/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.cache.SysDatabase;
import com.intersys.cache.metadata.ArrayIterator;
import com.intersys.cache.metadata.CacheForeignKeyMetadataImpl;
import com.intersys.cache.metadata.CacheIndexMetadataImpl;
import com.intersys.cache.metadata.CacheSerialStorageMetadataImpl;
import com.intersys.cache.metadata.Dictionary;
import com.intersys.cache.metadata.MethodHelper;
import com.intersys.cache.metadata.TableMetadataImpl;
import com.intersys.cache.metadata.VoidClass;
import com.intersys.classes.CPPStoredProc;
import com.intersys.classes.Compiler.LG.JavaClassDef;
import com.intersys.classes.Compiler.LG.JavaClassDefPointer;
import com.intersys.classes.Compiler.LG.JavaColumnDef;
import com.intersys.classes.Compiler.LG.JavaForeignKeyDef;
import com.intersys.classes.Compiler.LG.JavaIndexDef;
import com.intersys.classes.Compiler.LG.JavaMethodDef;
import com.intersys.classes.Compiler.LG.JavaMtdArgDef;
import com.intersys.classes.Compiler.LG.JavaPropDef;
import com.intersys.classes.Compiler.LG.MetaClassDef;
import com.intersys.classes.Compiler.LG.MetaMethodDef;
import com.intersys.classes.Compiler.LG.MetaQueryDef;
import com.intersys.objects.ByteArrayHolder;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheNullValueException;
import com.intersys.objects.Database;
import com.intersys.objects.InvalidMethodException;
import com.intersys.objects.ObjectHandleHolder;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheArgument;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassInfo;
import com.intersys.objects.reflect.CacheClassMetadata;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheForeignKeyInfo;
import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CacheMethod;
import com.intersys.objects.reflect.CacheQueryDefinition;
import com.intersys.objects.reflect.CacheSerialStorageMetadata;
import com.intersys.objects.reflect.CandidateKeyInfo;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.objects.reflect.TableMetadata;
import com.intersys.objects.reflect.TypeModifierHelper;
import com.intersys.objects.reflect.UniqueIndexMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

abstract class CacheClassMetadataImpl
implements CacheClass {
    private Dictionary mDict;
    private byte[] mSerializedState;
    private JavaClassDef mJavaClassDef;
    private String mName;
    private String mPackageName;
    private String mSQLTableName;
    private String mSchemaName;
    private int mRowIdJDBCCode;
    private String mParentClassName;
    private int mTypeId;
    private int mClassModifiers;
    private int mTypeModifier;
    private static final int HAS_DELETE_ID_METHOD = 1;
    private static final int HAS_EXISTS_ID_METHOD = 2;
    private static final int HAS_OPEN_ID_METHOD = 4;
    private static final int HAS_OPEN_METHOD = 8;
    protected static final int IS_CHILD = 16;
    private String mFlags = null;
    protected CacheClass[] mSupers;
    protected CacheField[] mDeclaredFields;
    protected CacheField[] mFields;
    protected CacheMethod[] mMethods;
    protected CacheQueryDefinition[] mQueryDefintiions;
    private CacheSerialStorageMetadataImpl mSerialStorage;
    private CacheField mParentField;
    private TableMetadata mSQLTableMetadata;
    private CacheIndexInfo[] mCacheIndexInfo;
    private CacheForeignKeyInfo[] mForeignKeyInfo;
    private String mJavaImplements;
    private String mIdPlaceholder;
    private boolean mIdPlaceHolderInit;
    private Boolean mEagerFetch;
    private Boolean mVersionControlEnabled = null;
    private String mVersionProperty = null;
    protected static CacheClass JGW_PROXY_CLASS = null;

    public CacheClassMetadataImpl(SysDatabase sysDatabase, String string, String string2, boolean bl, boolean bl2, boolean bl3) throws CacheException {
        ObjectHandleHolder objectHandleHolder = new ObjectHandleHolder(null);
        ByteArrayHolder byteArrayHolder = new ByteArrayHolder(null);
        if (bl3) {
            CPPStoredProc.getJavaClassDefByTable(sysDatabase, string, objectHandleHolder, true, true, string2, true, byteArrayHolder, false, bl2);
        } else {
            CPPStoredProc.getJavaClassDef(sysDatabase, string, objectHandleHolder, true, true, string2, true, byteArrayHolder, false, bl2);
        }
        byte[] byArray = byteArrayHolder.value;
        if (objectHandleHolder.value != null) {
            this.mJavaClassDef = (JavaClassDef)objectHandleHolder.value;
        } else if (byArray != null && byArray.length > 0) {
            this.mJavaClassDef = (JavaClassDef)JavaClassDef.open((Database)sysDatabase, byArray);
        } else {
            throw new CacheException("Failed to get metadata for class " + string);
        }
        if (bl) {
            this.mSerializedState = byArray;
        }
        this.mFlags = string2;
        if (this.mJavaClassDef == null) {
            throw new CacheException("Failed to get client class defintion for class " + string);
        }
        this.readSerialData(sysDatabase);
    }

    public CacheClassMetadataImpl(SysDatabase sysDatabase, String string, boolean bl, boolean bl2) throws CacheException {
        this(sysDatabase, string, "", false, bl, bl2);
    }

    public CacheClassMetadataImpl(JavaClassDef javaClassDef) throws CacheException {
        this.mJavaClassDef = javaClassDef;
        this.mName = this.mJavaClassDef.getClientClassDef().getname();
        this.readSerialData((SysDatabase)javaClassDef.getDatabase());
    }

    public CacheClassMetadataImpl(CacheClassMetadataImpl cacheClassMetadataImpl) throws CacheException {
        this.mJavaClassDef = cacheClassMetadataImpl.mJavaClassDef;
        this.mName = cacheClassMetadataImpl.getName();
        this.readSerialData(cacheClassMetadataImpl.getDatabase());
    }

    private void readSerialData(SysDatabase sysDatabase) throws CacheException {
        MetaClassDef metaClassDef = this.mJavaClassDef.getClientClassDef();
        int n = metaClassDef.getclassType();
        List list = metaClassDef.getdict();
        this.mDict = new Dictionary(list, sysDatabase);
        this.constructModifiers(metaClassDef);
        this.classifyClass(n, metaClassDef.getisAbstract());
        this.constructMembers(metaClassDef);
        this.mIdPlaceHolderInit = false;
    }

    private void constructMembers(MetaClassDef metaClassDef) throws CacheException {
        this.mName = metaClassDef.getname();
        this.mPackageName = metaClassDef.get_package();
        this.mParentClassName = this.mJavaClassDef.getparentClass();
        this.mRowIdJDBCCode = this.mJavaClassDef.getrowIdJDBCCode();
        this.mSchemaName = this.mJavaClassDef.getschemaName();
        this.mSerialStorage = new CacheSerialStorageMetadataImpl(this.mJavaClassDef);
        this.mSQLTableName = this.mJavaClassDef.gettableName();
        this.mTypeId = this.mJavaClassDef.gettypeId();
        this.mJavaImplements = null;
    }

    private void constructModifiers(MetaClassDef metaClassDef) throws CacheException {
        this.mClassModifiers = 0;
        if (metaClassDef.gethasDeleteId()) {
            this.mClassModifiers |= 1;
        }
        if (metaClassDef.gethasExistsId()) {
            this.mClassModifiers |= 2;
        }
        if (metaClassDef.gethasOpen()) {
            this.mClassModifiers |= 8;
        }
        if (metaClassDef.gethasOpenId()) {
            this.mClassModifiers |= 4;
        }
        try {
            if (this.mJavaClassDef.getisChild()) {
                this.mClassModifiers |= 0x10;
            }
        }
        catch (CacheNullValueException cacheNullValueException) {
            // empty catch block
        }
        this.mTypeModifier = 0;
    }

    public final int getModifiers() {
        return 0;
    }

    public final String getName() {
        return this.mName;
    }

    public final String getJavaClassName() throws CacheException {
        return this.mJavaClassDef.getjavaClassName();
    }

    public final String getJavaInterfaceName() throws CacheException {
        return this.mJavaClassDef.getjavaIClassName();
    }

    public final String getJavaPojoName() throws CacheException {
        return this.mJavaClassDef.getjavaPClassName();
    }

    public final String getJavaPackage() throws CacheException {
        return this.mJavaClassDef.getjavaPackage();
    }

    public final CacheClass getSuperclass() throws CacheException {
        this.checkSupers();
        String string = this.mJavaClassDef.getClientClassDef().get_super();
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.mSupers.length; ++i) {
            if (!this.mSupers[i].getName().equals(string)) continue;
            return this.mSupers[i];
        }
        throw new SystemError("Cache superclass " + string + " for class " + this.getName() + " was not found.");
    }

    public final CacheField[] getFields() throws CacheException {
        this.checkFields();
        CacheField[] cacheFieldArray = new CacheField[this.mFields.length];
        System.arraycopy(this.mFields, 0, cacheFieldArray, 0, this.mFields.length);
        return cacheFieldArray;
    }

    public final CacheField[] getDeclaredFields() throws CacheException {
        this.checkDeclaredFields();
        CacheField[] cacheFieldArray = new CacheField[this.mDeclaredFields.length];
        System.arraycopy(this.mDeclaredFields, 0, cacheFieldArray, 0, this.mDeclaredFields.length);
        return cacheFieldArray;
    }

    public CandidateKeyInfo[] getAvailableCandidateKeys() throws CacheException {
        if (this.mSQLTableName == null) {
            return new CandidateKeyInfo[0];
        }
        TableMetadata tableMetadata = this.getSQLTableMetadata();
        if (tableMetadata == null) {
            return new CandidateKeyInfo[0];
        }
        return tableMetadata.getUniqueIndicies();
    }

    public CandidateKeyInfo getBestCandidateKey() throws CacheException {
        UniqueIndexMetadata[] uniqueIndexMetadataArray;
        if (!this.isPersistent()) {
            return null;
        }
        TableMetadata tableMetadata = this.getSQLTableMetadata();
        if (tableMetadata == null) {
            return null;
        }
        CandidateKeyInfo candidateKeyInfo = tableMetadata.getPrimaryKey();
        if (candidateKeyInfo == null && (uniqueIndexMetadataArray = tableMetadata.getUniqueIndicies()).length > 0) {
            candidateKeyInfo = uniqueIndexMetadataArray[0];
        }
        return candidateKeyInfo;
    }

    public CandidateKeyInfo getKeyInfo(String string) throws CacheException {
        TableMetadata tableMetadata = this.getSQLTableMetadata();
        if (tableMetadata == null) {
            throw new CacheException("No key with name " + string + " available in class " + this.getName());
        }
        return tableMetadata.getCandidateKey(string);
    }

    public final CacheMethod[] getMethods() throws CacheException {
        this.checkMethods();
        CacheMethod[] cacheMethodArray = new CacheMethod[this.mMethods.length];
        System.arraycopy(this.mMethods, 0, cacheMethodArray, 0, this.mMethods.length);
        return cacheMethodArray;
    }

    public final CacheField getField(String string) throws CacheException {
        if (string == null) {
            throw new NullPointerException("Field name can not be null. Class " + this.getName());
        }
        this.checkFields();
        int n = Arrays.binarySearch(this.mFields, string);
        if (n >= 0) {
            return this.mFields[n];
        }
        return null;
    }

    protected CacheField validateFieldFromSuper(CacheField cacheField) throws CacheException {
        return cacheField;
    }

    public final CacheMethod getMethod(String string) throws CacheException {
        this.checkMethods();
        int n = Arrays.binarySearch(this.mMethods, string);
        if (n >= 0) {
            return this.mMethods[n];
        }
        if (n < 0 && (n = -n - 1) < this.mMethods.length && this.mMethods[n].getName().equals(string)) {
            return this.mMethods[n];
        }
        this.checkSupers();
        for (int i = 0; i < this.mSupers.length; ++i) {
            CacheMethod cacheMethod = this.mSupers[i].getMethod(string);
            if (cacheMethod == null) continue;
            return cacheMethod;
        }
        return null;
    }

    public final CacheMethod getMethod(String string, CacheClassInfo[] cacheClassInfoArray) throws CacheException {
        String string2 = cacheClassInfoArray != null ? MethodHelper.constructSignature(string, Arrays.asList(cacheClassInfoArray).iterator(), false) : string;
        CacheMethod cacheMethod = this.getMethod(string2);
        if (cacheMethod != null) {
            return cacheMethod;
        }
        CacheMethod[] cacheMethodArray = this.getMethods();
        String string3 = "";
        for (int i = 0; i < cacheMethodArray.length; ++i) {
            if (!cacheMethodArray[i].getName().equals(string)) continue;
            string3 = string3 + cacheMethodArray[i] + "\n";
        }
        if (string3.length() == 0) {
            string3 = "No method with name " + string + " in class " + this.getName();
        } else {
            String string4 = string + "(";
            if (cacheClassInfoArray != null) {
                for (int i = 0; i < cacheClassInfoArray.length; ++i) {
                    string4 = string4 + cacheClassInfoArray[i].getName();
                    if (i >= cacheClassInfoArray.length - 1) continue;
                    string4 = string4 + ",";
                }
            }
            string4 = string4 + ")";
            string3 = "Method " + string4 + " not found in class " + this.getName() + " Possible variants are: \n" + string3;
        }
        throw new InvalidMethodException(this.getDatabase(), this.getName(), string, string3);
    }

    public byte[] serialize() throws CacheException {
        int[] nArray = new int[1];
        if (this.mSerializedState == null) {
            this.mSerializedState = this.mJavaClassDef.serialize(new byte[0], nArray);
            if (nArray[0] <= 0) {
                throw new SystemError("Serialization of class metadata for " + this.getName() + " failed.");
            }
            if (this.mSerializedState.length != nArray[0]) {
                byte[] byArray = new byte[nArray[0]];
                System.arraycopy(this.mSerializedState, 0, byArray, 0, nArray[0]);
                this.mSerializedState = byArray;
            }
        }
        return this.mSerializedState;
    }

    public final CacheQueryDefinition getQuery(String string) throws CacheException {
        this.checkQueryDefs();
        int n = Arrays.binarySearch(this.mQueryDefintiions, string);
        if (n >= 0) {
            return this.mQueryDefintiions[n];
        }
        this.checkSupers();
        for (int i = 0; i < this.mSupers.length; ++i) {
            CacheQueryDefinition cacheQueryDefinition = this.mSupers[i].getQuery(string);
            if (cacheQueryDefinition == null) continue;
            return cacheQueryDefinition;
        }
        return null;
    }

    public final CacheQueryDefinition[] getQueries() throws CacheException {
        this.checkQueryDefs();
        CacheQueryDefinition[] cacheQueryDefinitionArray = new CacheQueryDefinition[this.mQueryDefintiions.length];
        System.arraycopy(this.mQueryDefintiions, 0, cacheQueryDefinitionArray, 0, this.mQueryDefintiions.length);
        return cacheQueryDefinitionArray;
    }

    public final Iterator getFieldNames() throws CacheException {
        this.checkFields();
        return new ArrayIterator.FieldNameIterator(this.mFields);
    }

    public final Iterator getMethodSignatures() throws CacheException {
        this.checkMethods();
        return new ArrayIterator.MethodSignatureIterator(this.mMethods);
    }

    public final CacheClass[] getCacheSuperclasses() throws CacheException {
        this.checkSupers();
        CacheClass[] cacheClassArray = new CacheClass[this.mSupers.length];
        System.arraycopy(this.mSupers, 0, cacheClassArray, 0, this.mSupers.length);
        return cacheClassArray;
    }

    public boolean isAssignableFrom(CacheClassInfo cacheClassInfo) throws CacheException {
        if (this.equals(cacheClassInfo)) {
            return true;
        }
        CacheClass[] cacheClassArray = cacheClassInfo.getCacheSuperclasses();
        for (int i = 0; i < cacheClassArray.length; ++i) {
            if (!this.isAssignableFrom(cacheClassArray[i])) continue;
            return true;
        }
        return false;
    }

    protected final void checkSupers() throws CacheException {
        if (this.mSupers != null) {
            return;
        }
        List list = this.mJavaClassDef.getsupers();
        this.mSupers = new CacheClass[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JavaClassDefPointer javaClassDefPointer = (JavaClassDefPointer)iterator.next();
            JavaClassDef javaClassDef = (JavaClassDef)javaClassDefPointer.getJavaClassDef();
            this.mSupers[n] = javaClassDef != null ? this.getAClass(javaClassDef) : this.getAClass(this.lookupName(javaClassDefPointer.getName()));
            ++n;
        }
    }

    protected final void checkMethods() throws CacheException {
        Object object;
        Object object222;
        if (this.mMethods != null) {
            return;
        }
        ArrayList<MethodPair> arrayList = new ArrayList<MethodPair>();
        ArrayList<CacheClassMetadataImpl> arrayList2 = new ArrayList<CacheClassMetadataImpl>();
        HashSet<String> hashSet = new HashSet<String>();
        List list = this.mJavaClassDef.getmethods();
        for (Object object222 : list) {
            hashSet.add(((MetaMethodDef)object222).getmethodName());
        }
        object222 = this;
        while ((object = (CacheClassMetadataImpl)((CacheClassMetadataImpl)object222).getSuperclass()) != null) {
            arrayList2.add((CacheClassMetadataImpl)object);
            object222 = object;
        }
        for (CacheClassMetadataImpl iterator2 : arrayList2) {
            List list2 = iterator2.mJavaClassDef.getmethods();
            for (Object object2 : list2) {
                if (!((MetaMethodDef)object2).getisClassMtd() || hashSet.contains(((MetaMethodDef)object2).getmethodName())) continue;
                hashSet.add(((MetaMethodDef)object2).getmethodName());
                arrayList.add(new MethodPair(iterator2, (JavaMethodDef)object2));
            }
        }
        this.mMethods = new CacheMethod[list.size() + arrayList.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JavaMethodDef javaMethodDef = (JavaMethodDef)iterator.next();
            this.mMethods[n] = this.createMethod(this, javaMethodDef);
            ++n;
        }
        Iterator iterator2 = arrayList.iterator();
        int n2 = n;
        while (iterator2.hasNext()) {
            Object object2;
            object2 = (MethodPair)iterator2.next();
            if (!((MethodPair)object2).jmd.getisClassMtd()) continue;
            this.mMethods[n2++] = ((MethodPair)object2).cls.createMethod(this, ((MethodPair)object2).jmd);
        }
        Arrays.sort(this.mMethods);
    }

    protected final void checkFields() throws CacheException {
        if (this.mFields != null) {
            return;
        }
        this.checkDeclaredFields();
        ArrayList<CacheField> arrayList = new ArrayList<CacheField>(Arrays.asList(this.mDeclaredFields));
        HashSet<String> hashSet = new HashSet<String>();
        for (CacheField cacheFieldArray : arrayList) {
            hashSet.add(cacheFieldArray.getName());
        }
        this.checkSupers();
        for (int i = 0; i < this.mSupers.length; ++i) {
            CacheField[] cacheFieldArray = this.mSupers[i].getFields();
            if (cacheFieldArray == null) continue;
            for (int j = 0; j < cacheFieldArray.length; ++j) {
                CacheField cacheField = this.validateFieldFromSuper(cacheFieldArray[j]);
                if (hashSet.contains(cacheField.getName())) continue;
                arrayList.add(cacheField);
                hashSet.add(cacheField.getName());
            }
        }
        this.mFields = new CacheField[arrayList.size()];
        this.mFields = arrayList.toArray(this.mFields);
        Arrays.sort(this.mFields);
    }

    protected final void checkDeclaredFields() throws CacheException {
        if (this.mDeclaredFields != null) {
            return;
        }
        List list = this.mJavaClassDef.getproperties();
        this.mDeclaredFields = new CacheField[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JavaPropDef javaPropDef = (JavaPropDef)iterator.next();
            this.mDeclaredFields[n] = this.createField(javaPropDef);
            ++n;
        }
        Arrays.sort(this.mDeclaredFields);
    }

    protected final void checkQueryDefs() throws CacheException {
        if (this.mQueryDefintiions != null) {
            return;
        }
        List list = this.mJavaClassDef.getClientClassDef().getqueries();
        this.mQueryDefintiions = new CacheQueryDefinition[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            MetaQueryDef metaQueryDef = (MetaQueryDef)iterator.next();
            this.mQueryDefintiions[n] = this.createQueryDef(metaQueryDef);
            ++n;
        }
        Arrays.sort(this.mQueryDefintiions);
    }

    protected final SQLColumn[] checkColumns() throws CacheException {
        List list = this.mJavaClassDef.getcolumns();
        Object[] objectArray = new SQLColumn[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JavaColumnDef javaColumnDef = (JavaColumnDef)iterator.next();
            objectArray[n] = this.createColumn(javaColumnDef);
            ++n;
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CacheClassMetadataImpl)) {
            return false;
        }
        CacheClassMetadataImpl cacheClassMetadataImpl = (CacheClassMetadataImpl)object;
        return this.mName.equals(cacheClassMetadataImpl.getName());
    }

    public String toString() {
        return this.getName();
    }

    protected String getShortName() {
        int n = this.mName.lastIndexOf(46);
        if (n < 0) {
            return this.mName;
        }
        return this.mName.substring(n + 1);
    }

    protected final CacheClass getAClass(JavaClassDefPointer javaClassDefPointer) throws CacheException {
        if (javaClassDefPointer == null) {
            return VoidClass.CLASS;
        }
        JavaClassDef javaClassDef = (JavaClassDef)javaClassDefPointer.getJavaClassDef();
        if (javaClassDef != null) {
            return this.getAClass(javaClassDef);
        }
        return this.getAClass(this.lookupName(javaClassDefPointer.getName()));
    }

    protected final CacheClass getAClass(JavaClassDef javaClassDef) throws CacheException {
        if (javaClassDef == null) {
            return VoidClass.CLASS;
        }
        String string = javaClassDef.getClientClassDef().getname();
        CacheClass cacheClass = this.getDatabase().getCacheClassIfLoaded(string);
        if (cacheClass != null) {
            return cacheClass;
        }
        cacheClass = this.createClass(javaClassDef);
        return cacheClass;
    }

    protected final CacheClass getAClass(String string) throws CacheException {
        if (string == null || string.length() == 0) {
            return VoidClass.CLASS;
        }
        CacheClass cacheClass = this.getDatabase().getCacheClassIfLoaded(string);
        if (cacheClass != null) {
            return cacheClass;
        }
        cacheClass = this.createClass(string);
        return cacheClass;
    }

    public Class getJavaClass() throws CacheException {
        try {
            return Class.forName(this.getJavaClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CacheException(classNotFoundException, "Java class " + this.getJavaClassName() + " for Cache class " + this.getName() + " was not found");
        }
    }

    protected void forceLazyInitializers() throws CacheException {
        this.checkMethods();
        this.checkQueryDefs();
    }

    protected final boolean isVersionControlEnabled() throws CacheException {
        if (this.mVersionControlEnabled == null) {
            this.mVersionControlEnabled = new Boolean(this.mJavaClassDef.getVersionChecking());
        }
        return this.mVersionControlEnabled;
    }

    public final String getVersionPropertyName() throws CacheException {
        if (this.mVersionProperty != null) {
            return this.mVersionProperty;
        }
        if (!this.isVersionControlEnabled()) {
            return null;
        }
        this.mVersionProperty = this.mJavaClassDef.getVersionProperty();
        if (this.mVersionProperty == null) {
            this.mVersionProperty = "%Version";
        }
        return this.mVersionProperty;
    }

    public final int getClassTypeId() {
        return this.mTypeId;
    }

    public final boolean hasDeleteIdMethod() {
        return (this.mClassModifiers & 1) != 0;
    }

    public final boolean hasExistsIdMethod() {
        return (this.mClassModifiers & 2) != 0;
    }

    public final boolean hasOpenIdMethod() {
        return (this.mClassModifiers & 4) != 0;
    }

    public final boolean hasOpenMethod() {
        return (this.mClassModifiers & 8) != 0;
    }

    public final boolean isChild() {
        return (this.mClassModifiers & 0x10) != 0;
    }

    public final String getParentClassName() {
        return this.mParentClassName;
    }

    public final CacheField getParentField() throws CacheException {
        if (!this.isChild()) {
            throw new CacheException("Class " + this.getName() + " is not a child in parent-child relationship.");
        }
        if (this.mParentField == null) {
            String string = this.mJavaClassDef.getparent();
            this.mParentField = this.getField(string);
        }
        return this.mParentField;
    }

    public final TableMetadata getSQLTableMetadata() throws CacheException {
        if (this.mSQLTableMetadata == null) {
            this.mSQLTableMetadata = new TableMetadataImpl(this, this.mJavaClassDef);
            try {
                ((TableMetadataImpl)this.mSQLTableMetadata).init();
            }
            catch (CacheException cacheException) {
                this.mSQLTableMetadata = null;
                throw cacheException;
            }
        }
        return this.mSQLTableMetadata;
    }

    protected void setSQLTableMetadata(TableMetadata tableMetadata) {
        this.mSQLTableMetadata = tableMetadata;
        this.mSQLTableName = tableMetadata.getName();
    }

    public boolean isMappedToTable() {
        return this.mSQLTableName != null;
    }

    public final CacheSerialStorageMetadata getSerialStateInfo() {
        return this.mSerialStorage;
    }

    public final String getFullSQLTableName() {
        return this.mSchemaName + '.' + this.mSQLTableName;
    }

    public final String getSQLTableName() {
        return this.mSQLTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdPlaceholder() {
        if (!this.mIdPlaceHolderInit) {
            try {
                CacheClass cacheClass;
                this.mIdPlaceholder = this.mJavaClassDef.getIdPlaceholder();
                if (this.mIdPlaceholder == null && (cacheClass = this.getSuperclass()) != null) {
                    this.mIdPlaceholder = cacheClass.getIdPlaceholder();
                }
            }
            catch (CacheException cacheException) {
                this.mIdPlaceholder = null;
            }
            finally {
                this.mIdPlaceHolderInit = true;
            }
        }
        return this.mIdPlaceholder;
    }

    public boolean eagerFetchRequiredForPOJO() throws CacheException {
        if (this.mEagerFetch == null) {
            boolean bl;
            try {
                bl = this.mJavaClassDef.getEagerFetchRequired();
            }
            catch (CacheNullValueException cacheNullValueException) {
                bl = true;
            }
            this.mEagerFetch = new Boolean(bl);
        }
        return this.mEagerFetch;
    }

    public final String getPackageName() {
        return this.mPackageName;
    }

    protected void classifyClass(int n, boolean bl) throws CacheException {
        if (n == 1) {
            this.addTypeModifier(4608);
        } else if (n == 2) {
            this.addTypeModifier(8704);
        } else if (n == 3) {
            this.addTypeModifier(256);
        }
        if (bl) {
            this.addTypeModifier(2048);
        }
    }

    public final void addTypeModifier(int n) {
        this.mTypeModifier |= n;
    }

    protected final void addClassModifier(int n) {
        this.mClassModifiers |= n;
    }

    public final boolean isPersistent() {
        return TypeModifierHelper.isPersistent(this.mTypeModifier);
    }

    public final boolean isSerial() {
        return TypeModifierHelper.isSerial(this.mTypeModifier);
    }

    public final boolean isDatatype() {
        return TypeModifierHelper.isDatatype(this.mTypeModifier);
    }

    public final boolean isAbstract() {
        return (this.mTypeModifier & 0x800) != 0;
    }

    public final boolean isCollection() {
        return TypeModifierHelper.isCollection(this.mTypeModifier);
    }

    public final String getSchemaName() {
        return this.mSchemaName;
    }

    public final int getRowIdJDBCCode() {
        return this.mRowIdJDBCCode;
    }

    public String getJavaImplements() throws CacheException {
        if (this.mJavaImplements == null) {
            this.mJavaImplements = this.mJavaClassDef.getJavaImplements();
        }
        return this.mJavaImplements;
    }

    protected abstract SysDatabase getDatabase();

    protected abstract CacheClass createClass(JavaClassDef var1) throws CacheException;

    protected abstract CacheClass createClass(String var1) throws CacheException;

    protected abstract CacheField createField(JavaPropDef var1) throws CacheException;

    protected abstract CacheMethod createMethod(CacheClassMetadata var1, JavaMethodDef var2) throws CacheException;

    protected abstract CacheArgument createArgument(JavaMtdArgDef var1) throws CacheException;

    protected abstract CacheQueryDefinition createQueryDef(MetaQueryDef var1) throws CacheException;

    protected abstract SQLColumn createColumn(JavaColumnDef var1) throws CacheException;

    protected String getFlags() {
        return this.mFlags;
    }

    public boolean isExternallyMapped() throws CacheException {
        SysDatabase sysDatabase = this.getDatabase();
        if (!sysDatabase.hasObjectMapper()) {
            return false;
        }
        if (JGW_PROXY_CLASS == null) {
            JGW_PROXY_CLASS = sysDatabase.getCacheClass("EnsLib.JavaGateway.JavaGatewayProxy");
        }
        boolean bl = JGW_PROXY_CLASS.isAssignableFrom(this);
        return bl;
    }

    public String lookupName(Integer n) {
        return this.mDict.lookup(n);
    }

    public Dictionary getDictionary() {
        return this.mDict;
    }

    public CacheIndexInfo[] getIndexInfo() throws CacheException {
        if (this.mCacheIndexInfo == null) {
            if (this.serverSupportsIndices()) {
                List list = this.mJavaClassDef.getindices();
                this.mCacheIndexInfo = new CacheIndexInfo[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    this.mCacheIndexInfo[i] = new CacheIndexMetadataImpl(this, (JavaIndexDef)list.get(i));
                }
            } else {
                this.mCacheIndexInfo = this.getAvailableCandidateKeys();
            }
        }
        return this.mCacheIndexInfo;
    }

    public CacheForeignKeyInfo[] getForeignKeyInfo() throws CacheException {
        if (this.mForeignKeyInfo == null) {
            List list = this.mJavaClassDef.getforeignKeys();
            this.mForeignKeyInfo = new CacheForeignKeyInfo[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.mForeignKeyInfo[i] = new CacheForeignKeyMetadataImpl(this.mJavaClassDef, (JavaForeignKeyDef)list.get(i));
            }
        }
        return this.mForeignKeyInfo;
    }

    public boolean serverSupportsIndices() {
        try {
            return this.getDatabase().getReflectionVersion() > 10;
        }
        catch (CacheException cacheException) {
            return false;
        }
    }

    private static class MethodPair {
        public CacheClassMetadataImpl cls;
        public JavaMethodDef jmd;

        public MethodPair(CacheClassMetadataImpl cacheClassMetadataImpl, JavaMethodDef javaMethodDef) {
            this.cls = cacheClassMetadataImpl;
            this.jmd = javaMethodDef;
        }
    }
}

