/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.StreamAccessHelper;
import com.intersys.cache.metadata.AbstractCacheField;
import com.intersys.cache.quick.ChidTableClass;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.Mappings;
import com.intersys.cache.quick.QuickCacheClassNew;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.QuickCollectionObject;
import com.intersys.cache.quick.QuickReaderObject;
import com.intersys.cache.quick.QuickStreamObject;
import com.intersys.classes.Compiler.LG.JavaPropDef;
import com.intersys.classes.ObjectHandle;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheOutputStream;
import com.intersys.objects.CacheWriter;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheModifier;
import com.intersys.objects.reflect.CacheSerialStorageMetadata;
import com.intersys.objects.reflect.SQLColumn;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.Date;

abstract class QuickCacheField
extends AbstractCacheField
implements Mappings,
ColumnBasedField {
    private int mColumnIdxForGet = -1;
    protected int mColumnIdxForSet = -1;
    private int mSerialStorageIdx = -1;
    protected LightDatabase mDB;
    private Boolean mEmbedded = null;

    QuickCacheField(QuickCacheClassNew quickCacheClassNew, JavaPropDef javaPropDef, boolean bl) throws CacheException {
        super((CacheClass)quickCacheClassNew, javaPropDef);
        this.mDB = (LightDatabase)quickCacheClassNew.getDatabase();
        this.init(bl);
    }

    private void init(boolean bl) {
        if (bl) {
            this.initEmbedded();
        } else {
            this.initNormal();
        }
        this.checkColumnIndices();
    }

    private void checkColumnIndices() {
        if (!this.isMappedToTable()) {
            return;
        }
        SQLColumn sQLColumn = this.getSQLColumn();
        if (sQLColumn != null) {
            CacheClass cacheClass = this.getDeclaringCacheClass();
            if (cacheClass instanceof ChidTableClass) {
                if (((ChidTableClass)cacheClass).isArray()) {
                    this.mColumnIdxForGet = sQLColumn.getNumber() - 1;
                    this.mColumnIdxForSet = sQLColumn.getNumber();
                } else if (((ChidTableClass)cacheClass).isList()) {
                    this.mColumnIdxForGet = sQLColumn.getNumber() - 2;
                    this.mColumnIdxForSet = sQLColumn.getNumber();
                }
            } else if (cacheClass.isChild()) {
                this.mColumnIdxForGet = sQLColumn.getNumber() + 1;
                this.mColumnIdxForSet = sQLColumn.getNumber();
            } else {
                this.mColumnIdxForGet = sQLColumn.getNumber();
                this.mColumnIdxForSet = sQLColumn.getNumber() - 1;
            }
        }
    }

    private void initNormal() {
    }

    private void initEmbedded() {
        String string;
        QuickCacheClassNew quickCacheClassNew = (QuickCacheClassNew)this.getDeclaringCacheClass();
        CacheSerialStorageMetadata.SerialStorageElement serialStorageElement = quickCacheClassNew.getSerialElementByName(string = this.getName());
        if (serialStorageElement == null) {
            return;
        }
        this.mSerialStorageIdx = serialStorageElement.getIndex();
    }

    public CacheField cloneForColumn(SQLColumn sQLColumn, QuickCacheClassNew quickCacheClassNew) throws CacheException {
        QuickCacheField quickCacheField = (QuickCacheField)super.cloneForColumn(sQLColumn, quickCacheClassNew);
        quickCacheField.mColumnIdxForGet = -1;
        quickCacheField.mColumnIdxForSet = -1;
        return quickCacheField;
    }

    protected CacheField cloneForSerialElement(CacheSerialStorageMetadata.SerialStorageElement serialStorageElement, QuickCacheClassNew quickCacheClassNew) throws CacheException {
        QuickCacheField quickCacheField = (QuickCacheField)this.cloneFor(quickCacheClassNew);
        quickCacheField.mSerialStorageIdx = serialStorageElement.getIndex();
        return quickCacheField;
    }

    protected CacheField cloneForChildTable(QuickCacheClassNew quickCacheClassNew, int n) throws CacheException {
        QuickCacheField quickCacheField = (QuickCacheField)this.cloneFor(quickCacheClassNew);
        quickCacheField.mColumnIdxForSet = n;
        return quickCacheField;
    }

    public int getColumnIndexForGet() throws CacheException {
        if (this.mColumnIdxForGet < 0 && this.isMappedToTable()) {
            this.checkColumnIndices();
        }
        return this.mColumnIdxForGet;
    }

    public final int getColumnIndexForSet() throws CacheException {
        if (this.mColumnIdxForSet < 0 && this.isMappedToTable()) {
            this.checkColumnIndices();
        }
        if (this.mColumnIdxForSet < 0 && this.isCalculated() && !this.isSQLComputed()) {
            throw new CacheException("Calculated property must be also SQLComputed to be usable from Light Java Binding. Property: " + this.getName() + " of class " + this.getDeclaringCacheClass().getName());
        }
        return this.mColumnIdxForSet;
    }

    public final int getSerialStorageIndex() {
        return this.mSerialStorageIdx - 1;
    }

    public final boolean isEmbedded() {
        if (this.mEmbedded == null) {
            this.mEmbedded = this.isCollection() ? new Boolean(false) : (this.getSQLColumn() == null ? new Boolean(false) : new Boolean(this.getSQLColumn().isForEmbeddedObject()));
        }
        return this.mEmbedded;
    }

    public final Object get(int n) throws CacheException {
        throw new CacheException("Not supported in this implementation.");
    }

    public final Object get(Object object) throws CacheException {
        if (this.isTransient() && !this.isCollection()) {
            return null;
        }
        if (!(object instanceof ObjectHandle)) {
            throw new CacheException("Can not get field value on object of type " + object.getClass().getName());
        }
        CacheObject cacheObject = ((ObjectHandle)object).getProxy();
        boolean bl = CacheModifier.isLiteral(this.getModifiers());
        int n = bl ? 0 : 1;
        Dataholder dataholder = cacheObject.getProperty(this.getII(), this.getJJ(), n, this.mName);
        if (bl) {
            return dataholder.getObject(this.getJavaTypeDHType());
        }
        CacheObject cacheObject2 = dataholder.getCacheObject();
        if (cacheObject2 == null) {
            return null;
        }
        return cacheObject2.newJavaInstance(true);
    }

    public final void set(int n, Object object) throws CacheException {
        throw new CacheException("Not supported in this implementation.");
    }

    public final void set(Object object, Object object2) throws CacheException {
        int n;
        if (this.isTransient() && !this.isCollection()) {
            return;
        }
        Dataholder dataholder = null;
        if (!(object instanceof ObjectHandle)) {
            throw new CacheException("Can not set field value on object of type " + object.getClass().getName());
        }
        CacheObject cacheObject = ((ObjectHandle)object).getProxy();
        int n2 = n = CacheModifier.isLiteral(this.getModifiers()) ? 0 : 1;
        if (n == 1 && object2 instanceof ObjectHandle) {
            ObjectHandle objectHandle = (ObjectHandle)object2;
            dataholder = new Dataholder(1026, objectHandle.getProxy());
        } else if (Date.class.getName().endsWith(this.mJavaTypeName)) {
            dataholder = Dataholder.create(object2);
            dataholder = new Dataholder(64, dataholder.getDate());
        } else {
            if (this.isStream()) {
                StreamAccessHelper.setStreamValue(this, object2, cacheObject);
                return;
            }
            if (this.isCollection() && !(object2 instanceof QuickCacheObject)) {
                this.setCollection(cacheObject, object2);
                return;
            }
            dataholder = Dataholder.create(object2);
        }
        cacheObject.setProperty(this.getII(), this.getJJ(), this.getKK(), n, this.mName, dataholder);
    }

    public Writer getWriter(CacheObject cacheObject) throws CacheException {
        Dataholder dataholder = cacheObject.getProperty(this.getII(), this.getJJ(), 1, this.getName());
        QuickReaderObject quickReaderObject = (QuickReaderObject)dataholder.getCacheObject();
        CacheWriter cacheWriter = quickReaderObject.getOut();
        return cacheWriter;
    }

    public OutputStream getBStream(CacheObject cacheObject) throws CacheException {
        Dataholder dataholder = cacheObject.getProperty(this.getII(), this.getJJ(), 1, this.getName());
        QuickStreamObject quickStreamObject = (QuickStreamObject)dataholder.getCacheObject();
        CacheOutputStream cacheOutputStream = quickStreamObject.getOut();
        return cacheOutputStream;
    }

    private void setCollection(CacheObject cacheObject, Object object) throws CacheException {
        Dataholder dataholder = cacheObject.getProperty(this.getII(), this.getJJ(), 1, this.mName);
        QuickCollectionObject quickCollectionObject = (QuickCollectionObject)dataholder.getCacheObject();
        quickCollectionObject.setCollection(object);
    }
}

