/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.Mappings;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.QuickCollectionObject;
import com.intersys.cache.quick.QuickDatabase;
import com.intersys.cache.quick.QuickEmbeddedObject;
import com.intersys.cache.quick.QuickReaderObject;
import com.intersys.cache.quick.QuickRelationshipObject;
import com.intersys.cache.quick.QuickStreamObject;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.TypeModifierHelper;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class SerialStorage
implements Mappings {
    private TableBasedClass mClass;
    private Object mFieldValues;
    private Dataholder[] mCachedValues;

    public SerialStorage(SysDatabase sysDatabase, String string, Object object) throws CacheException {
        string = this.init(string, object);
        this.mClass = (TableBasedClass)sysDatabase.getCacheClass(string);
        if (!this.mClass.hasSerialStorage()) {
            throw new CacheException("No serial storage information  available for class " + string);
        }
    }

    public SerialStorage(TableBasedClass tableBasedClass, Object object) throws CacheException {
        SysDatabase sysDatabase = tableBasedClass.getDatabase();
        String string = this.init(tableBasedClass.getName(), object);
        this.mClass = tableBasedClass.getName().equals(string) ? tableBasedClass : (TableBasedClass)sysDatabase.getCacheClass(string);
        if (!this.mClass.hasSerialStorage()) {
            throw new CacheException("No serial storage information  available for class " + string);
        }
    }

    private String init(String string, Object object) throws CacheException {
        if (object != null && !SysListProxy.atEnd(object)) {
            try {
                String string2;
                this.mFieldValues = SysListProxy.getSysList(object);
                if (!SysListProxy.atEnd(object) && (string2 = SysListProxy.getString(object)) != null) {
                    string = string2;
                }
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, "Failed to get serial state: " + object);
            }
        }
        return string;
    }

    protected Dataholder getProperty(ColumnBasedField columnBasedField) throws CacheException {
        Dataholder dataholder;
        int n = columnBasedField.getSerialStorageIndex();
        if (n < 0) {
            throw new CacheException("No serial storage information  available for class " + this.mClass.getName() + ", property " + columnBasedField.getName());
        }
        if (this.mCachedValues != null && (dataholder = this.mCachedValues[n]) != null && dataholder != QuickCacheObject.UNCHANGED) {
            return dataholder;
        }
        if (this.mCachedValues == null) {
            this.mCachedValues = new Dataholder[this.mClass.getNumberOfSerialElements()];
        }
        if (this.mFieldValues == null) {
            dataholder = null;
            if (columnBasedField.getCollectionType() != 0) {
                dataholder = SerialStorage.newCollection(columnBasedField);
            } else if (columnBasedField.isSerial()) {
                TableBasedClass tableBasedClass = (TableBasedClass)columnBasedField.getType();
                dataholder = SerialStorage.getSerialObject(null, tableBasedClass);
            } else {
                dataholder = new Dataholder();
            }
            this.mCachedValues[n] = dataholder;
            return dataholder;
        }
        try {
            Object object = SysListProxy.getWrappedItem(this.mFieldValues, n);
            if (columnBasedField.getCollectionType() != 0) {
                dataholder = this.getCollection(columnBasedField, object);
            } else if (columnBasedField.isSerial()) {
                TableBasedClass tableBasedClass = (TableBasedClass)columnBasedField.getType();
                dataholder = SerialStorage.getSerialObject(object, tableBasedClass);
            } else {
                dataholder = new Dataholder(4096, object);
            }
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to get property " + columnBasedField.getName());
        }
        this.mCachedValues[n] = dataholder;
        return dataholder;
    }

    protected void setProperty(ColumnBasedField columnBasedField, Dataholder dataholder) throws CacheException {
        int n = columnBasedField.getSerialStorageIndex();
        if (columnBasedField.isTransient()) {
            return;
        }
        if (n < 0) {
            throw new CacheException("No serial storage information  available for class " + this.mClass.getName() + ", property " + columnBasedField.getName());
        }
        if (this.mCachedValues == null) {
            this.mCachedValues = new Dataholder[this.mClass.getNumberOfSerialElements()];
        }
        this.mCachedValues[n] = dataholder;
    }

    protected Object serialize(Object object) throws CacheException {
        Iterator iterator;
        if (object == null) {
            object = this.createSysList();
        }
        Object object2 = this.createSysList();
        int n = 0;
        if (this.mCachedValues == null) {
            if (this.mFieldValues != null) {
                object2 = this.mFieldValues;
            } else {
                iterator = this.mClass.getAllSettableFieldsIterator();
                while (iterator.hasNext()) {
                    try {
                        SysListProxy.setString(object2, null);
                    }
                    catch (SQLException sQLException) {
                        throw new CacheException(sQLException);
                    }
                    ++n;
                    iterator.next();
                }
            }
        } else {
            iterator = this.mClass.getAllSettableFieldsIterator();
            while (iterator.hasNext()) {
                ColumnBasedField columnBasedField = (ColumnBasedField)iterator.next();
                if (columnBasedField == null || this.mCachedValues[n] == null) {
                    try {
                        SysListProxy.setString(object2, null);
                    }
                    catch (SQLException sQLException) {
                        throw new CacheException(sQLException);
                    }
                } else {
                    Object object3;
                    if (n != columnBasedField.getSerialStorageIndex()) {
                        throw new SystemError("Expected column " + n + ", instead got " + columnBasedField.getSerialStorageIndex());
                    }
                    if (columnBasedField.getCollectionType() != 0) {
                        object3 = this.getDatabase();
                        int n2 = columnBasedField.getElementType();
                        Object object4 = this.mCachedValues[n].getCollection();
                        Object object5 = SerialStorage.serializeCollection((QuickDatabase)object3, columnBasedField.getCollectionType(), object4, n2);
                        try {
                            SysListProxy.setSysList(object2, object5);
                        }
                        catch (SQLException sQLException) {
                            throw new CacheException(sQLException);
                        }
                    } else if (columnBasedField.isSerial()) {
                        object3 = this.mCachedValues[n].getCacheObject().getSerialState(null);
                        try {
                            Object object6 = SysListProxy.getSysList(object3, 0);
                            SysListProxy.setSysList(object2, object6);
                        }
                        catch (SQLException sQLException) {
                            throw new CacheException(sQLException);
                        }
                    } else {
                        this.mCachedValues[n].stuff(object2);
                    }
                }
                ++n;
            }
        }
        try {
            SysListProxy.setSysList(object, object2);
            SysListProxy.setString(object, this.mClass.getName());
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to set values for object of class " + this.mClass.getName());
        }
        return object;
    }

    protected final Object createSysList() {
        return this.getDatabase().createSysList();
    }

    private final QuickDatabase getDatabase() {
        return (QuickDatabase)this.mClass.getDatabase();
    }

    protected TableBasedClass getCacheClass() {
        return this.mClass;
    }

    private Dataholder getCollection(ColumnBasedField columnBasedField, Object object) throws CacheException, SQLException {
        Object object2;
        int n = columnBasedField.getCollectionType();
        QuickDatabase quickDatabase = this.getDatabase();
        int n2 = columnBasedField.getElementType();
        String string = columnBasedField.getElementTypeName();
        int n3 = -1;
        if (n2 == 256 && string != null && !string.endsWith("String")) {
            object2 = quickDatabase.getCacheClass(string).getJavaClassName();
            n3 = Dataholder.toIntType((String)object2);
        }
        if (columnBasedField.isList()) {
            object2 = SerialStorage.getSerialList(null, quickDatabase, string, n2, object, n3);
        } else if (n == 1) {
            object2 = SerialStorage.getSerialArray(null, quickDatabase, string, n2, object, n3);
        } else {
            throw new CacheException("Unsupported collection type: " + n);
        }
        TableBasedClass tableBasedClass = (TableBasedClass)columnBasedField.getType();
        QuickCollectionObject quickCollectionObject = new QuickCollectionObject(tableBasedClass, object2);
        return new Dataholder(quickCollectionObject);
    }

    protected static Dataholder newCollection(ColumnBasedField columnBasedField) throws CacheException {
        int n = columnBasedField.getCollectionType();
        QuickCacheObject quickCacheObject = null;
        TableBasedClass tableBasedClass = (TableBasedClass)columnBasedField.getType();
        if (n == 8) {
            quickCacheObject = new QuickCollectionObject(tableBasedClass, new ArrayList());
        } else if (n == 19) {
            quickCacheObject = new QuickRelationshipObject(tableBasedClass, new ArrayList());
        } else if (n == 21) {
            quickCacheObject = new QuickRelationshipObject(tableBasedClass, new ArrayList());
        } else if (n == 1) {
            quickCacheObject = new QuickCollectionObject(tableBasedClass, new HashMap());
        } else if (n == 32) {
            quickCacheObject = new QuickStreamObject(tableBasedClass, null, new ByteArrayOutputStream());
        } else if (n == 64) {
            quickCacheObject = new QuickReaderObject(tableBasedClass, null, new CharArrayWriter());
        } else {
            throw new CacheException("Unsupported collection type: " + n);
        }
        Dataholder dataholder = new Dataholder(quickCacheObject);
        return dataholder;
    }

    protected static List getCommaSeparatedSerialList(List arrayList, SysDatabase sysDatabase, String string, int n, Object object, int n2) throws CacheException, SQLException {
        if (n == 8704) {
            return SerialStorage.getCommaSeparatedSerialListWithStrings(sysDatabase, string, n, object);
        }
        String string2 = SysListProxy.getString(object);
        StringTokenizer stringTokenizer = null;
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2, ",");
        }
        block4: while (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            switch (n) {
                case 4608: {
                    byte[] byArray = string3.getBytes();
                    arrayList.add(SerialStorage.getObjectInCollection(sysDatabase, byArray, string));
                    continue block4;
                }
                case 256: {
                    Dataholder dataholder = new Dataholder(string3);
                    if (n2 < 0) {
                        arrayList.add(dataholder.getString());
                        continue block4;
                    }
                    arrayList.add(dataholder.getObject(n2));
                    continue block4;
                }
            }
            throw new CacheException("Unsupported collection element type");
        }
        return arrayList;
    }

    private static List getCommaSeparatedSerialListWithStrings(SysDatabase sysDatabase, String string, int n, Object object) throws CacheException, SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        byte[] byArray = SysListProxy.getByte(object);
        int n2 = 0;
        block4: while (n2 < byArray.length) {
            int n3 = byArray.length - n2;
            Object object2 = SysListProxy.createSysList(byArray, n3, n2, sysDatabase.getConnectionInfo());
            byte[] byArray2 = SysListProxy.getByte(object2);
            n2 = byArray2.length < 255 ? (n2 += byArray2.length + 2) : (n2 += byArray2.length + 4);
            switch (n) {
                case 256: {
                    Object object3 = SerialStorage.hackBytesBackToList(byArray2);
                    arrayList.add(SysListProxy.getString(object3));
                    break;
                }
                case 8704: {
                    SysListProxy.rewind(object2);
                    arrayList.add(SerialStorage.getSerialObject(sysDatabase, object2, string));
                    n2 += SerialStorage.listContinues(byArray, n2);
                    break;
                }
                default: {
                    throw new CacheException("Unsupported collection element type");
                }
            }
            if (n2 == byArray.length) break;
            if (byArray[n2] == 44) {
                ++n2;
            } else {
                throw new CacheException("Incorrect data format: expected ',' got '" + byArray[n2] + "'");
            }
            while (n2 < byArray.length && byArray[n2] == 44) {
                if (n2 < byArray.length && byArray[n2] == 1) {
                    --n2;
                    continue block4;
                }
                ++n2;
            }
        }
        return arrayList;
    }

    private static int listContinues(byte[] byArray, int n) {
        Object object = SysListProxy.createSysList(byArray, byArray.length - n, n, new ConnectionInfo());
        int n2 = 0;
        byte by = 44;
        while (byArray.length > n) {
            if (byArray[n] == by && byArray.length > n + 1 && byArray[n + 1] != 1 && byArray[n + 1] != 2) {
                return n2;
            }
            try {
                byte[] byArray2 = SysListProxy.getByte(object);
                n2 = byArray2.length < 255 ? (n2 += byArray2.length + 2) : (n2 += byArray2.length + 4);
                n += n2;
            }
            catch (Exception exception) {
                return n2;
            }
        }
        return n2;
    }

    protected static List getSerialList(List arrayList, SysDatabase sysDatabase, String string, int n, Object object, int n2) throws CacheException, SQLException {
        Object object2 = SysListProxy.getSysList(object);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        block5: while (object2 != null && !SysListProxy.atEnd(object2)) {
            switch (n) {
                case 4608: {
                    byte[] byArray = SysListProxy.getByte(object2);
                    arrayList.add(SerialStorage.getObjectInCollection(sysDatabase, byArray, string));
                    continue block5;
                }
                case 256: {
                    arrayList.add(SerialStorage.getDataType(object2, n2));
                    continue block5;
                }
                case 8704: {
                    Object object3 = SysListProxy.getSysList(object2);
                    arrayList.add(SerialStorage.getSerialObject(sysDatabase, object3, string));
                    continue block5;
                }
            }
            throw new CacheException("Unsupported collection element type: " + n);
        }
        return arrayList;
    }

    protected static Map getSerialArray(Map hashMap, SysDatabase sysDatabase, String string, int n, Object object, int n2) throws CacheException, SQLException {
        Object object2 = SysListProxy.getSysList(object);
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
        }
        block5: while (object2 != null && !SysListProxy.atEnd(object2)) {
            Object object3 = SysListProxy.getSysList(object2);
            String string2 = SysListProxy.getString(object3);
            switch (n) {
                case 4608: {
                    byte[] byArray = SysListProxy.getByte(object3);
                    hashMap.put(string2, SerialStorage.getObjectInCollection(sysDatabase, byArray, string));
                    continue block5;
                }
                case 256: {
                    hashMap.put(string2, SerialStorage.getDataType(object3, n2));
                    continue block5;
                }
                case 8704: {
                    Object object4 = SysListProxy.getSysList(object3);
                    hashMap.put(string2, SerialStorage.getSerialObject(sysDatabase, object4, string));
                    continue block5;
                }
            }
            throw new CacheException("Unsupported collection element type");
        }
        return hashMap;
    }

    protected static Map getCommaSeparatedSerialArray(Map hashMap, SysDatabase sysDatabase, String string, int n, Object object, int n2) throws CacheException, SQLException {
        byte[] byArray = SysListProxy.getByte(object);
        int n3 = 0;
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
        }
        if (byArray == null) {
            return hashMap;
        }
        block5: while (n3 < byArray.length) {
            int n4 = byArray.length - n3;
            Object object2 = SysListProxy.createSysList(byArray, n4, n3, sysDatabase.getConnectionInfo());
            byte[] byArray2 = SysListProxy.getByte(object2);
            n3 = byArray2.length < 255 ? (n3 += byArray2.length + 2) : (n3 += byArray2.length + 4);
            String string2 = SysListProxy.getString(SerialStorage.hackBytesBackToList(byArray2));
            byte[] byArray3 = SysListProxy.getByte(object2);
            n3 = byArray3.length < 255 ? (n3 += byArray3.length + 2) : (n3 += byArray3.length + 4);
            Object object3 = SerialStorage.hackBytesBackToList(byArray3);
            switch (n) {
                case 4608: {
                    byte[] byArray4 = SysListProxy.getByte(object3);
                    hashMap.put(string2, SerialStorage.getObjectInCollection(sysDatabase, byArray4, string));
                    break;
                }
                case 256: {
                    hashMap.put(string2, SerialStorage.getDataType(object3, n2));
                    break;
                }
                case 8704: {
                    Object object4 = SysListProxy.getSysList(object3);
                    hashMap.put(string2, SerialStorage.getSerialObject(sysDatabase, object4, string));
                    break;
                }
                default: {
                    throw new CacheException("Unsupported collection element type");
                }
            }
            if (n3 < byArray.length) {
                if (byArray[n3] == 44) {
                    ++n3;
                } else {
                    throw new CacheException("Incorrect data format: expected ',' got '" + byArray[n3] + "'");
                }
            }
            while (n3 < byArray.length && byArray[n3] == 44) {
                if (n3 < byArray.length && byArray[n3] == 1) {
                    --n3;
                    continue block5;
                }
                ++n3;
            }
        }
        return hashMap;
    }

    private static Object hackBytesBackToList(byte[] byArray) throws SQLException {
        Object object = SysListProxy.createSysList(new ConnectionInfo());
        SysListProxy.setByte(object, byArray);
        SysListProxy.rewind(object);
        return object;
    }

    private static Object getDataType(Object object, int n) throws SQLException, CacheException {
        if (n < 0) {
            return SysListProxy.getString(object);
        }
        Object object2 = SysListProxy.getWrappedItem(object);
        Dataholder dataholder = new Dataholder(4096, object2);
        return dataholder.getObject(n);
    }

    protected static Object getSerialObject(SysDatabase sysDatabase, Object object, String string) throws CacheException {
        SerialStorage serialStorage = new SerialStorage(sysDatabase, string, object);
        QuickEmbeddedObject quickEmbeddedObject = new QuickEmbeddedObject(serialStorage);
        return quickEmbeddedObject.newJavaInstance(true);
    }

    protected static Dataholder getSerialObject(Object object, TableBasedClass tableBasedClass) throws CacheException {
        SerialStorage serialStorage = new SerialStorage(tableBasedClass, object);
        QuickEmbeddedObject quickEmbeddedObject = new QuickEmbeddedObject(serialStorage);
        return new Dataholder(quickEmbeddedObject);
    }

    protected static Object getObjectInCollection(SysDatabase sysDatabase, byte[] byArray, String string) throws CacheException {
        CacheObject cacheObject = sysDatabase.openCacheObject(string, byArray);
        return cacheObject.newJavaInstance(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Object serializeCollection(QuickDatabase quickDatabase, int n, Object object, int n2) throws CacheException {
        if (TypeModifierHelper.isPersistent(n2)) {
            if (TypeModifierHelper.isList(n)) {
                return quickDatabase.wrapRefList((List)object, false);
            }
            if (n != 1) throw new CacheException("Unsupported collection type: " + n);
            return quickDatabase.wrapRefArray((Map)object, false);
        }
        if (TypeModifierHelper.isSerial(n2)) {
            if (TypeModifierHelper.isList(n)) {
                return quickDatabase.wrapSerialList((List)object);
            }
            if (n != 1) throw new CacheException("Unsupported collection type: " + n);
            return quickDatabase.wrapSerialArray((Map)object);
        }
        if (!TypeModifierHelper.isDatatype(n2)) throw new CacheException("Unsupported collection element type: " + n2);
        if (TypeModifierHelper.isList(n)) {
            List list = SerialStorage.listOfDatatypesToLogical((List)object);
            return quickDatabase.wrapPrimList(list);
        }
        if (n != 1) throw new CacheException("Unsupported collection type: " + n);
        Map map = SerialStorage.mapOfDatatypesToLogical((Map)object);
        return quickDatabase.wrapPrimArray(map);
    }

    private static List listOfDatatypesToLogical(List list) throws CacheException {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(SerialStorage.datatypeToLogical(iterator.next()));
        }
        return arrayList;
    }

    private static Map mapOfDatatypesToLogical(Map map) throws CacheException {
        HashMap hashMap = new HashMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            hashMap.put(entry.getKey(), SerialStorage.datatypeToLogical(entry.getValue()));
        }
        return hashMap;
    }

    private static Object datatypeToLogical(Object object) throws CacheException {
        Dataholder dataholder;
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            dataholder = new Dataholder((Date)object);
        } else if (object instanceof Time) {
            dataholder = new Dataholder((Time)object);
        } else if (object instanceof Timestamp) {
            dataholder = new Dataholder((Timestamp)object);
        } else {
            return object;
        }
        return dataholder.getInteger();
    }

    public static interface StorageElement {
        public int getIndex() throws CacheException;

        public int getCollectionType() throws CacheException;

        public boolean isSerial() throws CacheException;
    }
}

