/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.gateway;

import com.intersys.cache.CacheClassBuilder;
import com.intersys.gateway.GatewayException;
import com.intersys.gateway.Generator;
import com.intersys.gateway.ImportClassLoader;
import com.intersys.gateway.JGPrintStream;
import com.intersys.gateway.JMSGateway;
import com.intersys.gateway.TypeMap;
import com.intersys.gateway.XMLClassGenerator;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.InStream;
import com.intersys.jdbc.LogFileStream;
import com.intersys.jdbc.OutStream;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheDatabase;
import com.intersys.objects.Database;
import com.jalapeno.tools.objects.JavaCacheClassMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class JavaGateway
extends Thread {
    protected static final int PROTOCOL_VERSION = 0;
    protected static final byte[] MESSAGE_CONNECT = new byte[]{89, 48};
    protected static final byte[] MESSAGE_EXECUTE_METHOD = new byte[]{89, 49};
    protected static final byte[] MESSAGE_GENERATE_CLASSES = new byte[]{89, 50};
    protected static final byte[] MESSAGE_GET_JAVA_PROXY = new byte[]{89, 51};
    protected static final byte[] MESSAGE_DISCONNECT = new byte[]{89, 52};
    protected static final byte[] MESSAGE_EXCEPTION_RAISED = new byte[]{89, 53};
    protected static final byte[] MESSAGE_SHUTDOWN = new byte[]{89, 54};
    protected static final byte[] MESSAGE_JAVA_OBJECT_CREATED = new byte[]{89, 57};
    protected static final byte[] MESSAGE_JAVA_BINDING_ATTACH = new byte[]{89, 66};
    protected static final byte[] MESSAGE_GET_AVAILABLE_CLASSES = new byte[]{89, 67};
    protected static final byte[] MESSAGE_JAVA_BINDING_DETACH = new byte[]{89, 68};
    protected static final byte[] MESSAGE_JMS_GET_MESSAGE = new byte[]{89, 71};
    protected static final byte[] MESSAGE_JMS_MESSAGE_ALERT = new byte[]{89, 78};
    protected static final byte[] MESSAGE_GET_TIMESTAMP = new byte[]{89, 84};
    protected static final byte[] MESSAGE_LOAD_JAVA_CLASS = new byte[]{89, 90};
    protected static final byte[] MESSAGE_ADD_TO_CURRENT_CLASSPATH = new byte[]{89, 80};
    protected static final byte[] MESSAGE_REGISTER_ON_DESTRUCT_CALLBACK = new byte[]{89, 82};
    protected static final int CONNECT = 0;
    protected static final int EXECUTE_METHOD = 1;
    protected static final int GENERATE_CLASSES = 2;
    protected static final int GET_JAVA_PROXY = 3;
    protected static final int DISCONNECT = 4;
    protected static final int EXCEPTION_RAISED = 5;
    protected static final int SHUTDOWN = 6;
    protected static final int JAVA_OBJECT_CREATED = 9;
    protected static final int JAVA_BINDING_ATTACH = 18;
    protected static final int GET_AVAILABLE_CLASSES = 19;
    protected static final int JAVA_BINDING_DETACH = 20;
    protected static final int JMS_GET_MESSAGE = 23;
    protected static final int GET_TIMESTAMP = 36;
    protected static final int LOAD_JAVA_CLASS = 42;
    protected static final int ADD_TO_CURRENT_CLASSPATH = 32;
    protected static final int REGISTER_ON_DESTRUCT_CALLBACK = 34;
    protected static final int FIND_ANY = 0;
    protected static final int FIND_CONSTRUCTOR = 1;
    protected static HashMap cacheTypes;
    protected static HashMap calledCache;
    protected static HashMap allMethods;
    protected static HashMap allConstructors;
    private static HashMap gateways;
    protected static int systemClassLevel;
    protected CacheConnection connection;
    protected Database database = null;
    protected CacheClassBuilder classGenerator;
    protected LogFileStream logFile = null;
    protected InStream inMessage = null;
    protected OutStream outMessage = null;
    protected long cacheJobNumber = -1L;
    protected Socket socket = null;
    protected int protocolVersion;
    protected String namespace;
    protected HashMap orefRegistry;
    protected HashMap orefToClassMap;
    protected HashMap onDestructRegistry;
    protected HashMap alreadyGenerated;
    protected ArrayList exclusions;
    protected JGPrintStream outputRedirect;
    protected PrintStream originalOuputStream;
    protected boolean disableOutputRedirect;
    protected boolean disableDeployedMode;
    protected int port;
    protected boolean overloadHasReturnValue = false;

    protected JavaGateway(Socket socket, int n, LogFileStream logFileStream) throws Exception {
        this.socket = socket;
        this.port = n;
        this.alreadyGenerated = new HashMap();
        this.orefRegistry = new HashMap();
        this.orefToClassMap = new HashMap();
        this.logFile = logFileStream;
        this.socket.setReuseAddress(true);
        this.outMessage = new OutStream(this.socket.getOutputStream(), this.logFile);
        SysListProxy.setMaxItemSize(this.outMessage.wire, 0);
        this.inMessage = new InStream(this.socket.getInputStream(), this.logFile);
        this.disableOutputRedirect = false;
        this.disableDeployedMode = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runJavaGateway(CacheConnection cacheConnection, int n) throws Throwable {
        Class<JavaGateway> clazz = JavaGateway.class;
        synchronized (JavaGateway.class) {
            JavaGateway javaGateway;
            if (gateways == null) {
                gateways = new HashMap();
            }
            if ((javaGateway = (JavaGateway)gateways.get(cacheConnection)) == null) {
                javaGateway = new JavaGateway();
                gateways.put(cacheConnection, javaGateway);
                javaGateway.init(cacheConnection);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            boolean bl = false;
            if (n == 18) {
                javaGateway.javaBindingAttach();
            } else {
                javaGateway.processMessage(n, false);
                bl = true;
            }
            javaGateway.run(bl);
            return;
        }
    }

    private JavaGateway() throws Exception {
        this.alreadyGenerated = new HashMap();
        this.orefRegistry = new HashMap();
        this.orefToClassMap = new HashMap();
    }

    protected void cleanUp() throws Exception {
        this.connection = null;
        this.database = null;
        this.classGenerator = null;
        this.inMessage = null;
        this.outMessage = null;
        if (this.onDestructRegistry != null && this.onDestructRegistry.size() > 0) {
            this.clearDestructRegistry();
        }
        if (this.orefRegistry != null) {
            this.orefRegistry.clear();
            this.orefRegistry = null;
        }
        if (this.orefToClassMap != null) {
            this.orefToClassMap.clear();
            this.orefToClassMap = null;
        }
        if (this.alreadyGenerated != null) {
            this.alreadyGenerated.clear();
            this.alreadyGenerated = null;
        }
        if (this.exclusions != null) {
            this.exclusions.clear();
            this.exclusions = null;
        }
        System.setOut(this.originalOuputStream);
        this.outputRedirect = null;
    }

    private void init(CacheConnection cacheConnection) throws Exception {
        this.connection = cacheConnection;
        this.database = CacheDatabase.getDatabase(this.connection);
        this.createClassGenerator();
        this.outMessage = (OutStream)this.connection.getOutMessage();
        SysListProxy.setMaxItemSize(this.outMessage.wire, 0);
        this.inMessage = (InStream)this.connection.getInMessage();
        this.logFile = this.connection.logFile;
    }

    protected void javaBindingAttach() throws Exception {
        try {
            this.orefRegistry.clear();
            this.orefToClassMap.clear();
            this.onDestructRegistry = null;
            if (!this.disableOutputRedirect) {
                this.outputRedirect = new JGPrintStream();
                this.originalOuputStream = System.out;
                System.setOut(this.outputRedirect);
            }
            this.protocolVersion = SysListProxy.getInteger(this.inMessage.wire);
            this.cacheJobNumber = SysListProxy.getLong(this.inMessage.wire);
            this.namespace = SysListProxy.getString(this.inMessage.wire);
            if (this.logFile != null) {
                this.logFile.logApi(" >> JAVA_BINDING_ATTACH");
            }
            if (this.protocolVersion < 0) {
                this.protocolVersion = 0;
            }
            SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_JAVA_BINDING_ATTACH);
            SysListProxy.setInteger(this.outMessage.wire, this.protocolVersion);
            this.outMessage.send(0);
            if (this.logFile != null) {
                this.logFile.logApi(" << JAVA_BINDING_ATTACH");
            }
        }
        catch (Throwable throwable) {
            this.processException(throwable);
        }
    }

    protected void javaBindingDetach() throws Throwable {
        int n;
        if (this.logFile != null) {
            this.logFile.logApi(" >> JAVA_BINDING_DETACH");
        }
        if ((n = SysListProxy.getInteger(this.inMessage.wire)) > 0) {
            this.updateOrefRegistry(n);
        }
        SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_JAVA_BINDING_DETACH);
        this.outMessage.send(0);
        if (this.logFile != null) {
            this.logFile.logApi(" << JAVA_BINDING_DETACH");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        LogFileStream logFileStream = null;
        if (stringArray.length == 0) {
            throw new GatewayException("Port number must be supplied as the first command line argument");
        }
        int n = Integer.parseInt(stringArray[0]);
        if (stringArray.length > 1) {
            if (stringArray.length == 2) {
                logFileStream = new LogFileStream(stringArray[1]);
            } else if (stringArray.length == 3) {
                logFileStream = new LogFileStream(stringArray[1]);
                systemClassLevel = Integer.parseInt(stringArray[2]);
            }
        }
        try {
            ServerSocket serverSocket = new ServerSocket(n);
            while (true) {
                Socket socket = serverSocket.accept();
                socket.setReuseAddress(true);
                socket.setTcpNoDelay(true);
                new JavaGateway(socket, n, logFileStream).start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GatewayException("[Java Gateway] Communication link failure: " + exception.getMessage());
        }
    }

    public synchronized void run() {
        this.run(false);
    }

    public synchronized void run(boolean bl) {
        try {
            int n;
            do {
                try {
                    n = this.inMessage.readHeader();
                }
                catch (Exception exception) {
                    String string = exception.getMessage();
                    if (string.equals("Server closed communication device") || string.equals("Connection reset")) {
                        return;
                    }
                    throw new GatewayException(exception.getMessage());
                }
            } while (!this.processMessage(n, bl));
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private boolean processMessage(int n, boolean bl) throws Throwable {
        switch (n) {
            case 1: {
                this.executeMethod();
                break;
            }
            case 3: {
                this.callConstructor();
                break;
            }
            case 2: {
                this.generateClasses();
                break;
            }
            case 0: {
                this.connect();
                break;
            }
            case 19: {
                this.getAvailableClasses();
                break;
            }
            case 42: {
                this.loadJavaClass();
                break;
            }
            case 4: {
                this.disconnect();
                return true;
            }
            case 6: {
                this.shutdown();
            }
            case 23: {
                ((JMSGateway)this).getJMSMessage();
                break;
            }
            case 20: {
                this.javaBindingDetach();
                return true;
            }
            case 32: {
                this.addToCurrentClasspath();
                break;
            }
            case 34: {
                this.registerOnDestructCallback();
                break;
            }
            default: {
                if (bl) {
                    return true;
                }
                throw new GatewayException("Unknown Message: " + n);
            }
        }
        return false;
    }

    protected void shutdown() throws Exception {
        if (this.logFile != null) {
            this.logFile.logApi(" >> SHUTDOWN << ");
        }
        this.socket.close();
        System.exit(0);
    }

    protected void disconnect() throws Exception {
        if (this.logFile != null) {
            this.logFile.logApi(" >> DISCONNECT");
        }
        if (!this.disableOutputRedirect) {
            System.setOut(System.out);
        }
        this.database = null;
        SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_DISCONNECT);
        this.outMessage.send(0);
        if (this.logFile != null) {
            this.logFile.logApi(" << DISCONNECT");
        }
        this.cleanUp();
    }

    protected void connect() throws Exception {
        try {
            this.orefRegistry.clear();
            this.orefToClassMap.clear();
            this.protocolVersion = SysListProxy.getInteger(this.inMessage.wire);
            boolean bl = SysListProxy.getInteger(this.inMessage.wire) == 1;
            String string = SysListProxy.readServerEncoding(this.inMessage.wire);
            ConnectionInfo connectionInfo = new ConnectionInfo(this.protocolVersion, string, bl);
            this.cacheJobNumber = SysListProxy.getLong(this.inMessage.wire);
            this.namespace = SysListProxy.getString(this.inMessage.wire);
            this.setAdditionalClassPath(null);
            this.disableOutputRedirect = SysListProxy.getBoolean(this.inMessage.wire);
            if (!this.disableOutputRedirect) {
                this.outputRedirect = new JGPrintStream();
                this.originalOuputStream = System.out;
                System.setOut(this.outputRedirect);
            }
            this.disableDeployedMode = SysListProxy.getBoolean(this.inMessage.wire);
            int n = SysListProxy.getInteger(this.inMessage.wire);
            if (this.logFile != null) {
                this.logFile.logApi(" >> CONNECT");
            }
            if (this.protocolVersion < 0) {
                this.protocolVersion = 0;
            }
            this.connection = new CacheConnection(this.inMessage, this.outMessage, this.socket, this.namespace, this.port, n, this.logFile);
            this.connection.setConnectionInfo(connectionInfo);
            this.inMessage.setConnection(this.connection);
            this.outMessage.setConnection(this.connection);
            this.createClassGenerator();
            SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_CONNECT);
            SysListProxy.setInteger(this.outMessage.wire, this.protocolVersion);
            SysListProxy.setInteger(this.outMessage.wire, this.connection.getProtocolVersion());
            this.outMessage.send(0);
            if (this.logFile != null) {
                this.logFile.logApi(" << CONNECT");
            }
        }
        catch (Throwable throwable) {
            this.processException(throwable);
        }
    }

    private void registerOnDestructCallback() throws Exception {
        try {
            Object v;
            String string = SysListProxy.getString(this.inMessage.wire);
            String string2 = SysListProxy.getString(this.inMessage.wire);
            if (this.logFile != null) {
                this.logFile.logApi(" >> REGISTER_ON_DESTRUCT_CALLBACK");
            }
            if ((v = this.orefRegistry.get(string)) == null) {
                throw new GatewayException("Unable to register destruct callback - no matching object was found");
            }
            Method method = v.getClass().getMethod(string2, null);
            if (this.onDestructRegistry == null) {
                this.onDestructRegistry = new HashMap();
            }
            this.onDestructRegistry.put(v, method);
            this.outMessage.send(0);
            if (this.logFile != null) {
                this.logFile.logApi(" << REGISTER_ON_DESTRUCT_CALLBACK");
            }
        }
        catch (Throwable throwable) {
            this.processException(throwable);
        }
    }

    private void clearDestructRegistry() throws Exception {
        for (Object k : this.onDestructRegistry.keySet()) {
            Method method = (Method)this.onDestructRegistry.get(k);
            method.invoke(k, (Object[])null);
        }
    }

    private void setAdditionalClassPath(String string) throws Exception {
        int n = SysListProxy.getInteger(this.inMessage.wire);
        if (n == 0 && string == null) {
            return;
        }
        URL[] uRLArray = new URL[n];
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        for (int i = 0; i < n; ++i) {
            String string2 = SysListProxy.getString(this.inMessage.wire);
            uRLArray[i] = new File(string2).toURL();
            method.invoke((Object)uRLClassLoader, uRLArray[i]);
        }
        if (string != null) {
            URL[] uRLArray2 = new URL[]{new File(string).toURL()};
            method.invoke((Object)uRLClassLoader, uRLArray2[0]);
        }
    }

    private void createClassGenerator() throws Exception {
        this.classGenerator = new XMLClassGenerator();
    }

    protected synchronized void getAvailableClasses() throws Exception {
        try {
            String string = SysListProxy.getString(this.inMessage.wire);
            if (this.logFile != null) {
                this.logFile.logApi(" >> GET_AVAILABLE_CLASSES: " + string);
            }
            String[] stringArray = null;
            if (string != null && !string.equals("")) {
                stringArray = ImportClassLoader.newInstance(string).getAllClassNames();
            }
            SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_GET_AVAILABLE_CLASSES);
            SysListProxy.setInteger(this.outMessage.wire, stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                SysListProxy.setString(this.outMessage.wire, stringArray[i]);
            }
            this.outMessage.send(0);
            if (this.logFile != null) {
                this.logFile.logApi(" << GET_AVAILABLE_CLASSES");
            }
        }
        catch (Throwable throwable) {
            this.processException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void generateClasses() throws Exception {
        try {
            int n;
            String string = SysListProxy.getString(this.inMessage.wire);
            if (string.endsWith(".jar")) {
                this.setAdditionalClassPath(string);
            } else {
                this.setAdditionalClassPath(null);
            }
            this.exclusions = TypeMap.getInitialExclusions();
            int n2 = SysListProxy.getInteger(this.inMessage.wire);
            for (n = 0; n < n2; ++n) {
                this.exclusions.add(SysListProxy.getString(this.inMessage.wire));
            }
            if (this.logFile != null) {
                this.logFile.logApi(" >> GENERATE_CLASSES: " + string);
            }
            if (this.database == null) {
                this.database = CacheDatabase.getDatabase(this.connection);
            }
            Object[] objectArray = string.endsWith(".jar") ? this.generateJar(string) : new Generator(this).generate(string).toArray();
            String[] stringArray = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                stringArray[n] = TypeMap.getCacheClassName((String)objectArray[n]);
                Database database = this.database;
                synchronized (database) {
                    this.database.utilities().compileCacheClass(stringArray[n], "fr");
                    continue;
                }
            }
            this.database.close();
            this.database = null;
            SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_GENERATE_CLASSES);
            SysListProxy.setInteger(this.outMessage.wire, objectArray.length);
            for (n = 0; n < objectArray.length; ++n) {
                SysListProxy.setString(this.outMessage.wire, (String)objectArray[n]);
            }
            this.outMessage.send(0);
            if (this.logFile != null) {
                this.logFile.logApi(" << GENERATE_CLASSES");
            }
        }
        catch (Throwable throwable) {
            this.processException(throwable);
        }
    }

    private Object[] generateJar(String string) throws Throwable {
        HashSet hashSet = new HashSet();
        String[] stringArray = ImportClassLoader.newInstance(string).getAllClassNames();
        Generator generator = new Generator(this);
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.addAll(generator.generate(stringArray[i]));
        }
        return hashSet.toArray();
    }

    private void updateOrefRegistry(int n) throws Throwable {
        for (int i = 0; i < n; ++i) {
            String string = SysListProxy.getString(this.inMessage.wire);
            if (this.onDestructRegistry != null && this.onDestructRegistry.size() > 0) {
                Object v = this.orefRegistry.get(string);
                Method method = (Method)this.onDestructRegistry.get(v);
                method.invoke(v, (Object[])null);
            }
            this.orefRegistry.remove(string);
        }
    }

    private Object findMember(String string, String string2, int n) throws Throwable {
        Object object;
        HashMap<String, Object> hashMap = (HashMap<String, Object>)calledCache.get(string);
        if (hashMap != null) {
            object = hashMap.get(string2);
            if (object != null) {
                return object;
            }
        } else {
            hashMap = new HashMap<String, Object>();
            calledCache.put(string, hashMap);
        }
        object = this.loadClass(string);
        if (object == null) {
            throw new GatewayException("Class not found: " + string);
        }
        if (n == 1 || string.equals(string2)) {
            Constructor[] constructorArray = (Constructor[])allConstructors.get(string);
            if (constructorArray == null) {
                constructorArray = ((Class)object).getConstructors();
                allConstructors.put(string, constructorArray);
            }
            if (constructorArray == null || constructorArray.length == 0) {
                throw new GatewayException("Constructor not found: " + string);
            }
            if (constructorArray.length == 1) {
                hashMap.put(string2, constructorArray[0]);
                return constructorArray[0];
            }
            ArrayList<Constructor> arrayList = new ArrayList<Constructor>(constructorArray.length);
            for (int i = 0; i < constructorArray.length; ++i) {
                arrayList.add(constructorArray[i]);
            }
            hashMap.put(string2, arrayList);
            return arrayList;
        }
        Method[] methodArray = (Method[])allMethods.get(string);
        if (methodArray == null) {
            methodArray = ((Class)object).getMethods();
            allMethods.put(string, methodArray);
        }
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string2)) continue;
            arrayList.add(methodArray[i]);
        }
        methodArray = null;
        if (arrayList.size() == 1) {
            hashMap.put(string2, arrayList.get(0));
            return (Method)arrayList.get(0);
        }
        if (arrayList.size() > 1) {
            hashMap.put(string2, arrayList);
            return arrayList;
        }
        if (!string2.startsWith("get") && !string2.startsWith("set")) {
            throw new GatewayException("Member not found: " + string2);
        }
        Field field = ((Class)object).getField(string2.substring(3, string2.length()));
        hashMap.put(string2, field);
        return field;
    }

    protected void executeMethod() throws Throwable {
        try {
            String string;
            int n = SysListProxy.getInteger(this.inMessage.wire);
            if (n > 0) {
                this.updateOrefRegistry(n);
            }
            String string2 = SysListProxy.getString(this.inMessage.wire);
            String string3 = SysListProxy.getString(this.inMessage.wire);
            if (this.logFile != null) {
                this.logFile.logApi(" >> EXECUTE_METHOD: " + string3);
            }
            if ((string = (String)this.orefToClassMap.get(string2)) == null) {
                string = string2;
            }
            Object v = this.orefRegistry.get(string2);
            Object object = string.equals("java.lang.Object") && v != null && !v.getClass().getName().equals("java.lang.Object") ? this.findMember(v.getClass().getName(), string3, 0) : (v == null || string.equals(v.getClass().getName()) || v.getClass().getName().indexOf("$") != -1 || !Modifier.isPublic(v.getClass().getModifiers()) || v.getClass().isAssignableFrom(this.loadClass(string)) || this.loadClass(string).isAssignableFrom(v.getClass()) ? this.findMember(string, string3, 0) : this.findMember(v.getClass().getName(), string3, 0));
            if (object instanceof Method) {
                this.executeInstanceMethod((Method)object, string3, string2);
            } else if (object instanceof Constructor) {
                this.executeConstructor((Constructor)object, string2);
            } else if (object instanceof Field) {
                Object v2 = this.orefRegistry.get(string2);
                SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_EXECUTE_METHOD);
                if (string3.startsWith("get")) {
                    this.marshalReturnValue(((Field)object).getType(), ((Field)object).get(v2));
                } else if (string3.startsWith("set")) {
                    this.executeSetter((Field)object, v2);
                }
            } else if (object instanceof ArrayList) {
                this.executeOverloadedMethod((ArrayList)object, string3, string2);
            }
            this.outMessage.send(0);
            if (this.logFile != null) {
                this.logFile.logApi(" << EXECUTE_METHOD");
            }
        }
        catch (Throwable throwable) {
            this.processException(throwable);
        }
    }

    protected void executeInstanceMethod(Method method, String string, String string2) throws Throwable {
        Object object;
        Object v = this.orefRegistry.get(string2);
        if (v == null && !Modifier.isStatic(method.getModifiers())) {
            throw new Exception("Corresponding Java object not found: make sure you called a constructor");
        }
        int n = SysListProxy.getInteger(this.inMessage.wire);
        Class[] classArray = null;
        if (n == -1) {
            classArray = method.getParameterTypes();
            n = classArray.length;
        }
        Object[] objectArray = null;
        if (n == 0) {
            classArray = null;
            try {
                object = method.invoke(v, (Object[])null);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }
        objectArray = this.unmarshalParameters(n, classArray);
        try {
            object = method.invoke(v, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_EXECUTE_METHOD);
        Class<?> clazz = method.getReturnType();
        if (object != null && clazz == Object.class && !Proxy.isProxyClass(object.getClass())) {
            clazz = object.getClass();
        }
        if (!clazz.getName().equals("void")) {
            this.marshalReturnValue(clazz, object);
        }
        if (objectArray != null) {
            this.marshalArguments(objectArray);
        }
        if (!this.disableOutputRedirect && this.outputRedirect.wasWrittenTo()) {
            SysListProxy.setString(this.outMessage.wire, this.outputRedirect.getWire());
        } else {
            SysListProxy.setUndefined(this.outMessage.wire);
        }
    }

    protected void marshalArguments(Object[] objectArray) throws Throwable {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null && objectArray[i].getClass().isArray()) {
                String string = objectArray[i].getClass().getComponentType().getName();
                if (TypeMap.isJavaDataType(string)) {
                    this.marshalArray(objectArray[i], objectArray[i].getClass().getComponentType().getName());
                    continue;
                }
                SysListProxy.setUndefined(this.outMessage.wire);
                continue;
            }
            SysListProxy.setUndefined(this.outMessage.wire);
        }
    }

    protected void executeOverloadedMethod(ArrayList arrayList, String string, String string2) throws Throwable {
        Object object = this.orefRegistry.get(string2);
        String string3 = (String)this.orefToClassMap.get(string2);
        if (string3 == null) {
            string3 = string2;
        }
        Class clazz = this.loadClass(string3);
        int n = SysListProxy.getInteger(this.inMessage.wire);
        Class[] classArray = null;
        Object[] objectArray = null;
        if (n == 0) {
            classArray = null;
        } else {
            classArray = new Class[n];
            objectArray = this.unmarshalOverloadParameters(n, classArray);
        }
        if (string.equals(string3)) {
            SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_GET_JAVA_PROXY);
            Constructor constructor = this.findConstructor(clazz, classArray, objectArray);
            if (constructor == null) {
                if (classArray == null) {
                    try {
                        object = clazz.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                        throw instantiationException.getCause();
                    }
                }
                throw new Exception("No mathching constructor found; parameters: " + classArray);
            }
            try {
                object = constructor.newInstance(objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            try {
                Field field = clazz.getField("cacheDatabase");
                if (this.database == null) {
                    this.connection.setCacheJobID(this.cacheJobNumber);
                }
                field.set(object, this.database);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            this.orefRegistry.put(string2, object);
        } else {
            Object object2;
            SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_EXECUTE_METHOD);
            this.overloadHasReturnValue = false;
            Method method = this.findMethod(clazz, string, classArray, objectArray);
            if (method == null) {
                throw new Exception("Method not found: " + string + " parameters: " + classArray);
            }
            if (object == null && !Modifier.isStatic(method.getModifiers())) {
                throw new Exception("Corresponding Java object not found: make sure you called a constructor");
            }
            try {
                object2 = method.invoke(object, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            Class<?> clazz2 = method.getReturnType();
            if (object2 != null && clazz2 == Object.class && !Proxy.isProxyClass(object2.getClass())) {
                clazz2 = object2.getClass();
            }
            if (!clazz2.getName().equals("void")) {
                this.marshalReturnValue(clazz2, object2);
            } else if (this.overloadHasReturnValue) {
                SysListProxy.setUndefined(this.outMessage.wire);
            }
            if (objectArray != null) {
                this.marshalArguments(objectArray);
            }
        }
        if (!this.disableOutputRedirect && this.outputRedirect.wasWrittenTo()) {
            SysListProxy.setString(this.outMessage.wire, this.outputRedirect.getWire());
        } else {
            SysListProxy.setUndefined(this.outMessage.wire);
        }
    }

    private Constructor findConstructor(Class clazz, Class[] classArray, Object[] objectArray) throws Exception {
        try {
            if (classArray == null) {
                Constructor constructor = clazz.getConstructor(new Class[0]);
                return constructor;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class<?>[] classArray2;
            int n;
            Constructor[] constructorArray = (Constructor[])allConstructors.get(clazz.getName());
            if (constructorArray == null) {
                constructorArray = clazz.getConstructors();
                allConstructors.put(clazz.getName(), constructorArray);
            }
            ArrayList<Constructor> arrayList = new ArrayList<Constructor>();
            for (n = 0; n < constructorArray.length; ++n) {
                int n2 = 0;
                classArray2 = constructorArray[n].getParameterTypes();
                if (classArray2.length != classArray.length) continue;
                for (int i = 0; i < classArray.length; ++i) {
                    if (!this.compareTypes(classArray[i], classArray2[i])) continue;
                    ++n2;
                }
                if (n2 != classArray.length) continue;
                arrayList.add(constructorArray[n]);
            }
            if (arrayList.size() == 0) {
                return null;
            }
            if (arrayList.size() == 1) {
                Constructor constructor = (Constructor)arrayList.get(0);
                classArray2 = constructor.getParameterTypes();
                for (n = 0; n < classArray2.length; ++n) {
                    if (objectArray[n].getClass() == classArray2[n]) continue;
                    objectArray[n] = this.recastArgument(objectArray[n], classArray2[n]);
                }
                arrayList = null;
                return constructor;
            }
            throw new Exception("Constructor not found: ambiguous parameter types");
        }
    }

    private Method findMethod(Class clazz, String string, Class[] classArray, Object[] objectArray) throws Exception {
        Class<?>[] classArray2;
        int n;
        Method[] methodArray;
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        int n2 = 0;
        if (classArray != null) {
            n2 = classArray.length;
        }
        if ((methodArray = (Method[])allMethods.get(clazz.getName())) == null) {
            methodArray = clazz.getMethods();
            allMethods.put(clazz.getName(), methodArray);
        }
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (n = 0; n < methodArray.length; ++n) {
            if (!methodArray[n].getName().equals(string)) continue;
            if (!methodArray[n].getReturnType().getName().equals("void")) {
                this.overloadHasReturnValue = true;
            }
            if (methodArray[n].getParameterTypes().length != n2) continue;
            arrayList.add(methodArray[n]);
        }
        if (method != null) {
            return method;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        ArrayList arrayList2 = new ArrayList();
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = 0;
            classArray2 = ((Method)arrayList.get(n)).getParameterTypes();
            for (int i = 0; i < n2; ++i) {
                if (!this.compareTypes(classArray[i], classArray2[i])) continue;
                ++n3;
            }
            if (n3 != n2) continue;
            arrayList2.add(arrayList.get(n));
        }
        arrayList.clear();
        arrayList = null;
        if (arrayList2.isEmpty()) {
            return null;
        }
        if (arrayList2.size() == 1) {
            method = (Method)arrayList2.get(0);
            classArray2 = method.getParameterTypes();
            for (n = 0; n < classArray2.length; ++n) {
                if (classArray2[n] == Object.class || objectArray[n].getClass() == classArray2[n]) continue;
                objectArray[n] = this.recastArgument(objectArray[n], classArray2[n]);
            }
            arrayList2 = null;
            return method;
        }
        throw new Exception("Multiple matches found for overloaded method: " + string);
    }

    private Object recastArgument(Object object, Class clazz) throws Exception {
        if (clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        if (object.getClass() == Integer.class) {
            int n = (Integer)object;
            if (clazz == Short.class || clazz == Short.TYPE) {
                return new Short((short)n);
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                return new Long(n);
            }
            if (clazz == Float.class || clazz == Float.TYPE) {
                return new Float(n);
            }
            if (clazz == Double.class || clazz == Double.TYPE) {
                return new Double(n);
            }
            if (clazz == String.class) {
                return object.toString();
            }
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                if (n == 0) {
                    return new Boolean(false);
                }
                return new Boolean(true);
            }
        } else if (clazz == Class.class) {
            return this.loadClass((String)object);
        }
        return object;
    }

    private boolean compareTypes(Class clazz, Class clazz2) {
        if (clazz2.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz == Integer.TYPE && (clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE || clazz2 == Integer.class || clazz2 == Short.TYPE || clazz2 == Short.class || clazz2 == Long.class || clazz2 == Float.class || clazz2 == Double.class || clazz2 == String.class || clazz2 == Boolean.TYPE || clazz2 == Boolean.class || clazz2 == Object.class)) {
            return true;
        }
        return clazz == String.class && clazz2 == Class.class;
    }

    protected void executeConstructor(Constructor constructor, String string) throws Throwable {
        Object t;
        Object[] objectArray;
        int n = SysListProxy.getInteger(this.inMessage.wire);
        Class[] classArray = null;
        if (n == -1) {
            classArray = constructor.getParameterTypes();
            n = classArray.length;
            objectArray = this.unmarshalParameters(n, classArray);
        } else {
            classArray = new Class[n];
            objectArray = this.unmarshalOverloadParameters(n, classArray);
        }
        try {
            t = constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        try {
            Field field = t.getClass().getField("cacheDatabase");
            if (this.database == null) {
                this.connection.setCacheJobID(this.cacheJobNumber);
            }
            field.set(t, this.database);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_GET_JAVA_PROXY);
        this.orefRegistry.put(string, t);
        if (!this.disableOutputRedirect && this.outputRedirect.wasWrittenTo()) {
            SysListProxy.setString(this.outMessage.wire, this.outputRedirect.getWire());
        } else {
            SysListProxy.setUndefined(this.outMessage.wire);
        }
    }

    protected void executeSetter(Field field, Object object) throws Exception {
        Object object2 = this.unmarshalParameter(field.getType(), field.getType().getName());
        field.set(object, object2);
    }

    protected void callConstructor() throws Throwable {
        try {
            int n = SysListProxy.getInteger(this.inMessage.wire);
            if (n > 0) {
                this.updateOrefRegistry(n);
            }
            String string = SysListProxy.getString(this.inMessage.wire);
            String string2 = SysListProxy.getString(this.inMessage.wire);
            if (this.logFile != null) {
                this.logFile.logApi(" >> CALL_JAVA_CONSTRUCTOR");
            }
            Object object = this.findMember(string2, string2, 1);
            this.orefToClassMap.put(string, string2);
            if (object instanceof Constructor) {
                this.executeConstructor((Constructor)object, string);
            } else if (object instanceof ArrayList) {
                this.executeOverloadedMethod((ArrayList)object, string2, string);
            } else {
                throw new GatewayException("Constructor not found");
            }
            this.outMessage.send(0);
            if (this.logFile != null) {
                this.logFile.logApi(" << CALL_JAVA_CONSTRUCTOR");
            }
        }
        catch (Throwable throwable) {
            this.processException(throwable);
        }
    }

    protected Class loadClass(String string) throws ClassNotFoundException {
        if (string.equals("%GlobalBinaryStream")) {
            return Class.forName("[B");
        }
        if (string.equals("%GlobalCharacterStream")) {
            return Class.forName("[C");
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassNotFoundException classNotFoundException2 = classNotFoundException;
            int n = string.lastIndexOf(46);
            if (n == -1) {
                throw classNotFoundException2;
            }
            string = string.substring(0, n) + "$" + string.substring(n + 1, string.length());
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException3) {
                throw classNotFoundException2;
            }
        }
    }

    protected void addToCurrentClasspath() throws Throwable {
        try {
            if (this.logFile != null) {
                this.logFile.logApi(" >> ADD_TO_CURRENT_CLASSPATH");
            }
            this.setAdditionalClassPath(null);
            SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_ADD_TO_CURRENT_CLASSPATH);
            this.outMessage.send(0);
            if (this.logFile != null) {
                this.logFile.logApi(" << ADD_TO_CURRENT_CLASSPATH");
            }
        }
        catch (Throwable throwable) {
            this.processException(throwable);
        }
    }

    protected void loadJavaClass() throws Throwable {
        try {
            String string = SysListProxy.getString(this.inMessage.wire);
            if (this.logFile != null) {
                this.logFile.logApi(" >> LOAD_JAVA_CLASS: " + string);
            }
            Class.forName(string);
            SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_LOAD_JAVA_CLASS);
            this.outMessage.send(0);
            if (this.logFile != null) {
                this.logFile.logApi(" << LOAD_JAVA_CLASS");
            }
        }
        catch (Throwable throwable) {
            this.processException(throwable);
        }
    }

    protected void marshalArray(Object object, String string) throws Exception {
        if (object == null) {
            SysListProxy.setString(this.outMessage.wire, "%Library.ListOfDataTypes");
            SysListProxy.setInteger(this.outMessage.wire, -1);
            return;
        }
        int n = Array.getLength(object);
        String string2 = object.getClass().getComponentType().getName();
        if (!string2.equals("java.lang.Object")) {
            string = string2;
        }
        if (TypeMap.isJavaDataType(string)) {
            if (string.equals("byte")) {
                SysListProxy.setString(this.outMessage.wire, "%GlobalBinaryStream");
            } else if (string.equals("char")) {
                SysListProxy.setString(this.outMessage.wire, "%GlobalCharacterStream");
            } else {
                SysListProxy.setString(this.outMessage.wire, "%Library.ListOfDataTypes");
            }
            SysListProxy.setInteger(this.outMessage.wire, n);
        }
        if (string.equals("java.lang.String")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setString(this.outMessage.wire, ((String[])object)[i]);
            }
        } else if (string.equals("int")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setInteger(this.outMessage.wire, ((int[])object)[i]);
            }
        } else if (string.equals("java.lang.Integer")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setIntegerWrapper(this.outMessage.wire, ((Integer[])object)[i]);
            }
        } else if (string.equals("double")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setDouble(this.outMessage.wire, ((double[])object)[i]);
            }
        } else if (string.equals("java.lang.Double")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setDoubleWrapper(this.outMessage.wire, ((Double[])object)[i]);
            }
        } else if (string.equals("float")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setFloat(this.outMessage.wire, ((float[])object)[i]);
            }
        } else if (string.equals("java.lang.Float")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setFloatWrapper(this.outMessage.wire, ((Float[])object)[i]);
            }
        } else if (string.equals("boolean")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setBoolean(this.outMessage.wire, ((boolean[])object)[i]);
            }
        } else if (string.equals("java.lang.Boolean")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setBooleanWrapper(this.outMessage.wire, ((Boolean[])object)[i]);
            }
        } else if (string.equals("long")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setLong(this.outMessage.wire, ((long[])object)[i]);
            }
        } else if (string.equals("java.lang.Long")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setLongWrapper(this.outMessage.wire, ((Long[])object)[i]);
            }
        } else if (string.equals("short")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setShort(this.outMessage.wire, ((short[])object)[i]);
            }
        } else if (string.equals("java.lang.Short")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setShortWrapper(this.outMessage.wire, ((Short[])object)[i]);
            }
        } else if (string.equals("java.sql.Date")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setSQLDate(this.outMessage.wire, ((Date[])object)[i]);
            }
        } else if (string.equals("java.sql.Time")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setSQLTime(this.outMessage.wire, ((Time[])object)[i]);
            }
        } else if (string.equals("java.sql.Timestamp")) {
            for (int i = 0; i < n; ++i) {
                SysListProxy.setSQLTimestamp(this.outMessage.wire, ((Timestamp[])object)[i]);
            }
        } else if (string.equals("byte")) {
            SysListProxy.concatenate((Object)this.outMessage.wire, (byte[])object);
        } else if (string.equals("char")) {
            SysListProxy.concatenate((Object)this.outMessage.wire, new String((char[])object).getBytes());
        } else if (!TypeMap.isJavaDataType(string)) {
            String[] stringArray = this.getOrefs(string, object, n);
            SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_EXECUTE_METHOD);
            SysListProxy.setString(this.outMessage.wire, "%Library.ListOfObjects");
            SysListProxy.setInteger(this.outMessage.wire, n);
            for (int i = 0; i < n; ++i) {
                SysListProxy.setString(this.outMessage.wire, stringArray[i]);
            }
        } else {
            throw new GatewayException("Unsupported base array type: " + string);
        }
    }

    protected Object unmarshalArray() throws Exception {
        String string = SysListProxy.getString(this.inMessage.wire);
        int n = SysListProxy.getInteger(this.inMessage.wire);
        if (n == -1) {
            return null;
        }
        if (!string.equals("byte") && !string.equals("char")) {
            string = this.loadClass(string).getComponentType().getName();
        }
        if (string.equals("java.lang.String")) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = SysListProxy.getString(this.inMessage.wire);
            }
            return stringArray;
        }
        if (string.equals("int")) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = SysListProxy.getInteger(this.inMessage.wire);
            }
            return nArray;
        }
        if (string.equals("java.lang.Integer")) {
            Integer[] integerArray = new Integer[n];
            for (int i = 0; i < n; ++i) {
                integerArray[i] = SysListProxy.getIntegerWrapper(this.inMessage.wire);
            }
            return integerArray;
        }
        if (string.equals("double")) {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = SysListProxy.getDouble(this.inMessage.wire);
            }
            return dArray;
        }
        if (string.equals("java.lang.Double")) {
            Double[] doubleArray = new Double[n];
            for (int i = 0; i < n; ++i) {
                doubleArray[i] = SysListProxy.getDoubleWrapper(this.inMessage.wire);
            }
            return doubleArray;
        }
        if (string.equals("float")) {
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = SysListProxy.getFloat(this.inMessage.wire);
            }
            return fArray;
        }
        if (string.equals("java.lang.Float")) {
            Float[] floatArray = new Float[n];
            for (int i = 0; i < n; ++i) {
                floatArray[i] = SysListProxy.getFloatWrapper(this.inMessage.wire);
            }
            return floatArray;
        }
        if (string.equals("boolean")) {
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = SysListProxy.getBoolean(this.inMessage.wire);
            }
            return blArray;
        }
        if (string.equals("java.lang.Boolean")) {
            Boolean[] booleanArray = new Boolean[n];
            for (int i = 0; i < n; ++i) {
                booleanArray[i] = SysListProxy.getBooleanWrapper(this.inMessage.wire);
            }
            return booleanArray;
        }
        if (string.equals("long")) {
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = SysListProxy.getLong(this.inMessage.wire);
            }
            return lArray;
        }
        if (string.equals("java.lang.Long")) {
            Long[] longArray = new Long[n];
            for (int i = 0; i < n; ++i) {
                longArray[i] = SysListProxy.getLongWrapper(this.inMessage.wire);
            }
            return longArray;
        }
        if (string.equals("short")) {
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = SysListProxy.getShort(this.inMessage.wire);
            }
            return sArray;
        }
        if (string.equals("java.lang.Short")) {
            Short[] shortArray = new Short[n];
            for (int i = 0; i < n; ++i) {
                shortArray[i] = SysListProxy.getShortWrapper(this.inMessage.wire);
            }
            return shortArray;
        }
        if (string.equals("java.sql.Date")) {
            Date[] dateArray = new Date[n];
            for (int i = 0; i < n; ++i) {
                dateArray[i] = SysListProxy.getSQLDate(this.inMessage.wire);
            }
            return dateArray;
        }
        if (string.equals("java.sql.Time")) {
            Time[] timeArray = new Time[n];
            for (int i = 0; i < n; ++i) {
                timeArray[i] = SysListProxy.getSQLTime(this.inMessage.wire);
            }
            return timeArray;
        }
        if (string.equals("java.sql.Timestamp")) {
            Timestamp[] timestampArray = new Timestamp[n];
            for (int i = 0; i < n; ++i) {
                timestampArray[i] = SysListProxy.getSQLTimestamp(this.inMessage.wire);
            }
            return timestampArray;
        }
        if (string.equals("byte")) {
            byte[] byArray = new byte[n];
            if (n != 0) {
                byArray = SysListProxy.getByte(this.inMessage.wire);
            }
            return byArray;
        }
        if (string.equals("char")) {
            if (n == 0) {
                return null;
            }
            return SysListProxy.getString(this.inMessage.wire).toCharArray();
        }
        if (!TypeMap.isJavaDataType(string)) {
            Object object = Array.newInstance(this.loadClass(string), n);
            for (int i = 0; i < n; ++i) {
                Array.set(object, i, this.orefRegistry.get(SysListProxy.getString(this.inMessage.wire)));
            }
            return object;
        }
        throw new GatewayException("Unsupported base array type: " + string);
    }

    protected String orefRegistryLookup(Object object) {
        for (Object k : this.orefRegistry.keySet()) {
            Object v = this.orefRegistry.get(k);
            if (v != object) continue;
            return (String)k;
        }
        return null;
    }

    protected String[] getOrefs(String string, Object object, int n) throws Exception {
        String string2;
        int n2;
        int n3 = 0;
        String[] stringArray = new String[n];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n2 = 0; n2 < n; ++n2) {
            Object object2 = Array.get(object, n2);
            string2 = this.orefRegistryLookup(object2);
            if (string2 != null) {
                stringArray[n3] = string2;
                ++n3;
                continue;
            }
            arrayList.add(object2);
        }
        if (arrayList.isEmpty()) {
            return stringArray;
        }
        SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_JAVA_OBJECT_CREATED);
        SysListProxy.setInteger(this.outMessage.wire, arrayList.size());
        SysListProxy.setString(this.outMessage.wire, TypeMap.getCacheClassName(string));
        this.outMessage.send(0);
        this.inMessage.readHeader();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            string2 = SysListProxy.getString(this.inMessage.wire);
            this.orefRegistry.put(string2, arrayList.get(n2));
            this.orefToClassMap.put(string2, string);
            stringArray[n3] = string2;
            ++n3;
        }
        return stringArray;
    }

    protected String getOref(String string, Object object) throws Exception {
        String string2 = this.orefRegistryLookup(object);
        if (string2 != null) {
            return string2;
        }
        SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_JAVA_OBJECT_CREATED);
        SysListProxy.setInteger(this.outMessage.wire, 1);
        SysListProxy.setString(this.outMessage.wire, TypeMap.getCacheClassName(string));
        this.outMessage.send(0);
        this.inMessage.readHeader();
        string2 = SysListProxy.getString(this.inMessage.wire);
        this.orefRegistry.put(string2, object);
        this.orefToClassMap.put(string2, string);
        SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_EXECUTE_METHOD);
        SysListProxy.setString(this.outMessage.wire, string);
        return string2;
    }

    protected void processException(Throwable throwable) throws Exception {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
            SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_EXCEPTION_RAISED);
            SysListProxy.setString(this.outMessage.wire, byteArrayOutputStream.toString());
            this.outMessage.send(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GatewayException(throwable.getMessage());
        }
    }

    protected HashMap getDependencies(Class clazz) throws Exception {
        HashSet hashSet = new HashSet();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        JavaCacheClassMapper javaCacheClassMapper = new JavaCacheClassMapper();
        javaCacheClassMapper.ignoreNestedGenerics();
        javaCacheClassMapper.setDefaultReplacement('$', "d");
        javaCacheClassMapper.setDefaultReplacement('_', "u");
        javaCacheClassMapper.setDefaultAccessLevel(1);
        javaCacheClassMapper.mapClass(clazz);
        javaCacheClassMapper.addExclusions(this.getExclusions());
        hashSet.addAll(javaCacheClassMapper.getDependencies(true));
        for (Object e : hashSet) {
            String string = ((Class)e).getName();
            if (this.exclude(string)) continue;
            hashMap.put(string, string);
        }
        return hashMap;
    }

    private String getClassLastCompiled(String string, String string2) throws Exception {
        String string3 = this.loadClass(string).getResource(string2 + ".class").getPath();
        String[] stringArray = string3.split("!");
        if (stringArray.length > 1) {
            string3 = stringArray[0].substring(5, stringArray[0].length());
        }
        return new Timestamp(new File(string3).lastModified()).toString();
    }

    protected String upToDate(String string, String string2) throws Exception {
        String string3 = this.getClassLastCompiled(string, string2);
        SysListProxy.writeHeader(this.outMessage.wire, MESSAGE_GET_TIMESTAMP);
        SysListProxy.setString(this.outMessage.wire, TypeMap.getCacheClassName(string));
        this.outMessage.send(0);
        if (this.inMessage.readHeader() != 36) {
            throw new GatewayException("Invalid timestamp for class: " + string);
        }
        String string4 = SysListProxy.getString(this.inMessage.wire);
        if (string3.equals(string4)) {
            return null;
        }
        return string3;
    }

    protected Object[] unmarshalOverloadParameters(int n, Class[] classArray) throws Exception {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            String string = SysListProxy.getString(this.inMessage.wire);
            Class clazz = TypeMap.getJavaClass(string);
            if (clazz == null) {
                clazz = this.loadClass(string);
            }
            classArray[i] = clazz;
            String string2 = clazz.getName();
            objectArray[i] = this.unmarshalParameter(clazz, string2);
        }
        return objectArray;
    }

    protected Object[] unmarshalParameters(int n, Class[] classArray) throws Exception {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.unmarshalParameter(classArray[i], classArray[i].getName());
        }
        return objectArray;
    }

    private Object unmarshalParameter(Class clazz, String string) throws Exception {
        if (clazz.isArray()) {
            return this.unmarshalArray();
        }
        if (string.equals("boolean")) {
            return SysListProxy.getBooleanWrapper(this.inMessage.wire);
        }
        if (string.equals("java.lang.Boolean")) {
            return SysListProxy.getBooleanWrapper(this.inMessage.wire);
        }
        if (string.equals("byte")) {
            byte[] byArray = SysListProxy.getByte(this.inMessage.wire);
            return new Byte(byArray[0]);
        }
        if (string.equals("double")) {
            return SysListProxy.getDoubleWrapper(this.inMessage.wire);
        }
        if (string.equals("java.lang.Double")) {
            return SysListProxy.getDoubleWrapper(this.inMessage.wire);
        }
        if (string.equals("float")) {
            return SysListProxy.getFloatWrapper(this.inMessage.wire);
        }
        if (string.equals("java.lang.Float")) {
            return SysListProxy.getFloatWrapper(this.inMessage.wire);
        }
        if (string.equals("int")) {
            return SysListProxy.getIntegerWrapper(this.inMessage.wire);
        }
        if (string.equals("java.lang.Integer")) {
            return SysListProxy.getIntegerWrapper(this.inMessage.wire);
        }
        if (string.equals("long")) {
            return SysListProxy.getLongWrapper(this.inMessage.wire);
        }
        if (string.equals("java.lang.Long")) {
            return SysListProxy.getLongWrapper(this.inMessage.wire);
        }
        if (string.equals("char")) {
            char[] cArray = SysListProxy.getString(this.inMessage.wire).toCharArray();
            return new Character(cArray[0]);
        }
        if (string.equals("short")) {
            return SysListProxy.getShortWrapper(this.inMessage.wire);
        }
        if (string.equals("java.lang.Short")) {
            return SysListProxy.getShortWrapper(this.inMessage.wire);
        }
        if (string.equals("java.lang.String")) {
            return SysListProxy.getString(this.inMessage.wire);
        }
        if (string.equals("java.lang.StringBuffer")) {
            return new StringBuffer(SysListProxy.getString(this.inMessage.wire));
        }
        if (string.equals("java.sql.Date")) {
            return SysListProxy.getSQLDate(this.inMessage.wire);
        }
        if (string.equals("java.sql.Time")) {
            return SysListProxy.getSQLTime(this.inMessage.wire);
        }
        if (string.equals("java.sql.Timestamp")) {
            return SysListProxy.getSQLTimestamp(this.inMessage.wire);
        }
        String string2 = SysListProxy.getString(this.inMessage.wire);
        Object v = this.orefRegistry.get(string2);
        if (v == null) {
            return string2;
        }
        return v;
    }

    protected void marshalReturnValue(Class clazz, Object object) throws Exception {
        Object object2;
        String string = clazz.getName();
        if (object != null && string.equals("java.lang.Object") && !Proxy.isProxyClass(object.getClass())) {
            string = object.getClass().getName();
        }
        if (TypeMap.isJavaDataType(string)) {
            object2 = (String)cacheTypes.get(string);
            SysListProxy.setString(this.outMessage.wire, (String)object2);
        }
        if (string.equals("int")) {
            SysListProxy.setIntegerWrapper(this.outMessage.wire, (Integer)object);
        } else if (string.equals("double")) {
            SysListProxy.setDoubleWrapper(this.outMessage.wire, (Double)object);
        } else if (string.equals("float")) {
            SysListProxy.setFloatWrapper(this.outMessage.wire, (Float)object);
        } else if (string.equals("boolean")) {
            SysListProxy.setBooleanWrapper(this.outMessage.wire, (Boolean)object);
        } else if (string.equals("short")) {
            SysListProxy.setShortWrapper(this.outMessage.wire, (Short)object);
        } else if (string.equals("long")) {
            SysListProxy.setLongWrapper(this.outMessage.wire, (Long)object);
        } else if (string.equals("java.lang.String")) {
            SysListProxy.setString(this.outMessage.wire, (String)object);
        } else if (string.equals("java.lang.Integer")) {
            SysListProxy.setIntegerWrapper(this.outMessage.wire, (Integer)object);
        } else if (string.equals("java.lang.Boolean")) {
            SysListProxy.setBooleanWrapper(this.outMessage.wire, (Boolean)object);
        } else if (string.equals("java.lang.Double")) {
            SysListProxy.setDoubleWrapper(this.outMessage.wire, (Double)object);
        } else if (string.equals("java.lang.Float")) {
            SysListProxy.setFloatWrapper(this.outMessage.wire, (Float)object);
        } else if (string.equals("java.lang.Long")) {
            SysListProxy.setLongWrapper(this.outMessage.wire, (Long)object);
        } else if (string.equals("java.lang.Short")) {
            SysListProxy.setShortWrapper(this.outMessage.wire, (Short)object);
        } else if (string.equals("java.sql.Date")) {
            SysListProxy.setSQLDate(this.outMessage.wire, (Date)object);
        } else if (string.equals("java.sql.Time")) {
            SysListProxy.setSQLTime(this.outMessage.wire, (Time)object);
        } else if (string.equals("java.sql.Timestamp")) {
            SysListProxy.setSQLTimestamp(this.outMessage.wire, (Timestamp)object);
        } else if (string.equals("byte")) {
            object2 = new byte[1];
            object2[0] = (Byte)object;
            SysListProxy.setByte(this.outMessage.wire, (byte[])object2);
        } else if (string.equals("char")) {
            SysListProxy.setString(this.outMessage.wire, ((Character)object).toString());
        } else if (clazz.isArray()) {
            this.marshalArray(object, string);
        } else {
            object2 = (String)cacheTypes.get(string);
            SysListProxy.setString(this.outMessage.wire, (String)object2);
            if (object == null) {
                SysListProxy.setString(this.outMessage.wire, null);
            } else {
                if (object2 == null || object2 == "") {
                    object2 = string;
                }
                SysListProxy.setString(this.outMessage.wire, this.getOref((String)object2, object));
            }
        }
    }

    protected boolean exclude(String string) {
        for (int i = 0; i < this.exclusions.size(); ++i) {
            if (!string.startsWith((String)this.exclusions.get(i))) continue;
            return true;
        }
        return false;
    }

    protected ArrayList getExclusions() {
        return this.exclusions;
    }

    static {
        systemClassLevel = 0;
        calledCache = new HashMap();
        cacheTypes = TypeMap.getCacheTypes();
        allMethods = new HashMap();
        allConstructors = new HashMap();
    }
}

