/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheDataSource;
import com.intersys.jdbc.CacheDriver;
import com.intersys.jdbc.CachePooledConnection;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class CacheConnectionPoolDataSource
extends CacheDataSource
implements ConnectionPoolDataSource {
    protected Vector pool = new Vector();
    protected int maxPoolSize = 40;
    protected int activeConnections = 0;

    public synchronized PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(this.user, this.password);
    }

    public synchronized PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        if (this.url == null) {
            this.url = "jdbc:Cache://" + this.server + ":" + this.port + "/" + this.database;
        }
        return CacheDriver.CPManager.lookup(this, string, string2);
    }

    public synchronized void restartConnectionPool() throws SQLException {
        for (int i = 0; i < this.pool.size(); ++i) {
            CachePooledConnection cachePooledConnection = (CachePooledConnection)this.pool.elementAt(i);
            cachePooledConnection.close();
        }
        this.pool.removeAllElements();
        this.activeConnections = 0;
    }

    public synchronized int getPoolCount() {
        return this.pool.size();
    }

    public synchronized void setMaxPoolSize(int n) {
        this.maxPoolSize = n;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }
}

