/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.FakeStream;
import com.intersys.jdbc.RealStream;
import com.intersys.jdbc.Stream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;

public class CacheInputStream
extends InputStream {
    private Stream stream = null;

    CacheInputStream(CacheConnection cacheConnection, String string, int n, int n2, int n3, int n4) throws SQLException {
        this.stream = new RealStream(cacheConnection, string, null, n, n2, n3, n4);
        ((RealStream)this.stream).getSize();
    }

    CacheInputStream(CacheConnection cacheConnection, byte[] byArray, int n, int n2) throws SQLException {
        this.stream = n2 == 0 ? new RealStream(cacheConnection, null, byArray, n, 1, -4, 0) : new RealStream(cacheConnection, null, byArray, n, 0, -1, 0);
        ((RealStream)this.stream).getSPStreamSize();
    }

    public CacheInputStream(CacheConnection cacheConnection, byte[] byArray, int n) throws SQLException {
        this.stream = n == 0 ? new RealStream(cacheConnection, null, byArray, 0, 1, -4, 0) : new RealStream(cacheConnection, null, byArray, 0, 0, -1, 0);
        ((RealStream)this.stream).getSizeOpen();
    }

    CacheInputStream(byte[] byArray, int n, int n2, int n3) throws SQLException {
        this.stream = new FakeStream(byArray, n, n2, n3);
    }

    public int available() throws IOException {
        return this.stream.available();
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) <= 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        try {
            int n3;
            int n4 = 0;
            do {
                if ((n3 = this.stream.fetchStream(byArray, n + n4, n2 - n4)) >= 0) continue;
                if (n4 == 0) {
                    return n3;
                }
                break;
            } while ((n4 += n3) < n2);
            return n4;
        }
        catch (Exception exception) {
            throw new IOException("Unable to read stream data: " + exception.getMessage());
        }
    }

    public void close() throws IOException {
        this.stream.close();
    }

    protected boolean isNull() {
        return this.stream.isNull();
    }

    protected final String toUnicodeString() throws SQLException {
        try {
            if (this.stream.size == 0) {
                return "";
            }
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this, "UTF-8");
            char[] cArray = new char[this.stream.size];
            int n = inputStreamReader.read(cArray);
            return new String(cArray, 0, n);
        }
        catch (Exception exception) {
            throw new SQLException("Error read stream data " + exception.getMessage(), "S1000");
        }
    }

    protected final byte[] toByte() throws SQLException {
        try {
            byte[] byArray = new byte[this.stream.size];
            this.read(byArray, 0, this.stream.size);
            return byArray;
        }
        catch (Exception exception) {
            throw new SQLException("Error reading stream data", "S1000");
        }
    }
}

