/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.InStream;
import com.intersys.jdbc.ListUtil;
import com.intersys.jdbc.OutStream;
import com.intersys.jdbc.Stream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.sql.SQLException;

class RealStream
extends Stream {
    protected CacheConnection connection;
    protected String streamOID;
    protected Object streamHandle;
    protected int cursorNumber = 0;
    protected InStream input;
    protected OutStream output;

    RealStream(CacheConnection cacheConnection, String string, Object object, int n, int n2, int n3, int n4) throws SQLException {
        super(n2, n3, n4);
        this.connection = cacheConnection;
        try {
            this.output = new OutStream(this.connection);
            this.output.wire.setConnectionInfo(this.connection.connectionInfo);
            this.input = new InStream(this.connection);
            this.input.wire.setConnectionInfo(this.connection.connectionInfo);
        }
        catch (IOException iOException) {
            throw new SQLException("[Cache JDBC] Communication link failure: " + iOException.getMessage(), "08S01", 461);
        }
        this.streamOID = string;
        this.streamHandle = object;
        this.cursorNumber = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void getSize() throws SQLException {
        try {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.output.wire.writeHeader(this.cursorNumber, CacheConnection.OPEN_STREAM);
                this.output.wire.set(this.streamOID);
                this.output.send(this.connection.messageCount.getCount());
                if (this.input.readHeader(this.cursorNumber, 0, 403) == 403) {
                    this.size = -1;
                    this.input.wire.isNull = true;
                    return;
                }
                this.streamHandle = this.input.wire.getByte();
                this.available = this.size = this.input.wire.getInt();
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error reading stream data: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void getSizeOpen() throws SQLException {
        if (this.streamHandle == null) {
            throw new SQLException("Null stream handle");
        }
        try {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.output.wire.writeHeader(this.cursorNumber, CacheConnection.RETRIEVE_STREAM);
                this.output.wire.setParameter(this.streamHandle);
                this.output.wire.set(0);
                this.output.send(this.connection.messageCount.getCount());
                if (this.input.readHeader(this.cursorNumber, 0, 403) == 403) {
                    this.size = -1;
                    this.input.wire.isNull = true;
                    return;
                }
                this.streamHandle = this.input.wire.getByte();
                this.available = this.size = this.input.wire.getInt();
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error reading stream data: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void getSPStreamSize() throws SQLException {
        if (this.streamHandle == null) {
            throw new SQLException("Null stream handle");
        }
        try {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.output.wire.writeHeader(this.cursorNumber, CacheConnection.GET_STORED_PROCEDURE_STREAM_SIZE);
                this.output.wire.setParameter(this.streamHandle);
                this.output.send(this.connection.messageCount.getCount());
                if (this.input.readHeader(this.cursorNumber, 0, 403) == 403) {
                    this.size = -1;
                    this.input.wire.isNull = true;
                    return;
                }
                this.available = this.size = this.input.wire.getInt();
            }
        }
        catch (Exception exception) {
            throw new SQLException("Error reading stream data: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized byte[] getByteStream(long l, int n) throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        if (n < 0 || l <= 0L || l > (long)this.size) {
            throw new SQLException("Invalid parameters: pos = " + l + " len = " + n);
        }
        if ((long)this.size - l < (long)n) {
            n = (int)((long)this.size - l + 1L);
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.cursorNumber, CacheConnection.STREAM_GET_BYTES);
            this.output.wire.setParameter(this.streamHandle);
            this.output.wire.set(l);
            this.output.wire.set(n);
            this.output.send(this.connection.messageCount.getCount());
            this.input.readHeader(this.cursorNumber, 2, 0);
            return this.input.getRawBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long getPosition(byte[] byArray, long l) throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.cursorNumber, CacheConnection.STREAM_GET_POSITION);
            this.output.wire.setParameter(this.streamHandle);
            this.output.wire.set(l);
            this.output.wire.set(byArray);
            this.output.send(this.connection.messageCount.getCount());
            this.input.readHeader(this.cursorNumber, 0, 0);
            return this.input.wire.getLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int fetchStream(Object object, int n, int n2) throws SQLException {
        int n3;
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        if (this.available <= 0 || this.maxStreamSize == 0) {
            return -1;
        }
        if (n2 > this.available) {
            n2 = this.available;
        }
        if (this.maxStreamSize > 0 && n2 > this.maxStreamSize) {
            n2 = this.maxStreamSize;
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.cursorNumber, CacheConnection.READ_STREAM);
            this.output.wire.setParameter(this.streamHandle);
            this.output.wire.set(n2);
            this.output.send(this.connection.messageCount.getCount());
            if (this.input.readHeader(this.cursorNumber, 2, 403) == 403) {
                return -1;
            }
            byte[] byArray = this.input.getRawBytes();
            n3 = ListUtil.readStream(byArray, object, n, this.streamType, this.sqlType);
            this.available -= n3;
            if (this.maxStreamSize != 0) {
                this.maxStreamSize -= n3;
            }
        }
        return n3;
    }

    protected boolean isNull() {
        if (this.size == -1) {
            return true;
        }
        return this.input.wire.isNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.size = 0;
        this.streamOID = null;
        if (this.available > 0) {
            try {
                CacheConnection.MessageCount messageCount = this.connection.messageCount;
                synchronized (messageCount) {
                    this.output.wire.writeHeader(this.cursorNumber, CacheConnection.CLOSE_STREAM);
                    this.output.wire.setParameter(this.streamHandle);
                    this.output.send(this.connection.messageCount.getCount());
                }
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        this.streamHandle = null;
        this.connection = null;
        this.available = 0;
        this.closed = true;
    }

    protected static Object sendStream(CacheConnection cacheConnection, Object object, int n, int n2, int n3, int n4) throws SQLException {
        return RealStream.sendStream(cacheConnection, object, n, n2, n3, n4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object sendStream(CacheConnection cacheConnection, Object object, int n, int n2, int n3, int n4, Object object2) throws SQLException {
        if (object2 == null) {
            object2 = new Integer(0);
        }
        try {
            while (true) {
                int n5 = n < 0 || n > 500000 ? 500000 : n;
                Object object3 = cacheConnection.messageCount;
                synchronized (object3) {
                    if (n2 == 4) {
                        cacheConnection.outMessage.wire.writeHeader(n4, CacheConnection.STORE_CHARACTER_STREAM);
                        cacheConnection.outMessage.wire.setParameter(object2);
                        cacheConnection.outMessage.wire.writeReader((Reader)object, n5);
                    } else if (n2 == 1) {
                        cacheConnection.outMessage.wire.writeHeader(n4, CacheConnection.STORE_BINARY_STREAM);
                        cacheConnection.outMessage.wire.setParameter(object2);
                        cacheConnection.outMessage.wire.writeInputStream((InputStream)object, n5, n2, n3);
                    } else {
                        cacheConnection.outMessage.wire.writeHeader(n4, CacheConnection.STORE_CHARACTER_STREAM);
                        cacheConnection.outMessage.wire.setParameter(object2);
                        cacheConnection.outMessage.wire.writeInputStream((InputStream)object, n5, n2, n3);
                    }
                    cacheConnection.outMessage.send(cacheConnection.messageCount.getCount());
                    cacheConnection.inMessage.readHeader(n4, 0, 0);
                    cacheConnection.outMessage.wire.reset();
                    object2 = cacheConnection.inMessage.wire.getByte();
                }
                if (n >= 0) {
                    if ((n -= n5) != 0) continue;
                    break;
                }
                if (n2 != 4) {
                    throw new SQLException("Negative length supported only with Reader", "S1000");
                }
                object3 = (Reader)object;
                int n6 = ((Reader)object3).read();
                if (n6 < 0) break;
                PushbackReader pushbackReader = object3 instanceof PushbackReader ? (PushbackReader)object3 : new PushbackReader((Reader)object3);
                pushbackReader.unread(n6);
                object = pushbackReader;
            }
            if (n2 != 4 && ((InputStream)object).markSupported() && !(object instanceof BufferedInputStream)) {
                try {
                    ((InputStream)object).reset();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException("Error writing stream: " + exception.getMessage());
        }
        return object2;
    }
}

