/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime.dynamic;

import com.intersys.classes.CacheRootObject;
import com.jalapeno.runtime.ObjectFactory;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class Proxy {
    private CacheRootObject mStaticProxy;
    private boolean mLoaded;

    private Proxy(CacheRootObject cacheRootObject) {
        this.mStaticProxy = cacheRootObject;
        this.mLoaded = false;
    }

    public static Object createDynamicProxy(CacheRootObject cacheRootObject, Class clazz) throws IllegalAccessException, InstantiationException {
        Proxy proxy = new Proxy(cacheRootObject);
        Object t = clazz.newInstance();
        Factory factory = (Factory)t;
        factory.setCallback(0, (Callback)proxy.getInterceptor());
        return t;
    }

    public static boolean isProxy(Object object) {
        return Enhancer.isEnhanced(object.getClass());
    }

    private MethodInterceptor getInterceptor() {
        return new Interceptor();
    }

    private synchronized void load(Object object) throws Exception {
        this.mLoaded = true;
        this.mStaticProxy.swizzleDefault(object);
    }

    private Object realObject() throws Exception {
        return this.mStaticProxy.detach(false);
    }

    private void swizzle(Object object) throws Exception {
        this.mStaticProxy.swizzleOneLevel(object);
    }

    private static boolean alwaysDispatchToSuper(Method method, int n) {
        String string;
        if (n == 0) {
            String string2 = method.getName();
            if ("hashCode".equals(string2)) {
                return true;
            }
            if ("finalize".equals(string2)) {
                return true;
            }
            if ("toString".equals(string2)) {
                return true;
            }
        } else if (n == 1 && "equals".equals(string = method.getName())) {
            return true;
        }
        return false;
    }

    static {
        ObjectFactory.dynamicProxyFactoryInitialized = true;
    }

    private class Interceptor
    implements MethodInterceptor {
        private Interceptor() {
        }

        public Object intercept(Object object, Method method, Object[] objectArray, MethodProxy methodProxy) throws Throwable {
            if (objectArray.length == 0) {
                String string = method.getName();
                if ("isLoaded".equals(string)) {
                    return new Boolean(Proxy.this.mLoaded);
                }
                if ("writeReplace".equals(string)) {
                    return Proxy.this.realObject();
                }
                if ("swizzle".equals(string)) {
                    Proxy.this.swizzle(object);
                    return null;
                }
                if ("unswizzle".equals(string)) {
                    Proxy.this.mLoaded = false;
                    return null;
                }
                if ("shadowObject_fetchData".equals(string)) {
                    if (!Proxy.this.mLoaded) {
                        Proxy.this.load(object);
                    }
                    return null;
                }
            }
            if (Proxy.this.mLoaded) {
                return methodProxy.invokeSuper(object, objectArray);
            }
            if (Proxy.alwaysDispatchToSuper(method, objectArray.length)) {
                return methodProxy.invokeSuper(object, objectArray);
            }
            if (Proxy.this.mStaticProxy.getDatabase().isLowLevelConnectionClosed()) {
                throw new IllegalStateException("Can not fetch data on shadow object when connection to database is closed.");
            }
            Proxy.this.load(object);
            return methodProxy.invokeSuper(object, objectArray);
        }
    }
}

