/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects.gui;

import com.intersys.cache.util.CacheInfo;
import com.jalapeno.tools.SchemaBuilder;
import com.jalapeno.tools.objects.common.Messages;
import com.jalapeno.tools.objects.gui.Helper;
import com.jalapeno.tools.objects.gui.RunPersisterWizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LoginPanel
extends RunPersisterWizardPanel {
    private JPanel jContentPane = null;
    private JLabel jLabelServer = null;
    private JTextField jServer = null;
    private JLabel jLabelPort = null;
    private JTextField jPort = null;
    private JLabel jLabelUser = null;
    private JTextField jUser = null;
    private JLabel jLabelPassword = null;
    private JPasswordField jPasswordField = null;
    private JLabel jLabelNamespace = null;
    private JComboBox jNamespace = null;
    private JPanel jConnectButtonPanel = null;
    private JButton jConnectButton = null;
    private JPanel jCreateLogFileOptionPanel;
    private JPanel jInstructionsPanel;
    private JPanel jConfigFileExistsPanel;
    private JTextPane jInstructions;
    private JTextPane jInstructionsConnect;
    private JTextPane jConfigFileExistsMessage;
    Component[] mComponents;
    int mComponentIndex = 0;
    private DefaultComboBoxModel mNamespaces;
    String mNamespace;
    ComboxBoxAdapter mAdapter;
    private static final String OK_BUTTON = "ChangeNamespaceDialog.5";
    private static final String CANCEL_BUTTON = "ChangeNamespaceDialog.6";
    private static final String LABEL_PORT = "ChangeNamespaceDialog.0";
    private static final String LABEL_PASSWORD = "ChangeNamespaceDialog.1";
    private static final String LABEL_NAMESPACE = "ChangeNamespaceDialog.2";
    private static final String LABEL_SERVER = "ChangeNamespaceDialog.3";
    private static final String LABEL_USER = "ChangeNamespaceDialog.4";
    private static final String INSTRUCTIONS_TEXT = Messages.getString("LoginPanel.PLEASE_ENTER_CONNECTION_DETAILS");
    private static final String CONFIG_FILE_EXISTS = Messages.getString("LoginPanel.CONFIG_FILE_EXISTS");
    private static final String CONFIG_FILE_DOES_NOT_EXIST = Messages.getString("LoginPanel.CONFIG_FILE_DOES_NOT_EXIST");
    private static final String LOGFILE_CHECKBOX_TEXT = Messages.getString("LoginPanel.CREATE_LOGFILE");
    private static final String DEFAULT_LOG_FILE_NAME = Messages.getString("LoginPanel.JDBC_LOG");
    private static final String INSTRUCTIONS_CONNECT = Messages.getString("LoginPanel.BE_SURE_TO_SELECT_CORRECT_NAMESPACE_BEFORE_CLICKING_NEXT");
    private static final String CONNECT_BUTTON = Messages.getString("LoginPanel.CONNECT");
    private boolean mIsConnected = false;
    private JLabel jBlankLabel;
    private static final int IPADY_FOR_BLANK_LABEL_SEPERATOR = 30;
    private boolean mFirstTimeThru = true;
    private JPanel jLoginPanel;
    private JPanel jShowNameSpacePanel;
    private DocumentListener mDocumentListener;

    public void setFromParent() {
        this.jServer.setText(this.getPersisterProperties().getHost());
        this.jPort.setText(this.getPersisterProperties().getPort());
        this.jUser.setText(this.getPersisterProperties().getUser());
        this.jPasswordField.setText(this.getPersisterProperties().getPassword());
        this.mNamespace = this.getPersisterProperties().getNameSpace();
        this.setNamespaces();
    }

    public void setNamespaces() {
        String string = this.jServer.getText();
        String string2 = this.jPort.getText();
        String string3 = this.jUser.getText();
        String string4 = new String(this.jPasswordField.getPassword());
        this.mNamespaces.removeAllElements();
        String[] stringArray = null;
        try {
            stringArray = this.getNamespaces(string, string2, string3, string4);
        }
        catch (Exception exception) {
            this.mIsConnected = false;
        }
        if (stringArray.length == 0) {
            this.mIsConnected = false;
        }
        if (this.mIsConnected) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.mNamespaces.addElement(stringArray[i]);
            }
            this.mNamespace = this.getPersisterProperties().getNameSpace();
            if (this.mNamespaces.getIndexOf(this.mNamespace) >= 0) {
                this.mNamespaces.setSelectedItem(this.mNamespace);
            } else {
                this.mNamespaces.setSelectedItem(null);
            }
            this.getPanelDescriptor().getWizard().setNextFinishButtonEnabled(true);
            this.jNamespace.setEnabled(true);
        } else {
            this.getPanelDescriptor().getWizard().setNextFinishButtonEnabled(false);
            this.jNamespace.setEnabled(false);
        }
        if (this.mIsConnected) {
            this.getPanelDescriptor().getWizard().setNextFinishButtonEnabled(true);
        } else {
            this.getPanelDescriptor().getWizard().setNextFinishButtonEnabled(false);
        }
    }

    public void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJRocketPanel(), "North");
        this.add((Component)this.getJContentPane(), "Center");
        this.setFromParent();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJInstructionsPanel(), Helper.getPanelGridBagConstraints(1, 0, 0, -1));
            this.jContentPane.add((Component)this.getJLoginPanel(), Helper.getPanelGridBagConstraints(1, 80, 0, -1));
            this.jContentPane.add((Component)this.getJShowNameSpacePanel(), Helper.getPanelGridBagConstraints(1, 80, 0, -1));
            this.jContentPane.add((Component)this.getJConfigFileExistsPanel(), Helper.getPanelGridBagConstraints(1, 0, 0, -1));
        }
        return this.jContentPane;
    }

    private JPanel getJLoginPanel() {
        if (this.jLoginPanel == null) {
            this.mDocumentListener = new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    LoginPanel.this.clearNamespaces();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    LoginPanel.this.clearNamespaces();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    LoginPanel.this.clearNamespaces();
                }
            };
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.jLabelNamespace = new JLabel();
            this.jBlankLabel = new JLabel();
            this.jLabelPassword = new JLabel();
            this.jLabelPort = new JLabel();
            this.jLabelServer = new JLabel();
            this.jLoginPanel = new JPanel();
            this.jLoginPanel.setLayout(new GridBagLayout());
            this.jLabelPort.setText(Messages.getString(LABEL_PORT));
            this.jLabelPassword.setText(Messages.getString(LABEL_PASSWORD));
            this.jLabelNamespace.setText(Messages.getString(LABEL_NAMESPACE));
            this.jLabelServer.setText(Messages.getString(LABEL_SERVER));
            int n = 10;
            this.jLoginPanel.add((Component)this.jLabelServer, Helper.getLeftLabelGridBagConstraints());
            this.jLoginPanel.add((Component)this.getJServer(), Helper.getTextFieldGridBagConstraints(1, -1, 0));
            this.mComponents = new Component[6];
            this.mComponents[0] = this.getJServer();
            this.jLoginPanel.add((Component)this.jLabelPort, Helper.getLeftLabelGridBagConstraints());
            this.jLoginPanel.add((Component)this.getJPort(), Helper.getTextFieldGridBagConstraints(1, -1, 0));
            this.mComponents[1] = this.getJPort();
            this.jLoginPanel.add((Component)this.getJLabelUser(), Helper.getLeftLabelGridBagConstraints());
            this.jLoginPanel.add((Component)this.getJUser(), Helper.getTextFieldGridBagConstraints(1, -1, 0));
            this.mComponents[2] = this.getJUser();
            this.jLoginPanel.add((Component)this.jLabelPassword, Helper.getLeftLabelGridBagConstraints());
            this.jLoginPanel.add((Component)this.getJPasswordField(), Helper.getTextFieldGridBagConstraints(1, -1, 0));
            this.mComponents[3] = this.getJPasswordField();
            this.mComponents[4] = this.getJShowNamespaceButton();
            this.mComponents[5] = this.getJNamespace();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.ipady = 30;
            this.jLoginPanel.add((Component)this.jBlankLabel, gridBagConstraints);
        }
        return this.jLoginPanel;
    }

    private JPanel getJShowNameSpacePanel() {
        if (this.jShowNameSpacePanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.jShowNameSpacePanel = new JPanel();
            this.jShowNameSpacePanel.setLayout(new GridBagLayout());
            this.jShowNameSpacePanel.add((Component)this.getJShowNamespaceButton(), Helper.getTextFieldGridBagConstraints(0, -1, 1, 0));
            this.jShowNameSpacePanel.add((Component)this.getJNamespace(), Helper.getTextFieldGridBagConstraints(1, -1, 0));
        }
        return this.jShowNameSpacePanel;
    }

    private JTextField getJServer() {
        if (this.jServer == null) {
            this.jServer = new JTextField();
            this.jServer.getDocument().addDocumentListener(this.mDocumentListener);
        }
        return this.jServer;
    }

    private JTextField getJPort() {
        if (this.jPort == null) {
            this.jPort = new JTextField();
            this.jPort.getDocument().addDocumentListener(this.mDocumentListener);
        }
        return this.jPort;
    }

    private void clearNamespaces() {
        this.mNamespaces.removeAllElements();
        this.getPanelDescriptor().getWizard().setNextFinishButtonEnabled(false);
    }

    private JLabel getJLabelUser() {
        if (this.jLabelUser == null) {
            this.jLabelUser = new JLabel();
            this.jLabelUser.setText(Messages.getString(LABEL_USER));
        }
        return this.jLabelUser;
    }

    private JTextField getJUser() {
        if (this.jUser == null) {
            this.jUser = new JTextField();
            this.jUser.getDocument().addDocumentListener(this.mDocumentListener);
        }
        return this.jUser;
    }

    private JPasswordField getJPasswordField() {
        if (this.jPasswordField == null) {
            this.jPasswordField = new JPasswordField();
            this.jPasswordField.getDocument().addDocumentListener(this.mDocumentListener);
        }
        return this.jPasswordField;
    }

    private JComboBox getJNamespace() {
        if (this.jNamespace == null) {
            this.mNamespaces = new DefaultComboBoxModel();
            this.jNamespace = new JComboBox(this.mNamespaces);
            this.mNamespaces.addListDataListener(this.jNamespace);
            this.jNamespace.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LoginPanel.this.mNamespace = (String)LoginPanel.this.mNamespaces.getSelectedItem();
                }
            });
        }
        return this.jNamespace;
    }

    public String[] getNamespaces(String string, String string2, String string3, String string4) {
        int n = Integer.parseInt(string2);
        try {
            String[] stringArray = CacheInfo.getNamespacesSimple(string, n, string3, string4);
            this.mIsConnected = stringArray.length != 0;
            return stringArray;
        }
        catch (UnknownHostException unknownHostException) {
            this.processConnectionException(unknownHostException);
            return new String[0];
        }
        catch (ConnectException connectException) {
            this.processConnectionException(connectException);
            return new String[0];
        }
        catch (Exception exception) {
            this.mIsConnected = false;
            if (!this.mFirstTimeThru) {
                String string5 = exception.getMessage();
                Pattern pattern = Pattern.compile(".*416.*");
                Matcher matcher = pattern.matcher(string5);
                if (matcher.matches()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    this.getMyParent();
                    String string6 = Helper.wordwrap(stringBuilder.append(Messages.getString("GeneratorGUI.60")).append(string5).toString());
                    JOptionPane.showMessageDialog(this.getMyParent().getWizard().getOwner(), string6);
                } else {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    exception.printStackTrace(printWriter);
                    String string7 = stringWriter.toString();
                    JOptionPane.showMessageDialog(this.getMyParent().getWizard().getOwner(), string7);
                }
            }
            this.mFirstTimeThru = false;
            return new String[0];
        }
    }

    public String getServer() {
        return this.jServer.getText();
    }

    public String getPort() {
        return this.jPort.getText();
    }

    public String getUser() {
        return this.jUser.getText();
    }

    public String getPassword() {
        return new String(this.jPasswordField.getPassword());
    }

    public String getNameSpace() {
        return this.mNamespace;
    }

    private JPanel getJInstructionsPanel() {
        if (this.jInstructionsPanel == null) {
            this.jInstructionsPanel = new JPanel();
            this.jInstructionsPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 12;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 1;
            this.jInstructionsPanel.add((Component)this.getJInstructions(), gridBagConstraints);
            this.jInstructionsPanel.add((Component)this.getJConnectInstructions(), gridBagConstraints2);
        }
        return this.jInstructionsPanel;
    }

    private JPanel getJConfigFileExistsPanel() {
        if (this.jConfigFileExistsPanel == null) {
            this.jConfigFileExistsPanel = new JPanel();
            this.jConfigFileExistsPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            this.jConfigFileExistsPanel.add((Component)this.getJConfigFileExistsMessage(), gridBagConstraints);
        }
        return this.jConfigFileExistsPanel;
    }

    private JTextPane getJInstructions() {
        if (this.jInstructions == null) {
            this.jInstructions = new JTextPane();
            this.jInstructions.setText(INSTRUCTIONS_TEXT);
            this.jInstructions.setEditable(false);
            this.jInstructions.setOpaque(false);
            this.jInstructions.setFocusable(false);
        }
        return this.jInstructions;
    }

    private JTextPane getJConfigFileExistsMessage() {
        if (this.jConfigFileExistsMessage == null) {
            this.jConfigFileExistsMessage = new JTextPane();
            if (LoginPanel.existsConfigFile()) {
                this.jConfigFileExistsMessage.setText(CONFIG_FILE_EXISTS);
            } else {
                this.jConfigFileExistsMessage.setText(CONFIG_FILE_DOES_NOT_EXIST);
            }
            this.jConfigFileExistsMessage.setEditable(false);
            this.jConfigFileExistsMessage.setOpaque(false);
            this.jConfigFileExistsMessage.setFocusable(false);
        }
        return this.jConfigFileExistsMessage;
    }

    private JTextPane getJConnectInstructions() {
        if (this.jInstructionsConnect == null) {
            this.jInstructionsConnect = new JTextPane();
            this.jInstructionsConnect.setText(INSTRUCTIONS_CONNECT);
            this.jInstructionsConnect.setEditable(false);
            this.jInstructionsConnect.setOpaque(false);
            this.jInstructionsConnect.setFocusable(false);
        }
        return this.jInstructionsConnect;
    }

    public void selectLogFileIfChecked() {
    }

    public JPanel getJConnectButtonPanel() {
        if (this.jConnectButtonPanel == null) {
            this.jConnectButtonPanel = new JPanel();
            this.jConnectButtonPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 10;
            this.jConnectButtonPanel.add((Component)this.getJShowNamespaceButton(), gridBagConstraints);
        }
        return this.jConnectButtonPanel;
    }

    public JButton getJShowNamespaceButton() {
        if (this.jConnectButton == null) {
            this.jConnectButton = new JButton(CONNECT_BUTTON);
            this.jConnectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LoginPanel.this.setNamespaces();
                }
            });
        }
        return this.jConnectButton;
    }

    public boolean getConnected() {
        return this.mIsConnected;
    }

    public void processConnectionException(Exception exception) {
        this.mIsConnected = false;
        if (!this.mFirstTimeThru) {
            StringBuilder stringBuilder = new StringBuilder();
            this.getMyParent();
            String string = Helper.wordwrap(stringBuilder.append(Messages.getString("GeneratorGUI.60")).append(exception.getMessage()).toString());
            JOptionPane.showMessageDialog(this.getMyParent().getWizard().getOwner(), string);
        }
        this.mFirstTimeThru = false;
    }

    public static boolean existsConfigFile() {
        String string = SchemaBuilder.CONFIG_FILE_NAME;
        boolean bl = true;
        FileInputStream fileInputStream = null;
        File file = null;
        Properties properties = new Properties();
        try {
            file = new File(string);
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            bl = false;
        }
        if (bl) {
            try {
                properties.load(fileInputStream);
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
        return false;
    }

    class ComboxBoxAdapter
    implements ActionListener {
        ComboxBoxAdapter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = LoginPanel.this.jNamespace.getSelectedItem();
            if (object != null) {
                LoginPanel.this.mNamespace = (String)object;
            }
        }
    }

    private class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            ++LoginPanel.this.mComponentIndex;
            if (LoginPanel.this.mComponentIndex >= LoginPanel.this.mComponents.length) {
                LoginPanel.this.mComponentIndex = 0;
            }
            return LoginPanel.this.mComponents[LoginPanel.this.mComponentIndex];
        }

        public Component getComponentBefore(Container container, Component component) {
            --LoginPanel.this.mComponentIndex;
            if (LoginPanel.this.mComponentIndex < 0) {
                LoginPanel.this.mComponentIndex = LoginPanel.this.mComponents.length - 1;
            }
            return LoginPanel.this.mComponents[LoginPanel.this.mComponentIndex];
        }

        public Component getLastComponent(Container container) {
            LoginPanel.this.mComponentIndex = LoginPanel.this.mComponents.length - 1;
            return LoginPanel.this.mComponents[LoginPanel.this.mComponentIndex];
        }

        public Component getFirstComponent(Container container) {
            LoginPanel.this.mComponentIndex = 0;
            return LoginPanel.this.mComponents[LoginPanel.this.mComponentIndex];
        }

        public Component getDefaultComponent(Container container) {
            LoginPanel.this.mComponentIndex = 0;
            return LoginPanel.this.mComponents[LoginPanel.this.mComponentIndex];
        }
    }
}

