/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.DBProcParameterInfo;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.translators.AbstractABAPStreamGetval;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import java.sql.SQLException;

public abstract class StructMemberTranslator {
    protected DBProcParameterInfo.StructureElement structureElement;
    protected int index;
    protected int offset;

    public StructMemberTranslator(DBProcParameterInfo.StructureElement structureElement, int n, boolean bl) {
        this.structureElement = structureElement;
        this.index = n;
        this.offset = bl ? structureElement.unicodeOffset : structureElement.asciiOffset;
    }

    public abstract Object getObject(StructuredMem var1, int var2);

    public abstract void putObject(StructuredMem var1, Object var2) throws SQLException;

    public abstract void addOutStreamDescriptor(AbstractABAPStreamGetval var1) throws SQLException;

    protected void throwConversionError(String string) throws SQLException {
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.structure.element.conversion", this.structureElement.getSQLTypeName(), string));
    }

    public static StructMemberTranslator createStructMemberTranslator(DBProcParameterInfo dBProcParameterInfo, int n, boolean bl) throws SQLException {
        DBProcParameterInfo.StructureElement structureElement = dBProcParameterInfo.getMember(n);
        if (structureElement.typeName.equals("CHAR")) {
            if (structureElement.codeType.equals("BYTE")) {
                return new ByteStructureElementTranslator(structureElement, n, bl);
            }
            if (structureElement.codeType.equals("ASCII")) {
                return new CharAsciiStructureElementTranslator(structureElement, n, bl);
            }
        } else {
            if (structureElement.typeName.equals("WYDE")) {
                if (bl) {
                    return new WydeStructureElementTranslator(structureElement, n, bl);
                }
                return new CharAsciiStructureElementTranslator(structureElement, n, bl);
            }
            if (structureElement.typeName.equals("SMALLINT")) {
                if (structureElement.length == 5) {
                    return new ShortStructureElementTranslator(structureElement, n, bl);
                }
            } else if (structureElement.typeName.equals("INTEGER")) {
                if (structureElement.length == 10) {
                    return new IntStructureElementTranslator(structureElement, n, bl);
                }
                if (structureElement.length == 19) {
                    return new LongStructureElementTranslator(structureElement, n, bl);
                }
            } else if (structureElement.typeName.equals("FIXED")) {
                if (structureElement.precision == 0) {
                    if (structureElement.length == 5) {
                        return new ShortStructureElementTranslator(structureElement, n, bl);
                    }
                    if (structureElement.length == 10) {
                        return new IntStructureElementTranslator(structureElement, n, bl);
                    }
                    if (structureElement.length == 19) {
                        return new LongStructureElementTranslator(structureElement, n, bl);
                    }
                }
            } else if (structureElement.typeName.equals("FLOAT")) {
                if (structureElement.length == 15) {
                    return new DoubleStructureElementTranslator(structureElement, n, bl);
                }
                if (structureElement.length == 6) {
                    return new FloatStructureElementTranslator(structureElement, n, bl);
                }
            } else if (structureElement.typeName.equals("BOOLEAN")) {
                return new BooleanStructureElementTranslator(structureElement, n, bl);
            }
        }
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.conversion.structuretype", new Integer(n), structureElement.getSQLTypeName()));
    }

    public static StructMemberTranslator[] createStructMemberTranslators(DBProcParameterInfo dBProcParameterInfo, boolean bl) throws SQLException {
        StructMemberTranslator[] structMemberTranslatorArray = new StructMemberTranslator[dBProcParameterInfo.getMemberCount()];
        for (int i = 0; i < structMemberTranslatorArray.length; ++i) {
            structMemberTranslatorArray[i] = StructMemberTranslator.createStructMemberTranslator(dBProcParameterInfo, i, bl);
        }
        return structMemberTranslatorArray;
    }

    static class BooleanStructureElementTranslator
    extends StructMemberTranslator {
        public BooleanStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int n, boolean bl) {
            super(structureElement, n, bl);
        }

        public Object getObject(StructuredMem structuredMem, int n) {
            byte by = structuredMem.getInt1(this.offset + n);
            if (by == 0) {
                return new Boolean(false);
            }
            return new Boolean(true);
        }

        public void putObject(StructuredMem structuredMem, Object object) throws SQLException {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (bl) {
                    structuredMem.putInt1(1, this.offset);
                } else {
                    structuredMem.putInt1(0, this.offset);
                }
            } else {
                this.throwConversionError(object.getClass().getName());
            }
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval abstractABAPStreamGetval) throws SQLException {
            abstractABAPStreamGetval.addColumn(1, 1, 1, 0, 1, this.offset);
        }
    }

    static class FloatStructureElementTranslator
    extends StructMemberTranslator {
        public FloatStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int n, boolean bl) {
            super(structureElement, n, bl);
        }

        public Object getObject(StructuredMem structuredMem, int n) {
            int n2 = structuredMem.getInt4(this.offset);
            return new Float(Float.intBitsToFloat(n2));
        }

        public void putObject(StructuredMem structuredMem, Object object) throws SQLException {
            if (object instanceof Float) {
                float f = ((Float)object).floatValue();
                int n = Float.floatToIntBits(f);
                structuredMem.putInt4(n, this.offset);
            } else if (object instanceof Number) {
                double d = ((Number)object).doubleValue();
                if (d > 3.4028234663852886E38 || d < (double)1.4E-45f) {
                    throw new SQLExceptionSapDB(MessageTranslator.translate("error.structure.element.overflow", this.structureElement.getSQLTypeName(), object.toString()));
                }
                float f = ((Number)object).floatValue();
                int n = Float.floatToIntBits(f);
                structuredMem.putInt4(n, this.offset);
            } else {
                this.throwConversionError(object.getClass().getName());
            }
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval abstractABAPStreamGetval) throws SQLException {
            abstractABAPStreamGetval.addColumn(1, 9, 4, 0, 1, this.offset);
        }
    }

    static class DoubleStructureElementTranslator
    extends StructMemberTranslator {
        public DoubleStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int n, boolean bl) {
            super(structureElement, n, bl);
        }

        public Object getObject(StructuredMem structuredMem, int n) {
            long l = structuredMem.getInt8(this.offset + n);
            return new Double(Double.longBitsToDouble(l));
        }

        public void putObject(StructuredMem structuredMem, Object object) throws SQLException {
            if (object instanceof Number) {
                double d = ((Number)object).doubleValue();
                long l = Double.doubleToLongBits(d);
                structuredMem.putInt8(l, this.offset);
            } else {
                this.throwConversionError(object.getClass().getName());
            }
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval abstractABAPStreamGetval) throws SQLException {
            abstractABAPStreamGetval.addColumn(1, 10, 8, 0, 1, this.offset);
        }
    }

    static class LongStructureElementTranslator
    extends StructMemberTranslator {
        public LongStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int n, boolean bl) {
            super(structureElement, n, bl);
        }

        public Object getObject(StructuredMem structuredMem, int n) {
            long l = structuredMem.getInt8(this.offset + n);
            return new Long(l);
        }

        public void putObject(StructuredMem structuredMem, Object object) throws SQLException {
            if (object instanceof Long) {
                long l = (Long)object;
                structuredMem.putInt8(l, this.offset);
            } else if (object instanceof Number) {
                double d = ((Number)object).doubleValue();
                if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
                    throw new SQLExceptionSapDB(MessageTranslator.translate("error.structure.element.overflow", this.structureElement.getSQLTypeName(), object.toString()));
                }
                long l = ((Number)object).longValue();
                structuredMem.putInt8(l, this.offset);
            } else {
                this.throwConversionError(object.getClass().getName());
            }
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval abstractABAPStreamGetval) throws SQLException {
            abstractABAPStreamGetval.addColumn(1, 7, 8, 0, 1, this.offset);
        }
    }

    static class IntStructureElementTranslator
    extends StructMemberTranslator {
        public IntStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int n, boolean bl) {
            super(structureElement, n, bl);
        }

        public Object getObject(StructuredMem structuredMem, int n) {
            int n2 = structuredMem.getInt4(this.offset + n);
            return new Integer(n2);
        }

        public void putObject(StructuredMem structuredMem, Object object) throws SQLException {
            if (object instanceof Integer) {
                int n = (Integer)object;
                structuredMem.putInt4(n, this.offset);
            } else if (object instanceof Number) {
                double d = ((Number)object).doubleValue();
                if (d > 2.147483647E9 || d < -2.147483648E9) {
                    throw new SQLExceptionSapDB(MessageTranslator.translate("error.structure.element.overflow", this.structureElement.getSQLTypeName(), object.toString()));
                }
                int n = ((Number)object).intValue();
                structuredMem.putInt4(n, this.offset);
            } else {
                this.throwConversionError(object.getClass().getName());
            }
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval abstractABAPStreamGetval) throws SQLException {
            abstractABAPStreamGetval.addColumn(1, 5, 4, 0, 1, this.offset);
        }
    }

    static class ShortStructureElementTranslator
    extends StructMemberTranslator {
        public ShortStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int n, boolean bl) {
            super(structureElement, n, bl);
        }

        public Object getObject(StructuredMem structuredMem, int n) {
            int n2 = structuredMem.getInt2(this.offset + n);
            return new Short((short)n2);
        }

        public void putObject(StructuredMem structuredMem, Object object) throws SQLException {
            if (object instanceof Short) {
                short s = (Short)object;
                structuredMem.putInt2(s, this.offset);
            } else if (object instanceof Number) {
                double d = ((Number)object).doubleValue();
                if (d > 32767.0 || d < -32768.0) {
                    throw new SQLExceptionSapDB(MessageTranslator.translate("error.structure.element.overflow", this.structureElement.getSQLTypeName(), object.toString()));
                }
                short s = ((Number)object).shortValue();
                structuredMem.putInt2(s, this.offset);
            } else {
                this.throwConversionError(object.getClass().getName());
            }
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval abstractABAPStreamGetval) throws SQLException {
            abstractABAPStreamGetval.addColumn(1, 3, 2, 0, 1, this.offset);
        }
    }

    static class WydeStructureElementTranslator
    extends StructMemberTranslator {
        public WydeStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int n, boolean bl) {
            super(structureElement, n, bl);
        }

        public Object getObject(StructuredMem structuredMem, int n) {
            char[] cArray = structuredMem.getBigUnicode(this.offset + n, this.structureElement.length * 2);
            if (this.structureElement.length == 1) {
                return new Character(cArray[0]);
            }
            return new String(cArray);
        }

        public void putObject(StructuredMem structuredMem, Object object) throws SQLException {
            String string = null;
            if (object instanceof char[]) {
                string = new String((char[])object);
            } else if (object instanceof String) {
                string = (String)object;
            } else if (object instanceof Character) {
                char[] cArray = new char[]{((Character)object).charValue()};
                string = new String(cArray);
            } else {
                this.throwConversionError(object.getClass().getName());
            }
            structuredMem.putBigUnicode(string.toCharArray(), this.offset, this.structureElement.length * 2);
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval abstractABAPStreamGetval) throws SQLException {
            abstractABAPStreamGetval.addColumn(1, 17, this.structureElement.length * 2, 0, this.structureElement.length, this.offset);
        }
    }

    static class CharAsciiStructureElementTranslator
    extends StructMemberTranslator {
        public CharAsciiStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int n, boolean bl) {
            super(structureElement, n, bl);
        }

        public Object getObject(StructuredMem structuredMem, int n) {
            byte[] byArray = structuredMem.getBytes(this.offset + n, this.structureElement.length);
            if (this.structureElement.length == 1) {
                return new Character((char)byArray[0]);
            }
            return new String(byArray);
        }

        public void putObject(StructuredMem structuredMem, Object object) throws SQLException {
            Object[] objectArray;
            String string = null;
            if (object instanceof char[]) {
                string = new String((char[])object);
            } else if (object instanceof String) {
                string = (String)object;
            } else if (object instanceof Character) {
                objectArray = new char[]{((Character)object).charValue()};
                string = new String((char[])objectArray);
            } else {
                this.throwConversionError(object.getClass().getName());
            }
            objectArray = StringUtil.bytes_ascii7bit(string);
            structuredMem.putStringBytes((byte[])objectArray, this.offset, this.structureElement.length);
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval abstractABAPStreamGetval) throws SQLException {
            abstractABAPStreamGetval.addColumn(1, 14, this.structureElement.length, 0, this.structureElement.length, this.offset);
        }
    }

    static class ByteStructureElementTranslator
    extends StructMemberTranslator {
        public ByteStructureElementTranslator(DBProcParameterInfo.StructureElement structureElement, int n, boolean bl) {
            super(structureElement, n, bl);
        }

        public Object getObject(StructuredMem structuredMem, int n) {
            byte[] byArray = structuredMem.getBytes(this.offset + n, this.structureElement.length);
            StructuredBytes structuredBytes = new StructuredBytes(byArray);
            structuredBytes.traceOn(System.err);
            if (this.structureElement.length == 1) {
                return new Byte(byArray[0]);
            }
            return byArray;
        }

        public void putObject(StructuredMem structuredMem, Object object) throws SQLException {
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                structuredMem.putBytes(byArray, this.offset);
            } else if (object instanceof Byte) {
                byte[] byArray = new byte[]{(Byte)object};
            } else {
                this.throwConversionError(object.getClass().getName());
            }
        }

        public void addOutStreamDescriptor(AbstractABAPStreamGetval abstractABAPStreamGetval) throws SQLException {
            abstractABAPStreamGetval.addColumn(1, 14, this.structureElement.length, 0, this.structureElement.length, this.offset);
        }
    }
}

