/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.tds.DataFormat;
import com.sybase.jdbc3.tds.Dumpable;
import com.sybase.jdbc3.tds.SrvDataFormat;
import com.sybase.jdbc3.tds.SrvFormatToken;
import com.sybase.jdbc3.tds.TdsInputStream;
import com.sybase.jdbc3.tds.TdsOutputStream;
import com.sybase.jdbc3.tds.Token;
import com.sybase.jdbc3.utils.DumpFilter;
import com.sybase.jdbc3.utils.DumpInfo;
import com.sybase.jdbc3.utils.HexConverts;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class SrvAltFmtToken
extends Token
implements SrvFormatToken,
Dumpable {
    protected int _totalLen;
    protected int _id;
    protected int _noOperators;
    protected Vector _operators;
    protected int _noByColumns;
    protected Vector _columns;

    public SrvAltFmtToken(TdsInputStream tdsInputStream) throws IOException {
        int n;
        this._totalLen = tdsInputStream.readShort();
        this._id = tdsInputStream.readShort();
        this._noOperators = tdsInputStream.readUnsignedByte();
        this._operators = new Vector();
        for (n = 0; n < this._noOperators; ++n) {
            OperatorInfo operatorInfo = new OperatorInfo(tdsInputStream);
            this._operators.addElement(operatorInfo);
        }
        this._columns = new Vector();
        this._noByColumns = tdsInputStream.readUnsignedByte();
        for (n = 0; n < this._noByColumns; ++n) {
            this._columns.addElement(new Integer(tdsInputStream.readUnsignedByte()));
        }
    }

    public int getId() {
        return this._id;
    }

    public void addFormat(DataFormat dataFormat) {
    }

    public int getLength() {
        return 0;
    }

    public int getFormatCount() {
        return this._noOperators;
    }

    public DataFormat formatAt(int n) {
        return (SrvDataFormat)this._operators.elementAt(n);
    }

    public void sendFormat(TdsOutputStream tdsOutputStream) throws IOException {
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(168)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "ALTFMT Token (0x" + HexConverts.hexConvert((int)168, (int)1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "ALTFMT Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._totalLen);
            }
            if (dumpFilter.includesDetail(3) || dumpFilter.includesDetail(7)) {
                Object object;
                dumpInfo.addInt("ID", 2, this._id);
                dumpInfo.addInt("Number of Operators", 1, this._noOperators);
                Enumeration enumeration = this._operators.elements();
                int n = 1;
                while (enumeration.hasMoreElements()) {
                    dumpInfo.addInfo("TDSFmt", 0, "Operator " + n++);
                    object = (OperatorInfo)enumeration.nextElement();
                    dumpInfo.addInfo(((OperatorInfo)object).dump(dumpFilter));
                }
                dumpInfo.addInt("Number of By Columns", 1, this._noByColumns);
                enumeration = this._columns.elements();
                n = 1;
                while (enumeration.hasMoreElements()) {
                    dumpInfo.addInfo("TDSFmt", 0, "Column " + n++);
                    object = (Integer)enumeration.nextElement();
                    dumpInfo.addInt("", 1, ((Integer)object).intValue());
                }
            }
        }
        return dumpInfo;
    }

    public int getTokenType() {
        return 168;
    }

    class OperatorInfo
    extends SrvDataFormat
    implements Dumpable {
        private int _opType;
        private int _opColNo;

        protected OperatorInfo(TdsInputStream tdsInputStream) throws IOException {
            this._opType = tdsInputStream.readUnsignedByte();
            this._opColNo = tdsInputStream.readUnsignedByte();
            this._usertype = tdsInputStream.readInt();
            this._datatype = tdsInputStream.readUnsignedByte();
            switch (DataFormat.lengthSize((int)this._datatype)) {
                case 1: {
                    this._length = tdsInputStream.readUnsignedByte();
                    break;
                }
                case 2: {
                    this._length = tdsInputStream.readShort();
                    break;
                }
                case 4: {
                    this._length = tdsInputStream.readInt();
                }
            }
            this._localeLen = tdsInputStream.readUnsignedByte();
            if (this._localeLen != 0) {
                this._locale = tdsInputStream.readString(this._localeLen);
            }
        }

        public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
            DumpInfo dumpInfo = dumpFilter.getDumpInfo();
            dumpInfo.addInfo("Operator Type", 1, this.getOperatorTypeString(this._opType));
            dumpInfo.addInt("Column Number", 1, this._opColNo);
            dumpInfo.addHex("User Type", 4, this._usertype);
            dumpInfo.addInfo("Data Type", 1, DataFormat.getDataTypeString((int)this._datatype));
            if (dumpFilter.includesDetail(1) && DataFormat.lengthSize((int)this._datatype) > 0) {
                dumpInfo.addInt("Length", DataFormat.lengthSize((int)this._datatype), this._length);
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Locale Length", 1, this._localeLen);
            }
            if (this._localeLen > 0) {
                dumpInfo.addText("Locale", this._localeLen, this._locale);
            }
            return dumpInfo;
        }

        public int getTokenType() {
            return -1;
        }

        private String getOperatorTypeString(int n) {
            String string;
            switch (n) {
                case 79: {
                    string = "ALT_AVG";
                    break;
                }
                case 75: {
                    string = "ALT_COUNT";
                    break;
                }
                case 82: {
                    string = "ALT_MAX";
                    break;
                }
                case 81: {
                    string = "ALT_MIN";
                    break;
                }
                case 77: {
                    string = "ALT_SUM";
                    break;
                }
                default: {
                    string = "<unrecognized>";
                }
            }
            return string;
        }
    }
}

