/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.util.IfxErrMsg;
import com.informix.util.dateUtil;
import com.informix.util.memoryUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class IfxVarChar
extends IfxObject {
    private static final int h = 255;
    protected String value;

    IfxVarChar() throws SQLException {
        this.setIfxType(13);
    }

    IfxVarChar(String string) throws SQLException {
        block3: {
            block2: {
                this.setIfxType(13);
                this.value = string;
                if (this.value != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.unnullify();
        }
    }

    public byte[] toIfx() throws SQLException {
        try {
            String string = this.conn.getdbEncoding();
            return ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, string);
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public byte[] toIfxTuple() throws SQLException {
        try {
            block6: {
                byte[] byArray;
                block8: {
                    block7: {
                        if (!this.isNull()) break block6;
                        if (!((IfxSqliConnect)this.conn).r()) break block7;
                        byArray = new byte[2];
                        if (!IfxSqliConnect.db) break block8;
                    }
                    byArray = new byte[this.encodedLength + 1];
                }
                memoryUtil.byfill(byArray, (byte)0);
                byArray[0] = 1;
                return byArray;
            }
            String string = this.conn.getdbEncoding();
            byte[] byArray = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxVarChar(this.value, string, this.encodedLength);
            if (((IfxSqliConnect)this.conn).r()) {
                int n = 1 + (0xFF & byArray[0]);
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                return byArray2;
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        try {
            block9: {
                int n3;
                block8: {
                    n3 = byArray[n] & 0xFF;
                    if (n3 == 1 && byArray[n + 1] == 0) {
                        this.value = null;
                        this.nullify();
                        return;
                    }
                    if (n3 != 0) break block8;
                    this.value = new String("");
                    if (!IfxSqliConnect.db) break block9;
                }
                String string = this.conn.getdbEncoding();
                if (n2 > 0) {
                    n3 = Math.min(n3, n2);
                }
                if (((IfxSqliConnect)this.conn).isOnLine5SER()) {
                    string = "NOCODING";
                }
                this.value = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, n + 1, n3, string);
            }
            this.unnullify();
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public byte[] toBytes() throws SQLException {
        byte[] byArray;
        block3: {
            block4: {
                byArray = null;
                if (this.value != null) break block4;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            try {
                String string = ((IfxSqliConnect)this.conn).returnEnc();
                byte[] byArray2 = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, string);
                int n = byArray2.length;
                byArray = new byte[n - 2];
                System.arraycopy(byArray2, 2, byArray, 0, n - 2);
            }
            catch (Exception exception) {
                this.value = null;
                if (!(exception instanceof IOException)) break block3;
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
        return byArray;
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        IfxSqliConnect cfr_ignored_0 = (IfxSqliConnect)this.conn;
        if (IfxSqliConnect.GclEnv) {
            IfxSqliConnect cfr_ignored_1 = (IfxSqliConnect)this.conn;
            if (IfxSqliConnect.ConnEst) {
                try {
                    byte[] byArray = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, ((IfxSqliConnect)this.conn).returnEnc());
                    this.value = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, 2, byArray.length - 2, ((IfxSqliConnect)this.conn).returnEnc());
                    IfxSqliConnect cfr_ignored_2 = (IfxSqliConnect)this.conn;
                    IfxSqliConnect.GclEnv = false;
                    return this.value;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
        }
        return this.value;
    }

    public void fromString(String string) throws SQLException {
        this.fromString(string, false);
    }

    public void fromString(String string, boolean bl) throws SQLException {
        block4: {
            boolean bl2;
            block5: {
                bl2 = IfxSqliConnect.db;
                if (string != null) break block5;
                this.nullify();
                if (!bl2) break block4;
            }
            try {
                block7: {
                    String string2;
                    block6: {
                        this.clearWarning();
                        string2 = null;
                        string2 = bl ? string.trim() : string;
                        if (string2.length() <= 255) break block6;
                        this.value = string2.substring(0, 255);
                        if (!bl2) break block7;
                    }
                    this.value = string2;
                }
                String string3 = this.conn.getdbEncoding();
                byte[] byArray = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, string3);
                this.value = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, 2, byArray.length - 2, string3);
                this.unnullify();
            }
            catch (Exception exception) {
                this.value = null;
                exception.printStackTrace();
                if (!(exception instanceof IOException)) break block4;
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
    }

    public void fromBytes(byte[] byArray) throws SQLException {
        block4: {
            block5: {
                if (byArray != null) break block5;
                this.nullify();
                if (!IfxSqliConnect.db) break block4;
            }
            try {
                int n = byArray.length;
                if (byArray.length > 255) {
                    n = 255;
                }
                String string = this.conn.getdbEncoding();
                this.value = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray, 0, n, string);
                this.unnullify();
            }
            catch (Exception exception) {
                this.value = null;
                if (!(exception instanceof IOException)) break block4;
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
    }

    public byte toByte() throws SQLException {
        byte by;
        if (this.isNull()) {
            return 0;
        }
        try {
            by = Byte.parseByte(this.value);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return by;
    }

    public void fromByte(Byte by) throws SQLException {
        block3: {
            block2: {
                if (by != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.fromByte((byte)by);
        }
    }

    public void fromByte(byte by) throws SQLException {
        this.value = String.valueOf(by);
        this.unnullify();
    }

    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value.equalsIgnoreCase("1") || this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("t");
    }

    public void fromBoolean(Boolean bl) throws SQLException {
        block3: {
            block2: {
                if (bl != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.fromBoolean((boolean)bl);
        }
    }

    public void fromBoolean(boolean bl) throws SQLException {
        block3: {
            block2: {
                if (!bl) break block2;
                this.value = "true";
                if (!IfxSqliConnect.db) break block3;
            }
            this.value = "false";
        }
        this.unnullify();
    }

    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Integer n = new Integer(this.value);
            return n;
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    public void fromInt(Integer n) throws SQLException {
        block3: {
            block2: {
                if (n != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.fromInt((int)n);
        }
    }

    public void fromInt(int n) throws SQLException {
        this.value = Integer.toString(n);
        this.unnullify();
    }

    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        block3: {
            block2: {
                if (bigDecimal != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.value = bigDecimal.toString();
            this.unnullify();
        }
    }

    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Short s = new Short(this.value);
            return s;
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    public void fromShort(Short s) throws SQLException {
        block3: {
            block2: {
                if (s != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.fromShort((short)s);
        }
    }

    public void fromShort(short s) throws SQLException {
        this.value = String.valueOf(s);
        this.unnullify();
    }

    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.value);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    public void fromLong(Long l2) throws SQLException {
        block3: {
            block2: {
                if (l2 != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.fromLong((long)l2);
        }
    }

    public void fromLong(long l2) throws SQLException {
        this.value = String.valueOf(l2);
        this.unnullify();
    }

    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        Float f2 = Float.valueOf(this.value);
        return f2.floatValue();
    }

    public void fromFloat(Float f2) throws SQLException {
        block3: {
            block2: {
                if (f2 != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.fromFloat(f2.floatValue());
        }
    }

    public void fromFloat(float f2) throws SQLException {
        this.value = String.valueOf(f2);
        this.unnullify();
    }

    public Date toDate() throws SQLException {
        Date date = null;
        if (this.isNull()) {
            return null;
        }
        try {
            date = dateUtil.convertDateObj(this.value, this.conn);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return date;
    }

    public void fromDate(Date date) throws SQLException {
        block3: {
            block2: {
                if (date != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.value = dateUtil.convertDateStr(date, this.conn);
            this.unnullify();
        }
    }

    public Time toTime() throws SQLException {
        Time time;
        long l2 = 0L;
        if (this.isNull()) {
            return null;
        }
        try {
            boolean bl = true;
            Object object = dateUtil.convertDateTimeObj(this.value, this.conn, bl);
            l2 = ((java.util.Date)object).getTime();
            time = new Time(l2);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return time;
    }

    public void fromTime(Time time) throws SQLException {
        block3: {
            block2: {
                if (time != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            long l2 = time.getTime();
            this.value = dateUtil.convertDateTimeStr(time, this.conn, l2);
            this.unnullify();
        }
    }

    public Timestamp toTimestamp() throws SQLException {
        Timestamp timestamp;
        if (this.isNull()) {
            return null;
        }
        try {
            boolean bl = false;
            timestamp = (Timestamp)dateUtil.convertDateTimeObj(this.value, this.conn, bl);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return timestamp;
    }

    public void fromTimestamp(Timestamp timestamp) throws SQLException {
        block3: {
            block2: {
                if (timestamp != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            long l2 = timestamp.getTime();
            this.value = dateUtil.convertDateTimeStr(timestamp, this.conn, l2);
            this.unnullify();
        }
    }

    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        Double d2 = Double.valueOf(this.value);
        return d2;
    }

    public void fromDouble(Double d2) throws SQLException {
        block3: {
            block2: {
                if (d2 != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.fromDouble((double)d2);
        }
    }

    public void fromDouble(double d2) throws SQLException {
        this.value = String.valueOf(d2);
        this.unnullify();
    }

    public BigDecimal toDecimal() throws SQLException {
        BigDecimal bigDecimal;
        if (this.isNull()) {
            return null;
        }
        try {
            bigDecimal = new BigDecimal(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw IfxErrMsg.getSQLException(-79716, numberFormatException.toString(), this.conn);
        }
        return bigDecimal;
    }

    public void fromBigDecimal(BigDecimal bigDecimal) throws SQLException {
        block3: {
            block2: {
                if (bigDecimal != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.db) break block3;
            }
            this.value = bigDecimal.toString();
            this.unnullify();
        }
    }

    public boolean equals(Object object) {
        if (this.isNull() || object == null || !(object instanceof IfxVarChar)) {
            return false;
        }
        IfxVarChar ifxVarChar = (IfxVarChar)object;
        if (ifxVarChar.isNull()) {
            return false;
        }
        return this.value.equals(ifxVarChar.value);
    }

    public InputStream toAsciiStream() throws SQLException {
        byte[] byArray;
        block5: {
            if (this.isNull()) {
                return null;
            }
            try {
                String string = this.conn.getdbEncoding();
                if (string != null) {
                    byArray = this.value.getBytes(string);
                    if (!IfxSqliConnect.db) break block5;
                }
                byArray = this.value.getBytes();
            }
            catch (IOException iOException) {
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
        return new ByteArrayInputStream(byArray);
    }

    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        block5: {
            block7: {
                boolean bl;
                block6: {
                    bl = IfxSqliConnect.db;
                    this.a(3, "IfxVarChar: fromAsciiStream()");
                    if (inputStream == null) break block5;
                    this.a(3, "IfxVarChar: fromAsciiStream(): length = " + n);
                    if (n != 0) break block6;
                    this.value = "";
                    if (!bl) break block7;
                }
                byte[] byArray = new byte[n];
                int n2 = 0;
                try {
                    block2: while (true) {
                        int n3 = inputStream.read(byArray, n2, n);
                        this.a(3, "IfxVarChar: fromAsciiStream(): readLen=" + n3);
                        this.a(3, "IfxVarChar: fromAsciiStream(): length = " + (n -= n3));
                        this.a(3, "IfxVarChar: fromAsciiStream(): offset =" + (n2 += n3));
                        do {
                            if (n > 0) continue block2;
                        } while (bl);
                        break;
                    }
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
                this.value = new String(byArray);
                this.a(3, "IfxVarChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        this.fromAsciiStream(inputStream, n);
    }

    public InputStream toInputStream() throws SQLException {
        return this.toAsciiStream();
    }

    public void fromCharacterStream(Reader reader, int n) throws SQLException {
        block5: {
            block7: {
                boolean bl;
                block6: {
                    bl = IfxSqliConnect.db;
                    this.a(3, "IfxVarChar: fromCharacterStream()");
                    if (reader == null) break block5;
                    this.a(3, "IfxVarChar: fromCharacterStream():length =" + n);
                    if (n != 0) break block6;
                    this.value = "";
                    if (!bl) break block7;
                }
                char[] cArray = new char[n];
                int n2 = 0;
                BufferedReader bufferedReader = new BufferedReader(reader);
                try {
                    block2: while (true) {
                        int n3 = reader.read(cArray, n2, n);
                        this.a(3, "IfxVarChar: fromcharacterStream():readLen=" + n3);
                        this.a(3, "IfxVarChar: fromCharacterStream():length=" + (n -= n3));
                        this.a(3, "IfxVarChar: fromCharacterStream():offset=" + (n2 += n3));
                        do {
                            if (n > 0) continue block2;
                        } while (bl);
                        break;
                    }
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
                this.value = new String(cArray);
                this.a(3, "IfxVarChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    public Reader toCharacterStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        this.a(99, "IfxVarChar: toCharacterStream()");
        this.a(3, "IfxVarChar: toCharacterStream(): value = " + this.value);
        return new StringReader(this.value);
    }
}

