/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jni;

import com.intersys.cache.jni.CacheExternalOref;
import com.intersys.cache.jni.CacheInternalArg;
import com.intersys.cache.jni.CallinException;
import com.intersys.objects.CacheException;
import com.intersys.objects.ObjectClosedException;

public class CacheJNI {
    public static final int CACHE_TYPE_INT = 1;
    public static final int CACHE_TYPE_DOUBLE = 2;
    public static final int CACHE_TYPE_STRING = 3;
    public static final int CACHE_TYPE_OREF = 3;
    public static final int CACHE_ERNORES = -13;
    public static final int CACHE_ERBADARG = -12;
    public static final int CACHE_ERRETTRUNC = -10;
    public static final int CACHE_ERUNKNOWN = -9;
    public static final int CACHE_ERRETTOOSMALL = -8;
    public static final int CACHE_ERNOCON = -7;
    public static final int CACHE_ERINTERRUPT = -6;
    public static final int CACHE_ERSTRTOOLONG = -3;

    public static void main(String[] stringArray) {
    }

    public static boolean isLoaded() {
        boolean bl;
        try {
            bl = CacheJNI.native_isLoaded();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
        }
        return bl;
    }

    private static native boolean native_isLoaded();

    public static native void getLock();

    public static native boolean releaseLock();

    public static void PushArg(float f) throws CallinException {
        CacheJNI.PushArg((double)f);
    }

    public static native void PushArg(int var0) throws CallinException;

    public static native void PushArg(double var0) throws CallinException;

    public static void PushArg(CacheExternalOref cacheExternalOref) throws CallinException, ObjectClosedException {
        CacheJNI.native_PushOref(cacheExternalOref.getOref());
    }

    protected static native void native_PushOref(int var0) throws CallinException, ObjectClosedException;

    public static native void PushArg(String var0) throws CallinException, CacheException;

    public static native void PushGlobal(String var0) throws CallinException, CacheException;

    public static native void PushGlobal(String var0, String var1) throws CallinException, CacheException;

    public static void PushProperty(CacheExternalOref cacheExternalOref, String string) throws CallinException, CacheException, ObjectClosedException {
        CacheJNI.native_PushProperty(cacheExternalOref.getOref(), string);
    }

    protected static native void native_PushProperty(int var0, String var1) throws CallinException, CacheException, ObjectClosedException;

    public static void PushMethod(CacheExternalOref cacheExternalOref, String string, int n) throws CallinException, CacheException, ObjectClosedException {
        CacheJNI.native_PushMethod(cacheExternalOref.getOref(), string, n);
    }

    protected static native void native_PushMethod(int var0, String var1, int var2) throws CallinException, CacheException, ObjectClosedException;

    public static native void PushClassMethod(String var0, String var1, int var2) throws CallinException, CacheException;

    public static native int PushRoutine(String var0) throws CacheException, CallinException;

    public static native int PushRoutine(String var0, String var1) throws CacheException, CallinException;

    public static native int PushRoutine(String var0, int var1, String var2, String var3) throws CacheException, CallinException;

    public static native int PushFunction(String var0) throws CacheException, CallinException;

    public static native int PushFunction(String var0, String var1) throws CacheException, CallinException;

    public static native int PushFunction(String var0, int var1, String var2, String var3) throws CacheException, CallinException;

    public static native void UnPop() throws CallinException;

    public static CacheInternalArg Pop() throws CallinException {
        return CacheJNI.native_pop(new CacheInternalArg());
    }

    protected static native CacheInternalArg native_pop(CacheInternalArg var0) throws CallinException;

    public static native int PopInt() throws CallinException;

    public static float PopFloat() throws CallinException {
        return (float)CacheJNI.PopDouble();
    }

    public static native double PopDouble() throws CallinException;

    public static native String PopString() throws CallinException;

    public static CacheExternalOref PopOref() throws CallinException {
        return new CacheExternalOref(CacheJNI.native_PopOref());
    }

    protected static native int native_PopOref() throws CallinException;

    public static native void DoRoutine(int var0, int var1) throws CallinException;

    public static native void DoFunction(int var0, int var1) throws CallinException;

    public static native void CallFunction(int var0, int var1) throws CallinException;

    public static native void InvokeClassMethod(int var0) throws CallinException;

    public static native void InvokeMethod(int var0) throws CallinException;

    public static native void GetProperty() throws CallinException;

    public static native void SetProperty() throws CallinException;

    public static native void GetLocal(String var0) throws CallinException, CacheException;

    public static native void SetLocal(String var0) throws CallinException, CacheException;

    public static native void GetGlobal(int var0, int var1) throws CallinException;

    public static native void SetGlobal(int var0) throws CallinException;

    protected static native void IncrementOrefCount(int var0) throws CallinException;

    protected static native void CloseOref(int var0) throws CallinException;

    public static native void Execute(String var0) throws CallinException;

    public static native void Evaluate(String var0) throws CallinException;

    public static native String ErrorMessage(int var0) throws CallinException;

    public static int TopArgType() throws CallinException {
        int n = CacheJNI.nativeTopArgType();
        if (n == 15) {
            n = 3;
        }
        return n;
    }

    protected static native int nativeTopArgType() throws CallinException;
}

