/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.oldmetadata;

import com.intersys.cache.metadata.MethodHelper;
import com.intersys.cache.metadata.MethodInvocator;
import com.intersys.classes.RegisteredObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.reflect.CacheArgument;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheMethod;
import com.intersys.objects.reflect.CacheModifier;
import java.util.Iterator;

public abstract class AbstractCacheMethod
implements CacheMethod,
MethodInvocator {
    protected final String mReturnType;
    protected final String mJavaReturnType;
    protected final String mName;
    protected final CacheClass mClass;
    protected int mModifiers;

    public AbstractCacheMethod(CacheClass cacheClass, String string, String string2, String string3) {
        this.mReturnType = string == null ? "" : string.trim();
        this.mJavaReturnType = string2 == null ? "" : string2.trim();
        this.mClass = cacheClass;
        this.mName = string3;
    }

    public CacheClass getImplementationClass() throws CacheException {
        return this.mClass;
    }

    public CacheClass getDeclaringClass() throws CacheException {
        return this.mClass;
    }

    public String getName() {
        return this.mName;
    }

    public String getJavaReturnTypeName() throws CacheException {
        return this.mJavaReturnType;
    }

    public Class getJavaReturnType() throws CacheException {
        try {
            return Class.forName(this.mJavaReturnType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CacheException(classNotFoundException, "Can not find return type for method " + this.getName());
        }
    }

    public Object invoke(RegisteredObject registeredObject, Object[] objectArray) throws CacheException, IllegalArgumentException {
        return MethodHelper.invokeLow(this, registeredObject == null ? 0 : registeredObject.getOref(), objectArray, false);
    }

    public Object invoke(int n, Object[] objectArray) throws CacheException, IllegalArgumentException {
        return MethodHelper.invokeLow(this, n, objectArray, true);
    }

    public int getModifiers() {
        return this.mModifiers;
    }

    public String toString() {
        try {
            return this.getImplementationClass() + ": " + this.getDeclaration();
        }
        catch (CacheException cacheException) {
            return this.mName + " <exception occured: " + cacheException.toString() + ">";
        }
    }

    public boolean equals(Object object) {
        try {
            String string = this.getSignature();
            if (object instanceof String) {
                String string2 = (String)object;
                if (string.equals(string2)) {
                    return true;
                }
                string = this.getSignature(false);
                return string.equals(string2);
            }
            if (object instanceof CacheMethod) {
                String string3 = ((CacheMethod)object).getSignature();
                return string.equals(string3);
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getSignature() throws CacheException {
        return MethodHelper.constructSignature(this.mName, this.getArgumentIterator(), true);
    }

    private String getSignature(boolean bl) throws CacheException {
        return MethodHelper.constructSignature(this.mName, this.getArgumentIterator(), bl);
    }

    public String getDeclaration() throws CacheException {
        String string = this.mReturnType + " " + this.mName + "(";
        Iterator iterator = this.getArgumentIterator();
        while (iterator.hasNext()) {
            CacheArgument cacheArgument = (CacheArgument)iterator.next();
            string = string + cacheArgument.getTypeName();
            if (CacheModifier.byReference(cacheArgument.getModifiers())) {
                string = string + "&";
            }
            string = string + " " + cacheArgument.getName();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        return string + ")";
    }
}

