/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.oldmetadata;

import com.intersys.cache.jbind.JBindDatabase;
import com.intersys.cache.oldmetadata.MethodIterator;
import com.intersys.cache.oldmetadata.MethodSignatureIterator;
import com.intersys.cache.oldmetadata.ReadOnlyCacheClass;
import com.intersys.objects.CacheException;
import com.intersys.objects.InvalidClassException;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheMethod;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class JBindCacheClass
extends ReadOnlyCacheClass {
    private byte[] mMethods = null;
    private int mReferences = 1;
    private Map mMethodsMap = null;

    public JBindCacheClass(JBindDatabase jBindDatabase, String string) throws CacheException {
        super(string, jBindDatabase.getAdapter(), jBindDatabase);
        if (jBindDatabase != null) {
            jBindDatabase.addClass(this, null);
        }
    }

    public String getPackageName() {
        throw new UnsupportedOperationException("Method getPackageName() is not implemented in class com.intersys.cache.oldmetadata.JBindCacheClass");
    }

    public CacheMethod[] getMethods() throws CacheException {
        this.checkMethods();
        CacheMethod[] cacheMethodArray = new CacheMethod[this.mMethodsMap.size()];
        return this.mMethodsMap.values().toArray(cacheMethodArray);
    }

    public Iterator getMethodSignatures() throws CacheException {
        this.checkMethods();
        return new MethodSignatureIterator(this.myDB(), this.mMethods);
    }

    public CacheMethod getMethod(String string) throws CacheException {
        this.checkMethods();
        int n = string.indexOf(40);
        String string2 = n > 0 ? string.substring(0, n) : string;
        string2 = string2.trim();
        CacheMethod cacheMethod = (CacheMethod)this.mMethodsMap.get(string2);
        if (cacheMethod != null) {
            return cacheMethod;
        }
        CacheClass[] cacheClassArray = this.getCacheSuperclasses();
        for (int i = 0; i < cacheClassArray.length; ++i) {
            cacheMethod = cacheClassArray[i].getMethod(string);
            if (cacheMethod == null) continue;
            return cacheMethod;
        }
        return null;
    }

    public boolean isDatatype() {
        throw new UnsupportedOperationException("Method isDatatype() is not implemented in class com.intersys.cache.oldmetadata.JBindCacheClass");
    }

    public boolean isAbstract() {
        throw new UnsupportedOperationException("Method isAbstract() is not implemented in class com.intersys.cache.oldmetadata.JBindCacheClass");
    }

    public void incrementReferences() {
        ++this.mReferences;
    }

    public void close() {
        --this.mReferences;
        if (this.mReferences <= 0) {
            this.myDB().removeClass(this);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private void checkMethods() throws CacheException {
        if (this.mMethods == null) {
            this.mMethods = this.myDB().getAdapter().getClassMethods(this.mTypeName);
            if (this.mMethods == null) {
                throw new InvalidClassException(this.getName(), "Class " + this.getName() + " not found in Cache");
            }
        }
        if (this.mMethodsMap == null) {
            this.mMethodsMap = new TreeMap();
            MethodIterator methodIterator = new MethodIterator(this.myDB(), this, this.mMethods);
            while (methodIterator.hasNext()) {
                CacheMethod cacheMethod = (CacheMethod)methodIterator.next();
                if (this.mMethodsMap.put(cacheMethod.getName(), cacheMethod) == null) continue;
                throw new CacheException("Method " + cacheMethod.getName() + " is overloaded.");
            }
        }
    }

    private JBindDatabase myDB() {
        return (JBindDatabase)this.getDatabase();
    }
}

