/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.oldmetadata;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.oldmetadata.GeneralCacheDescription;
import com.intersys.cache.oldmetadata.QuickCacheClass;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.QuickDatabase;
import com.intersys.classes.ObjectHandle;
import com.intersys.objects.CacheException;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassMetadata;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheModifier;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.objects.reflect.TableMetadata;
import java.sql.Date;
import java.util.Vector;

class QuickCacheField
extends GeneralCacheDescription
implements ColumnBasedField {
    private final int mII;
    private final int mJJ;
    private final int mKK;
    private int mColumnIdxForGet;
    private int mColumnIdxForSet;
    private boolean mInvisible;
    private String mChildTableName;
    private String mInverseFieldName;
    protected Boolean mSerial = null;
    boolean mElementTypeSet = false;
    private QuickCacheField[] mEmbeddedFields;

    public QuickCacheField(QuickDatabase quickDatabase, String string, String string2, String string3, String string4, int n, int n2, int n3) {
        this.mDB = quickDatabase;
        this.mName = string;
        this.mDefaultValue = "";
        this.mTypeName = string2;
        this.mElementTypeName = string3;
        this.mJavaTypeName = string4;
        this.mModifier = 0;
        this.mII = n;
        this.mJJ = n2;
        this.mKK = n3;
        this.mColumnIdxForGet = -1;
        this.mColumnIdxForSet = -1;
    }

    public int getII() {
        return this.mII;
    }

    public int getJJ() {
        return this.mJJ;
    }

    public int getKK() {
        return this.mKK;
    }

    protected void addChild(QuickCacheField quickCacheField, CacheField cacheField) throws CacheException {
        int n;
        if (CacheModifier.isLiteral(this.getModifiers())) {
            throw new SystemError("Can not add child to a literal field: " + this.getName() + " -> " + quickCacheField.getName());
        }
        if (this.mEmbeddedFields == null) {
            this.setupChildFieldArray();
        }
        if ((n = cacheField.getII()) >= 0) {
            this.mEmbeddedFields[n] = quickCacheField;
        }
    }

    public ColumnBasedField getChildField(String string, int n, int n2) {
        if (this.mEmbeddedFields == null) {
            return null;
        }
        return this.mEmbeddedFields[n];
    }

    private void setupChildFieldArray() throws CacheException {
        QuickCacheClass quickCacheClass = (QuickCacheClass)this.mDB.getCacheClass(this.mTypeName);
        Vector vector = quickCacheClass.getAllFieldsAsVector();
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = ((CacheField)vector.get(i)).getII();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        this.mEmbeddedFields = new QuickCacheField[n2 + 1];
    }

    protected void setTypes(String string, String string2, String string3) {
        this.mTypeName = string;
        this.mJavaTypeName = string2;
        this.mElementTypeName = string3;
    }

    public int getElementType() throws CacheException {
        if (!this.mElementTypeSet) {
            this.guessElementType();
        }
        return super.getElementType();
    }

    public void setElementType(String string) throws CacheException {
        if (string == null) {
            return;
        }
        if ("TYPE_PERSISTENT".equals(string)) {
            this.setElementType(4608);
        } else if ("DATATYPE".equals(string)) {
            this.setElementType(256);
        } else if ("TYPE_SERIAL".equals(string)) {
            this.setElementType(8704);
        }
    }

    public String getChildTableName() {
        return this.mChildTableName;
    }

    protected void setChildTableName(String string) {
        this.mChildTableName = string;
    }

    public boolean isInvisible() {
        return this.mInvisible;
    }

    public boolean isSerial() throws CacheException {
        if (this.mSerial == null) {
            this.mSerial = this.getTypeName() == null ? Boolean.FALSE : new Boolean(((QuickCacheClass)this.getType()).isSerial());
        }
        return this.mSerial;
    }

    protected void setInvisible(boolean bl) {
        this.mInvisible = bl;
    }

    protected void setCollectionType(int n) {
        this.addTypeModifier(n);
    }

    protected void setCollectionType(String string) throws CacheException {
        if (string == null) {
            return;
        }
        if (string.equals("LIST")) {
            this.addTypeModifier(8);
        } else if (string.equals("ARRAY")) {
            this.addTypeModifier(1);
        } else {
            throw new SystemError("Unknown Collection type: " + string);
        }
    }

    public int getColumnIndexForGet() {
        return this.mColumnIdxForGet;
    }

    public int getColumnIndexForSet() {
        return this.mColumnIdxForSet;
    }

    public boolean isEmbedded() {
        return this.mColumnIdxForGet == -10;
    }

    public int getSerialStorageIndex() {
        return this.getColumnIndexForSet();
    }

    protected void setColumnIndexForGet(int n) {
        this.mColumnIdxForGet = n;
    }

    protected void setColumnIndexForSet(int n) {
        this.mColumnIdxForSet = n;
    }

    public String getInverseFieldName() {
        return this.mInverseFieldName;
    }

    protected void setInverseFieldName(String string) {
        this.mInverseFieldName = string;
    }

    public String columnNameForEmbProp(String string) {
        return this.getName() + '_' + string;
    }

    public boolean isEmbeddedSetUp() {
        return this.mEmbeddedFields != null;
    }

    public Object get(int n) throws CacheException {
        throw new CacheException("Not supported in this implementation.");
    }

    public Object get(Object object) throws CacheException {
        if (!(object instanceof ObjectHandle)) {
            throw new CacheException("Can not get field value on object of type " + object.getClass().getName());
        }
        CacheObject cacheObject = ((ObjectHandle)object).getProxy();
        boolean bl = CacheModifier.isLiteral(this.getModifiers());
        int n = bl ? 0 : 1;
        Dataholder dataholder = cacheObject.getProperty(this.mII, this.mJJ, n, this.mName);
        if (bl) {
            return dataholder.getObject(this.mJavaTypeName);
        }
        CacheObject cacheObject2 = dataholder.getCacheObject();
        if (cacheObject2 == null) {
            return null;
        }
        return cacheObject2.newJavaInstance(true);
    }

    public void set(int n, Object object) throws CacheException {
        throw new CacheException("Not supported in this implementation.");
    }

    public void set(Object object, Object object2) throws CacheException {
        int n;
        Dataholder dataholder = null;
        if (!(object instanceof ObjectHandle)) {
            throw new CacheException("Can not set field value on object of type " + object.getClass().getName());
        }
        CacheObject cacheObject = ((ObjectHandle)object).getProxy();
        int n2 = n = CacheModifier.isLiteral(this.getModifiers()) ? 0 : 1;
        if (n == 1 && object2 instanceof ObjectHandle) {
            ObjectHandle objectHandle = (ObjectHandle)object2;
            dataholder = new Dataholder(1026, objectHandle.getProxy());
        } else if (Date.class.getName().endsWith(this.mJavaTypeName)) {
            dataholder = Dataholder.create(object2);
            dataholder = new Dataholder(64, dataholder.getDate());
        } else {
            dataholder = Dataholder.create(object2);
        }
        cacheObject.setProperty(this.mII, this.mJJ, this.mKK, n, this.mName, dataholder);
    }

    public boolean equals(Object object) {
        if (!(object instanceof QuickCacheField)) {
            return false;
        }
        QuickCacheField quickCacheField = (QuickCacheField)object;
        return this.mName.equals(quickCacheField.mName) && (this.mTypeName == null && quickCacheField.mTypeName == null || this.mTypeName != null && this.mTypeName.equals(quickCacheField.mTypeName));
    }

    public boolean isChildTable() {
        return this.mChildTableName != null;
    }

    public SQLColumn getSQLColumn() {
        throw new UnsupportedOperationException("Method getSQLColumn() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public String[] getDisplayList() {
        throw new UnsupportedOperationException("Method getDisplayList() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public String[] getValueList() {
        throw new UnsupportedOperationException("Method getValueList() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public boolean isCalculated() {
        throw new UnsupportedOperationException("Method isCalculated() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public boolean isSQLComputed() {
        throw new UnsupportedOperationException("Method isSQLComputed() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public boolean hasGet() {
        throw new UnsupportedOperationException("Method hasGet() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public boolean hasSet() {
        throw new UnsupportedOperationException("Method hasSet() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public boolean hasGetAsMethod() {
        throw new UnsupportedOperationException("Method hasGetAsMethod() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public boolean hasSetAsMethod() {
        throw new UnsupportedOperationException("Method hasSetAsMethod() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public boolean definedGet() {
        throw new UnsupportedOperationException("Method definedGet() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public boolean definedSet() {
        throw new UnsupportedOperationException("Method definedSet() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public String getGetAccessorName() {
        throw new UnsupportedOperationException("Method getGetAccessorName() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public String getDeclaredType() {
        throw new UnsupportedOperationException("Method getDeclaredType() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public SQLColumn[] getChildTableColumns() throws CacheException {
        throw new UnsupportedOperationException("Method getChildTableColumns() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public CacheClassMetadata getParentClassMetadata() {
        throw new UnsupportedOperationException("Method getParentClassMetadata() { is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public TableMetadata getChildTableMetadata() {
        throw new UnsupportedOperationException("Method getChildTableMetadata() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public String getGetter() {
        throw new UnsupportedOperationException("Method getGetter() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isVersionField() throws CacheException {
        return false;
    }

    private void guessElementType() throws CacheException {
        if (this.mElementTypeSet) {
            return;
        }
        String string = this.getElementTypeName();
        CacheClass cacheClass = this.mDB.getCacheClass(string);
        if (cacheClass.isPersistent()) {
            this.setElementType(4608);
        } else if (cacheClass.isSerial()) {
            this.setElementType(8704);
        } else {
            this.setElementType(256);
        }
    }

    private void setElementType(int n) {
        this.addTypeModifier(n);
        this.mElementTypeSet = true;
    }

    public CacheClass getDeclaringCacheClass() {
        throw new UnsupportedOperationException("Method getDeclaringCacheClass() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }

    public boolean isRequired() throws CacheException {
        throw new UnsupportedOperationException("Method isRequired() is not implemented in class com.intersys.cache.oldmetadata.QuickCacheField");
    }
}

