/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.gateway;

import java.util.ArrayList;
import java.util.HashMap;

class TypeMap {
    private static HashMap types;
    private static HashMap javaTypes;
    private static HashMap javaClasses;
    private static ArrayList exclusions;

    TypeMap() {
    }

    protected static HashMap getCacheTypes() {
        return types;
    }

    protected static String getJavaType(String string) {
        String string2 = (String)javaTypes.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    protected static Class getJavaClass(String string) throws Exception {
        return (Class)javaClasses.get(string);
    }

    protected static boolean isJavaDataType(String string) {
        return string.equals("java.lang.String") || string.equals("int") || string.equals("java.lang.Integer") || string.equals("float") || string.equals("java.lang.Float") || string.equals("double") || string.equals("java.lang.Double") || string.equals("short") || string.equals("java.lang.Short") || string.equals("long") || string.equals("java.lang.Long") || string.equals("char") || string.equals("byte") || string.equals("boolean") || string.equals("java.lang.Boolean") || string.equals("java.sql.Date") || string.equals("java.sql.Time") || string.equals("java.sql.Timestamp");
    }

    protected static ArrayList getInitialExclusions() {
        return (ArrayList)exclusions.clone();
    }

    protected static String getCachePropertyName(String string) {
        return string.replaceAll("_", "u").replace('$', 'd');
    }

    protected static String getCacheClassName(String string) throws Exception {
        Class<?> clazz = Class.forName(string).getDeclaringClass();
        string = string.replaceAll("_", "u");
        if (clazz == null) {
            return string.replace('$', 'd');
        }
        String string2 = clazz.getName();
        if (string.startsWith(string2 + "$")) {
            return TypeMap.getCacheClassName(string.substring(0, string2.length())) + "." + string.substring(string2.length() + 1, string.length()).replace('$', 'd');
        }
        throw new Exception("Invalid class Name");
    }

    static {
        exclusions = new ArrayList();
        exclusions.add("org.apache.poi.util");
        exclusions.add("org.apache.xalan.extensions.ExtensionHandlerGeneral");
        exclusions.add("sun");
        exclusions.add("com.sun.jms");
        exclusions.add("com.sun.security");
        exclusions.add("com.sun.corba");
        exclusions.add("com.sun.enterprise");
        exclusions.add("com.sun.ejb");
        exclusions.add("com.sun.jts");
        exclusions.add("COM.rsa");
        types = new HashMap();
        types.put("void", "\"\"");
        types.put("boolean", "%Library.Boolean");
        types.put("int", "%Library.Integer");
        types.put("short", "%Library.SmallInt");
        types.put("long", "%Library.Integer");
        types.put("float", "%Library.Float");
        types.put("double", "%Library.Numeric");
        types.put("byte", "%Library.Integer");
        types.put("char", "%Library.String");
        types.put("java.lang.Boolean", "%Library.Boolean");
        types.put("java.lang.Integer", "%Library.Integer");
        types.put("java.lang.Short", "%Library.SmallInt");
        types.put("java.lang.Long", "%Library.Integer");
        types.put("java.lang.Float", "%Library.Float");
        types.put("java.lang.Double", "%Library.Numeric");
        types.put("java.lang.String", "%Library.String");
        types.put("java.sql.Date", "%Library.Date");
        types.put("java.sql.Time", "%Library.Time");
        types.put("java.sql.Timestamp", "%Library.TimeStamp");
        types.put("[Ljava.lang.String;", "%Library.ListOfDataTypes");
        types.put("[Ljava.lang.Double;", "%Library.ListOfDataTypes");
        types.put("[Ljava.sql.Time;", "%Library.ListOfDataTypes");
        types.put("[Ljava.sql.Timestamp;", "%Library.ListOfDataTypes");
        types.put("[Ljava.sql.Date;", "%Library.ListOfDataTypes");
        types.put("[Z", "%Library.ListOfDataTypes");
        types.put("[S", "%Library.ListOfDataTypes");
        types.put("[I", "%Library.ListOfDataTypes");
        types.put("[J", "%Library.ListOfDataTypes");
        types.put("[F", "%Library.ListOfDataTypes");
        types.put("[D", "%Library.ListOfDataTypes");
        types.put("[B", "%Library.GlobalBinaryStream");
        types.put("[C", "%Library.GlobalCharacterStream");
        javaTypes = new HashMap();
        javaTypes.put("%String", "java.lang.String");
        javaTypes.put("%Integer", "int");
        javaTypes.put("%Float", "float");
        javaTypes.put("%SmallInt", "short");
        javaTypes.put("%Date", "java.sql.Date");
        javaTypes.put("%Time", "java.sql.Time");
        javaTypes.put("%TimeStamp", "java.sql.Timestamp");
        javaClasses = new HashMap();
        javaClasses.put("%String", String.class);
        javaClasses.put("%Integer", Integer.TYPE);
        javaTypes.put("%Float", "Float.TYPE");
        javaTypes.put("%SmallInt", "Short.TYPE");
        javaTypes.put("%Date", "java.sql.Date.class");
        javaTypes.put("%Time", "java.sql.Time.class");
        javaTypes.put("%TimeStamp", "java.sql.Timestamp.class");
        javaTypes.put("%GlobalBinaryStream", "[B");
        javaTypes.put("%GlobalCharacterStream", "[C");
    }
}

