/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheConnectionPoolDataSource;
import com.intersys.jdbc.CacheDriver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class CacheDataSource
implements DataSource {
    protected static CacheDriver driver;
    protected PrintWriter logStream = null;
    protected String database;
    protected String dataSource;
    protected String description;
    protected String server;
    protected String eventClass = "";
    protected String password = "";
    protected String user = "";
    protected String url = null;
    protected int port = 1972;
    protected int loginTimeout = 0;
    protected Object transactionManager = null;
    protected boolean nodelay = true;
    protected int securityLevel = 0;
    protected String principalName = null;
    protected int isolationLevel = 1;

    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        if (this.url == null) {
            this.url = "jdbc:Cache://" + this.server + ":" + this.port + "/" + this.database;
        }
        if (this instanceof CacheConnectionPoolDataSource) {
            return CacheDriver.CPManager.lookup((CacheConnectionPoolDataSource)this, string, string2).getConnection();
        }
        return new CacheConnection(this.url, this.server, this.port, this.database, string, string2, this.eventClass, this.logStream, this.loginTimeout, this.nodelay, null, this.securityLevel, this.principalName, this.isolationLevel);
    }

    public PrintWriter getLogWriter() {
        return this.logStream;
    }

    public synchronized void setLogWriter(PrintWriter printWriter) {
        this.logStream = printWriter;
    }

    public synchronized void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public synchronized void setDatabaseName(String string) {
        this.database = string;
    }

    public String getDatabaseName() {
        return this.database;
    }

    public synchronized void setDataSourceName(String string) {
        this.dataSource = string;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public synchronized void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public synchronized void setPortNumber(int n) {
        this.port = n;
    }

    public int getPortNumber() {
        return this.port;
    }

    public synchronized void setServerName(String string) {
        this.server = string;
    }

    public String getServerName() {
        return this.server;
    }

    public synchronized void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public synchronized void setEventClass(String string) {
        this.eventClass = string;
        if (this.eventClass == null) {
            this.eventClass = "";
        }
    }

    public String getEventClass() {
        return this.eventClass;
    }

    public synchronized void setURL(String string) throws SQLException {
        if (!string.startsWith("jdbc:Cache://")) {
            throw new SQLException("Invalid URL: " + string, "S1000");
        }
        this.url = string;
        String string2 = string.substring(13);
        int n = string2.indexOf(":");
        if (n == -1) {
            throw new SQLException("Invalid URL: " + string, "S1000");
        }
        this.server = string2.substring(0, n);
        if ((n = (string2 = string2.substring(n + 1)).indexOf("/")) == -1) {
            throw new SQLException("Invalid URL: " + string, "S1000");
        }
        this.port = Integer.parseInt(string2.substring(0, n));
        if ((n = (string2 = string2.substring(n + 1)).indexOf("/")) == -1) {
            this.database = string2;
            this.logStream = null;
            return;
        }
        this.database = string2.substring(0, n);
        if ((n = (string2 = string2.substring(n + 1)).indexOf(":")) == -1) {
            this.setLogStream(string2);
            return;
        }
        this.setLogStream(string2.substring(0, n));
        string2 = string2.substring(n + 1);
        this.parseExtension(string2);
    }

    public String getURL() {
        if (this.url == null) {
            this.url = "jdbc:Cache://" + this.server + ":" + this.port + "/" + this.database;
        }
        return this.url;
    }

    public synchronized void setNodelay(boolean bl) {
        this.nodelay = bl;
    }

    public boolean getNodelay() {
        return this.nodelay;
    }

    public synchronized void setServicePrincipalName(String string) {
        this.principalName = string;
    }

    public String getServicePrincipalName() {
        return this.principalName;
    }

    public synchronized void setConnectionSecurityLevel(int n) {
        this.securityLevel = n;
    }

    public int getConnectionSecurityLevel() {
        return this.securityLevel;
    }

    public void setLogFile(String string) throws SQLException {
        this.setLogStream(string);
    }

    private void setLogStream(String string) throws SQLException {
        if (string == null || string.equals("")) {
            this.logStream = null;
        } else {
            try {
                File file = new File(string);
                file.delete();
                this.logStream = new PrintWriter(new FileOutputStream(file, true), true);
            }
            catch (Exception exception) {
                throw new SQLException("Invalid log file name: " + string, "S1000");
            }
        }
    }

    public int getDefaultTransactionIsolation() {
        return this.isolationLevel;
    }

    public synchronized void setDefaultTransactionIsolation(int n) {
        this.isolationLevel = n;
    }

    private void parseExtension(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            this.eventClass = string;
        } else {
            this.eventClass = string.substring(0, n);
            if ((string = string.substring(n + 1)).equalsIgnoreCase("false")) {
                this.nodelay = false;
            }
        }
    }

    static {
        if (driver == null) {
            try {
                driver = (CacheDriver)Class.forName("com.intersys.jdbc.CacheDriver").newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

