/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBlob;
import com.intersys.jdbc.CacheCallableStatement;
import com.intersys.jdbc.CacheClob;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheInputStream;
import com.intersys.jdbc.CacheReader;
import com.intersys.jdbc.CacheResultSetMetaData;
import com.intersys.jdbc.CacheStatement;
import com.intersys.jdbc.CacheUpdatableResultSet;
import com.intersys.jdbc.Descriptor;
import com.intersys.jdbc.SysList;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class CacheResultSet
implements ResultSet {
    protected static final int GET_RESULT_SET_OBJECT_INIT = 0;
    protected static final int GET_RESULT_SET_OBJECT_MORE_DATA = 1;
    protected static final int GET_RESULT_SET_OBJECT_CLOSE = 2;
    protected int rowID;
    protected int currentColumn;
    protected int currentRow;
    protected boolean closed;
    protected boolean isAfterLast;
    protected CacheStatement statement;
    private String cacheResultSetOref;

    CacheResultSet(CacheStatement cacheStatement) throws SQLException {
        this.statement = cacheStatement;
        this.currentRow = 0;
        this.closed = false;
        this.isAfterLast = false;
        this.currentColumn = this.statement.columns.size() + 1;
        this.cacheResultSetOref = null;
    }

    CacheResultSet(CacheStatement cacheStatement, String string) throws SQLException {
        this.statement = cacheStatement;
        this.currentRow = 0;
        this.closed = false;
        this.isAfterLast = false;
        this.currentColumn = this.statement.columns.size() + 1;
        this.cacheResultSetOref = string;
    }

    public synchronized boolean next() throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet closed", "S1000", 460);
        }
        if (this.statement.maxRows != 0 && this.currentRow == this.statement.maxRows) {
            return false;
        }
        this.currentColumn = this.statement.input.wire.advance(this.currentColumn, this.statement.columns.size() + 1);
        if (this.currentColumn != this.statement.columns.size() + 1) {
            if (this.statement.fetchDone) {
                this.isAfterLast = true;
                return false;
            }
            this.fetchMoreData();
            this.currentColumn = this.statement.input.wire.advance(this.currentColumn, this.statement.columns.size() + 1);
        }
        if (this.statement.input.wire.isEnd() && this.statement.fetchDone) {
            this.isAfterLast = true;
            return false;
        }
        this.statement.input.wire.saveCurrentRowPosition();
        this.currentColumn = 1;
        ++this.currentRow;
        return true;
    }

    public Object getWire() throws SQLException {
        int n = this.statement.columns.size();
        this.checkAndPosition(n);
        this.statement.input.wire.resetRow();
        return this.statement.input.wire.getSubList(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.statement == null) {
            return;
        }
        if (this.statement.connection == null || this.statement.connection.isClosed()) {
            return;
        }
        if (this.cacheResultSetOref != null) {
            CacheConnection cfr_ignored_0 = this.statement.connection;
            this.statement.output.wire.writeHeader(this.statement.serverCursorNumber, CacheConnection.GET_CACHE_RESULT_SET_OBJECT);
            this.statement.output.wire.set(this.cacheResultSetOref);
            this.statement.output.wire.set(2);
            this.statement.output.send(this.statement.connection.messageCount.getCount());
            return;
        }
        if (this.statement.connection.isOwner(this.statement.serverCursorNumber, this.statement)) {
            if (this.statement.resultSetType != 1003 || !this.statement.fetchDone) {
                CacheConnection.MessageCount messageCount = this.statement.connection.messageCount;
                synchronized (messageCount) {
                    CacheConnection cfr_ignored_1 = this.statement.connection;
                    this.statement.output.wire.writeHeader(this.statement.serverCursorNumber, CacheConnection.CLOSE_CURSOR);
                    this.statement.output.send(this.statement.connection.messageCount.getCount());
                }
            }
            this.statement.connection.markAsNotBeingExecuted(this.statement.serverCursorNumber, this.statement);
        }
        this.currentRow = 0;
        this.currentColumn = 0;
        this.statement.myResultSet = null;
        if (!this.statement.multipleResultSets) {
            this.statement.genericExecuteCalled = false;
        }
        this.closed = true;
    }

    public boolean wasNull() throws SQLException {
        return this.statement.input.wire.wasNull();
    }

    public synchronized String getString(int n) throws SQLException {
        if (n < 0 || n > this.statement.columns.size() || n == 0 && !(this instanceof CacheUpdatableResultSet)) {
            throw new SQLException("Cursor out of range", "S1000", 460);
        }
        Descriptor descriptor = (Descriptor)this.statement.columns.elementAt(n - 1);
        switch (descriptor.type) {
            case -4: {
                CacheInputStream cacheInputStream = (CacheInputStream)this.getStream(n, 1, descriptor.type);
                if (cacheInputStream == null) {
                    return null;
                }
                return cacheInputStream.toUnicodeString();
            }
            case -1: {
                CacheReader cacheReader = (CacheReader)this.getStream(n, 4, descriptor.type);
                if (cacheReader == null) {
                    return null;
                }
                return cacheReader.toUnicodeString();
            }
        }
        this.checkAndPosition(n);
        return this.statement.input.wire.getString(descriptor);
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        this.checkAndPosition(n);
        return this.statement.input.wire.getBoolean();
    }

    public synchronized byte getByte(int n) throws SQLException {
        this.checkAndPosition(n);
        return this.statement.input.wire.getOneByte();
    }

    public synchronized short getShort(int n) throws SQLException {
        this.checkAndPosition(n);
        return this.statement.input.wire.getShort();
    }

    public synchronized int getInt(int n) throws SQLException {
        this.checkAndPosition(n);
        return this.statement.input.wire.getInt();
    }

    public synchronized long getLong(int n) throws SQLException {
        this.checkAndPosition(n);
        return this.statement.input.wire.getLong();
    }

    public synchronized float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    public synchronized double getDouble(int n) throws SQLException {
        this.checkAndPosition(n);
        return this.statement.input.wire.getDouble((Descriptor)this.statement.columns.elementAt(n - 1));
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkAndPosition(n);
        return this.statement.input.wire.getBigDecimalScale(n2);
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        if (n < 0 || n > this.statement.columns.size() || n == 0 && !(this instanceof CacheUpdatableResultSet)) {
            throw new SQLException("Cursor out of range", "S1000", 460);
        }
        Descriptor descriptor = (Descriptor)this.statement.columns.elementAt(n - 1);
        switch (descriptor.type) {
            case -1: {
                throw new SQLException("Restricted data type attribute violation", "07006", 7006);
            }
            case -4: {
                CacheInputStream cacheInputStream = (CacheInputStream)this.getStream(n, 1, descriptor.type);
                if (cacheInputStream == null) {
                    return null;
                }
                return cacheInputStream.toByte();
            }
        }
        this.checkAndPosition(n);
        return this.statement.input.wire.getByte(descriptor);
    }

    public synchronized Date getDate(int n) throws SQLException {
        this.checkAndPosition(n);
        return this.statement.input.wire.getDate();
    }

    public synchronized Time getTime(int n) throws SQLException {
        this.checkAndPosition(n);
        return this.statement.input.wire.getTime();
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        this.checkAndPosition(n);
        return this.statement.input.wire.getTimestamp();
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        if (n < 0 || n > this.statement.columns.size() || n == 0 && !(this instanceof CacheUpdatableResultSet)) {
            throw new SQLException("Cursor out of range", "S1000", 460);
        }
        int n2 = this.statement.getColumnType(n);
        switch (n2) {
            case -4: 
            case -1: {
                return (CacheInputStream)this.getStream(n, 0, n2);
            }
            case -3: 
            case 12: {
                return new CacheInputStream(this.getBytes(n), 0, n2, this.statement.input.wire.getMaxFieldSize());
            }
        }
        throw new SQLException("Restricted data type attribute violation", "07006", 7006);
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        throw new SQLException("This api is no longer supported", "S1000");
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        if (n < 0 || n > this.statement.columns.size() || n == 0 && !(this instanceof CacheUpdatableResultSet)) {
            throw new SQLException("Cursor out of range", "S1000", 460);
        }
        int n2 = this.statement.getColumnType(n);
        switch (n2) {
            case -4: 
            case -1: {
                return (CacheInputStream)this.getStream(n, 1, n2);
            }
            case -3: {
                return new CacheInputStream(this.getBytes(n), 1, n2, this.statement.input.wire.getMaxFieldSize());
            }
        }
        throw new SQLException("Restricted data type attribute violation", "07006", 7006);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        throw new SQLException("This api is no longer supported", "S1000");
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet closed", "S1000", 460);
        }
        return new CacheResultSetMetaData(this.statement);
    }

    public synchronized Object getObject(int n) throws SQLException {
        if (n < 0 || n > this.statement.columns.size() || n == 0 && !(this instanceof CacheUpdatableResultSet)) {
            throw new SQLException("Cursor out of range", "S1000", 460);
        }
        Descriptor descriptor = (Descriptor)this.statement.columns.elementAt(n - 1);
        if (descriptor.type == -1) {
            return this.getAsciiStream(n);
        }
        if (descriptor.type == -4) {
            return this.getBinaryStream(n);
        }
        this.checkAndPosition(n);
        switch (descriptor.type) {
            case 12: {
                return this.statement.input.wire.getString(descriptor);
            }
            case -6: 
            case 4: 
            case 5: {
                return this.statement.input.wire.getIntegerWrapper();
            }
            case 8: {
                return this.statement.input.wire.getDoubleWrapper();
            }
            case 91: {
                return this.statement.input.wire.getDate();
            }
            case 92: {
                return this.statement.input.wire.getTime();
            }
            case 93: {
                return this.statement.input.wire.getTimestamp();
            }
            case -7: {
                return this.statement.input.wire.getBooleanWrapper();
            }
            case 2: {
                return this.statement.input.wire.getBigDecimal(descriptor);
            }
            case -3: 
            case -2: {
                return this.statement.input.wire.getByte();
            }
            case -5: {
                return this.statement.input.wire.getLongWrapper();
            }
        }
        return this.statement.input.wire.getString(descriptor);
    }

    public synchronized int findColumn(String string) throws SQLException {
        for (int i = 1; i <= this.statement.columns.size(); ++i) {
            if (!string.equalsIgnoreCase(this.statement.getColumnName(i))) continue;
            return i;
        }
        throw new SQLException("Column does not exist: " + string, "S1002", 463);
    }

    public Object getObject(String string) throws SQLException {
        if (string.equals("**QuickStatement**")) {
            return this.statement.connection.createQuickStatement();
        }
        if (string.equals("**CacheConnection**")) {
            return this.statement.connection;
        }
        return this.getObject(this.findColumn(string));
    }

    protected final synchronized void checkAndPosition(int n) throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet closed", "S1000", 460);
        }
        if (n < 0 || this.isAfterLast || this.currentRow == 0 || n == 0 && !(this instanceof CacheUpdatableResultSet)) {
            throw new SQLException("Cursor out of range", "S1000", 460);
        }
        if (this.currentColumn > n) {
            this.statement.input.wire.resetRow();
            this.currentColumn = 1;
            if (this instanceof CacheUpdatableResultSet && n != 0) {
                ((CacheUpdatableResultSet)this).rowID = this.getRowID();
            }
        }
        if (n > this.statement.columns.size()) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
        if (this.currentColumn > this.statement.columns.size()) {
            throw new SQLException("Cursor positioned before first row", "S1000", 460);
        }
        this.currentColumn = this.statement.input.wire.advance(this.currentColumn, n);
        if (this.currentColumn != n || this.statement.input.wire.isEnd()) {
            this.fetchMoreData();
            this.currentColumn = this.statement.input.wire.advance(this.currentColumn, n);
        }
        ++this.currentColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void fetchMoreData() throws SQLException {
        if (this.statement.fetchDone) {
            return;
        }
        if (this.statement.connection == null || this.statement.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        CacheConnection.MessageCount messageCount = this.statement.connection.messageCount;
        synchronized (messageCount) {
            if (this.statement instanceof CacheCallableStatement || this.statement.statementType == 10 || this.statement.statementType == 12) {
                if (this.statement.multipleResultSets) {
                    CacheConnection cfr_ignored_0 = this.statement.connection;
                    this.statement.output.wire.writeHeader(this.statement.serverCursorNumber, CacheConnection.MULTIPLE_RESULT_SETS_FETCH_DATA);
                } else {
                    CacheConnection cfr_ignored_1 = this.statement.connection;
                    this.statement.output.wire.writeHeader(this.statement.serverCursorNumber, CacheConnection.STORED_PROCEDURE_FETCH_DATA);
                }
            } else if (this.cacheResultSetOref == null) {
                CacheConnection cfr_ignored_2 = this.statement.connection;
                this.statement.output.wire.writeHeader(this.statement.serverCursorNumber, CacheConnection.FETCH_DATA);
            } else {
                CacheConnection cfr_ignored_3 = this.statement.connection;
                this.statement.output.wire.writeHeader(this.statement.serverCursorNumber, CacheConnection.GET_CACHE_RESULT_SET_OBJECT);
                this.statement.output.wire.set(this.cacheResultSetOref);
                this.statement.output.wire.set(1);
            }
            this.statement.output.send(this.statement.connection.messageCount.getCount());
            SysList sysList = this.statement.input.wire;
            synchronized (sysList) {
                if (this.statement.input.readHeader(this.statement.serverCursorNumber, 1, 100) == 0) {
                    this.statement.connection.markAsBeingExecuted(this.statement.serverCursorNumber, this.statement);
                    return;
                }
            }
        }
        this.statement.fetchDone = true;
        this.statement.connection.markAsNotBeingExecuted(this.statement.serverCursorNumber, this.statement);
    }

    protected synchronized int getRowID() throws SQLException {
        if (this.isAfterLast) {
            throw new SQLException("Cursor out of range", "S1000", 460);
        }
        this.statement.input.wire.resetRow();
        int n = this.statement.input.wire.getInt();
        this.currentColumn = 1;
        return n;
    }

    private final synchronized Object getStream(int n, int n2, int n3) throws SQLException {
        this.checkAndPosition(n);
        String string = this.statement.input.wire.getString();
        if (string == null) {
            this.statement.input.wire.isNull = true;
            return null;
        }
        if (n2 == 3) {
            CacheClob cacheClob = new CacheClob(this.statement.connection, string, this.statement.serverCursorNumber, n2, n3);
            if (cacheClob.isNull()) {
                this.statement.input.wire.isNull = true;
                return null;
            }
            return cacheClob;
        }
        if (n2 == 2) {
            CacheBlob cacheBlob = new CacheBlob(this.statement.connection, string, this.statement.serverCursorNumber, n2, n3);
            if (cacheBlob.isNull()) {
                this.statement.input.wire.isNull = true;
                return null;
            }
            return cacheBlob;
        }
        if (n2 == 4) {
            CacheReader cacheReader = new CacheReader(this.statement.connection, string, this.statement.serverCursorNumber, n3, this.statement.input.wire.getMaxFieldSize());
            if (cacheReader.isNull()) {
                this.statement.input.wire.isNull = true;
                return null;
            }
            return cacheReader;
        }
        CacheInputStream cacheInputStream = new CacheInputStream(this.statement.connection, string, this.statement.serverCursorNumber, n2, n3, this.statement.input.wire.getMaxFieldSize());
        if (cacheInputStream.isNull()) {
            this.statement.input.wire.isNull = true;
            return null;
        }
        return cacheInputStream;
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        if (n < 0 || n > this.statement.columns.size() || n == 0 && !(this instanceof CacheUpdatableResultSet)) {
            throw new SQLException("Cursor out of range", "S1000", 460);
        }
        int n2 = this.statement.getColumnType(n);
        switch (n2) {
            case -4: 
            case -1: {
                return (CacheReader)this.getStream(n, 4, n2);
            }
            case -3: 
            case 12: {
                return new CacheReader(this.getString(n));
            }
        }
        throw new SQLException("Restricted data type attribute violation", "07006", 7006);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkAndPosition(n);
        return this.statement.input.wire.getBigDecimal((Descriptor)this.statement.columns.elementAt(n - 1));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY", "S1000");
    }

    public boolean isAfterLast() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY", "S1000");
    }

    public boolean isFirst() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY", "S1000");
    }

    public boolean isLast() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY", "S1000");
    }

    public void beforeFirst() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY", "S1000");
    }

    public void afterLast() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY", "S1000");
    }

    public boolean first() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY", "S1000");
    }

    public boolean last() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY", "S1000");
    }

    public boolean absolute(int n) throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY", "S1000");
    }

    public boolean relative(int n) throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY", "S1000");
    }

    public boolean previous() throws SQLException {
        throw new SQLException("Fetch type is TYPE_FORWARD_ONLY", "S1000");
    }

    public int getRow() throws SQLException {
        return this.currentRow;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw new SQLException("Not supported", "IM001");
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Invalid number of rows specified: " + n, "S1000");
        }
        this.statement.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.statement.fetchSize;
    }

    public int getType() throws SQLException {
        return this.statement.resultSetType;
    }

    public int getConcurrency() throws SQLException {
        return this.statement.resultSetConcurrency;
    }

    public boolean rowUpdated() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public boolean rowInserted() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public boolean rowDeleted() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateNull(int n) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateShort(int n, short s) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateLong(int n, long l) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateString(int n, String string) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateNull(String string) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateShort(String string, short s) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateInt(String string, int n) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateLong(String string, long l) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateString(String string, String string2) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void insertRow() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void refreshRow() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    public synchronized Clob getClob(int n) throws SQLException {
        if (this.statement.getColumnType(n) != -1) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        return (CacheClob)this.getStream(n, 3, -1);
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    public synchronized Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkAndPosition(n);
        return this.statement.input.wire.getDate(calendar);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkAndPosition(n);
        return this.statement.input.wire.getTime(calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkAndPosition(n);
        return this.statement.input.wire.getTimestamp(calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        if (this.statement.getColumnType(n) != -4) {
            throw new SQLException("Restricted data type attribute violation", "07006", 7006);
        }
        return (CacheBlob)this.getStream(n, 2, -4);
    }

    public synchronized Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException("ResultSet concurrency is CONCUR_READ_ONLY", "S1000");
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLException("Not supported.", "IM001");
    }
}

