/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheStatement;
import com.intersys.jdbc.CacheStaticResultSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;

public class CacheUpdatableResultSet
extends CacheStaticResultSet {
    private PreparedStatement update;
    private Statement delete = null;
    private String statementText;
    protected String[] columns;
    protected HashMap values;
    protected boolean onInsertRow = false;
    protected int moveToCurrentRow;

    CacheUpdatableResultSet(CacheStatement cacheStatement) throws SQLException {
        super(cacheStatement);
        this.init();
    }

    public synchronized String getString(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (String)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getString(n);
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Boolean)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getBoolean(n);
    }

    public synchronized byte getByte(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Byte)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getByte(n);
    }

    public synchronized short getShort(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Short)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getShort(n);
    }

    public synchronized int getInt(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Integer)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getInt(n);
    }

    public synchronized long getLong(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Long)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getLong(n);
    }

    public synchronized float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    public synchronized double getDouble(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Double)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getDouble(n);
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (BigDecimal)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getBigDecimal(n);
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (byte[])this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getBytes(n);
    }

    public synchronized Date getDate(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Date)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getDate(n);
    }

    public synchronized Time getTime(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Time)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getTime(n);
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Timestamp)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getTimestamp(n);
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (InputStream)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getAsciiStream(n);
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (InputStream)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getBinaryStream(n);
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Date)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getDate(n, calendar);
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Time)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getTime(n, calendar);
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Timestamp)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getTimestamp(n, calendar);
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Blob)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getBlob(n);
    }

    public synchronized Clob getClob(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return (Clob)this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getClob(n);
    }

    public synchronized Object getObject(int n) throws SQLException {
        this.check(n);
        if (this.values.containsKey(this.columns[n])) {
            return this.values.get(this.columns[n]);
        }
        if (this.onInsertRow) {
            throw new SQLException("Undefined: on insert row but updateXXX was not yet called");
        }
        return super.getObject(n);
    }

    public void updateNull(int n) throws SQLException {
        this.check(n);
        this.updateNull(this.columns[n]);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.check(n);
        this.updateBoolean(this.columns[n], bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.check(n);
        this.updateByte(this.columns[n], by);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.check(n);
        this.updateShort(this.columns[n], s);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.check(n);
        this.updateInt(this.columns[n], n2);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.check(n);
        this.updateLong(this.columns[n], l);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.check(n);
        this.updateFloat(this.columns[n], f);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.check(n);
        this.updateDouble(this.columns[n], d);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.check(n);
        this.updateBigDecimal(this.columns[n], bigDecimal);
    }

    public void updateString(int n, String string) throws SQLException {
        this.check(n);
        this.updateString(this.columns[n], string);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.check(n);
        this.updateBytes(this.columns[n], byArray);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.check(n);
        this.updateDate(this.columns[n], date);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.check(n);
        this.updateTime(this.columns[n], time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.check(n);
        this.updateTimestamp(this.columns[n], timestamp);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.check(n);
        this.updateAsciiStream(this.columns[n], inputStream, n2);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.check(n);
        this.updateBinaryStream(this.columns[n], inputStream, n2);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.check(n);
        this.updateCharacterStream(this.columns[n], reader, n2);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.check(n);
        this.updateObject(this.columns[n], object, n2);
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.check(n);
        this.updateObject(this.columns[n], object);
    }

    public void updateNull(String string) throws SQLException {
        this.check(string);
        this.values.put(string, null);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.check(string);
        this.values.put(string, new Boolean(bl));
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.check(string);
        this.values.put(string, new Byte(by));
    }

    public void updateShort(String string, short s) throws SQLException {
        this.check(string);
        this.values.put(string, new Short(s));
    }

    public void updateInt(String string, int n) throws SQLException {
        this.check(string);
        this.values.put(string, new Integer(n));
    }

    public void updateLong(String string, long l) throws SQLException {
        this.check(string);
        this.values.put(string, new Long(l));
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.check(string);
        this.values.put(string, new Float(f));
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.check(string);
        this.values.put(string, new Double(d));
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.check(string);
        this.values.put(string, bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.check(string);
        this.values.put(string, string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.check(string);
        this.values.put(string, byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.check(string);
        this.values.put(string, date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.check(string);
        this.values.put(string, time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.check(string);
        this.values.put(string, timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.check(string);
        this.values.put(string, new ObjectWrapper(0, inputStream, n));
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.check(string);
        this.values.put(string, new ObjectWrapper(1, inputStream, n));
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.check(string);
        this.values.put(string, new ObjectWrapper(2, reader, n));
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.check(string);
        this.values.put(string, new ObjectWrapper(3, object, n));
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.check(string);
        this.values.put(string, object);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.check(n);
        this.updateBlob(this.columns[n], blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.check(string);
        this.values.put(string, blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.check(n);
        this.updateClob(this.columns[n], clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.check(string);
        this.values.put(string, clob);
    }

    public void insertRow() throws SQLException {
        int n;
        if (!this.onInsertRow) {
            throw new SQLException("The cursor is currently not positioned on the insert row");
        }
        this.statementText = "INSERT INTO " + this.statement.updatableRSTableName + " (";
        for (n = 1; n < this.columns.length - 1; ++n) {
            this.statementText = this.statementText + this.columns[n] + ", ";
        }
        this.statementText = this.statementText + this.columns[this.columns.length - 1] + ") VALUES (";
        for (n = 1; n < this.columns.length - 1; ++n) {
            this.statementText = this.statementText + "?,";
        }
        this.statementText = this.statementText + "?)";
        this.update = this.statement.connection.prepareStatement(this.statementText);
        for (n = 1; n < this.columns.length; ++n) {
            if (this.values.containsKey(this.columns[n])) {
                Object v = this.values.get(this.columns[n]);
                if (v instanceof ObjectWrapper) {
                    this.setObjectWrapper(this.update, n, (ObjectWrapper)v);
                    continue;
                }
                this.update.setObject(n, v);
                continue;
            }
            if (this.statement.getColumnNullable(n) != 0) {
                this.update.setNull(n, this.statement.getColumnType(n));
                continue;
            }
            throw new SQLException("Not all non-nullable columns in the insert row have value");
        }
        this.update.executeUpdate();
        this.onInsertRow = false;
    }

    public void updateRow() throws SQLException {
        Object k2;
        Iterator iterator;
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        if (this.values.size() == 0) {
            throw new SQLException("No values to update specified");
        }
        this.statementText = "UPDATE " + this.statement.updatableRSTableName + " SET ";
        Iterator iterator2 = iterator = this.values.keySet().iterator();
        if (iterator.hasNext()) {
            k2 = iterator.next();
            this.statementText = this.statementText + (String)k2 + " = ?";
        }
        while (iterator.hasNext()) {
            k2 = iterator.next();
            this.statementText = this.statementText + ", " + (String)k2 + " = ?";
        }
        this.statementText = this.statementText + " WHERE " + this.columns[0] + " = ?";
        this.update = this.statement.connection.prepareStatement(this.statementText);
        int n = 1;
        for (Object k2 : this.values.keySet()) {
            Object v = this.values.get(k2);
            if (v instanceof ObjectWrapper) {
                this.setObjectWrapper(this.update, n, (ObjectWrapper)v);
            } else {
                this.update.setObject(n, v);
            }
            ++n;
        }
        this.update.setInt(n, this.rowID);
        this.update.executeUpdate();
    }

    public void deleteRow() throws SQLException {
        if (this.onInsertRow || this.isAfterLast) {
            throw new SQLException("Invalid cursor position");
        }
        if (this.delete == null) {
            this.delete = this.statement.connection.createStatement();
        }
        this.delete.executeUpdate("DELETE FROM " + this.statement.updatableRSTableName + " WHERE " + this.columns[0] + " = " + this.rowID);
        this.currentRow = 0;
        this.closed = false;
        this.isAfterLast = false;
        this.currentColumn = this.statement.columns.size() + 1;
    }

    public void refreshRow() throws SQLException {
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
    }

    public void moveToInsertRow() throws SQLException {
        this.onInsertRow = true;
        this.moveToCurrentRow = this.isAfterLast ? 0 : this.currentRow;
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.onInsertRow) {
            this.currentRow = this.moveToCurrentRow;
        }
        this.onInsertRow = false;
    }

    public synchronized boolean next() throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet closed", "S1000", 460);
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        if (this.statement.resultSetType == 1003) {
            if (this.statement.maxRows != 0 && this.currentRow == this.statement.maxRows) {
                return false;
            }
            this.currentColumn = this.statement.input.wire.advance(this.currentColumn, this.statement.columns.size() + 1);
            if (this.currentColumn != this.statement.columns.size() + 1 || this.statement.input.wire.isEnd()) {
                if (this.statement.fetchDone) {
                    this.isAfterLast = true;
                    return false;
                }
                this.fetchMoreData();
                this.currentColumn = this.statement.input.wire.advance(this.currentColumn, this.statement.columns.size() + 1);
            }
            this.statement.input.wire.saveCurrentRowPosition();
            this.currentColumn = 1;
            ++this.currentRow;
            this.rowID = this.getRowID();
            return true;
        }
        boolean bl = super.next();
        if (bl) {
            this.rowID = this.getRowID();
        }
        return bl;
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        return super.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        return super.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        return super.isFirst();
    }

    public boolean isLast() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        return super.isLast();
    }

    public void beforeFirst() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        super.beforeFirst();
    }

    public void afterLast() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        super.afterLast();
    }

    public boolean first() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        return super.first();
    }

    public boolean last() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        return super.last();
    }

    public boolean absolute(int n) throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        return super.absolute(n);
    }

    public boolean relative(int n) throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        return super.relative(n);
    }

    public boolean previous() throws SQLException {
        if (this.statement.resultSetType == 1003) {
            throw new SQLException("Result set not scrollable");
        }
        if (this.onInsertRow) {
            throw new SQLException("The cursor is currently positioned on the insert row");
        }
        this.values.clear();
        return super.previous();
    }

    public int getType() throws SQLException {
        return this.statement.resultSetType;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    private void init() throws SQLException {
        int n = this.statement.columns.size();
        if (n <= 0) {
            throw new SQLException("Invalid result set");
        }
        if (this.statement.updatableRSTableName == null) {
            this.statement.updatableRSTableName = this.statement.getColumnTableName(1);
            String string = this.statement.getColumnSchemaName(1);
            this.statement.updatableRSColumnNames = new String[n];
            this.statement.updatableRSColumnNames[0] = this.statement.getColumnName(1);
            this.statement.columns.remove(0);
            for (int i = 1; i < n; ++i) {
                if (!this.statement.updatableRSTableName.equals(this.statement.getColumnTableName(i))) {
                    throw new SQLException("Positioned updates are only supported whenthe query references a single table");
                }
                this.statement.updatableRSColumnNames[i] = this.statement.getColumnName(i);
            }
            this.statement.updatableRSTableName = string + "." + this.statement.updatableRSTableName;
        }
        this.values = new HashMap();
        this.currentColumn = this.statement.columns.size() + 1;
        this.columns = this.statement.updatableRSColumnNames;
    }

    protected synchronized boolean staticFetch(int n, int n2) throws SQLException {
        boolean bl = super.staticFetch(n, n2);
        if (bl) {
            this.rowID = this.getRowID();
        }
        return bl;
    }

    private void setObjectWrapper(PreparedStatement preparedStatement, int n, ObjectWrapper objectWrapper) throws SQLException {
        if (objectWrapper.type == 0) {
            preparedStatement.setAsciiStream(n, (InputStream)objectWrapper.obj, objectWrapper.lengthOrScale);
        } else if (objectWrapper.type == 1) {
            preparedStatement.setBinaryStream(n, (InputStream)objectWrapper.obj, objectWrapper.lengthOrScale);
        } else if (objectWrapper.type == 2) {
            preparedStatement.setCharacterStream(n, (Reader)objectWrapper.obj, objectWrapper.lengthOrScale);
        } else {
            int n2 = this.statement.getColumnType(n);
            if (n2 == 3 || n2 == 2) {
                preparedStatement.setObject(n, objectWrapper.obj, n2, objectWrapper.lengthOrScale);
            } else {
                preparedStatement.setObject(n, objectWrapper.obj);
            }
        }
    }

    private void check(int n) throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet closed", "S1000", 460);
        }
        if (n <= 0 || n >= this.columns.length) {
            throw new SQLException("Invalid column number", "S1002", 463);
        }
    }

    private void check(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet closed", "S1000", 460);
        }
        for (int i = 1; i <= this.columns.length + 1; ++i) {
            if (!this.columns[i].equalsIgnoreCase(string)) continue;
            return;
        }
        throw new SQLException("Invalid column name: " + string, "S1002", 463);
    }

    private class ObjectWrapper {
        static final int ASCII_STREAM = 0;
        static final int BINARY_STREAM = 1;
        static final int CHARACTER_STREAM = 2;
        static final int OBJECT_WITH_SCALE = 3;
        int type;
        Object obj;
        int lengthOrScale;

        ObjectWrapper(int n, Object object, int n2) {
            this.obj = object;
            this.type = n;
            this.lengthOrScale = n2;
        }
    }
}

