/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.cache.Dataholder;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.Persistent;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CandidateKeyInfo;
import com.intersys.objects.reflect.SQLColumn;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class CandidateKey
implements Serializable {
    private String[] mKeys;
    private transient CandidateKeyInfo mMetadata;

    public CandidateKey(CandidateKeyInfo candidateKeyInfo) {
        this.init(candidateKeyInfo);
    }

    public CandidateKey(CandidateKeyInfo candidateKeyInfo, String string) throws CacheException {
        this.init(candidateKeyInfo);
        this.set(string);
    }

    private void init(CandidateKeyInfo candidateKeyInfo) {
        this.mMetadata = candidateKeyInfo;
        this.mKeys = new String[this.mMetadata.getLength()];
    }

    public void set(String string) throws CacheException {
        int n = this.mMetadata.getLength();
        String string2 = ",";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        if (stringTokenizer.countTokens() != n) {
            throw new CacheException("Inconsistent data for primary key" + this.mMetadata.getSQLName() + ". Required: " + n + " values, supplied: " + stringTokenizer.countTokens() + " values");
        }
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.mKeys[n2] = stringTokenizer.nextToken();
            ++n2;
        }
    }

    public void set(int n, String string) {
        this.mKeys[n] = string;
    }

    public void set(String string, String string2) throws CacheException {
        int n = this.mMetadata.getColumnNumber(string);
        this.mKeys[n] = string2;
    }

    public Object toSysList() throws SQLException {
        Object object = SysListProxy.createSysList(new ConnectionInfo());
        for (int i = 0; i < this.mKeys.length; ++i) {
            SysListProxy.setString(object, this.mKeys[i]);
        }
        return object;
    }

    public void toStatement(PreparedStatement preparedStatement, int n) throws SQLException {
        for (int i = 0; i < this.mKeys.length; ++i) {
            preparedStatement.setString(n + i, this.mKeys[i]);
        }
    }

    public void setFromObject(ObjectHandle objectHandle) throws CacheException {
        SQLColumn[] sQLColumnArray = this.mMetadata.getColumns();
        if (sQLColumnArray == null || sQLColumnArray.length == 0) {
            return;
        }
        for (int i = 0; i < sQLColumnArray.length; ++i) {
            SQLColumn sQLColumn = sQLColumnArray[i];
            CacheField cacheField = sQLColumn.getField();
            Object object = cacheField.get(objectHandle);
            if (object instanceof Persistent) {
                object = ((Persistent)object).getId();
            }
            this.mKeys[i] = object.toString();
        }
    }

    public String getOpenMethodName() {
        return this.mMetadata.getOpenMethodName();
    }

    public int getLength() {
        return this.mMetadata.getLength();
    }

    public String getSQLName() {
        return this.mMetadata.getSQLName();
    }

    public String getObjectName() {
        return this.mMetadata.getObjectName();
    }

    public boolean isPrimaryKey() {
        return this.mMetadata.isPrimaryKey();
    }

    public boolean isIdKey() {
        return this.mMetadata.isIdKey();
    }

    public String[] toArray() {
        return (String[])this.mKeys.clone();
    }

    public void fillArguments(Dataholder[] dataholderArray) throws CacheException {
        for (int i = 0; i < this.mKeys.length; ++i) {
            dataholderArray[i] = new Dataholder(this.mKeys[i]);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.mMetadata.toString()).append(" [");
        this.toStringBuffer(stringBuffer, ",");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringValue() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringBuffer(stringBuffer, ",");
        return stringBuffer.toString();
    }

    public String toIdValue() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringBuffer(stringBuffer, "||");
        return stringBuffer.toString();
    }

    private void toStringBuffer(StringBuffer stringBuffer, String string) {
        for (int i = 0; i < this.mKeys.length; ++i) {
            stringBuffer.append(this.mKeys[i]);
            if (i >= this.mKeys.length - 1) continue;
            stringBuffer.append(string);
        }
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.mKeys.length; ++i) {
            if (this.mKeys[i] == null) continue;
            n += this.mKeys[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CandidateKey)) {
            return false;
        }
        CandidateKey candidateKey = (CandidateKey)object;
        if (!this.mMetadata.equals(candidateKey.mMetadata)) {
            return false;
        }
        for (int i = 0; i < this.mKeys.length; ++i) {
            if (this.mKeys[i] == null) {
                if (candidateKey.mKeys[i] == null) continue;
                return false;
            }
            if (this.mKeys[i].equals(candidateKey.mKeys[i])) continue;
            return false;
        }
        return true;
    }
}

