/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.transaction.xa;

import com.intersys.jdbc.CacheConnection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class CacheXAResource
implements XAResource {
    protected XAConnection xacon;
    private CacheConnection conn;
    private Xid currentXid;
    private int timeout;
    protected String user;
    protected String password;
    protected HashMap xidToConnectionMap;

    public CacheXAResource(XAConnection xAConnection, String string, String string2) {
        this.xacon = xAConnection;
        this.currentXid = null;
        this.user = string;
        this.password = string2;
        this.xidToConnectionMap = new HashMap();
        try {
            this.conn = (CacheConnection)xAConnection.getConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void commit(Xid xid, boolean bl) throws XAException {
        if (this.conn.logFile != null) {
            this.conn.logFile.logApi("XA commit xid = " + xid.toString() + " onePhase = " + bl);
        }
        if (this.currentXid != xid) {
            throw new XAException("Only able to commit the transaction associated with the following Xid: " + this.currentXid);
        }
        try {
            if (this.conn == null) {
                throw new XAException("Unable to commit: Physical connection closed");
            }
            int n = this.conn.sendXAMessage(CacheConnection.XA_COMMIT, xid.toString());
            if (n != 0) {
                throw new XAException("XA Commit returned: " + n);
            }
        }
        catch (SQLException sQLException) {
            throw new XAException("Communication link failure");
        }
    }

    public final void end(Xid xid, int n) throws XAException {
        if (this.conn.logFile != null) {
            this.conn.logFile.logApi("XA end xid = " + xid.toString() + " flags = " + n);
        }
        if (this.currentXid != xid) {
            throw new XAException("Only able to end the transaction associated with the following Xid: " + this.currentXid);
        }
        try {
            if (this.conn == null) {
                throw new XAException("Unable to end: Physical connection closed");
            }
            int n2 = this.conn.sendXAMessage(CacheConnection.XA_END, xid.toString());
            if (n2 != 0) {
                throw new XAException("XA End returned: " + n2);
            }
        }
        catch (SQLException sQLException) {
            throw new XAException("Communication link failure");
        }
    }

    public final void forget(Xid xid) throws XAException {
        if (this.conn.logFile != null) {
            this.conn.logFile.logApi("XA forget xid = " + xid.toString());
        }
        if (this.currentXid != xid) {
            throw new XAException("Only able to end the transaction associated with the following Xid: " + this.currentXid);
        }
        try {
            if (this.conn == null) {
                throw new XAException("Unable to forget: Physical connection closed");
            }
            int n = this.conn.sendXAMessage(CacheConnection.XA_FORGET, xid.toString());
            if (n != 0) {
                throw new XAException("XA Forget returned: " + n);
            }
        }
        catch (SQLException sQLException) {
            throw new XAException("Communication link failure");
        }
    }

    public final int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    public final boolean isSameRM(XAResource xAResource) throws XAException {
        return this == xAResource;
    }

    public final int prepare(Xid xid) throws XAException {
        if (this.conn.logFile != null) {
            this.conn.logFile.logApi("XA prepare xid = " + xid.toString());
        }
        if (this.currentXid != xid) {
            throw new XAException("Only able to prepare the transaction associated with the following Xid: " + this.currentXid);
        }
        if (this.conn == null) {
            throw new XAException("Unable to prepare: Physical connection closed");
        }
        try {
            int n = this.conn.sendXAMessage(CacheConnection.XA_PREPARE, xid.toString());
            if (n != 0) {
                return 0;
            }
            throw new XAException("XA Prepare returned: " + n);
        }
        catch (SQLException sQLException) {
            throw new XAException("Communication link failure");
        }
    }

    public final Xid[] recover(int n) throws XAException {
        if (this.conn.logFile != null) {
            this.conn.logFile.logApi("XA recover flag = " + n);
        }
        try {
            if (this.conn == null) {
                throw new XAException("Unable to recover: Physical connection closed");
            }
            int n2 = this.conn.sendXAMessage(CacheConnection.XA_RECOVER, null);
            if (n2 != 0) {
                throw new XAException("XA Recover returned: " + n2);
            }
        }
        catch (SQLException sQLException) {
            throw new XAException("Communication link failure");
        }
        return null;
    }

    public final void rollback(Xid xid) throws XAException {
        if (this.conn.logFile != null) {
            this.conn.logFile.logApi("XA rollback xid = " + xid.toString());
        }
        if (this.currentXid != xid) {
            throw new XAException("Only able to rollback the transaction associated with the following Xid: " + this.currentXid);
        }
        try {
            if (this.conn == null) {
                throw new XAException("Unable to rollback: Physical connection closed");
            }
            int n = this.conn.sendXAMessage(CacheConnection.XA_ROLLBACK, xid.toString());
            if (n != 0) {
                throw new XAException("XA Rollback returned: " + n);
            }
        }
        catch (SQLException sQLException) {
            throw new XAException("Communication link failure");
        }
    }

    public final boolean setTransactionTimeout(int n) throws XAException {
        this.timeout = n;
        return true;
    }

    public final void start(Xid xid, int n) throws XAException {
        if (this.conn.logFile != null) {
            this.conn.logFile.logApi("XA start xid = " + xid.toString() + " flags = " + n);
        }
        this.currentXid = xid;
        try {
            if (this.conn == null) {
                throw new XAException("Unable to start: Physical connection not available");
            }
            int n2 = this.conn.sendXAMessage(CacheConnection.XA_START, xid.toString());
            if (n2 != 0) {
                throw new XAException("XA Start returned: " + n2);
            }
            this.xidToConnectionMap.put(xid, this.conn);
        }
        catch (SQLException sQLException) {
            throw new XAException("Communication link failure");
        }
    }
}

