/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools;

import com.jalapeno.tools.SchemaBuilder;
import com.jalapeno.tools.objects.common.Messages;
import com.jalapeno.tools.objects.gui.Helper;
import com.jalapeno.tools.objects.gui.wizard.Wizard;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.swing.JOptionPane;

public class SchemaBuilderWizard {
    private Properties mConfigProperties = new Properties();
    private SchemaBuilder mSchemaBuilder;
    private Connection mConnection;
    private boolean mIsConnected;
    public static final String CONNECTION_EXCEPTION = "GeneratorGUI.60";
    private static final String RUN_EXCEPTION = "GeneratorGUI.61";
    Wizard mWizard = Wizard.getWizard();
    private static final String WIZARD_TITLE = Messages.getString("SchemaBuilderWizard.GENERATE_CACHE_CLASSES");

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SchemaBuilderWizard.createAndShowWizard();
            }
        });
    }

    public static void createAndShowWizard() {
        new SchemaBuilderWizard();
    }

    SchemaBuilderWizard() {
        this.setFromConfigPropertiesFile();
        this.initialize();
    }

    public void registerAll() {
        this.mWizard.registerAll(this);
    }

    public void initialize() {
        this.mWizard.getFrame().setTitle(WIZARD_TITLE);
        this.registerAll();
        this.mWizard.setCurrentPanel("LOGIN_PANEL");
        int n = this.mWizard.showFrame();
    }

    public static void setFromConfigPropertiesFile(Properties properties, String string) {
        boolean bl = true;
        FileInputStream fileInputStream = null;
        File file = null;
        try {
            file = new File(string);
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            bl = false;
        }
        if (bl) {
            try {
                properties.load(fileInputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setFromConfigPropertiesFile() {
        SchemaBuilderWizard.setFromConfigPropertiesFile(this.mConfigProperties, this.mWizard.getConfigFileName());
        this.mSchemaBuilder = SchemaBuilder.getRunPersister(this.mConfigProperties);
        this.mWizard.setPersisterProperties(this.mSchemaBuilder.getPersisterProperties());
        this.mWizard.setRunPersisterWizard(this);
    }

    public void writePropertiesToConfigFile(String string) {
        this.mSchemaBuilder.getPersisterProperties().setLogFile(string);
        this.writePropertiesToConfigFile();
    }

    public void writePropertiesToConfigFile() {
        this.mSchemaBuilder.getPersisterProperties().writePropertiesToConfigFile(this.mConfigProperties, this.mWizard.getConfigFileName());
    }

    public void connect() {
        try {
            this.mSchemaBuilder = SchemaBuilder.getRunPersister(this.mConfigProperties, this.mSchemaBuilder.getPersisterProperties().getPassword());
            this.mIsConnected = true;
            this.mConnection = this.mSchemaBuilder.getDB();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.processConnectionException(classNotFoundException);
        }
        catch (SQLException sQLException) {
            this.processConnectionException(sQLException);
        }
    }

    public void processConnectionException(Exception exception) {
        this.mIsConnected = false;
        JOptionPane.showMessageDialog(this.mWizard.getOwner(), Helper.wordwrap(Messages.getString(CONNECTION_EXCEPTION) + exception.getMessage()));
    }

    public void processRunException(Exception exception) {
        this.mIsConnected = false;
        JOptionPane.showMessageDialog(this.mWizard.getOwner(), Helper.wordwrap(Messages.getString(RUN_EXCEPTION) + exception.getMessage()));
    }

    public void processException(Exception exception) {
        this.mIsConnected = false;
        JOptionPane.showMessageDialog(this.mWizard.getOwner(), Helper.wordwrap(Messages.getString(RUN_EXCEPTION) + exception.getMessage()));
    }

    public SchemaBuilder getRunPersister() {
        return this.mSchemaBuilder;
    }

    public boolean isConnected() {
        return this.mIsConnected;
    }

    public Connection getConnection() {
        return this.mConnection;
    }

    public Wizard getWizard() {
        return this.mWizard;
    }

    public void repack() {
        this.mWizard.repack();
    }

    public Properties getConfigProperties() {
        return this.mConfigProperties;
    }
}

