/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CacheRelationshipInfo;
import com.jalapeno.tools.objects.ClassMetadata;
import com.jalapeno.tools.objects.HibernateHandler;
import com.jalapeno.tools.objects.Java2DBMapping;
import com.jalapeno.tools.objects.PropertyMetadata;
import com.jalapeno.tools.objects.ProviderTest;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HibernateProvider
implements Java2DBMapping {
    private HashMap<Class, ClassMetadata> classMetadata;

    public HibernateProvider(String string) throws Throwable {
        HibernateHandler hibernateHandler = new HibernateHandler();
        this.classMetadata = hibernateHandler.parse(string);
    }

    public HibernateProvider() throws Exception {
    }

    public String cacheClassNameFor(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getClassName();
    }

    public String sqlTableNameFor(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getSQLTableName();
    }

    public String primaryKeyNameFor(Class clazz) {
        return null;
    }

    public CacheIndexInfo[] allIndicesFor(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getIndices();
    }

    public int getAccessLevel(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return -1;
        }
        return classMetadata.getAccessLevel();
    }

    public int getAccessType(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return -1;
        }
        return classMetadata.getAccessType();
    }

    public String getJavaProjectionPackage(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getJavaProjectionPackageName();
    }

    public String getJavaProjectionClassName(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getJavaProjectionClassName();
    }

    public String cacheFieldNameFor(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getName();
    }

    public String cacheFieldTypeFor(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getType();
    }

    public int getPropertyKind(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return -1;
        }
        return propertyMetadata.getKind();
    }

    public boolean isFetchTypeEager(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return false;
        }
        return propertyMetadata.isFetchTypeEager();
    }

    public CacheRelationshipInfo relationshipFor(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getRelationshipMetadata();
    }

    public boolean isSerial(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return false;
        }
        return classMetadata.getIsSerial();
    }

    public String getVersionID(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getVersionID();
    }

    public boolean isClassTransient(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return false;
        }
        return classMetadata.isTransient();
    }

    public boolean isPropertyRequired(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return false;
        }
        return propertyMetadata.isRequired();
    }

    public boolean isMemberTransient(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return false;
        }
        return propertyMetadata.isTransient();
    }

    public Map getPropertyParameters(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getPropertyParameters();
    }

    public String getDatabaseID(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getDatabaseID();
    }

    public int getDatabaseIDType(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return -1;
        }
        return classMetadata.getDatabaseIDType();
    }

    public void close() {
        this.classMetadata.clear();
    }

    public boolean isPopulatable(Class clazz) {
        return false;
    }

    public boolean isXMLSerializable(Class clazz) {
        return false;
    }

    public Map getClassParameters(Class clazz) {
        return null;
    }

    public String getExtendedClass(Class clazz) {
        return null;
    }

    public String[] getImplementedClasses(Class clazz) {
        return null;
    }

    private boolean isAccessor(Method method) {
        String string = method.getName();
        if (!string.startsWith("set") && !string.startsWith("get")) {
            return false;
        }
        return !(string.startsWith("get") ? method.getParameterTypes().length != 0 || method.getReturnType() == null : method.getParameterTypes().length != 1 || method.getReturnType() != null);
    }

    private PropertyMetadata getPropertyMetadata(Object object) {
        Member member = (Member)object;
        ((AccessibleObject)((Object)member)).setAccessible(true);
        ClassMetadata classMetadata = this.classMetadata.get(member.getDeclaringClass());
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getPropertyMetadata(member);
    }

    public boolean isPropertyAnnotated(Member member) {
        return this.getPropertyMetadata(member) != null;
    }

    public Class[] getPersistedClasses() {
        Set<Class> set = this.classMetadata.keySet();
        return set.toArray(new Class[set.size()]);
    }

    public static void main(String[] stringArray) throws Throwable {
        HibernateProvider hibernateProvider = new HibernateProvider(stringArray[0]);
        Class[] classArray = hibernateProvider.getPersistedClasses();
        for (int i = 0; i < classArray.length; ++i) {
            ProviderTest.test(hibernateProvider, classArray[i]);
        }
    }

    private ClassMetadata getClassMetadata(Class clazz) {
        HashMap<Class, ClassMetadata> hashMap;
        ClassMetadata classMetadata = null;
        if (this.classMetadata != null && this.classMetadata.containsKey(clazz)) {
            classMetadata = this.classMetadata.get(clazz);
            return classMetadata;
        }
        HibernateHandler hibernateHandler = new HibernateHandler(clazz);
        InputStream inputStream = this.lookupFile(clazz);
        if (inputStream == null) {
            this.classMetadata.put(clazz, null);
            return null;
        }
        try {
            hashMap = hibernateHandler.parse(inputStream);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Failed to parse metadata for class: " + clazz.getName(), throwable);
        }
        classMetadata = hashMap.get(clazz);
        if (classMetadata == null) {
            throw new IllegalArgumentException("No metadata for class " + clazz.getName() + " was not found in corresponding file.");
        }
        if (this.classMetadata == null) {
            this.classMetadata = hashMap;
        } else {
            this.classMetadata.putAll(hashMap);
        }
        return classMetadata;
    }

    private InputStream lookupFile(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        String string2 = string + ".hbm.xml";
        InputStream inputStream = clazz.getResourceAsStream(string2);
        return inputStream;
    }
}

