/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CacheRelationshipInfo;
import com.jalapeno.tools.objects.AnnotationProvider;
import com.jalapeno.tools.objects.Java2DBMapping;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public class ProviderTest {
    public static void test(Java2DBMapping java2DBMapping, Class clazz) throws Throwable {
        int n;
        String string;
        String string2;
        String string3;
        String string4;
        System.out.println("Cache Name: " + java2DBMapping.cacheClassNameFor(clazz));
        if (java2DBMapping.isClassTransient(clazz)) {
            System.out.println("Class is marked as Transient");
            return;
        }
        if (java2DBMapping.isSerial(clazz)) {
            System.out.println("This is a Serial/Embeddable Class.");
        }
        if ((string4 = java2DBMapping.sqlTableNameFor(clazz)) != null) {
            System.out.println("Table Name: " + string4);
        }
        if ((string3 = java2DBMapping.primaryKeyNameFor(clazz)) != null) {
            System.out.println("Primary Key: " + string3);
        }
        System.out.print("AccessLevel: " + java2DBMapping.getAccessLevel(clazz));
        System.out.println("    AccessType: " + java2DBMapping.getAccessType(clazz));
        String string5 = java2DBMapping.getJavaProjectionPackage(clazz);
        String string6 = java2DBMapping.getJavaProjectionClassName(clazz);
        if (string5 != null) {
            System.out.println("ProjectionPackage: " + string5);
        }
        if (string6 != null) {
            System.out.println("ProjectionClass: " + string6);
        }
        if ((string2 = java2DBMapping.getDatabaseID(clazz)) != null) {
            System.out.print("ID: " + string2);
            System.out.println("  ID Type: " + java2DBMapping.getDatabaseIDType(clazz));
        }
        if ((string = java2DBMapping.getVersionID(clazz)) != null) {
            System.out.println("Version ID: " + string);
        }
        System.out.print("Indices:");
        CacheIndexInfo[] cacheIndexInfoArray = java2DBMapping.allIndicesFor(clazz);
        if (cacheIndexInfoArray != null) {
            for (n = 0; n < cacheIndexInfoArray.length; ++n) {
                ProviderTest.dumpIndexInfo(java2DBMapping, cacheIndexInfoArray[n]);
            }
        } else {
            System.out.println(" (none)");
        }
        System.out.println("Properties/Methods:");
        Field[] fieldArray = clazz.getDeclaredFields();
        for (n = 0; n < fieldArray.length; ++n) {
            ProviderTest.dumpPropertyInfo(java2DBMapping, fieldArray[n]);
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        for (n = 0; n < methodArray.length; ++n) {
            String string7 = methodArray[n].getName();
            if (!string7.startsWith("get") && !string7.startsWith("set")) continue;
            try {
                String string8 = string7.substring(3, 4).toLowerCase() + string7.substring(4, string7.length());
                Field field = clazz.getDeclaredField(string8);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                ProviderTest.dumpPropertyInfo(java2DBMapping, methodArray[n]);
            }
        }
    }

    private static void dumpPropertyInfo(Java2DBMapping java2DBMapping, Member member) {
        if (member instanceof Method) {
            System.out.println("\tMethod: " + member.getName());
        } else {
            System.out.println("\tProperty: " + member.getName());
        }
        if (java2DBMapping instanceof AnnotationProvider && !((AnnotationProvider)java2DBMapping).isPropertyAnnotated(member)) {
            System.out.println("\tNo annotations found.");
            System.out.println();
            return;
        }
        if (java2DBMapping.isMemberTransient(member)) {
            System.out.println("Class is marked as Transient");
            return;
        }
        if (java2DBMapping.isFetchTypeEager(member)) {
            System.out.println("Fetch Type: Eager.");
        }
        System.out.println("\tField Name: " + java2DBMapping.cacheFieldNameFor(member));
        String string = java2DBMapping.cacheFieldTypeFor(member);
        if (string != null) {
            System.out.println("\tField Type: " + string);
        }
        System.out.println("\tProperty Kind: " + java2DBMapping.getPropertyKind(member));
        CacheRelationshipInfo cacheRelationshipInfo = java2DBMapping.relationshipFor(member);
        if (cacheRelationshipInfo != null) {
            System.out.print("\tRelationship: ");
            if (cacheRelationshipInfo.pointsToManyOrChildren) {
                System.out.println("(ONE_TO_MANY)");
            } else {
                System.out.println("(MANY_TO_ONE)");
            }
            if (cacheRelationshipInfo.parentChild) {
                System.out.println("\t\t This is a parent-child relationship");
            }
            System.out.println("\t\tInverse : " + cacheRelationshipInfo.inverseClass);
            System.out.println("\t\tInverse Field: " + cacheRelationshipInfo.inverseField);
        }
        System.out.println();
    }

    private static void dumpIndexInfo(Java2DBMapping java2DBMapping, CacheIndexInfo cacheIndexInfo) throws Exception {
        System.out.println();
        System.out.println("\tName : " + cacheIndexInfo.getName());
        System.out.println("\tSQLName : " + cacheIndexInfo.getSQLName());
        System.out.println("\tProperty Names : " + cacheIndexInfo.getProperties());
        System.out.println("\tisPrimaryKey : " + cacheIndexInfo.isPrimaryKey());
        System.out.println("\tisUnique : " + cacheIndexInfo.isUnique());
        System.out.println();
    }
}

