/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects.gui;

import com.jalapeno.tools.objects.gui.DirProvider;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DirUtility {
    private JButton jSelectDir = null;
    private JPanel jDirPanel = null;
    private JTextField jDirTextField = null;
    private JFileChooser jDirChooser = null;
    DirProvider mParent;
    private String mButtonText;
    private DocumentListener mDocumentListener;

    DirUtility(DirProvider dirProvider, String string) {
        this.mParent = dirProvider;
        this.mButtonText = string;
    }

    public void setDir(String string) {
        this.jDirTextField.setText(string);
    }

    public String getDir() {
        return this.jDirTextField.getText();
    }

    public JPanel getJDirPanel() {
        if (this.jDirPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            this.jDirPanel = new JPanel();
            this.jDirPanel.setLayout(new GridBagLayout());
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 7;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.jDirPanel.add((Component)this.getJSelectDir(), gridBagConstraints2);
            this.jDirPanel.add((Component)this.getJDirTextField(), gridBagConstraints);
        }
        return this.jDirPanel;
    }

    private JButton getJSelectDir() {
        if (this.jSelectDir == null) {
            this.jSelectDir = new JButton();
            this.jSelectDir.setText(this.mButtonText);
            this.jSelectDir.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DirUtility.this.getDirFromFileChooserDialog();
                }
            });
        }
        return this.jSelectDir;
    }

    private JTextField getJDirTextField() {
        if (this.jDirTextField == null) {
            this.mDocumentListener = new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    DirUtility.this.mParent.action(DirUtility.this.jDirTextField.getText());
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    DirUtility.this.mParent.action(DirUtility.this.jDirTextField.getText());
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    DirUtility.this.mParent.action(DirUtility.this.jDirTextField.getText());
                }
            };
            this.jDirTextField = new JTextField();
            this.jDirTextField.getDocument().addDocumentListener(this.mDocumentListener);
        }
        return this.jDirTextField;
    }

    private void getDirFromFileChooserDialog() {
        String string = this.jDirTextField.getText();
        if (this.jDirChooser == null) {
            this.jDirChooser = new JFileChooser();
            this.jDirChooser.setFileSelectionMode(1);
        }
        this.jDirChooser.setCurrentDirectory(new File(string));
        int n = this.jDirChooser.showOpenDialog((Component)((Object)this.mParent));
        if (n == 0) {
            this.jDirTextField.setText(this.jDirChooser.getSelectedFile().getAbsolutePath());
            this.mParent.action(this.jDirTextField.getText());
        }
    }
}

