/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.AbstractPreparedStatement;
import org.firebirdsql.jdbc.FBEscapedCallParser;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBProcedureCall;
import org.firebirdsql.jdbc.FBProcedureParam;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdCallableStatement;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.TypeConvertionException;

public abstract class AbstractCallableStatement
extends AbstractPreparedStatement
implements CallableStatement,
FirebirdCallableStatement {
    static final String NATIVE_CALL_COMMAND = "EXECUTE PROCEDURE";
    static final String NATIVE_SELECT_COMMAND = "SELECT * FROM";
    private ResultSet currentRs;
    protected boolean selectableProcedure;
    protected FBProcedureCall procedureCall;
    private ArrayList batchList = new ArrayList();

    protected AbstractCallableStatement(GDSHelper c, String sql, int rsType, int rsConcurrency, int rsHoldability, FBObjectListener.StatementListener statementListener, FBObjectListener.BlobListener blobListener) throws SQLException {
        super(c, rsType, rsConcurrency, rsHoldability, statementListener, blobListener);
        DatabaseParameterBuffer dpb = c.getDatabaseParameterBuffer();
        int mode = 0;
        if (dpb.hasArgument(134)) {
            mode = 1;
        }
        FBEscapedCallParser parser = new FBEscapedCallParser(mode);
        this.procedureCall = parser.parseCall(this.nativeSQL(sql));
    }

    public void addBatch() throws SQLException {
        this.batchList.add(this.procedureCall.clone());
    }

    public void clearBatch() throws SQLException {
        this.batchList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            boolean success = false;
            try {
                int[] nArray;
                this.notifyStatementStarted();
                ArrayList<Integer> results = new ArrayList<Integer>(this.batchList.size());
                Iterator iterator = this.batchList.iterator();
                try {
                    while (iterator.hasNext()) {
                        this.procedureCall = (FBProcedureCall)iterator.next();
                        try {
                            this.prepareFixedStatement(this.procedureCall.getSQL(this.selectableProcedure), true);
                            if (this.internalExecute(!this.selectableProcedure)) {
                                throw new BatchUpdateException(this.toArray(results));
                            }
                            results.add(new Integer(this.getUpdateCount()));
                        }
                        catch (GDSException ex) {
                            throw new BatchUpdateException(ex.getMessage(), "", ex.getFbErrorCode(), this.toArray(results));
                        }
                    }
                    success = true;
                    nArray = this.toArray(results);
                }
                catch (Throwable throwable) {
                    this.clearBatch();
                    throw throwable;
                }
                this.clearBatch();
                return nArray;
            }
            finally {
                this.notifyStatementCompleted(success);
            }
        }
    }

    public void setSelectableProcedure(boolean selectableProcedure) {
        this.selectableProcedure = selectableProcedure;
    }

    protected void setRequiredTypes() throws SQLException {
        FBResultSet resultSet = (FBResultSet)this.getCurrentResultSet();
        for (FBProcedureParam param : this.procedureCall.getOutputParams()) {
            if (param == null) continue;
            FBField field = resultSet.getField(this.procedureCall.mapOutParamIndexToPosition(param.getIndex()), false);
            field.setRequiredType(param.getType());
        }
    }

    protected void prepareFixedStatement(String sql, boolean describeBind) throws GDSException, SQLException {
        if (this.fixedStmt != null) {
            return;
        }
        super.prepareFixedStatement(sql, describeBind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        Object syncObject;
        this.statementListener.executionStarted(this);
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.prepareFixedStatement(this.procedureCall.getSQL(this.selectableProcedure), true);
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
        return super.getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        Object syncObject;
        boolean hasResultSet = false;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            try {
                try {
                    this.currentRs = null;
                    this.prepareFixedStatement(this.procedureCall.getSQL(this.selectableProcedure), true);
                    hasResultSet = this.internalExecute(!this.selectableProcedure);
                    if (hasResultSet) {
                        this.setRequiredTypes();
                    }
                }
                catch (GDSException ge) {
                    throw new FBSQLException(ge);
                }
            }
            finally {
                if (!hasResultSet) {
                    this.notifyStatementCompleted();
                }
            }
            return hasResultSet;
        }
    }

    public ResultSet executeQuery() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            try {
                this.currentRs = null;
                this.prepareFixedStatement(this.procedureCall.getSQL(this.selectableProcedure), true);
                if (!this.internalExecute(!this.selectableProcedure)) {
                    throw new FBSQLException("No resultset for sql", "07005");
                }
                this.getResultSet();
                this.setRequiredTypes();
                return this.getCurrentResultSet();
            }
            catch (GDSException ex) {
                throw new FBSQLException(ex);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate() throws SQLException {
        Object syncObject;
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            try {
                int n;
                this.notifyStatementStarted();
                try {
                    this.currentRs = null;
                    this.prepareFixedStatement(this.procedureCall.getSQL(this.selectableProcedure), true);
                    boolean hasResults = this.internalExecute(!this.selectableProcedure);
                    if (hasResults) {
                        this.setRequiredTypes();
                    }
                    n = this.getUpdateCount();
                }
                catch (GDSException ex) {
                    throw new FBSQLException(ex);
                }
                return n;
            }
            finally {
                this.notifyStatementCompleted();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean internalExecute(boolean sendOutParams) throws SQLException {
        int counter = 0;
        List inputParams = this.procedureCall.getInputParams();
        for (FBProcedureParam param : inputParams) {
            Object obj;
            if (param == null || !param.isParam()) continue;
            Object value = param.getValue();
            FBField field = this.getField(++counter);
            if (value == null) {
                field.setNull();
            } else if (value instanceof WrapperWithCalendar) {
                obj = ((WrapperWithCalendar)value).getValue();
                if (obj == null) {
                    field.setNull();
                } else {
                    Calendar cal = ((WrapperWithCalendar)value).getCalendar();
                    if (obj instanceof Timestamp) {
                        field.setTimestamp((Timestamp)obj, cal);
                    } else if (obj instanceof Date) {
                        field.setDate((Date)obj, cal);
                    } else {
                        if (!(obj instanceof Time)) throw new TypeConvertionException("Cannot convert type " + obj.getClass().getName());
                        field.setTime((Time)obj, cal);
                    }
                }
            } else if (value instanceof WrapperWithInt) {
                obj = ((WrapperWithInt)value).getValue();
                if (obj == null) {
                    field.setNull();
                } else {
                    int intValue = ((WrapperWithInt)value).getIntValue();
                    if (obj instanceof InputStream) {
                        field.setBinaryStream((InputStream)obj, intValue);
                    } else {
                        if (!(obj instanceof Reader)) throw new TypeConvertionException("Cannot convert type " + obj.getClass().getName());
                        field.setCharacterStream((Reader)obj, intValue);
                    }
                }
            } else {
                field.setObject(value);
            }
            this.isParamSet[counter - 1] = true;
        }
        return super.internalExecute(sendOutParams);
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.procedureCall.registerOutParam(parameterIndex, sqlType);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.procedureCall.registerOutParam(parameterIndex, sqlType);
    }

    public boolean wasNull() throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().wasNull();
    }

    public String getString(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getString(parameterIndex);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getBoolean(parameterIndex);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getByte(parameterIndex);
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getShort(parameterIndex);
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getInt(parameterIndex);
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getLong(parameterIndex);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getFloat(parameterIndex);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getDouble(parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getBigDecimal(parameterIndex, scale);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getBytes(parameterIndex);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getDate(parameterIndex);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getTime(parameterIndex);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getTimestamp(parameterIndex);
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getObject(parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getBigDecimal(parameterIndex);
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getObject(parameterIndex, map);
    }

    public Ref getRef(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getRef(parameterIndex);
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getBlob(parameterIndex);
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getClob(parameterIndex);
    }

    public Array getArray(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getArray(parameterIndex);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getDate(parameterIndex, cal);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getTime(parameterIndex, cal);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getCurrentResultSet().getTimestamp(parameterIndex, cal);
    }

    protected void assertHasData(ResultSet rs) throws SQLException {
        if (rs.getRow() != 0) {
            return;
        }
        rs.next();
        if (rs.getRow() == 0) {
            throw new FBSQLException("Current statement has not data to return.", "07005");
        }
    }

    public ResultSet getCurrentResultSet() throws SQLException {
        if (this.currentRs == null) {
            this.currentRs = super.getResultSet();
        }
        return this.currentRs;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getCurrentResultSet();
    }

    public void setArray(int i, Array x) throws SQLException {
        this.procedureCall.getInputParam(i).setValue(x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithInt(inputStream, length));
    }

    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(blob);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new Boolean(x));
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new Byte(x));
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithInt(reader, length));
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithCalendar(x, cal));
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new Double(x));
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new Float(x));
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new Integer(x));
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new Long(x));
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(null);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(null);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new Short(x));
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithCalendar(x, cal));
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithCalendar(x, cal));
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    private static class WrapperWithInt {
        private Object value;
        private int intValue;

        private WrapperWithInt(Object value, int intValue) {
            this.value = value;
            this.intValue = intValue;
        }

        private Object getValue() {
            return this.value;
        }

        private int getIntValue() {
            return this.intValue;
        }
    }

    private static class WrapperWithCalendar {
        private Object value;
        private Calendar c;

        private WrapperWithCalendar(Object value, Calendar c) {
            this.value = value;
            this.c = c;
        }

        private Object getValue() {
            return this.value;
        }

        private Calendar getCalendar() {
            return this.c;
        }
    }
}

