/*
 * Decompiled with CFR 0.152.
 */
package mx4j.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.remote.ConnectionNotificationEmitter;
import mx4j.remote.HeartBeat;
import mx4j.remote.NotificationTuple;
import mx4j.remote.RemoteNotificationClientHandler;

public abstract class AbstractRemoteNotificationClientHandler
implements RemoteNotificationClientHandler {
    private static int fetcherID;
    private static int delivererID;
    private final ConnectionNotificationEmitter emitter;
    private final HeartBeat heartbeat;
    private final Map tuples = new HashMap();
    private NotificationFetcherThread fetcherThread;
    private NotificationDelivererThread delivererThread;

    protected AbstractRemoteNotificationClientHandler(ConnectionNotificationEmitter emitter, HeartBeat heartbeat, Map environment) {
        this.emitter = emitter;
        this.heartbeat = heartbeat;
        this.fetcherThread = new NotificationFetcherThread(environment);
        this.delivererThread = new NotificationDelivererThread(environment);
    }

    public boolean isActive() {
        return this.fetcherThread.isActive();
    }

    public void start() {
        if (this.isActive()) {
            return;
        }
        this.delivererThread.start();
        this.fetcherThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.isActive()) {
            return;
        }
        this.fetcherThread.stop();
        this.delivererThread.stop();
        Map map = this.tuples;
        synchronized (map) {
            this.tuples.clear();
        }
    }

    private static synchronized int getFetcherID() {
        return ++fetcherID;
    }

    private static synchronized int getDelivererID() {
        return ++delivererID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(NotificationTuple tuple) {
        Map map = this.tuples;
        synchronized (map) {
            return this.tuples.containsValue(tuple);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(Integer id, NotificationTuple tuple) {
        if (!this.isActive()) {
            this.start();
        }
        Map map = this.tuples;
        synchronized (map) {
            this.tuples.put(id, tuple);
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug("Adding remote NotificationListener " + tuple);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer[] getNotificationListeners(NotificationTuple tuple) {
        Map map = this.tuples;
        synchronized (map) {
            ArrayList ids = new ArrayList();
            for (Map.Entry entry : this.tuples.entrySet()) {
                if (!entry.getValue().equals(tuple)) continue;
                ids.add(entry.getKey());
            }
            if (ids.size() > 0) {
                return ids.toArray(new Integer[ids.size()]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getNotificationListener(NotificationTuple tuple) {
        Map map = this.tuples;
        synchronized (map) {
            for (Map.Entry entry : this.tuples.entrySet()) {
                if (!entry.getValue().equals(tuple)) continue;
                return (Integer)entry.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListeners(Integer[] ids) {
        Logger logger = this.getLogger();
        Map map = this.tuples;
        synchronized (map) {
            for (int i = 0; i < ids.length; ++i) {
                Integer id = ids[i];
                NotificationTuple tuple = (NotificationTuple)this.tuples.remove(id);
                if (tuple == null || !logger.isEnabledFor(10)) continue;
                logger.debug("Removing remote NotificationListener " + tuple);
            }
        }
    }

    protected abstract NotificationResult fetchNotifications(long var1, int var3, long var4) throws IOException;

    protected long getRetryPeriod() {
        return this.heartbeat.getPulsePeriod();
    }

    protected int getMaxRetries() {
        return this.heartbeat.getMaxRetries();
    }

    protected void sendConnectionNotificationLost(long number) {
        this.emitter.sendConnectionNotificationLost(number);
    }

    protected int getNotificationsCount() {
        return this.delivererThread.getNotificationsCount();
    }

    private int deliverNotifications(TargetedNotification[] notifications) {
        return this.delivererThread.addNotifications(notifications);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotification(TargetedNotification notification) {
        NotificationTuple tuple = null;
        Map map = this.tuples;
        synchronized (map) {
            tuple = (NotificationTuple)this.tuples.get(notification.getListenerID());
        }
        if (tuple == null) {
            return;
        }
        Notification notif = notification.getNotification();
        Logger logger = this.getLogger();
        if (tuple.getInvokeFilter()) {
            NotificationFilter filter = tuple.getNotificationFilter();
            if (logger.isEnabledFor(10)) {
                logger.debug("Filtering notification " + notif + ", filter = " + filter);
            }
            if (filter != null) {
                try {
                    boolean deliver = filter.isNotificationEnabled(notif);
                    if (!deliver) {
                        return;
                    }
                }
                catch (Throwable x) {
                    logger.warn("Throwable caught from isNotificationEnabled, filter = " + filter, x);
                }
            }
        }
        if (logger.isEnabledFor(10)) {
            logger.debug("Sending Notification " + notif + ", listener info is " + tuple);
        }
        NotificationListener listener = tuple.getNotificationListener();
        try {
            listener.handleNotification(notif, tuple.getHandback());
        }
        catch (Throwable x) {
            logger.warn("Throwable caught from handleNotification, listener = " + listener, x);
        }
    }

    protected Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    private class NotificationDelivererThread
    implements Runnable {
        private final List notificationQueue = new LinkedList();
        private int capacity;
        private volatile boolean active;
        private Thread thread;

        private NotificationDelivererThread(Map environment) {
            Object size;
            if (environment != null && (size = environment.get("jmx.remote.x.queue.size")) instanceof Integer) {
                this.capacity = (Integer)size;
                if (this.capacity < 0) {
                    this.capacity = 0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int addNotifications(TargetedNotification[] notifications) {
            if (notifications == null || notifications.length == 0) {
                return 0;
            }
            List<TargetedNotification> notifs = Arrays.asList(notifications);
            Logger logger = AbstractRemoteNotificationClientHandler.this.getLogger();
            if (logger.isEnabledFor(10)) {
                logger.debug("Enqueuing notifications for delivery: " + notifs);
            }
            NotificationDelivererThread notificationDelivererThread = this;
            synchronized (notificationDelivererThread) {
                int size;
                int added = size = notifs.size();
                if (this.capacity > 0) {
                    int room = this.capacity - this.notificationQueue.size();
                    if (room < size) {
                        added = room;
                        if (logger.isEnabledFor(10)) {
                            logger.debug("Notification queue is full, enqueued " + room + " notifications out of " + size + ", exceeding will be lost");
                        }
                    }
                    this.notificationQueue.addAll(notifs.subList(0, added));
                } else {
                    this.notificationQueue.addAll(notifs);
                }
                this.notifyAll();
                return added;
            }
        }

        private boolean isActive() {
            return this.active;
        }

        private synchronized void start() {
            this.active = true;
            this.notificationQueue.clear();
            this.thread = new Thread((Runnable)this, "Notification Deliverer #" + AbstractRemoteNotificationClientHandler.getDelivererID());
            this.thread.setDaemon(true);
            this.thread.start();
        }

        private synchronized void stop() {
            this.active = false;
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Logger logger = AbstractRemoteNotificationClientHandler.this.getLogger();
            try {
                while (this.isActive() && !this.thread.isInterrupted()) {
                    try {
                        TargetedNotification notification = null;
                        NotificationDelivererThread notificationDelivererThread = this;
                        synchronized (notificationDelivererThread) {
                            while (this.notificationQueue.isEmpty()) {
                                this.wait();
                            }
                            notification = (TargetedNotification)this.notificationQueue.remove(0);
                        }
                        AbstractRemoteNotificationClientHandler.this.sendNotification(notification);
                    }
                    catch (InterruptedException x) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    catch (Throwable x) {
                        if (!logger.isEnabledFor(30)) continue;
                        logger.warn("Caught an unexpected exception", x);
                    }
                }
            }
            finally {
                this.active = false;
                if (logger.isEnabledFor(10)) {
                    logger.debug(this.thread.getName() + " Thread exited");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getNotificationsCount() {
            NotificationDelivererThread notificationDelivererThread = this;
            synchronized (notificationDelivererThread) {
                return this.notificationQueue.size();
            }
        }
    }

    private class NotificationFetcherThread
    implements Runnable {
        private long sequenceNumber;
        private volatile boolean active;
        private Thread thread;
        private long timeout = 60000L;
        private int maxNumber = 25;
        private long sleep = 0L;

        private NotificationFetcherThread(Map environment) {
            if (environment != null) {
                try {
                    this.timeout = (Long)environment.get("jmx.remote.x.client.fetch.timeout");
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    this.maxNumber = (Integer)environment.get("jmx.remote.x.client.max.notifications");
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    this.sleep = ((Integer)environment.get("jmx.remote.x.notification.fetch.sleep")).intValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private synchronized long getSequenceNumber() {
            return this.sequenceNumber;
        }

        private synchronized void setSequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        private boolean isActive() {
            return this.active;
        }

        private synchronized void start() {
            this.active = true;
            this.sequenceNumber = -1L;
            this.thread = new Thread((Runnable)this, "Notification Fetcher #" + AbstractRemoteNotificationClientHandler.getFetcherID());
            this.thread.setDaemon(true);
            this.thread.start();
        }

        private synchronized void stop() {
            this.active = false;
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Logger logger = AbstractRemoteNotificationClientHandler.this.getLogger();
            try {
                while (this.isActive()) {
                    if (this.thread.isInterrupted()) return;
                    try {
                        long sequence = this.getSequenceNumber();
                        NotificationResult result = this.fetchNotifications(sequence, this.maxNumber, this.timeout);
                        if (logger.isEnabledFor(10)) {
                            logger.debug("Fetched Notifications: " + result);
                        }
                        long sleepTime = this.sleep;
                        if (result != null) {
                            boolean notifsLostByServer;
                            int targetedLength;
                            long nextSequence = result.getNextSequenceNumber();
                            TargetedNotification[] targeted = result.getTargetedNotifications();
                            int n = targetedLength = targeted == null ? 0 : targeted.length;
                            boolean notifsFilteredByServer = sequence >= 0L ? nextSequence - sequence != (long)targetedLength : false;
                            boolean bl = notifsLostByServer = sequence >= 0L && result.getEarliestSequenceNumber() > sequence;
                            if (notifsFilteredByServer) {
                                AbstractRemoteNotificationClientHandler.this.sendConnectionNotificationLost(nextSequence - sequence - (long)targetedLength);
                            }
                            if (notifsLostByServer) {
                                AbstractRemoteNotificationClientHandler.this.sendConnectionNotificationLost(result.getEarliestSequenceNumber() - sequence);
                            }
                            this.setSequenceNumber(nextSequence);
                            int delivered = AbstractRemoteNotificationClientHandler.this.deliverNotifications(targeted);
                            if (delivered < targetedLength) {
                                AbstractRemoteNotificationClientHandler.this.sendConnectionNotificationLost(targetedLength - delivered);
                            }
                            if (targeted != null && targeted.length == this.maxNumber) {
                                sleepTime = 0L;
                            }
                        }
                        if (sleepTime <= 0L) continue;
                        Thread.sleep(sleepTime);
                    }
                    catch (IOException x) {
                        if (!logger.isEnabledFor(10)) return;
                        logger.debug("Caught IOException from fetchNotifications", x);
                        return;
                    }
                    catch (InterruptedException x) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (Throwable x) {
                        if (!logger.isEnabledFor(30)) continue;
                        logger.warn("Caught an unexpected exception", x);
                    }
                }
                return;
            }
            finally {
                AbstractRemoteNotificationClientHandler.this.stop();
                if (logger.isEnabledFor(10)) {
                    logger.debug(this.thread.getName() + " Thread exited");
                }
            }
        }

        private NotificationResult fetchNotifications(long sequence, int maxNumber, long timeout) throws IOException, InterruptedException {
            Logger logger = AbstractRemoteNotificationClientHandler.this.getLogger();
            int retries = 0;
            while (true) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Fetching notifications, sequence is " + sequence + ", timeout is " + timeout);
                }
                try {
                    return AbstractRemoteNotificationClientHandler.this.fetchNotifications(sequence, maxNumber, timeout);
                }
                catch (IOException x) {
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Could not fetch notifications, sleeping " + AbstractRemoteNotificationClientHandler.this.getRetryPeriod() + " and trying " + (AbstractRemoteNotificationClientHandler.this.getMaxRetries() - retries) + " more times", x);
                    }
                    Thread.sleep(AbstractRemoteNotificationClientHandler.this.getRetryPeriod());
                    if (retries++ != AbstractRemoteNotificationClientHandler.this.getMaxRetries()) continue;
                    throw x;
                }
                break;
            }
        }
    }
}

