/*
 * Decompiled with CFR 0.152.
 */
package mx4j.remote.rmi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.MarshalledObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import mx4j.remote.rmi.Marshaller;

class RMIMarshaller {
    private static final Method unmarshal = RMIMarshaller.getUnmarshalMethod();

    RMIMarshaller() {
    }

    private static Method getUnmarshalMethod() {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String marshallerName = Marshaller.class.getName();
                InputStream stream = Marshaller.class.getResourceAsStream(marshallerName.substring(marshallerName.lastIndexOf(46) + 1) + ".class");
                if (stream == null) {
                    throw new Error("Could not load implementation class " + marshallerName);
                }
                BufferedInputStream bis = new BufferedInputStream(stream);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BufferedOutputStream bos = new BufferedOutputStream(baos);
                try {
                    byte[] buffer = new byte[256];
                    int read = -1;
                    while ((read = bis.read(buffer)) >= 0) {
                        bos.write(buffer, 0, read);
                    }
                    bis.close();
                    bos.close();
                }
                catch (IOException x) {
                    throw new Error(x.toString());
                }
                byte[] classBytes = baos.toByteArray();
                MarshallerClassLoader loader = new MarshallerClassLoader(classBytes);
                try {
                    Class cls = loader.loadClass(marshallerName);
                    return cls.getMethod("unmarshal", MarshalledObject.class);
                }
                catch (ClassNotFoundException x) {
                    throw new Error(x.toString());
                }
                catch (NoSuchMethodException x) {
                    throw new Error(x.toString());
                }
            }
        });
    }

    public static MarshalledObject marshal(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        return new MarshalledObject<Object>(object);
    }

    public static Object unmarshal(MarshalledObject object, final ClassLoader mbeanLoader, final ClassLoader defaultLoader) throws IOException {
        if (object == null) {
            return null;
        }
        if (mbeanLoader == null) {
            return RMIMarshaller.unmarshal(object, defaultLoader);
        }
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ExtendedClassLoader(mbeanLoader, defaultLoader);
            }
        });
        return RMIMarshaller.unmarshal(object, loader);
    }

    private static Object unmarshal(MarshalledObject object, ClassLoader loader) throws IOException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            RMIMarshaller.setContextClassLoader(loader);
            Object object2 = RMIMarshaller.unmarshal(object);
            return object2;
        }
        catch (IOException x) {
            throw x;
        }
        catch (ClassNotFoundException ignored) {
            throw new IOException(ignored.toString());
        }
        finally {
            RMIMarshaller.setContextClassLoader(old);
        }
    }

    private static Object unmarshal(MarshalledObject marshalled) throws IOException, ClassNotFoundException {
        try {
            return unmarshal.invoke(null, marshalled);
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)t;
            }
            throw new IOException(t.toString());
        }
        catch (Exception x) {
            throw new IOException(x.toString());
        }
    }

    private static void setContextClassLoader(final ClassLoader loader) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(loader);
                return null;
            }
        });
    }

    private static class ExtendedClassLoader
    extends SecureClassLoader {
        private final ClassLoader defaultLoader;

        private ExtendedClassLoader(ClassLoader mbeanLoader, ClassLoader defaultLoader) {
            super(mbeanLoader);
            this.defaultLoader = defaultLoader;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            return this.defaultLoader.loadClass(name);
        }

        protected URL findResource(String name) {
            return this.defaultLoader.getResource(name);
        }
    }

    private static class MarshallerClassLoader
    extends SecureClassLoader {
        private byte[] bytes;

        private MarshallerClassLoader(byte[] classBytes) {
            super(null);
            this.bytes = classBytes;
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            if (name.startsWith(Marshaller.class.getName())) {
                try {
                    return this.defineClass(name, this.bytes, 0, this.bytes.length, this.getClass().getProtectionDomain());
                }
                catch (ClassFormatError x) {
                    throw new ClassNotFoundException("Class Format Error", x);
                }
            }
            return super.loadClass(name);
        }
    }
}

