/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.taskdefs.Antlib;
import org.apache.tools.ant.taskdefs.DefBase;
import org.apache.tools.ant.types.EnumeratedAttribute;

public abstract class Definer
extends DefBase {
    private static ResourceStack resourceStack = new ResourceStack();
    private String name;
    private String classname;
    private File file;
    private String resource;
    private int format = 0;
    private boolean definerSet = false;
    private int onError = 0;
    private String adapter;
    private String adaptTo;
    private Class adapterClass;
    private Class adaptToClass;

    public void setOnError(OnError onError) {
        this.onError = onError.getIndex();
    }

    public void setFormat(Format format) {
        this.format = format.getIndex();
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public String getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        ClassLoader al = this.createLoader();
        if (!this.definerSet) {
            throw new BuildException("name, file or resource attribute of " + this.getTaskName() + " is undefined", this.getLocation());
        }
        if (this.name != null) {
            if (this.classname == null) {
                throw new BuildException("classname attribute of " + this.getTaskName() + " element " + "is undefined", this.getLocation());
            }
            this.addDefinition(al, this.name, this.classname);
        } else {
            URL url;
            if (this.classname != null) {
                String msg = "You must not specify classname together with file or resource.";
                throw new BuildException(msg, this.getLocation());
            }
            Enumeration urls = null;
            if (this.file != null) {
                url = this.fileToURL();
                if (url == null) {
                    return;
                }
                urls = new Enumeration(){
                    private boolean more = true;

                    public boolean hasMoreElements() {
                        return this.more;
                    }

                    public Object nextElement() throws NoSuchElementException {
                        if (this.more) {
                            this.more = false;
                            return url;
                        }
                        throw new NoSuchElementException();
                    }
                };
            } else {
                urls = this.resourceToURLs(al);
            }
            while (urls.hasMoreElements()) {
                url = (URL)urls.nextElement();
                int format = this.format;
                if (url.toString().toLowerCase(Locale.US).endsWith(".xml")) {
                    format = 1;
                }
                if (format == 0) {
                    this.loadProperties(al, url);
                    break;
                }
                if (resourceStack.getStack().get(url) != null) {
                    this.log("Warning: Recursive loading of " + url + " ignored" + " at " + this.getLocation() + " originally loaded at " + resourceStack.getStack().get(url), 1);
                    continue;
                }
                try {
                    resourceStack.getStack().put(url, this.getLocation());
                    this.loadAntlib(al, url);
                }
                finally {
                    resourceStack.getStack().remove(url);
                }
            }
        }
    }

    private URL fileToURL() {
        if (!this.file.exists()) {
            this.log("File " + this.file + " does not exist", 1);
            return null;
        }
        if (!this.file.isFile()) {
            this.log("File " + this.file + " is not a file", 1);
            return null;
        }
        try {
            return this.file.toURL();
        }
        catch (Exception ex) {
            this.log("File " + this.file + " cannot use as URL: " + ex.toString(), 1);
            return null;
        }
    }

    private Enumeration resourceToURLs(ClassLoader classLoader) {
        Enumeration<URL> ret;
        try {
            ret = classLoader.getResources(this.resource);
        }
        catch (IOException e) {
            throw new BuildException("Could not fetch resources named " + this.resource, e, this.getLocation());
        }
        if (!ret.hasMoreElements() && this.onError != 2) {
            this.log("Could not load definitions from resource " + this.resource + ". It could not be found.", 1);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadProperties(ClassLoader al, URL url) {
        block12: {
            block11: {
                is = null;
                try {
                    try {
                        is = url.openStream();
                        if (is == null) {
                            this.log("Could not load definitions from " + url, 1);
                            var7_4 = null;
                            if (is == null) return;
                            break block11;
                        }
                        props = new Properties();
                        props.load(is);
                        keys = props.keys();
                        while (keys.hasMoreElements()) {
                            this.name = (String)keys.nextElement();
                            this.classname = props.getProperty(this.name);
                            this.addDefinition(al, this.name, this.classname);
                        }
                        break block12;
                    }
                    catch (IOException ex) {
                        throw new BuildException(ex, this.getLocation());
                    }
                }
                catch (Throwable var6_13) {
                    var7_6 = null;
                    if (is == null) throw var6_13;
                    try {
                        is.close();
                        throw var6_13;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var6_13;
                }
            }
            ** try [egrp 2[TRYBLOCK] [5 : 150->157)] { 
lbl34:
            // 1 sources

            is.close();
            return;
lbl36:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        var7_5 = null;
        if (is == null) return;
        try {}
        catch (IOException e) {}
        is.close();
        return;
    }

    private void loadAntlib(ClassLoader classLoader, URL url) {
        try {
            Antlib antlib = Antlib.createAntlib(this.getProject(), url, this.getURI());
            antlib.setClassLoader(classLoader);
            antlib.setURI(this.getURI());
            antlib.perform();
        }
        catch (BuildException ex) {
            throw ProjectHelper.addLocationToBuildException(ex, this.getLocation());
        }
    }

    public void setFile(File file) {
        if (this.definerSet) {
            this.tooManyDefinitions();
        }
        this.definerSet = true;
        this.file = file;
    }

    public void setResource(String res) {
        if (this.definerSet) {
            this.tooManyDefinitions();
        }
        this.definerSet = true;
        this.resource = res;
    }

    public void setName(String name) {
        if (this.definerSet) {
            this.tooManyDefinitions();
        }
        this.definerSet = true;
        this.name = name;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void setAdapter(String adapter) {
        this.adapter = adapter;
    }

    protected void setAdapterClass(Class adapterClass) {
        this.adapterClass = adapterClass;
    }

    public void setAdaptTo(String adaptTo) {
        this.adaptTo = adaptTo;
    }

    protected void setAdaptToClass(Class adaptToClass) {
        this.adaptToClass = adaptToClass;
    }

    protected void addDefinition(ClassLoader al, String name, String classname) throws BuildException {
        Class<?> cl = null;
        try {
            try {
                name = ProjectHelper.genComponentName(this.getURI(), name);
                if (this.onError != 2) {
                    cl = Class.forName(classname, true, al);
                }
                if (this.adapter != null) {
                    this.adapterClass = Class.forName(this.adapter, true, al);
                }
                if (this.adaptTo != null) {
                    this.adaptToClass = Class.forName(this.adaptTo, true, al);
                }
                AntTypeDefinition def = new AntTypeDefinition();
                def.setName(name);
                def.setClassName(classname);
                def.setClass(cl);
                def.setAdapterClass(this.adapterClass);
                def.setAdaptToClass(this.adaptToClass);
                def.setClassLoader(al);
                if (cl != null) {
                    def.checkClass(this.getProject());
                }
                ComponentHelper.getComponentHelper(this.getProject()).addDataTypeDefinition(def);
            }
            catch (ClassNotFoundException cnfe) {
                String msg = this.getTaskName() + " class " + classname + " cannot be found";
                throw new BuildException(msg, cnfe, this.getLocation());
            }
            catch (NoClassDefFoundError ncdfe) {
                String msg = this.getTaskName() + " A class needed by class " + classname + " cannot be found: " + ncdfe.getMessage();
                throw new BuildException(msg, ncdfe, this.getLocation());
            }
        }
        catch (BuildException ex) {
            switch (this.onError) {
                case 0: {
                    throw ex;
                }
                case 1: {
                    this.log(ex.getLocation() + "Warning: " + ex.getMessage(), 1);
                    break;
                }
                default: {
                    this.log(ex.getLocation() + ex.getMessage(), 4);
                }
            }
        }
    }

    private void tooManyDefinitions() {
        throw new BuildException("Only one of the attributes name,file,resource can be set", this.getLocation());
    }

    public static class Format
    extends EnumeratedAttribute {
        public static final int PROPERTIES = 0;
        public static final int XML = 1;

        public String[] getValues() {
            return new String[]{"properties", "xml"};
        }
    }

    public static class OnError
    extends EnumeratedAttribute {
        public static final int FAIL = 0;
        public static final int REPORT = 1;
        public static final int IGNORE = 2;

        public OnError() {
        }

        public OnError(String value) {
            this.setValue(value);
        }

        public String[] getValues() {
            return new String[]{"fail", "report", "ignore"};
        }
    }

    private static class ResourceStack
    extends ThreadLocal {
        private ResourceStack() {
        }

        public Object initialValue() {
            return new HashMap();
        }

        Map getStack() {
            return (Map)this.get();
        }
    }
}

