/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.fmt.BundleSupport;

public abstract class SetLocaleSupport
extends TagSupport {
    private static final char HYPHEN = '-';
    private static final char UNDERSCORE = '_';
    protected Object value;
    protected String variant;
    private int scope;
    static Locale[] availableFormattingLocales;

    public SetLocaleSupport() {
        this.init();
    }

    private void init() {
        this.variant = null;
        this.value = null;
        this.scope = 1;
    }

    public void setScope(String string) {
        this.scope = Util.getScope(string);
    }

    public int doEndTag() throws JspException {
        Locale locale = null;
        locale = this.value == null ? Locale.getDefault() : (this.value instanceof String ? (((String)this.value).trim().equals("") ? Locale.getDefault() : SetLocaleSupport.parseLocale((String)this.value, this.variant)) : (Locale)this.value);
        Config.set((PageContext)this.pageContext, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)locale, (int)this.scope);
        SetLocaleSupport.setResponseLocale(this.pageContext, locale);
        return 6;
    }

    public void release() {
        this.init();
    }

    public static Locale parseLocale(String string) {
        return SetLocaleSupport.parseLocale(string, null);
    }

    public static Locale parseLocale(String string, String string2) {
        Locale locale = null;
        String string3 = string;
        String string4 = null;
        int n = -1;
        n = string.indexOf(45);
        if (n > -1 || (n = string.indexOf(95)) > -1) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException(Resources.getMessage("LOCALE_NO_LANGUAGE"));
        }
        if (string4 == null) {
            locale = string2 != null ? new Locale(string3, "", string2) : new Locale(string3, "");
        } else if (string4.length() > 0) {
            locale = string2 != null ? new Locale(string3, string4, string2) : new Locale(string3, string4);
        } else {
            throw new IllegalArgumentException(Resources.getMessage("LOCALE_EMPTY_COUNTRY"));
        }
        return locale;
    }

    static void setResponseLocale(PageContext pageContext, Locale locale) {
        ServletResponse servletResponse = pageContext.getResponse();
        servletResponse.setLocale(locale);
        if (pageContext.getSession() != null) {
            try {
                pageContext.setAttribute("javax.servlet.jsp.jstl.fmt.request.charset", (Object)servletResponse.getCharacterEncoding(), 3);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    static Locale getFormattingLocale(PageContext pageContext, Tag tag, boolean bl, Locale[] localeArray) {
        LocalizationContext localizationContext = null;
        Tag tag2 = SetLocaleSupport.findAncestorWithClass((Tag)tag, (Class)BundleSupport.class);
        if (tag2 != null && (localizationContext = ((BundleSupport)tag2).getLocalizationContext()).getLocale() != null) {
            if (bl) {
                SetLocaleSupport.setResponseLocale(pageContext, localizationContext.getLocale());
            }
            return localizationContext.getLocale();
        }
        localizationContext = BundleSupport.getLocalizationContext(pageContext);
        if (localizationContext != null && localizationContext.getLocale() != null) {
            if (bl) {
                SetLocaleSupport.setResponseLocale(pageContext, localizationContext.getLocale());
            }
            return localizationContext.getLocale();
        }
        Locale locale = null;
        Locale locale2 = SetLocaleSupport.getLocale(pageContext, "javax.servlet.jsp.jstl.fmt.locale");
        locale = locale2 != null ? SetLocaleSupport.findFormattingMatch(locale2, localeArray) : SetLocaleSupport.findFormattingMatch(pageContext, localeArray);
        if (locale == null && (locale2 = SetLocaleSupport.getLocale(pageContext, "javax.servlet.jsp.jstl.fmt.fallbackLocale")) != null) {
            locale = SetLocaleSupport.findFormattingMatch(locale2, localeArray);
        }
        if (bl && locale != null) {
            SetLocaleSupport.setResponseLocale(pageContext, locale);
        }
        return locale;
    }

    static Locale getFormattingLocale(PageContext pageContext) {
        Locale locale = null;
        Locale locale2 = SetLocaleSupport.getLocale(pageContext, "javax.servlet.jsp.jstl.fmt.locale");
        locale = locale2 != null ? SetLocaleSupport.findFormattingMatch(locale2, availableFormattingLocales) : SetLocaleSupport.findFormattingMatch(pageContext, availableFormattingLocales);
        if (locale == null && (locale2 = SetLocaleSupport.getLocale(pageContext, "javax.servlet.jsp.jstl.fmt.fallbackLocale")) != null) {
            locale = SetLocaleSupport.findFormattingMatch(locale2, availableFormattingLocales);
        }
        if (locale != null) {
            SetLocaleSupport.setResponseLocale(pageContext, locale);
        }
        return locale;
    }

    static Locale getLocale(PageContext pageContext, String string) {
        Locale locale = null;
        Object object = Config.find((PageContext)pageContext, (String)string);
        if (object != null) {
            locale = object instanceof Locale ? (Locale)object : SetLocaleSupport.parseLocale((String)object);
        }
        return locale;
    }

    private static Locale findFormattingMatch(PageContext pageContext, Locale[] localeArray) {
        Locale locale;
        Locale locale2 = null;
        Enumeration enumeration = Util.getRequestLocales((HttpServletRequest)pageContext.getRequest());
        while (enumeration.hasMoreElements() && (locale2 = SetLocaleSupport.findFormattingMatch(locale = (Locale)enumeration.nextElement(), localeArray)) == null) {
        }
        return locale2;
    }

    private static Locale findFormattingMatch(Locale locale, Locale[] localeArray) {
        Locale locale2 = null;
        boolean bl = false;
        for (int i = 0; i < localeArray.length; ++i) {
            if (locale.equals(localeArray[i])) {
                locale2 = localeArray[i];
                break;
            }
            if (!"".equals(locale.getVariant()) && "".equals(localeArray[i].getVariant()) && locale.getLanguage().equals(localeArray[i].getLanguage()) && locale.getCountry().equals(localeArray[i].getCountry())) {
                locale2 = localeArray[i];
                bl = true;
                continue;
            }
            if (bl || !locale.getLanguage().equals(localeArray[i].getLanguage()) || !"".equals(localeArray[i].getCountry()) || locale2 != null) continue;
            locale2 = localeArray[i];
        }
        return locale2;
    }

    static {
        Locale[] localeArray = DateFormat.getAvailableLocales();
        Locale[] localeArray2 = NumberFormat.getAvailableLocales();
        Vector<Locale> vector = new Vector<Locale>(localeArray.length);
        block0: for (int i = 0; i < localeArray.length; ++i) {
            for (int j = 0; j < localeArray2.length; ++j) {
                if (!localeArray[i].equals(localeArray2[j])) continue;
                vector.add(localeArray[i]);
                continue block0;
            }
        }
        availableFormattingLocales = new Locale[vector.size()];
        availableFormattingLocales = vector.toArray(availableFormattingLocales);
    }
}

