/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.QueryExp;
import mx4j.util.Utils;

public class ObjectName
implements QueryExp,
Serializable {
    private static final long serialVersionUID = 1081892073854801359L;
    private static final boolean cacheEnabled;
    private static final WeakObjectNameCache cache;
    private transient String propertiesString;
    private transient boolean isPropertyPattern;
    private transient boolean isDomainPattern;
    private transient String canonicalName;

    public ObjectName(String name) throws MalformedObjectNameException {
        if (name == null) {
            throw new NullPointerException("ObjectName 'name' parameter can't be null");
        }
        if (name.length() == 0) {
            name = "*:*";
        }
        this.parse(name);
    }

    public ObjectName(String domain, Hashtable table) throws MalformedObjectNameException {
        if (domain == null) {
            throw new NullPointerException("ObjectName 'domain' parameter can't be null");
        }
        if (table == null) {
            throw new NullPointerException("ObjectName 'table' parameter can't be null");
        }
        if (!this.isDomainValid(domain)) {
            throw new MalformedObjectNameException("Invalid domain: " + domain);
        }
        if (table.isEmpty()) {
            throw new MalformedObjectNameException("Properties table cannot be empty");
        }
        for (Map.Entry entry : table.entrySet()) {
            String key = entry.getKey().toString();
            if (!this.isKeyValid(key)) {
                throw new MalformedObjectNameException("Invalid key: " + key);
            }
            Object value = entry.getValue();
            if (!(value instanceof String)) {
                throw new MalformedObjectNameException("Property values must be Strings");
            }
            String strvalue = value.toString();
            if (this.isValueValid(strvalue)) continue;
            throw new MalformedObjectNameException("Invalid value: " + strvalue);
        }
        this.init(domain, this.convertPropertiesToString(new TreeMap(table)), table);
    }

    public ObjectName(String domain, String key, String value) throws MalformedObjectNameException {
        if (domain == null) {
            throw new NullPointerException("ObjectName 'domain' parameter can't be null");
        }
        if (key == null) {
            throw new NullPointerException("ObjectName 'key' parameter can't be null");
        }
        if (value == null) {
            throw new NullPointerException("ObjectName 'value' parameter can't be null");
        }
        if (!this.isDomainValid(domain)) {
            throw new MalformedObjectNameException("Invalid domain: " + domain);
        }
        if (!this.isKeyValid(key)) {
            throw new MalformedObjectNameException("Invalid key: " + key);
        }
        if (!this.isValueValid(value)) {
            throw new MalformedObjectNameException("Invalid value: " + value);
        }
        HashMap<String, String> table = new HashMap<String, String>();
        table.put(key, value);
        this.init(domain, this.convertPropertiesToString(table), table);
    }

    public boolean apply(ObjectName name) {
        boolean result = false;
        result = name.isPattern() ? false : (this.isPattern() ? this.domainsMatch(this, name) && this.propertiesMatch(this, name) : this.equals(name));
        return result;
    }

    boolean implies(ObjectName name) {
        return this.domainsMatch(this, name) && this.propertiesMatch(this, name);
    }

    private boolean domainsMatch(ObjectName name1, ObjectName name2) {
        String thisDomain = name1.getDomain();
        boolean thisPattern = name1.isDomainPattern();
        String otherDomain = name2.getDomain();
        boolean otherPattern = name2.isDomainPattern();
        if (!thisPattern && otherPattern) {
            return false;
        }
        if (!(thisPattern || otherPattern || thisDomain.equals(otherDomain))) {
            return false;
        }
        return Utils.wildcardMatch(thisDomain, otherDomain);
    }

    private boolean propertiesMatch(ObjectName name1, ObjectName name2) {
        Map thisProperties = name1.getPropertiesMap();
        boolean thisPattern = name1.isPropertyPattern();
        Map otherProperties = name2.getPropertiesMap();
        boolean otherPattern = name2.isPropertyPattern();
        if (!thisPattern && otherPattern) {
            return false;
        }
        if (!(thisPattern || otherPattern || ((Object)thisProperties).equals(otherProperties))) {
            return false;
        }
        return !thisPattern || otherProperties.entrySet().containsAll(thisProperties.entrySet());
    }

    public void setMBeanServer(MBeanServer server) {
    }

    public String getCanonicalKeyPropertyListString() {
        String canonical = this.getCanonicalName();
        int index = canonical.indexOf(58);
        String list = canonical.substring(index + 1);
        if (this.isPropertyPattern()) {
            if (this.getKeyPropertyListString().length() == 0) {
                return list.substring(0, list.length() - "*".length());
            }
            return list.substring(0, list.length() - ",*".length());
        }
        return list;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public String getDomain() {
        String canonical = this.getCanonicalName();
        int index = canonical.indexOf(58);
        return canonical.substring(0, index);
    }

    public String getKeyProperty(String key) {
        Map props = this.getPropertiesMap();
        return (String)props.get(key);
    }

    public Hashtable getKeyPropertyList() {
        return new Hashtable(this.getPropertiesMap());
    }

    private Map getPropertiesMap() {
        try {
            return this.convertStringToProperties(this.getKeyPropertyListString(), null);
        }
        catch (MalformedObjectNameException x) {
            return null;
        }
    }

    public String getKeyPropertyListString() {
        return this.propertiesString;
    }

    public boolean isPattern() {
        return this.isDomainPattern() || this.isPropertyPattern();
    }

    public boolean isPropertyPattern() {
        return this.isPropertyPattern;
    }

    public boolean isDomainPattern() {
        return this.isDomainPattern;
    }

    public static ObjectName getInstance(ObjectName name) {
        if (name.getClass() == ObjectName.class) {
            return name;
        }
        try {
            return ObjectName.getInstance(name.getCanonicalName());
        }
        catch (MalformedObjectNameException x) {
            throw new IllegalArgumentException(x.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectName getInstance(String name) throws MalformedObjectNameException {
        if (cacheEnabled) {
            ObjectName cached = null;
            WeakObjectNameCache weakObjectNameCache = cache;
            synchronized (weakObjectNameCache) {
                cached = cache.get(name);
            }
            if (cached != null) {
                return cached;
            }
        }
        return new ObjectName(name);
    }

    public static ObjectName getInstance(String domain, Hashtable table) throws MalformedObjectNameException {
        return new ObjectName(domain, table);
    }

    public static ObjectName getInstance(String domain, String key, String value) throws MalformedObjectNameException {
        return new ObjectName(domain, key, value);
    }

    public static String quote(String value) {
        StringBuffer buffer = new StringBuffer("\"");
        block7: for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\n': {
                    buffer.append("\\n");
                    continue block7;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block7;
                }
                case '*': {
                    buffer.append("\\*");
                    continue block7;
                }
                case '?': {
                    buffer.append("\\?");
                    continue block7;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        buffer.append("\"");
        return buffer.toString();
    }

    public static String unquote(String value) throws IllegalArgumentException {
        int lastIndex = value.length() - 1;
        if (lastIndex < 1 || value.charAt(0) != '\"' || value.charAt(lastIndex) != '\"') {
            throw new IllegalArgumentException("The given string is not quoted");
        }
        StringBuffer buffer = new StringBuffer();
        block10: for (int i = 1; i < lastIndex; ++i) {
            char ch = value.charAt(i);
            if (ch == '\\') {
                if (++i == lastIndex) {
                    throw new IllegalArgumentException("Invalid escape sequence at the end of quoted string");
                }
                ch = value.charAt(i);
                switch (ch) {
                    case 'n': {
                        buffer.append("\n");
                        continue block10;
                    }
                    case '\"': {
                        buffer.append("\"");
                        continue block10;
                    }
                    case '\\': {
                        buffer.append("\\");
                        continue block10;
                    }
                    case '*': {
                        buffer.append("*");
                        continue block10;
                    }
                    case '?': {
                        buffer.append("?");
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid escape sequence: \\" + ch);
                    }
                }
            }
            switch (ch) {
                case '\n': 
                case '\"': 
                case '*': 
                case '?': {
                    throw new IllegalArgumentException("Invalid unescaped character: " + ch);
                }
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(String name) throws MalformedObjectNameException {
        String domain;
        boolean isSubclass;
        boolean bl = isSubclass = this.getClass() != ObjectName.class;
        if (cacheEnabled && !isSubclass) {
            ObjectName cached = null;
            WeakObjectNameCache weakObjectNameCache = cache;
            synchronized (weakObjectNameCache) {
                cached = cache.get(name);
            }
            if (cached != null) {
                this.propertiesString = cached.getKeyPropertyListString();
                this.isDomainPattern = cached.isDomainPattern();
                this.isPropertyPattern = cached.isPropertyPattern();
                this.canonicalName = cached.getCanonicalName();
                return;
            }
        }
        if (!this.isDomainValid(domain = this.parseDomain(name))) {
            throw new MalformedObjectNameException("Invalid domain: " + domain);
        }
        String properties = this.parseProperties(name);
        if (properties.trim().length() < 1) {
            throw new MalformedObjectNameException("Missing properties");
        }
        if (properties.trim().endsWith(",")) {
            throw new MalformedObjectNameException("Missing property after trailing comma");
        }
        StringBuffer propsString = new StringBuffer();
        Map table = this.convertStringToProperties(properties, propsString);
        this.init(domain, propsString.toString(), table);
        if (cacheEnabled && !isSubclass) {
            WeakObjectNameCache weakObjectNameCache = cache;
            synchronized (weakObjectNameCache) {
                cache.put(name, this);
            }
        }
    }

    private String parseDomain(String objectName) throws MalformedObjectNameException {
        int colon = objectName.indexOf(58);
        if (colon < 0) {
            throw new MalformedObjectNameException("Missing ':' character in ObjectName");
        }
        String domain = objectName.substring(0, colon);
        return domain;
    }

    private boolean isDomainValid(String domain) {
        if (domain == null) {
            return false;
        }
        if (domain.indexOf(10) >= 0) {
            return false;
        }
        return domain.indexOf(":") < 0;
    }

    private String parseProperties(String objectName) throws MalformedObjectNameException {
        int colon = objectName.indexOf(58);
        if (colon < 0) {
            throw new MalformedObjectNameException("Missing ':' character in ObjectName");
        }
        String list = objectName.substring(colon + 1);
        return list;
    }

    private Map convertStringToProperties(String properties, StringBuffer buffer) throws MalformedObjectNameException {
        if (buffer != null) {
            buffer.setLength(0);
        }
        HashMap<String, String> table = new HashMap<String, String>();
        StringBuffer toBeParsed = new StringBuffer(properties);
        while (toBeParsed.length() > 0) {
            String key = this.parsePropertyKey(toBeParsed);
            String value = null;
            value = "*".equals(key) ? "*" : this.parsePropertyValue(toBeParsed);
            String duplicate = table.put(key, value);
            if (duplicate != null) {
                throw new MalformedObjectNameException("Duplicate key not allowed: " + key);
            }
            if (buffer == null || "*".equals(key)) continue;
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(key).append('=').append(value);
        }
        return table;
    }

    private String parsePropertyKey(StringBuffer buffer) throws MalformedObjectNameException {
        String toBeParsed = buffer.toString();
        int equal = toBeParsed.indexOf(61);
        int comma = toBeParsed.indexOf(44);
        if (equal < 0 && comma < 0) {
            String key = toBeParsed.trim();
            if (!"*".equals(key)) {
                throw new MalformedObjectNameException("Invalid key: '" + key + "'");
            }
            buffer.setLength(0);
            return key;
        }
        if (comma >= 0 && comma < equal) {
            String key = toBeParsed.substring(0, comma).trim();
            if (!"*".equals(key)) {
                throw new MalformedObjectNameException("Invalid key: '" + key + "'");
            }
            buffer.delete(0, comma + 1);
            return key;
        }
        String key = toBeParsed.substring(0, equal);
        if (!this.isKeyValid(key)) {
            throw new MalformedObjectNameException("Invalid key: '" + key + "'");
        }
        buffer.delete(0, equal + 1);
        return key;
    }

    private boolean isKeyValid(String key) {
        if (key == null) {
            return false;
        }
        if (key.trim().length() < 1) {
            return false;
        }
        if (key.indexOf(10) >= 0) {
            return false;
        }
        if (key.indexOf(44) >= 0) {
            return false;
        }
        if (key.indexOf(61) >= 0) {
            return false;
        }
        if (key.indexOf(42) >= 0) {
            return false;
        }
        if (key.indexOf(63) >= 0) {
            return false;
        }
        return key.indexOf(58) < 0;
    }

    private String parsePropertyValue(StringBuffer buffer) throws MalformedObjectNameException {
        String toBeParsed = buffer.toString();
        if (toBeParsed.trim().startsWith("\"")) {
            int start = toBeParsed.indexOf(34) + 1;
            int endQuote = -1;
            while ((endQuote = toBeParsed.indexOf(34, start)) >= 0) {
                int bslashes = this.countBackslashesBackwards(toBeParsed, endQuote);
                if (bslashes % 2 != 0) {
                    start = endQuote + 1;
                    continue;
                }
                String value = toBeParsed.substring(0, endQuote + 1).trim();
                if (!this.isValueValid(value)) {
                    throw new MalformedObjectNameException("Invalid value: '" + value + "'");
                }
                buffer.delete(0, endQuote + 1);
                toBeParsed = buffer.toString();
                if (toBeParsed.trim().startsWith(",")) {
                    int comma = toBeParsed.indexOf(44);
                    buffer.delete(0, comma + 1);
                    return value;
                }
                if (toBeParsed.trim().length() == 0) {
                    buffer.setLength(0);
                    return value;
                }
                throw new MalformedObjectNameException("Garbage after quoted value: " + toBeParsed);
            }
            throw new MalformedObjectNameException("Missing closing quote: " + toBeParsed);
        }
        int comma = toBeParsed.indexOf(44);
        if (comma >= 0) {
            String value = toBeParsed.substring(0, comma);
            if (!this.isValueValid(value)) {
                throw new MalformedObjectNameException("Invalid value: '" + value + "'");
            }
            buffer.delete(0, comma + 1);
            return value;
        }
        String value = toBeParsed;
        if (!this.isValueValid(value)) {
            throw new MalformedObjectNameException("Invalid value: '" + value + "'");
        }
        buffer.setLength(0);
        return value;
    }

    private int indexOfLastConsecutiveBackslash(String value, int from) {
        int index = value.indexOf(92, from);
        if (index < 0) {
            return index;
        }
        if (index == value.length() - 1) {
            return index;
        }
        int next = this.indexOfLastConsecutiveBackslash(value, from + 1);
        if (next < 0) {
            return index;
        }
        return next;
    }

    private boolean isValueValid(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() == 0) {
            return false;
        }
        if (value.indexOf(10) >= 0) {
            return false;
        }
        if (value.trim().startsWith("\"")) {
            if ((value = value.trim()).length() < 2) {
                return false;
            }
            if (value.charAt(value.length() - 1) != '\"') {
                return false;
            }
            if (this.countBackslashesBackwards(value, value.length() - 1) % 2 == 1) {
                return false;
            }
            value = value.substring(1, value.length() - 1);
            int start = 0;
            int index = -1;
            do {
                if ((index = this.indexOfLastConsecutiveBackslash(value, start)) < 0) continue;
                int count = this.countBackslashesBackwards(value, index + 1);
                if (count % 2 != 0) {
                    if (index == value.length() - 1) {
                        return false;
                    }
                    char next = value.charAt(index + 1);
                    if (next != '\\' && next != 'n' && next != '\"' && next != '?' && next != '*') {
                        return false;
                    }
                }
                start = index + 1;
            } while (index >= 0);
            start = 0;
            index = -1;
            do {
                if ((index = value.indexOf(34, start)) < 0) {
                    index = value.indexOf(42, start);
                }
                if (index < 0) {
                    index = value.indexOf(63, start);
                }
                if (index < 0) continue;
                int bslashCount = this.countBackslashesBackwards(value, index);
                if (bslashCount % 2 == 0) {
                    return false;
                }
                start = index + 1;
            } while (index >= 0);
        } else {
            if (value.indexOf(44) >= 0) {
                return false;
            }
            if (value.indexOf(61) >= 0) {
                return false;
            }
            if (value.indexOf(58) >= 0) {
                return false;
            }
            if (value.indexOf(34) >= 0) {
                return false;
            }
            if (value.indexOf(42) >= 0) {
                return false;
            }
            if (value.indexOf(63) >= 0) {
                return false;
            }
        }
        return true;
    }

    private int countBackslashesBackwards(String string, int from) {
        int bslashCount = 0;
        while (--from >= 0 && string.charAt(from) == '\\') {
            ++bslashCount;
        }
        return bslashCount;
    }

    private void init(String domain, String propertiesString, Map properties) {
        this.initDomain(domain);
        this.initProperties(properties);
        this.propertiesString = propertiesString;
        StringBuffer buffer = new StringBuffer(domain).append(':').append(this.convertPropertiesToString(new TreeMap(properties)));
        if (this.isPropertyPattern()) {
            if (this.getKeyPropertyListString().length() == 0) {
                buffer.append('*');
            } else {
                buffer.append(",*");
            }
        }
        this.canonicalName = buffer.toString();
    }

    private void initDomain(String domain) {
        if (domain.indexOf(42) >= 0 || domain.indexOf(63) >= 0) {
            this.isDomainPattern = true;
        }
    }

    private void initProperties(Map properties) {
        if (properties.containsKey("*")) {
            properties.remove("*");
            this.isPropertyPattern = true;
        }
    }

    private String convertPropertiesToString(Map properties) {
        StringBuffer b = new StringBuffer();
        boolean firstTime = true;
        Iterator i = properties.entrySet().iterator();
        while (i.hasNext()) {
            if (!firstTime) {
                b.append(",");
            } else {
                firstTime = false;
            }
            Map.Entry entry = i.next();
            b.append(entry.getKey());
            b.append("=");
            b.append(entry.getValue());
        }
        return b.toString();
    }

    public int hashCode() {
        return this.getCanonicalName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            ObjectName other = (ObjectName)obj;
            return this.getCanonicalName().equals(other.getCanonicalName());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return this.getName(false);
    }

    private String getName(boolean canonical) {
        StringBuffer buffer = new StringBuffer(this.getDomain()).append(':');
        String properties = canonical ? this.getCanonicalKeyPropertyListString() : this.getKeyPropertyListString();
        buffer.append(properties);
        if (this.isPropertyPattern()) {
            if (properties.length() == 0) {
                buffer.append("*");
            } else {
                buffer.append(",*");
            }
        }
        return buffer.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        String name = this.getName(false);
        out.writeObject(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String objectName = (String)in.readObject();
        try {
            this.parse(objectName);
        }
        catch (MalformedObjectNameException x) {
            throw new InvalidObjectException("String representing the ObjectName is not a valid ObjectName: " + x.toString());
        }
    }

    static {
        String enableCache = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("mx4j.objectname.caching");
            }
        });
        cacheEnabled = enableCache != null ? Boolean.valueOf(enableCache) : true;
        cache = cacheEnabled ? new WeakObjectNameCache() : null;
    }

    private static class WeakObjectNameCache {
        private ReferenceQueue queue = new ReferenceQueue();
        private HashMap map = new HashMap();

        private WeakObjectNameCache() {
        }

        public void put(String key, ObjectName value) {
            this.cleanup();
            this.map.put(key, WeakValue.create(key, value, this.queue));
        }

        public ObjectName get(String key) {
            this.cleanup();
            WeakValue value = (WeakValue)this.map.get(key);
            if (value == null) {
                return null;
            }
            return (ObjectName)value.get();
        }

        private void cleanup() {
            WeakValue ref = null;
            while ((ref = (WeakValue)this.queue.poll()) != null) {
                this.map.remove(ref.getKey());
            }
        }

        private static final class WeakValue
        extends WeakReference {
            private Object key;

            public static WeakValue create(Object key, Object value, ReferenceQueue queue) {
                if (value == null) {
                    return null;
                }
                return new WeakValue(key, value, queue);
            }

            private WeakValue(Object key, Object value, ReferenceQueue queue) {
                super(value, queue);
                this.key = key;
            }

            public Object getKey() {
                return this.key;
            }
        }
    }
}

