/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

public class MBeanServerNotificationFilter
extends NotificationFilterSupport {
    private static final long serialVersionUID = 2605900539589789736L;
    private static final String[] serialNames = new String[]{"selectedNames", "deselectedNames"};
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField(serialNames[0], List.class), new ObjectStreamField(serialNames[1], List.class)};
    private HashSet m_disabledObjectNames;
    private HashSet m_enabledObjectNames;

    public MBeanServerNotificationFilter() {
        this.enableType("JMX.mbean.registered");
        this.enableType("JMX.mbean.unregistered");
        this.disableAllObjectNames();
    }

    public int hashCode() {
        int result = this.m_disabledObjectNames != null ? this.m_disabledObjectNames.hashCode() : 0;
        result = 29 * result + (this.m_enabledObjectNames != null ? this.m_enabledObjectNames.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MBeanServerNotificationFilter)) {
            return false;
        }
        MBeanServerNotificationFilter other = (MBeanServerNotificationFilter)obj;
        if (this.m_disabledObjectNames != null ? !this.m_disabledObjectNames.equals(other.m_disabledObjectNames) : other.m_disabledObjectNames != null) {
            return false;
        }
        return !(this.m_enabledObjectNames != null ? !this.m_enabledObjectNames.equals(other.m_enabledObjectNames) : other.m_enabledObjectNames != null);
    }

    public void disableAllObjectNames() {
        if (this.m_enabledObjectNames == null) {
            this.m_enabledObjectNames = new HashSet();
        } else {
            this.m_enabledObjectNames.clear();
        }
        this.m_disabledObjectNames = null;
    }

    public void enableAllObjectNames() {
        if (this.m_disabledObjectNames == null) {
            this.m_disabledObjectNames = new HashSet();
        } else {
            this.m_disabledObjectNames.clear();
        }
        this.m_enabledObjectNames = null;
    }

    public void enableObjectName(ObjectName name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("ObjectName cannot be null");
        }
        if (this.m_disabledObjectNames != null && this.m_disabledObjectNames.size() > 0) {
            this.m_disabledObjectNames.remove(name);
        }
        if (this.m_enabledObjectNames != null) {
            this.m_enabledObjectNames.add(name);
        }
    }

    public void disableObjectName(ObjectName name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("ObjectName cannot be null");
        }
        if (this.m_enabledObjectNames != null && this.m_enabledObjectNames.size() > 0) {
            this.m_enabledObjectNames.remove(name);
        }
        if (this.m_disabledObjectNames != null) {
            this.m_disabledObjectNames.add(name);
        }
    }

    public Vector getEnabledObjectNames() {
        if (this.m_enabledObjectNames == null) {
            return null;
        }
        Vector v = new Vector();
        v.addAll(this.m_enabledObjectNames);
        return v;
    }

    public Vector getDisabledObjectNames() {
        if (this.m_disabledObjectNames == null) {
            return null;
        }
        Vector v = new Vector();
        v.addAll(this.m_disabledObjectNames);
        return v;
    }

    public boolean isNotificationEnabled(Notification notification) {
        boolean goOn = super.isNotificationEnabled(notification);
        if (goOn && notification instanceof MBeanServerNotification) {
            MBeanServerNotification n = (MBeanServerNotification)notification;
            ObjectName name = n.getMBeanName();
            if (this.m_enabledObjectNames == null) {
                return this.m_disabledObjectNames == null || !this.m_disabledObjectNames.contains(name);
            }
            return this.m_enabledObjectNames.contains(name);
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        Vector vector = (Vector)fields.get(serialNames[0], null);
        if (fields.defaulted(serialNames[0])) {
            throw new IOException("Serialized stream corrupted: expecting a non-null Vector");
        }
        if (vector != null) {
            if (this.m_enabledObjectNames == null) {
                this.m_enabledObjectNames = new HashSet();
            }
            this.m_enabledObjectNames.clear();
            this.m_enabledObjectNames.addAll(vector);
        }
        vector = (Vector)fields.get(serialNames[1], null);
        if (fields.defaulted(serialNames[1])) {
            throw new IOException("Serialized stream corrupted: expecting a non-null Vector");
        }
        if (vector != null) {
            if (this.m_disabledObjectNames == null) {
                this.m_disabledObjectNames = new HashSet();
            }
            this.m_disabledObjectNames.clear();
            this.m_disabledObjectNames.addAll(vector);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        Vector vector = this.getEnabledObjectNames();
        fields.put(serialNames[0], vector);
        vector = this.getDisabledObjectNames();
        fields.put(serialNames[1], vector);
        out.writeFields();
    }
}

