/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.local;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;
import mx4j.remote.ConnectionResolver;
import mx4j.tools.remote.AbstractJMXConnectorServer;
import mx4j.tools.remote.local.LocalConnectionManager;

public class LocalConnectorServer
extends AbstractJMXConnectorServer {
    private static Map instances = new HashMap();
    private MBeanServer mbeanServer;
    private LocalConnectionManager connectionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalConnectionManager find(JMXServiceURL url) {
        Class<LocalConnectorServer> clazz = LocalConnectorServer.class;
        synchronized (LocalConnectorServer.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (LocalConnectionManager)instances.get(url);
        }
    }

    public LocalConnectorServer(JMXServiceURL url, Map environment, MBeanServer server) {
        super(url, environment, server);
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    protected void doStart() throws IOException {
        Map environment;
        JMXServiceURL address = this.getAddress();
        String protocol = address.getProtocol();
        ConnectionResolver resolver = ConnectionResolver.newConnectionResolver(protocol, environment = this.getEnvironment());
        if (resolver == null) {
            throw new MalformedURLException("Unsupported protocol: " + protocol);
        }
        MBeanServer realServer = null;
        MBeanServer server = super.getMBeanServer();
        MBeanServer resolvedServer = (MBeanServer)resolver.createServer(address, environment);
        if (resolvedServer == null) {
            if (server == null) {
                throw new IllegalStateException("This LocalConnectorServer is not attached to an MBeanServer");
            }
            realServer = server;
        } else if (server == null) {
            realServer = resolvedServer;
        } else {
            if (server != resolvedServer) {
                throw new IllegalStateException("This LocalConnectorServer cannot be attached to 2 MBeanServers");
            }
            realServer = server;
        }
        this.mbeanServer = realServer;
        this.connectionManager = new LocalConnectionManager(this, environment);
        this.setAddress(resolver.bindServer(realServer, address, environment));
        this.register(this.getAddress(), this.connectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(JMXServiceURL url, LocalConnectionManager manager) throws IOException {
        Class<LocalConnectorServer> clazz = LocalConnectorServer.class;
        synchronized (LocalConnectorServer.class) {
            if (instances.get(url) != null) {
                throw new IOException("A LocalConnectorServer is already serving at address " + url);
            }
            instances.put(url, manager);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected void doStop() throws IOException {
        this.connectionManager.close();
        JMXServiceURL address = this.getAddress();
        String protocol = address.getProtocol();
        Map environment = this.getEnvironment();
        ConnectionResolver resolver = ConnectionResolver.newConnectionResolver(protocol, environment);
        if (resolver == null) {
            throw new MalformedURLException("Unsupported protocol: " + protocol);
        }
        MBeanServer server = this.getMBeanServer();
        resolver.unbindServer(server, address, environment);
        resolver.destroyServer(server, address, environment);
        this.unregister(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(JMXServiceURL url) throws IOException {
        Class<LocalConnectorServer> clazz = LocalConnectorServer.class;
        synchronized (LocalConnectorServer.class) {
            Object removed = instances.remove(url);
            if (removed == null) {
                throw new IOException("No LocalConnectorServer is present for address " + url);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

