/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.AnnotationMemberValue;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.apt.model.NameImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.VariableElementImpl;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.jdt.internal.compiler.lookup.AptBinaryLocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ExecutableElementImpl
extends ElementImpl
implements ExecutableElement {
    private Name _name = null;

    ExecutableElementImpl(BaseProcessingEnvImpl baseProcessingEnvImpl, MethodBinding methodBinding) {
        super(baseProcessingEnvImpl, methodBinding);
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
        return elementVisitor.visitExecutable(this, p);
    }

    @Override
    protected AnnotationBinding[] getAnnotationBindings() {
        return ((MethodBinding)this._binding).getAnnotations();
    }

    @Override
    public AnnotationValue getDefaultValue() {
        MethodBinding methodBinding = (MethodBinding)this._binding;
        Object object = methodBinding.getDefaultValue();
        if (object != null) {
            return new AnnotationMemberValue(this._env, object, methodBinding);
        }
        return null;
    }

    @Override
    public List<? extends Element> getEnclosedElements() {
        return Collections.emptyList();
    }

    @Override
    public Element getEnclosingElement() {
        MethodBinding methodBinding = (MethodBinding)this._binding;
        if (null == methodBinding.declaringClass) {
            return null;
        }
        return this._env.getFactory().newElement(methodBinding.declaringClass);
    }

    @Override
    public String getFileName() {
        ReferenceBinding referenceBinding = ((MethodBinding)this._binding).declaringClass;
        char[] cArray = referenceBinding.getFileName();
        if (cArray == null) {
            return null;
        }
        return new String(cArray);
    }

    @Override
    public ElementKind getKind() {
        MethodBinding methodBinding = (MethodBinding)this._binding;
        if (methodBinding.isConstructor()) {
            return ElementKind.CONSTRUCTOR;
        }
        if (CharOperation.equals(methodBinding.selector, TypeConstants.CLINIT)) {
            return ElementKind.STATIC_INIT;
        }
        if (CharOperation.equals(methodBinding.selector, TypeConstants.INIT)) {
            return ElementKind.INSTANCE_INIT;
        }
        return ElementKind.METHOD;
    }

    @Override
    public Set<Modifier> getModifiers() {
        MethodBinding methodBinding = (MethodBinding)this._binding;
        return Factory.getModifiers(methodBinding.modifiers, this.getKind());
    }

    @Override
    PackageElement getPackage() {
        MethodBinding methodBinding = (MethodBinding)this._binding;
        if (null == methodBinding.declaringClass) {
            return null;
        }
        return this._env.getFactory().newPackageElement(methodBinding.declaringClass.fPackage);
    }

    @Override
    public List<? extends VariableElement> getParameters() {
        int n;
        MethodBinding methodBinding = (MethodBinding)this._binding;
        int n2 = n = methodBinding.parameters == null ? 0 : methodBinding.parameters.length;
        if (0 != n) {
            AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
            ArrayList<VariableElementImpl> arrayList = new ArrayList<VariableElementImpl>(n);
            if (abstractMethodDeclaration != null) {
                for (Argument argument : abstractMethodDeclaration.arguments) {
                    VariableElementImpl variableElementImpl = new VariableElementImpl(this._env, argument.binding);
                    arrayList.add(variableElementImpl);
                }
            } else {
                boolean bl = methodBinding.isConstructor() && methodBinding.declaringClass.isEnum() && methodBinding.declaringClass.isBinaryBinding() && (methodBinding.modifiers & 0x40000000) == 0;
                AnnotationBinding[][] annotationBindingArray = null;
                AnnotationHolder annotationHolder = methodBinding.declaringClass.retrieveAnnotationHolder(methodBinding, false);
                if (annotationHolder != null) {
                    annotationBindingArray = annotationHolder.getParameterAnnotations();
                }
                if (bl) {
                    if (n == 2) {
                        return Collections.emptyList();
                    }
                    for (int i = 2; i < n; ++i) {
                        TypeBinding typeBinding = methodBinding.parameters[i];
                        StringBuilder stringBuilder = new StringBuilder("arg");
                        stringBuilder.append(i - 2);
                        VariableElementImpl variableElementImpl = new VariableElementImpl(this._env, new AptBinaryLocalVariableBinding(String.valueOf(stringBuilder).toCharArray(), typeBinding, 0, null, methodBinding));
                        arrayList.add(variableElementImpl);
                    }
                } else {
                    int n3 = 0;
                    for (TypeBinding typeBinding : methodBinding.parameters) {
                        StringBuilder stringBuilder = new StringBuilder("arg");
                        stringBuilder.append(n3);
                        VariableElementImpl variableElementImpl = new VariableElementImpl(this._env, new AptBinaryLocalVariableBinding(String.valueOf(stringBuilder).toCharArray(), typeBinding, 0, annotationBindingArray != null ? annotationBindingArray[n3] : null, methodBinding));
                        arrayList.add(variableElementImpl);
                        ++n3;
                    }
                }
            }
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    @Override
    public TypeMirror getReturnType() {
        MethodBinding methodBinding = (MethodBinding)this._binding;
        if (methodBinding.returnType == null) {
            return null;
        }
        return this._env.getFactory().newTypeMirror(methodBinding.returnType);
    }

    @Override
    public Name getSimpleName() {
        MethodBinding methodBinding = (MethodBinding)this._binding;
        if (this._name == null) {
            this._name = new NameImpl(methodBinding.selector);
        }
        return this._name;
    }

    @Override
    public List<? extends TypeMirror> getThrownTypes() {
        MethodBinding methodBinding = (MethodBinding)this._binding;
        if (methodBinding.thrownExceptions.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(methodBinding.thrownExceptions.length);
        for (ReferenceBinding referenceBinding : methodBinding.thrownExceptions) {
            arrayList.add(this._env.getFactory().newTypeMirror(referenceBinding));
        }
        return arrayList;
    }

    @Override
    public List<? extends TypeParameterElement> getTypeParameters() {
        MethodBinding methodBinding = (MethodBinding)this._binding;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables();
        if (typeVariableBindingArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<TypeParameterElement> arrayList = new ArrayList<TypeParameterElement>(typeVariableBindingArray.length);
        for (TypeVariableBinding typeVariableBinding : typeVariableBindingArray) {
            arrayList.add(this._env.getFactory().newTypeParameterElement(typeVariableBinding, this));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public boolean hides(Element element) {
        if (!(element instanceof ExecutableElementImpl)) {
            return false;
        }
        MethodBinding methodBinding = (MethodBinding)this._binding;
        MethodBinding methodBinding2 = (MethodBinding)((ExecutableElementImpl)element)._binding;
        if (methodBinding == methodBinding2) {
            return false;
        }
        if (methodBinding2.isPrivate()) {
            return false;
        }
        if (!methodBinding.isStatic() || !methodBinding2.isStatic()) {
            return false;
        }
        if (!CharOperation.equals(methodBinding2.selector, methodBinding.selector)) {
            return false;
        }
        if (!this._env.getLookupEnvironment().methodVerifier().isMethodSubsignature(methodBinding, methodBinding2)) {
            return false;
        }
        return null != methodBinding.declaringClass.findSuperTypeOriginatingFrom(methodBinding2.declaringClass);
    }

    @Override
    public boolean isVarArgs() {
        return ((MethodBinding)this._binding).isVarargs();
    }

    public boolean overrides(ExecutableElement executableElement, TypeElement typeElement) {
        MethodBinding methodBinding = (MethodBinding)((ExecutableElementImpl)executableElement)._binding;
        ReferenceBinding referenceBinding = (ReferenceBinding)((TypeElementImpl)typeElement)._binding;
        if ((MethodBinding)this._binding == methodBinding || methodBinding.isStatic() || methodBinding.isPrivate() || ((MethodBinding)this._binding).isStatic()) {
            return false;
        }
        char[] cArray = ((MethodBinding)this._binding).selector;
        if (!CharOperation.equals(cArray, methodBinding.selector)) {
            return false;
        }
        if (null == referenceBinding.findSuperTypeOriginatingFrom(((MethodBinding)this._binding).declaringClass) && null == ((MethodBinding)this._binding).declaringClass.findSuperTypeOriginatingFrom(referenceBinding)) {
            return false;
        }
        MethodBinding methodBinding2 = new MethodBinding((MethodBinding)this._binding, referenceBinding);
        if (methodBinding2.isPrivate()) {
            return false;
        }
        TypeBinding typeBinding = methodBinding2.declaringClass.findSuperTypeOriginatingFrom(methodBinding.declaringClass);
        if (!(typeBinding instanceof ReferenceBinding)) {
            return false;
        }
        MethodBinding[] methodBindingArray = ((ReferenceBinding)typeBinding).getMethods(cArray);
        LookupEnvironment lookupEnvironment = this._env.getLookupEnvironment();
        if (lookupEnvironment == null) {
            return false;
        }
        MethodVerifier methodVerifier = lookupEnvironment.methodVerifier();
        int n = methodBindingArray.length;
        for (int i = 0; i < n; ++i) {
            if (methodBindingArray[i].original() != methodBinding) continue;
            return methodVerifier.doesMethodOverride(methodBinding2, methodBindingArray[i]);
        }
        return false;
    }
}

