/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.ShouldNotImplement;
import org.eclipse.jdt.internal.compiler.util.Messages;

public abstract class Expression
extends Statement {
    public Constant constant;
    public int statementEnd = -1;
    public int implicitConversion;
    public TypeBinding resolvedType;

    public static final boolean isConstantValueRepresentable(Constant constant, int n, int n2) {
        if (n2 == n) {
            return true;
        }
        switch (n2) {
            case 2: {
                switch (n) {
                    case 2: {
                        return true;
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.charValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.charValue();
                    }
                    case 10: {
                        return constant.intValue() == constant.charValue();
                    }
                    case 4: {
                        return constant.shortValue() == constant.charValue();
                    }
                    case 3: {
                        return constant.byteValue() == constant.charValue();
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.charValue();
                    }
                }
                return false;
            }
            case 9: {
                switch (n) {
                    case 2: {
                        return (float)constant.charValue() == constant.floatValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.floatValue();
                    }
                    case 9: {
                        return true;
                    }
                    case 10: {
                        return (float)constant.intValue() == constant.floatValue();
                    }
                    case 4: {
                        return (float)constant.shortValue() == constant.floatValue();
                    }
                    case 3: {
                        return (float)constant.byteValue() == constant.floatValue();
                    }
                    case 7: {
                        return (float)constant.longValue() == constant.floatValue();
                    }
                }
                return false;
            }
            case 8: {
                switch (n) {
                    case 2: {
                        return (double)constant.charValue() == constant.doubleValue();
                    }
                    case 8: {
                        return true;
                    }
                    case 9: {
                        return (double)constant.floatValue() == constant.doubleValue();
                    }
                    case 10: {
                        return (double)constant.intValue() == constant.doubleValue();
                    }
                    case 4: {
                        return (double)constant.shortValue() == constant.doubleValue();
                    }
                    case 3: {
                        return (double)constant.byteValue() == constant.doubleValue();
                    }
                    case 7: {
                        return (double)constant.longValue() == constant.doubleValue();
                    }
                }
                return false;
            }
            case 3: {
                switch (n) {
                    case 2: {
                        return constant.charValue() == constant.byteValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.byteValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.byteValue();
                    }
                    case 10: {
                        return constant.intValue() == constant.byteValue();
                    }
                    case 4: {
                        return constant.shortValue() == constant.byteValue();
                    }
                    case 3: {
                        return true;
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.byteValue();
                    }
                }
                return false;
            }
            case 4: {
                switch (n) {
                    case 2: {
                        return constant.charValue() == constant.shortValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.shortValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.shortValue();
                    }
                    case 10: {
                        return constant.intValue() == constant.shortValue();
                    }
                    case 4: {
                        return true;
                    }
                    case 3: {
                        return constant.byteValue() == constant.shortValue();
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.shortValue();
                    }
                }
                return false;
            }
            case 10: {
                switch (n) {
                    case 2: {
                        return constant.charValue() == constant.intValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.intValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.intValue();
                    }
                    case 10: {
                        return true;
                    }
                    case 4: {
                        return constant.shortValue() == constant.intValue();
                    }
                    case 3: {
                        return constant.byteValue() == constant.intValue();
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.intValue();
                    }
                }
                return false;
            }
            case 7: {
                switch (n) {
                    case 2: {
                        return (long)constant.charValue() == constant.longValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.longValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.longValue();
                    }
                    case 10: {
                        return (long)constant.intValue() == constant.longValue();
                    }
                    case 4: {
                        return (long)constant.shortValue() == constant.longValue();
                    }
                    case 3: {
                        return (long)constant.byteValue() == constant.longValue();
                    }
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, boolean bl) {
        return this.analyseCode(blockScope, flowContext, flowInfo);
    }

    public final boolean checkCastTypesCompatibility(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2, Expression expression) {
        boolean bl;
        if (typeBinding == null || typeBinding2 == null) {
            return true;
        }
        boolean bl2 = scope.compilerOptions().sourceLevel >= 0x310000L;
        boolean bl3 = bl = scope.compilerOptions().sourceLevel >= 0x330000L;
        if (typeBinding.isBaseType()) {
            if (typeBinding2.isBaseType()) {
                if (typeBinding2 == typeBinding) {
                    if (expression != null) {
                        this.constant = expression.constant;
                    }
                    this.tagAsUnnecessaryCast(scope, typeBinding);
                    return true;
                }
                boolean bl4 = false;
                if (typeBinding2.isCompatibleWith(typeBinding) || (bl4 = BaseTypeBinding.isNarrowing(typeBinding.id, typeBinding2.id))) {
                    if (expression != null) {
                        expression.implicitConversion = (typeBinding.id << 4) + typeBinding2.id;
                        if (expression.constant != Constant.NotAConstant) {
                            this.constant = expression.constant.castTo(expression.implicitConversion);
                        }
                    }
                    if (!bl4) {
                        this.tagAsUnnecessaryCast(scope, typeBinding);
                    }
                    return true;
                }
            } else {
                if (bl && typeBinding2.id == 1) {
                    return true;
                }
                if (bl2 && scope.environment().computeBoxingType(typeBinding2).isCompatibleWith(typeBinding)) {
                    this.tagAsUnnecessaryCast(scope, typeBinding);
                    return true;
                }
            }
            return false;
        }
        if (bl2 && typeBinding2.isBaseType() && scope.environment().computeBoxingType(typeBinding2).isCompatibleWith(typeBinding)) {
            this.tagAsUnnecessaryCast(scope, typeBinding);
            return true;
        }
        switch (typeBinding2.kind()) {
            case 132: {
                if (typeBinding2 == TypeBinding.NULL) {
                    this.tagAsUnnecessaryCast(scope, typeBinding);
                    return true;
                }
                return false;
            }
            case 68: {
                if (typeBinding == typeBinding2) {
                    this.tagAsUnnecessaryCast(scope, typeBinding);
                    return true;
                }
                switch (typeBinding.kind()) {
                    case 68: {
                        TypeBinding typeBinding3 = ((ArrayBinding)typeBinding).elementsType();
                        TypeBinding typeBinding4 = ((ArrayBinding)typeBinding2).elementsType();
                        if (typeBinding4.isBaseType() || typeBinding3.isBaseType()) {
                            if (typeBinding3 == typeBinding4) {
                                this.tagAsNeedCheckCast();
                                return true;
                            }
                            return false;
                        }
                        return this.checkCastTypesCompatibility(scope, typeBinding3, typeBinding4, expression);
                    }
                    case 4100: {
                        TypeBinding typeBinding5 = typeBinding2.findSuperTypeOriginatingFrom(typeBinding);
                        if (typeBinding5 == null) {
                            this.checkUnsafeCast(scope, typeBinding, typeBinding2, null, true);
                        }
                        return this.checkCastTypesCompatibility(scope, ((TypeVariableBinding)typeBinding).upperBound(), typeBinding2, expression);
                    }
                }
                switch (typeBinding.id) {
                    case 36: 
                    case 37: {
                        this.tagAsNeedCheckCast();
                        return true;
                    }
                    case 1: {
                        this.tagAsUnnecessaryCast(scope, typeBinding);
                        return true;
                    }
                }
                return false;
            }
            case 4100: {
                TypeBinding typeBinding6 = typeBinding2.findSuperTypeOriginatingFrom(typeBinding);
                if (typeBinding6 != null) {
                    return this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding6, false);
                }
                return this.checkCastTypesCompatibility(scope, typeBinding, ((TypeVariableBinding)typeBinding2).upperBound(), expression);
            }
            case 516: 
            case 8196: {
                TypeBinding typeBinding7 = typeBinding2.findSuperTypeOriginatingFrom(typeBinding);
                if (typeBinding7 != null) {
                    return this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding7, false);
                }
                return this.checkCastTypesCompatibility(scope, typeBinding, ((WildcardBinding)typeBinding2).bound, expression);
            }
        }
        if (typeBinding2.isInterface()) {
            switch (typeBinding.kind()) {
                case 68: {
                    switch (typeBinding2.id) {
                        case 36: 
                        case 37: {
                            this.tagAsNeedCheckCast();
                            return true;
                        }
                    }
                    return false;
                }
                case 4100: {
                    TypeBinding typeBinding8 = typeBinding2.findSuperTypeOriginatingFrom(typeBinding);
                    if (typeBinding8 == null) {
                        this.checkUnsafeCast(scope, typeBinding, typeBinding2, null, true);
                    }
                    return this.checkCastTypesCompatibility(scope, ((TypeVariableBinding)typeBinding).upperBound(), typeBinding2, expression);
                }
            }
            if (typeBinding.isInterface()) {
                ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding2;
                TypeBinding typeBinding9 = referenceBinding.findSuperTypeOriginatingFrom(typeBinding);
                if (typeBinding9 != null) {
                    return this.checkUnsafeCast(scope, typeBinding, referenceBinding, typeBinding9, false);
                }
                this.tagAsNeedCheckCast();
                typeBinding9 = typeBinding.findSuperTypeOriginatingFrom(referenceBinding);
                if (typeBinding9 != null) {
                    return this.checkUnsafeCast(scope, typeBinding, referenceBinding, typeBinding9, true);
                }
                if (bl2) {
                    this.checkUnsafeCast(scope, typeBinding, typeBinding2, null, true);
                    if (scope.compilerOptions().complianceLevel < 0x330000L ? referenceBinding.hasIncompatibleSuperType((ReferenceBinding)typeBinding) : !typeBinding.isRawType() && referenceBinding.hasIncompatibleSuperType((ReferenceBinding)typeBinding)) {
                        return false;
                    }
                } else {
                    MethodBinding[] methodBindingArray = this.getAllOriginalInheritedMethods((ReferenceBinding)typeBinding);
                    MethodBinding[] methodBindingArray2 = this.getAllOriginalInheritedMethods((ReferenceBinding)typeBinding2);
                    int n = methodBindingArray2.length;
                    int n2 = methodBindingArray.length;
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            if (methodBindingArray[i].returnType == methodBindingArray2[j].returnType || !CharOperation.equals(methodBindingArray[i].selector, methodBindingArray2[j].selector) || !methodBindingArray[i].areParametersEqual(methodBindingArray2[j])) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
            if (typeBinding.id == 1) {
                this.tagAsUnnecessaryCast(scope, typeBinding);
                return true;
            }
            this.tagAsNeedCheckCast();
            TypeBinding typeBinding10 = typeBinding.findSuperTypeOriginatingFrom(typeBinding2);
            if (typeBinding10 != null) {
                return this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding10, true);
            }
            if (((ReferenceBinding)typeBinding).isFinal()) {
                return false;
            }
            if (bl2) {
                this.checkUnsafeCast(scope, typeBinding, typeBinding2, null, true);
                if (scope.compilerOptions().complianceLevel < 0x330000L ? ((ReferenceBinding)typeBinding).hasIncompatibleSuperType((ReferenceBinding)typeBinding2) : !typeBinding.isRawType() && ((ReferenceBinding)typeBinding).hasIncompatibleSuperType((ReferenceBinding)typeBinding2)) {
                    return false;
                }
            }
            return true;
        }
        switch (typeBinding.kind()) {
            case 68: {
                if (typeBinding2.id == 1) {
                    if (bl2) {
                        this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding2, true);
                    }
                    this.tagAsNeedCheckCast();
                    return true;
                }
                return false;
            }
            case 4100: {
                TypeBinding typeBinding11 = typeBinding2.findSuperTypeOriginatingFrom(typeBinding);
                if (typeBinding11 == null) {
                    this.checkUnsafeCast(scope, typeBinding, typeBinding2, null, true);
                }
                return this.checkCastTypesCompatibility(scope, ((TypeVariableBinding)typeBinding).upperBound(), typeBinding2, expression);
            }
        }
        if (typeBinding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding2;
            TypeBinding typeBinding12 = referenceBinding.findSuperTypeOriginatingFrom(typeBinding);
            if (typeBinding12 != null) {
                return this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding12, false);
            }
            if (referenceBinding.isFinal()) {
                return false;
            }
            this.tagAsNeedCheckCast();
            typeBinding12 = typeBinding.findSuperTypeOriginatingFrom(typeBinding2);
            if (typeBinding12 != null) {
                return this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding12, true);
            }
            if (bl2) {
                this.checkUnsafeCast(scope, typeBinding, typeBinding2, null, true);
                if (scope.compilerOptions().complianceLevel < 0x330000L ? referenceBinding.hasIncompatibleSuperType((ReferenceBinding)typeBinding) : !typeBinding.isRawType() && referenceBinding.hasIncompatibleSuperType((ReferenceBinding)typeBinding)) {
                    return false;
                }
            }
            return true;
        }
        TypeBinding typeBinding13 = typeBinding2.findSuperTypeOriginatingFrom(typeBinding);
        if (typeBinding13 != null) {
            if (expression != null && typeBinding.id == 11) {
                this.constant = expression.constant;
            }
            return this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding13, false);
        }
        typeBinding13 = typeBinding.findSuperTypeOriginatingFrom(typeBinding2);
        if (typeBinding13 != null) {
            this.tagAsNeedCheckCast();
            return this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding13, true);
        }
        return false;
    }

    public void checkNPE(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        LocalVariableBinding localVariableBinding = this.localVariableBinding();
        if (localVariableBinding != null && (localVariableBinding.type.tagBits & 2L) == 0L) {
            if ((this.bits & 0x20000) == 0) {
                flowContext.recordUsingNullReference(blockScope, localVariableBinding, this, 3, flowInfo);
            }
            flowInfo.markAsComparedEqualToNonNull(localVariableBinding);
            if ((flowContext.tagBits & 4) != 0) {
                flowInfo.markedAsNullOrNonNullInAssertExpression(localVariableBinding);
            }
            if (flowContext.initsOnFinally != null) {
                flowContext.initsOnFinally.markAsComparedEqualToNonNull(localVariableBinding);
                if ((flowContext.tagBits & 4) != 0) {
                    flowContext.initsOnFinally.markedAsNullOrNonNullInAssertExpression(localVariableBinding);
                }
            }
        }
    }

    public boolean checkUnsafeCast(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3, boolean bl) {
        if (typeBinding3 == typeBinding) {
            if (!bl) {
                this.tagAsUnnecessaryCast(scope, typeBinding);
            }
            return true;
        }
        if (!(typeBinding3 == null || typeBinding.isReifiable() && typeBinding2.isReifiable() || !(bl ? typeBinding3.isProvablyDistinct(typeBinding2) : typeBinding.isProvablyDistinct(typeBinding3)))) {
            return false;
        }
        if (!bl) {
            this.tagAsUnnecessaryCast(scope, typeBinding);
        }
        return true;
    }

    public void computeConversion(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        int n;
        if (typeBinding == null || typeBinding2 == null) {
            return;
        }
        if (this.implicitConversion != 0) {
            return;
        }
        if (typeBinding != TypeBinding.NULL && typeBinding.isBaseType()) {
            if (!typeBinding2.isBaseType()) {
                TypeBinding typeBinding3 = scope.environment().computeBoxingType(typeBinding2);
                this.implicitConversion = 1024;
                scope.problemReporter().autoboxing(this, typeBinding2, typeBinding);
                typeBinding2 = typeBinding3;
            }
        } else {
            if (typeBinding2 != TypeBinding.NULL && typeBinding2.isBaseType()) {
                TypeBinding typeBinding4 = scope.environment().computeBoxingType(typeBinding);
                if (typeBinding4 == typeBinding) {
                    typeBinding4 = typeBinding2;
                }
                this.implicitConversion = 0x200 | (typeBinding4.id << 4) + typeBinding2.id;
                scope.problemReporter().autoboxing(this, typeBinding2, scope.environment().computeBoxingType(typeBinding4));
                return;
            }
            if (this.constant != Constant.NotAConstant && this.constant.typeID() != 11) {
                this.implicitConversion = 512;
                return;
            }
        }
        if ((n = typeBinding2.id) == Integer.MAX_VALUE) {
            n = typeBinding2.erasure().id == 11 ? 11 : 1;
        }
        int n2 = typeBinding.id;
        switch (n2) {
            case 2: 
            case 3: 
            case 4: {
                if (n == 1) {
                    this.implicitConversion |= (n2 << 4) + n;
                    break;
                }
                this.implicitConversion |= 160 + n;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.implicitConversion |= (n2 << 4) + n;
                break;
            }
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        this.generateCode(blockScope, codeStream, false);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        if (this.constant == Constant.NotAConstant) {
            throw new ShouldNotImplement(Messages.ast_missingCode);
        }
        int n = codeStream.position;
        codeStream.generateConstant(this.constant, this.implicitConversion);
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public void generateOptimizedBoolean(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        Constant constant = this.optimizedBooleanConstant();
        this.generateCode(blockScope, codeStream, bl && constant == Constant.NotAConstant);
        if (constant != Constant.NotAConstant && constant.typeID() == 5) {
            int n = codeStream.position;
            if (constant.booleanValue()) {
                if (bl && branchLabel2 == null && branchLabel != null) {
                    codeStream.goto_(branchLabel);
                }
            } else if (bl && branchLabel2 != null && branchLabel == null) {
                codeStream.goto_(branchLabel2);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        int n = codeStream.position;
        if (bl) {
            if (branchLabel2 == null) {
                if (branchLabel != null) {
                    codeStream.ifne(branchLabel);
                }
            } else if (branchLabel == null) {
                codeStream.ifeq(branchLabel2);
            }
        }
        codeStream.updateLastRecordedEndPC(blockScope, n);
    }

    public void generateOptimizedStringConcatenation(BlockScope blockScope, CodeStream codeStream, int n) {
        if (n == 11 && this.constant != Constant.NotAConstant && this.constant.stringValue().length() == 0) {
            return;
        }
        this.generateCode(blockScope, codeStream, true);
        codeStream.invokeStringConcatenationAppendForType(n);
    }

    public void generateOptimizedStringConcatenationCreation(BlockScope blockScope, CodeStream codeStream, int n) {
        codeStream.newStringContatenation();
        codeStream.dup();
        switch (n) {
            case 0: 
            case 1: {
                codeStream.invokeStringConcatenationDefaultConstructor();
                this.generateCode(blockScope, codeStream, true);
                codeStream.invokeStringConcatenationAppendForType(1);
                return;
            }
            case 11: 
            case 12: {
                if (this.constant != Constant.NotAConstant) {
                    String string = this.constant.stringValue();
                    if (string.length() == 0) {
                        codeStream.invokeStringConcatenationDefaultConstructor();
                        return;
                    }
                    codeStream.ldc(string);
                    break;
                }
                this.generateCode(blockScope, codeStream, true);
                codeStream.invokeStringValueOf(1);
                break;
            }
            default: {
                this.generateCode(blockScope, codeStream, true);
                codeStream.invokeStringValueOf(n);
            }
        }
        codeStream.invokeStringConcatenationStringConstructor();
    }

    private MethodBinding[] getAllOriginalInheritedMethods(ReferenceBinding referenceBinding) {
        ArrayList<MethodBinding> arrayList = new ArrayList<MethodBinding>();
        this.getAllInheritedMethods0(referenceBinding, arrayList);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList.set(i, ((MethodBinding)arrayList.get(i)).original());
        }
        return arrayList.toArray(new MethodBinding[arrayList.size()]);
    }

    private void getAllInheritedMethods0(ReferenceBinding referenceBinding, ArrayList arrayList) {
        if (!referenceBinding.isInterface()) {
            return;
        }
        MethodBinding[] methodBindingArray = referenceBinding.methods();
        int n = methodBindingArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList.add(methodBindingArray[i]);
        }
        ReferenceBinding[] referenceBindingArray = referenceBinding.superInterfaces();
        int n2 = referenceBindingArray.length;
        for (n = 0; n < n2; ++n) {
            this.getAllInheritedMethods0(referenceBindingArray[n], arrayList);
        }
    }

    public static Binding getDirectBinding(Expression expression) {
        if ((expression.bits & 0x20000000) != 0) {
            return null;
        }
        if (expression instanceof SingleNameReference) {
            return ((SingleNameReference)expression).binding;
        }
        if (expression instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)expression;
            if (fieldReference.receiver.isThis() && !(fieldReference.receiver instanceof QualifiedThisReference)) {
                return fieldReference.binding;
            }
        } else if (expression instanceof Assignment) {
            Expression expression2 = ((Assignment)expression).lhs;
            if ((expression2.bits & 0x2000) != 0) {
                return Expression.getDirectBinding(((Assignment)expression).lhs);
            }
            if (expression instanceof PrefixExpression) {
                return Expression.getDirectBinding(((Assignment)expression).lhs);
            }
        } else if (expression instanceof QualifiedNameReference) {
            QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)expression;
            if (qualifiedNameReference.indexOfFirstFieldBinding != 1 && qualifiedNameReference.otherBindings == null) {
                return qualifiedNameReference.binding;
            }
        } else if (expression.isThis()) {
            return expression.resolvedType;
        }
        return null;
    }

    public boolean isCompactableOperation() {
        return false;
    }

    public boolean isConstantValueOfTypeAssignableToType(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (this.constant == Constant.NotAConstant) {
            return false;
        }
        if (typeBinding == typeBinding2) {
            return true;
        }
        if (BaseTypeBinding.isWidening(10, typeBinding.id) && BaseTypeBinding.isNarrowing(typeBinding2.id, 10)) {
            return Expression.isConstantValueRepresentable(this.constant, typeBinding.id, typeBinding2.id);
        }
        return false;
    }

    public boolean isTypeReference() {
        return false;
    }

    public LocalVariableBinding localVariableBinding() {
        return null;
    }

    public void markAsNonNull() {
        this.bits |= 0x20000;
    }

    public int nullStatus(FlowInfo flowInfo) {
        if (this.constant != null && this.constant != Constant.NotAConstant) {
            return 4;
        }
        LocalVariableBinding localVariableBinding = this.localVariableBinding();
        if (localVariableBinding != null) {
            return flowInfo.nullStatus(localVariableBinding);
        }
        return 4;
    }

    public Constant optimizedBooleanConstant() {
        return this.constant;
    }

    public TypeBinding postConversionType(Scope scope) {
        TypeBinding typeBinding = this.resolvedType;
        int n = (this.implicitConversion & 0xFF) >> 4;
        switch (n) {
            case 5: {
                typeBinding = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                typeBinding = TypeBinding.BYTE;
                break;
            }
            case 4: {
                typeBinding = TypeBinding.SHORT;
                break;
            }
            case 2: {
                typeBinding = TypeBinding.CHAR;
                break;
            }
            case 10: {
                typeBinding = TypeBinding.INT;
                break;
            }
            case 9: {
                typeBinding = TypeBinding.FLOAT;
                break;
            }
            case 7: {
                typeBinding = TypeBinding.LONG;
                break;
            }
            case 8: {
                typeBinding = TypeBinding.DOUBLE;
                break;
            }
        }
        if ((this.implicitConversion & 0x200) != 0) {
            typeBinding = scope.environment().computeBoxingType(typeBinding);
        }
        return typeBinding;
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        Expression.printIndent(n, stringBuffer);
        return this.printExpression(n, stringBuffer);
    }

    public abstract StringBuffer printExpression(int var1, StringBuffer var2);

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer).append(";");
    }

    public void resolve(BlockScope blockScope) {
        this.resolveType(blockScope);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        return null;
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return null;
    }

    public TypeBinding resolveTypeExpecting(BlockScope blockScope, TypeBinding typeBinding) {
        this.setExpectedType(typeBinding);
        TypeBinding typeBinding2 = this.resolveType(blockScope);
        if (typeBinding2 == null) {
            return null;
        }
        if (typeBinding2 == typeBinding) {
            return typeBinding2;
        }
        if (!typeBinding2.isCompatibleWith(typeBinding)) {
            if (blockScope.isBoxingCompatibleWith(typeBinding2, typeBinding)) {
                this.computeConversion(blockScope, typeBinding, typeBinding2);
            } else {
                blockScope.problemReporter().typeMismatchError(typeBinding2, typeBinding, this, null);
                return null;
            }
        }
        return typeBinding2;
    }

    public boolean forcedToBeRaw(ReferenceContext referenceContext) {
        if (this instanceof NameReference) {
            Binding binding = ((NameReference)this).binding;
            if (binding.isParameter() && (((LocalVariableBinding)binding).tagBits & 0x200L) != 0L) {
                return true;
            }
            if (binding instanceof FieldBinding) {
                FieldBinding fieldBinding = (FieldBinding)binding;
                if (fieldBinding.type.isRawType()) {
                    if (referenceContext instanceof AbstractMethodDeclaration) {
                        AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)referenceContext;
                        if (fieldBinding.declaringClass != abstractMethodDeclaration.binding.declaringClass) {
                            return true;
                        }
                    } else if (referenceContext instanceof TypeDeclaration) {
                        TypeDeclaration typeDeclaration = (TypeDeclaration)referenceContext;
                        if (fieldBinding.declaringClass != typeDeclaration.binding) {
                            return true;
                        }
                    }
                }
            }
        } else if (this instanceof MessageSend) {
            if (!CharOperation.equals(((MessageSend)this).binding.declaringClass.getFileName(), referenceContext.compilationResult().getFileName())) {
                return true;
            }
        } else if (this instanceof FieldReference) {
            FieldBinding fieldBinding = ((FieldReference)this).binding;
            if (!CharOperation.equals(fieldBinding.declaringClass.getFileName(), referenceContext.compilationResult().getFileName())) {
                return true;
            }
            if (fieldBinding.type.isRawType()) {
                if (referenceContext instanceof AbstractMethodDeclaration) {
                    AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)referenceContext;
                    if (fieldBinding.declaringClass != abstractMethodDeclaration.binding.declaringClass) {
                        return true;
                    }
                } else if (referenceContext instanceof TypeDeclaration) {
                    TypeDeclaration typeDeclaration = (TypeDeclaration)referenceContext;
                    if (fieldBinding.declaringClass != typeDeclaration.binding) {
                        return true;
                    }
                }
            }
        } else if (this instanceof ConditionalExpression) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)this;
            if (conditionalExpression.valueIfTrue.forcedToBeRaw(referenceContext) || conditionalExpression.valueIfFalse.forcedToBeRaw(referenceContext)) {
                return true;
            }
        }
        return false;
    }

    public Object reusableJSRTarget() {
        if (this.constant != Constant.NotAConstant) {
            return this.constant;
        }
        return null;
    }

    public void setExpectedType(TypeBinding typeBinding) {
    }

    public void tagAsNeedCheckCast() {
    }

    public void tagAsUnnecessaryCast(Scope scope, TypeBinding typeBinding) {
    }

    public Expression toTypeReference() {
        return this;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
    }
}

