/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class StringLiteral
extends Literal {
    char[] source;
    int lineNumber;

    public StringLiteral(char[] cArray, int n, int n2, int n3) {
        this(n, n2);
        this.source = cArray;
        this.lineNumber = n3 - 1;
    }

    public StringLiteral(int n, int n2) {
        super(n, n2);
    }

    public void computeConstant() {
        this.constant = StringConstant.fromValue(String.valueOf(this.source));
    }

    public ExtendedStringLiteral extendWith(CharLiteral charLiteral) {
        return new ExtendedStringLiteral(this, charLiteral);
    }

    public ExtendedStringLiteral extendWith(StringLiteral stringLiteral) {
        return new ExtendedStringLiteral(this, stringLiteral);
    }

    public StringLiteralConcatenation extendsWith(StringLiteral stringLiteral) {
        return new StringLiteralConcatenation(this, stringLiteral);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.ldc(this.constant.stringValue());
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope blockScope) {
        return blockScope.getJavaLangString();
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append('\"');
        block10: for (int i = 0; i < this.source.length; ++i) {
            switch (this.source[i]) {
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block10;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block10;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block10;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block10;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block10;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block10;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block10;
                }
                default: {
                    stringBuffer.append(this.source[i]);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer;
    }

    public char[] source() {
        return this.source;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

