/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;

public class AnnotationHolder {
    AnnotationBinding[] annotations;

    static AnnotationHolder storeAnnotations(AnnotationBinding[] annotationBindingArray, AnnotationBinding[][] annotationBindingArray2, Object object, LookupEnvironment lookupEnvironment) {
        if (annotationBindingArray2 != null) {
            boolean bl = true;
            int n = annotationBindingArray2.length;
            while (bl && --n >= 0) {
                if (annotationBindingArray2[n] == null || annotationBindingArray2[n].length <= 0) continue;
                bl = false;
            }
            if (bl) {
                annotationBindingArray2 = null;
            }
        }
        if (object != null) {
            return new AnnotationMethodHolder(annotationBindingArray, annotationBindingArray2, object, lookupEnvironment);
        }
        if (annotationBindingArray2 != null) {
            return new MethodHolder(annotationBindingArray, annotationBindingArray2);
        }
        return new AnnotationHolder().setAnnotations(annotationBindingArray);
    }

    AnnotationBinding[] getAnnotations() {
        return this.annotations;
    }

    Object getDefaultValue() {
        return null;
    }

    public AnnotationBinding[][] getParameterAnnotations() {
        return null;
    }

    AnnotationBinding[] getParameterAnnotations(int n) {
        return Binding.NO_ANNOTATIONS;
    }

    AnnotationHolder setAnnotations(AnnotationBinding[] annotationBindingArray) {
        if (annotationBindingArray == null || annotationBindingArray.length == 0) {
            return null;
        }
        this.annotations = annotationBindingArray;
        return this;
    }

    static class AnnotationMethodHolder
    extends MethodHolder {
        Object defaultValue;
        LookupEnvironment env;

        AnnotationMethodHolder(AnnotationBinding[] annotationBindingArray, AnnotationBinding[][] annotationBindingArray2, Object object, LookupEnvironment lookupEnvironment) {
            super(annotationBindingArray, annotationBindingArray2);
            this.defaultValue = object;
            this.env = lookupEnvironment;
        }

        Object getDefaultValue() {
            if (this.defaultValue instanceof UnresolvedReferenceBinding) {
                if (this.env == null) {
                    throw new IllegalStateException();
                }
                this.defaultValue = ((UnresolvedReferenceBinding)this.defaultValue).resolve(this.env, false);
            }
            return this.defaultValue;
        }
    }

    static class MethodHolder
    extends AnnotationHolder {
        AnnotationBinding[][] parameterAnnotations;

        MethodHolder(AnnotationBinding[] annotationBindingArray, AnnotationBinding[][] annotationBindingArray2) {
            this.setAnnotations(annotationBindingArray);
            this.parameterAnnotations = annotationBindingArray2;
        }

        public AnnotationBinding[][] getParameterAnnotations() {
            return this.parameterAnnotations;
        }

        AnnotationBinding[] getParameterAnnotations(int n) {
            AnnotationBinding[] annotationBindingArray = this.parameterAnnotations == null ? null : this.parameterAnnotations[n];
            return annotationBindingArray == null ? Binding.NO_ANNOTATIONS : annotationBindingArray;
        }

        AnnotationHolder setAnnotations(AnnotationBinding[] annotationBindingArray) {
            this.annotations = annotationBindingArray == null || annotationBindingArray.length == 0 ? Binding.NO_ANNOTATIONS : annotationBindingArray;
            return this;
        }
    }
}

