/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ClassSignature;
import org.eclipse.jdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedAnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;

public class BinaryTypeBinding
extends ReferenceBinding {
    protected ReferenceBinding superclass;
    protected ReferenceBinding enclosingType;
    protected ReferenceBinding[] superInterfaces;
    protected FieldBinding[] fields;
    protected MethodBinding[] methods;
    protected ReferenceBinding[] memberTypes;
    protected TypeVariableBinding[] typeVariables;
    protected LookupEnvironment environment;
    protected SimpleLookupTable storedAnnotations = null;

    static Object convertMemberValue(Object object, LookupEnvironment lookupEnvironment, char[][][] cArray) {
        if (object == null) {
            return null;
        }
        if (object instanceof Constant) {
            return object;
        }
        if (object instanceof ClassSignature) {
            return lookupEnvironment.getTypeFromSignature(((ClassSignature)object).getTypeName(), 0, -1, false, null, cArray);
        }
        if (object instanceof IBinaryAnnotation) {
            return BinaryTypeBinding.createAnnotation((IBinaryAnnotation)object, lookupEnvironment, cArray);
        }
        if (object instanceof EnumConstantSignature) {
            EnumConstantSignature enumConstantSignature = (EnumConstantSignature)object;
            ReferenceBinding referenceBinding = (ReferenceBinding)lookupEnvironment.getTypeFromSignature(enumConstantSignature.getTypeName(), 0, -1, false, null, cArray);
            referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, lookupEnvironment, false);
            return referenceBinding.getField(enumConstantSignature.getEnumConstantName(), false);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            if (n == 0) {
                return objectArray;
            }
            Object[] objectArray2 = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = BinaryTypeBinding.convertMemberValue(objectArray[i], lookupEnvironment, cArray);
            }
            return objectArray2;
        }
        throw new IllegalStateException();
    }

    static AnnotationBinding createAnnotation(IBinaryAnnotation iBinaryAnnotation, LookupEnvironment lookupEnvironment, char[][][] cArray) {
        IBinaryElementValuePair[] iBinaryElementValuePairArray = iBinaryAnnotation.getElementValuePairs();
        int n = iBinaryElementValuePairArray == null ? 0 : iBinaryElementValuePairArray.length;
        ElementValuePair[] elementValuePairArray = n == 0 ? Binding.NO_ELEMENT_VALUE_PAIRS : new ElementValuePair[n];
        for (int i = 0; i < n; ++i) {
            elementValuePairArray[i] = new ElementValuePair(iBinaryElementValuePairArray[i].getName(), BinaryTypeBinding.convertMemberValue(iBinaryElementValuePairArray[i].getValue(), lookupEnvironment, cArray), null);
        }
        char[] cArray2 = iBinaryAnnotation.getTypeName();
        ReferenceBinding referenceBinding = lookupEnvironment.getTypeFromConstantPoolName(cArray2, 1, cArray2.length - 1, false, cArray);
        return new UnresolvedAnnotationBinding(referenceBinding, elementValuePairArray, lookupEnvironment);
    }

    public static AnnotationBinding[] createAnnotations(IBinaryAnnotation[] iBinaryAnnotationArray, LookupEnvironment lookupEnvironment, char[][][] cArray) {
        int n = iBinaryAnnotationArray == null ? 0 : iBinaryAnnotationArray.length;
        AnnotationBinding[] annotationBindingArray = n == 0 ? Binding.NO_ANNOTATIONS : new AnnotationBinding[n];
        for (int i = 0; i < n; ++i) {
            annotationBindingArray[i] = BinaryTypeBinding.createAnnotation(iBinaryAnnotationArray[i], lookupEnvironment, cArray);
        }
        return annotationBindingArray;
    }

    public static TypeBinding resolveType(TypeBinding typeBinding, LookupEnvironment lookupEnvironment, boolean bl) {
        switch (typeBinding.kind()) {
            case 260: {
                ((ParameterizedTypeBinding)typeBinding).resolve();
                break;
            }
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).resolve();
            }
            case 68: {
                BinaryTypeBinding.resolveType(((ArrayBinding)typeBinding).leafComponentType, lookupEnvironment, bl);
                break;
            }
            case 4100: {
                ((TypeVariableBinding)typeBinding).resolve();
                break;
            }
            case 2052: {
                if (!bl) break;
                return lookupEnvironment.convertUnresolvedBinaryToRawType(typeBinding);
            }
            default: {
                if (typeBinding instanceof UnresolvedReferenceBinding) {
                    return ((UnresolvedReferenceBinding)typeBinding).resolve(lookupEnvironment, bl);
                }
                if (!bl) break;
                return lookupEnvironment.convertUnresolvedBinaryToRawType(typeBinding);
            }
        }
        return typeBinding;
    }

    protected BinaryTypeBinding() {
    }

    public BinaryTypeBinding(PackageBinding packageBinding, IBinaryType iBinaryType, LookupEnvironment lookupEnvironment) {
        this.compoundName = CharOperation.splitOn('/', iBinaryType.getName());
        this.computeId();
        this.tagBits |= 0x40L;
        this.environment = lookupEnvironment;
        this.fPackage = packageBinding;
        this.fileName = iBinaryType.getFileName();
        char[] cArray = iBinaryType.getGenericSignature();
        this.typeVariables = cArray != null && cArray.length > 0 && cArray[0] == '<' ? null : Binding.NO_TYPE_VARIABLES;
        this.sourceName = iBinaryType.getSourceName();
        this.modifiers = iBinaryType.getModifiers();
        if ((iBinaryType.getTagBits() & 0x20000L) != 0L) {
            this.tagBits |= 0x20000L;
        }
        if (iBinaryType.isAnonymous()) {
            this.tagBits |= 0x834L;
        } else if (iBinaryType.isLocal()) {
            this.tagBits |= 0x814L;
        } else if (iBinaryType.isMember()) {
            this.tagBits |= 0x80CL;
        }
        char[] cArray2 = iBinaryType.getEnclosingTypeName();
        if (cArray2 != null) {
            this.enclosingType = lookupEnvironment.getTypeFromConstantPoolName(cArray2, 0, -1, true, null);
            this.tagBits |= 0x80CL;
            this.tagBits |= 0x8000000L;
            if (this.enclosingType().isStrictfp()) {
                this.modifiers |= 0x800;
            }
            if (this.enclosingType().isDeprecated()) {
                this.modifiers |= 0x200000;
            }
        }
    }

    public FieldBinding[] availableFields() {
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.fields;
        }
        if ((this.tagBits & 0x1000L) == 0L) {
            int n = this.fields.length;
            if (n > 1) {
                ReferenceBinding.sortFields(this.fields, 0, n);
            }
            this.tagBits |= 0x1000L;
        }
        FieldBinding[] fieldBindingArray = new FieldBinding[this.fields.length];
        int n = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            try {
                fieldBindingArray[n] = this.resolveTypeFor(this.fields[i]);
                ++n;
                continue;
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
        }
        if (n < fieldBindingArray.length) {
            FieldBinding[] fieldBindingArray2 = fieldBindingArray;
            fieldBindingArray = new FieldBinding[n];
            System.arraycopy(fieldBindingArray2, 0, fieldBindingArray, 0, n);
        }
        return fieldBindingArray;
    }

    private TypeVariableBinding[] addMethodTypeVariables(TypeVariableBinding[] typeVariableBindingArray) {
        if (this.typeVariables == null || this.typeVariables == Binding.NO_TYPE_VARIABLES) {
            return typeVariableBindingArray;
        }
        if (typeVariableBindingArray == null || typeVariableBindingArray == Binding.NO_TYPE_VARIABLES) {
            return this.typeVariables;
        }
        int n = this.typeVariables.length + typeVariableBindingArray.length;
        TypeVariableBinding[] typeVariableBindingArray2 = new TypeVariableBinding[n];
        System.arraycopy(this.typeVariables, 0, typeVariableBindingArray2, 0, this.typeVariables.length);
        int n2 = this.typeVariables.length;
        int n3 = typeVariableBindingArray.length;
        block0: for (int i = 0; i < n3; ++i) {
            for (int j = this.typeVariables.length - 1; j >= 0; --j) {
                if (CharOperation.equals(typeVariableBindingArray[i].sourceName, this.typeVariables[j].sourceName)) continue block0;
            }
            typeVariableBindingArray2[n2++] = typeVariableBindingArray[i];
        }
        if (n2 != n) {
            TypeVariableBinding[] typeVariableBindingArray3 = typeVariableBindingArray2;
            typeVariableBindingArray2 = new TypeVariableBinding[n2];
            System.arraycopy(typeVariableBindingArray3, 0, typeVariableBindingArray2, 0, n2);
        }
        return typeVariableBindingArray2;
    }

    public MethodBinding[] availableMethods() {
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.methods;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        MethodBinding[] methodBindingArray = new MethodBinding[this.methods.length];
        int n = 0;
        for (int i = 0; i < this.methods.length; ++i) {
            try {
                methodBindingArray[n] = this.resolveTypesFor(this.methods[i]);
                ++n;
                continue;
            }
            catch (AbortCompilation abortCompilation) {
                // empty catch block
            }
        }
        if (n < methodBindingArray.length) {
            MethodBinding[] methodBindingArray2 = methodBindingArray;
            methodBindingArray = new MethodBinding[n];
            System.arraycopy(methodBindingArray2, 0, methodBindingArray, 0, n);
        }
        return methodBindingArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cachePartsFrom(IBinaryType iBinaryType, boolean bl) {
        try {
            int n;
            ArrayList<TypeBinding> arrayList;
            int n2;
            this.typeVariables = Binding.NO_TYPE_VARIABLES;
            this.superInterfaces = Binding.NO_SUPERINTERFACES;
            this.memberTypes = Binding.NO_MEMBER_TYPES;
            IBinaryNestedType[] iBinaryNestedTypeArray = iBinaryType.getMemberTypes();
            if (iBinaryNestedTypeArray != null && (n2 = iBinaryNestedTypeArray.length) > 0) {
                this.memberTypes = new ReferenceBinding[n2];
                for (int i = 0; i < n2; ++i) {
                    this.memberTypes[i] = this.environment.getTypeFromConstantPoolName(iBinaryNestedTypeArray[i].getName(), 0, -1, false, null);
                }
                this.tagBits |= 0x10000000L;
            }
            long l = this.environment.globalOptions.originalSourceLevel;
            char[] cArray = iBinaryType.getGenericSignature();
            this.tagBits |= iBinaryType.getTagBits();
            char[][][] cArray2 = iBinaryType.getMissingTypeNames();
            SignatureWrapper signatureWrapper = null;
            if (cArray != null) {
                signatureWrapper = new SignatureWrapper(cArray);
                if (signatureWrapper.signature[signatureWrapper.start] == '<') {
                    ++signatureWrapper.start;
                    this.typeVariables = this.createTypeVariables(signatureWrapper, true, cArray2);
                    ++signatureWrapper.start;
                    this.tagBits |= 0x1000000L;
                    this.modifiers |= 0x40000000;
                }
            }
            TypeVariableBinding[] typeVariableBindingArray = Binding.NO_TYPE_VARIABLES;
            char[] cArray3 = iBinaryType.getEnclosingMethod();
            if (cArray3 != null && (arrayList = this.findMethod(cArray3, cArray2)) != null) {
                typeVariableBindingArray = ((MethodBinding)((Object)arrayList)).typeVariables;
                this.typeVariables = this.addMethodTypeVariables(typeVariableBindingArray);
            }
            if (cArray == null) {
                arrayList = (ArrayList<TypeBinding>)iBinaryType.getSuperclassName();
                if (arrayList != null) {
                    this.superclass = this.environment.getTypeFromConstantPoolName((char[])arrayList, 0, -1, false, cArray2);
                    this.tagBits |= 0x2000000L;
                }
                this.superInterfaces = Binding.NO_SUPERINTERFACES;
                char[][] cArray4 = iBinaryType.getInterfaceNames();
                if (cArray4 != null && (n = cArray4.length) > 0) {
                    this.superInterfaces = new ReferenceBinding[n];
                    for (int i = 0; i < n; ++i) {
                        this.superInterfaces[i] = this.environment.getTypeFromConstantPoolName(cArray4[i], 0, -1, false, cArray2);
                    }
                    this.tagBits |= 0x4000000L;
                }
            } else {
                this.superclass = (ReferenceBinding)this.environment.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, this, cArray2);
                this.tagBits |= 0x2000000L;
                this.superInterfaces = Binding.NO_SUPERINTERFACES;
                if (!signatureWrapper.atEnd()) {
                    arrayList = new ArrayList<TypeBinding>(2);
                    do {
                        arrayList.add(this.environment.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, this, cArray2));
                    } while (!signatureWrapper.atEnd());
                    this.superInterfaces = new ReferenceBinding[arrayList.size()];
                    arrayList.toArray(this.superInterfaces);
                    this.tagBits |= 0x4000000L;
                }
            }
            if (bl) {
                this.createFields(iBinaryType.getFields(), l, cArray2);
                this.createMethods(iBinaryType.getMethods(), l, cArray2);
                boolean bl2 = this.isViewedAsDeprecated();
                if (bl2) {
                    int n3;
                    n = this.fields.length;
                    for (n3 = 0; n3 < n; ++n3) {
                        FieldBinding fieldBinding = this.fields[n3];
                        if (fieldBinding.isDeprecated()) continue;
                        fieldBinding.modifiers |= 0x200000;
                    }
                    n = this.methods.length;
                    for (n3 = 0; n3 < n; ++n3) {
                        MethodBinding methodBinding = this.methods[n3];
                        if (methodBinding.isDeprecated()) continue;
                        methodBinding.modifiers |= 0x200000;
                    }
                }
            }
            if (this.environment.globalOptions.storeAnnotations) {
                this.setAnnotations(BinaryTypeBinding.createAnnotations(iBinaryType.getAnnotations(), this.environment, cArray2));
            }
            Object var16_20 = null;
            if (this.fields == null) {
                this.fields = Binding.NO_FIELDS;
            }
            if (this.methods == null) {
                this.methods = Binding.NO_METHODS;
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            if (this.fields == null) {
                this.fields = Binding.NO_FIELDS;
            }
            if (this.methods == null) {
                this.methods = Binding.NO_METHODS;
            }
            throw throwable;
        }
    }

    private void createFields(IBinaryField[] iBinaryFieldArray, long l, char[][][] cArray) {
        int n;
        this.fields = Binding.NO_FIELDS;
        if (iBinaryFieldArray != null && (n = iBinaryFieldArray.length) > 0) {
            IBinaryField iBinaryField;
            int n2;
            this.fields = new FieldBinding[n];
            boolean bl = l >= 0x310000L;
            boolean bl2 = this.hasRestrictedAccess();
            int n3 = -1;
            for (n2 = 0; n2 < n; ++n2) {
                iBinaryField = iBinaryFieldArray[n2];
                char[] cArray2 = bl ? iBinaryField.getGenericSignature() : null;
                TypeBinding typeBinding = cArray2 == null ? this.environment.getTypeFromSignature(iBinaryField.getTypeName(), 0, -1, false, this, cArray) : this.environment.getTypeFromTypeSignature(new SignatureWrapper(cArray2), Binding.NO_TYPE_VARIABLES, this, cArray);
                FieldBinding fieldBinding = new FieldBinding(iBinaryField.getName(), typeBinding, iBinaryField.getModifiers() | 0x2000000, this, iBinaryField.getConstant());
                if (n3 < 0 && this.environment.globalOptions.storeAnnotations && iBinaryField.getAnnotations() != null) {
                    n3 = n2;
                }
                fieldBinding.id = n2;
                if (bl) {
                    fieldBinding.tagBits |= iBinaryField.getTagBits();
                }
                if (bl2) {
                    fieldBinding.modifiers |= 0x40000;
                }
                if (cArray2 != null) {
                    fieldBinding.modifiers |= 0x40000000;
                }
                this.fields[n2] = fieldBinding;
            }
            if (n3 >= 0) {
                for (n2 = n3; n2 < n; ++n2) {
                    iBinaryField = iBinaryFieldArray[n2];
                    this.fields[n2].setAnnotations(BinaryTypeBinding.createAnnotations(iBinaryField.getAnnotations(), this.environment, cArray));
                }
            }
        }
    }

    private MethodBinding createMethod(IBinaryMethod iBinaryMethod, long l, char[][][] cArray) {
        Object object;
        Object object2;
        int n;
        Object object3;
        int n2 = iBinaryMethod.getModifiers() | 0x2000000;
        if (l < 0x310000L) {
            n2 &= 0xFFFFFF7F;
        }
        ReferenceBinding[] referenceBindingArray = Binding.NO_EXCEPTIONS;
        TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
        TypeVariableBinding[] typeVariableBindingArray = Binding.NO_TYPE_VARIABLES;
        AnnotationBinding[][] annotationBindingArray = null;
        TypeBinding typeBinding = null;
        boolean bl = l >= 0x310000L;
        char[] cArray2 = iBinaryMethod.getGenericSignature();
        if (cArray2 == null) {
            char[][] cArray3;
            int n3;
            int n4;
            object3 = iBinaryMethod.getMethodDescriptor();
            n = 0;
            object2 = 0;
            while ((object = object3[++object2]) != 41) {
                if (object == 91) continue;
                ++n;
                if (object != 76) continue;
                while ((object = object3[++object2]) != 59) {
                }
            }
            int n5 = 0;
            if (iBinaryMethod.isConstructor()) {
                if (this.isMemberType() && !this.isStatic()) {
                    ++n5;
                }
                if (this.isEnum()) {
                    n5 += 2;
                }
            }
            if ((n4 = n - n5) > 0) {
                typeBindingArray = new TypeBinding[n4];
                if (this.environment.globalOptions.storeAnnotations) {
                    annotationBindingArray = new AnnotationBinding[n4][];
                }
                object2 = 1;
                int n6 = 0;
                for (n3 = 0; n3 < n; ++n3) {
                    Object object4;
                    do {
                        object4 = object3[++n6];
                        object = object4;
                    } while (object4 == 91);
                    if (object == 76) {
                        Object object5;
                        do {
                            object5 = object3[++n6];
                            object = object5;
                        } while (object5 != 59);
                    }
                    if (n3 >= n5) {
                        typeBindingArray[n3 - n5] = this.environment.getTypeFromSignature((char[])object3, (int)object2, n6, false, this, cArray);
                        if (annotationBindingArray != null) {
                            annotationBindingArray[n3 - n5] = BinaryTypeBinding.createAnnotations(iBinaryMethod.getParameterAnnotations(n3 - n5), this.environment, cArray);
                        }
                    }
                    object2 = n6 + 1;
                }
            }
            if ((cArray3 = iBinaryMethod.getExceptionTypeNames()) != null && (n4 = cArray3.length) > 0) {
                referenceBindingArray = new ReferenceBinding[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    referenceBindingArray[n3] = this.environment.getTypeFromConstantPoolName(cArray3[n3], 0, -1, false, cArray);
                }
            }
            if (!iBinaryMethod.isConstructor()) {
                typeBinding = this.environment.getTypeFromSignature((char[])object3, object2 + 1, -1, false, this, cArray);
            }
        } else {
            Object object6;
            n2 |= 0x40000000;
            object3 = new SignatureWrapper(cArray2, bl);
            if (((SignatureWrapper)object3).signature[((SignatureWrapper)object3).start] == '<') {
                ++((SignatureWrapper)object3).start;
                typeVariableBindingArray = this.createTypeVariables((SignatureWrapper)object3, false, cArray);
                ++((SignatureWrapper)object3).start;
            }
            if (((SignatureWrapper)object3).signature[((SignatureWrapper)object3).start] == '(') {
                ++((SignatureWrapper)object3).start;
                if (((SignatureWrapper)object3).signature[((SignatureWrapper)object3).start] == ')') {
                    ++((SignatureWrapper)object3).start;
                } else {
                    object6 = new ArrayList(2);
                    while (((SignatureWrapper)object3).signature[((SignatureWrapper)object3).start] != ')') {
                        object6.add(this.environment.getTypeFromTypeSignature((SignatureWrapper)object3, typeVariableBindingArray, this, cArray));
                    }
                    ++((SignatureWrapper)object3).start;
                    object = object6.size();
                    typeBindingArray = new TypeBinding[object];
                    object6.toArray(typeBindingArray);
                    if (this.environment.globalOptions.storeAnnotations) {
                        annotationBindingArray = new AnnotationBinding[object][];
                        for (object2 = 0; object2 < object; ++object2) {
                            annotationBindingArray[object2] = BinaryTypeBinding.createAnnotations(iBinaryMethod.getParameterAnnotations((int)object2), this.environment, cArray);
                        }
                    }
                }
            }
            typeBinding = this.environment.getTypeFromTypeSignature((SignatureWrapper)object3, typeVariableBindingArray, this, cArray);
            if (!((SignatureWrapper)object3).atEnd() && ((SignatureWrapper)object3).signature[((SignatureWrapper)object3).start] == '^') {
                object6 = new ArrayList(2);
                do {
                    ++((SignatureWrapper)object3).start;
                    object6.add(this.environment.getTypeFromTypeSignature((SignatureWrapper)object3, typeVariableBindingArray, this, cArray));
                } while (!((SignatureWrapper)object3).atEnd() && ((SignatureWrapper)object3).signature[((SignatureWrapper)object3).start] == '^');
                referenceBindingArray = new ReferenceBinding[object6.size()];
                object6.toArray(referenceBindingArray);
            } else {
                object6 = iBinaryMethod.getExceptionTypeNames();
                if (object6 != null && (object = ((char[][])object6).length) > 0) {
                    referenceBindingArray = new ReferenceBinding[object];
                    for (object2 = 0; object2 < object; ++object2) {
                        referenceBindingArray[object2] = this.environment.getTypeFromConstantPoolName((char[])object6[object2], 0, -1, false, cArray);
                    }
                }
            }
        }
        Object object7 = object3 = iBinaryMethod.isConstructor() ? new MethodBinding(n2, typeBindingArray, referenceBindingArray, this) : new MethodBinding(n2, iBinaryMethod.getSelector(), typeBinding, typeBindingArray, referenceBindingArray, this);
        if (this.environment.globalOptions.storeAnnotations) {
            ((MethodBinding)object3).setAnnotations(BinaryTypeBinding.createAnnotations(iBinaryMethod.getAnnotations(), this.environment, cArray), annotationBindingArray, this.isAnnotationType() ? BinaryTypeBinding.convertMemberValue(iBinaryMethod.getDefaultValue(), this.environment, cArray) : null, this.environment);
        }
        if (bl) {
            ((MethodBinding)object3).tagBits |= iBinaryMethod.getTagBits();
        }
        ((MethodBinding)object3).typeVariables = typeVariableBindingArray;
        object = typeVariableBindingArray.length;
        for (n = 0; n < object; ++n) {
            typeVariableBindingArray[n].declaringElement = object3;
        }
        return object3;
    }

    private void createMethods(IBinaryMethod[] iBinaryMethodArray, long l, char[][][] cArray) {
        Object object;
        Object object2;
        int n;
        boolean bl;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int[] nArray = null;
        if (iBinaryMethodArray != null) {
            n2 = n3 = iBinaryMethodArray.length;
            bl = l < 0x310000L;
            n = n2;
            while (--n >= 0) {
                object2 = iBinaryMethodArray[n];
                if ((object2.getModifiers() & 0x1000) != 0) {
                    if (bl && (object2.getModifiers() & 0x40) != 0) continue;
                    if (nArray == null) {
                        nArray = new int[iBinaryMethodArray.length];
                    }
                    nArray[n] = -1;
                    --n2;
                    continue;
                }
                if (n4 != -1 || ((char[])(object = object2.getSelector())).length != 8 || object[0] != '<') continue;
                n4 = n;
                --n2;
            }
        }
        if (n2 == 0) {
            this.methods = Binding.NO_METHODS;
            return;
        }
        bl = this.hasRestrictedAccess();
        this.methods = new MethodBinding[n2];
        if (n2 == n3) {
            for (n = 0; n < n3; ++n) {
                object2 = this.createMethod(iBinaryMethodArray[n], l, cArray);
                if (bl) {
                    ((MethodBinding)object2).modifiers |= 0x40000;
                }
                this.methods[n] = object2;
            }
        } else {
            int n5 = 0;
            for (n = 0; n < n3; ++n) {
                if (n4 == n || nArray != null && nArray[n] == -1) continue;
                object = this.createMethod(iBinaryMethodArray[n], l, cArray);
                if (bl) {
                    object.modifiers |= 0x40000;
                }
                this.methods[n5++] = object;
            }
        }
    }

    private TypeVariableBinding[] createTypeVariables(SignatureWrapper signatureWrapper, boolean bl, char[][][] cArray) {
        int n;
        char[] cArray2 = signatureWrapper.signature;
        int n2 = 0;
        int n3 = cArray2.length;
        int n4 = 0;
        ArrayList<TypeVariableBinding> arrayList = new ArrayList<TypeVariableBinding>(1);
        n2 = 0;
        boolean bl2 = true;
        block5: for (int i = 1; i < n3; ++i) {
            switch (cArray2[i]) {
                case '<': {
                    ++n2;
                    continue block5;
                }
                case '>': {
                    if (--n2 >= 0) continue block5;
                    break block5;
                }
                case ';': {
                    if (n2 != 0 || i + 1 >= n3 || cArray2[i + 1] == ':') continue block5;
                    bl2 = true;
                    continue block5;
                }
                default: {
                    if (!bl2) continue block5;
                    bl2 = false;
                    n = CharOperation.indexOf(':', cArray2, i);
                    char[] cArray3 = CharOperation.subarray(cArray2, i, n);
                    arrayList.add(new TypeVariableBinding(cArray3, this, n4++, this.environment));
                }
            }
        }
        TypeVariableBinding[] typeVariableBindingArray = new TypeVariableBinding[n4];
        arrayList.toArray(typeVariableBindingArray);
        if (bl) {
            this.typeVariables = typeVariableBindingArray;
        }
        for (n = 0; n < n4; ++n) {
            this.initializeTypeVariable(typeVariableBindingArray[n], typeVariableBindingArray, signatureWrapper, cArray);
        }
        return typeVariableBindingArray;
    }

    public ReferenceBinding enclosingType() {
        if ((this.tagBits & 0x8000000L) == 0L) {
            return this.enclosingType;
        }
        this.enclosingType = (ReferenceBinding)BinaryTypeBinding.resolveType(this.enclosingType, this.environment, false);
        this.tagBits &= 0xFFFFFFFFF7FFFFFFL;
        return this.enclosingType;
    }

    public FieldBinding[] fields() {
        int n;
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.fields;
        }
        if ((this.tagBits & 0x1000L) == 0L) {
            n = this.fields.length;
            if (n > 1) {
                ReferenceBinding.sortFields(this.fields, 0, n);
            }
            this.tagBits |= 0x1000L;
        }
        n = this.fields.length;
        while (--n >= 0) {
            this.resolveTypeFor(this.fields[n]);
        }
        this.tagBits |= 0x2000L;
        return this.fields;
    }

    private MethodBinding findMethod(char[] cArray, char[][][] cArray2) {
        int n;
        char c;
        int n2 = -1;
        while (cArray[++n2] != '(') {
        }
        char[] cArray3 = new char[n2];
        System.arraycopy(cArray, 0, cArray3, 0, n2);
        TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
        int n3 = 0;
        int n4 = n2;
        while ((c = cArray[++n2]) != ')') {
            if (c == '[') continue;
            ++n3;
            if (c != 'L') continue;
            while ((c = cArray[++n2]) != ';') {
            }
        }
        if (n3 > 0) {
            typeBindingArray = new TypeBinding[n3];
            n2 = n4 + 1;
            n = n4;
            for (int i = 0; i < n3; ++i) {
                TypeBinding typeBinding;
                while ((c = cArray[++n]) == '[') {
                }
                if (c == 'L') {
                    while ((c = cArray[++n]) != ';') {
                    }
                }
                if ((typeBinding = this.environment.getTypeFromSignature(cArray, n2, n, false, this, cArray2)) instanceof UnresolvedReferenceBinding) {
                    typeBinding = BinaryTypeBinding.resolveType(typeBinding, this.environment, true);
                }
                typeBindingArray[i] = typeBinding;
                n2 = n + 1;
            }
        }
        n = typeBindingArray.length;
        MethodBinding[] methodBindingArray = this.enclosingType.getMethods(cArray3, n);
        int n5 = methodBindingArray.length;
        block6: for (int i = 0; i < n5; ++i) {
            MethodBinding methodBinding = methodBindingArray[i];
            TypeBinding[] typeBindingArray2 = methodBinding.parameters;
            int n6 = typeBindingArray2.length;
            if (n != n6) continue;
            for (int j = 0; j < n6; ++j) {
                if (typeBindingArray[j] != typeBindingArray2[j] && typeBindingArray[j].erasure() != typeBindingArray2[j].erasure()) continue block6;
            }
            return methodBinding;
        }
        return null;
    }

    public char[] genericTypeSignature() {
        return this.computeGenericTypeSignature(this.typeVariables);
    }

    public MethodBinding getExactConstructor(TypeBinding[] typeBindingArray) {
        int n;
        if ((this.tagBits & 0x4000L) == 0L) {
            n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        n = typeBindingArray.length;
        long l = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods);
        if (l >= 0L) {
            int n2 = (int)(l >> 32);
            block0: for (int i = (int)l; i <= n2; ++i) {
                MethodBinding methodBinding = this.methods[i];
                if (methodBinding.parameters.length != n) continue;
                this.resolveTypesFor(methodBinding);
                TypeBinding[] typeBindingArray2 = methodBinding.parameters;
                for (int j = 0; j < n; ++j) {
                    if (typeBindingArray2[j] != typeBindingArray[j]) continue block0;
                }
                return methodBinding;
            }
        }
        return null;
    }

    public MethodBinding getExactMethod(char[] cArray, TypeBinding[] typeBindingArray, CompilationUnitScope compilationUnitScope) {
        int n;
        if ((this.tagBits & 0x4000L) == 0L) {
            n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        n = typeBindingArray.length;
        boolean bl = true;
        long l = ReferenceBinding.binarySearch(cArray, this.methods);
        if (l >= 0L) {
            int n2 = (int)(l >> 32);
            block0: for (int i = (int)l; i <= n2; ++i) {
                MethodBinding methodBinding = this.methods[i];
                bl = false;
                if (methodBinding.parameters.length != n) continue;
                this.resolveTypesFor(methodBinding);
                TypeBinding[] typeBindingArray2 = methodBinding.parameters;
                for (int j = 0; j < n; ++j) {
                    if (typeBindingArray2[j] != typeBindingArray[j]) continue block0;
                }
                return methodBinding;
            }
        }
        if (bl) {
            if (this.isInterface()) {
                if (this.superInterfaces().length == 1) {
                    if (compilationUnitScope != null) {
                        compilationUnitScope.recordTypeReference(this.superInterfaces[0]);
                    }
                    return this.superInterfaces[0].getExactMethod(cArray, typeBindingArray, compilationUnitScope);
                }
            } else if (this.superclass() != null) {
                if (compilationUnitScope != null) {
                    compilationUnitScope.recordTypeReference(this.superclass);
                }
                return this.superclass.getExactMethod(cArray, typeBindingArray, compilationUnitScope);
            }
        }
        return null;
    }

    public FieldBinding getField(char[] cArray, boolean bl) {
        if ((this.tagBits & 0x1000L) == 0L) {
            int n = this.fields.length;
            if (n > 1) {
                ReferenceBinding.sortFields(this.fields, 0, n);
            }
            this.tagBits |= 0x1000L;
        }
        FieldBinding fieldBinding = ReferenceBinding.binarySearch(cArray, this.fields);
        return bl && fieldBinding != null ? this.resolveTypeFor(fieldBinding) : fieldBinding;
    }

    public ReferenceBinding getMemberType(char[] cArray) {
        int n = this.memberTypes.length;
        while (--n >= 0) {
            ReferenceBinding referenceBinding = this.memberTypes[n];
            if (referenceBinding instanceof UnresolvedReferenceBinding) {
                char[] cArray2 = referenceBinding.sourceName;
                int n2 = this.compoundName[this.compoundName.length - 1].length + 1;
                if (cArray2.length != n2 + cArray.length || !CharOperation.fragmentEquals(cArray, cArray2, n2, true)) continue;
                this.memberTypes[n] = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, this.environment, false);
                return this.memberTypes[n];
            }
            if (!CharOperation.equals(cArray, referenceBinding.sourceName)) continue;
            return referenceBinding;
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] cArray) {
        long l;
        if ((this.tagBits & 0x8000L) != 0L) {
            long l2 = ReferenceBinding.binarySearch(cArray, this.methods);
            if (l2 >= 0L) {
                int n = (int)l2;
                int n2 = (int)(l2 >> 32);
                int n3 = n2 - n + 1;
                if ((this.tagBits & 0x8000L) != 0L) {
                    MethodBinding[] methodBindingArray = new MethodBinding[n3];
                    System.arraycopy(this.methods, n, methodBindingArray, 0, n3);
                    return methodBindingArray;
                }
            }
            return Binding.NO_METHODS;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        if ((l = ReferenceBinding.binarySearch(cArray, this.methods)) >= 0L) {
            int n = (int)l;
            int n4 = (int)(l >> 32);
            int n5 = n4 - n + 1;
            MethodBinding[] methodBindingArray = new MethodBinding[n5];
            int n6 = n;
            int n7 = 0;
            while (n6 <= n4) {
                methodBindingArray[n7] = this.resolveTypesFor(this.methods[n6]);
                ++n6;
                ++n7;
            }
            return methodBindingArray;
        }
        return Binding.NO_METHODS;
    }

    public MethodBinding[] getMethods(char[] cArray, int n) {
        long l;
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.getMethods(cArray);
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int n2 = this.methods.length;
            if (n2 > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n2);
            }
            this.tagBits |= 0x4000L;
        }
        if ((l = ReferenceBinding.binarySearch(cArray, this.methods)) >= 0L) {
            int n3;
            int n4 = (int)l;
            int n5 = (int)(l >> 32);
            int n6 = n5 - n4 + 1;
            int n7 = 0;
            for (int i = n4; i <= n5; ++i) {
                n3 = this.methods[i].parameters.length;
                if (n3 > n && (!this.methods[i].isVarargs() || n3 != n + 1)) continue;
                ++n7;
            }
            if (n7 == 0) {
                MethodBinding[] methodBindingArray = new MethodBinding[n6];
                int n8 = 0;
                for (n3 = n4; n3 <= n5; ++n3) {
                    methodBindingArray[n8++] = this.resolveTypesFor(this.methods[n3]);
                }
                return methodBindingArray;
            }
            MethodBinding[] methodBindingArray = new MethodBinding[n7];
            int n9 = 0;
            for (n3 = n4; n3 <= n5; ++n3) {
                int n10 = this.methods[n3].parameters.length;
                if (n10 > n && (!this.methods[n3].isVarargs() || n10 != n + 1)) continue;
                methodBindingArray[n9++] = this.resolveTypesFor(this.methods[n3]);
            }
            return methodBindingArray;
        }
        return Binding.NO_METHODS;
    }

    public boolean hasMemberTypes() {
        return this.memberTypes.length > 0;
    }

    public TypeVariableBinding getTypeVariable(char[] cArray) {
        TypeVariableBinding typeVariableBinding = super.getTypeVariable(cArray);
        typeVariableBinding.resolve();
        return typeVariableBinding;
    }

    private void initializeTypeVariable(TypeVariableBinding typeVariableBinding, TypeVariableBinding[] typeVariableBindingArray, SignatureWrapper signatureWrapper, char[][][] cArray) {
        ReferenceBinding[] referenceBindingArray;
        ReferenceBinding referenceBinding;
        int n = CharOperation.indexOf(':', signatureWrapper.signature, signatureWrapper.start);
        signatureWrapper.start = n + 1;
        ReferenceBinding referenceBinding2 = null;
        if (signatureWrapper.signature[signatureWrapper.start] == ':') {
            referenceBinding = this.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
        } else {
            referenceBindingArray = this.environment.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, this, cArray);
            referenceBinding = referenceBindingArray instanceof ReferenceBinding ? (ReferenceBinding)referenceBindingArray : this.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
            referenceBinding2 = referenceBinding;
        }
        typeVariableBinding.modifiers |= 0x2000000;
        typeVariableBinding.superclass = referenceBinding;
        referenceBindingArray = null;
        if (signatureWrapper.signature[signatureWrapper.start] == ':') {
            ArrayList<TypeBinding> arrayList = new ArrayList<TypeBinding>(2);
            do {
                ++signatureWrapper.start;
                arrayList.add(this.environment.getTypeFromTypeSignature(signatureWrapper, typeVariableBindingArray, this, cArray));
            } while (signatureWrapper.signature[signatureWrapper.start] == ':');
            referenceBindingArray = new ReferenceBinding[arrayList.size()];
            arrayList.toArray(referenceBindingArray);
        }
        ReferenceBinding[] referenceBindingArray2 = typeVariableBinding.superInterfaces = referenceBindingArray == null ? Binding.NO_SUPERINTERFACES : referenceBindingArray;
        if (referenceBinding2 == null) {
            referenceBinding2 = typeVariableBinding.superInterfaces.length == 0 ? null : typeVariableBinding.superInterfaces[0];
        }
        typeVariableBinding.firstBound = referenceBinding2;
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 260: 
            case 1028: {
                return typeBinding.erasure() == this;
            }
        }
        return false;
    }

    public boolean isGenericType() {
        return this.typeVariables != Binding.NO_TYPE_VARIABLES;
    }

    public boolean isHierarchyConnected() {
        return (this.tagBits & 0x6000000L) == 0L;
    }

    public int kind() {
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            return 2052;
        }
        return 4;
    }

    public ReferenceBinding[] memberTypes() {
        if ((this.tagBits & 0x10000000L) == 0L) {
            return this.memberTypes;
        }
        int n = this.memberTypes.length;
        while (--n >= 0) {
            this.memberTypes[n] = (ReferenceBinding)BinaryTypeBinding.resolveType(this.memberTypes[n], this.environment, false);
        }
        this.tagBits &= 0xFFFFFFFFEFFFFFFFL;
        return this.memberTypes;
    }

    public MethodBinding[] methods() {
        int n;
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.methods;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            n = this.methods.length;
            if (n > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, n);
            }
            this.tagBits |= 0x4000L;
        }
        n = this.methods.length;
        while (--n >= 0) {
            this.resolveTypesFor(this.methods[n]);
        }
        this.tagBits |= 0x8000L;
        return this.methods;
    }

    private FieldBinding resolveTypeFor(FieldBinding fieldBinding) {
        TypeBinding typeBinding;
        if ((fieldBinding.modifiers & 0x2000000) == 0) {
            return fieldBinding;
        }
        fieldBinding.type = typeBinding = BinaryTypeBinding.resolveType(fieldBinding.type, this.environment, true);
        if ((typeBinding.tagBits & 0x80L) != 0L) {
            fieldBinding.tagBits |= 0x80L;
        }
        fieldBinding.modifiers &= 0xFDFFFFFF;
        return fieldBinding;
    }

    MethodBinding resolveTypesFor(MethodBinding methodBinding) {
        TypeBinding typeBinding;
        if ((methodBinding.modifiers & 0x2000000) == 0) {
            return methodBinding;
        }
        if (!methodBinding.isConstructor()) {
            TypeBinding typeBinding2;
            methodBinding.returnType = typeBinding2 = BinaryTypeBinding.resolveType(methodBinding.returnType, this.environment, true);
            if ((typeBinding2.tagBits & 0x80L) != 0L) {
                methodBinding.tagBits |= 0x80L;
            }
        }
        int n = methodBinding.parameters.length;
        while (--n >= 0) {
            methodBinding.parameters[n] = typeBinding = BinaryTypeBinding.resolveType(methodBinding.parameters[n], this.environment, true);
            if ((typeBinding.tagBits & 0x80L) == 0L) continue;
            methodBinding.tagBits |= 0x80L;
        }
        n = methodBinding.thrownExceptions.length;
        while (--n >= 0) {
            typeBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(methodBinding.thrownExceptions[n], this.environment, true);
            methodBinding.thrownExceptions[n] = typeBinding;
            if ((((ReferenceBinding)typeBinding).tagBits & 0x80L) == 0L) continue;
            methodBinding.tagBits |= 0x80L;
        }
        n = methodBinding.typeVariables.length;
        while (--n >= 0) {
            methodBinding.typeVariables[n].resolve();
        }
        methodBinding.modifiers &= 0xFDFFFFFF;
        return methodBinding;
    }

    AnnotationBinding[] retrieveAnnotations(Binding binding) {
        return AnnotationBinding.addStandardAnnotations(super.retrieveAnnotations(binding), binding.getAnnotationTagBits(), this.environment);
    }

    SimpleLookupTable storedAnnotations(boolean bl) {
        if (bl && this.storedAnnotations == null) {
            if (!this.environment.globalOptions.storeAnnotations) {
                return null;
            }
            this.storedAnnotations = new SimpleLookupTable(3);
        }
        return this.storedAnnotations;
    }

    public ReferenceBinding superclass() {
        if ((this.tagBits & 0x2000000L) == 0L) {
            return this.superclass;
        }
        this.superclass = (ReferenceBinding)BinaryTypeBinding.resolveType(this.superclass, this.environment, true);
        this.tagBits &= 0xFFFFFFFFFDFFFFFFL;
        if (this.superclass.problemId() == 1) {
            this.tagBits |= 0x20000L;
        }
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        if ((this.tagBits & 0x4000000L) == 0L) {
            return this.superInterfaces;
        }
        int n = this.superInterfaces.length;
        while (--n >= 0) {
            this.superInterfaces[n] = (ReferenceBinding)BinaryTypeBinding.resolveType(this.superInterfaces[n], this.environment, true);
            if (this.superInterfaces[n].problemId() != 1) continue;
            this.tagBits |= 0x20000L;
        }
        this.tagBits &= 0xFFFFFFFFFBFFFFFFL;
        return this.superInterfaces;
    }

    public TypeVariableBinding[] typeVariables() {
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this.typeVariables;
        }
        int n = this.typeVariables.length;
        while (--n >= 0) {
            this.typeVariables[n].resolve();
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        return this.typeVariables;
    }

    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDeprecated()) {
            stringBuffer.append("deprecated ");
        }
        if (this.isPublic()) {
            stringBuffer.append("public ");
        }
        if (this.isProtected()) {
            stringBuffer.append("protected ");
        }
        if (this.isPrivate()) {
            stringBuffer.append("private ");
        }
        if (this.isAbstract() && this.isClass()) {
            stringBuffer.append("abstract ");
        }
        if (this.isStatic() && this.isNestedType()) {
            stringBuffer.append("static ");
        }
        if (this.isFinal()) {
            stringBuffer.append("final ");
        }
        if (this.isEnum()) {
            stringBuffer.append("enum ");
        } else if (this.isAnnotationType()) {
            stringBuffer.append("@interface ");
        } else if (this.isClass()) {
            stringBuffer.append("class ");
        } else {
            stringBuffer.append("interface ");
        }
        stringBuffer.append(this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        if (this.typeVariables == null) {
            stringBuffer.append("<NULL TYPE VARIABLES>");
        } else if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            stringBuffer.append("<");
            n2 = this.typeVariables.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                if (this.typeVariables[n] == null) {
                    stringBuffer.append("NULL TYPE VARIABLE");
                    continue;
                }
                char[] cArray = this.typeVariables[n].toString().toCharArray();
                stringBuffer.append(cArray, 1, cArray.length - 2);
            }
            stringBuffer.append(">");
        }
        stringBuffer.append("\n\textends ");
        stringBuffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.superInterfaces != null) {
            if (this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                stringBuffer.append("\n\timplements : ");
                n2 = this.superInterfaces.length;
                for (n = 0; n < n2; ++n) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.superInterfaces[n] != null ? this.superInterfaces[n].debugName() : "NULL TYPE");
                }
            }
        } else {
            stringBuffer.append("NULL SUPERINTERFACES");
        }
        if (this.enclosingType != null) {
            stringBuffer.append("\n\tenclosing type : ");
            stringBuffer.append(this.enclosingType.debugName());
        }
        if (this.fields != null) {
            if (this.fields != Binding.NO_FIELDS) {
                stringBuffer.append("\n/*   fields   */");
                n2 = this.fields.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(this.fields[n] != null ? "\n" + this.fields[n].toString() : "\nNULL FIELD");
                }
            }
        } else {
            stringBuffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            if (this.methods != Binding.NO_METHODS) {
                stringBuffer.append("\n/*   methods   */");
                n2 = this.methods.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(this.methods[n] != null ? "\n" + this.methods[n].toString() : "\nNULL METHOD");
                }
            }
        } else {
            stringBuffer.append("NULL METHODS");
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != Binding.NO_MEMBER_TYPES) {
                stringBuffer.append("\n/*   members   */");
                n2 = this.memberTypes.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(this.memberTypes[n] != null ? "\n" + this.memberTypes[n].toString() : "\nNULL TYPE");
                }
            }
        } else {
            stringBuffer.append("NULL MEMBER TYPES");
        }
        stringBuffer.append("\n\n\n");
        return stringBuffer.toString();
    }

    MethodBinding[] unResolvedMethods() {
        return this.methods;
    }

    public FieldBinding[] unResolvedFields() {
        return this.fields;
    }
}

