/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.InnerEmulationDependency;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public final class LocalTypeBinding
extends NestedTypeBinding {
    static final char[] LocalTypePrefix = new char[]{'$', 'L', 'o', 'c', 'a', 'l', '$'};
    private InnerEmulationDependency[] dependents;
    public ArrayBinding[] localArrayBindings;
    public CaseStatement enclosingCase;
    public int sourceStart;
    public MethodBinding enclosingMethod;

    public LocalTypeBinding(ClassScope classScope, SourceTypeBinding sourceTypeBinding, CaseStatement caseStatement) {
        super((char[][])new char[][]{CharOperation.concat(LocalTypePrefix, classScope.referenceContext.name)}, classScope, sourceTypeBinding);
        TypeDeclaration typeDeclaration = classScope.referenceContext;
        this.tagBits = (typeDeclaration.bits & 0x200) != 0 ? (this.tagBits |= 0x834L) : (this.tagBits |= 0x814L);
        this.enclosingCase = caseStatement;
        this.sourceStart = typeDeclaration.sourceStart;
        MethodScope methodScope = classScope.enclosingMethodScope();
        AbstractMethodDeclaration abstractMethodDeclaration = methodScope.referenceMethod();
        if (abstractMethodDeclaration != null) {
            this.enclosingMethod = abstractMethodDeclaration.binding;
        }
    }

    public void addInnerEmulationDependent(BlockScope blockScope, boolean bl) {
        int n;
        if (this.dependents == null) {
            n = 0;
            this.dependents = new InnerEmulationDependency[1];
        } else {
            n = this.dependents.length;
            for (int i = 0; i < n; ++i) {
                if (this.dependents[i].scope != blockScope) continue;
                return;
            }
            this.dependents = new InnerEmulationDependency[n + 1];
            System.arraycopy(this.dependents, 0, this.dependents, 0, n);
        }
        this.dependents[n] = new InnerEmulationDependency(blockScope, bl);
    }

    public ReferenceBinding anonymousOriginalSuperType() {
        TypeReference typeReference;
        if (this.superInterfaces != Binding.NO_SUPERINTERFACES) {
            return this.superInterfaces[0];
        }
        if ((this.tagBits & 0x20000L) == 0L) {
            return this.superclass;
        }
        if (this.scope != null && (typeReference = this.scope.referenceContext.allocation.type) != null) {
            return (ReferenceBinding)typeReference.resolvedType;
        }
        return this.superclass;
    }

    public char[] computeUniqueKey(boolean bl) {
        char[] cArray = this.outermostEnclosingType().computeUniqueKey(bl);
        int n = CharOperation.lastIndexOf(';', cArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray, 0, n);
        stringBuffer.append('$');
        stringBuffer.append(String.valueOf(this.sourceStart));
        if (!this.isAnonymousType()) {
            stringBuffer.append('$');
            stringBuffer.append(this.sourceName);
        }
        stringBuffer.append(cArray, n, cArray.length - n);
        int n2 = stringBuffer.length();
        char[] cArray2 = new char[n2];
        stringBuffer.getChars(0, n2, cArray2, 0);
        return cArray2;
    }

    public char[] constantPoolName() {
        if (this.constantPoolName == null && this.scope != null) {
            this.constantPoolName = this.scope.compilationUnitScope().computeConstantPoolName(this);
        }
        return this.constantPoolName;
    }

    ArrayBinding createArrayType(int n, LookupEnvironment lookupEnvironment) {
        if (this.localArrayBindings == null) {
            this.localArrayBindings = new ArrayBinding[]{new ArrayBinding(this, n, lookupEnvironment)};
            return this.localArrayBindings[0];
        }
        int n2 = this.localArrayBindings.length;
        for (int i = 0; i < n2; ++i) {
            if (this.localArrayBindings[i].dimensions != n) continue;
            return this.localArrayBindings[i];
        }
        this.localArrayBindings = new ArrayBinding[n2 + 1];
        System.arraycopy(this.localArrayBindings, 0, this.localArrayBindings, 0, n2);
        this.localArrayBindings[n2] = new ArrayBinding(this, n, lookupEnvironment);
        return this.localArrayBindings[n2];
    }

    public char[] genericTypeSignature() {
        if (this.genericReferenceTypeSignature == null && this.constantPoolName == null) {
            if (this.isAnonymousType()) {
                this.setConstantPoolName(this.superclass().sourceName());
            } else {
                this.setConstantPoolName(this.sourceName());
            }
        }
        return super.genericTypeSignature();
    }

    public char[] readableName() {
        char[] cArray = this.isAnonymousType() ? CharOperation.concat(TypeConstants.ANONYM_PREFIX, this.anonymousOriginalSuperType().readableName(), TypeConstants.ANONYM_SUFFIX) : (this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.') : this.sourceName);
        TypeVariableBinding[] typeVariableBindingArray = this.typeVariables();
        if (typeVariableBindingArray != Binding.NO_TYPE_VARIABLES) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(cArray).append('<');
            int n2 = typeVariableBindingArray.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeVariableBindingArray[n].readableName());
            }
            stringBuffer.append('>');
            n = stringBuffer.length();
            cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
        }
        return cArray;
    }

    public char[] shortReadableName() {
        char[] cArray = this.isAnonymousType() ? CharOperation.concat(TypeConstants.ANONYM_PREFIX, this.anonymousOriginalSuperType().shortReadableName(), TypeConstants.ANONYM_SUFFIX) : (this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.') : this.sourceName);
        TypeVariableBinding[] typeVariableBindingArray = this.typeVariables();
        if (typeVariableBindingArray != Binding.NO_TYPE_VARIABLES) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append(cArray).append('<');
            int n2 = typeVariableBindingArray.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeVariableBindingArray[n].shortReadableName());
            }
            stringBuffer.append('>');
            n = stringBuffer.length();
            cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
        }
        return cArray;
    }

    public void setAsMemberType() {
        this.tagBits |= 0x80CL;
    }

    public void setConstantPoolName(char[] cArray) {
        this.constantPoolName = cArray;
    }

    public char[] signature() {
        if (this.signature == null && this.constantPoolName == null) {
            if (this.isAnonymousType()) {
                this.setConstantPoolName(this.superclass().sourceName());
            } else {
                this.setConstantPoolName(this.sourceName());
            }
        }
        return super.signature();
    }

    public char[] sourceName() {
        if (this.isAnonymousType()) {
            return CharOperation.concat(TypeConstants.ANONYM_PREFIX, this.anonymousOriginalSuperType().sourceName(), TypeConstants.ANONYM_SUFFIX);
        }
        return this.sourceName;
    }

    public String toString() {
        if (this.isAnonymousType()) {
            return "Anonymous type : " + super.toString();
        }
        if (this.isMemberType()) {
            return "Local member type : " + new String(this.sourceName()) + " " + super.toString();
        }
        return "Local type : " + new String(this.sourceName()) + " " + super.toString();
    }

    public void updateInnerEmulationDependents() {
        if (this.dependents != null) {
            for (int i = 0; i < this.dependents.length; ++i) {
                InnerEmulationDependency innerEmulationDependency = this.dependents[i];
                innerEmulationDependency.scope.propagateInnerEmulation(this, innerEmulationDependency.wasEnclosingInstanceSupplied);
            }
        }
    }
}

