/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.Util;

public class MethodBinding
extends Binding {
    public int modifiers;
    public char[] selector;
    public TypeBinding returnType;
    public TypeBinding[] parameters;
    public ReferenceBinding[] thrownExceptions;
    public ReferenceBinding declaringClass;
    public TypeVariableBinding[] typeVariables = Binding.NO_TYPE_VARIABLES;
    char[] signature;
    public long tagBits;

    protected MethodBinding() {
    }

    public MethodBinding(int n, char[] cArray, TypeBinding typeBinding, TypeBinding[] typeBindingArray, ReferenceBinding[] referenceBindingArray, ReferenceBinding referenceBinding) {
        this.modifiers = n;
        this.selector = cArray;
        this.returnType = typeBinding;
        this.parameters = typeBindingArray == null || typeBindingArray.length == 0 ? Binding.NO_PARAMETERS : typeBindingArray;
        this.thrownExceptions = referenceBindingArray == null || referenceBindingArray.length == 0 ? Binding.NO_EXCEPTIONS : referenceBindingArray;
        this.declaringClass = referenceBinding;
        if (this.declaringClass != null && this.declaringClass.isStrictfp() && !this.isNative() && !this.isAbstract()) {
            this.modifiers |= 0x800;
        }
    }

    public MethodBinding(int n, TypeBinding[] typeBindingArray, ReferenceBinding[] referenceBindingArray, ReferenceBinding referenceBinding) {
        this(n, TypeConstants.INIT, TypeBinding.VOID, typeBindingArray, referenceBindingArray, referenceBinding);
    }

    public MethodBinding(MethodBinding methodBinding, ReferenceBinding referenceBinding) {
        this.modifiers = methodBinding.modifiers;
        this.selector = methodBinding.selector;
        this.returnType = methodBinding.returnType;
        this.parameters = methodBinding.parameters;
        this.thrownExceptions = methodBinding.thrownExceptions;
        this.declaringClass = referenceBinding;
        referenceBinding.storeAnnotationHolder(this, methodBinding.declaringClass.retrieveAnnotationHolder(methodBinding, true));
    }

    public final boolean areParameterErasuresEqual(MethodBinding methodBinding) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        if (this.parameters == typeBindingArray) {
            return true;
        }
        int n = this.parameters.length;
        if (n != typeBindingArray.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.parameters[i] == typeBindingArray[i] || this.parameters[i].erasure() == typeBindingArray[i].erasure()) continue;
            return false;
        }
        return true;
    }

    public final boolean areParametersCompatibleWith(TypeBinding[] typeBindingArray) {
        int n;
        int n2 = this.parameters.length;
        int n3 = n = typeBindingArray.length;
        if (this.isVarargs()) {
            TypeBinding typeBinding;
            n3 = n2 - 1;
            if (n2 == n) {
                typeBinding = this.parameters[n3];
                TypeBinding typeBinding2 = typeBindingArray[n3];
                if (typeBinding != typeBinding2 && !typeBinding2.isCompatibleWith(typeBinding)) {
                    return false;
                }
            } else if (n2 < n) {
                typeBinding = ((ArrayBinding)this.parameters[n3]).elementsType();
                for (int i = n3; i < n; ++i) {
                    if (typeBinding == typeBindingArray[i] || typeBindingArray[i].isCompatibleWith(typeBinding)) continue;
                    return false;
                }
            } else if (n3 != n) {
                return false;
            }
        }
        for (int i = 0; i < n3; ++i) {
            if (this.parameters[i] == typeBindingArray[i] || typeBindingArray[i].isCompatibleWith(this.parameters[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean areParametersEqual(MethodBinding methodBinding) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        if (this.parameters == typeBindingArray) {
            return true;
        }
        int n = this.parameters.length;
        if (n != typeBindingArray.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.parameters[i] == typeBindingArray[i]) continue;
            return false;
        }
        return true;
    }

    public final boolean areTypeVariableErasuresEqual(MethodBinding methodBinding) {
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        if (this.typeVariables == typeVariableBindingArray) {
            return true;
        }
        int n = this.typeVariables.length;
        if (n != typeVariableBindingArray.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.typeVariables[i] == typeVariableBindingArray[i] || this.typeVariables[i].erasure() == typeVariableBindingArray[i].erasure()) continue;
            return false;
        }
        return true;
    }

    MethodBinding asRawMethod(LookupEnvironment lookupEnvironment) {
        if (this.typeVariables == Binding.NO_TYPE_VARIABLES) {
            return this;
        }
        int n = this.typeVariables.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            TypeVariableBinding typeVariableBinding = this.typeVariables[i];
            if (typeVariableBinding.boundsCount() <= 1) {
                typeBindingArray[i] = lookupEnvironment.convertToRawType(typeVariableBinding.upperBound(), false);
                continue;
            }
            ReferenceBinding[] referenceBindingArray = typeVariableBinding.superInterfaces();
            int n3 = referenceBindingArray.length;
            TypeBinding typeBinding = null;
            TypeBinding[] typeBindingArray2 = null;
            if (typeVariableBinding.boundsCount() == n3) {
                typeBinding = lookupEnvironment.convertToRawType(referenceBindingArray[0], false);
                typeBindingArray2 = new TypeBinding[n3 - 1];
                for (n2 = 1; n2 < n3; ++n2) {
                    typeBindingArray2[n2 - 1] = lookupEnvironment.convertToRawType(referenceBindingArray[n2], false);
                }
            } else {
                typeBinding = lookupEnvironment.convertToRawType(typeVariableBinding.superclass(), false);
                typeBindingArray2 = new TypeBinding[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    typeBindingArray2[n2] = lookupEnvironment.convertToRawType(referenceBindingArray[n2], false);
                }
            }
            typeBindingArray[i] = lookupEnvironment.createWildcard(null, 0, typeBinding, typeBindingArray2, 1);
        }
        return lookupEnvironment.createParameterizedGenericMethod(this, typeBindingArray);
    }

    public final boolean canBeSeenBy(InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding == this.declaringClass) {
            return true;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            return invocationSite.isSuperAccess();
        }
        if (this.isPrivate()) {
            ReferenceBinding referenceBinding;
            ReferenceBinding referenceBinding2 = sourceTypeBinding;
            for (referenceBinding = referenceBinding2.enclosingType(); referenceBinding != null; referenceBinding = referenceBinding.enclosingType()) {
                referenceBinding2 = referenceBinding;
            }
            ReferenceBinding referenceBinding3 = (ReferenceBinding)this.declaringClass.erasure();
            for (referenceBinding = referenceBinding3.enclosingType(); referenceBinding != null; referenceBinding = referenceBinding.enclosingType()) {
                referenceBinding3 = referenceBinding;
            }
            return referenceBinding2 == referenceBinding3;
        }
        return sourceTypeBinding.fPackage == this.declaringClass.fPackage;
    }

    public final boolean canBeSeenBy(PackageBinding packageBinding) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return packageBinding == this.declaringClass.getPackage();
    }

    public final boolean canBeSeenBy(TypeBinding typeBinding, InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding == this.declaringClass && sourceTypeBinding == typeBinding) {
            return true;
        }
        if (sourceTypeBinding == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.declaringClass.fPackage;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding == this.declaringClass) {
                return true;
            }
            if (sourceTypeBinding.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding referenceBinding = sourceTypeBinding;
            TypeBinding typeBinding2 = typeBinding.erasure();
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.declaringClass.erasure();
            int n = 0;
            do {
                if (referenceBinding.findSuperTypeOriginatingFrom(referenceBinding2) != null) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (typeBinding instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        if (n > 0) {
                            invocationSite.setDepth(n);
                        }
                        return true;
                    }
                    if (referenceBinding == typeBinding2 || typeBinding2.findSuperTypeOriginatingFrom(referenceBinding) != null) {
                        if (n > 0) {
                            invocationSite.setDepth(n);
                        }
                        return true;
                    }
                }
                ++n;
            } while ((referenceBinding = referenceBinding.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (!(typeBinding == this.declaringClass || scope.compilerOptions().complianceLevel <= 0x320000L && typeBinding.isTypeVariable() && ((TypeVariableBinding)typeBinding).isErasureBoundTo(this.declaringClass.erasure()))) {
                return false;
            }
            if (sourceTypeBinding != this.declaringClass) {
                ReferenceBinding referenceBinding;
                ReferenceBinding referenceBinding3 = sourceTypeBinding;
                for (referenceBinding = referenceBinding3.enclosingType(); referenceBinding != null; referenceBinding = referenceBinding.enclosingType()) {
                    referenceBinding3 = referenceBinding;
                }
                ReferenceBinding referenceBinding4 = (ReferenceBinding)this.declaringClass.erasure();
                for (referenceBinding = referenceBinding4.enclosingType(); referenceBinding != null; referenceBinding = referenceBinding.enclosingType()) {
                    referenceBinding4 = referenceBinding;
                }
                if (referenceBinding3 != referenceBinding4) {
                    return false;
                }
            }
            return true;
        }
        PackageBinding packageBinding = this.declaringClass.fPackage;
        if (sourceTypeBinding.fPackage != packageBinding) {
            return false;
        }
        if (typeBinding instanceof ArrayBinding) {
            return false;
        }
        TypeBinding typeBinding3 = this.declaringClass.original();
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        do {
            if (referenceBinding.isCapture() ? typeBinding3 == referenceBinding.erasure().original() : typeBinding3 == referenceBinding.original()) {
                return true;
            }
            PackageBinding packageBinding2 = referenceBinding.fPackage;
            if (packageBinding2 == null || packageBinding2 == packageBinding) continue;
            return false;
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    public List collectMissingTypes(List list) {
        if ((this.tagBits & 0x80L) != 0L) {
            int n;
            list = this.returnType.collectMissingTypes(list);
            int n2 = this.parameters.length;
            for (n = 0; n < n2; ++n) {
                list = this.parameters[n].collectMissingTypes(list);
            }
            n2 = this.thrownExceptions.length;
            for (n = 0; n < n2; ++n) {
                list = this.thrownExceptions[n].collectMissingTypes(list);
            }
            n2 = this.typeVariables.length;
            for (n = 0; n < n2; ++n) {
                TypeVariableBinding typeVariableBinding = this.typeVariables[n];
                list = typeVariableBinding.superclass().collectMissingTypes(list);
                ReferenceBinding[] referenceBindingArray = typeVariableBinding.superInterfaces();
                int n3 = referenceBindingArray.length;
                for (int i = 0; i < n3; ++i) {
                    list = referenceBindingArray[i].collectMissingTypes(list);
                }
            }
        }
        return list;
    }

    MethodBinding computeSubstitutedMethod(MethodBinding methodBinding, LookupEnvironment lookupEnvironment) {
        int n = this.typeVariables.length;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        if (n != typeVariableBindingArray.length) {
            return null;
        }
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = lookupEnvironment.createParameterizedGenericMethod(methodBinding, this.typeVariables);
        for (int i = 0; i < n; ++i) {
            if (this.typeVariables[i].isInterchangeableWith(typeVariableBindingArray[i], parameterizedGenericMethodBinding)) continue;
            return null;
        }
        return parameterizedGenericMethodBinding;
    }

    public char[] computeUniqueKey(boolean bl) {
        boolean bl2;
        boolean bl3;
        char[] cArray = this.declaringClass.computeUniqueKey(false);
        int n = cArray.length;
        int n2 = this.selector == TypeConstants.INIT ? 0 : this.selector.length;
        char[] cArray2 = this.genericSignature();
        boolean bl4 = bl3 = cArray2 != null;
        if (!bl3) {
            cArray2 = this.signature();
        }
        int n3 = cArray2.length;
        int n4 = this.thrownExceptions.length;
        int n5 = 0;
        Object object = null;
        boolean bl5 = bl2 = n4 > 0 && (!bl3 || CharOperation.lastIndexOf('^', cArray2) < 0);
        if (bl2) {
            object = new char[n4][];
            for (int i = 0; i < n4; ++i) {
                if (this.thrownExceptions[i] == null) continue;
                object[i] = this.thrownExceptions[i].signature();
                n5 += object[i].length + 1;
            }
        }
        char[] cArray3 = new char[n + 1 + n2 + n3 + n5];
        int n6 = 0;
        System.arraycopy(cArray, 0, cArray3, n6, n);
        n6 = n;
        cArray3[n6++] = 46;
        System.arraycopy(this.selector, 0, cArray3, n6, n2);
        System.arraycopy(cArray2, 0, cArray3, n6 += n2, n3);
        if (n5 > 0) {
            n6 += n3;
            for (int i = 0; i < n4; ++i) {
                char[] cArray4 = object[i];
                if (cArray4 == null) continue;
                cArray3[n6++] = 124;
                int n7 = cArray4.length;
                System.arraycopy(cArray4, 0, cArray3, n6, n7);
                n6 += n7;
            }
        }
        return cArray3;
    }

    public final char[] constantPoolName() {
        return this.selector;
    }

    public MethodBinding findOriginalInheritedMethod(MethodBinding methodBinding) {
        MethodBinding methodBinding2 = methodBinding.original();
        TypeBinding typeBinding = this.declaringClass.findSuperTypeOriginatingFrom(methodBinding2.declaringClass);
        if (typeBinding == null || !(typeBinding instanceof ReferenceBinding)) {
            return null;
        }
        if (methodBinding2.declaringClass != typeBinding) {
            MethodBinding[] methodBindingArray = ((ReferenceBinding)typeBinding).getMethods(methodBinding2.selector, methodBinding2.parameters.length);
            int n = methodBindingArray.length;
            for (int i = 0; i < n; ++i) {
                if (methodBindingArray[i].original() != methodBinding2) continue;
                return methodBindingArray[i];
            }
        }
        return methodBinding2;
    }

    public char[] genericSignature() {
        int n;
        int n2;
        int n3;
        if ((this.modifiers & 0x40000000) == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            stringBuffer.append('<');
            n3 = this.typeVariables.length;
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer.append(this.typeVariables[n2].genericSignature());
            }
            stringBuffer.append('>');
        }
        stringBuffer.append('(');
        n3 = this.parameters.length;
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append(this.parameters[n2].genericTypeSignature());
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            stringBuffer.append(this.returnType.genericTypeSignature());
        }
        n2 = 0;
        n3 = this.thrownExceptions.length;
        for (n = 0; n < n3; ++n) {
            if ((this.thrownExceptions[n].modifiers & 0x40000000) == 0) continue;
            n2 = 1;
            break;
        }
        if (n2 != 0) {
            for (n = 0; n < n3; ++n) {
                stringBuffer.append('^');
                stringBuffer.append(this.thrownExceptions[n].genericTypeSignature());
            }
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public AnnotationBinding[] getAnnotations() {
        MethodBinding methodBinding = this.original();
        return methodBinding.declaringClass.retrieveAnnotations(methodBinding);
    }

    public long getAnnotationTagBits() {
        TypeDeclaration typeDeclaration;
        AbstractMethodDeclaration abstractMethodDeclaration;
        ClassScope classScope;
        MethodBinding methodBinding = this.original();
        if ((methodBinding.tagBits & 0x200000000L) == 0L && methodBinding.declaringClass instanceof SourceTypeBinding && (classScope = ((SourceTypeBinding)methodBinding.declaringClass).scope) != null && (abstractMethodDeclaration = (typeDeclaration = classScope.referenceContext).declarationOf(methodBinding)) != null) {
            ASTNode.resolveAnnotations(abstractMethodDeclaration.scope, abstractMethodDeclaration.annotations, methodBinding);
        }
        return methodBinding.tagBits;
    }

    public Object getDefaultValue() {
        Object object;
        MethodBinding methodBinding = this.original();
        if ((methodBinding.tagBits & 0x20000000000000L) == 0L) {
            if (methodBinding.declaringClass instanceof SourceTypeBinding) {
                AbstractMethodDeclaration abstractMethodDeclaration;
                object = (SourceTypeBinding)methodBinding.declaringClass;
                if (((SourceTypeBinding)object).scope != null && (abstractMethodDeclaration = methodBinding.sourceMethod()) != null && abstractMethodDeclaration.isAnnotationMethod()) {
                    abstractMethodDeclaration.resolve(((SourceTypeBinding)object).scope);
                }
            }
            methodBinding.tagBits |= 0x20000000000000L;
        }
        return (object = methodBinding.declaringClass.retrieveAnnotationHolder(methodBinding, true)) == null ? null : ((AnnotationHolder)object).getDefaultValue();
    }

    public AnnotationBinding[][] getParameterAnnotations() {
        AnnotationBinding[][] annotationBindingArray;
        int n = this.parameters.length;
        if (n == 0) {
            return null;
        }
        MethodBinding methodBinding = this.original();
        AnnotationHolder annotationHolder = methodBinding.declaringClass.retrieveAnnotationHolder(methodBinding, true);
        AnnotationBinding[][] annotationBindingArray2 = annotationBindingArray = annotationHolder == null ? (AnnotationBinding[][])null : annotationHolder.getParameterAnnotations();
        if (annotationBindingArray == null && (this.tagBits & 0x400L) != 0L) {
            annotationBindingArray = new AnnotationBinding[n][];
            if (this.declaringClass instanceof SourceTypeBinding) {
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)this.declaringClass;
                if (sourceTypeBinding.scope != null) {
                    AbstractMethodDeclaration abstractMethodDeclaration = sourceTypeBinding.scope.referenceType().declarationOf(this);
                    for (int i = 0; i < n; ++i) {
                        Argument argument = abstractMethodDeclaration.arguments[i];
                        if (argument.annotations != null) {
                            ASTNode.resolveAnnotations(abstractMethodDeclaration.scope, argument.annotations, argument.binding);
                            annotationBindingArray[i] = argument.binding.getAnnotations();
                            continue;
                        }
                        annotationBindingArray[i] = Binding.NO_ANNOTATIONS;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        annotationBindingArray[i] = Binding.NO_ANNOTATIONS;
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    annotationBindingArray[i] = Binding.NO_ANNOTATIONS;
                }
            }
            this.setParameterAnnotations(annotationBindingArray);
        }
        return annotationBindingArray;
    }

    public TypeVariableBinding getTypeVariable(char[] cArray) {
        int n = this.typeVariables.length;
        while (--n >= 0) {
            if (!CharOperation.equals(this.typeVariables[n].sourceName, cArray)) continue;
            return this.typeVariables[n];
        }
        return null;
    }

    public boolean hasSubstitutedParameters() {
        return false;
    }

    public boolean hasSubstitutedReturnType() {
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isConstructor() {
        return this.selector == TypeConstants.INIT;
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDefaultAbstract() {
        return (this.modifiers & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isImplementing() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public final boolean isMain() {
        TypeBinding typeBinding;
        return this.selector.length == 4 && CharOperation.equals(this.selector, TypeConstants.MAIN) && (this.modifiers & 9) != 0 && TypeBinding.VOID == this.returnType && this.parameters.length == 1 && (typeBinding = this.parameters[0]).dimensions() == 1 && typeBinding.leafComponentType().id == 11;
    }

    public final boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public final boolean isOverriding() {
        return (this.modifiers & 0x10000000) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isOrEnclosedByPrivateType() {
        if ((this.modifiers & 2) != 0) {
            return true;
        }
        return this.declaringClass != null && this.declaringClass.isOrEnclosedByPrivateType();
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public final boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public boolean isVarargs() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isPolymorphic() {
        return false;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public final int kind() {
        return 8;
    }

    public MethodBinding original() {
        return this;
    }

    public char[] readableName() {
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            stringBuffer.append(this.declaringClass.sourceName());
        } else {
            stringBuffer.append(this.selector);
        }
        stringBuffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int n = this.parameters.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.parameters[i].sourceName());
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString().toCharArray();
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray) {
        this.declaringClass.storeAnnotations(this, annotationBindingArray);
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray, AnnotationBinding[][] annotationBindingArray2, Object object, LookupEnvironment lookupEnvironment) {
        this.declaringClass.storeAnnotationHolder(this, AnnotationHolder.storeAnnotations(annotationBindingArray, annotationBindingArray2, object, lookupEnvironment));
    }

    public void setDefaultValue(Object object) {
        MethodBinding methodBinding = this.original();
        methodBinding.tagBits |= 0x20000000000000L;
        AnnotationHolder annotationHolder = this.declaringClass.retrieveAnnotationHolder(this, false);
        if (annotationHolder == null) {
            this.setAnnotations(null, null, object, null);
        } else {
            this.setAnnotations(annotationHolder.getAnnotations(), annotationHolder.getParameterAnnotations(), object, null);
        }
    }

    public void setParameterAnnotations(AnnotationBinding[][] annotationBindingArray) {
        AnnotationHolder annotationHolder = this.declaringClass.retrieveAnnotationHolder(this, false);
        if (annotationHolder == null) {
            this.setAnnotations(null, annotationBindingArray, null, null);
        } else {
            this.setAnnotations(annotationHolder.getAnnotations(), annotationBindingArray, annotationHolder.getDefaultValue(), null);
        }
    }

    protected final void setSelector(char[] cArray) {
        this.selector = cArray;
        this.signature = null;
    }

    public char[] shortReadableName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            stringBuffer.append(this.declaringClass.shortReadableName());
        } else {
            stringBuffer.append(this.selector);
        }
        stringBuffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int n2 = this.parameters.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.parameters[n].shortReadableName());
            }
        }
        stringBuffer.append(')');
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    public final char[] signature() {
        int n;
        int n2;
        Binding[] bindingArray;
        boolean bl;
        if (this.signature != null) {
            return this.signature;
        }
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        stringBuffer.append('(');
        TypeBinding[] typeBindingArray = this.parameters;
        boolean bl2 = this.isConstructor();
        if (bl2 && this.declaringClass.isEnum()) {
            stringBuffer.append(ConstantPool.JavaLangStringSignature);
            stringBuffer.append(TypeBinding.INT.signature());
        }
        boolean bl3 = bl = bl2 && this.declaringClass.isNestedType();
        if (bl) {
            bindingArray = this.declaringClass.syntheticEnclosingInstanceTypes();
            if (bindingArray != null) {
                n2 = bindingArray.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(((ReferenceBinding)bindingArray[n]).signature());
                }
            }
            if (this instanceof SyntheticMethodBinding) {
                typeBindingArray = ((SyntheticMethodBinding)this).targetMethod.parameters;
            }
        }
        if (typeBindingArray != Binding.NO_PARAMETERS) {
            for (int i = 0; i < typeBindingArray.length; ++i) {
                stringBuffer.append(typeBindingArray[i].signature());
            }
        }
        if (bl) {
            bindingArray = this.declaringClass.syntheticOuterLocalVariables();
            n = bindingArray == null ? 0 : bindingArray.length;
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append(((SyntheticArgumentBinding)bindingArray[n2]).type.signature());
            }
            int n3 = this.parameters.length;
            for (n2 = typeBindingArray.length; n2 < n3; ++n2) {
                stringBuffer.append(this.parameters[n2].signature());
            }
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            stringBuffer.append(this.returnType.signature());
        }
        int n4 = stringBuffer.length();
        this.signature = new char[n4];
        stringBuffer.getChars(0, n4, this.signature, 0);
        return this.signature;
    }

    public final char[] signature(ClassFile classFile) {
        TypeBinding typeBinding;
        int n;
        boolean bl;
        if (this.signature != null) {
            if ((this.tagBits & 0x800L) != 0L) {
                TypeBinding typeBinding2;
                int n2;
                Object object;
                boolean bl2;
                boolean bl3 = this.isConstructor();
                TypeBinding[] typeBindingArray = this.parameters;
                boolean bl4 = bl2 = bl3 && this.declaringClass.isNestedType();
                if (bl2) {
                    object = this.declaringClass.syntheticEnclosingInstanceTypes();
                    if (object != null) {
                        int n3 = ((ReferenceBinding[])object).length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            typeBinding2 = object[n2];
                            if ((typeBinding2.tagBits & 0x800L) == 0L) continue;
                            Util.recordNestedType(classFile, typeBinding2);
                        }
                    }
                    if (this instanceof SyntheticMethodBinding) {
                        typeBindingArray = ((SyntheticMethodBinding)this).targetMethod.parameters;
                    }
                }
                if (typeBindingArray != Binding.NO_PARAMETERS) {
                    n2 = typeBindingArray.length;
                    for (int i = 0; i < n2; ++i) {
                        TypeBinding typeBinding3 = typeBindingArray[i];
                        typeBinding2 = typeBinding3.leafComponentType();
                        if ((typeBinding2.tagBits & 0x800L) == 0L) continue;
                        Util.recordNestedType(classFile, typeBinding2);
                    }
                }
                if (bl2) {
                    n2 = this.parameters.length;
                    for (int i = typeBindingArray.length; i < n2; ++i) {
                        TypeBinding typeBinding4 = this.parameters[i];
                        typeBinding2 = typeBinding4.leafComponentType();
                        if ((typeBinding2.tagBits & 0x800L) == 0L) continue;
                        Util.recordNestedType(classFile, typeBinding2);
                    }
                }
                if (this.returnType != null) {
                    object = this.returnType.leafComponentType();
                    if ((object.tagBits & 0x800L) != 0L) {
                        Util.recordNestedType(classFile, (TypeBinding)object);
                    }
                }
            }
            return this.signature;
        }
        StringBuffer stringBuffer = new StringBuffer((this.parameters.length + 1) * 20);
        stringBuffer.append('(');
        TypeBinding[] typeBindingArray = this.parameters;
        boolean bl5 = this.isConstructor();
        if (bl5 && this.declaringClass.isEnum()) {
            stringBuffer.append(ConstantPool.JavaLangStringSignature);
            stringBuffer.append(TypeBinding.INT.signature());
        }
        boolean bl6 = bl = bl5 && this.declaringClass.isNestedType();
        if (bl) {
            ReferenceBinding[] referenceBindingArray = this.declaringClass.syntheticEnclosingInstanceTypes();
            if (referenceBindingArray != null) {
                int n4 = referenceBindingArray.length;
                for (n = 0; n < n4; ++n) {
                    typeBinding = referenceBindingArray[n];
                    if ((((ReferenceBinding)typeBinding).tagBits & 0x800L) != 0L) {
                        this.tagBits |= 0x800L;
                        Util.recordNestedType(classFile, typeBinding);
                    }
                    stringBuffer.append(((ReferenceBinding)typeBinding).signature());
                }
            }
            if (this instanceof SyntheticMethodBinding) {
                typeBindingArray = ((SyntheticMethodBinding)this).targetMethod.parameters;
            }
        }
        if (typeBindingArray != Binding.NO_PARAMETERS) {
            n = typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding5 = typeBindingArray[i];
                typeBinding = typeBinding5.leafComponentType();
                if ((typeBinding.tagBits & 0x800L) != 0L) {
                    this.tagBits |= 0x800L;
                    Util.recordNestedType(classFile, typeBinding);
                }
                stringBuffer.append(typeBinding5.signature());
            }
        }
        if (bl) {
            int n5;
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = this.declaringClass.syntheticOuterLocalVariables();
            n = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
            for (n5 = 0; n5 < n; ++n5) {
                stringBuffer.append(syntheticArgumentBindingArray[n5].type.signature());
            }
            int n6 = this.parameters.length;
            for (n5 = typeBindingArray.length; n5 < n6; ++n5) {
                TypeBinding typeBinding6 = this.parameters[n5];
                TypeBinding typeBinding7 = typeBinding6.leafComponentType();
                if ((typeBinding7.tagBits & 0x800L) != 0L) {
                    this.tagBits |= 0x800L;
                    Util.recordNestedType(classFile, typeBinding7);
                }
                stringBuffer.append(typeBinding6.signature());
            }
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            TypeBinding typeBinding8 = this.returnType.leafComponentType();
            if ((typeBinding8.tagBits & 0x800L) != 0L) {
                this.tagBits |= 0x800L;
                Util.recordNestedType(classFile, typeBinding8);
            }
            stringBuffer.append(this.returnType.signature());
        }
        int n7 = stringBuffer.length();
        this.signature = new char[n7];
        stringBuffer.getChars(0, n7, this.signature, 0);
        return this.signature;
    }

    public final int sourceEnd() {
        AbstractMethodDeclaration abstractMethodDeclaration = this.sourceMethod();
        if (abstractMethodDeclaration == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceEnd();
            }
            return 0;
        }
        return abstractMethodDeclaration.sourceEnd;
    }

    public AbstractMethodDeclaration sourceMethod() {
        SourceTypeBinding sourceTypeBinding;
        if (this.isSynthetic()) {
            return null;
        }
        try {
            sourceTypeBinding = (SourceTypeBinding)this.declaringClass;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = sourceTypeBinding.scope.referenceContext.methods;
        if (abstractMethodDeclarationArray != null) {
            int n = abstractMethodDeclarationArray.length;
            while (--n >= 0) {
                if (this != abstractMethodDeclarationArray[n].binding) continue;
                return abstractMethodDeclarationArray[n];
            }
        }
        return null;
    }

    public final int sourceStart() {
        AbstractMethodDeclaration abstractMethodDeclaration = this.sourceMethod();
        if (abstractMethodDeclaration == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceStart();
            }
            return 0;
        }
        return abstractMethodDeclaration.sourceStart;
    }

    public MethodBinding tiebreakMethod() {
        return this;
    }

    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(10);
        if ((this.modifiers & 0x2000000) != 0) {
            stringBuffer.append("[unresolved] ");
        }
        ASTNode.printModifiers(this.modifiers, stringBuffer);
        stringBuffer.append(this.returnType != null ? this.returnType.debugName() : "<no type>");
        stringBuffer.append(" ");
        stringBuffer.append(this.selector != null ? new String(this.selector) : "<no selector>");
        stringBuffer.append("(");
        if (this.parameters != null) {
            if (this.parameters != Binding.NO_PARAMETERS) {
                n2 = this.parameters.length;
                for (n = 0; n < n2; ++n) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.parameters[n] != null ? this.parameters[n].debugName() : "<no argument type>");
                }
            }
        } else {
            stringBuffer.append("<no argument types>");
        }
        stringBuffer.append(") ");
        if (this.thrownExceptions != null) {
            if (this.thrownExceptions != Binding.NO_EXCEPTIONS) {
                stringBuffer.append("throws ");
                n2 = this.thrownExceptions.length;
                for (n = 0; n < n2; ++n) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.thrownExceptions[n] != null ? this.thrownExceptions[n].debugName() : "<no exception type>");
                }
            }
        } else {
            stringBuffer.append("<no exception types>");
        }
        return stringBuffer.toString();
    }

    public TypeVariableBinding[] typeVariables() {
        return this.typeVariables;
    }
}

