/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportConflictBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.MostSpecificExceptionMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;

public abstract class Scope {
    public static final int BLOCK_SCOPE = 1;
    public static final int CLASS_SCOPE = 3;
    public static final int COMPILATION_UNIT_SCOPE = 4;
    public static final int METHOD_SCOPE = 2;
    public static final int NOT_COMPATIBLE = -1;
    public static final int COMPATIBLE = 0;
    public static final int AUTOBOX_COMPATIBLE = 1;
    public static final int VARARGS_COMPATIBLE = 2;
    public static final int EQUAL_OR_MORE_SPECIFIC = -1;
    public static final int NOT_RELATED = 0;
    public static final int MORE_GENERIC = 1;
    public int kind;
    public Scope parent;

    protected Scope(int n, Scope scope) {
        this.kind = n;
        this.parent = scope;
    }

    public static int compareTypes(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding.isCompatibleWith(typeBinding2)) {
            return -1;
        }
        if (typeBinding2.isCompatibleWith(typeBinding)) {
            return 1;
        }
        return 0;
    }

    public static TypeBinding convertEliminatingTypeVariables(TypeBinding typeBinding, ReferenceBinding referenceBinding, int n, Set hashSet) {
        if ((typeBinding.tagBits & 0x20000000L) != 0L) {
            switch (typeBinding.kind()) {
                case 68: {
                    ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                    TypeBinding typeBinding2 = arrayBinding.leafComponentType;
                    TypeBinding typeBinding3 = Scope.convertEliminatingTypeVariables(typeBinding2, referenceBinding, n, hashSet);
                    if (typeBinding3 == typeBinding2) break;
                    return arrayBinding.environment.createArrayType(typeBinding3.leafComponentType(), typeBinding3.dimensions() + arrayBinding.dimensions());
                }
                case 260: {
                    int n2;
                    TypeBinding[] typeBindingArray;
                    ReferenceBinding referenceBinding2;
                    ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
                    ReferenceBinding referenceBinding3 = referenceBinding2 = parameterizedTypeBinding.enclosingType();
                    if (referenceBinding2 != null) {
                        referenceBinding3 = (ReferenceBinding)Scope.convertEliminatingTypeVariables(referenceBinding2, referenceBinding, n, hashSet);
                    }
                    TypeBinding[] typeBindingArray2 = typeBindingArray = parameterizedTypeBinding.arguments;
                    int n3 = n2 = typeBindingArray == null ? 0 : typeBindingArray.length;
                    for (int i = 0; i < n2; ++i) {
                        TypeBinding typeBinding4 = typeBindingArray[i];
                        TypeBinding typeBinding5 = Scope.convertEliminatingTypeVariables(typeBinding4, parameterizedTypeBinding.genericType(), i, hashSet);
                        if (typeBinding5 != typeBinding4) {
                            if (typeBindingArray2 == typeBindingArray) {
                                typeBindingArray2 = new TypeBinding[n2];
                                System.arraycopy(typeBindingArray, 0, typeBindingArray2, 0, i);
                            }
                            typeBindingArray2[i] = typeBinding5;
                            continue;
                        }
                        if (typeBindingArray2 == typeBindingArray) continue;
                        typeBindingArray2[i] = typeBinding4;
                    }
                    if (referenceBinding2 == referenceBinding3 && typeBindingArray == typeBindingArray2) break;
                    return parameterizedTypeBinding.environment.createParameterizedType(parameterizedTypeBinding.genericType(), typeBindingArray2, referenceBinding3);
                }
                case 4100: {
                    if (referenceBinding == null) break;
                    TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBinding;
                    if (hashSet != null && hashSet.contains(typeBinding)) {
                        return typeVariableBinding.environment.createWildcard(referenceBinding, n, null, null, 0);
                    }
                    TypeBinding typeBinding6 = typeVariableBinding.upperBound();
                    if (hashSet == null) {
                        hashSet = new HashSet<TypeVariableBinding>(2);
                    }
                    hashSet.add(typeVariableBinding);
                    TypeBinding typeBinding7 = Scope.convertEliminatingTypeVariables(typeBinding6, referenceBinding, n, hashSet);
                    hashSet.remove(typeVariableBinding);
                    return typeVariableBinding.environment.createWildcard(referenceBinding, n, typeBinding7, null, 1);
                }
                case 1028: {
                    break;
                }
                case 2052: {
                    int n4;
                    TypeBinding[] typeBindingArray;
                    ReferenceBinding referenceBinding4;
                    ReferenceBinding referenceBinding5 = (ReferenceBinding)typeBinding;
                    ReferenceBinding referenceBinding6 = referenceBinding4 = referenceBinding5.enclosingType();
                    if (referenceBinding4 != null) {
                        referenceBinding6 = (ReferenceBinding)Scope.convertEliminatingTypeVariables(referenceBinding4, referenceBinding, n, hashSet);
                    }
                    TypeBinding[] typeBindingArray3 = typeBindingArray = referenceBinding5.typeVariables();
                    int n5 = n4 = typeBindingArray == null ? 0 : typeBindingArray.length;
                    for (int i = 0; i < n4; ++i) {
                        TypeVariableBinding typeVariableBinding = typeBindingArray[i];
                        TypeBinding typeBinding8 = Scope.convertEliminatingTypeVariables(typeVariableBinding, referenceBinding5, i, hashSet);
                        if (typeBinding8 != typeVariableBinding) {
                            if (typeBindingArray3 == typeBindingArray) {
                                typeBindingArray3 = new TypeBinding[n4];
                                System.arraycopy(typeBindingArray, 0, typeBindingArray3, 0, i);
                            }
                            typeBindingArray3[i] = typeBinding8;
                            continue;
                        }
                        if (typeBindingArray3 == typeBindingArray) continue;
                        typeBindingArray3[i] = typeVariableBinding;
                    }
                    if (referenceBinding4 == referenceBinding6 && typeBindingArray == typeBindingArray3) break;
                    return typeBindingArray[0].environment.createParameterizedType(referenceBinding, typeBindingArray3, referenceBinding6);
                }
                case 516: {
                    TypeBinding typeBinding9;
                    WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                    TypeBinding typeBinding10 = typeBinding9 = wildcardBinding.bound;
                    if (typeBinding9 == null || (typeBinding10 = Scope.convertEliminatingTypeVariables(typeBinding9, referenceBinding, n, hashSet)) == typeBinding9) break;
                    return wildcardBinding.environment.createWildcard(wildcardBinding.genericType, wildcardBinding.rank, typeBinding10, null, wildcardBinding.boundKind);
                }
                case 8196: {
                    int n6;
                    TypeBinding[] typeBindingArray;
                    TypeBinding typeBinding11;
                    WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                    TypeBinding typeBinding12 = typeBinding11 = wildcardBinding.bound;
                    if (typeBinding11 != null) {
                        typeBinding12 = Scope.convertEliminatingTypeVariables(typeBinding11, referenceBinding, n, hashSet);
                    }
                    TypeBinding[] typeBindingArray4 = typeBindingArray = wildcardBinding.otherBounds;
                    int n7 = n6 = typeBindingArray == null ? 0 : typeBindingArray.length;
                    for (int i = 0; i < n6; ++i) {
                        TypeBinding typeBinding13 = typeBindingArray[i];
                        TypeBinding typeBinding14 = Scope.convertEliminatingTypeVariables(typeBinding13, referenceBinding, n, hashSet);
                        if (typeBinding14 != typeBinding13) {
                            if (typeBindingArray4 == typeBindingArray) {
                                typeBindingArray4 = new TypeBinding[n6];
                                System.arraycopy(typeBindingArray, 0, typeBindingArray4, 0, i);
                            }
                            typeBindingArray4[i] = typeBinding14;
                            continue;
                        }
                        if (typeBindingArray4 == typeBindingArray) continue;
                        typeBindingArray4[i] = typeBinding13;
                    }
                    if (typeBinding12 == typeBinding11 && typeBindingArray4 == typeBindingArray) break;
                    return wildcardBinding.environment.createWildcard(wildcardBinding.genericType, wildcardBinding.rank, typeBinding12, typeBindingArray4, wildcardBinding.boundKind);
                }
            }
        }
        return typeBinding;
    }

    public static TypeBinding getBaseType(char[] cArray) {
        int n = cArray.length;
        if (n > 2 && n < 8) {
            switch (cArray[0]) {
                case 'i': {
                    if (n != 3 || cArray[1] != 'n' || cArray[2] != 't') break;
                    return TypeBinding.INT;
                }
                case 'v': {
                    if (n != 4 || cArray[1] != 'o' || cArray[2] != 'i' || cArray[3] != 'd') break;
                    return TypeBinding.VOID;
                }
                case 'b': {
                    if (n == 7 && cArray[1] == 'o' && cArray[2] == 'o' && cArray[3] == 'l' && cArray[4] == 'e' && cArray[5] == 'a' && cArray[6] == 'n') {
                        return TypeBinding.BOOLEAN;
                    }
                    if (n != 4 || cArray[1] != 'y' || cArray[2] != 't' || cArray[3] != 'e') break;
                    return TypeBinding.BYTE;
                }
                case 'c': {
                    if (n != 4 || cArray[1] != 'h' || cArray[2] != 'a' || cArray[3] != 'r') break;
                    return TypeBinding.CHAR;
                }
                case 'd': {
                    if (n != 6 || cArray[1] != 'o' || cArray[2] != 'u' || cArray[3] != 'b' || cArray[4] != 'l' || cArray[5] != 'e') break;
                    return TypeBinding.DOUBLE;
                }
                case 'f': {
                    if (n != 5 || cArray[1] != 'l' || cArray[2] != 'o' || cArray[3] != 'a' || cArray[4] != 't') break;
                    return TypeBinding.FLOAT;
                }
                case 'l': {
                    if (n != 4 || cArray[1] != 'o' || cArray[2] != 'n' || cArray[3] != 'g') break;
                    return TypeBinding.LONG;
                }
                case 's': {
                    if (n != 5 || cArray[1] != 'h' || cArray[2] != 'o' || cArray[3] != 'r' || cArray[4] != 't') break;
                    return TypeBinding.SHORT;
                }
            }
        }
        return null;
    }

    public static ReferenceBinding[] greaterLowerBound(ReferenceBinding[] referenceBindingArray) {
        ReferenceBinding referenceBinding;
        int n;
        if (referenceBindingArray == null) {
            return null;
        }
        int n2 = referenceBindingArray.length;
        if (n2 == 0) {
            return null;
        }
        ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ReferenceBinding referenceBinding2 = referenceBindingArray2[i];
            if (referenceBinding2 == null) continue;
            for (n = 0; n < n2; ++n) {
                if (i == n || (referenceBinding = referenceBindingArray2[n]) == null || !referenceBinding2.isCompatibleWith(referenceBinding)) continue;
                if (referenceBindingArray2 == referenceBindingArray) {
                    ReferenceBinding[] referenceBindingArray3 = referenceBindingArray2;
                    referenceBindingArray2 = new ReferenceBinding[n2];
                    System.arraycopy(referenceBindingArray3, 0, referenceBindingArray2, 0, n2);
                }
                referenceBindingArray2[n] = null;
                ++n3;
            }
        }
        if (n3 == 0) {
            return referenceBindingArray2;
        }
        if (n2 == n3) {
            return null;
        }
        ReferenceBinding[] referenceBindingArray4 = new ReferenceBinding[n2 - n3];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            referenceBinding = referenceBindingArray2[i];
            if (referenceBinding == null) continue;
            referenceBindingArray4[n++] = referenceBinding;
        }
        return referenceBindingArray4;
    }

    public static TypeBinding[] greaterLowerBound(TypeBinding[] typeBindingArray) {
        TypeBinding typeBinding;
        int n;
        if (typeBindingArray == null) {
            return null;
        }
        int n2 = typeBindingArray.length;
        if (n2 == 0) {
            return null;
        }
        TypeBinding[] typeBindingArray2 = typeBindingArray;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            TypeBinding typeBinding2 = typeBindingArray2[i];
            if (typeBinding2 == null) continue;
            for (n = 0; n < n2; ++n) {
                if (i == n || (typeBinding = typeBindingArray2[n]) == null || !typeBinding2.isCompatibleWith(typeBinding)) continue;
                if (typeBindingArray2 == typeBindingArray) {
                    TypeBinding[] typeBindingArray3 = typeBindingArray2;
                    typeBindingArray2 = new TypeBinding[n2];
                    System.arraycopy(typeBindingArray3, 0, typeBindingArray2, 0, n2);
                }
                typeBindingArray2[n] = null;
                ++n3;
            }
        }
        if (n3 == 0) {
            return typeBindingArray2;
        }
        if (n2 == n3) {
            return null;
        }
        TypeBinding[] typeBindingArray4 = new TypeBinding[n2 - n3];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            typeBinding = typeBindingArray2[i];
            if (typeBinding == null) continue;
            typeBindingArray4[n++] = typeBinding;
        }
        return typeBindingArray4;
    }

    public static ReferenceBinding[] substitute(Substitution substitution, ReferenceBinding[] referenceBindingArray) {
        if (referenceBindingArray == null) {
            return null;
        }
        ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
        int n = referenceBindingArray.length;
        for (int i = 0; i < n; ++i) {
            ReferenceBinding referenceBinding = referenceBindingArray[i];
            TypeBinding typeBinding = Scope.substitute(substitution, referenceBinding);
            if (!(typeBinding instanceof ReferenceBinding)) {
                return null;
            }
            if (typeBinding != referenceBinding) {
                if (referenceBindingArray2 == referenceBindingArray) {
                    referenceBindingArray2 = new ReferenceBinding[n];
                    System.arraycopy(referenceBindingArray, 0, referenceBindingArray2, 0, i);
                }
                referenceBindingArray2[i] = (ReferenceBinding)typeBinding;
                continue;
            }
            if (referenceBindingArray2 == referenceBindingArray) continue;
            referenceBindingArray2[i] = referenceBinding;
        }
        return referenceBindingArray2;
    }

    public static TypeBinding substitute(Substitution substitution, TypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        switch (typeBinding.kind()) {
            case 4100: {
                return substitution.substitute((TypeVariableBinding)typeBinding);
            }
            case 260: {
                TypeBinding[] typeBindingArray;
                ReferenceBinding referenceBinding;
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
                ReferenceBinding referenceBinding2 = referenceBinding = typeBinding.enclosingType();
                if (referenceBinding != null) {
                    referenceBinding2 = (ReferenceBinding)Scope.substitute(substitution, referenceBinding);
                }
                TypeBinding[] typeBindingArray2 = typeBindingArray = parameterizedTypeBinding.arguments;
                if (typeBindingArray != null) {
                    if (substitution.isRawSubstitution()) {
                        return parameterizedTypeBinding.environment.createRawType(parameterizedTypeBinding.genericType(), referenceBinding2);
                    }
                    typeBindingArray2 = Scope.substitute(substitution, typeBindingArray);
                }
                if (typeBindingArray2 == typeBindingArray && referenceBinding2 == referenceBinding) break;
                return parameterizedTypeBinding.environment.createParameterizedType(parameterizedTypeBinding.genericType(), typeBindingArray2, referenceBinding2);
            }
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                TypeBinding typeBinding2 = arrayBinding.leafComponentType;
                TypeBinding typeBinding3 = Scope.substitute(substitution, typeBinding2);
                if (typeBinding3 == typeBinding2) break;
                return arrayBinding.environment.createArrayType(typeBinding3.leafComponentType(), typeBinding3.dimensions() + typeBinding.dimensions());
            }
            case 516: 
            case 8196: {
                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                if (wildcardBinding.boundKind == 0) break;
                TypeBinding typeBinding4 = wildcardBinding.bound;
                TypeBinding typeBinding5 = Scope.substitute(substitution, typeBinding4);
                TypeBinding[] typeBindingArray = wildcardBinding.otherBounds;
                TypeBinding[] typeBindingArray3 = Scope.substitute(substitution, typeBindingArray);
                if (typeBinding5 == typeBinding4 && typeBindingArray == typeBindingArray3) break;
                if (typeBindingArray != null) {
                    TypeBinding[] typeBindingArray4 = new TypeBinding[1 + typeBindingArray3.length];
                    typeBindingArray4[0] = typeBinding5;
                    System.arraycopy(typeBindingArray3, 0, typeBindingArray4, 1, typeBindingArray3.length);
                    TypeBinding[] typeBindingArray5 = Scope.greaterLowerBound(typeBindingArray4);
                    if (typeBindingArray5 != null && typeBindingArray5 != typeBindingArray4) {
                        typeBinding5 = typeBindingArray5[0];
                        if (typeBindingArray5.length == 1) {
                            typeBindingArray3 = null;
                        } else {
                            typeBindingArray3 = new TypeBinding[typeBindingArray5.length - 1];
                            System.arraycopy(typeBindingArray5, 1, typeBindingArray3, 0, typeBindingArray5.length - 1);
                        }
                    }
                }
                return wildcardBinding.environment.createWildcard(wildcardBinding.genericType, wildcardBinding.rank, typeBinding5, typeBindingArray3, wildcardBinding.boundKind);
            }
            case 4: {
                ReferenceBinding referenceBinding;
                if (!typeBinding.isMemberType()) break;
                ReferenceBinding referenceBinding3 = (ReferenceBinding)typeBinding;
                ReferenceBinding referenceBinding4 = referenceBinding = typeBinding.enclosingType();
                if (referenceBinding != null) {
                    referenceBinding4 = (ReferenceBinding)Scope.substitute(substitution, referenceBinding);
                }
                if (referenceBinding4 == referenceBinding) break;
                return substitution.isRawSubstitution() ? substitution.environment().createRawType(referenceBinding3, referenceBinding4) : substitution.environment().createParameterizedType(referenceBinding3, null, referenceBinding4);
            }
            case 2052: {
                ReferenceBinding referenceBinding;
                ReferenceBinding referenceBinding5 = (ReferenceBinding)typeBinding;
                ReferenceBinding referenceBinding6 = referenceBinding = typeBinding.enclosingType();
                if (referenceBinding != null) {
                    referenceBinding6 = (ReferenceBinding)Scope.substitute(substitution, referenceBinding);
                }
                if (substitution.isRawSubstitution()) {
                    return substitution.environment().createRawType(referenceBinding5, referenceBinding6);
                }
                TypeBinding[] typeBindingArray = referenceBinding5.typeVariables();
                TypeBinding[] typeBindingArray6 = Scope.substitute(substitution, typeBindingArray);
                return substitution.environment().createParameterizedType(referenceBinding5, typeBindingArray6, referenceBinding6);
            }
        }
        return typeBinding;
    }

    public static TypeBinding[] substitute(Substitution substitution, TypeBinding[] typeBindingArray) {
        if (typeBindingArray == null) {
            return null;
        }
        TypeBinding[] typeBindingArray2 = typeBindingArray;
        int n = typeBindingArray.length;
        for (int i = 0; i < n; ++i) {
            TypeBinding typeBinding = typeBindingArray[i];
            TypeBinding typeBinding2 = Scope.substitute(substitution, typeBinding);
            if (typeBinding2 != typeBinding) {
                if (typeBindingArray2 == typeBindingArray) {
                    typeBindingArray2 = new TypeBinding[n];
                    System.arraycopy(typeBindingArray, 0, typeBindingArray2, 0, i);
                }
                typeBindingArray2[i] = typeBinding2;
                continue;
            }
            if (typeBindingArray2 == typeBindingArray) continue;
            typeBindingArray2[i] = typeBinding;
        }
        return typeBindingArray2;
    }

    public TypeBinding boxing(TypeBinding typeBinding) {
        if (typeBinding.isBaseType()) {
            return this.environment().computeBoxingType(typeBinding);
        }
        return typeBinding;
    }

    public final ClassScope classScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final CompilationUnitScope compilationUnitScope() {
        Scope scope = null;
        Scope scope2 = this;
        do {
            scope = scope2;
        } while ((scope2 = scope2.parent) != null);
        return (CompilationUnitScope)scope;
    }

    public final CompilerOptions compilerOptions() {
        return this.compilationUnitScope().environment.globalOptions;
    }

    protected final MethodBinding computeCompatibleMethod(MethodBinding methodBinding, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        TypeBinding[] typeBindingArray2 = invocationSite.genericTypeArguments();
        TypeBinding[] typeBindingArray3 = methodBinding.parameters;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        if (typeBindingArray3 == typeBindingArray && (methodBinding.returnType.tagBits & 0x20000000L) == 0L && typeBindingArray2 == null && typeVariableBindingArray == Binding.NO_TYPE_VARIABLES) {
            return methodBinding;
        }
        int n = typeBindingArray.length;
        int n2 = typeBindingArray3.length;
        boolean bl = methodBinding.isVarargs();
        if (!(n == n2 || bl && n >= n2 - 1)) {
            return null;
        }
        if (typeVariableBindingArray != Binding.NO_TYPE_VARIABLES && this.compilerOptions().sourceLevel >= 0x310000L) {
            TypeBinding[] typeBindingArray4 = null;
            for (int i = 0; i < n; ++i) {
                TypeBinding typeBinding;
                TypeBinding typeBinding2 = typeBinding = i < n2 ? typeBindingArray3[i] : typeBindingArray3[n2 - 1];
                if (typeBindingArray[i].isBaseType() == typeBinding.isBaseType()) continue;
                if (typeBindingArray4 == null) {
                    typeBindingArray4 = new TypeBinding[n];
                    System.arraycopy(typeBindingArray, 0, typeBindingArray4, 0, n);
                }
                typeBindingArray4[i] = this.environment().computeBoxingType(typeBindingArray[i]);
            }
            if (typeBindingArray4 != null) {
                typeBindingArray = typeBindingArray4;
            }
            if ((methodBinding = ParameterizedGenericMethodBinding.computeCompatibleMethod(methodBinding, typeBindingArray, this, invocationSite)) == null) {
                return null;
            }
            if (!methodBinding.isValidBinding()) {
                return methodBinding;
            }
        } else if (typeBindingArray2 != null && this.compilerOptions().complianceLevel < 0x330000L) {
            if (methodBinding instanceof ParameterizedGenericMethodBinding) {
                if (!((ParameterizedGenericMethodBinding)methodBinding).wasInferred) {
                    return new ProblemMethodBinding(methodBinding, methodBinding.selector, typeBindingArray2, 13);
                }
            } else if (!methodBinding.isOverriding() || !this.isOverriddenMethodGeneric(methodBinding)) {
                return new ProblemMethodBinding(methodBinding, methodBinding.selector, typeBindingArray2, 11);
            }
        }
        if (this.parameterCompatibilityLevel(methodBinding, typeBindingArray) > -1) {
            if ((methodBinding.tagBits & 0x10000000000000L) != 0L) {
                return this.environment().createPolymorphicMethod(methodBinding, typeBindingArray);
            }
            return methodBinding;
        }
        if (typeBindingArray2 != null && typeVariableBindingArray != Binding.NO_TYPE_VARIABLES) {
            return new ProblemMethodBinding(methodBinding, methodBinding.selector, typeBindingArray, 12);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected boolean connectTypeVariables(TypeParameter[] typeParameterArray, boolean bl) {
        TypeVariableBinding typeVariableBinding;
        TypeParameter typeParameter;
        int n;
        if (typeParameterArray == null || typeParameterArray.length == 0) {
            return true;
        }
        HashMap hashMap = new HashMap(2);
        boolean bl2 = true;
        int n2 = typeParameterArray.length;
        for (n = 0; n < n2; ++n) {
            typeParameter = typeParameterArray[n];
            typeVariableBinding = typeParameter.binding;
            if (typeVariableBinding == null) {
                return false;
            }
            typeVariableBinding.superclass = this.getJavaLangObject();
            typeVariableBinding.superInterfaces = Binding.NO_SUPERINTERFACES;
            typeVariableBinding.firstBound = null;
        }
        n = 0;
        n2 = typeParameterArray.length;
        while (true) {
            block25: {
                TypeBinding typeBinding;
                boolean bl3;
                TypeReference typeReference;
                block24: {
                    block26: {
                        if (n >= n2) {
                            return bl2;
                        }
                        typeParameter = typeParameterArray[n];
                        typeVariableBinding = typeParameter.binding;
                        typeReference = typeParameter.type;
                        if (typeReference == null) break block25;
                        bl3 = false;
                        TypeBinding typeBinding2 = typeBinding = this.kind == 2 ? typeReference.resolveType((BlockScope)this, false) : typeReference.resolveType((ClassScope)this);
                        if (typeBinding != null) break block26;
                        typeVariableBinding.tagBits |= 0x20000L;
                        break block24;
                    }
                    typeReference.resolvedType = typeBinding;
                    switch (typeBinding.kind()) {
                        case 68: {
                            this.problemReporter().boundCannotBeArray(typeReference, typeBinding);
                            typeVariableBinding.tagBits |= 0x20000L;
                            break block24;
                        }
                        case 4100: {
                            bl3 = true;
                            TypeVariableBinding typeVariableBinding2 = (TypeVariableBinding)typeBinding;
                            if (typeVariableBinding2.rank >= typeVariableBinding.rank && typeVariableBinding2.declaringElement == typeVariableBinding.declaringElement && this.compilerOptions().complianceLevel <= 0x320000L) {
                                this.problemReporter().forwardTypeVariableReference(typeParameter, typeVariableBinding2);
                                typeVariableBinding.tagBits |= 0x20000L;
                                break block24;
                            } else {
                                void var14_20;
                                if (this.compilerOptions().complianceLevel <= 0x320000L || typeVariableBinding.rank < typeVariableBinding2.rank || typeVariableBinding2.declaringElement != typeVariableBinding.declaringElement) break;
                                SimpleSet simpleSet = new SimpleSet(typeParameterArray.length);
                                simpleSet.add(typeVariableBinding);
                                TypeVariableBinding typeVariableBinding3 = typeVariableBinding2;
                                while (var14_20 instanceof TypeVariableBinding) {
                                    if (simpleSet.includes(var14_20)) {
                                        this.problemReporter().hierarchyCircularity(typeVariableBinding, (ReferenceBinding)typeVariableBinding2, typeReference);
                                        typeVariableBinding.tagBits |= 0x20000L;
                                        break block24;
                                    }
                                    simpleSet.add(var14_20);
                                    ReferenceBinding referenceBinding = ((TypeVariableBinding)var14_20).superclass;
                                }
                                break;
                            }
                        }
                        default: {
                            if (!((ReferenceBinding)typeBinding).isFinal()) break;
                            this.problemReporter().finalVariableBound(typeVariableBinding, typeReference);
                        }
                    }
                    ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
                    if (!typeBinding.isInterface()) {
                        typeVariableBinding.superclass = referenceBinding;
                    } else {
                        typeVariableBinding.superInterfaces = new ReferenceBinding[]{referenceBinding};
                    }
                    typeVariableBinding.tagBits |= typeBinding.tagBits & 0x800L;
                    typeVariableBinding.firstBound = referenceBinding;
                }
                TypeReference[] typeReferenceArray = typeParameter.bounds;
                if (typeReferenceArray != null) {
                    int n3 = typeReferenceArray.length;
                    block7: for (int i = 0; i < n3; ++i) {
                        boolean bl4;
                        typeReference = typeReferenceArray[i];
                        TypeBinding typeBinding3 = typeBinding = this.kind == 2 ? typeReference.resolveType((BlockScope)this, false) : typeReference.resolveType((ClassScope)this);
                        if (typeBinding == null) {
                            typeVariableBinding.tagBits |= 0x20000L;
                            continue;
                        }
                        typeVariableBinding.tagBits |= typeBinding.tagBits & 0x800L;
                        boolean bl5 = bl4 = !typeReference.resolvedType.isValidBinding();
                        if (bl3 && i == 0) {
                            this.problemReporter().noAdditionalBoundAfterTypeVariable(typeReference);
                            typeVariableBinding.tagBits |= 0x20000L;
                            bl4 = true;
                        } else {
                            if (typeBinding.isArrayType()) {
                                if (bl4) continue;
                                this.problemReporter().boundCannotBeArray(typeReference, typeBinding);
                                typeVariableBinding.tagBits |= 0x20000L;
                                continue;
                            }
                            if (!typeBinding.isInterface()) {
                                if (bl4) continue;
                                this.problemReporter().boundMustBeAnInterface(typeReference, typeBinding);
                                typeVariableBinding.tagBits |= 0x20000L;
                                continue;
                            }
                        }
                        if (bl && typeVariableBinding.firstBound == typeVariableBinding.superclass && this.hasErasedCandidatesCollisions(typeBinding, typeVariableBinding.superclass, hashMap, typeVariableBinding, typeReference)) continue;
                        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
                        int n4 = typeVariableBinding.superInterfaces.length;
                        while (--n4 >= 0) {
                            ReferenceBinding referenceBinding2 = typeVariableBinding.superInterfaces[n4];
                            if (referenceBinding2 == referenceBinding) {
                                this.problemReporter().duplicateBounds(typeReference, typeBinding);
                                typeVariableBinding.tagBits |= 0x20000L;
                                continue block7;
                            }
                            if (!bl || !this.hasErasedCandidatesCollisions(typeBinding, referenceBinding2, hashMap, typeVariableBinding, typeReference)) continue;
                            continue block7;
                        }
                        n4 = typeVariableBinding.superInterfaces.length;
                        typeVariableBinding.superInterfaces = new ReferenceBinding[n4 + 1];
                        System.arraycopy(typeVariableBinding.superInterfaces, 0, typeVariableBinding.superInterfaces, 0, n4);
                        typeVariableBinding.superInterfaces[n4] = referenceBinding;
                    }
                }
                bl2 &= (typeVariableBinding.tagBits & 0x20000L) == 0L;
            }
            ++n;
        }
    }

    public ArrayBinding createArrayType(TypeBinding typeBinding, int n) {
        if (typeBinding.isValidBinding()) {
            return this.environment().createArrayType(typeBinding, n);
        }
        return new ArrayBinding(typeBinding, n, this.environment());
    }

    public TypeVariableBinding[] createTypeVariables(TypeParameter[] typeParameterArray, Binding binding) {
        if (typeParameterArray == null || typeParameterArray.length == 0) {
            return Binding.NO_TYPE_VARIABLES;
        }
        PackageBinding packageBinding = this.compilationUnitScope().fPackage;
        int n = typeParameterArray.length;
        TypeVariableBinding[] typeVariableBindingArray = new TypeVariableBinding[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            TypeParameter typeParameter = typeParameterArray[i];
            TypeVariableBinding typeVariableBinding = new TypeVariableBinding(typeParameter.name, binding, i, this.environment());
            typeVariableBinding.fPackage = packageBinding;
            typeParameter.binding = typeVariableBinding;
            for (int j = 0; j < n2; ++j) {
                TypeVariableBinding typeVariableBinding2 = typeVariableBindingArray[j];
                if (!CharOperation.equals(typeVariableBinding2.sourceName, typeParameter.name)) continue;
                this.problemReporter().duplicateTypeParameterInType(typeParameter);
            }
            typeVariableBindingArray[n2++] = typeVariableBinding;
        }
        if (n2 != n) {
            TypeVariableBinding[] typeVariableBindingArray2 = typeVariableBindingArray;
            typeVariableBindingArray = new TypeVariableBinding[n2];
            System.arraycopy(typeVariableBindingArray2, 0, typeVariableBindingArray, 0, n2);
        }
        return typeVariableBindingArray;
    }

    public final ClassScope enclosingClassScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        }
        return null;
    }

    public final MethodScope enclosingMethodScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        }
        return null;
    }

    public final ReferenceBinding enclosingReceiverType() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return this.environment().convertToParameterizedType(((ClassScope)scope).referenceContext.binding);
        } while ((scope = scope.parent) != null);
        return null;
    }

    public ReferenceContext enclosingReferenceContext() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            switch (scope.kind) {
                case 2: {
                    return ((MethodScope)scope).referenceContext;
                }
                case 3: {
                    return ((ClassScope)scope).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)scope).referenceContext;
                }
            }
        }
        return null;
    }

    public final SourceTypeBinding enclosingSourceType() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return ((ClassScope)scope).referenceContext.binding;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final LookupEnvironment environment() {
        Scope scope;
        Scope scope2 = this;
        while ((scope = scope2.parent) != null) {
            scope2 = scope;
        }
        return ((CompilationUnitScope)scope2).environment;
    }

    protected MethodBinding findDefaultAbstractMethod(ReferenceBinding referenceBinding, char[] cArray, TypeBinding[] typeBindingArray, InvocationSite invocationSite, ReferenceBinding referenceBinding2, ObjectVector objectVector, MethodBinding methodBinding) {
        int n = objectVector.size;
        for (ReferenceBinding referenceBinding3 = referenceBinding2; referenceBinding3 != null; referenceBinding3 = referenceBinding3.superclass()) {
            this.findMethodInSuperInterfaces(referenceBinding3, cArray, objectVector, invocationSite);
        }
        MethodBinding[] methodBindingArray = null;
        int n2 = 0;
        MethodBinding methodBinding2 = null;
        int n3 = objectVector.size;
        if (n3 > n) {
            for (int i = n; i < n3; ++i) {
                MethodBinding methodBinding3 = (MethodBinding)objectVector.elementAt(i);
                MethodBinding methodBinding4 = this.computeCompatibleMethod(methodBinding3, typeBindingArray, invocationSite);
                if (methodBinding4 == null) continue;
                if (methodBinding4.isValidBinding()) {
                    if (methodBinding != null && this.environment().methodVerifier().areMethodsCompatible(methodBinding, methodBinding4)) continue;
                    if (n2 == 0) {
                        methodBindingArray = new MethodBinding[n3 - n + 1];
                        if (methodBinding != null) {
                            methodBindingArray[n2++] = methodBinding;
                        }
                    }
                    methodBindingArray[n2++] = methodBinding4;
                    continue;
                }
                if (methodBinding2 != null) continue;
                methodBinding2 = methodBinding4;
            }
        }
        if (n2 < 2) {
            if (methodBinding == null) {
                if (n2 == 0) {
                    return methodBinding2;
                }
                methodBinding = methodBindingArray[0];
            }
            this.compilationUnitScope().recordTypeReferences(methodBinding.thrownExceptions);
            return methodBinding;
        }
        if (this.compilerOptions().complianceLevel >= 0x300000L) {
            return this.mostSpecificMethodBinding(methodBindingArray, n2, typeBindingArray, invocationSite, referenceBinding);
        }
        return this.mostSpecificInterfaceMethodBinding(methodBindingArray, n2, invocationSite);
    }

    public ReferenceBinding findDirectMemberType(char[] cArray, ReferenceBinding referenceBinding) {
        if ((referenceBinding.tagBits & 0x10000L) != 0L) {
            return null;
        }
        ReferenceBinding referenceBinding2 = this.enclosingReceiverType();
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordReference(referenceBinding, cArray);
        ReferenceBinding referenceBinding3 = referenceBinding.getMemberType(cArray);
        if (referenceBinding3 != null) {
            compilationUnitScope.recordTypeReference(referenceBinding3);
            if (referenceBinding2 == null) {
                TypeDeclaration[] typeDeclarationArray;
                if (referenceBinding3.canBeSeenBy(this.getCurrentPackage())) {
                    return referenceBinding3;
                }
                if (this instanceof CompilationUnitScope && (typeDeclarationArray = ((CompilationUnitScope)this).referenceContext.types) != null) {
                    int n = typeDeclarationArray.length;
                    for (int i = 0; i < n; ++i) {
                        if (!referenceBinding3.canBeSeenBy(referenceBinding, typeDeclarationArray[i].binding)) continue;
                        return referenceBinding3;
                    }
                }
            } else if (referenceBinding3.canBeSeenBy(referenceBinding, referenceBinding2)) {
                return referenceBinding3;
            }
            return new ProblemReferenceBinding(new char[][]{cArray}, referenceBinding3, 2);
        }
        return null;
    }

    public MethodBinding findExactMethod(ReferenceBinding referenceBinding, char[] cArray, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordTypeReferences(typeBindingArray);
        MethodBinding methodBinding = referenceBinding.getExactMethod(cArray, typeBindingArray, compilationUnitScope);
        if (methodBinding != null && methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES && !methodBinding.isBridge()) {
            if (this.compilerOptions().sourceLevel >= 0x310000L) {
                int n = typeBindingArray.length;
                while (--n >= 0) {
                    if (!this.isPossibleSubtypeOfRawType(typeBindingArray[n])) continue;
                    return null;
                }
            }
            compilationUnitScope.recordTypeReferences(methodBinding.thrownExceptions);
            if (methodBinding.isAbstract() && methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
                return null;
            }
            if (referenceBinding.isInterface() || methodBinding.canBeSeenBy(referenceBinding, invocationSite, this)) {
                if (typeBindingArray == Binding.NO_PARAMETERS && CharOperation.equals(cArray, TypeConstants.GETCLASS) && methodBinding.returnType.isParameterizedType()) {
                    return this.environment().createGetClassMethod(referenceBinding, methodBinding, this);
                }
                if (invocationSite.genericTypeArguments() != null) {
                    methodBinding = this.computeCompatibleMethod(methodBinding, typeBindingArray, invocationSite);
                }
                return methodBinding;
            }
        }
        return null;
    }

    public FieldBinding findField(TypeBinding typeBinding, char[] cArray, InvocationSite invocationSite, boolean bl) {
        return this.findField(typeBinding, cArray, invocationSite, bl, false);
    }

    public FieldBinding findField(TypeBinding typeBinding, char[] cArray, InvocationSite invocationSite, boolean bl, boolean bl2) {
        int n;
        Object object;
        int n2;
        Object object2;
        boolean bl3;
        Binding binding;
        CompilationUnitScope compilationUnitScope;
        block34: {
            TypeBinding typeBinding2;
            compilationUnitScope = this.compilationUnitScope();
            compilationUnitScope.recordTypeReference(typeBinding);
            switch (typeBinding.kind()) {
                case 132: {
                    return null;
                }
                case 516: 
                case 4100: 
                case 8196: {
                    binding = typeBinding.erasure();
                    if (((TypeBinding)binding).isArrayType()) {
                        typeBinding2 = ((TypeBinding)binding).leafComponentType();
                        break;
                    }
                    break block34;
                }
                case 68: {
                    typeBinding2 = typeBinding.leafComponentType();
                    break;
                }
                default: {
                    break block34;
                }
            }
            if (typeBinding2 instanceof ReferenceBinding && !((ReferenceBinding)typeBinding2).canBeSeenBy(this)) {
                return new ProblemFieldBinding((ReferenceBinding)typeBinding2, cArray, 8);
            }
            if (CharOperation.equals(cArray, TypeConstants.LENGTH)) {
                if ((typeBinding2.tagBits & 0x80L) != 0L) {
                    return new ProblemFieldBinding(ArrayBinding.ArrayLength, null, cArray, 1);
                }
                return ArrayBinding.ArrayLength;
            }
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        if (!referenceBinding.canBeSeenBy(this)) {
            return new ProblemFieldBinding(referenceBinding, cArray, 8);
        }
        referenceBinding.initializeForStaticImports();
        binding = referenceBinding.getField(cArray, bl);
        boolean bl4 = bl3 = this instanceof MethodScope && ((MethodScope)this).insideTypeAnnotation;
        if (binding != null) {
            if (bl2) {
                return binding;
            }
            if (invocationSite == null || bl3 ? ((FieldBinding)binding).canBeSeenBy(this.getCurrentPackage()) : ((FieldBinding)binding).canBeSeenBy(referenceBinding, invocationSite, this)) {
                return binding;
            }
            return new ProblemFieldBinding((FieldBinding)binding, ((FieldBinding)binding).declaringClass, cArray, 2);
        }
        ReferenceBinding[] referenceBindingArray = null;
        int n3 = 0;
        Binding binding2 = null;
        boolean bl5 = true;
        Binding binding3 = null;
        while (bl5) {
            object2 = referenceBinding.superInterfaces();
            if (object2 != null && object2 != Binding.NO_SUPERINTERFACES) {
                if (referenceBindingArray == null) {
                    referenceBindingArray = object2;
                    n3 = referenceBindingArray.length;
                } else {
                    n2 = ((ReferenceBinding[])object2).length;
                    if (n3 + n2 >= referenceBindingArray.length) {
                        ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                        referenceBindingArray = new ReferenceBinding[n3 + n2 + 5];
                        System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n3);
                    }
                    block6: for (int i = 0; i < n2; ++i) {
                        object = object2[i];
                        for (n = 0; n < n3; ++n) {
                            if (object == referenceBindingArray[n]) continue block6;
                        }
                        referenceBindingArray[n3++] = object;
                    }
                }
            }
            if ((referenceBinding = referenceBinding.superclass()) == null) break;
            compilationUnitScope.recordTypeReference(referenceBinding);
            referenceBinding.initializeForStaticImports();
            binding = (referenceBinding = (ReferenceBinding)referenceBinding.capture(this, invocationSite == null ? 0 : invocationSite.sourceEnd())).getField(cArray, bl);
            if (binding == null) continue;
            if (bl2) {
                return binding;
            }
            bl5 = false;
            if (((FieldBinding)binding).canBeSeenBy(typeBinding, invocationSite, this)) {
                if (binding2 == null) {
                    binding2 = binding;
                    continue;
                }
                return new ProblemFieldBinding((FieldBinding)binding2, ((FieldBinding)binding2).declaringClass, cArray, 3);
            }
            if (binding3 != null) continue;
            binding3 = binding;
        }
        if (referenceBindingArray != null) {
            object2 = null;
            for (n2 = 0; n2 < n3; ++n2) {
                ReferenceBinding referenceBinding2 = referenceBindingArray[n2];
                compilationUnitScope.recordTypeReference(referenceBinding2);
                binding = referenceBinding2.getField(cArray, true);
                if (binding != null) {
                    if (bl2) {
                        return binding;
                    }
                    if (binding2 == null) {
                        binding2 = binding;
                        continue;
                    }
                    object2 = new ProblemFieldBinding((FieldBinding)binding2, ((FieldBinding)binding2).declaringClass, cArray, 3);
                    break;
                }
                object = referenceBinding2.superInterfaces();
                if (object == null || object == Binding.NO_SUPERINTERFACES) continue;
                n = ((ReferenceBinding[])object).length;
                if (n3 + n >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n3 + n + 5];
                    System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n3);
                }
                block9: for (int i = 0; i < n; ++i) {
                    ReferenceBinding referenceBinding3 = object[i];
                    for (int j = 0; j < n3; ++j) {
                        if (referenceBinding3 == referenceBindingArray[j]) continue block9;
                    }
                    referenceBindingArray[n3++] = referenceBinding3;
                }
            }
            if (object2 != null) {
                return object2;
            }
        }
        if (binding2 != null) {
            return binding2;
        }
        if (binding3 != null) {
            return new ProblemFieldBinding((FieldBinding)binding3, referenceBinding, cArray, 2);
        }
        return null;
    }

    public ReferenceBinding findMemberType(char[] cArray, ReferenceBinding referenceBinding) {
        int n;
        Object object;
        Object object2;
        if ((referenceBinding.tagBits & 0x10000L) != 0L) {
            return null;
        }
        SourceTypeBinding sourceTypeBinding = this.enclosingSourceType();
        PackageBinding packageBinding = this.getCurrentPackage();
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordReference(referenceBinding, cArray);
        ReferenceBinding referenceBinding2 = referenceBinding.getMemberType(cArray);
        if (referenceBinding2 != null) {
            compilationUnitScope.recordTypeReference(referenceBinding2);
            if (sourceTypeBinding == null || this.parent == compilationUnitScope && (sourceTypeBinding.tagBits & 0x40000L) == 0L ? referenceBinding2.canBeSeenBy(packageBinding) : referenceBinding2.canBeSeenBy(referenceBinding, sourceTypeBinding)) {
                return referenceBinding2;
            }
            return new ProblemReferenceBinding(new char[][]{cArray}, referenceBinding2, 2);
        }
        ReferenceBinding referenceBinding3 = referenceBinding;
        ReferenceBinding[] referenceBindingArray = null;
        int n2 = 0;
        ReferenceBinding referenceBinding4 = null;
        boolean bl = true;
        ReferenceBinding referenceBinding5 = null;
        while (bl) {
            object2 = referenceBinding3.superInterfaces();
            if (object2 == null) {
                ReferenceBinding referenceBinding6;
                ReferenceBinding referenceBinding7 = referenceBinding6 = referenceBinding3.isParameterizedType() ? ((ParameterizedTypeBinding)referenceBinding3).genericType() : referenceBinding3;
                if (referenceBinding6.isHierarchyBeingConnected()) {
                    return null;
                }
                ((SourceTypeBinding)referenceBinding6).scope.connectTypeHierarchy();
                object2 = referenceBinding3.superInterfaces();
            }
            if (object2 != null && object2 != Binding.NO_SUPERINTERFACES) {
                if (referenceBindingArray == null) {
                    referenceBindingArray = object2;
                    n2 = referenceBindingArray.length;
                } else {
                    int n3 = ((ReferenceBinding[])object2).length;
                    if (n2 + n3 >= referenceBindingArray.length) {
                        ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                        referenceBindingArray = new ReferenceBinding[n2 + n3 + 5];
                        System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n2);
                    }
                    block1: for (int i = 0; i < n3; ++i) {
                        object = object2[i];
                        for (n = 0; n < n2; ++n) {
                            if (object == referenceBindingArray[n]) continue block1;
                        }
                        referenceBindingArray[n2++] = object;
                    }
                }
            }
            if ((referenceBinding3 = referenceBinding3.superclass()) == null) break;
            compilationUnitScope.recordReference(referenceBinding3, cArray);
            referenceBinding2 = referenceBinding3.getMemberType(cArray);
            if (referenceBinding2 == null) continue;
            compilationUnitScope.recordTypeReference(referenceBinding2);
            bl = false;
            if (sourceTypeBinding == null ? referenceBinding2.canBeSeenBy(packageBinding) : referenceBinding2.canBeSeenBy(referenceBinding, sourceTypeBinding)) {
                if (referenceBinding4 == null) {
                    referenceBinding4 = referenceBinding2;
                    continue;
                }
                return new ProblemReferenceBinding(new char[][]{cArray}, referenceBinding4, 3);
            }
            referenceBinding5 = referenceBinding2;
        }
        if (referenceBindingArray != null) {
            object2 = null;
            for (int i = 0; i < n2; ++i) {
                void var15_19 = referenceBindingArray[i];
                compilationUnitScope.recordReference((ReferenceBinding)var15_19, cArray);
                referenceBinding2 = var15_19.getMemberType(cArray);
                if (referenceBinding2 != null) {
                    compilationUnitScope.recordTypeReference(referenceBinding2);
                    if (referenceBinding4 == null) {
                        referenceBinding4 = referenceBinding2;
                        continue;
                    }
                    object2 = new ProblemReferenceBinding(new char[][]{cArray}, referenceBinding4, 3);
                    break;
                }
                object = var15_19.superInterfaces();
                if (object == null || object == Binding.NO_SUPERINTERFACES) continue;
                n = ((ReferenceBinding[])object).length;
                if (n2 + n >= referenceBindingArray.length) {
                    ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                    referenceBindingArray = new ReferenceBinding[n2 + n + 5];
                    System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n2);
                }
                block4: for (int j = 0; j < n; ++j) {
                    ReferenceBinding referenceBinding8 = object[j];
                    for (int k = 0; k < n2; ++k) {
                        if (referenceBinding8 == referenceBindingArray[k]) continue block4;
                    }
                    referenceBindingArray[n2++] = referenceBinding8;
                }
            }
            if (object2 != null) {
                return object2;
            }
        }
        if (referenceBinding4 != null) {
            return referenceBinding4;
        }
        if (referenceBinding5 != null) {
            return new ProblemReferenceBinding(new char[][]{cArray}, referenceBinding5, 2);
        }
        return null;
    }

    public MethodBinding findMethod(ReferenceBinding referenceBinding, char[] cArray, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        return this.findMethod(referenceBinding, cArray, typeBindingArray, invocationSite, false);
    }

    public MethodBinding findMethod(ReferenceBinding referenceBinding, char[] cArray, TypeBinding[] typeBindingArray, InvocationSite invocationSite, boolean bl) {
        boolean bl2;
        MethodBinding methodBinding;
        MethodBinding methodBinding2;
        int n;
        int n2;
        long l;
        ReferenceBinding referenceBinding2 = referenceBinding;
        boolean bl3 = referenceBinding.isInterface();
        ObjectVector objectVector = new ObjectVector(3);
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordTypeReferences(typeBindingArray);
        if (bl3) {
            compilationUnitScope.recordTypeReference(referenceBinding);
            Object[] objectArray = referenceBinding.getMethods(cArray, typeBindingArray.length);
            if (objectArray.length > 0) {
                objectVector.addAll(objectArray);
            }
            this.findMethodInSuperInterfaces(referenceBinding, cArray, objectVector, invocationSite);
            referenceBinding2 = this.getJavaLangObject();
        }
        boolean bl4 = (l = this.compilerOptions().complianceLevel) >= 0x300000L;
        boolean bl5 = l >= 0x310000L;
        ReferenceBinding referenceBinding3 = referenceBinding2;
        MethodVerifier methodVerifier = this.environment().methodVerifier();
        while (referenceBinding2 != null) {
            compilationUnitScope.recordTypeReference(referenceBinding2);
            referenceBinding2 = (ReferenceBinding)referenceBinding2.capture(this, invocationSite == null ? 0 : invocationSite.sourceEnd());
            Object[] objectArray = referenceBinding2.getMethods(cArray, typeBindingArray.length);
            int n3 = objectArray.length;
            if (n3 > 0) {
                Object object;
                int n4;
                if (bl4 && (bl3 || objectVector.size > 0)) {
                    n4 = n3;
                    block8: for (n2 = 0; n2 < n4; ++n2) {
                        object = objectArray[n2];
                        if (object == null) continue;
                        if (bl3 && !((MethodBinding)object).isPublic()) {
                            --n3;
                            objectArray[n2] = null;
                            continue;
                        }
                        int n5 = objectVector.size;
                        for (n = 0; n < n5; ++n) {
                            methodBinding2 = (MethodBinding)objectVector.elementAt(n);
                            MethodBinding methodBinding3 = methodBinding2.original();
                            methodBinding = methodBinding3.findOriginalInheritedMethod((MethodBinding)object);
                            if (methodBinding == null || !methodVerifier.isParameterSubsignature(methodBinding3, methodBinding)) continue;
                            if (bl5 && methodBinding2.isBridge() && !((MethodBinding)object).isBridge()) continue block8;
                            --n3;
                            objectArray[n2] = null;
                            continue block8;
                        }
                    }
                }
                if (n3 > 0) {
                    if (objectArray.length == n3) {
                        objectVector.addAll(objectArray);
                    } else {
                        n4 = objectArray.length;
                        for (n2 = 0; n2 < n4; ++n2) {
                            object = objectArray[n2];
                            if (object == null) continue;
                            objectVector.add(object);
                        }
                    }
                }
            }
            referenceBinding2 = referenceBinding2.superclass();
        }
        int n6 = objectVector.size;
        MethodBinding[] methodBindingArray = null;
        n2 = 0;
        Binding binding = null;
        boolean bl6 = bl2 = bl4 && !bl3 && (referenceBinding.isAbstract() || referenceBinding.isTypeVariable());
        if (n6 > 0) {
            for (n = 0; n < n6; ++n) {
                MethodBinding methodBinding4 = (MethodBinding)objectVector.elementAt(n);
                methodBinding2 = this.computeCompatibleMethod(methodBinding4, typeBindingArray, invocationSite);
                if (methodBinding2 == null) continue;
                if (methodBinding2.isValidBinding()) {
                    if (n6 == 1 && methodBinding2.canBeSeenBy(referenceBinding, invocationSite, this)) {
                        if (bl2) {
                            return this.findDefaultAbstractMethod(referenceBinding, cArray, typeBindingArray, invocationSite, referenceBinding3, objectVector, methodBinding2);
                        }
                        compilationUnitScope.recordTypeReferences(methodBinding2.thrownExceptions);
                        return methodBinding2;
                    }
                    if (n2 == 0) {
                        methodBindingArray = new MethodBinding[n6];
                    }
                    methodBindingArray[n2++] = methodBinding2;
                    continue;
                }
                if (binding != null) continue;
                binding = methodBinding2;
            }
        }
        if (n2 == 0) {
            MethodBinding methodBinding5;
            if (binding != null) {
                switch (binding.problemId()) {
                    case 11: 
                    case 13: {
                        return binding;
                    }
                }
            }
            if ((methodBinding5 = this.findDefaultAbstractMethod(referenceBinding, cArray, typeBindingArray, invocationSite, referenceBinding3, objectVector, null)) != null) {
                return methodBinding5;
            }
            if (objectVector.size == 0) {
                return null;
            }
            if (binding != null) {
                return binding;
            }
            int n7 = -1;
            methodBinding2 = (MethodBinding)objectVector.elementAt(0);
            int n8 = typeBindingArray.length;
            n6 = objectVector.size;
            for (int i = 0; i < n6; ++i) {
                int n9;
                int n10;
                MethodBinding methodBinding6 = (MethodBinding)objectVector.elementAt(i);
                TypeBinding[] typeBindingArray2 = methodBinding6.parameters;
                int n11 = typeBindingArray2.length;
                int n12 = 0;
                block13: for (n10 = 0; n10 < n8; ++n10) {
                    TypeBinding typeBinding = typeBindingArray[n10];
                    int n13 = n9 = n10 == 0 ? 0 : n10 - 1;
                    while (n9 < n11 && n9 < n10 + 1) {
                        if (typeBindingArray2[n9] == typeBinding) {
                            ++n12;
                            continue block13;
                        }
                        ++n9;
                    }
                }
                if (n12 < n7) continue;
                if (n12 == n7) {
                    n10 = n11 < n8 ? 2 * (n8 - n11) : n11 - n8;
                    int n14 = methodBinding2.parameters.length;
                    int n15 = n9 = n14 < n8 ? 2 * (n8 - n14) : n14 - n8;
                    if (n10 >= n9) continue;
                }
                n7 = n12;
                methodBinding2 = methodBinding6;
            }
            return new ProblemMethodBinding(methodBinding2, methodBinding2.selector, typeBindingArray, 1);
        }
        n = 0;
        if (bl3) {
            if (n2 == 1) {
                compilationUnitScope.recordTypeReferences(methodBindingArray[0].thrownExceptions);
                return methodBindingArray[0];
            }
            n = n2;
        } else {
            for (int i = 0; i < n2; ++i) {
                methodBinding2 = methodBindingArray[i];
                if (!methodBinding2.canBeSeenBy(referenceBinding, invocationSite, this)) continue;
                if (n != i) {
                    methodBindingArray[i] = null;
                    methodBindingArray[n] = methodBinding2;
                }
                ++n;
            }
            switch (n) {
                case 0: {
                    MethodBinding methodBinding7 = this.findDefaultAbstractMethod(referenceBinding, cArray, typeBindingArray, invocationSite, referenceBinding3, objectVector, null);
                    if (methodBinding7 != null) {
                        return methodBinding7;
                    }
                    return new ProblemMethodBinding(methodBindingArray[0], methodBindingArray[0].selector, methodBindingArray[0].parameters, 2);
                }
                case 1: {
                    if (bl2) {
                        return this.findDefaultAbstractMethod(referenceBinding, cArray, typeBindingArray, invocationSite, referenceBinding3, objectVector, (MethodBinding)methodBindingArray[0]);
                    }
                    compilationUnitScope.recordTypeReferences(methodBindingArray[0].thrownExceptions);
                    return methodBindingArray[0];
                }
            }
        }
        if (l <= 0x2F0000L) {
            ReferenceBinding referenceBinding4 = methodBindingArray[0].declaringClass;
            return !referenceBinding4.isInterface() ? this.mostSpecificClassMethodBinding(methodBindingArray, n, invocationSite) : this.mostSpecificInterfaceMethodBinding(methodBindingArray, n, invocationSite);
        }
        if (this.compilerOptions().sourceLevel >= 0x310000L) {
            for (int i = 0; i < n; ++i) {
                methodBinding2 = methodBindingArray[i];
                if (methodBinding2 instanceof ParameterizedGenericMethodBinding) {
                    methodBinding2 = ((ParameterizedGenericMethodBinding)methodBinding2).originalMethod;
                }
                if (!methodBinding2.hasSubstitutedParameters()) continue;
                for (int j = i + 1; j < n; ++j) {
                    methodBinding = methodBindingArray[j];
                    if (!methodBinding.hasSubstitutedParameters() || methodBinding != methodBinding2 && (methodBinding2.declaringClass != methodBinding.declaringClass || !methodBinding2.areParametersEqual(methodBinding))) continue;
                    return new ProblemMethodBinding(methodBindingArray[i], methodBindingArray[i].selector, methodBindingArray[i].parameters, 3);
                }
            }
        }
        if (bl) {
            MethodBinding[] methodBindingArray2 = new MethodBinding[n];
            int n16 = 0;
            for (int i = 0; i < n; ++i) {
                if (!methodBindingArray[i].isStatic()) continue;
                methodBindingArray2[n16++] = methodBindingArray[i];
            }
            if (n16 == 1) {
                return methodBindingArray2[0];
            }
            if (n16 > 1) {
                return this.mostSpecificMethodBinding(methodBindingArray2, n16, typeBindingArray, invocationSite, referenceBinding);
            }
        }
        MethodBinding methodBinding8 = this.mostSpecificMethodBinding(methodBindingArray, n, typeBindingArray, invocationSite, referenceBinding);
        if (bl2) {
            if (methodBinding8.isValidBinding()) {
                return this.findDefaultAbstractMethod(referenceBinding, cArray, typeBindingArray, invocationSite, referenceBinding3, objectVector, methodBinding8);
            }
            MethodBinding methodBinding9 = this.findDefaultAbstractMethod(referenceBinding, cArray, typeBindingArray, invocationSite, referenceBinding3, objectVector, null);
            if (methodBinding9 != null && methodBinding9.isValidBinding()) {
                return methodBinding9;
            }
        }
        return methodBinding8;
    }

    public MethodBinding findMethodForArray(ArrayBinding arrayBinding, char[] cArray, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        TypeBinding typeBinding = arrayBinding.leafComponentType();
        if (typeBinding instanceof ReferenceBinding && !((ReferenceBinding)typeBinding).canBeSeenBy(this)) {
            return new ProblemMethodBinding(cArray, Binding.NO_PARAMETERS, (ReferenceBinding)typeBinding, 8);
        }
        ReferenceBinding referenceBinding = this.getJavaLangObject();
        MethodBinding methodBinding = referenceBinding.getExactMethod(cArray, typeBindingArray, null);
        if (methodBinding != null) {
            if (typeBindingArray == Binding.NO_PARAMETERS) {
                switch (cArray[0]) {
                    case 'c': {
                        if (!CharOperation.equals(cArray, TypeConstants.CLONE)) break;
                        return this.environment().computeArrayClone(methodBinding);
                    }
                    case 'g': {
                        if (!CharOperation.equals(cArray, TypeConstants.GETCLASS) || !methodBinding.returnType.isParameterizedType()) break;
                        return this.environment().createGetClassMethod(arrayBinding, methodBinding, this);
                    }
                }
            }
            if (methodBinding.canBeSeenBy(arrayBinding, invocationSite, this)) {
                return methodBinding;
            }
        }
        if ((methodBinding = this.findMethod(referenceBinding, cArray, typeBindingArray, invocationSite)) == null) {
            return new ProblemMethodBinding(cArray, typeBindingArray, 1);
        }
        return methodBinding;
    }

    protected void findMethodInSuperInterfaces(ReferenceBinding referenceBinding, char[] cArray, ObjectVector objectVector, InvocationSite invocationSite) {
        ReferenceBinding[] referenceBindingArray = referenceBinding.superInterfaces();
        if (referenceBindingArray != null && referenceBindingArray != Binding.NO_SUPERINTERFACES) {
            ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
            int n = referenceBindingArray2.length;
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                referenceBinding = referenceBindingArray2[i];
                this.compilationUnitScope().recordTypeReference(referenceBinding);
                referenceBinding = (ReferenceBinding)referenceBinding.capture(this, invocationSite == null ? 0 : invocationSite.sourceEnd());
                Object[] objectArray = referenceBinding.getMethods(cArray);
                if (objectArray.length > 0) {
                    n3 = objectVector.size;
                    if (n3 > 0) {
                        int n4 = objectArray.length;
                        block1: for (n2 = 0; n2 < n4; ++n2) {
                            Object object = objectArray[n2];
                            for (int j = 0; j < n3; ++j) {
                                if (object == objectVector.elementAt(j)) continue block1;
                            }
                            objectVector.add(object);
                        }
                    } else {
                        objectVector.addAll(objectArray);
                    }
                }
                if ((referenceBindingArray = referenceBinding.superInterfaces()) == null || referenceBindingArray == Binding.NO_SUPERINTERFACES) continue;
                n3 = referenceBindingArray.length;
                if (n + n3 >= referenceBindingArray2.length) {
                    ReferenceBinding[] referenceBindingArray3 = referenceBindingArray2;
                    referenceBindingArray2 = new ReferenceBinding[n + n3 + 5];
                    System.arraycopy(referenceBindingArray3, 0, referenceBindingArray2, 0, n);
                }
                block3: for (n2 = 0; n2 < n3; ++n2) {
                    ReferenceBinding referenceBinding2 = referenceBindingArray[n2];
                    for (int j = 0; j < n; ++j) {
                        if (referenceBinding2 == referenceBindingArray2[j]) continue block3;
                    }
                    referenceBindingArray2[n++] = referenceBinding2;
                }
            }
        }
    }

    public ReferenceBinding findType(char[] cArray, PackageBinding packageBinding, PackageBinding packageBinding2) {
        this.compilationUnitScope().recordReference(packageBinding.compoundName, cArray);
        ReferenceBinding referenceBinding = packageBinding.getType(cArray);
        if (referenceBinding == null) {
            return null;
        }
        if (referenceBinding.isValidBinding() && packageBinding != packageBinding2 && !referenceBinding.canBeSeenBy(packageBinding2)) {
            return new ProblemReferenceBinding(new char[][]{cArray}, referenceBinding, 2);
        }
        return referenceBinding;
    }

    public LocalVariableBinding findVariable(char[] cArray) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Binding getBinding(char[] cArray, int n, InvocationSite invocationSite, boolean bl) {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        LookupEnvironment lookupEnvironment = compilationUnitScope.environment;
        try {
            lookupEnvironment.missingClassFileLocation = invocationSite;
            Binding binding = null;
            Object object = null;
            if ((n & 3) != 0) {
                Object object2;
                Object object3;
                Binding binding2;
                ImportBinding[] importBindingArray;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                Object object4 = null;
                Object object5 = null;
                Scope scope = this;
                int n2 = 0;
                int n3 = 0;
                Binding binding3 = null;
                block27: while (true) {
                    switch (scope.kind) {
                        case 2: {
                            importBindingArray = (MethodScope)scope;
                            n4 |= importBindingArray.isStatic;
                            bl3 |= importBindingArray.isConstructorCall;
                            bl4 = importBindingArray.insideTypeAnnotation;
                        }
                        case 1: {
                            Object object6;
                            LocalVariableBinding localVariableBinding = scope.findVariable(cArray);
                            if (localVariableBinding == null) break;
                            if (object4 != null && ((Binding)object4).isValidBinding()) {
                                object6 = new ProblemFieldBinding((FieldBinding)object4, ((FieldBinding)object4).declaringClass, cArray, 5);
                                return object6;
                            }
                            if (n2 > 0) {
                                invocationSite.setDepth(n2);
                            }
                            object6 = localVariableBinding;
                            return object6;
                        }
                        case 3: {
                            Object object6 = (ClassScope)scope;
                            binding2 = ((Scope)object6).enclosingReceiverType();
                            if (!bl4 && (object3 = ((Scope)object6).findField((TypeBinding)binding2, cArray, invocationSite, bl)) != null) {
                                if (((Binding)object3).problemId() == 3) {
                                    if (object4 != null && ((Binding)object4).problemId() != 2) {
                                        object2 = new ProblemFieldBinding((FieldBinding)object4, ((FieldBinding)object4).declaringClass, cArray, 5);
                                        return object2;
                                    }
                                    object2 = object3;
                                    return object2;
                                }
                                object2 = null;
                                if (((Binding)object3).isValidBinding()) {
                                    if (!((FieldBinding)object3).isStatic()) {
                                        int n4;
                                        if (bl3) {
                                            object2 = new ProblemFieldBinding((FieldBinding)object3, ((FieldBinding)object3).declaringClass, cArray, 6);
                                        } else if (n4 != 0) {
                                            object2 = new ProblemFieldBinding((FieldBinding)object3, ((FieldBinding)object3).declaringClass, cArray, 7);
                                        }
                                    }
                                    if (binding2 == ((FieldBinding)object3).declaringClass || this.compilerOptions().complianceLevel >= 0x300000L) {
                                        if (object4 == null) {
                                            if (n2 > 0) {
                                                invocationSite.setDepth(n2);
                                                invocationSite.setActualReceiverType((ReferenceBinding)binding2);
                                            }
                                            Object object7 = object2 == null ? object3 : object2;
                                            return object7;
                                        }
                                        if (((Binding)object4).isValidBinding() && ((FieldBinding)object4).declaringClass != ((FieldBinding)object3).declaringClass && ((FieldBinding)object4).declaringClass != binding3) {
                                            ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding((FieldBinding)object4, ((FieldBinding)object4).declaringClass, cArray, 5);
                                            return problemFieldBinding;
                                        }
                                    }
                                }
                                if (object4 == null || ((Binding)object4).problemId() == 2 && ((Binding)object3).problemId() != 2) {
                                    n3 = n2;
                                    binding3 = binding2;
                                    object5 = object2;
                                    object4 = object3;
                                }
                            }
                            bl4 = false;
                            ++n2;
                            n4 |= ((ReferenceBinding)binding2).isStatic();
                            object3 = scope.methodScope();
                            bl3 = object3 == null ? false : ((MethodScope)object3).isConstructorCall;
                            break;
                        }
                        case 4: {
                            break block27;
                        }
                    }
                    scope = scope.parent;
                }
                if (object5 != null) {
                    importBindingArray = object5;
                    return importBindingArray;
                }
                if (object4 != null) {
                    if (((Binding)object4).isValidBinding()) {
                        if (n3 > 0) {
                            invocationSite.setDepth(n3);
                            invocationSite.setActualReceiverType((ReferenceBinding)binding3);
                        }
                        importBindingArray = object4;
                        return importBindingArray;
                    }
                    object = object4;
                    object4 = null;
                }
                if (this.compilerOptions().sourceLevel >= 0x310000L) {
                    compilationUnitScope.faultInImports();
                    importBindingArray = compilationUnitScope.imports;
                    if (importBindingArray != null) {
                        int n5;
                        int n6 = importBindingArray.length;
                        for (n5 = 0; n5 < n6; ++n5) {
                            binding2 = importBindingArray[n5];
                            if (!((ImportBinding)binding2).isStatic() || ((ImportBinding)binding2).onDemand || !CharOperation.equals(((ImportBinding)binding2).compoundName[((ImportBinding)binding2).compoundName.length - 1], cArray) || compilationUnitScope.resolveSingleImport((ImportBinding)binding2, 13) == null || !(((ImportBinding)binding2).resolvedImport instanceof FieldBinding)) continue;
                            object4 = (FieldBinding)((ImportBinding)binding2).resolvedImport;
                            object3 = ((ImportBinding)binding2).reference;
                            if (object3 != null && bl) {
                                ((ImportReference)object3).bits |= 2;
                            }
                            invocationSite.setActualReceiverType(((FieldBinding)object4).declaringClass);
                            if (((Binding)object4).isValidBinding()) {
                                object2 = object4;
                                return object2;
                            }
                            if (object != null) continue;
                            object = object4;
                        }
                        n5 = 0;
                        int n7 = importBindingArray.length;
                        for (n6 = 0; n6 < n7; ++n6) {
                            FieldBinding fieldBinding;
                            object3 = importBindingArray[n6];
                            if (!((ImportBinding)object3).isStatic() || !((ImportBinding)object3).onDemand || !((object2 = ((ImportBinding)object3).resolvedImport) instanceof ReferenceBinding) || (fieldBinding = this.findField((ReferenceBinding)object2, cArray, invocationSite, bl)) == null) continue;
                            if (!fieldBinding.isValidBinding()) {
                                if (object != null) continue;
                                object = fieldBinding;
                                continue;
                            }
                            if (!fieldBinding.isStatic() || object4 == fieldBinding) continue;
                            ImportReference importReference = ((ImportBinding)object3).reference;
                            if (importReference != null && bl) {
                                importReference.bits |= 2;
                            }
                            if (n5 != 0) {
                                ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding((FieldBinding)object4, ((FieldBinding)object4).declaringClass, cArray, 3);
                                return problemFieldBinding;
                            }
                            object4 = fieldBinding;
                            n5 = 1;
                        }
                        if (object4 != null) {
                            invocationSite.setActualReceiverType(((FieldBinding)object4).declaringClass);
                            Object object8 = object4;
                            return object8;
                        }
                    }
                }
            }
            if ((n & 4) != 0) {
                binding = Scope.getBaseType(cArray);
                if (binding != null) {
                    TypeBinding typeBinding = binding;
                    return typeBinding;
                }
                binding = this.getTypeOrPackage(cArray, (n & 0x10) == 0 ? 4 : 20, bl);
                if (binding.isValidBinding() || n == 4) {
                    Binding binding4 = binding;
                    return binding4;
                }
            } else if ((n & 0x10) != 0) {
                compilationUnitScope.recordSimpleReference(cArray);
                binding = lookupEnvironment.getTopLevelPackage(cArray);
                if (binding != null) {
                    Binding binding5 = binding;
                    return binding5;
                }
            }
            if (object != null) {
                Binding binding6 = object;
                return binding6;
            }
            if (binding != null && binding.problemId() != 1) {
                Binding binding7 = binding;
                return binding7;
            }
            ProblemBinding problemBinding = new ProblemBinding(cArray, (ReferenceBinding)this.enclosingSourceType(), 1);
            return problemBinding;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    public MethodBinding getConstructor(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        LookupEnvironment lookupEnvironment = compilationUnitScope.environment;
        try {
            lookupEnvironment.missingClassFileLocation = invocationSite;
            compilationUnitScope.recordTypeReference(referenceBinding);
            compilationUnitScope.recordTypeReferences(typeBindingArray);
            MethodBinding methodBinding = referenceBinding.getExactConstructor(typeBindingArray);
            if (methodBinding != null && methodBinding.canBeSeenBy(invocationSite, this)) {
                if (invocationSite.genericTypeArguments() != null) {
                    methodBinding = this.computeCompatibleMethod(methodBinding, typeBindingArray, invocationSite);
                }
                MethodBinding methodBinding2 = methodBinding;
                return methodBinding2;
            }
            MethodBinding[] methodBindingArray = referenceBinding.getMethods(TypeConstants.INIT, typeBindingArray.length);
            if (methodBindingArray == Binding.NO_METHODS) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(TypeConstants.INIT, typeBindingArray, 1);
                return problemMethodBinding;
            }
            MethodBinding[] methodBindingArray2 = new MethodBinding[methodBindingArray.length];
            int n = 0;
            MethodBinding methodBinding3 = null;
            int n2 = methodBindingArray.length;
            for (int i = 0; i < n2; ++i) {
                MethodBinding methodBinding4 = this.computeCompatibleMethod(methodBindingArray[i], typeBindingArray, invocationSite);
                if (methodBinding4 == null) continue;
                if (methodBinding4.isValidBinding()) {
                    methodBindingArray2[n++] = methodBinding4;
                    continue;
                }
                if (methodBinding3 != null) continue;
                methodBinding3 = methodBinding4;
            }
            if (n == 0) {
                if (methodBinding3 == null) {
                    ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(methodBindingArray[0], TypeConstants.INIT, typeBindingArray, 1);
                    return problemMethodBinding;
                }
                MethodBinding methodBinding5 = methodBinding3;
                return methodBinding5;
            }
            MethodBinding[] methodBindingArray3 = new MethodBinding[n];
            n2 = 0;
            for (int i = 0; i < n; ++i) {
                MethodBinding methodBinding6 = methodBindingArray2[i];
                if (!methodBinding6.canBeSeenBy(invocationSite, this)) continue;
                methodBindingArray3[n2++] = methodBinding6;
            }
            if (n2 == 1) {
                MethodBinding methodBinding7 = methodBindingArray3[0];
                return methodBinding7;
            }
            if (n2 == 0) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(methodBindingArray2[0], TypeConstants.INIT, methodBindingArray2[0].parameters, 2);
                return problemMethodBinding;
            }
            MethodBinding methodBinding8 = this.mostSpecificMethodBinding(methodBindingArray3, n2, typeBindingArray, invocationSite, referenceBinding);
            return methodBinding8;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    public final PackageBinding getCurrentPackage() {
        Scope scope;
        Scope scope2 = this;
        while ((scope = scope2.parent) != null) {
            scope2 = scope;
        }
        return ((CompilationUnitScope)scope2).fPackage;
    }

    public int getDeclarationModifiers() {
        switch (this.kind) {
            case 1: 
            case 2: {
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                    if (methodBinding == null) break;
                    return methodBinding.modifiers;
                }
                SourceTypeBinding sourceTypeBinding = ((BlockScope)this).referenceType().binding;
                if (methodScope.initializedField != null) {
                    return methodScope.initializedField.modifiers;
                }
                if (sourceTypeBinding == null) break;
                return sourceTypeBinding.modifiers;
            }
            case 3: {
                SourceTypeBinding sourceTypeBinding = ((ClassScope)this).referenceType().binding;
                if (sourceTypeBinding == null) break;
                return sourceTypeBinding.modifiers;
            }
        }
        return -1;
    }

    public FieldBinding getField(TypeBinding typeBinding, char[] cArray, InvocationSite invocationSite) {
        LookupEnvironment lookupEnvironment = this.environment();
        try {
            lookupEnvironment.missingClassFileLocation = invocationSite;
            FieldBinding fieldBinding = this.findField(typeBinding, cArray, invocationSite, true);
            if (fieldBinding != null) {
                FieldBinding fieldBinding2 = fieldBinding;
                return fieldBinding2;
            }
            ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding(typeBinding instanceof ReferenceBinding ? (ReferenceBinding)typeBinding : null, cArray, 1);
            return problemFieldBinding;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public MethodBinding getImplicitMethod(char[] var1_1, TypeBinding[] var2_2, InvocationSite var3_3) {
        var4_4 = false;
        var5_5 = false;
        var6_6 = false;
        var7_7 = null;
        var8_8 = null;
        var9_9 = false;
        var10_10 = this;
        var11_11 = 0;
        var12_12 = this.compilerOptions();
        var13_13 = var12_12.complianceLevel >= 0x300000L;
        block5: while (true) {
            switch (var10_10.kind) {
                case 2: {
                    var14_14 = (MethodScope)var10_10;
                    var4_4 |= var14_14.isStatic;
                    var5_5 |= var14_14.isConstructorCall;
                    var6_6 = var14_14.insideTypeAnnotation;
                    ** GOTO lbl68
                }
                case 3: {
                    var15_15 = (ImportBinding[])var10_10;
                    var16_16 = var15_15.enclosingReceiverType();
                    if (!var6_6) {
                        var17_17 = var15_15.findExactMethod((ReferenceBinding)var16_16, var1_1, var2_2, var3_3);
                        if (var17_17 == null) {
                            var17_17 = var15_15.findMethod((ReferenceBinding)var16_16, var1_1, var2_2, var3_3);
                        }
                        if (var17_17 != null) {
                            if (var7_7 == null) {
                                if (var17_17.isValidBinding()) {
                                    if (!var17_17.isStatic() && (var5_5 || var4_4)) {
                                        if (var8_8 != null && var8_8.problemId() != 2) {
                                            return var8_8;
                                        }
                                        return new ProblemMethodBinding((MethodBinding)var17_17, var17_17.selector, var17_17.parameters, var5_5 != false ? 6 : 7);
                                    }
                                    if (var13_13 || var16_16 == var17_17.declaringClass || var16_16.getMethods(var1_1) != Binding.NO_METHODS) {
                                        if (var9_9) {
                                            return var8_8;
                                        }
                                        if (var11_11 > 0) {
                                            var3_3.setDepth(var11_11);
                                            var3_3.setActualReceiverType((ReferenceBinding)var16_16);
                                        }
                                        if (var2_2 == Binding.NO_PARAMETERS && CharOperation.equals(var1_1, TypeConstants.GETCLASS) && var17_17.returnType.isParameterizedType()) {
                                            return this.environment().createGetClassMethod((TypeBinding)var16_16, (MethodBinding)var17_17, this);
                                        }
                                        return var17_17;
                                    }
                                    if (var8_8 == null || var8_8.problemId() == 2) {
                                        if (var8_8 != null) {
                                            var8_8 = null;
                                        }
                                        if (var11_11 > 0) {
                                            var3_3.setDepth(var11_11);
                                            var3_3.setActualReceiverType((ReferenceBinding)var16_16);
                                        }
                                        var7_7 = var17_17;
                                    }
                                } else {
                                    if (var17_17.problemId() != 2 && var17_17.problemId() != 1) {
                                        return var17_17;
                                    }
                                    if (var8_8 == null) {
                                        var8_8 = var17_17;
                                    }
                                    if (!var9_9 && var17_17.problemId() == 1 && (var18_19 = ((ProblemMethodBinding)var17_17).closestMatch) != null && var18_19.canBeSeenBy((TypeBinding)var16_16, var3_3, this)) {
                                        var8_8 = var17_17;
                                        var9_9 = true;
                                    }
                                }
                            } else if (var17_17.problemId() == 3 || var7_7.declaringClass != var17_17.declaringClass && (var16_16 == var17_17.declaringClass || var16_16.getMethods(var1_1) != Binding.NO_METHODS)) {
                                return new ProblemMethodBinding((MethodBinding)var17_17, var1_1, var2_2, 5);
                            }
                        }
                    }
                    var6_6 = false;
                    ++var11_11;
                    var4_4 |= var16_16.isStatic();
                    var17_17 = var10_10.methodScope();
                    var5_5 = var17_17 == null ? false : var17_17.isConstructorCall;
                    ** GOTO lbl68
                }
                case 4: {
                    break block5;
                }
lbl68:
                // 3 sources

                default: {
                    var10_10 = var10_10.parent;
                    continue block5;
                }
            }
            break;
        }
        if (var4_4 && var12_12.sourceLevel >= 0x310000L) {
            if (var8_8 != null) {
                if (var8_8.declaringClass != null && var8_8.declaringClass.id == 1) {
                    return var8_8;
                }
                if (var8_8.problemId() == 1 && var9_9) {
                    return var8_8;
                }
            }
            var14_14 = (CompilationUnitScope)var10_10;
            var14_14.faultInImports();
            var15_15 = var14_14.imports;
            if (var15_15 != null) {
                var16_16 = null;
                var17_18 = false;
                var19_22 = var15_15.length;
                for (var18_20 = 0; var18_20 < var19_22; ++var18_20) {
                    var20_23 = var15_15[var18_20];
                    if (!var20_23.isStatic()) continue;
                    var21_24 = var20_23.resolvedImport;
                    var22_25 = null;
                    if (var20_23.onDemand) {
                        if (!var17_18 && var21_24 instanceof ReferenceBinding) {
                            var22_25 = this.findMethod((ReferenceBinding)var21_24, var1_1, var2_2, var3_3, true);
                        }
                    } else if (var21_24 instanceof MethodBinding) {
                        var23_26 = (MethodBinding)var21_24;
                        if (CharOperation.equals(var23_26.selector, var1_1)) {
                            var22_25 = this.findMethod(var23_26.declaringClass, var1_1, var2_2, var3_3, true);
                        }
                    } else if (var21_24 instanceof FieldBinding) {
                        var23_26 = (FieldBinding)var21_24;
                        if (CharOperation.equals(var23_26.name, var1_1) && (var25_28 = this.getType(var24_27 /* !! */  = var20_23.reference.tokens, var24_27 /* !! */ .length - 1)) != null) {
                            var22_25 = this.findMethod((ReferenceBinding)var25_28, var1_1, var2_2, var3_3, true);
                        }
                    }
                    if (var22_25 == null || var22_25 == var8_8) continue;
                    if (!var22_25.isValidBinding()) {
                        if (var8_8 != null) continue;
                        var8_8 = var22_25;
                        continue;
                    }
                    if (!var22_25.isStatic()) continue;
                    var23_26 = this.computeCompatibleMethod((MethodBinding)var22_25, var2_2, var3_3);
                    if (var23_26 != null) {
                        if (var23_26.isValidBinding()) {
                            if (var23_26.canBeSeenBy(var14_14.fPackage)) {
                                if (var16_16 != null && var16_16.contains(var23_26)) continue;
                                var24_27 /* !! */  = (char[][])var20_23.reference;
                                if (var24_27 /* !! */  != null) {
                                    var24_27 /* !! */ .bits |= 2;
                                }
                                if (!var17_18 && !var20_23.onDemand) {
                                    var16_16 = null;
                                    var17_18 = true;
                                }
                                if (var16_16 == null) {
                                    var16_16 = new ObjectVector(3);
                                }
                                var16_16.add(var23_26);
                                continue;
                            }
                            if (var8_8 != null) continue;
                            var8_8 = new ProblemMethodBinding((MethodBinding)var23_26, var1_1, var23_26.parameters, 2);
                            continue;
                        }
                        if (var8_8 != null) continue;
                        var8_8 = var23_26;
                        continue;
                    }
                    if (var8_8 != null) continue;
                    var8_8 = new ProblemMethodBinding((MethodBinding)var22_25, var1_1, var2_2, 1);
                }
                if (var16_16 != null) {
                    var18_21 = new MethodBinding[var16_16.size];
                    var16_16.copyInto(var18_21);
                    var7_7 = this.mostSpecificMethodBinding((MethodBinding[])var18_21, var18_21.length, var2_2, var3_3, null);
                }
            }
        }
        if (var7_7 != null) {
            var3_3.setActualReceiverType(var7_7.declaringClass);
            return var7_7;
        }
        if (var8_8 != null) {
            return var8_8;
        }
        return new ProblemMethodBinding(var1_1, var2_2, 1);
    }

    public final ReferenceBinding getJavaIoSerializable() {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordQualifiedReference(TypeConstants.JAVA_IO_SERIALIZABLE);
        return compilationUnitScope.environment.getResolvedType(TypeConstants.JAVA_IO_SERIALIZABLE, this);
    }

    public final ReferenceBinding getJavaLangAnnotationAnnotation() {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION);
        return compilationUnitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION, this);
    }

    public final ReferenceBinding getJavaLangAssertionError() {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_ASSERTIONERROR);
        return compilationUnitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_ASSERTIONERROR, this);
    }

    public final ReferenceBinding getJavaLangClass() {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_CLASS);
        return compilationUnitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_CLASS, this);
    }

    public final ReferenceBinding getJavaLangCloneable() {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_CLONEABLE);
        return compilationUnitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_CLONEABLE, this);
    }

    public final ReferenceBinding getJavaLangEnum() {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_ENUM);
        return compilationUnitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_ENUM, this);
    }

    public final ReferenceBinding getJavaLangIterable() {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_ITERABLE);
        return compilationUnitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_ITERABLE, this);
    }

    public final ReferenceBinding getJavaLangObject() {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_OBJECT);
        return compilationUnitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, this);
    }

    public final ReferenceBinding getJavaLangString() {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_STRING);
        return compilationUnitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_STRING, this);
    }

    public final ReferenceBinding getJavaLangThrowable() {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordQualifiedReference(TypeConstants.JAVA_LANG_THROWABLE);
        return compilationUnitScope.environment.getResolvedType(TypeConstants.JAVA_LANG_THROWABLE, this);
    }

    public final ReferenceBinding getJavaUtilIterator() {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        compilationUnitScope.recordQualifiedReference(TypeConstants.JAVA_UTIL_ITERATOR);
        return compilationUnitScope.environment.getResolvedType(TypeConstants.JAVA_UTIL_ITERATOR, this);
    }

    public final ReferenceBinding getMemberType(char[] cArray, ReferenceBinding referenceBinding) {
        ReferenceBinding referenceBinding2 = this.findMemberType(cArray, referenceBinding);
        if (referenceBinding2 != null) {
            return referenceBinding2;
        }
        char[][] cArrayArray = new char[][]{cArray};
        return new ProblemReferenceBinding(cArrayArray, null, 1);
    }

    public MethodBinding getMethod(TypeBinding typeBinding, char[] cArray, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
        LookupEnvironment lookupEnvironment = compilationUnitScope.environment;
        try {
            lookupEnvironment.missingClassFileLocation = invocationSite;
            switch (typeBinding.kind()) {
                case 132: {
                    ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(cArray, typeBindingArray, 1);
                    return problemMethodBinding;
                }
                case 68: {
                    compilationUnitScope.recordTypeReference(typeBinding);
                    MethodBinding methodBinding = this.findMethodForArray((ArrayBinding)typeBinding, cArray, typeBindingArray, invocationSite);
                    return methodBinding;
                }
            }
            compilationUnitScope.recordTypeReference(typeBinding);
            ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
            if (!referenceBinding.canBeSeenBy(this)) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(cArray, typeBindingArray, 8);
                return problemMethodBinding;
            }
            MethodBinding methodBinding = this.findExactMethod(referenceBinding, cArray, typeBindingArray, invocationSite);
            if (methodBinding != null) {
                MethodBinding methodBinding2 = methodBinding;
                return methodBinding2;
            }
            methodBinding = this.findMethod(referenceBinding, cArray, typeBindingArray, invocationSite);
            if (methodBinding == null) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(cArray, typeBindingArray, 1);
                return problemMethodBinding;
            }
            if (!methodBinding.isValidBinding()) {
                MethodBinding methodBinding3 = methodBinding;
                return methodBinding3;
            }
            if (typeBindingArray == Binding.NO_PARAMETERS && CharOperation.equals(cArray, TypeConstants.GETCLASS) && methodBinding.returnType.isParameterizedType()) {
                ParameterizedMethodBinding parameterizedMethodBinding = this.environment().createGetClassMethod(typeBinding, methodBinding, this);
                return parameterizedMethodBinding;
            }
            MethodBinding methodBinding4 = methodBinding;
            return methodBinding4;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    public final Binding getPackage(char[][] cArray) {
        this.compilationUnitScope().recordQualifiedReference(cArray);
        Binding binding = this.getTypeOrPackage(cArray[0], 20, true);
        if (binding == null) {
            char[][] cArrayArray = new char[][]{cArray[0]};
            return new ProblemReferenceBinding(cArrayArray, this.environment().createMissingType(null, cArray), 1);
        }
        if (!binding.isValidBinding()) {
            if (binding instanceof PackageBinding) {
                char[][] cArrayArray = new char[][]{cArray[0]};
                return new ProblemReferenceBinding(cArrayArray, null, 1);
            }
            return binding;
        }
        if (!(binding instanceof PackageBinding)) {
            return null;
        }
        int n = 1;
        int n2 = cArray.length;
        PackageBinding packageBinding = (PackageBinding)binding;
        while (n < n2) {
            if ((binding = packageBinding.getTypeOrPackage(cArray[n++])) == null) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n), null, 1);
            }
            if (!binding.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n), binding instanceof ReferenceBinding ? (ReferenceBinding)((ReferenceBinding)binding).closestMatch() : null, binding.problemId());
            }
            if (!(binding instanceof PackageBinding)) {
                return packageBinding;
            }
            packageBinding = (PackageBinding)binding;
        }
        return new ProblemReferenceBinding(cArray, null, 1);
    }

    public final TypeBinding getType(char[] cArray) {
        TypeBinding typeBinding = Scope.getBaseType(cArray);
        if (typeBinding != null) {
            return typeBinding;
        }
        return (ReferenceBinding)this.getTypeOrPackage(cArray, 4, true);
    }

    public final TypeBinding getType(char[] cArray, PackageBinding packageBinding) {
        if (packageBinding == null) {
            return this.getType(cArray);
        }
        Binding binding = packageBinding.getTypeOrPackage(cArray);
        if (binding == null) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, cArray), null, 1);
        }
        if (!binding.isValidBinding()) {
            return new ProblemReferenceBinding(binding instanceof ReferenceBinding ? ((ReferenceBinding)binding).compoundName : CharOperation.arrayConcat(packageBinding.compoundName, cArray), binding instanceof ReferenceBinding ? (ReferenceBinding)((ReferenceBinding)binding).closestMatch() : null, binding.problemId());
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)binding;
        if (!referenceBinding.canBeSeenBy(this)) {
            return new ProblemReferenceBinding(referenceBinding.compoundName, referenceBinding, 2);
        }
        return referenceBinding;
    }

    public final TypeBinding getType(char[][] cArray, int n) {
        Binding binding;
        Object object;
        if (n == 1 && (object = Scope.getBaseType(cArray[0])) != null) {
            return object;
        }
        object = this.compilationUnitScope();
        ((CompilationUnitScope)object).recordQualifiedReference(cArray);
        Binding binding2 = this.getTypeOrPackage(cArray[0], n == 1 ? 4 : 20, true);
        if (binding2 == null) {
            char[][] cArrayArray = new char[][]{cArray[0]};
            return new ProblemReferenceBinding(cArrayArray, this.environment().createMissingType(this.compilationUnitScope().getCurrentPackage(), cArrayArray), 1);
        }
        if (!binding2.isValidBinding()) {
            if (binding2 instanceof PackageBinding) {
                char[][] cArrayArray = new char[][]{cArray[0]};
                return new ProblemReferenceBinding(cArrayArray, this.environment().createMissingType(null, cArrayArray), 1);
            }
            return (ReferenceBinding)binding2;
        }
        int n2 = 1;
        boolean bl = false;
        if (binding2 instanceof PackageBinding) {
            binding = (PackageBinding)binding2;
            while (n2 < n) {
                if ((binding2 = ((PackageBinding)binding).getTypeOrPackage(cArray[n2++])) == null) {
                    char[][] cArray2 = CharOperation.subarray(cArray, 0, n2);
                    return new ProblemReferenceBinding(cArray2, this.environment().createMissingType((PackageBinding)binding, cArray2), 1);
                }
                if (!binding2.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), binding2 instanceof ReferenceBinding ? (ReferenceBinding)((ReferenceBinding)binding2).closestMatch() : null, binding2.problemId());
                }
                if (!(binding2 instanceof PackageBinding)) break;
                binding = (PackageBinding)binding2;
            }
            if (binding2 instanceof PackageBinding) {
                char[][] cArray3 = CharOperation.subarray(cArray, 0, n2);
                return new ProblemReferenceBinding(cArray3, this.environment().createMissingType(null, cArray3), 1);
            }
            bl = true;
        }
        binding = (ReferenceBinding)binding2;
        ((CompilationUnitScope)object).recordTypeReference((TypeBinding)binding);
        if (bl && !((ReferenceBinding)binding).canBeSeenBy(this)) {
            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding, 2);
        }
        while (n2 < n) {
            if ((binding = this.getMemberType(cArray[n2++], (ReferenceBinding)binding)).isValidBinding()) continue;
            if (binding instanceof ProblemReferenceBinding) {
                ProblemReferenceBinding problemReferenceBinding = (ProblemReferenceBinding)binding;
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), problemReferenceBinding.closestReferenceMatch(), binding.problemId());
            }
            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)((ReferenceBinding)binding2).closestMatch(), binding.problemId());
        }
        return binding;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final Binding getTypeOrPackage(char[] cArray, int n, boolean bl) {
        PackageBinding packageBinding;
        Binding binding;
        Object object;
        Object object2;
        Scope scope = this;
        Binding binding2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if ((n & 4) == 0) {
            Scope scope2 = scope;
            while ((scope2 = scope.parent) != null) {
                scope = scope2;
            }
        } else {
            boolean bl4 = this.compilerOptions().complianceLevel >= 0x300000L;
            block7: while (true) {
                switch (scope.kind) {
                    case 2: {
                        object2 = (MethodScope)scope;
                        AbstractMethodDeclaration abstractMethodDeclaration = ((MethodScope)object2).referenceMethod();
                        if (abstractMethodDeclaration != null) {
                            if (abstractMethodDeclaration.binding != null) {
                                object = abstractMethodDeclaration.binding.getTypeVariable(cArray);
                                if (object != null) {
                                    return object;
                                }
                            } else {
                                int n2;
                                object = abstractMethodDeclaration.typeParameters();
                                int n3 = n2 = object == null ? 0 : ((TypeParameter[])object).length;
                                while (--n2 >= 0) {
                                    if (!CharOperation.equals(((TypeParameter)object[n2]).name, cArray) || ((TypeParameter)object[n2]).binding == null || !((TypeParameter)object[n2]).binding.isValidBinding()) continue;
                                    return ((TypeParameter)object[n2]).binding;
                                }
                            }
                        }
                        bl2 |= ((MethodScope)object2).isStatic;
                        bl3 = ((MethodScope)object2).insideTypeAnnotation;
                    }
                    case 1: {
                        object = ((BlockScope)scope).findLocalType(cArray);
                        if (object == null) break;
                        if (binding2 == null) return object;
                        if (binding2 == object) return object;
                        return new ProblemReferenceBinding(new char[][]{cArray}, (ReferenceBinding)binding2, 5);
                    }
                    case 3: {
                        TypeVariableBinding typeVariableBinding;
                        ReferenceBinding referenceBinding;
                        SourceTypeBinding sourceTypeBinding = ((ClassScope)scope).referenceContext.binding;
                        if (scope == this && (sourceTypeBinding.tagBits & 0x40000L) == 0L) {
                            TypeVariableBinding typeVariableBinding2 = sourceTypeBinding.getTypeVariable(cArray);
                            if (typeVariableBinding2 != null) {
                                return typeVariableBinding2;
                            }
                            if (CharOperation.equals(cArray, sourceTypeBinding.sourceName)) {
                                return sourceTypeBinding;
                            }
                            bl2 |= sourceTypeBinding.isStatic();
                            break;
                        }
                        if (!bl3 && (referenceBinding = this.findMemberType(cArray, sourceTypeBinding)) != null) {
                            if (referenceBinding.problemId() == 3) {
                                if (binding2 == null) return referenceBinding;
                                if (binding2.problemId() == 2) {
                                    return referenceBinding;
                                }
                                return new ProblemReferenceBinding(new char[][]{cArray}, (ReferenceBinding)binding2, 5);
                            }
                            if (referenceBinding.isValidBinding() && (sourceTypeBinding == referenceBinding.enclosingType() || bl4)) {
                                if (bl2 && !referenceBinding.isStatic() && sourceTypeBinding.isGenericType()) {
                                    return new ProblemReferenceBinding(new char[][]{cArray}, referenceBinding, 7);
                                }
                                if (binding2 == null) return referenceBinding;
                                if (bl4 && binding2.problemId() == 2) {
                                    return referenceBinding;
                                }
                                if (binding2.isValidBinding() && binding2 != referenceBinding) {
                                    return new ProblemReferenceBinding(new char[][]{cArray}, (ReferenceBinding)binding2, 5);
                                }
                            }
                            if (binding2 == null || binding2.problemId() == 2 && referenceBinding.problemId() != 2) {
                                binding2 = referenceBinding;
                            }
                        }
                        if ((typeVariableBinding = sourceTypeBinding.getTypeVariable(cArray)) != null) {
                            if (!bl2) return typeVariableBinding;
                            return new ProblemReferenceBinding(new char[][]{cArray}, typeVariableBinding, 7);
                        }
                        bl2 |= sourceTypeBinding.isStatic();
                        bl3 = false;
                        if (!CharOperation.equals(sourceTypeBinding.sourceName, cArray)) break;
                        if (binding2 == null) return sourceTypeBinding;
                        if (binding2 == sourceTypeBinding) return sourceTypeBinding;
                        if (binding2.problemId() == 2) return sourceTypeBinding;
                        return new ProblemReferenceBinding(new char[][]{cArray}, (ReferenceBinding)binding2, 5);
                    }
                    case 4: {
                        break block7;
                    }
                }
                scope = scope.parent;
            }
            if (binding2 != null && binding2.problemId() != 2) {
                return binding2;
            }
        }
        CompilationUnitScope compilationUnitScope = (CompilationUnitScope)scope;
        object2 = compilationUnitScope.typeOrPackageCache;
        if (object2 != null && (binding = (Binding)((HashtableOfObject)object2).get(cArray)) != null) {
            void var10_16;
            if (binding instanceof ImportBinding) {
                object = ((ImportBinding)binding).reference;
                if (object != null) {
                    ((ImportReference)object).bits |= 2;
                }
                if (binding instanceof ImportConflictBinding) {
                    ReferenceBinding referenceBinding = ((ImportConflictBinding)binding).conflictingTypeBinding;
                    ((HashtableOfObject)object2).put(cArray, referenceBinding);
                } else {
                    Binding binding3 = ((ImportBinding)binding).resolvedImport;
                    ((HashtableOfObject)object2).put(cArray, binding3);
                }
            }
            if ((n & 4) != 0) {
                if (binding2 != null && binding2.problemId() != 2 && var10_16.problemId() != 3) {
                    return binding2;
                }
                if (var10_16 instanceof ReferenceBinding) {
                    return var10_16;
                }
            }
            if ((n & 0x10) != 0 && var10_16 instanceof PackageBinding) {
                return var10_16;
            }
        }
        if ((n & 4) != 0) {
            Binding binding4;
            ImportBinding[] importBindingArray = compilationUnitScope.imports;
            if (importBindingArray != null && object2 == null) {
                int n4 = importBindingArray.length;
                for (int i = 0; i < n4; ++i) {
                    ImportBinding importBinding = importBindingArray[i];
                    if (importBinding.onDemand || !CharOperation.equals(importBinding.compoundName[importBinding.compoundName.length - 1], cArray) || (binding4 = compilationUnitScope.resolveSingleImport(importBinding, 4)) == null || !(binding4 instanceof TypeBinding)) continue;
                    ImportReference importReference = importBinding.reference;
                    if (importReference == null) return binding4;
                    importReference.bits |= 2;
                    return binding4;
                }
            }
            object = compilationUnitScope.fPackage;
            compilationUnitScope.recordReference(((PackageBinding)object).compoundName, cArray);
            Binding binding5 = ((PackageBinding)object).getTypeOrPackage(cArray);
            if (binding5 instanceof ReferenceBinding) {
                ReferenceBinding referenceBinding = (ReferenceBinding)binding5;
                if ((referenceBinding.tagBits & 0x80L) == 0L) {
                    if (object2 == null) return referenceBinding;
                    ((HashtableOfObject)object2).put(cArray, referenceBinding);
                    return referenceBinding;
                }
            }
            if (importBindingArray != null) {
                boolean bl5 = false;
                binding4 = null;
                int n5 = importBindingArray.length;
                for (int i = 0; i < n5; ++i) {
                    ImportBinding importBinding = importBindingArray[i];
                    if (!importBinding.onDemand) continue;
                    Binding binding6 = importBinding.resolvedImport;
                    ReferenceBinding referenceBinding = null;
                    if (binding6 instanceof PackageBinding) {
                        referenceBinding = this.findType(cArray, (PackageBinding)binding6, (PackageBinding)object);
                    } else if (importBinding.isStatic()) {
                        referenceBinding = this.findMemberType(cArray, (ReferenceBinding)binding6);
                        if (referenceBinding != null && !referenceBinding.isStatic()) {
                            referenceBinding = null;
                        }
                    } else {
                        referenceBinding = this.findDirectMemberType(cArray, (ReferenceBinding)binding6);
                    }
                    if (referenceBinding == binding4 || referenceBinding == null) continue;
                    if (referenceBinding.isValidBinding()) {
                        boolean bl6;
                        ImportReference importReference = importBinding.reference;
                        if (importReference != null) {
                            importReference.bits |= 2;
                        }
                        if (bl6) {
                            referenceBinding = new ProblemReferenceBinding(new char[][]{cArray}, (ReferenceBinding)binding4, 3);
                            if (object2 == null) return referenceBinding;
                            ((HashtableOfObject)object2).put(cArray, referenceBinding);
                            return referenceBinding;
                        }
                        binding4 = referenceBinding;
                        bl6 = true;
                        continue;
                    }
                    if (binding2 != null) continue;
                    binding2 = referenceBinding;
                }
                if (binding4 != null) {
                    if (object2 == null) return binding4;
                    ((HashtableOfObject)object2).put(cArray, binding4);
                    return binding4;
                }
            }
        }
        compilationUnitScope.recordSimpleReference(cArray);
        if ((n & 0x10) != 0 && (packageBinding = compilationUnitScope.environment.getTopLevelPackage(cArray)) != null) {
            if (object2 == null) return packageBinding;
            ((HashtableOfObject)object2).put(cArray, packageBinding);
            return packageBinding;
        }
        if (binding2 != null) {
            if ((((ReferenceBinding)binding2).tagBits & 0x80L) == 0L) return binding2;
            char[][] cArrayArray = new char[][]{cArray};
            binding2 = new ProblemReferenceBinding(cArrayArray, (ReferenceBinding)binding2, 1);
            if (object2 == null) return binding2;
            if ((n & 0x10) == 0) return binding2;
            ((HashtableOfObject)object2).put(cArray, binding2);
            return binding2;
        }
        char[][] cArrayArray = new char[][]{cArray};
        object = null;
        if ((n & 0x10) != 0) {
            if (bl) {
                object = this.environment().createMissingType(compilationUnitScope.fPackage, cArrayArray);
            }
        } else {
            PackageBinding packageBinding2 = compilationUnitScope.environment.getTopLevelPackage(cArray);
            if ((packageBinding2 == null || !packageBinding2.isValidBinding()) && bl) {
                object = this.environment().createMissingType(compilationUnitScope.fPackage, cArrayArray);
            }
        }
        binding2 = new ProblemReferenceBinding(cArrayArray, (ReferenceBinding)object, 1);
        if (object2 == null) return binding2;
        if ((n & 0x10) == 0) return binding2;
        ((HashtableOfObject)object2).put(cArray, binding2);
        return binding2;
    }

    public final Binding getTypeOrPackage(char[][] cArray) {
        Binding binding;
        Binding binding2;
        int n = cArray.length;
        if (n == 1 && (binding2 = Scope.getBaseType(cArray[0])) != null) {
            return binding2;
        }
        binding2 = this.getTypeOrPackage(cArray[0], 20, true);
        if (!binding2.isValidBinding()) {
            return binding2;
        }
        int n2 = 1;
        boolean bl = false;
        if (binding2 instanceof PackageBinding) {
            binding = (PackageBinding)binding2;
            while (n2 < n) {
                if ((binding2 = ((PackageBinding)binding).getTypeOrPackage(cArray[n2++])) == null) {
                    return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
                }
                if (!binding2.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), binding2 instanceof ReferenceBinding ? (ReferenceBinding)((ReferenceBinding)binding2).closestMatch() : null, binding2.problemId());
                }
                if (!(binding2 instanceof PackageBinding)) break;
                binding = (PackageBinding)binding2;
            }
            if (binding2 instanceof PackageBinding) {
                return binding2;
            }
            bl = true;
        }
        binding = (ReferenceBinding)binding2;
        Binding binding3 = (ReferenceBinding)this.environment().convertToRawType((TypeBinding)binding, false);
        if (bl && !((ReferenceBinding)binding).canBeSeenBy(this)) {
            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding, 2);
        }
        while (n2 < n) {
            if (!(binding = this.getMemberType(cArray[n2++], (ReferenceBinding)binding)).isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)((TypeBinding)binding).closestMatch(), binding.problemId());
            }
            if (((TypeBinding)binding).isGenericType()) {
                binding3 = this.environment().createRawType((ReferenceBinding)binding, (ReferenceBinding)binding3);
                continue;
            }
            binding3 = binding3 != null && (((TypeBinding)binding3).isRawType() || ((TypeBinding)binding3).isParameterizedType()) ? this.environment().createParameterizedType((ReferenceBinding)binding, null, (ReferenceBinding)binding3) : binding;
        }
        return binding3;
    }

    protected boolean hasErasedCandidatesCollisions(TypeBinding typeBinding, TypeBinding typeBinding2, Map map, ReferenceBinding referenceBinding, ASTNode aSTNode) {
        map.clear();
        TypeBinding[] typeBindingArray = this.minimalErasedCandidates(new TypeBinding[]{typeBinding, typeBinding2}, map);
        if (typeBindingArray != null) {
            int n = typeBindingArray.length;
            for (int i = 0; i < n; ++i) {
                Object v;
                TypeBinding typeBinding3 = typeBindingArray[i];
                if (typeBinding3 == null || !((v = map.get(typeBinding3)) instanceof TypeBinding[])) continue;
                TypeBinding[] typeBindingArray2 = (TypeBinding[])v;
                this.problemReporter().superinterfacesCollide(typeBindingArray2[0].erasure(), aSTNode, typeBindingArray2[0], typeBindingArray2[1]);
                referenceBinding.tagBits |= 0x20000L;
                return true;
            }
        }
        return false;
    }

    public CaseStatement innermostSwitchCase() {
        Scope scope = this;
        do {
            if (!(scope instanceof BlockScope)) continue;
            return ((BlockScope)scope).enclosingCase;
        } while ((scope = scope.parent) != null);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    protected boolean isAcceptableMethod(MethodBinding methodBinding, MethodBinding methodBinding2) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n = typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
        int n2 = typeBindingArray2.length;
        if (n != n2) {
            if (!methodBinding.isVarargs()) return false;
            if (!methodBinding2.isVarargs()) return false;
            if (n > n2 && ((ArrayBinding)typeBindingArray2[n2 - 1]).elementsType().id != 1) {
                return false;
            }
        } else {
            boolean bl = this.environment().globalOptions.sourceLevel < 0x310000L;
            int n3 = 0;
            while (n3 < n) {
                TypeBinding typeBinding;
                TypeBinding typeBinding2;
                TypeBinding typeBinding3 = bl ? typeBindingArray[n3].erasure() : typeBindingArray[n3];
                TypeBinding typeBinding4 = typeBinding2 = bl ? typeBindingArray2[n3].erasure() : typeBindingArray2[n3];
                if (typeBinding3 != typeBinding2 && !typeBinding3.isCompatibleWith(typeBinding2)) {
                    if (n3 != n - 1) return false;
                    if (!methodBinding.isVarargs()) return false;
                    if (!methodBinding2.isVarargs()) return false;
                    typeBinding = ((ArrayBinding)typeBinding2).elementsType();
                    if (typeBinding3 == typeBinding) return true;
                    if (!typeBinding3.isCompatibleWith(typeBinding)) return false;
                    return true;
                }
                if (!methodBinding2.declaringClass.isRawType()) {
                    typeBinding = methodBinding2.original().parameters[n3].leafComponentType();
                    TypeBinding typeBinding5 = bl ? typeBinding.erasure() : typeBinding;
                    block0 : switch (typeBinding5.kind()) {
                        case 4100: {
                            if (((TypeVariableBinding)typeBinding5).hasOnlyRawBounds()) break;
                        }
                        case 260: 
                        case 516: 
                        case 8196: {
                            TypeBinding typeBinding6 = methodBinding.original().parameters[n3].leafComponentType();
                            switch (typeBinding6.kind()) {
                                case 4: 
                                case 2052: {
                                    TypeBinding typeBinding7 = typeBinding3.findSuperTypeOriginatingFrom(typeBinding2);
                                    if (typeBinding7 == null) break block0;
                                    if (typeBinding7.leafComponentType().isRawType()) return false;
                                    break block0;
                                }
                                case 4100: {
                                    if (((TypeVariableBinding)typeBinding6).upperBound().isRawType()) return false;
                                    break block0;
                                }
                                case 1028: {
                                    return false;
                                }
                            }
                        }
                    }
                }
                ++n3;
            }
            return true;
        }
        int n4 = (n > n2 ? n2 : n) - 2;
        while (true) {
            if (n4 < 0) {
                if (this.parameterCompatibilityLevel(methodBinding, typeBindingArray2) != -1) return false;
                if (this.parameterCompatibilityLevel(methodBinding2, typeBindingArray) != 2) return false;
                return true;
            }
            if (typeBindingArray[n4] != typeBindingArray2[n4] && !typeBindingArray[n4].isCompatibleWith(typeBindingArray2[n4])) {
                return false;
            }
            --n4;
        }
    }

    public boolean isBoxingCompatibleWith(TypeBinding typeBinding, TypeBinding typeBinding2) {
        LookupEnvironment lookupEnvironment = this.environment();
        if (lookupEnvironment.globalOptions.sourceLevel < 0x310000L || typeBinding.isBaseType() == typeBinding2.isBaseType()) {
            return false;
        }
        TypeBinding typeBinding3 = lookupEnvironment.computeBoxingType(typeBinding);
        return typeBinding3 == typeBinding2 || typeBinding3.isCompatibleWith(typeBinding2);
    }

    public final boolean isDefinedInField(FieldBinding fieldBinding) {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            MethodScope methodScope = (MethodScope)scope;
            if (methodScope.initializedField != fieldBinding) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInMethod(MethodBinding methodBinding) {
        Scope scope = this;
        do {
            ReferenceContext referenceContext;
            if (!(scope instanceof MethodScope) || !((referenceContext = ((MethodScope)scope).referenceContext) instanceof AbstractMethodDeclaration) || ((AbstractMethodDeclaration)referenceContext).binding != methodBinding) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInSameUnit(ReferenceBinding referenceBinding) {
        Scope scope;
        ReferenceBinding referenceBinding2 = referenceBinding;
        while ((referenceBinding = referenceBinding2.enclosingType()) != null) {
            referenceBinding2 = referenceBinding;
        }
        Scope scope2 = this;
        while ((scope = scope2.parent) != null) {
            scope2 = scope;
        }
        SourceTypeBinding[] sourceTypeBindingArray = ((CompilationUnitScope)scope2).topLevelTypes;
        int n = sourceTypeBindingArray.length;
        while (--n >= 0) {
            if (sourceTypeBindingArray[n] != referenceBinding2) continue;
            return true;
        }
        return false;
    }

    public final boolean isDefinedInType(ReferenceBinding referenceBinding) {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope) || ((ClassScope)scope).referenceContext.binding != referenceBinding) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideCase(CaseStatement caseStatement) {
        Scope scope = this;
        do {
            switch (scope.kind) {
                case 1: {
                    if (((BlockScope)scope).enclosingCase != caseStatement) break;
                    return true;
                }
            }
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideDeprecatedCode() {
        switch (this.kind) {
            case 1: 
            case 2: {
                Binding binding;
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer() ? (binding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) != null && ((MethodBinding)binding).isViewedAsDeprecated() : methodScope.initializedField != null && methodScope.initializedField.isViewedAsDeprecated()) {
                    return true;
                }
                binding = ((BlockScope)this).referenceType().binding;
                if (binding == null) break;
                ((SourceTypeBinding)binding).initializeDeprecatedAnnotationTagBits();
                if (!((ReferenceBinding)binding).isViewedAsDeprecated()) break;
                return true;
            }
            case 3: {
                SourceTypeBinding sourceTypeBinding = ((ClassScope)this).referenceType().binding;
                if (sourceTypeBinding == null) break;
                ((Binding)sourceTypeBinding).initializeDeprecatedAnnotationTagBits();
                if (!sourceTypeBinding.isViewedAsDeprecated()) break;
                return true;
            }
            case 4: {
                SourceTypeBinding sourceTypeBinding;
                CompilationUnitDeclaration compilationUnitDeclaration = this.referenceCompilationUnit();
                if (compilationUnitDeclaration.types == null || compilationUnitDeclaration.types.length <= 0 || (sourceTypeBinding = compilationUnitDeclaration.types[0].binding) == null) break;
                sourceTypeBinding.initializeDeprecatedAnnotationTagBits();
                if (!sourceTypeBinding.isViewedAsDeprecated()) break;
                return true;
            }
        }
        return false;
    }

    private boolean isOverriddenMethodGeneric(MethodBinding methodBinding) {
        MethodVerifier methodVerifier = this.environment().methodVerifier();
        for (ReferenceBinding referenceBinding = methodBinding.declaringClass.superclass(); referenceBinding != null; referenceBinding = referenceBinding.superclass()) {
            MethodBinding[] methodBindingArray = referenceBinding.getMethods(methodBinding.selector);
            int n = methodBindingArray.length;
            for (int i = 0; i < n; ++i) {
                MethodBinding methodBinding2 = methodBindingArray[i];
                if (methodBinding2 == null || methodBinding2.original().typeVariables == Binding.NO_TYPE_VARIABLES || !methodVerifier.doesMethodOverride(methodBinding, methodBinding2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPossibleSubtypeOfRawType(TypeBinding typeBinding) {
        int n;
        TypeBinding typeBinding2 = typeBinding.leafComponentType();
        if (typeBinding2.isBaseType()) {
            return false;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding2;
        ReferenceBinding[] referenceBindingArray = null;
        int n2 = 0;
        do {
            if (referenceBinding.isRawType()) {
                return true;
            }
            if (!referenceBinding.isHierarchyConnected()) {
                return true;
            }
            ReferenceBinding[] referenceBindingArray2 = referenceBinding.superInterfaces();
            if (referenceBindingArray2 == null || referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray == null) {
                referenceBindingArray = referenceBindingArray2;
                n2 = referenceBindingArray.length;
                continue;
            }
            int n3 = referenceBindingArray2.length;
            if (n2 + n3 >= referenceBindingArray.length) {
                ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2 + n3 + 5];
                System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n2);
            }
            block1: for (n = 0; n < n3; ++n) {
                ReferenceBinding referenceBinding2 = referenceBindingArray2[n];
                for (int i = 0; i < n2; ++i) {
                    if (referenceBinding2 == referenceBindingArray[i]) continue block1;
                }
                referenceBindingArray[n2++] = referenceBinding2;
            }
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        for (int i = 0; i < n2; ++i) {
            referenceBinding = referenceBindingArray[i];
            if (referenceBinding.isRawType()) {
                return true;
            }
            ReferenceBinding[] referenceBindingArray4 = referenceBinding.superInterfaces();
            if (referenceBindingArray4 == null || referenceBindingArray4 == Binding.NO_SUPERINTERFACES) continue;
            n = referenceBindingArray4.length;
            if (n2 + n >= referenceBindingArray.length) {
                ReferenceBinding[] referenceBindingArray5 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2 + n + 5];
                System.arraycopy(referenceBindingArray5, 0, referenceBindingArray, 0, n2);
            }
            block4: for (int j = 0; j < n; ++j) {
                ReferenceBinding referenceBinding3 = referenceBindingArray4[j];
                for (int k = 0; k < n2; ++k) {
                    if (referenceBinding3 == referenceBindingArray[k]) continue block4;
                }
                referenceBindingArray[n2++] = referenceBinding3;
            }
        }
        return false;
    }

    private TypeBinding leastContainingInvocation(TypeBinding typeBinding, Object object, List list) {
        if (object == null) {
            return typeBinding;
        }
        if (object instanceof TypeBinding) {
            return (TypeBinding)object;
        }
        TypeBinding[] typeBindingArray = (TypeBinding[])object;
        int n = typeBinding.dimensions();
        int n2 = (typeBinding = typeBinding.leafComponentType()).typeVariables().length;
        if (n2 == 0) {
            return typeBinding;
        }
        TypeBinding[] typeBindingArray2 = new TypeBinding[n2];
        int n3 = typeBindingArray.length;
        block5: for (int i = 0; i < n3; ++i) {
            TypeBinding typeBinding2 = typeBindingArray[i].leafComponentType();
            switch (typeBinding2.kind()) {
                case 2052: {
                    TypeVariableBinding[] typeVariableBindingArray = typeBinding2.typeVariables();
                    for (int j = 0; j < n2; ++j) {
                        TypeBinding typeBinding3 = this.leastContainingTypeArgument(typeBindingArray2[j], typeVariableBindingArray[j], (ReferenceBinding)typeBinding, j, list);
                        if (typeBinding3 == null) {
                            return null;
                        }
                        typeBindingArray2[j] = typeBinding3;
                    }
                    continue block5;
                }
                case 260: {
                    ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding2;
                    for (int j = 0; j < n2; ++j) {
                        TypeBinding typeBinding4 = this.leastContainingTypeArgument(typeBindingArray2[j], parameterizedTypeBinding.arguments[j], (ReferenceBinding)typeBinding, j, list);
                        if (typeBinding4 == null) {
                            return null;
                        }
                        typeBindingArray2[j] = typeBinding4;
                    }
                    continue block5;
                }
                case 1028: {
                    return n == 0 ? typeBinding2 : this.environment().createArrayType(typeBinding2, n);
                }
            }
        }
        ParameterizedTypeBinding parameterizedTypeBinding = this.environment().createParameterizedType((ReferenceBinding)typeBinding.erasure(), typeBindingArray2, typeBinding.enclosingType());
        return n == 0 ? parameterizedTypeBinding : this.environment().createArrayType(parameterizedTypeBinding, n);
    }

    private TypeBinding leastContainingTypeArgument(TypeBinding typeBinding, TypeBinding typeBinding2, ReferenceBinding referenceBinding, int n, List list) {
        TypeBinding typeBinding3;
        if (typeBinding == null) {
            return typeBinding2;
        }
        if (typeBinding == typeBinding2) {
            return typeBinding;
        }
        if (typeBinding2.isWildcard()) {
            typeBinding3 = (WildcardBinding)typeBinding2;
            if (typeBinding.isWildcard()) {
                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                switch (wildcardBinding.boundKind) {
                    case 1: {
                        switch (typeBinding3.boundKind) {
                            case 1: {
                                TypeBinding typeBinding4 = this.lowerUpperBound(new TypeBinding[]{wildcardBinding.bound, typeBinding3.bound}, list);
                                if (typeBinding4 == null) {
                                    return null;
                                }
                                if (typeBinding4 == TypeBinding.INT) {
                                    return this.environment().createWildcard(referenceBinding, n, null, null, 0);
                                }
                                return this.environment().createWildcard(referenceBinding, n, typeBinding4, null, 1);
                            }
                            case 2: {
                                if (wildcardBinding.bound == typeBinding3.bound) {
                                    return wildcardBinding.bound;
                                }
                                return this.environment().createWildcard(referenceBinding, n, null, null, 0);
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (wildcardBinding.boundKind != 2) break;
                        TypeBinding[] typeBindingArray = Scope.greaterLowerBound(new TypeBinding[]{wildcardBinding.bound, typeBinding3.bound});
                        if (typeBindingArray == null) {
                            return null;
                        }
                        return this.environment().createWildcard(referenceBinding, n, typeBindingArray[0], null, 2);
                    }
                }
            } else {
                switch (typeBinding3.boundKind) {
                    case 1: {
                        TypeBinding typeBinding5 = this.lowerUpperBound(new TypeBinding[]{typeBinding, typeBinding3.bound}, list);
                        if (typeBinding5 == null) {
                            return null;
                        }
                        if (typeBinding5 == TypeBinding.INT) {
                            return this.environment().createWildcard(referenceBinding, n, null, null, 0);
                        }
                        return this.environment().createWildcard(referenceBinding, n, typeBinding5, null, 1);
                    }
                    case 2: {
                        TypeBinding[] typeBindingArray = Scope.greaterLowerBound(new TypeBinding[]{typeBinding, typeBinding3.bound});
                        if (typeBindingArray == null) {
                            return null;
                        }
                        return this.environment().createWildcard(referenceBinding, n, typeBindingArray[0], null, 2);
                    }
                }
            }
        } else if (typeBinding.isWildcard()) {
            typeBinding3 = (WildcardBinding)typeBinding;
            switch (typeBinding3.boundKind) {
                case 1: {
                    TypeBinding typeBinding6 = this.lowerUpperBound(new TypeBinding[]{typeBinding3.bound, typeBinding2}, list);
                    if (typeBinding6 == null) {
                        return null;
                    }
                    if (typeBinding6 == TypeBinding.INT) {
                        return this.environment().createWildcard(referenceBinding, n, null, null, 0);
                    }
                    return this.environment().createWildcard(referenceBinding, n, typeBinding6, null, 1);
                }
                case 2: {
                    TypeBinding[] typeBindingArray = Scope.greaterLowerBound(new TypeBinding[]{typeBinding3.bound, typeBinding2});
                    if (typeBindingArray == null) {
                        return null;
                    }
                    return this.environment().createWildcard(referenceBinding, n, typeBindingArray[0], null, 2);
                }
            }
        }
        typeBinding3 = this.lowerUpperBound(new TypeBinding[]{typeBinding, typeBinding2}, list);
        if (typeBinding3 == null) {
            return null;
        }
        if (typeBinding3 == TypeBinding.INT) {
            return this.environment().createWildcard(referenceBinding, n, null, null, 0);
        }
        return this.environment().createWildcard(referenceBinding, n, typeBinding3, null, 1);
    }

    public TypeBinding lowerUpperBound(TypeBinding[] typeBindingArray) {
        int n = typeBindingArray.length;
        if (n == 1) {
            TypeBinding typeBinding = typeBindingArray[0];
            return typeBinding == null ? TypeBinding.VOID : typeBinding;
        }
        return this.lowerUpperBound(typeBindingArray, new ArrayList(1));
    }

    private TypeBinding lowerUpperBound(TypeBinding[] typeBindingArray, List list) {
        int n;
        int n2;
        TypeBinding typeBinding;
        int n3;
        int n4;
        TypeBinding[] typeBindingArray2;
        int n5 = typeBindingArray.length;
        if (n5 == 1) {
            TypeBinding typeBinding2 = typeBindingArray[0];
            return typeBinding2 == null ? TypeBinding.VOID : typeBinding2;
        }
        int n6 = list.size();
        block5: for (int i = 0; i < n6; ++i) {
            typeBindingArray2 = (TypeBinding[])list.get(i);
            n4 = typeBindingArray2.length;
            if (n4 < n5) continue;
            block6: for (n3 = 0; n3 < n5; ++n3) {
                typeBinding = typeBindingArray[n3];
                if (typeBinding == null) continue;
                for (n2 = 0; n2 < n4; ++n2) {
                    TypeBinding typeBinding3 = typeBindingArray2[n2];
                    if (typeBinding3 != null && (typeBinding3 == typeBinding || typeBinding3.isEquivalentTo(typeBinding))) continue block6;
                }
                continue block5;
            }
            return TypeBinding.INT;
        }
        list.add(typeBindingArray);
        HashMap hashMap = new HashMap(1);
        typeBindingArray2 = this.minimalErasedCandidates(typeBindingArray, hashMap);
        if (typeBindingArray2 == null) {
            return null;
        }
        n4 = typeBindingArray2.length;
        if (n4 == 0) {
            return TypeBinding.VOID;
        }
        n3 = 0;
        typeBinding = null;
        n2 = -1;
        for (int i = 0; i < n4; ++i) {
            TypeBinding typeBinding4 = typeBindingArray2[i];
            if (typeBinding4 == null) continue;
            if ((typeBinding4 = this.leastContainingInvocation(typeBinding4, hashMap.get(typeBinding4), list)) == null) {
                return null;
            }
            n = typeBinding4.dimensions();
            if (n2 == -1) {
                n2 = n;
            } else if (n != n2) {
                return null;
            }
            if (typeBinding == null && !typeBinding4.leafComponentType().isInterface()) {
                typeBinding = typeBinding4.leafComponentType();
            }
            typeBindingArray2[n3++] = typeBinding4;
        }
        switch (n3) {
            case 0: {
                return TypeBinding.VOID;
            }
            case 1: {
                return typeBindingArray2[0];
            }
            case 2: {
                if ((n2 == 0 ? typeBindingArray2[1].id : typeBindingArray2[1].leafComponentType().id) == 1) {
                    return typeBindingArray2[0];
                }
                if ((n2 == 0 ? typeBindingArray2[0].id : typeBindingArray2[0].leafComponentType().id) != 1) break;
                return typeBindingArray2[1];
            }
        }
        TypeBinding[] typeBindingArray3 = new TypeBinding[n3 - 1];
        int n7 = 0;
        for (n = 0; n < n3; ++n) {
            TypeBinding typeBinding5;
            TypeBinding typeBinding6 = typeBinding5 = n2 == 0 ? typeBindingArray2[n] : typeBindingArray2[n].leafComponentType();
            if (!typeBinding5.isInterface()) continue;
            typeBindingArray3[n7++] = typeBinding5;
        }
        WildcardBinding wildcardBinding = this.environment().createWildcard(null, 0, typeBinding, typeBindingArray3, 1);
        return n2 == 0 ? wildcardBinding : this.environment().createArrayType(wildcardBinding, n2);
    }

    public final MethodScope methodScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    protected TypeBinding[] minimalErasedCandidates(TypeBinding[] typeBindingArray, Map map) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        TypeBinding[] typeBindingArray2;
        int n2;
        TypeBinding typeBinding;
        Object object5;
        int n3 = typeBindingArray.length;
        int n4 = -1;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            object5 = typeBindingArray[i];
            if (object5 == null) continue;
            if (((TypeBinding)object5).isBaseType()) {
                return null;
            }
            if (n4 < 0) {
                n4 = i;
            }
            ++n5;
        }
        switch (n5) {
            case 0: {
                return Binding.NO_TYPES;
            }
            case 1: {
                return typeBindingArray;
            }
        }
        TypeBinding typeBinding2 = typeBindingArray[n4];
        if (typeBinding2.isBaseType()) {
            return null;
        }
        object5 = new ArrayList(5);
        int n6 = typeBinding2.dimensions();
        TypeBinding typeBinding3 = typeBinding2.leafComponentType();
        switch (typeBinding3.kind()) {
            case 68: 
            case 260: 
            case 1028: {
                typeBinding = typeBinding2.erasure();
                break;
            }
            default: {
                typeBinding = typeBinding2;
            }
        }
        if (typeBinding != typeBinding2) {
            map.put(typeBinding, typeBinding2);
        }
        ((ArrayList)object5).add(typeBinding2);
        int n7 = 1;
        block12: for (n2 = 0; n2 < n7; ++n2) {
            Object object6;
            ReferenceBinding referenceBinding;
            Object object7;
            typeBindingArray2 = (TypeBinding[])((ArrayList)object5).get(n2);
            n6 = typeBindingArray2.dimensions();
            if (n6 > 0) {
                typeBinding3 = typeBindingArray2.leafComponentType();
                switch (typeBinding3.id) {
                    case 1: {
                        if (n6 > 1) {
                            object7 = ((ArrayBinding)typeBindingArray2).elementsType();
                            if (((ArrayList)object5).contains(object7)) continue block12;
                            ((ArrayList)object5).add(object7);
                            ++n7;
                            continue block12;
                        }
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        object7 = this.getJavaIoSerializable();
                        if (!((ArrayList)object5).contains(object7)) {
                            ((ArrayList)object5).add(object7);
                            ++n7;
                        }
                        if (!((ArrayList)object5).contains(object7 = this.getJavaLangCloneable())) {
                            ((ArrayList)object5).add(object7);
                            ++n7;
                        }
                        if (((ArrayList)object5).contains(object7 = this.getJavaLangObject())) continue block12;
                        ((ArrayList)object5).add(object7);
                        ++n7;
                        continue block12;
                    }
                    default: {
                        typeBindingArray2 = typeBinding3;
                    }
                }
            }
            if ((referenceBinding = (ReferenceBinding)typeBindingArray2).isCapture() && (object7 = ((CaptureBinding)referenceBinding).firstBound) != null && ((TypeBinding)object7).isArrayType()) {
                Object object8 = object4 = n6 == 0 ? object7 : this.environment().createArrayType((TypeBinding)object7, n6);
                if (((ArrayList)object5).contains(object4)) continue;
                ((ArrayList)object5).add(object4);
                ++n7;
                Object object9 = object3 = ((TypeBinding)object7).isTypeVariable() || ((TypeBinding)object7).isWildcard() ? object4 : ((TypeBinding)object4).erasure();
                if (object3 == object4) continue;
                map.put(object3, object4);
                continue;
            }
            object7 = referenceBinding.superInterfaces();
            if (object7 != null) {
                int n8 = ((Object)object7).length;
                for (int i = 0; i < n8; ++i) {
                    Object object10;
                    object2 = object7[i];
                    Object object11 = object10 = n6 == 0 ? object2 : this.environment().createArrayType((TypeBinding)object2, n6);
                    if (((ArrayList)object5).contains(object10)) continue;
                    ((ArrayList)object5).add(object10);
                    ++n7;
                    Object object12 = object = ((TypeBinding)object2).isTypeVariable() || ((TypeBinding)object2).isWildcard() ? object10 : ((TypeBinding)object10).erasure();
                    if (object == object10) continue;
                    map.put(object, object10);
                }
            }
            if ((object4 = referenceBinding.superclass()) == null) continue;
            Object object13 = object6 = n6 == 0 ? object4 : this.environment().createArrayType((TypeBinding)object4, n6);
            if (((ArrayList)object5).contains(object6)) continue;
            ((ArrayList)object5).add(object6);
            ++n7;
            Object object14 = object2 = ((TypeBinding)object4).isTypeVariable() || ((TypeBinding)object4).isWildcard() ? object6 : ((TypeBinding)object6).erasure();
            if (object2 == object6) continue;
            map.put(object2, object6);
        }
        n2 = ((ArrayList)object5).size();
        typeBindingArray2 = new TypeBinding[n2];
        int n9 = 0;
        object4 = ((ArrayList)object5).iterator();
        while (object4.hasNext()) {
            object3 = (TypeBinding)object4.next();
            typeBinding3 = ((TypeBinding)object3).leafComponentType();
            typeBindingArray2[n9++] = typeBinding3.isTypeVariable() || typeBinding3.isWildcard() ? object3 : ((TypeBinding)object3).erasure();
        }
        int n10 = n2;
        for (n = n4 + 1; n < n3; ++n) {
            int n11;
            int n12;
            TypeBinding[] typeBindingArray3;
            Object v;
            TypeBinding typeBinding4;
            int n13;
            object2 = typeBindingArray[n];
            if (object2 == null) continue;
            if (((TypeBinding)object2).isArrayType()) {
                block16: for (n13 = 0; n13 < n2; ++n13) {
                    object = typeBindingArray2[n13];
                    if (object == null || object == object2) continue;
                    typeBinding4 = ((TypeBinding)object2).findSuperTypeOriginatingFrom((TypeBinding)object);
                    if (typeBinding4 == null) {
                        typeBindingArray2[n13] = null;
                        if (--n10 != 0) continue;
                        return null;
                    }
                    v = map.get(object);
                    if (v == null) {
                        map.put(object, typeBinding4);
                        continue;
                    }
                    if (v instanceof TypeBinding) {
                        if (typeBinding4 == v) continue;
                        typeBindingArray3 = new TypeBinding[]{(TypeBinding)v, typeBinding4};
                        map.put(object, typeBindingArray3);
                        continue;
                    }
                    typeBindingArray3 = (TypeBinding[])v;
                    n12 = typeBindingArray3.length;
                    for (n11 = 0; n11 < n12; ++n11) {
                        if (typeBindingArray3[n11] == typeBinding4) continue block16;
                    }
                    TypeBinding[] typeBindingArray4 = typeBindingArray3;
                    typeBindingArray3 = new TypeBinding[n12 + 1];
                    System.arraycopy(typeBindingArray4, 0, typeBindingArray3, 0, n12);
                    map.put(object, typeBindingArray3);
                    typeBindingArray3[n12] = typeBinding4;
                }
                continue;
            }
            block18: for (n13 = 0; n13 < n2; ++n13) {
                object = typeBindingArray2[n13];
                if (object == null) continue;
                if (object == object2 || ((TypeBinding)object).id == 1 && ((TypeBinding)object2).isInterface()) {
                    typeBinding4 = object;
                } else {
                    typeBinding4 = ((TypeBinding)object).isArrayType() ? null : ((TypeBinding)object2).findSuperTypeOriginatingFrom((TypeBinding)object);
                    if (typeBinding4 == null) {
                        typeBindingArray2[n13] = null;
                        if (--n10 != 0) continue;
                        return null;
                    }
                }
                v = map.get(object);
                if (v == null) {
                    map.put(object, typeBinding4);
                    continue;
                }
                if (v instanceof TypeBinding) {
                    if (typeBinding4 == v) continue;
                    typeBindingArray3 = new TypeBinding[]{(TypeBinding)v, typeBinding4};
                    map.put(object, typeBindingArray3);
                    continue;
                }
                typeBindingArray3 = (TypeBinding[])v;
                n12 = typeBindingArray3.length;
                for (n11 = 0; n11 < n12; ++n11) {
                    if (typeBindingArray3[n11] == typeBinding4) continue block18;
                }
                TypeBinding[] typeBindingArray5 = typeBindingArray3;
                typeBindingArray3 = new TypeBinding[n12 + 1];
                System.arraycopy(typeBindingArray5, 0, typeBindingArray3, 0, n12);
                map.put(object, typeBindingArray3);
                typeBindingArray3[n12] = typeBinding4;
            }
        }
        if (n10 > 1) {
            for (n = 0; n < n2; ++n) {
                object2 = typeBindingArray2[n];
                if (object2 == null) continue;
                for (int i = 0; i < n2; ++i) {
                    if (n == i || (object = typeBindingArray2[i]) == null) continue;
                    if (object2 instanceof ReferenceBinding) {
                        if (((TypeBinding)object).id == 1 && ((TypeBinding)object2).isInterface() || ((TypeBinding)object2).findSuperTypeOriginatingFrom((TypeBinding)object) == null) continue;
                        typeBindingArray2[i] = null;
                        --n10;
                        continue;
                    }
                    if (!((TypeBinding)object2).isArrayType() || ((TypeBinding)object).isArrayType() && ((TypeBinding)object).leafComponentType().id == 1 && ((TypeBinding)object).dimensions() == ((TypeBinding)object2).dimensions() && ((TypeBinding)object2).leafComponentType().isInterface() || ((TypeBinding)object2).findSuperTypeOriginatingFrom((TypeBinding)object) == null) continue;
                    typeBindingArray2[i] = null;
                    --n10;
                }
            }
        }
        return typeBindingArray2;
    }

    protected final MethodBinding mostSpecificClassMethodBinding(MethodBinding[] methodBindingArray, int n, InvocationSite invocationSite) {
        MethodBinding methodBinding = null;
        block0: for (int i = 0; i < n; ++i) {
            MethodBinding methodBinding2 = methodBindingArray[i];
            if (methodBinding != null && methodBinding2.declaringClass != methodBinding.declaringClass) break;
            if (!methodBinding2.isStatic()) {
                methodBinding = methodBinding2;
            }
            for (int j = 0; j < n; ++j) {
                if (i != j && !methodBindingArray[j].areParametersCompatibleWith(methodBinding2.parameters)) continue block0;
            }
            this.compilationUnitScope().recordTypeReferences(methodBinding2.thrownExceptions);
            return methodBinding2;
        }
        return new ProblemMethodBinding(methodBindingArray[0], methodBindingArray[0].selector, methodBindingArray[0].parameters, 3);
    }

    protected final MethodBinding mostSpecificInterfaceMethodBinding(MethodBinding[] methodBindingArray, int n, InvocationSite invocationSite) {
        block0: for (int i = 0; i < n; ++i) {
            MethodBinding methodBinding = methodBindingArray[i];
            for (int j = 0; j < n; ++j) {
                if (i != j && !methodBindingArray[j].areParametersCompatibleWith(methodBinding.parameters)) continue block0;
            }
            this.compilationUnitScope().recordTypeReferences(methodBinding.thrownExceptions);
            return methodBinding;
        }
        return new ProblemMethodBinding(methodBindingArray[0], methodBindingArray[0].selector, methodBindingArray[0].parameters, 3);
    }

    protected final MethodBinding mostSpecificMethodBinding(MethodBinding[] methodBindingArray, int n, TypeBinding[] typeBindingArray, final InvocationSite invocationSite, ReferenceBinding referenceBinding) {
        Binding binding;
        MethodBinding methodBinding;
        MethodBinding methodBinding2;
        int n2;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.parameterCompatibilityLevel(methodBindingArray[i], typeBindingArray);
        }
        InvocationSite invocationSite2 = new InvocationSite(){

            public TypeBinding[] genericTypeArguments() {
                return null;
            }

            public boolean isSuperAccess() {
                return invocationSite.isSuperAccess();
            }

            public boolean isTypeAccess() {
                return invocationSite.isTypeAccess();
            }

            public void setActualReceiverType(ReferenceBinding referenceBinding) {
            }

            public void setDepth(int n) {
            }

            public void setFieldIndex(int n) {
            }

            public int sourceStart() {
                return invocationSite.sourceStart();
            }

            public int sourceEnd() {
                return invocationSite.sourceStart();
            }

            public TypeBinding expectedType() {
                return invocationSite.expectedType();
            }
        };
        MethodBinding[] methodBindingArray2 = new MethodBinding[n];
        int n3 = 0;
        int n4 = 2;
        for (n2 = 0; n2 <= n4; ++n2) {
            block2: for (int i = 0; i < n; ++i) {
                if (nArray[i] != n2) continue;
                n4 = n2;
                methodBinding2 = methodBindingArray[i];
                MethodBinding methodBinding3 = methodBinding2.original();
                MethodBinding methodBinding4 = methodBinding2.tiebreakMethod();
                for (int j = 0; j < n; ++j) {
                    MethodBinding methodBinding5;
                    if (i == j || nArray[j] != n2) continue;
                    methodBinding = methodBindingArray[j];
                    if (methodBinding3 == methodBinding.original()) {
                        nArray[j] = -1;
                        continue;
                    }
                    binding = methodBinding;
                    if (methodBinding instanceof ParameterizedGenericMethodBinding) {
                        methodBinding5 = (ParameterizedGenericMethodBinding)methodBinding;
                        if (!((ParameterizedGenericMethodBinding)methodBinding5).isRaw || methodBinding5.isStatic()) {
                            binding = ((ParameterizedGenericMethodBinding)methodBinding5).originalMethod;
                        }
                    }
                    if ((methodBinding5 = this.computeCompatibleMethod((MethodBinding)binding, methodBinding4.parameters, invocationSite2)) == null || !methodBinding5.isValidBinding() || !this.isAcceptableMethod(methodBinding4, methodBinding5) || methodBinding2.isBridge() && !methodBinding.isBridge() && methodBinding4.areParametersEqual(methodBinding5)) continue block2;
                }
                methodBindingArray2[i] = methodBinding2;
                ++n3;
            }
        }
        if (n3 == 1) {
            for (n2 = 0; n2 < n; ++n2) {
                if (methodBindingArray2[n2] == null) continue;
                this.compilationUnitScope().recordTypeReferences(methodBindingArray[n2].thrownExceptions);
                return methodBindingArray[n2];
            }
        } else if (n3 == 0) {
            return new ProblemMethodBinding(methodBindingArray[0], methodBindingArray[0].selector, methodBindingArray[0].parameters, 3);
        }
        if (referenceBinding != null) {
            referenceBinding = referenceBinding instanceof CaptureBinding ? referenceBinding : (ReferenceBinding)referenceBinding.erasure();
        }
        block5: for (n2 = 0; n2 < n; ++n2) {
            MethodBinding methodBinding6 = methodBindingArray2[n2];
            if (methodBinding6 == null) continue;
            Object[] objectArray = null;
            methodBinding2 = methodBinding6.original();
            boolean bl = methodBinding2.declaringClass.isAbstract() && methodBinding2.thrownExceptions != Binding.NO_EXCEPTIONS;
            for (int i = 0; i < n; ++i) {
                int n5;
                int n6;
                MethodBinding methodBinding7 = methodBindingArray2[i];
                if (methodBinding7 == null || n2 == i) continue;
                methodBinding = methodBinding7.original();
                if (methodBinding2.declaringClass == methodBinding.declaringClass) break block5;
                if (!methodBinding2.isAbstract()) {
                    if (methodBinding.isAbstract() || (methodBinding = methodBinding2.findOriginalInheritedMethod(methodBinding)) != null && (!methodBinding6.hasSubstitutedParameters() && methodBinding2.typeVariables == Binding.NO_TYPE_VARIABLES || this.environment().methodVerifier().isParameterSubsignature(methodBinding2, methodBinding))) continue;
                    continue block5;
                }
                if (referenceBinding == null) continue;
                binding = referenceBinding.findSuperTypeOriginatingFrom(methodBinding2.declaringClass.erasure());
                if (methodBinding2.declaringClass != binding && binding instanceof ReferenceBinding) {
                    MethodBinding[] methodBindingArray3 = ((ReferenceBinding)binding).getMethods(methodBinding2.selector, typeBindingArray.length);
                    n6 = methodBindingArray3.length;
                    for (n5 = 0; n5 < n6; ++n5) {
                        if (methodBindingArray3[n5].original() != methodBinding2) continue;
                        methodBinding2 = methodBindingArray3[n5];
                        break;
                    }
                }
                if (methodBinding.declaringClass != (binding = referenceBinding.findSuperTypeOriginatingFrom(methodBinding.declaringClass.erasure())) && binding instanceof ReferenceBinding) {
                    MethodBinding[] methodBindingArray4 = ((ReferenceBinding)binding).getMethods(methodBinding.selector, typeBindingArray.length);
                    n6 = methodBindingArray4.length;
                    for (n5 = 0; n5 < n6; ++n5) {
                        if (methodBindingArray4[n5].original() != methodBinding) continue;
                        methodBinding = methodBindingArray4[n5];
                        break;
                    }
                }
                if (methodBinding2.typeVariables != Binding.NO_TYPE_VARIABLES) {
                    methodBinding = methodBinding2.computeSubstitutedMethod(methodBinding, this.environment());
                }
                if (methodBinding == null || !methodBinding2.areParameterErasuresEqual(methodBinding) || methodBinding2.returnType != methodBinding.returnType && (methodBinding7.original().typeVariables == Binding.NO_TYPE_VARIABLES ? !methodBinding6.returnType.isCompatibleWith(methodBinding7.returnType) : methodBinding2.returnType.erasure().findSuperTypeOriginatingFrom(methodBinding.returnType.erasure()) == null)) continue block5;
                if (!bl || !methodBinding.declaringClass.isInterface() || methodBinding6.thrownExceptions == methodBinding7.thrownExceptions) continue;
                if (methodBinding7.thrownExceptions == Binding.NO_EXCEPTIONS) {
                    objectArray = Binding.NO_EXCEPTIONS;
                    continue;
                }
                if (objectArray == null) {
                    objectArray = methodBinding6.thrownExceptions;
                }
                int n7 = objectArray.length;
                n5 = methodBinding7.thrownExceptions.length;
                SimpleSet simpleSet = new SimpleSet(n7);
                boolean bl2 = false;
                block9: for (int j = 0; j < n7; ++j) {
                    ReferenceBinding referenceBinding2 = objectArray[j];
                    for (int k = 0; k < n5; ++k) {
                        ReferenceBinding referenceBinding3 = methodBinding7.thrownExceptions[k];
                        if (referenceBinding2.isCompatibleWith(referenceBinding3)) {
                            simpleSet.add(referenceBinding2);
                            continue block9;
                        }
                        if (referenceBinding3.isCompatibleWith(referenceBinding2)) {
                            simpleSet.add(referenceBinding3);
                            bl2 = true;
                            continue block9;
                        }
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                objectArray = simpleSet.elementSize == 0 ? Binding.NO_EXCEPTIONS : new ReferenceBinding[simpleSet.elementSize];
                simpleSet.asArray(objectArray);
            }
            if (objectArray != null && objectArray != methodBinding6.thrownExceptions) {
                return new MostSpecificExceptionMethodBinding(methodBinding6, (ReferenceBinding[])objectArray);
            }
            return methodBinding6;
        }
        return new ProblemMethodBinding(methodBindingArray[0], methodBindingArray[0].selector, methodBindingArray[0].parameters, 3);
    }

    public final ClassScope outerMostClassScope() {
        ClassScope classScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            classScope = (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return classScope;
    }

    public final MethodScope outerMostMethodScope() {
        MethodScope methodScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            methodScope = (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return methodScope;
    }

    public int parameterCompatibilityLevel(MethodBinding methodBinding, TypeBinding[] typeBindingArray) {
        TypeBinding typeBinding;
        TypeBinding typeBinding2;
        TypeBinding[] typeBindingArray2 = methodBinding.parameters;
        int n = typeBindingArray2.length;
        int n2 = typeBindingArray.length;
        if (this.compilerOptions().sourceLevel < 0x310000L) {
            if (n != n2) {
                return -1;
            }
            for (int i = 0; i < n2; ++i) {
                TypeBinding typeBinding3 = typeBindingArray[i];
                TypeBinding typeBinding4 = typeBindingArray2[i];
                if (typeBinding3 == typeBinding4 || typeBinding3.isCompatibleWith(typeBinding4.erasure())) continue;
                return -1;
            }
            return 0;
        }
        int n3 = 0;
        int n4 = n2;
        LookupEnvironment lookupEnvironment = this.environment();
        if (methodBinding.isVarargs()) {
            TypeBinding typeBinding5;
            n4 = n - 1;
            if (n == n2) {
                typeBinding5 = typeBindingArray2[n4];
                typeBinding2 = typeBindingArray[n4];
                if (typeBinding5 != typeBinding2 && (n3 = this.parameterCompatibilityLevel(typeBinding2, typeBinding5, lookupEnvironment)) == -1) {
                    if (this.parameterCompatibilityLevel(typeBinding2, typeBinding5 = ((ArrayBinding)typeBinding5).elementsType(), lookupEnvironment) == -1) {
                        return -1;
                    }
                    n3 = 2;
                }
            } else {
                if (n < n2) {
                    typeBinding5 = ((ArrayBinding)typeBindingArray2[n4]).elementsType();
                    for (int i = n4; i < n2; ++i) {
                        typeBinding = typeBindingArray[i];
                        if (typeBinding5 == typeBinding || this.parameterCompatibilityLevel(typeBinding, typeBinding5, lookupEnvironment) != -1) continue;
                        return -1;
                    }
                } else if (n4 != n2) {
                    return -1;
                }
                n3 = 2;
            }
        } else if (n != n2) {
            return -1;
        }
        for (int i = 0; i < n4; ++i) {
            typeBinding = typeBindingArray[i];
            typeBinding2 = typeBindingArray2[i];
            if (typeBinding == typeBinding2) continue;
            int n5 = this.parameterCompatibilityLevel(typeBinding, typeBinding2, lookupEnvironment);
            if (n5 == -1) {
                return -1;
            }
            if (n5 <= n3) continue;
            n3 = n5;
        }
        return n3;
    }

    private int parameterCompatibilityLevel(TypeBinding typeBinding, TypeBinding typeBinding2, LookupEnvironment lookupEnvironment) {
        TypeBinding typeBinding3;
        if (typeBinding.isCompatibleWith(typeBinding2)) {
            return 0;
        }
        if (typeBinding.isBaseType() != typeBinding2.isBaseType() && ((typeBinding3 = lookupEnvironment.computeBoxingType(typeBinding)) == typeBinding2 || typeBinding3.isCompatibleWith(typeBinding2))) {
            return 1;
        }
        return -1;
    }

    public abstract ProblemReporter problemReporter();

    public final CompilationUnitDeclaration referenceCompilationUnit() {
        Scope scope;
        Scope scope2 = this;
        while ((scope = scope2.parent) != null) {
            scope2 = scope;
        }
        return ((CompilationUnitScope)scope2).referenceContext;
    }

    public ReferenceContext referenceContext() {
        Scope scope = this;
        do {
            switch (scope.kind) {
                case 2: {
                    return ((MethodScope)scope).referenceContext;
                }
                case 3: {
                    return ((ClassScope)scope).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)scope).referenceContext;
                }
            }
        } while ((scope = scope.parent) != null);
        return null;
    }

    public void deferBoundCheck(TypeReference typeReference) {
        if (this.kind == 3) {
            ClassScope classScope = (ClassScope)this;
            if (classScope.deferredBoundChecks == null) {
                classScope.deferredBoundChecks = new ArrayList(3);
                classScope.deferredBoundChecks.add(typeReference);
            } else if (!classScope.deferredBoundChecks.contains(typeReference)) {
                classScope.deferredBoundChecks.add(typeReference);
            }
        }
    }

    int startIndex() {
        return 0;
    }

    public MethodBinding getStaticFactory(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        Object object;
        int n;
        TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
        int n2 = typeVariableBindingArray.length;
        MethodBinding[] methodBindingArray = referenceBinding.getMethods(TypeConstants.INIT, typeBindingArray.length);
        MethodBinding[] methodBindingArray2 = new MethodBinding[methodBindingArray.length];
        int n3 = 0;
        int n4 = methodBindingArray.length;
        for (int i = 0; i < n4; ++i) {
            int n5;
            TypeBinding[] typeBindingArray2;
            Object object2;
            int n6;
            MethodBinding methodBinding = methodBindingArray[i];
            int n7 = methodBinding.parameters.length;
            n = methodBinding.isVarargs();
            if (typeBindingArray.length != n7 && (n == 0 || typeBindingArray.length < n7 - 1)) continue;
            object = methodBinding.typeVariables();
            int n8 = ((TypeVariableBinding[])object).length;
            MethodBinding methodBinding2 = new MethodBinding(methodBinding.modifiers | 8, TypeConstants.SYNTHETIC_STATIC_FACTORY, null, null, null, methodBinding.declaringClass);
            methodBinding2.typeVariables = new TypeVariableBinding[n2 + n8];
            final SimpleLookupTable simpleLookupTable = new SimpleLookupTable(n2 + n8);
            LookupEnvironment lookupEnvironment = this.environment();
            for (n6 = 0; n6 < n2; ++n6) {
                methodBinding2.typeVariables[n6] = new TypeVariableBinding(CharOperation.concat(typeVariableBindingArray[n6].sourceName, "'".toCharArray()), methodBinding2, n6, lookupEnvironment);
                simpleLookupTable.put(typeVariableBindingArray[n6], methodBinding2.typeVariables[n6]);
            }
            int n9 = n2 + n8;
            for (n6 = n2; n6 < n9; ++n6) {
                methodBinding2.typeVariables[n6] = new TypeVariableBinding(CharOperation.concat(((TypeVariableBinding)object[n6 - n2]).sourceName, "''".toCharArray()), methodBinding2, n6, lookupEnvironment);
                simpleLookupTable.put(object[n6 - n2], methodBinding2.typeVariables[n6]);
            }
            for (ReferenceBinding referenceBinding3 = referenceBinding2; referenceBinding3 != null; referenceBinding3 = referenceBinding3.enclosingType()) {
                if (referenceBinding3.kind() != 260) continue;
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding3;
                object2 = parameterizedTypeBinding.genericType();
                typeBindingArray2 = ((TypeBinding)object2).typeVariables();
                n5 = typeBindingArray2.length;
                for (int j = 0; j < n5; ++j) {
                    simpleLookupTable.put(typeBindingArray2[j], parameterizedTypeBinding.arguments[j]);
                }
            }
            final Scope scope = this;
            object2 = new Substitution(){

                public LookupEnvironment environment() {
                    return scope.environment();
                }

                public boolean isRawSubstitution() {
                    return false;
                }

                public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
                    TypeBinding typeBinding = (TypeBinding)simpleLookupTable.get(typeVariableBinding);
                    return typeBinding != null ? typeBinding : typeVariableBinding;
                }
            };
            n5 = n2 + n8;
            block8: for (int j = 0; j < n5; ++j) {
                Object object3 = j < n2 ? typeVariableBindingArray[j] : object[j - n2];
                TypeBinding typeBinding = (TypeBinding)simpleLookupTable.get(object3);
                if (!(typeBinding instanceof TypeVariableBinding)) continue;
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBinding;
                TypeBinding typeBinding2 = Scope.substitute((Substitution)object2, ((TypeVariableBinding)object3).superclass);
                ReferenceBinding[] referenceBindingArray = Scope.substitute((Substitution)object2, ((TypeVariableBinding)object3).superInterfaces);
                if (((TypeVariableBinding)object3).firstBound != null) {
                    typeVariableBinding.firstBound = ((TypeVariableBinding)object3).firstBound == ((TypeVariableBinding)object3).superclass ? typeBinding2 : referenceBindingArray[0];
                }
                switch (typeBinding2.kind()) {
                    case 68: {
                        typeVariableBinding.superclass = lookupEnvironment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
                        typeVariableBinding.superInterfaces = referenceBindingArray;
                        continue block8;
                    }
                    default: {
                        if (typeBinding2.isInterface()) {
                            typeVariableBinding.superclass = lookupEnvironment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
                            int n10 = referenceBindingArray.length;
                            ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                            referenceBindingArray = new ReferenceBinding[n10 + 1];
                            System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 1, n10);
                            referenceBindingArray[0] = (ReferenceBinding)typeBinding2;
                            typeVariableBinding.superInterfaces = referenceBindingArray;
                            continue block8;
                        }
                        typeVariableBinding.superclass = (ReferenceBinding)typeBinding2;
                        typeVariableBinding.superInterfaces = referenceBindingArray;
                    }
                }
            }
            typeBindingArray2 = new TypeVariableBinding[n2];
            for (n5 = 0; n5 < n2; ++n5) {
                typeBindingArray2[n5] = (TypeVariableBinding)simpleLookupTable.get(typeVariableBindingArray[n5]);
            }
            methodBinding2.returnType = lookupEnvironment.createParameterizedType(referenceBinding, typeBindingArray2, referenceBinding.enclosingType());
            methodBinding2.parameters = Scope.substitute((Substitution)object2, methodBinding.parameters);
            methodBinding2.thrownExceptions = Scope.substitute((Substitution)object2, methodBinding.thrownExceptions);
            if (methodBinding2.thrownExceptions == null) {
                methodBinding2.thrownExceptions = Binding.NO_EXCEPTIONS;
            }
            methodBindingArray2[n3++] = new ParameterizedMethodBinding((ParameterizedTypeBinding)lookupEnvironment.convertToParameterizedType(methodBinding2.declaringClass), methodBinding2);
        }
        if (n3 == 0) {
            return null;
        }
        if (n3 != methodBindingArray.length) {
            MethodBinding[] methodBindingArray3 = methodBindingArray2;
            methodBindingArray2 = new MethodBinding[n3];
            System.arraycopy(methodBindingArray3, 0, methodBindingArray2, 0, n3);
        }
        MethodBinding[] methodBindingArray4 = new MethodBinding[n3];
        n4 = 0;
        for (int i = 0; i < n3; ++i) {
            MethodBinding methodBinding = this.computeCompatibleMethod(methodBindingArray2[i], typeBindingArray, invocationSite);
            if (methodBinding == null || !methodBinding.isValidBinding()) continue;
            methodBindingArray4[n4++] = methodBinding;
        }
        if (n4 == 0) {
            return null;
        }
        MethodBinding[] methodBindingArray5 = new MethodBinding[n4];
        int n11 = 0;
        for (n = 0; n < n4; ++n) {
            object = methodBindingArray4[n];
            if (!((MethodBinding)object).canBeSeenBy(invocationSite, this)) continue;
            methodBindingArray5[n11++] = object;
        }
        if (n11 == 0) {
            return null;
        }
        return n11 == 1 ? methodBindingArray5[0] : this.mostSpecificMethodBinding(methodBindingArray5, n11, typeBindingArray, invocationSite, referenceBinding);
    }
}

