/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredAnnotation;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredField;
import org.eclipse.jdt.internal.compiler.parser.RecoveredInitializer;
import org.eclipse.jdt.internal.compiler.parser.RecoveredMethod;
import org.eclipse.jdt.internal.compiler.parser.RecoveredStatement;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;

public class RecoveredType
extends RecoveredStatement
implements TerminalTokens {
    public static final int MAX_TYPE_DEPTH = 256;
    public TypeDeclaration typeDeclaration;
    public RecoveredAnnotation[] annotations;
    public int annotationCount;
    public int modifiers;
    public int modifiersStart;
    public RecoveredType[] memberTypes;
    public int memberTypeCount;
    public RecoveredField[] fields;
    public int fieldCount;
    public RecoveredMethod[] methods;
    public int methodCount;
    public boolean preserveContent = false;
    public int bodyEnd;
    public boolean insideEnumConstantPart = false;
    public TypeParameter[] pendingTypeParameters;
    public int pendingTypeParametersStart;
    int pendingModifiers;
    int pendingModifersSourceStart = -1;
    RecoveredAnnotation[] pendingAnnotations;
    int pendingAnnotationCount;

    public RecoveredType(TypeDeclaration typeDeclaration, RecoveredElement recoveredElement, int n) {
        super(typeDeclaration, recoveredElement, n);
        this.typeDeclaration = typeDeclaration;
        this.foundOpeningBrace = typeDeclaration.allocation != null && typeDeclaration.allocation.type == null ? true : !this.bodyStartsAtHeaderEnd();
        boolean bl = this.insideEnumConstantPart = TypeDeclaration.kind(typeDeclaration.modifiers) == 3;
        if (this.foundOpeningBrace) {
            ++this.bracketBalance;
        }
        this.preserveContent = this.parser().methodRecoveryActivated || this.parser().statementRecoveryActivated;
    }

    public RecoveredElement add(AbstractMethodDeclaration abstractMethodDeclaration, int n) {
        if (this.typeDeclaration.declarationSourceEnd != 0 && abstractMethodDeclaration.declarationSourceStart > this.typeDeclaration.declarationSourceEnd) {
            this.pendingTypeParameters = null;
            this.resetPendingModifiers();
            return this.parent.add(abstractMethodDeclaration, n);
        }
        if (this.methods == null) {
            this.methods = new RecoveredMethod[5];
            this.methodCount = 0;
        } else if (this.methodCount == this.methods.length) {
            this.methods = new RecoveredMethod[2 * this.methodCount];
            System.arraycopy(this.methods, 0, this.methods, 0, this.methodCount);
        }
        RecoveredMethod recoveredMethod = new RecoveredMethod(abstractMethodDeclaration, this, n, this.recoveringParser);
        this.methods[this.methodCount++] = recoveredMethod;
        if (this.pendingTypeParameters != null) {
            recoveredMethod.attach(this.pendingTypeParameters, this.pendingTypeParametersStart);
            this.pendingTypeParameters = null;
        }
        if (this.pendingAnnotationCount > 0) {
            recoveredMethod.attach(this.pendingAnnotations, this.pendingAnnotationCount, this.pendingModifiers, this.pendingModifersSourceStart);
        }
        this.resetPendingModifiers();
        this.insideEnumConstantPart = false;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (abstractMethodDeclaration.declarationSourceEnd == 0) {
            return recoveredMethod;
        }
        return this;
    }

    public RecoveredElement add(Block block, int n) {
        this.pendingTypeParameters = null;
        this.resetPendingModifiers();
        int n2 = 0;
        if (this.parser().recoveredStaticInitializerStart != 0) {
            n2 = 8;
        }
        return this.add(new Initializer(block, n2), n);
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n) {
        RecoveredField recoveredField;
        this.pendingTypeParameters = null;
        if (this.typeDeclaration.declarationSourceEnd != 0 && fieldDeclaration.declarationSourceStart > this.typeDeclaration.declarationSourceEnd) {
            this.resetPendingModifiers();
            return this.parent.add(fieldDeclaration, n);
        }
        if (this.fields == null) {
            this.fields = new RecoveredField[5];
            this.fieldCount = 0;
        } else if (this.fieldCount == this.fields.length) {
            this.fields = new RecoveredField[2 * this.fieldCount];
            System.arraycopy(this.fields, 0, this.fields, 0, this.fieldCount);
        }
        switch (fieldDeclaration.getKind()) {
            case 1: 
            case 3: {
                recoveredField = new RecoveredField(fieldDeclaration, this, n);
                break;
            }
            case 2: {
                recoveredField = new RecoveredInitializer(fieldDeclaration, this, n);
                break;
            }
            default: {
                return this;
            }
        }
        this.fields[this.fieldCount++] = recoveredField;
        if (this.pendingAnnotationCount > 0) {
            recoveredField.attach(this.pendingAnnotations, this.pendingAnnotationCount, this.pendingModifiers, this.pendingModifersSourceStart);
        }
        this.resetPendingModifiers();
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (fieldDeclaration.declarationSourceEnd == 0) {
            return recoveredField;
        }
        return this;
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        this.pendingTypeParameters = null;
        if (this.typeDeclaration.declarationSourceEnd != 0 && typeDeclaration.declarationSourceStart > this.typeDeclaration.declarationSourceEnd) {
            this.resetPendingModifiers();
            return this.parent.add(typeDeclaration, n);
        }
        this.insideEnumConstantPart = false;
        if ((typeDeclaration.bits & 0x200) != 0) {
            if (this.methodCount > 0) {
                RecoveredMethod recoveredMethod = this.methods[this.methodCount - 1];
                recoveredMethod.methodDeclaration.bodyEnd = 0;
                recoveredMethod.methodDeclaration.declarationSourceEnd = 0;
                ++recoveredMethod.bracketBalance;
                this.resetPendingModifiers();
                return recoveredMethod.add(typeDeclaration, n);
            }
            return this;
        }
        if (this.memberTypes == null) {
            this.memberTypes = new RecoveredType[5];
            this.memberTypeCount = 0;
        } else if (this.memberTypeCount == this.memberTypes.length) {
            this.memberTypes = new RecoveredType[2 * this.memberTypeCount];
            System.arraycopy(this.memberTypes, 0, this.memberTypes, 0, this.memberTypeCount);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n);
        this.memberTypes[this.memberTypeCount++] = recoveredType;
        if (this.pendingAnnotationCount > 0) {
            recoveredType.attach(this.pendingAnnotations, this.pendingAnnotationCount, this.pendingModifiers, this.pendingModifersSourceStart);
        }
        this.resetPendingModifiers();
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (typeDeclaration.declarationSourceEnd == 0) {
            return recoveredType;
        }
        return this;
    }

    public void add(TypeParameter[] typeParameterArray, int n) {
        this.pendingTypeParameters = typeParameterArray;
        this.pendingTypeParametersStart = n;
    }

    public RecoveredElement addAnnotationName(int n, int n2, int n3, int n4) {
        if (this.pendingAnnotations == null) {
            this.pendingAnnotations = new RecoveredAnnotation[5];
            this.pendingAnnotationCount = 0;
        } else if (this.pendingAnnotationCount == this.pendingAnnotations.length) {
            this.pendingAnnotations = new RecoveredAnnotation[2 * this.pendingAnnotationCount];
            System.arraycopy(this.pendingAnnotations, 0, this.pendingAnnotations, 0, this.pendingAnnotationCount);
        }
        RecoveredAnnotation recoveredAnnotation = new RecoveredAnnotation(n, n2, n3, this, n4);
        this.pendingAnnotations[this.pendingAnnotationCount++] = recoveredAnnotation;
        return recoveredAnnotation;
    }

    public void addModifier(int n, int n2) {
        this.pendingModifiers |= n;
        if (this.pendingModifersSourceStart < 0) {
            this.pendingModifersSourceStart = n2;
        }
    }

    public void attach(RecoveredAnnotation[] recoveredAnnotationArray, int n, int n2, int n3) {
        if (n > 0) {
            Annotation[] annotationArray = this.typeDeclaration.annotations;
            if (annotationArray != null) {
                this.annotations = new RecoveredAnnotation[n];
                this.annotationCount = 0;
                block0: for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < annotationArray.length; ++j) {
                        if (recoveredAnnotationArray[i].annotation == annotationArray[j]) continue block0;
                    }
                    this.annotations[this.annotationCount++] = recoveredAnnotationArray[i];
                }
            } else {
                this.annotations = recoveredAnnotationArray;
                this.annotationCount = n;
            }
        }
        if (n2 != 0) {
            this.modifiers = n2;
            this.modifiersStart = n3;
        }
    }

    public int bodyEnd() {
        if (this.bodyEnd == 0) {
            return this.typeDeclaration.declarationSourceEnd;
        }
        return this.bodyEnd;
    }

    public boolean bodyStartsAtHeaderEnd() {
        if (this.typeDeclaration.superInterfaces == null) {
            if (this.typeDeclaration.superclass == null) {
                if (this.typeDeclaration.typeParameters == null) {
                    return this.typeDeclaration.bodyStart == this.typeDeclaration.sourceEnd + 1;
                }
                return this.typeDeclaration.bodyStart == this.typeDeclaration.typeParameters[this.typeDeclaration.typeParameters.length - 1].sourceEnd + 1;
            }
            return this.typeDeclaration.bodyStart == this.typeDeclaration.superclass.sourceEnd + 1;
        }
        return this.typeDeclaration.bodyStart == this.typeDeclaration.superInterfaces[this.typeDeclaration.superInterfaces.length - 1].sourceEnd + 1;
    }

    public RecoveredType enclosingType() {
        RecoveredElement recoveredElement = this.parent;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredType) {
                return (RecoveredType)recoveredElement;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public int lastMemberEnd() {
        ASTNode aSTNode;
        int n = this.typeDeclaration.bodyStart;
        if (this.fieldCount > 0) {
            aSTNode = this.fields[this.fieldCount - 1].fieldDeclaration;
            if (n < aSTNode.declarationSourceEnd && aSTNode.declarationSourceEnd != 0) {
                n = aSTNode.declarationSourceEnd;
            }
        }
        if (this.methodCount > 0) {
            aSTNode = this.methods[this.methodCount - 1].methodDeclaration;
            if (n < ((AbstractMethodDeclaration)aSTNode).declarationSourceEnd && ((AbstractMethodDeclaration)aSTNode).declarationSourceEnd != 0) {
                n = ((AbstractMethodDeclaration)aSTNode).declarationSourceEnd;
            }
        }
        if (this.memberTypeCount > 0) {
            aSTNode = this.memberTypes[this.memberTypeCount - 1].typeDeclaration;
            if (n < ((TypeDeclaration)aSTNode).declarationSourceEnd && ((TypeDeclaration)aSTNode).declarationSourceEnd != 0) {
                n = ((TypeDeclaration)aSTNode).declarationSourceEnd;
            }
        }
        return n;
    }

    public char[] name() {
        return this.typeDeclaration.name;
    }

    public ASTNode parseTree() {
        return this.typeDeclaration;
    }

    public void resetPendingModifiers() {
        this.pendingAnnotations = null;
        this.pendingAnnotationCount = 0;
        this.pendingModifiers = 0;
        this.pendingModifersSourceStart = -1;
    }

    public int sourceEnd() {
        return this.typeDeclaration.declarationSourceEnd;
    }

    public String toString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n));
        stringBuffer.append("Recovered type:\n");
        if ((this.typeDeclaration.bits & 0x200) != 0) {
            stringBuffer.append(this.tabString(n));
            stringBuffer.append(" ");
        }
        this.typeDeclaration.print(n + 1, stringBuffer);
        if (this.annotations != null) {
            for (n2 = 0; n2 < this.annotationCount; ++n2) {
                stringBuffer.append("\n");
                stringBuffer.append(this.annotations[n2].toString(n + 1));
            }
        }
        if (this.memberTypes != null) {
            for (n2 = 0; n2 < this.memberTypeCount; ++n2) {
                stringBuffer.append("\n");
                stringBuffer.append(this.memberTypes[n2].toString(n + 1));
            }
        }
        if (this.fields != null) {
            for (n2 = 0; n2 < this.fieldCount; ++n2) {
                stringBuffer.append("\n");
                stringBuffer.append(this.fields[n2].toString(n + 1));
            }
        }
        if (this.methods != null) {
            for (n2 = 0; n2 < this.methodCount; ++n2) {
                stringBuffer.append("\n");
                stringBuffer.append(this.methods[n2].toString(n + 1));
            }
        }
        return stringBuffer.toString();
    }

    public void updateBodyStart(int n) {
        this.foundOpeningBrace = true;
        this.typeDeclaration.bodyStart = n;
    }

    public Statement updatedStatement(int n, Set set) {
        if ((this.typeDeclaration.bits & 0x200) != 0 && !this.preserveContent) {
            return null;
        }
        TypeDeclaration typeDeclaration = this.updatedTypeDeclaration(n + 1, set);
        if (typeDeclaration != null && (typeDeclaration.bits & 0x200) != 0) {
            QualifiedAllocationExpression qualifiedAllocationExpression = typeDeclaration.allocation;
            if (qualifiedAllocationExpression.statementEnd == -1) {
                qualifiedAllocationExpression.statementEnd = typeDeclaration.declarationSourceEnd;
            }
            return qualifiedAllocationExpression;
        }
        return typeDeclaration;
    }

    public TypeDeclaration updatedTypeDeclaration(int n, Set set) {
        Object object;
        int n2;
        AbstractMethodDeclaration[] abstractMethodDeclarationArray;
        int n3;
        int n4;
        Statement[] statementArray;
        int n5;
        if (n >= 256) {
            return null;
        }
        if (set.contains(this.typeDeclaration)) {
            return null;
        }
        set.add(this.typeDeclaration);
        int n6 = this.typeDeclaration.bodyStart;
        if (this.modifiers != 0) {
            this.typeDeclaration.modifiers |= this.modifiers;
            if (this.modifiersStart < this.typeDeclaration.declarationSourceStart) {
                this.typeDeclaration.declarationSourceStart = this.modifiersStart;
            }
        }
        if (this.annotationCount > 0) {
            n5 = this.typeDeclaration.annotations == null ? 0 : this.typeDeclaration.annotations.length;
            statementArray = new Annotation[n5 + this.annotationCount];
            if (n5 > 0) {
                System.arraycopy(this.typeDeclaration.annotations, 0, statementArray, this.annotationCount, n5);
            }
            for (n4 = 0; n4 < this.annotationCount; ++n4) {
                statementArray[n4] = this.annotations[n4].updatedAnnotationReference();
            }
            this.typeDeclaration.annotations = statementArray;
            n4 = this.annotations[0].annotation.sourceStart;
            if (n4 < this.typeDeclaration.declarationSourceStart) {
                this.typeDeclaration.declarationSourceStart = n4;
            }
        }
        if (this.memberTypeCount > 0) {
            n5 = this.typeDeclaration.memberTypes == null ? 0 : this.typeDeclaration.memberTypes.length;
            statementArray = new TypeDeclaration[n5 + this.memberTypeCount];
            if (n5 > 0) {
                System.arraycopy(this.typeDeclaration.memberTypes, 0, statementArray, 0, n5);
            }
            if (this.memberTypes[this.memberTypeCount - 1].typeDeclaration.declarationSourceEnd == 0) {
                this.memberTypes[this.memberTypeCount - 1].typeDeclaration.declarationSourceEnd = n4 = this.bodyEnd();
                this.memberTypes[this.memberTypeCount - 1].typeDeclaration.bodyEnd = n4;
            }
            n4 = 0;
            for (n3 = 0; n3 < this.memberTypeCount; ++n3) {
                TypeDeclaration typeDeclaration = this.memberTypes[n3].updatedTypeDeclaration(n + 1, set);
                if (typeDeclaration == null) continue;
                statementArray[n5 + n4++] = typeDeclaration;
            }
            if (n4 < this.memberTypeCount) {
                n3 = n5 + n4;
                Statement[] statementArray2 = statementArray;
                statementArray = new TypeDeclaration[n3];
                System.arraycopy(statementArray2, 0, statementArray, 0, n3);
            }
            if (statementArray.length > 0) {
                this.typeDeclaration.memberTypes = statementArray;
                if (((TypeDeclaration)statementArray[statementArray.length - 1]).declarationSourceEnd > n6) {
                    n6 = ((TypeDeclaration)statementArray[statementArray.length - 1]).declarationSourceEnd;
                }
            }
        }
        if (this.fieldCount > 0) {
            n5 = this.typeDeclaration.fields == null ? 0 : this.typeDeclaration.fields.length;
            statementArray = new FieldDeclaration[n5 + this.fieldCount];
            if (n5 > 0) {
                System.arraycopy(this.typeDeclaration.fields, 0, statementArray, 0, n5);
            }
            if (this.fields[this.fieldCount - 1].fieldDeclaration.declarationSourceEnd == 0) {
                this.fields[this.fieldCount - 1].fieldDeclaration.declarationSourceEnd = n4 = this.bodyEnd();
                this.fields[this.fieldCount - 1].fieldDeclaration.declarationEnd = n4;
            }
            for (n4 = 0; n4 < this.fieldCount; ++n4) {
                statementArray[n5 + n4] = this.fields[n4].updatedFieldDeclaration(n, set);
            }
            for (n4 = this.fieldCount - 1; 0 < n4; --n4) {
                if (((FieldDeclaration)statementArray[n5 + n4 - 1]).declarationSourceStart != ((FieldDeclaration)statementArray[n5 + n4]).declarationSourceStart) continue;
                ((FieldDeclaration)statementArray[n5 + n4 - 1]).declarationSourceEnd = ((FieldDeclaration)statementArray[n5 + n4]).declarationSourceEnd;
                ((FieldDeclaration)statementArray[n5 + n4 - 1]).declarationEnd = ((FieldDeclaration)statementArray[n5 + n4]).declarationEnd;
            }
            this.typeDeclaration.fields = statementArray;
            if (((FieldDeclaration)statementArray[statementArray.length - 1]).declarationSourceEnd > n6) {
                n6 = ((FieldDeclaration)statementArray[statementArray.length - 1]).declarationSourceEnd;
            }
        }
        n5 = this.typeDeclaration.methods == null ? 0 : this.typeDeclaration.methods.length;
        boolean bl = false;
        n4 = 0;
        n3 = 0;
        int n7 = -1;
        if (this.methodCount > 0) {
            abstractMethodDeclarationArray = new AbstractMethodDeclaration[n5 + this.methodCount];
            for (n2 = 0; n2 < n5; ++n2) {
                object = this.typeDeclaration.methods[n2];
                if (((AbstractMethodDeclaration)object).isDefaultConstructor()) {
                    n7 = n2;
                }
                if (((AbstractMethodDeclaration)object).isAbstract()) {
                    n3 = 1;
                }
                abstractMethodDeclarationArray[n2] = object;
            }
            if (this.methods[this.methodCount - 1].methodDeclaration.declarationSourceEnd == 0) {
                this.methods[this.methodCount - 1].methodDeclaration.declarationSourceEnd = n2 = this.bodyEnd();
                this.methods[this.methodCount - 1].methodDeclaration.bodyEnd = n2;
            }
            for (n2 = 0; n2 < this.methodCount; ++n2) {
                object = this.methods[n2].updatedMethodDeclaration(n, set);
                if (((AbstractMethodDeclaration)object).isConstructor()) {
                    n4 = 1;
                }
                if (((AbstractMethodDeclaration)object).isAbstract()) {
                    n3 = 1;
                }
                abstractMethodDeclarationArray[n5 + n2] = object;
            }
            this.typeDeclaration.methods = abstractMethodDeclarationArray;
            if (abstractMethodDeclarationArray[abstractMethodDeclarationArray.length - 1].declarationSourceEnd > n6) {
                n6 = abstractMethodDeclarationArray[abstractMethodDeclarationArray.length - 1].declarationSourceEnd;
            }
            if (n3 != 0) {
                this.typeDeclaration.bits |= 0x800;
            }
            bl = this.typeDeclaration.checkConstructors(this.parser());
        } else {
            for (int i = 0; i < n5; ++i) {
                if (!this.typeDeclaration.methods[i].isConstructor()) continue;
                bl = true;
            }
        }
        if (this.typeDeclaration.needClassInitMethod()) {
            boolean bl2 = false;
            for (n2 = 0; n2 < n5; ++n2) {
                if (!this.typeDeclaration.methods[n2].isClinit()) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.typeDeclaration.addClinit();
            }
        }
        if (n7 >= 0 && n4 != 0) {
            abstractMethodDeclarationArray = new AbstractMethodDeclaration[this.typeDeclaration.methods.length - 1];
            if (n7 != 0) {
                System.arraycopy(this.typeDeclaration.methods, 0, abstractMethodDeclarationArray, 0, n7);
            }
            if (n7 != this.typeDeclaration.methods.length - 1) {
                System.arraycopy(this.typeDeclaration.methods, n7 + 1, abstractMethodDeclarationArray, n7, this.typeDeclaration.methods.length - n7 - 1);
            }
            this.typeDeclaration.methods = abstractMethodDeclarationArray;
        } else {
            int n8 = TypeDeclaration.kind(this.typeDeclaration.modifiers);
            if (!bl && n8 != 2 && n8 != 4 && this.typeDeclaration.allocation == null) {
                n2 = 0;
                object = this.parent;
                while (object != null) {
                    if (object instanceof RecoveredField) {
                        n2 = 1;
                        break;
                    }
                    object = ((RecoveredElement)object).parent;
                }
                this.typeDeclaration.createDefaultConstructor(!this.parser().diet || n2 != 0, true);
            }
        }
        if (this.parent instanceof RecoveredType) {
            this.typeDeclaration.bits |= 0x400;
        } else if (this.parent instanceof RecoveredMethod) {
            this.typeDeclaration.bits |= 0x100;
        }
        if (this.typeDeclaration.declarationSourceEnd == 0) {
            this.typeDeclaration.declarationSourceEnd = n6;
            this.typeDeclaration.bodyEnd = n6;
        }
        return this.typeDeclaration;
    }

    public void updateFromParserState() {
        if (this.bodyStartsAtHeaderEnd() && this.typeDeclaration.allocation == null) {
            Parser parser = this.parser();
            if (parser.listLength > 0 && parser.astLengthPtr > 0) {
                boolean bl;
                int n = parser.astLengthStack[parser.astLengthPtr];
                int n2 = parser.astPtr - n;
                boolean bl2 = bl = n2 >= 0;
                if (bl) {
                    if (!(parser.astStack[n2] instanceof TypeDeclaration)) {
                        bl = false;
                    }
                    int n3 = n + 1;
                    for (int i = 1; i < n3; ++i) {
                        if (parser.astStack[n2 + i] instanceof TypeReference) continue;
                        bl = false;
                    }
                }
                if (bl) {
                    parser.consumeClassHeaderImplements();
                }
            } else if (parser.listTypeParameterLength > 0) {
                boolean bl;
                int n = parser.genericsPtr;
                int n4 = parser.listTypeParameterLength;
                boolean bl3 = bl = n + 1 >= n4 && parser.astPtr > -1;
                if (bl) {
                    if (!(parser.astStack[parser.astPtr] instanceof TypeDeclaration)) {
                        bl = false;
                    }
                    while (n + 1 > n4 && !(parser.genericsStack[n] instanceof TypeParameter)) {
                        --n;
                    }
                    for (int i = 0; i < n4; ++i) {
                        if (parser.genericsStack[n - i] instanceof TypeParameter) continue;
                        bl = false;
                    }
                }
                if (bl) {
                    TypeDeclaration typeDeclaration = (TypeDeclaration)parser.astStack[parser.astPtr];
                    typeDeclaration.typeParameters = new TypeParameter[n4];
                    System.arraycopy(parser.genericsStack, n - n4 + 1, typeDeclaration.typeParameters, 0, n4);
                    typeDeclaration.bodyStart = typeDeclaration.typeParameters[n4 - 1].declarationSourceEnd + 1;
                    parser.listTypeParameterLength = 0;
                    parser.lastCheckPoint = typeDeclaration.bodyStart;
                }
            }
        }
    }

    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(n, n2);
            this.bodyEnd = n - 1;
            return this.parent;
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int n, int n2) {
        TypeIds typeIds;
        if (this.bracketBalance == 0) {
            typeIds = this.parser();
            switch (typeIds.lastIgnoredToken) {
                case -1: 
                case 10: 
                case 11: 
                case 12: 
                case 99: 
                case 106: {
                    if (typeIds.recoveredStaticInitializerStart == 0) break;
                }
                default: {
                    this.foundOpeningBrace = true;
                    this.bracketBalance = 1;
                }
            }
        }
        if (this.bracketBalance == 1) {
            Initializer initializer;
            typeIds = new Block(0);
            Parser parser = this.parser();
            ((Block)typeIds).sourceStart = parser.scanner.startPosition;
            if (parser.recoveredStaticInitializerStart == 0) {
                initializer = new Initializer((Block)typeIds, 0);
            } else {
                initializer = new Initializer((Block)typeIds, 8);
                initializer.declarationSourceStart = parser.recoveredStaticInitializerStart;
            }
            initializer.bodyStart = parser.scanner.currentPosition;
            return this.add(initializer, 1);
        }
        return super.updateOnOpeningBrace(n, n2);
    }

    public void updateParseTree() {
        this.updatedTypeDeclaration(0, new HashSet());
    }

    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.typeDeclaration.declarationSourceEnd == 0) {
            this.bodyEnd = 0;
            this.typeDeclaration.declarationSourceEnd = n2;
            this.typeDeclaration.bodyEnd = n2;
        }
    }
}

