/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class Clinit
extends AbstractMethodDeclaration {
    private static int ENUM_CONSTANTS_THRESHOLD = 2000;
    private FieldBinding assertionSyntheticFieldBinding = null;
    private FieldBinding classLiteralSyntheticField = null;

    public Clinit(CompilationResult compilationResult) {
        super(compilationResult);
        this.modifiers = 0;
        this.selector = TypeConstants.CLINIT;
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationFlowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            ExceptionHandlingFlowContext exceptionHandlingFlowContext = new ExceptionHandlingFlowContext(initializationFlowContext.parent, this, Binding.NO_EXCEPTIONS, initializationFlowContext, this.scope, FlowInfo.DEAD_END);
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= 0x40;
            }
            flowInfo = flowInfo.mergedWith(initializationFlowContext.initsOnReturn);
            FieldBinding[] fieldBindingArray = this.scope.enclosingSourceType().fields();
            int n = fieldBindingArray.length;
            for (int i = 0; i < n; ++i) {
                FieldBinding fieldBinding = fieldBindingArray[i];
                if (!fieldBinding.isStatic() || !fieldBinding.isFinal() || flowInfo.isDefinitelyAssigned(fieldBindingArray[i])) continue;
                this.scope.problemReporter().uninitializedBlankFinalField(fieldBinding, this.scope.referenceType().declarationOf(fieldBinding.original()));
            }
            initializationFlowContext.checkInitializerExceptions(this.scope, exceptionHandlingFlowContext, flowInfo);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int n = 0;
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        boolean bl = false;
        do {
            try {
                n = classFile.contentsOffset;
                this.generateCode(classScope, classFile, n);
                bl = false;
            }
            catch (AbortMethod abortMethod) {
                if (abortMethod.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.resetInWideMode();
                    bl = true;
                    continue;
                }
                if (abortMethod.compilationResult == CodeStream.RESTART_CODE_GEN_FOR_UNUSED_LOCALS_MODE) {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.resetForCodeGenUnusedLocals();
                    bl = true;
                    continue;
                }
                classFile.contentsOffset = n;
                --classFile.methodCount;
                bl = false;
            }
        } while (bl);
    }

    private void generateCode(ClassScope classScope, ClassFile classFile, int n) {
        int n2;
        Object object;
        TypeDeclaration typeDeclaration;
        CodeStream codeStream;
        int n3;
        int n4;
        int n5;
        ConstantPool constantPool;
        block28: {
            Object object2;
            MethodScope methodScope;
            block25: {
                int n6;
                int n7;
                int n8;
                block27: {
                    block26: {
                        constantPool = classFile.constantPool;
                        n5 = constantPool.currentOffset;
                        n4 = constantPool.currentIndex;
                        classFile.generateMethodInfoHeaderForClinit();
                        n3 = classFile.contentsOffset;
                        classFile.generateCodeAttributeHeader();
                        codeStream = classFile.codeStream;
                        this.resolve(classScope);
                        codeStream.reset(this, classFile);
                        typeDeclaration = classScope.referenceContext;
                        methodScope = typeDeclaration.staticInitializerScope;
                        methodScope.computeLocalVariablePositions(0, codeStream);
                        if (this.assertionSyntheticFieldBinding != null) {
                            codeStream.generateClassLiteralAccessForType(classScope.outerMostClassScope().enclosingSourceType(), this.classLiteralSyntheticField);
                            codeStream.invokeJavaLangClassDesiredAssertionStatus();
                            object2 = new BranchLabel(codeStream);
                            codeStream.ifne((BranchLabel)object2);
                            codeStream.iconst_1();
                            object = new BranchLabel(codeStream);
                            codeStream.decrStackSize(1);
                            codeStream.goto_((BranchLabel)object);
                            ((BranchLabel)object2).place();
                            codeStream.iconst_0();
                            ((BranchLabel)object).place();
                            codeStream.fieldAccess((byte)-77, this.assertionSyntheticFieldBinding, null);
                        }
                        object2 = typeDeclaration.fields;
                        object = null;
                        n8 = 0;
                        if (TypeDeclaration.kind(typeDeclaration.modifiers) != 3) break block25;
                        n2 = typeDeclaration.enumConstantsCounter;
                        if (n2 <= ENUM_CONSTANTS_THRESHOLD) break block26;
                        n7 = -1;
                        n6 = 0;
                        if (object2 == null) break block27;
                        int n9 = ((FieldDeclaration[])object2).length;
                        for (int i = 0; i < n9; ++i) {
                            Object object3 = object2[i];
                            if (!((FieldDeclaration)object3).isStatic() || ((FieldDeclaration)object3).getKind() != 3) continue;
                            if (n7 == -1) {
                                n7 = i;
                            }
                            if (++n6 <= ENUM_CONSTANTS_THRESHOLD) continue;
                            SyntheticMethodBinding syntheticMethodBinding = typeDeclaration.binding.addSyntheticMethodForEnumInitialization(n7, i);
                            codeStream.invoke((byte)-72, syntheticMethodBinding, null);
                            n7 = i;
                            n6 = 1;
                        }
                        if (n6 == 0) break block27;
                        SyntheticMethodBinding syntheticMethodBinding = typeDeclaration.binding.addSyntheticMethodForEnumInitialization(n7, n9);
                        codeStream.invoke((byte)-72, syntheticMethodBinding, null);
                        break block27;
                    }
                    if (object2 != null) {
                        n6 = ((FieldDeclaration[])object2).length;
                        for (n7 = 0; n7 < n6; ++n7) {
                            FieldDeclaration fieldDeclaration = object2[n7];
                            if (!fieldDeclaration.isStatic()) continue;
                            if (fieldDeclaration.getKind() == 3) {
                                fieldDeclaration.generateCode(methodScope, codeStream);
                                continue;
                            }
                            ++n8;
                        }
                    }
                }
                codeStream.generateInlinedValue(n2);
                codeStream.anewarray(typeDeclaration.binding);
                if (n2 > 0 && object2 != null) {
                    n6 = ((Object)object2).length;
                    for (n7 = 0; n7 < n6; ++n7) {
                        Object object4 = object2[n7];
                        if (((FieldDeclaration)object4).getKind() != 3) continue;
                        codeStream.dup();
                        codeStream.generateInlinedValue(((FieldDeclaration)object4).binding.id);
                        codeStream.fieldAccess((byte)-78, ((FieldDeclaration)object4).binding, null);
                        codeStream.aastore();
                    }
                }
                codeStream.fieldAccess((byte)-77, typeDeclaration.enumValuesSyntheticfield, null);
                if (n8 != 0) {
                    n6 = ((Object)object2).length;
                    block12: for (n7 = 0; n7 < n6 && n8 >= 0; ++n7) {
                        Object object5 = object2[n7];
                        switch (((FieldDeclaration)object5).getKind()) {
                            case 3: {
                                continue block12;
                            }
                            case 2: {
                                if (!((FieldDeclaration)object5).isStatic()) continue block12;
                                --n8;
                                object = ((Initializer)object5).block.scope;
                                ((FieldDeclaration)object5).generateCode(methodScope, codeStream);
                                continue block12;
                            }
                            case 1: {
                                if (!((FieldDeclaration)object5).binding.isStatic()) continue block12;
                                --n8;
                                object = null;
                                ((FieldDeclaration)object5).generateCode(methodScope, codeStream);
                            }
                        }
                    }
                }
                break block28;
            }
            if (object2 != null) {
                int n10 = ((FieldDeclaration[])object2).length;
                block13: for (n2 = 0; n2 < n10; ++n2) {
                    FieldDeclaration fieldDeclaration = object2[n2];
                    switch (fieldDeclaration.getKind()) {
                        case 2: {
                            if (!fieldDeclaration.isStatic()) continue block13;
                            object = ((Initializer)fieldDeclaration).block.scope;
                            fieldDeclaration.generateCode(methodScope, codeStream);
                            continue block13;
                        }
                        case 1: {
                            if (!fieldDeclaration.binding.isStatic()) continue block13;
                            object = null;
                            fieldDeclaration.generateCode(methodScope, codeStream);
                        }
                    }
                }
            }
        }
        if (codeStream.position == 0) {
            classFile.contentsOffset = n;
            --classFile.methodCount;
            constantPool.resetForClinit(n4, n5);
        } else {
            if ((this.bits & 0x40) != 0) {
                n2 = codeStream.position;
                codeStream.return_();
                if (object != null) {
                    codeStream.updateLastRecordedEndPC((Scope)object, n2);
                }
            }
            codeStream.recordPositionsFrom(0, typeDeclaration.sourceStart);
            classFile.completeCodeAttributeForClinit(n3);
        }
    }

    public boolean isClinit() {
        return true;
    }

    public boolean isInitializationMethod() {
        return true;
    }

    public boolean isStatic() {
        return true;
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        Clinit.printIndent(n, stringBuffer).append("<clinit>()");
        this.printBody(n + 1, stringBuffer);
        return stringBuffer;
    }

    public void resolve(ClassScope classScope) {
        this.scope = new MethodScope(classScope, classScope.referenceContext, true);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }

    public void setAssertionSupport(FieldBinding fieldBinding, boolean bl) {
        SourceTypeBinding sourceTypeBinding;
        this.assertionSyntheticFieldBinding = fieldBinding;
        if (bl && !(sourceTypeBinding = this.scope.outerMostClassScope().enclosingSourceType()).isInterface() && !sourceTypeBinding.isBaseType()) {
            this.classLiteralSyntheticField = sourceTypeBinding.addSyntheticFieldForClassLiteral(sourceTypeBinding, this.scope);
        }
    }
}

