/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrameCodeStream;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ConstructorDeclaration
extends AbstractMethodDeclaration {
    public ExplicitConstructorCall constructorCall;
    public TypeParameter[] typeParameters;

    public ConstructorDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationFlowContext, FlowInfo flowInfo) {
        this.analyseCode(classScope, initializationFlowContext, flowInfo, 0);
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationFlowContext, FlowInfo flowInfo, int n) {
        Object object;
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        int n2 = flowInfo.reachMode();
        flowInfo.setReachMode(n);
        Object object2 = this.binding;
        if (object2 != null && (this.bits & 0x80) == 0 && !((MethodBinding)object2).isUsed() && !(!((MethodBinding)object2).isPrivate() ? !((MethodBinding)object2).isOrEnclosedByPrivateType() : (this.binding.declaringClass.tagBits & 0x40000000000000L) == 0L)) {
            MethodBinding methodBinding;
            if (this.constructorCall != null && (this.constructorCall.accessMode == 3 || (object = ((MethodBinding)object2).declaringClass.superclass()) != null && (methodBinding = ((ReferenceBinding)object).getExactConstructor(Binding.NO_PARAMETERS)) != null && methodBinding.canBeSeenBy(SuperReference.implicitSuperConstructorCall(), this.scope))) {
                this.scope.problemReporter().unusedPrivateConstructor(this);
            }
        }
        if (this.isRecursive(null)) {
            this.scope.problemReporter().recursiveConstructorInvocation(this.constructorCall);
        }
        try {
            Object object3;
            int n3;
            object2 = new ExceptionHandlingFlowContext(initializationFlowContext.parent, this, this.binding.thrownExceptions, initializationFlowContext, this.scope, FlowInfo.DEAD_END);
            initializationFlowContext.checkInitializerExceptions(this.scope, (FlowContext)object2, flowInfo);
            if (this.binding.declaringClass.isAnonymousType() && (object = ((ExceptionHandlingFlowContext)object2).extendedExceptions) != null && (n3 = ((ArrayList)object).size()) > 0) {
                ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n3];
                ((ArrayList)object).toArray(referenceBindingArray);
                this.binding.thrownExceptions = referenceBindingArray;
            }
            if (this.arguments != null) {
                int n4 = this.arguments.length;
                for (int i = 0; i < n4; ++i) {
                    flowInfo.markAsDefinitelyAssigned(this.arguments[i].binding);
                }
            }
            if (this.constructorCall != null) {
                if (this.constructorCall.accessMode == 3) {
                    FieldBinding[] fieldBindingArray = this.binding.declaringClass.fields();
                    int n5 = fieldBindingArray.length;
                    for (int i = 0; i < n5; ++i) {
                        object3 = fieldBindingArray[i];
                        if (((FieldBinding)object3).isStatic()) continue;
                        flowInfo.markAsDefinitelyAssigned((FieldBinding)object3);
                    }
                }
                flowInfo = this.constructorCall.analyseCode(this.scope, (FlowContext)object2, flowInfo);
            }
            flowInfo.setReachMode(n2);
            if (this.statements != null) {
                int n6 = (n2 & 3) == 0 ? 0 : 1;
                int n7 = this.statements.length;
                for (int i = 0; i < n7; ++i) {
                    object3 = this.statements[i];
                    if ((n6 = ((Statement)object3).complainIfUnreachable(flowInfo, this.scope, n6)) >= 2) continue;
                    flowInfo = ((Statement)object3).analyseCode(this.scope, (FlowContext)object2, flowInfo);
                }
            }
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= 0x40;
            }
            if (this.constructorCall != null && this.constructorCall.accessMode != 3) {
                flowInfo = flowInfo.mergedWith(((ExceptionHandlingFlowContext)object2).initsOnReturn);
                FieldBinding[] fieldBindingArray = this.binding.declaringClass.fields();
                int n8 = fieldBindingArray.length;
                for (int i = 0; i < n8; ++i) {
                    object3 = fieldBindingArray[i];
                    if (((FieldBinding)object3).isStatic() || !((VariableBinding)object3).isFinal() || flowInfo.isDefinitelyAssigned(fieldBindingArray[i])) continue;
                    this.scope.problemReporter().uninitializedBlankFinalField((FieldBinding)object3, (this.bits & 0x80) != 0 ? this.scope.referenceType() : this);
                }
            }
            ((ExceptionHandlingFlowContext)object2).complainIfUnusedExceptionHandlers(this);
            this.scope.checkUnusedParameters(this.binding);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int n = 0;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getProblems();
            int n2 = categorizedProblemArray.length;
            CategorizedProblem[] categorizedProblemArray2 = new CategorizedProblem[n2];
            System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray2, 0, n2);
            classFile.addProblemConstructor(this, this.binding, categorizedProblemArray2);
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        do {
            try {
                n = classFile.contentsOffset;
                this.internalGenerateCode(classScope, classFile);
                bl = false;
            }
            catch (AbortMethod abortMethod) {
                if (abortMethod.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.resetInWideMode();
                    bl = true;
                    continue;
                }
                if (abortMethod.compilationResult == CodeStream.RESTART_CODE_GEN_FOR_UNUSED_LOCALS_MODE) {
                    classFile.contentsOffset = n;
                    --classFile.methodCount;
                    classFile.codeStream.resetForCodeGenUnusedLocals();
                    bl = true;
                    continue;
                }
                bl = false;
                bl2 = true;
            }
        } while (bl);
        if (bl2) {
            CategorizedProblem[] categorizedProblemArray = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
            int n3 = categorizedProblemArray.length;
            CategorizedProblem[] categorizedProblemArray3 = new CategorizedProblem[n3];
            System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray3, 0, n3);
            classFile.addProblemConstructor(this, this.binding, categorizedProblemArray3, n);
        }
    }

    public void generateSyntheticFieldInitializationsIfNecessary(MethodScope methodScope, CodeStream codeStream, ReferenceBinding referenceBinding) {
        SyntheticArgumentBinding syntheticArgumentBinding;
        int n;
        int n2;
        if (!referenceBinding.isNestedType()) {
            return;
        }
        NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)referenceBinding;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray = nestedTypeBinding.syntheticEnclosingInstances();
        if (syntheticArgumentBindingArray != null) {
            n2 = syntheticArgumentBindingArray.length;
            for (n = 0; n < n2; ++n) {
                syntheticArgumentBinding = syntheticArgumentBindingArray[n];
                if (syntheticArgumentBinding.matchingField == null) continue;
                codeStream.aload_0();
                codeStream.load(syntheticArgumentBinding);
                codeStream.fieldAccess((byte)-75, syntheticArgumentBinding.matchingField, null);
            }
        }
        if ((syntheticArgumentBindingArray = nestedTypeBinding.syntheticOuterLocalVariables()) != null) {
            n2 = syntheticArgumentBindingArray.length;
            for (n = 0; n < n2; ++n) {
                syntheticArgumentBinding = syntheticArgumentBindingArray[n];
                if (syntheticArgumentBinding.matchingField == null) continue;
                codeStream.aload_0();
                codeStream.load(syntheticArgumentBinding);
                codeStream.fieldAccess((byte)-75, syntheticArgumentBinding.matchingField, null);
            }
        }
    }

    private void internalGenerateCode(ClassScope classScope, ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int n = classFile.contentsOffset;
        int n2 = classFile.generateMethodInfoAttributes(this.binding);
        if (!this.binding.isNative() && !this.binding.isAbstract()) {
            int n3;
            int n4;
            boolean bl;
            int n5;
            TypeDeclaration typeDeclaration = classScope.referenceContext;
            int n6 = classFile.contentsOffset;
            classFile.generateCodeAttributeHeader();
            CodeStream codeStream = classFile.codeStream;
            codeStream.reset(this, classFile);
            ReferenceBinding referenceBinding = this.binding.declaringClass;
            int n7 = referenceBinding.isEnum() ? 2 : 0;
            int n8 = 1 + n7;
            if (referenceBinding.isNestedType()) {
                this.scope.extraSyntheticArguments = referenceBinding.syntheticOuterLocalVariables();
                this.scope.computeLocalVariablePositions(referenceBinding.getEnclosingInstancesSlotSize() + 1 + n7, codeStream);
                n8 += referenceBinding.getEnclosingInstancesSlotSize();
                n8 += referenceBinding.getOuterLocalVariablesSlotSize();
            } else {
                this.scope.computeLocalVariablePositions(1 + n7, codeStream);
            }
            if (this.arguments != null) {
                n5 = this.arguments.length;
                block5: for (int i = 0; i < n5; ++i) {
                    LocalVariableBinding localVariableBinding = this.arguments[i].binding;
                    codeStream.addVisibleLocalVariable(localVariableBinding);
                    localVariableBinding.recordInitializationStartPC(0);
                    switch (localVariableBinding.type.id) {
                        case 7: 
                        case 8: {
                            n8 += 2;
                            continue block5;
                        }
                        default: {
                            ++n8;
                        }
                    }
                }
            }
            MethodScope methodScope = typeDeclaration.initializerScope;
            methodScope.computeLocalVariablePositions(n8, codeStream);
            n5 = this.constructorCall == null || this.constructorCall.accessMode != 3 ? 1 : 0;
            boolean bl2 = bl = this.scope.compilerOptions().targetJDK >= 0x300000L;
            if (n5 != 0 && bl) {
                this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, referenceBinding);
                codeStream.recordPositionsFrom(0, this.bodyStart);
            }
            if (this.constructorCall != null) {
                this.constructorCall.generateCode(this.scope, codeStream);
            }
            if (n5 != 0) {
                if (!bl) {
                    this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, referenceBinding);
                }
                if (typeDeclaration.fields != null) {
                    n4 = typeDeclaration.fields.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        FieldDeclaration fieldDeclaration = typeDeclaration.fields[n3];
                        if (fieldDeclaration.isStatic()) continue;
                        fieldDeclaration.generateCode(methodScope, codeStream);
                    }
                }
            }
            if (this.statements != null) {
                n4 = this.statements.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    this.statements[n3].generateCode(this.scope, codeStream);
                }
            }
            if (this.ignoreFurtherInvestigation) {
                throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            if ((this.bits & 0x40) != 0) {
                codeStream.return_();
            }
            codeStream.exitUserScope(this.scope);
            codeStream.recordPositionsFrom(0, this.bodyEnd);
            try {
                classFile.completeCodeAttribute(n6);
            }
            catch (NegativeArraySizeException negativeArraySizeException) {
                throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            ++n2;
            if (codeStream instanceof StackMapFrameCodeStream && n5 != 0 && typeDeclaration.fields != null) {
                ((StackMapFrameCodeStream)codeStream).resetSecretLocals();
            }
        }
        classFile.completeMethodInfo(this.binding, n, n2);
    }

    public boolean isConstructor() {
        return true;
    }

    public boolean isDefaultConstructor() {
        return (this.bits & 0x80) != 0;
    }

    public boolean isInitializationMethod() {
        return true;
    }

    public boolean isRecursive(ArrayList arrayList) {
        if (this.binding == null || this.constructorCall == null || this.constructorCall.binding == null || this.constructorCall.isSuperAccess() || !this.constructorCall.binding.isValidBinding()) {
            return false;
        }
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)this.scope.referenceType().declarationOf(this.constructorCall.binding.original());
        if (this == constructorDeclaration) {
            return true;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<ConstructorDeclaration>(1);
        } else {
            int n = arrayList.indexOf(this);
            if (n >= 0) {
                return n == 0;
            }
        }
        arrayList.add(this);
        return constructorDeclaration.isRecursive(arrayList);
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
        if ((this.bits & 0x80) != 0 && this.constructorCall == null) {
            this.constructorCall = SuperReference.implicitSuperConstructorCall();
            this.constructorCall.sourceStart = this.sourceStart;
            this.constructorCall.sourceEnd = this.sourceEnd;
            return;
        }
        parser.parse(this, compilationUnitDeclaration, false);
    }

    public StringBuffer printBody(int n, StringBuffer stringBuffer) {
        stringBuffer.append(" {");
        if (this.constructorCall != null) {
            stringBuffer.append('\n');
            this.constructorCall.printStatement(n, stringBuffer);
        }
        if (this.statements != null) {
            for (int i = 0; i < this.statements.length; ++i) {
                stringBuffer.append('\n');
                this.statements[i].printStatement(n, stringBuffer);
            }
        }
        stringBuffer.append('\n');
        ConstructorDeclaration.printIndent(n == 0 ? 0 : n - 1, stringBuffer).append('}');
        return stringBuffer;
    }

    public void resolveJavadoc() {
        if (this.binding == null || this.javadoc != null) {
            super.resolveJavadoc();
        } else if ((this.bits & 0x80) == 0 && this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
            int n = this.binding.modifiers & 7;
            ClassScope classScope = this.scope.classScope();
            ProblemReporter problemReporter = this.scope.problemReporter();
            int n2 = problemReporter.computeSeverity(-1610612250);
            if (n2 != 256) {
                if (classScope != null) {
                    n = Util.computeOuterMostVisibility(classScope.referenceType(), n);
                }
                int n3 = this.binding.modifiers & 0xFFFFFFF8 | n;
                problemReporter.javadocMissing(this.sourceStart, this.sourceEnd, n2, n3);
            }
        }
    }

    public void resolveStatements() {
        SourceTypeBinding sourceTypeBinding = this.scope.enclosingSourceType();
        if (!CharOperation.equals(sourceTypeBinding.sourceName, this.selector)) {
            this.scope.problemReporter().missingReturnType(this);
        }
        if (this.typeParameters != null) {
            int n = this.typeParameters.length;
            for (int i = 0; i < n; ++i) {
                this.typeParameters[i].resolve(this.scope);
            }
        }
        if (this.binding != null && !this.binding.isPrivate()) {
            sourceTypeBinding.tagBits |= 0x40000000000000L;
        }
        if (this.constructorCall != null) {
            if (sourceTypeBinding.id == 1 && this.constructorCall.accessMode != 3) {
                if (this.constructorCall.accessMode == 2) {
                    this.scope.problemReporter().cannotUseSuperInJavaLangObject(this.constructorCall);
                }
                this.constructorCall = null;
            } else {
                this.constructorCall.resolve(this.scope);
            }
        }
        if ((this.modifiers & 0x1000000) != 0) {
            this.scope.problemReporter().methodNeedBody(this);
        }
        super.resolveStatements();
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            int n2;
            if (this.javadoc != null) {
                this.javadoc.traverse(aSTVisitor, this.scope);
            }
            if (this.annotations != null) {
                n2 = this.annotations.length;
                for (n = 0; n < n2; ++n) {
                    this.annotations[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.typeParameters != null) {
                n2 = this.typeParameters.length;
                for (n = 0; n < n2; ++n) {
                    this.typeParameters[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.arguments != null) {
                n2 = this.arguments.length;
                for (n = 0; n < n2; ++n) {
                    this.arguments[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.thrownExceptions != null) {
                n2 = this.thrownExceptions.length;
                for (n = 0; n < n2; ++n) {
                    this.thrownExceptions[n].traverse(aSTVisitor, this.scope);
                }
            }
            if (this.constructorCall != null) {
                this.constructorCall.traverse(aSTVisitor, this.scope);
            }
            if (this.statements != null) {
                n2 = this.statements.length;
                for (n = 0; n < n2; ++n) {
                    this.statements[n].traverse(aSTVisitor, this.scope);
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }

    public TypeParameter[] typeParameters() {
        return this.typeParameters;
    }
}

