/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileFinder;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.CompilerStats;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.GenericXMLWriter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfInt;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Main
implements ProblemSeverities,
SuffixConstants {
    boolean enableJavadocOn;
    boolean warnJavadocOn;
    boolean warnAllJavadocOn;
    public Compiler batchCompiler;
    public ResourceBundle bundle;
    protected FileSystem.Classpath[] checkedClasspaths;
    public Locale compilerLocale;
    public CompilerOptions compilerOptions;
    public CompilationProgress progress;
    public String destinationPath;
    public String[] destinationPaths;
    private boolean didSpecifySource;
    private boolean didSpecifyTarget;
    public String[] encodings;
    public int exportedClassFilesCounter;
    public String[] filenames;
    public String[] classNames;
    public int globalErrorsCount;
    public int globalProblemsCount;
    public int globalTasksCount;
    public int globalWarningsCount;
    private File javaHomeCache;
    private boolean javaHomeChecked = false;
    public long lineCount0;
    public String log;
    public Logger logger;
    public int maxProblems;
    public Map options;
    protected PrintWriter out;
    public boolean proceed = true;
    public boolean proceedOnError = false;
    public boolean produceRefInfo = false;
    public int currentRepetition;
    public int maxRepetition;
    public boolean showProgress = false;
    public long startTime;
    public ArrayList pendingErrors;
    public boolean systemExitWhenFinished = true;
    public static final int TIMING_DISABLED = 0;
    public static final int TIMING_ENABLED = 1;
    public static final int TIMING_DETAILED = 2;
    public int timing = 0;
    public CompilerStats[] compilerStats;
    public boolean verbose = false;
    private String[] expandedCommandLine;
    private PrintWriter err;
    protected ArrayList extraProblems;
    public static final String bundleName = "org.eclipse.jdt.internal.compiler.batch.messages";
    public static final int DEFAULT_SIZE_CLASSPATH = 4;
    public static final String NONE = "none";
    static /* synthetic */ Class class$org$eclipse$jdt$core$compiler$IProblem;

    public static boolean compile(String string) {
        return new Main(new PrintWriter(System.out), new PrintWriter(System.err), false, null, null).compile(Main.tokenize(string));
    }

    public static boolean compile(String string, PrintWriter printWriter, PrintWriter printWriter2) {
        return new Main(printWriter, printWriter2, false, null, null).compile(Main.tokenize(string));
    }

    public static boolean compile(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2, CompilationProgress compilationProgress) {
        return new Main(printWriter, printWriter2, false, null, compilationProgress).compile(stringArray);
    }

    public static File[][] getLibrariesFiles(File[] fileArray) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return Util.isPotentialZipArchive(string);
            }
        };
        int n = fileArray.length;
        File[][] fileArray2 = new File[n][];
        for (int i = 0; i < n; ++i) {
            File file = fileArray[i];
            if (!file.exists() || !file.isDirectory()) continue;
            fileArray2[i] = file.listFiles(filenameFilter);
        }
        return fileArray2;
    }

    public static void main(String[] stringArray) {
        new Main(new PrintWriter(System.out), new PrintWriter(System.err), true, null, null).compile(stringArray);
    }

    public static String[] tokenize(String string) {
        int n = 0;
        String[] stringArray = new String[10];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"", true);
        String string2 = Util.EMPTY_STRING;
        boolean bl = false;
        boolean bl2 = true;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) {
                if (bl) {
                    int n2 = n - 1;
                    stringArray[n2] = stringArray[n2] + string2;
                    bl2 = false;
                    continue;
                }
                bl2 = true;
                continue;
            }
            if (string2.equals("\"")) {
                if (!bl && bl2) {
                    if (n == stringArray.length) {
                        String[] stringArray2 = stringArray;
                        stringArray = new String[n * 2];
                        System.arraycopy(stringArray2, 0, stringArray, 0, n);
                    }
                    stringArray[n++] = Util.EMPTY_STRING;
                }
                bl = !bl;
                bl2 = false;
                continue;
            }
            if (bl) {
                int n3 = n - 1;
                stringArray[n3] = stringArray[n3] + string2;
            } else if (string2.length() > 0 && !bl2) {
                int n4 = n - 1;
                stringArray[n4] = stringArray[n4] + string2;
            } else {
                String string3;
                if (n == stringArray.length) {
                    String[] stringArray3 = stringArray;
                    stringArray = new String[n * 2];
                    System.arraycopy(stringArray3, 0, stringArray, 0, n);
                }
                if ((string3 = string2.trim()).length() != 0) {
                    stringArray[n++] = string3;
                }
            }
            bl2 = false;
        }
        String[] stringArray4 = stringArray;
        stringArray = new String[n];
        System.arraycopy(stringArray4, 0, stringArray, 0, n);
        return stringArray;
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this(printWriter, printWriter2, bl, null, null);
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        this(printWriter, printWriter2, bl, map, null);
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map, CompilationProgress compilationProgress) {
        this.initialize(printWriter, printWriter2, bl, map, compilationProgress);
        this.relocalize();
    }

    public void addExtraProblems(CategorizedProblem categorizedProblem) {
        if (this.extraProblems == null) {
            this.extraProblems = new ArrayList();
        }
        this.extraProblems.add(categorizedProblem);
    }

    protected void addNewEntry(ArrayList arrayList, String string, ArrayList arrayList2, String string2, String string3, boolean bl, boolean bl2) {
        Object object;
        int n = arrayList2.size();
        AccessRuleSet accessRuleSet = null;
        if (n != 0) {
            object = new AccessRule[arrayList2.size()];
            boolean bl3 = true;
            Iterator iterator = arrayList2.iterator();
            int n2 = 0;
            block6: while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                char c = string4.charAt(0);
                String string5 = string4.substring(1);
                if (string5.length() > 0) {
                    switch (c) {
                        case '+': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0);
                            continue block6;
                        }
                        case '~': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000118);
                            continue block6;
                        }
                        case '-': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000133);
                            continue block6;
                        }
                        case '?': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000133, true);
                            continue block6;
                        }
                    }
                    bl3 = false;
                    continue;
                }
                bl3 = false;
            }
            if (bl3) {
                accessRuleSet = new AccessRuleSet((AccessRule[])object, 0, string);
            } else {
                if (string.length() != 0) {
                    this.addPendingErrors(this.bind("configure.incorrectClasspath", string));
                }
                return;
            }
        }
        if (NONE.equals(string3)) {
            string3 = NONE;
        }
        if (bl2 && string3 != null && Util.isPotentialZipArchive(string)) {
            throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntryFile", string));
        }
        object = FileSystem.getClasspath(string, string2, bl, accessRuleSet, string3);
        if (object != null) {
            arrayList.add(object);
        } else if (string.length() != 0) {
            this.addPendingErrors(this.bind("configure.incorrectClasspath", string));
        }
    }

    void addPendingErrors(String string) {
        if (this.pendingErrors == null) {
            this.pendingErrors = new ArrayList();
        }
        this.pendingErrors.add(string);
    }

    public String bind(String string) {
        return this.bind(string, (String[])null);
    }

    public String bind(String string, String string2) {
        return this.bind(string, new String[]{string2});
    }

    public String bind(String string, String string2, String string3) {
        return this.bind(string, new String[]{string2, string3});
    }

    public String bind(String string, String[] stringArray) {
        if (string == null) {
            return "No message available";
        }
        String string2 = null;
        try {
            string2 = this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + string + " in: " + bundleName;
        }
        return MessageFormat.format(string2, stringArray);
    }

    private boolean checkVMVersion(long l) {
        int n;
        String string = System.getProperty("java.class.version");
        if (string == null) {
            return false;
        }
        int n2 = string.indexOf(46);
        if (n2 == -1) {
            return false;
        }
        try {
            n = Integer.parseInt(string.substring(0, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        switch (n) {
            case 45: {
                return 2949123L >= l;
            }
            case 46: {
                return 0x2E0000L >= l;
            }
            case 47: {
                return 0x2F0000L >= l;
            }
            case 48: {
                return 0x300000L >= l;
            }
            case 49: {
                return 0x310000L >= l;
            }
            case 50: {
                return 0x320000L >= l;
            }
            case 51: {
                return 0x330000L >= l;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compile(String[] stringArray) {
        block19: {
            try {
                this.configure(stringArray);
                if (this.progress != null) {
                    this.progress.begin(this.filenames == null ? 0 : this.filenames.length * this.maxRepetition);
                }
                if (this.proceed) {
                    if (this.showProgress) {
                        this.logger.compiling();
                    }
                    this.currentRepetition = 0;
                    while (this.currentRepetition < this.maxRepetition) {
                        this.globalProblemsCount = 0;
                        this.globalErrorsCount = 0;
                        this.globalWarningsCount = 0;
                        this.globalTasksCount = 0;
                        this.exportedClassFilesCounter = 0;
                        if (this.maxRepetition > 1) {
                            this.logger.flush();
                            this.logger.logRepetition(this.currentRepetition, this.maxRepetition);
                        }
                        this.performCompilation();
                        ++this.currentRepetition;
                    }
                    if (this.compilerStats != null) {
                        this.logger.logAverage();
                    }
                    if (this.showProgress) {
                        this.logger.printNewLine();
                    }
                }
                if (!this.systemExitWhenFinished) break block19;
                this.logger.flush();
                this.logger.close();
                System.exit(this.globalErrorsCount > 0 ? -1 : 0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.logException(illegalArgumentException);
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(-1);
                }
                boolean bl = false;
                Object var5_3 = null;
                this.logger.flush();
                this.logger.close();
                if (this.progress != null) {
                    this.progress.done();
                }
                return bl;
            }
            catch (RuntimeException runtimeException) {
                try {
                    this.logger.logException(runtimeException);
                    if (this.systemExitWhenFinished) {
                        this.logger.flush();
                        this.logger.close();
                        System.exit(-1);
                    }
                    boolean bl = false;
                    Object var5_4 = null;
                    this.logger.flush();
                    this.logger.close();
                    if (this.progress != null) {
                        this.progress.done();
                    }
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.logger.flush();
                    this.logger.close();
                    if (this.progress != null) {
                        this.progress.done();
                    }
                    throw throwable;
                }
            }
        }
        Object var5_2 = null;
        this.logger.flush();
        this.logger.close();
        if (this.progress != null) {
            this.progress.done();
        }
        return this.globalErrorsCount == 0 && (this.progress == null || !this.progress.isCanceled());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(String[] stringArray) {
        Object object;
        int n;
        if (stringArray == null || stringArray.length == 0) {
            this.printUsage();
            return;
        }
        ArrayList arrayList = new ArrayList(4);
        String string = null;
        ArrayList arrayList2 = new ArrayList(4);
        ArrayList arrayList3 = new ArrayList(4);
        ArrayList<String> arrayList4 = null;
        ArrayList<String> arrayList5 = null;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = stringArray.length;
        int n6 = 0;
        this.maxRepetition = 0;
        boolean bl = false;
        String string2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = Util.EMPTY_STRING;
        HashSet<String> hashSet = null;
        boolean bl6 = false;
        for (int i = 0; i < n5; ++i) {
            if (!stringArray[i].startsWith("@")) continue;
            bl6 = true;
            break;
        }
        String[] stringArray2 = null;
        if (bl6) {
            stringArray2 = new String[n5];
            n2 = 0;
            for (n = 0; n < n5; ++n) {
                String[] stringArray3 = null;
                String string7 = stringArray[n].trim();
                if (string7.startsWith("@")) {
                    try {
                        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(new String(Util.getFileCharContent(new File(string7.substring(1)), null))));
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((object = lineNumberReader.readLine()) != null) {
                            if (((String)(object = ((String)object).trim())).startsWith("#")) continue;
                            stringBuffer.append((String)object).append(" ");
                        }
                        stringArray3 = Main.tokenize(stringBuffer.toString());
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException(this.bind("configure.invalidexpansionargumentname", string7));
                    }
                }
                if (stringArray3 != null) {
                    int n7 = stringArray2.length;
                    int n8 = stringArray3.length;
                    String[] stringArray4 = stringArray2;
                    stringArray2 = new String[n7 + n8 - 1];
                    System.arraycopy(stringArray4, 0, stringArray2, 0, n2);
                    System.arraycopy(stringArray3, 0, stringArray2, n2, n8);
                    n2 += n8;
                    continue;
                }
                stringArray2[n2++] = string7;
            }
            n2 = -1;
        } else {
            stringArray2 = stringArray;
            for (n = 0; n < n5; ++n) {
                stringArray2[n] = stringArray2[n].trim();
            }
        }
        n5 = stringArray2.length;
        this.expandedCommandLine = stringArray2;
        block51: while (++n2 < n5) {
            int n9;
            File file;
            int n10;
            if (string3 != null) {
                throw new IllegalArgumentException(this.bind("configure.unexpectedCustomEncoding", string6, string3));
            }
            string6 = stringArray2[n2];
            switch (n6) {
                case 0: {
                    String string8;
                    int n11;
                    boolean bl7;
                    if (string6.startsWith("[")) {
                        throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string6));
                    }
                    if (string6.endsWith("]")) {
                        n = string6.indexOf(91) + 1;
                        if (n <= 1) {
                            throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string6));
                        }
                        int n12 = string6.length() - 1;
                        if (n >= 1) {
                            if (n < n12) {
                                string3 = string6.substring(n, n12);
                                try {
                                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), string3);
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    throw new IllegalArgumentException(this.bind("configure.unsupportedEncoding", string3));
                                }
                            }
                            string6 = string6.substring(0, n - 1);
                        }
                    }
                    if (string6.endsWith(".java")) {
                        if (this.filenames == null) {
                            this.filenames = new String[n5 - n2];
                            this.encodings = new String[n5 - n2];
                            this.destinationPaths = new String[n5 - n2];
                        } else if (n3 == this.filenames.length) {
                            n = this.filenames.length;
                            this.filenames = new String[n + n5 - n2];
                            System.arraycopy(this.filenames, 0, this.filenames, 0, n);
                            this.encodings = new String[n + n5 - n2];
                            System.arraycopy(this.encodings, 0, this.encodings, 0, n);
                            this.destinationPaths = new String[n + n5 - n2];
                            System.arraycopy(this.destinationPaths, 0, this.destinationPaths, 0, n);
                        }
                        this.filenames[n3] = string6;
                        this.encodings[n3++] = string3;
                        string3 = null;
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-log")) {
                        if (this.log != null) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateLog", string6));
                        }
                        n6 = 5;
                        continue block51;
                    }
                    if (string6.equals("-repeat")) {
                        if (this.maxRepetition > 0) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateRepeat", string6));
                        }
                        n6 = 6;
                        continue block51;
                    }
                    if (string6.equals("-maxProblems")) {
                        if (this.maxProblems > 0) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateMaxProblems", string6));
                        }
                        n6 = 11;
                        continue block51;
                    }
                    if (string6.equals("-source")) {
                        n6 = 7;
                        continue block51;
                    }
                    if (string6.equals("-encoding")) {
                        n6 = 8;
                        continue block51;
                    }
                    if (string6.equals("-1.3")) {
                        if (bl4) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", string6));
                        }
                        bl4 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-1.4")) {
                        if (bl4) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", string6));
                        }
                        bl4 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-1.5") || string6.equals("-5") || string6.equals("-5.0")) {
                        if (bl4) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", string6));
                        }
                        bl4 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-1.6") || string6.equals("-6") || string6.equals("-6.0")) {
                        if (bl4) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", string6));
                        }
                        bl4 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-1.7") || string6.equals("-7") || string6.equals("-7.0")) {
                        if (bl4) {
                            throw new IllegalArgumentException(this.bind("configure.duplicateCompliance", string6));
                        }
                        bl4 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-d")) {
                        if (this.destinationPath != null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string6);
                            if (n2 + 1 >= n5) throw new IllegalArgumentException(this.bind("configure.duplicateOutputPath", stringBuffer.toString()));
                            stringBuffer.append(' ');
                            stringBuffer.append(stringArray2[n2 + 1]);
                            throw new IllegalArgumentException(this.bind("configure.duplicateOutputPath", stringBuffer.toString()));
                        }
                        n6 = 3;
                        continue block51;
                    }
                    if (string6.equals("-classpath") || string6.equals("-cp")) {
                        n6 = 1;
                        continue block51;
                    }
                    if (string6.equals("-bootclasspath")) {
                        if (arrayList.size() > 0) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string6);
                            if (n2 + 1 >= n5) throw new IllegalArgumentException(this.bind("configure.duplicateBootClasspath", stringBuffer.toString()));
                            stringBuffer.append(' ');
                            stringBuffer.append(stringArray2[n2 + 1]);
                            throw new IllegalArgumentException(this.bind("configure.duplicateBootClasspath", stringBuffer.toString()));
                        }
                        n6 = 9;
                        continue block51;
                    }
                    if (string6.equals("-sourcepath")) {
                        if (string != null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string6);
                            if (n2 + 1 >= n5) throw new IllegalArgumentException(this.bind("configure.duplicateSourcepath", stringBuffer.toString()));
                            stringBuffer.append(' ');
                            stringBuffer.append(stringArray2[n2 + 1]);
                            throw new IllegalArgumentException(this.bind("configure.duplicateSourcepath", stringBuffer.toString()));
                        }
                        n6 = 13;
                        continue block51;
                    }
                    if (string6.equals("-extdirs")) {
                        if (arrayList4 != null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string6);
                            if (n2 + 1 >= n5) throw new IllegalArgumentException(this.bind("configure.duplicateExtDirs", stringBuffer.toString()));
                            stringBuffer.append(' ');
                            stringBuffer.append(stringArray2[n2 + 1]);
                            throw new IllegalArgumentException(this.bind("configure.duplicateExtDirs", stringBuffer.toString()));
                        }
                        n6 = 12;
                        continue block51;
                    }
                    if (string6.equals("-endorseddirs")) {
                        if (arrayList5 != null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string6);
                            if (n2 + 1 >= n5) throw new IllegalArgumentException(this.bind("configure.duplicateEndorsedDirs", stringBuffer.toString()));
                            stringBuffer.append(' ');
                            stringBuffer.append(stringArray2[n2 + 1]);
                            throw new IllegalArgumentException(this.bind("configure.duplicateEndorsedDirs", stringBuffer.toString()));
                        }
                        n6 = 15;
                        continue block51;
                    }
                    if (string6.equals("-progress")) {
                        n6 = 0;
                        this.showProgress = true;
                        continue block51;
                    }
                    if (string6.startsWith("-proceedOnError")) {
                        n6 = 0;
                        n = string6.length();
                        if (n > 15) {
                            if (!string6.equals("-proceedOnError:Fatal")) throw new IllegalArgumentException(this.bind("configure.invalidWarningConfiguration", string6));
                            this.options.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "enabled");
                        } else {
                            this.options.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "disabled");
                        }
                        this.proceedOnError = true;
                        continue block51;
                    }
                    if (string6.equals("-time")) {
                        n6 = 0;
                        this.timing = 1;
                        continue block51;
                    }
                    if (string6.equals("-time:detail")) {
                        n6 = 0;
                        this.timing = 3;
                        continue block51;
                    }
                    if (string6.equals("-version") || string6.equals("-v")) {
                        this.logger.logVersion(true);
                        this.proceed = false;
                        return;
                    }
                    if (string6.equals("-showversion")) {
                        bl2 = true;
                        n6 = 0;
                        continue block51;
                    }
                    if ("-deprecation".equals(string6)) {
                        bl3 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-help") || string6.equals("-?")) {
                        bl = true;
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-help:warn") || string6.equals("-?:warn")) {
                        bl = true;
                        string2 = "misc.usage.warn";
                        continue block51;
                    }
                    if (string6.equals("-noExit")) {
                        this.systemExitWhenFinished = false;
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-verbose")) {
                        this.verbose = true;
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-referenceInfo")) {
                        this.produceRefInfo = true;
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-inlineJSR")) {
                        n6 = 0;
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
                        continue block51;
                    }
                    if (string6.startsWith("-g")) {
                        n6 = 0;
                        String string9 = string6;
                        int n13 = string6.length();
                        if (n13 == 2) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                            continue block51;
                        }
                        if (n13 <= 3) throw new IllegalArgumentException(this.bind("configure.invalidDebugOption", string9));
                        this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                        this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                        this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                        if (n13 == 7 && string9.equals("-g:none")) continue block51;
                        StringTokenizer stringTokenizer = new StringTokenizer(string9.substring(3, string9.length()), ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string10 = stringTokenizer.nextToken();
                            if (string10.equals("vars")) {
                                this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                                continue;
                            }
                            if (string10.equals("lines")) {
                                this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                                continue;
                            }
                            if (!string10.equals("source")) throw new IllegalArgumentException(this.bind("configure.invalidDebugOption", string9));
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                        }
                        continue block51;
                    }
                    if (string6.startsWith("-nowarn")) {
                        this.disableWarnings();
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.startsWith("-warn")) {
                        int n14;
                        n6 = 0;
                        String string11 = string6;
                        int n15 = string6.length();
                        if (n15 == 10 && string11.equals("-warn:none")) {
                            this.disableWarnings();
                            continue block51;
                        }
                        if (n15 <= 6) {
                            throw new IllegalArgumentException(this.bind("configure.invalidWarningConfiguration", string11));
                        }
                        switch (string11.charAt(6)) {
                            case '+': {
                                n14 = 7;
                                n10 = 1;
                                bl7 = true;
                                break;
                            }
                            case '-': {
                                n14 = 7;
                                n10 = 0;
                                bl7 = true;
                                break;
                            }
                            default: {
                                this.disableWarnings();
                                n14 = 6;
                                n10 = 1;
                                bl7 = false;
                            }
                        }
                        object = new StringTokenizer(string11.substring(n14, string11.length()), ",");
                        n11 = 0;
                        if (bl3) {
                            this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        }
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            string8 = ((StringTokenizer)object).nextToken();
                            ++n11;
                            switch (string8.charAt(0)) {
                                case '+': {
                                    if (!bl7) throw new IllegalArgumentException(this.bind("configure.invalidUsageOfPlusOption", string8));
                                    n10 = 1;
                                    string8 = string8.substring(1);
                                    break;
                                }
                                case '-': {
                                    if (!bl7) throw new IllegalArgumentException(this.bind("configure.invalidUsageOfMinusOption", string8));
                                    n10 = 0;
                                    string8 = string8.substring(1);
                                    break;
                                }
                            }
                            this.handleWarningToken(string8, n10 != 0);
                        }
                        if (n11 != 0) continue block51;
                        throw new IllegalArgumentException(this.bind("configure.invalidWarningOption", string6));
                    }
                    if (string6.startsWith("-err")) {
                        int n16;
                        n6 = 0;
                        String string12 = string6;
                        int n17 = string6.length();
                        if (n17 <= 5) {
                            throw new IllegalArgumentException(this.bind("configure.invalidErrorConfiguration", string12));
                        }
                        switch (string12.charAt(5)) {
                            case '+': {
                                n16 = 6;
                                n10 = 1;
                                bl7 = true;
                                break;
                            }
                            case '-': {
                                n16 = 6;
                                n10 = 0;
                                bl7 = true;
                                break;
                            }
                            default: {
                                this.disableErrors();
                                n16 = 5;
                                n10 = 1;
                                bl7 = false;
                            }
                        }
                        object = new StringTokenizer(string12.substring(n16, string12.length()), ",");
                        n11 = 0;
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            string8 = ((StringTokenizer)object).nextToken();
                            ++n11;
                            switch (string8.charAt(0)) {
                                case '+': {
                                    if (!bl7) throw new IllegalArgumentException(this.bind("configure.invalidUsageOfPlusOption", string8));
                                    n10 = 1;
                                    string8 = string8.substring(1);
                                    break;
                                }
                                case '-': {
                                    if (!bl7) throw new IllegalArgumentException(this.bind("configure.invalidUsageOfMinusOption", string8));
                                    n10 = 0;
                                    string8 = string8.substring(1);
                                    break;
                                }
                            }
                            this.handleErrorToken(string8, n10 != 0);
                        }
                        if (n11 != 0) continue block51;
                        throw new IllegalArgumentException(this.bind("configure.invalidErrorOption", string6));
                    }
                    if (string6.equals("-target")) {
                        n6 = 4;
                        continue block51;
                    }
                    if (string6.equals("-preserveAllLocals")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-enableJavadoc")) {
                        n6 = 0;
                        this.enableJavadocOn = true;
                        continue block51;
                    }
                    if (string6.equals("-Xemacs")) {
                        n6 = 0;
                        this.logger.setEmacs();
                        continue block51;
                    }
                    if (string6.startsWith("-A")) {
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-processorpath")) {
                        n6 = 17;
                        continue block51;
                    }
                    if (string6.equals("-processor")) {
                        n6 = 18;
                        continue block51;
                    }
                    if (string6.equals("-proc:only")) {
                        this.options.put("org.eclipse.jdt.core.compiler.generateClassFiles", "disabled");
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-proc:none")) {
                        bl5 = true;
                        this.options.put("org.eclipse.jdt.core.compiler.processAnnotations", "disabled");
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-s")) {
                        n6 = 19;
                        continue block51;
                    }
                    if (string6.equals("-XprintProcessorInfo") || string6.equals("-XprintRounds")) {
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.startsWith("-X")) {
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.startsWith("-J")) {
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-O")) {
                        n6 = 0;
                        continue block51;
                    }
                    if (string6.equals("-classNames")) {
                        n6 = 20;
                        continue block51;
                    }
                    if (!string6.equals("-properties")) break;
                    n6 = 21;
                    continue block51;
                }
                case 4: {
                    if (this.didSpecifyTarget) {
                        throw new IllegalArgumentException(this.bind("configure.duplicateTarget", string6));
                    }
                    this.didSpecifyTarget = true;
                    if (string6.equals("1.1")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                    } else if (string6.equals("1.2")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                    } else if (string6.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
                    } else if (string6.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    } else if (string6.equals("1.5") || string6.equals("5") || string6.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    } else if (string6.equals("1.6") || string6.equals("6") || string6.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    } else if (string6.equals("1.7") || string6.equals("7") || string6.equals("7.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                    } else if (string6.equals("jsr14")) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "jsr14");
                    } else {
                        if (!string6.equals("cldc1.1")) throw new IllegalArgumentException(this.bind("configure.targetJDK", string6));
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "cldc1.1");
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
                    }
                    n6 = 0;
                    continue block51;
                }
                case 5: {
                    this.log = string6;
                    n6 = 0;
                    continue block51;
                }
                case 6: {
                    try {
                        this.maxRepetition = Integer.parseInt(string6);
                        if (this.maxRepetition <= 0) {
                            throw new IllegalArgumentException(this.bind("configure.repetition", string6));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(this.bind("configure.repetition", string6));
                    }
                    n6 = 0;
                    continue block51;
                }
                case 11: {
                    try {
                        this.maxProblems = Integer.parseInt(string6);
                        if (this.maxProblems <= 0) {
                            throw new IllegalArgumentException(this.bind("configure.maxProblems", string6));
                        }
                        this.options.put("org.eclipse.jdt.core.compiler.maxProblemPerUnit", string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(this.bind("configure.maxProblems", string6));
                    }
                    n6 = 0;
                    continue block51;
                }
                case 7: {
                    if (this.didSpecifySource) {
                        throw new IllegalArgumentException(this.bind("configure.duplicateSource", string6));
                    }
                    this.didSpecifySource = true;
                    if (string6.equals("1.3")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                    } else if (string6.equals("1.4")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.4");
                    } else if (string6.equals("1.5") || string6.equals("5") || string6.equals("5.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                    } else if (string6.equals("1.6") || string6.equals("6") || string6.equals("6.0")) {
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                    } else {
                        if (!string6.equals("1.7") && !string6.equals("7") && !string6.equals("7.0")) throw new IllegalArgumentException(this.bind("configure.source", string6));
                        this.options.put("org.eclipse.jdt.core.compiler.source", "1.7");
                    }
                    n6 = 0;
                    continue block51;
                }
                case 8: {
                    if (hashSet != null) {
                        if (!hashSet.contains(string6)) {
                            if (hashSet.size() > 1) {
                                this.logger.logWarning(this.bind("configure.differentencodings", string6, Main.getAllEncodings(hashSet)));
                            } else {
                                this.logger.logWarning(this.bind("configure.differentencoding", string6, Main.getAllEncodings(hashSet)));
                            }
                        }
                    } else {
                        hashSet = new HashSet<String>();
                    }
                    try {
                        new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), string6);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new IllegalArgumentException(this.bind("configure.unsupportedEncoding", string6));
                    }
                    hashSet.add(string6);
                    this.options.put("org.eclipse.jdt.core.encoding", string6);
                    n6 = 0;
                    continue block51;
                }
                case 3: {
                    this.setDestinationPath(string6.equals(NONE) ? NONE : string6);
                    n6 = 0;
                    continue block51;
                }
                case 1: {
                    n6 = 0;
                    n2 += this.processPaths(stringArray2, n2, string6, arrayList3);
                    continue block51;
                }
                case 9: {
                    n6 = 0;
                    n2 += this.processPaths(stringArray2, n2, string6, arrayList);
                    continue block51;
                }
                case 13: {
                    n6 = 0;
                    String[] stringArray5 = new String[1];
                    n2 += this.processPaths(stringArray2, n2, string6, stringArray5);
                    string = stringArray5[0];
                    continue block51;
                }
                case 12: {
                    if (string6.indexOf("[-d") != -1) {
                        throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntry", "-extdir"));
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, File.pathSeparator, false);
                    arrayList4 = new ArrayList<String>(4);
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList4.add(stringTokenizer.nextToken());
                    }
                    n6 = 0;
                    continue block51;
                }
                case 15: {
                    if (string6.indexOf("[-d") != -1) {
                        throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntry", "-endorseddirs"));
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, File.pathSeparator, false);
                    arrayList5 = new ArrayList<String>(4);
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList5.add(stringTokenizer.nextToken());
                    }
                    n6 = 0;
                    continue block51;
                }
                case 16: {
                    if (!string6.endsWith("]")) throw new IllegalArgumentException(this.bind("configure.incorrectDestinationPathEntry", "[-d " + string6));
                    string4 = string6.substring(0, string6.length() - 1);
                    break;
                }
                case 17: {
                    n6 = 0;
                    continue block51;
                }
                case 18: {
                    n6 = 0;
                    continue block51;
                }
                case 19: {
                    n6 = 0;
                    continue block51;
                }
                case 20: {
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                    if (this.classNames == null) {
                        this.classNames = new String[4];
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        if (this.classNames.length == n4) {
                            this.classNames = new String[n4 * 2];
                            System.arraycopy(this.classNames, 0, this.classNames, 0, n4);
                        }
                        this.classNames[n4++] = stringTokenizer.nextToken();
                    }
                    n6 = 0;
                    continue block51;
                }
                case 21: {
                    this.initializeWarnings(string6);
                    n6 = 0;
                    continue block51;
                }
            }
            if (string4 == null) {
                if (File.separatorChar != '/') {
                    string6 = string6.replace('/', File.separatorChar);
                }
                if (string6.endsWith("[-d")) {
                    string5 = string6.substring(0, string6.length() - 3);
                    n6 = 16;
                    continue;
                }
                string5 = string6;
            }
            if (!(file = new File(string5)).isDirectory()) {
                throw new IllegalArgumentException(this.bind("configure.unrecognizedOption", string5));
            }
            String[] stringArray6 = FileFinder.find(file, ".JAVA");
            if (NONE.equals(string4)) {
                string4 = NONE;
            }
            if (this.filenames != null) {
                n9 = stringArray6.length;
                this.filenames = new String[n9 + n3];
                System.arraycopy(this.filenames, 0, this.filenames, 0, n3);
                this.encodings = new String[n9 + n3];
                System.arraycopy(this.encodings, 0, this.encodings, 0, n3);
                this.destinationPaths = new String[n9 + n3];
                System.arraycopy(this.destinationPaths, 0, this.destinationPaths, 0, n3);
                System.arraycopy(stringArray6, 0, this.filenames, n3, n9);
                for (n10 = 0; n10 < n9; ++n10) {
                    this.encodings[n3 + n10] = string3;
                    this.destinationPaths[n3 + n10] = string4;
                }
                n3 += n9;
                string3 = null;
                string4 = null;
                string5 = null;
            } else {
                this.filenames = stringArray6;
                n3 = this.filenames.length;
                this.encodings = new String[n3];
                this.destinationPaths = new String[n3];
                for (n9 = 0; n9 < n3; ++n9) {
                    this.encodings[n9] = string3;
                    this.destinationPaths[n9] = string4;
                }
                string3 = null;
                string4 = null;
                string5 = null;
            }
            n6 = 0;
        }
        if (this.enableJavadocOn) {
            this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        } else if (this.warnJavadocOn || this.warnAllJavadocOn) {
            this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference", "disabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference", "disabled");
        }
        if (this.warnJavadocOn) {
            this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", "enabled");
            this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
        }
        if (bl || n3 == 0 && n4 == 0) {
            if (string2 == null) {
                this.printUsage();
            } else {
                this.printUsage(string2);
            }
            this.proceed = false;
            return;
        }
        if (this.log != null) {
            this.logger.setLog(this.log);
        } else {
            this.showProgress = false;
        }
        this.logger.logVersion(bl2);
        this.validateOptions(bl4);
        if (!bl5 && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) >= 0x320000L) {
            this.options.put("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        }
        this.logger.logCommandLineArguments(stringArray2);
        this.logger.logOptions(this.options);
        if (this.maxRepetition == 0) {
            this.maxRepetition = 1;
        }
        if (this.maxRepetition >= 3 && (this.timing & 1) != 0) {
            this.compilerStats = new CompilerStats[this.maxRepetition];
        }
        if (n3 != 0) {
            this.filenames = new String[n3];
            System.arraycopy(this.filenames, 0, this.filenames, 0, n3);
        }
        if (n4 != 0) {
            this.classNames = new String[n4];
            System.arraycopy(this.classNames, 0, this.classNames, 0, n4);
        }
        this.setPaths(arrayList, string, arrayList2, arrayList3, arrayList4, arrayList5, string3);
        if (hashSet != null && hashSet.size() > 1) {
            this.logger.logWarning(this.bind("configure.multipleencodings", (String)this.options.get("org.eclipse.jdt.core.encoding"), Main.getAllEncodings(hashSet)));
        }
        if (this.pendingErrors == null) return;
        Iterator iterator = this.pendingErrors.iterator();
        while (iterator.hasNext()) {
            String string13 = (String)iterator.next();
            this.logger.logPendingError(string13);
        }
        this.pendingErrors = null;
    }

    private static String getAllEncodings(Set set) {
        int n = set.size();
        Object[] objectArray = new String[n];
        set.toArray(objectArray);
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((String)objectArray[i]);
        }
        return String.valueOf(stringBuffer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeWarnings(String string) {
        String string2;
        Properties properties;
        block9: {
            File file = new File(string);
            if (!file.exists()) {
                throw new IllegalArgumentException(this.bind("configure.missingwarningspropertiesfile", string));
            }
            BufferedInputStream bufferedInputStream = null;
            properties = null;
            try {
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                    properties = new Properties();
                    properties.load(bufferedInputStream);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new IllegalArgumentException(this.bind("configure.ioexceptionwarningspropertiesfile", string));
                }
                string2 = null;
                if (bufferedInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (bufferedInputStream == null) throw throwable;
                try {
                    bufferedInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            bufferedInputStream.close();
        }
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            string2 = (String)entry.getKey();
            if (!string2.startsWith("org.eclipse.jdt.core.compiler.problem")) continue;
            this.options.put(string2, entry.getValue());
        }
    }

    protected void disableWarnings() {
        Object[] objectArray = this.options.entrySet().toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = (Map.Entry)objectArray[i];
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !((String)entry.getValue()).equals("warning")) continue;
            this.options.put(entry.getKey(), "ignore");
        }
        this.options.put("org.eclipse.jdt.core.compiler.taskTags", Util.EMPTY_STRING);
    }

    protected void disableErrors() {
        Object[] objectArray = this.options.entrySet().toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = (Map.Entry)objectArray[i];
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !((String)entry.getValue()).equals("error")) continue;
            this.options.put(entry.getKey(), "ignore");
        }
    }

    public String extractDestinationPathFromSourceFile(CompilationResult compilationResult) {
        String string;
        File file;
        char[] cArray;
        int n;
        ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
        if (iCompilationUnit != null && (n = CharOperation.lastIndexOf(File.separatorChar, cArray = iCompilationUnit.getFileName())) != -1 && (file = new File(string = new String(cArray, 0, n))).exists() && file.isDirectory()) {
            return string;
        }
        return System.getProperty("user.dir");
    }

    public ICompilerRequestor getBatchRequestor() {
        return new ICompilerRequestor(){
            int lineDelta = 0;

            public void acceptResult(CompilationResult compilationResult) {
                if (compilationResult.lineSeparatorPositions != null) {
                    int n = compilationResult.lineSeparatorPositions.length;
                    this.lineDelta += n;
                    if (Main.this.showProgress && this.lineDelta > 2000) {
                        Main.this.logger.logProgress();
                        this.lineDelta = 0;
                    }
                }
                Main.this.logger.startLoggingSource(compilationResult);
                if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
                    Main.this.logger.logProblems(compilationResult.getAllProblems(), compilationResult.compilationUnit.getContents(), Main.this);
                }
                Main.this.outputClassFiles(compilationResult);
                Main.this.logger.endLoggingSource();
            }
        };
    }

    public CompilationUnit[] getCompilationUnits() {
        int n = this.filenames.length;
        CompilationUnit[] compilationUnitArray = new CompilationUnit[n];
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n);
        String string = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if (Util.EMPTY_STRING.equals(string)) {
            string = null;
        }
        for (int i = 0; i < n; ++i) {
            char[] cArray = this.filenames[i].toCharArray();
            if (hashtableOfObject.get(cArray) != null) {
                throw new IllegalArgumentException(this.bind("unit.more", this.filenames[i]));
            }
            hashtableOfObject.put(cArray, cArray);
            File file = new File(this.filenames[i]);
            if (!file.exists()) {
                throw new IllegalArgumentException(this.bind("unit.missing", this.filenames[i]));
            }
            String string2 = this.encodings[i];
            if (string2 == null) {
                string2 = string;
            }
            compilationUnitArray[i] = new CompilationUnit(null, this.filenames[i], string2, this.destinationPaths[i]);
        }
        return compilationUnitArray;
    }

    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean proceedOnErrors() {
                return Main.this.proceedOnError;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        };
    }

    public File getJavaHome() {
        if (!this.javaHomeChecked) {
            this.javaHomeChecked = true;
            this.javaHomeCache = Util.getJavaHome();
        }
        return this.javaHomeCache;
    }

    public FileSystem getLibraryAccess() {
        return new FileSystem(this.checkedClasspaths, this.filenames);
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(this.compilerLocale);
    }

    protected ArrayList handleBootclasspath(ArrayList arrayList, String string) {
        int n;
        if (arrayList != null && (n = arrayList.size()) != 0) {
            String[] stringArray = new String[n];
            arrayList.toArray(stringArray);
            arrayList.clear();
            for (int i = 0; i < n; ++i) {
                this.processPathEntries(4, arrayList, stringArray[i], string, false, true);
            }
        } else {
            arrayList = new ArrayList(4);
            try {
                Util.collectRunningVMBootclasspath(arrayList);
            }
            catch (IllegalStateException illegalStateException) {
                this.logger.logWrongJDK();
                this.proceed = false;
                return null;
            }
        }
        return arrayList;
    }

    protected ArrayList handleClasspath(ArrayList arrayList, String string) {
        FileSystem.Classpath classpath;
        Object object;
        Object object2;
        int n;
        if (arrayList != null && (n = arrayList.size()) != 0) {
            object2 = new String[n];
            arrayList.toArray((T[])object2);
            arrayList.clear();
            for (int i = 0; i < n; ++i) {
                this.processPathEntries(4, arrayList, (String)object2[i], string, false, true);
            }
        } else {
            arrayList = new ArrayList<FileSystem.Classpath>(4);
            object2 = System.getProperty("java.class.path");
            if (object2 == null || ((String)object2).length() == 0) {
                this.addPendingErrors(this.bind("configure.noClasspath"));
                FileSystem.Classpath classpath2 = FileSystem.getClasspath(System.getProperty("user.dir"), string, null);
                if (classpath2 != null) {
                    arrayList.add(classpath2);
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    classpath = FileSystem.getClasspath((String)object, string, null);
                    if (classpath != null) {
                        arrayList.add(classpath);
                        continue;
                    }
                    if (((String)object).length() == 0) continue;
                    this.addPendingErrors(this.bind("configure.incorrectClasspath", (String)object));
                }
            }
        }
        object2 = new ArrayList();
        HashMap<String, FileSystem.Classpath> hashMap = new HashMap<String, FileSystem.Classpath>();
        object = new FileSystem.ClasspathSectionProblemReporter(){

            public void invalidClasspathSection(String string) {
                Main.this.addPendingErrors(Main.this.bind("configure.invalidClasspathSection", string));
            }

            public void multipleClasspathSections(String string) {
                Main.this.addPendingErrors(Main.this.bind("configure.multipleClasspathSections", string));
            }
        };
        while (!arrayList.isEmpty()) {
            classpath = (FileSystem.Classpath)arrayList.remove(0);
            String string2 = classpath.getPath();
            if (hashMap.get(string2) != null) continue;
            hashMap.put(string2, classpath);
            ((ArrayList)object2).add(classpath);
            List list = classpath.fetchLinkedJars((FileSystem.ClasspathSectionProblemReporter)object);
            if (list == null) continue;
            arrayList.addAll(0, list);
        }
        return object2;
    }

    protected ArrayList handleEndorseddirs(ArrayList arrayList) {
        Object object;
        File file = this.getJavaHome();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(4);
            object = System.getProperty("java.endorsed.dirs");
            if (object == null) {
                if (file != null) {
                    arrayList.add(file.getAbsolutePath() + "/lib/endorsed");
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
        }
        if (arrayList.size() != 0) {
            object = new File[arrayList.size()];
            for (int i = 0; i < ((File[])object).length; ++i) {
                object[i] = new File((String)arrayList.get(i));
            }
            arrayList.clear();
            File[][] fileArray = Main.getLibrariesFiles(object);
            if (fileArray != null) {
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File[] fileArray2 = fileArray[i];
                    if (fileArray2 != null) {
                        int n2 = fileArray2.length;
                        for (int j = 0; j < n2; ++j) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray2[j].getAbsolutePath(), null, null);
                            if (classpath == null) continue;
                            arrayList.add(classpath);
                        }
                        continue;
                    }
                    if (!object[i].isFile()) continue;
                    this.addPendingErrors(this.bind("configure.incorrectEndorsedDirsEntry", object[i].getAbsolutePath()));
                }
            }
        }
        return arrayList;
    }

    protected ArrayList handleExtdirs(ArrayList arrayList) {
        Object object;
        File file = this.getJavaHome();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(4);
            object = System.getProperty("java.ext.dirs");
            if (object == null) {
                arrayList.add(file.getAbsolutePath() + "/lib/ext");
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
        }
        if (arrayList.size() != 0) {
            object = new File[arrayList.size()];
            for (int i = 0; i < ((File[])object).length; ++i) {
                object[i] = new File((String)arrayList.get(i));
            }
            arrayList.clear();
            File[][] fileArray = Main.getLibrariesFiles(object);
            if (fileArray != null) {
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File[] fileArray2 = fileArray[i];
                    if (fileArray2 != null) {
                        int n2 = fileArray2.length;
                        for (int j = 0; j < n2; ++j) {
                            FileSystem.Classpath classpath = FileSystem.getClasspath(fileArray2[j].getAbsolutePath(), null, null);
                            if (classpath == null) continue;
                            arrayList.add(classpath);
                        }
                        continue;
                    }
                    if (!object[i].isFile()) continue;
                    this.addPendingErrors(this.bind("configure.incorrectExtDirsEntry", object[i].getAbsolutePath()));
                }
            }
        }
        return arrayList;
    }

    protected void handleWarningToken(String string, boolean bl) {
        this.handleErrorOrWarningToken(string, bl, 0);
    }

    protected void handleErrorToken(String string, boolean bl) {
        this.handleErrorOrWarningToken(string, bl, 1);
    }

    private void setSeverity(String string, int n, boolean bl) {
        if (bl) {
            switch (n) {
                case 1: {
                    this.options.put(string, "error");
                    break;
                }
                case 0: {
                    this.options.put(string, "warning");
                    break;
                }
                default: {
                    this.options.put(string, "ignore");
                    break;
                }
            }
        } else {
            switch (n) {
                case 1: {
                    String string2 = (String)this.options.get(string);
                    if (!"error".equals(string2)) break;
                    this.options.put(string, "ignore");
                    break;
                }
                case 0: {
                    String string3 = (String)this.options.get(string);
                    if (!"warning".equals(string3)) break;
                    this.options.put(string, "ignore");
                    break;
                }
                default: {
                    this.options.put(string, "ignore");
                }
            }
        }
    }

    private void handleErrorOrWarningToken(String string, boolean bl, int n) {
        if (string.length() == 0) {
            return;
        }
        switch (string.charAt(0)) {
            case 'a': {
                if (string.equals("allDeprecation")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.deprecation", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", bl ? "enabled" : "disabled");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("allJavadoc")) {
                    this.warnAllJavadocOn = this.warnJavadocOn = bl;
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", n, bl);
                    return;
                }
                if (string.equals("assertIdentifier")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.assertIdentifier", n, bl);
                    return;
                }
                if (string.equals("allDeadCode")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.deadCode", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deadCodeInTrivialIfStatement", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("allOver-ann")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", bl ? "enabled" : "disabled");
                    return;
                }
                if (!string.equals("all-static-method")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", n, bl);
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", n, bl);
                return;
            }
            case 'b': {
                if (!string.equals("boxing")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.autoboxing", n, bl);
                return;
            }
            case 'c': {
                if (string.equals("constructorName")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", n, bl);
                    return;
                }
                if (string.equals("conditionAssign")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", n, bl);
                    return;
                }
                if (string.equals("compareIdentical")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.comparingIdentical", n, bl);
                    return;
                }
                if (!string.equals("charConcat")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", n, bl);
                return;
            }
            case 'd': {
                if (string.equals("deprecation")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.deprecation", n, bl);
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled");
                    return;
                }
                if (string.equals("dep-ann")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", n, bl);
                    return;
                }
                if (string.equals("discouraged")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.discouragedReference", n, bl);
                    return;
                }
                if (!string.equals("deadCode")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.deadCode", n, bl);
                this.options.put("org.eclipse.jdt.core.compiler.problem.deadCodeInTrivialIfStatement", "disabled");
                return;
            }
            case 'e': {
                if (string.equals("enumSwitch") || string.equals("incomplete-switch")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", n, bl);
                    return;
                }
                if (string.equals("emptyBlock")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", n, bl);
                    return;
                }
                if (!string.equals("enumIdentifier")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.enumIdentifier", n, bl);
                return;
            }
            case 'f': {
                if (string.equals("fieldHiding")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.fieldHiding", n, bl);
                    return;
                }
                if (string.equals("finalBound")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.finalParameterBound", n, bl);
                    return;
                }
                if (string.equals("finally")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", n, bl);
                    return;
                }
                if (string.equals("forbidden")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.forbiddenReference", n, bl);
                    return;
                }
                if (!string.equals("fallthrough")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.fallthroughCase", n, bl);
                return;
            }
            case 'h': {
                if (string.equals("hiding")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.localVariableHiding", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.fieldHiding", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", n, bl);
                    return;
                }
                if (!string.equals("hashCode")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingHashCodeMethod", n, bl);
                return;
            }
            case 'i': {
                if (string.equals("indirectStatic")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", n, bl);
                    return;
                }
                if (string.equals("intfNonInherited") || string.equals("interfaceNonInherited")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", n, bl);
                    return;
                }
                if (string.equals("intfAnnotation")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.annotationSuperInterface", n, bl);
                    return;
                }
                if (string.equals("intfRedundant")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", n, bl);
                    return;
                }
                if (!string.equals("includeAssertNull")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.includeNullInfoFromAsserts", bl ? "enabled" : "disabled");
                return;
            }
            case 'j': {
                if (!string.equals("javadoc")) break;
                this.warnJavadocOn = bl;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", n, bl);
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", n, bl);
                return;
            }
            case 'l': {
                if (!string.equals("localHiding")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.localVariableHiding", n, bl);
                return;
            }
            case 'm': {
                if (!string.equals("maskedCatchBlock") && !string.equals("maskedCatchBlocks")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", n, bl);
                return;
            }
            case 'n': {
                if (string.equals("nls")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", n, bl);
                    return;
                }
                if (string.equals("noEffectAssign")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", n, bl);
                    return;
                }
                if (string.equals("noImplicitStringConversion")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", n, bl);
                    return;
                }
                if (string.equals("null")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullReference", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.potentialNullReference", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", n, bl);
                    return;
                }
                if (!string.equals("nullDereference")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.nullReference", n, bl);
                if (!bl) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.potentialNullReference", 256, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", 256, bl);
                }
                return;
            }
            case 'o': {
                if (string.equals("over-sync")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod", n, bl);
                    return;
                }
                if (!string.equals("over-ann")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", n, bl);
                this.options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
                return;
            }
            case 'p': {
                if (string.equals("pkgDefaultMethod") || string.equals("packageDefaultMethod")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", n, bl);
                    return;
                }
                if (!string.equals("paramAssign")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.parameterAssignment", n, bl);
                return;
            }
            case 'r': {
                if (string.equals("raw")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.rawTypeReference", n, bl);
                    return;
                }
                if (!string.equals("redundantSuperinterface")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", n, bl);
                return;
            }
            case 's': {
                if (string.equals("specialParamHiding")) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", bl ? "enabled" : "disabled");
                    return;
                }
                if (string.equals("syntheticAccess") || string.equals("synthetic-access")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", n, bl);
                    return;
                }
                if (string.equals("staticReceiver")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", n, bl);
                    return;
                }
                if (string.equals("syncOverride")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod", n, bl);
                    return;
                }
                if (string.equals("semicolon")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.emptyStatement", n, bl);
                    return;
                }
                if (string.equals("serial")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", n, bl);
                    return;
                }
                if (string.equals("suppress")) {
                    switch (n) {
                        case 0: {
                            this.options.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", bl ? "enabled" : "disabled");
                            this.options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "disabled");
                            break;
                        }
                        case 1: {
                            this.options.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", bl ? "enabled" : "disabled");
                            this.options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", bl ? "enabled" : "disabled");
                        }
                    }
                    return;
                }
                if (string.equals("static-access")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", n, bl);
                    return;
                }
                if (string.equals("super")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", n, bl);
                    return;
                }
                if (!string.equals("static-method")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", n, bl);
                return;
            }
            case 't': {
                if (string.startsWith("tasks")) {
                    String string2 = Util.EMPTY_STRING;
                    int n2 = string.indexOf(40);
                    int n3 = string.indexOf(41);
                    if (n2 >= 0 && n3 >= 0 && n2 < n3) {
                        string2 = string.substring(n2 + 1, n3).trim();
                        string2 = string2.replace('|', ',');
                    }
                    if (string2.length() == 0) {
                        throw new IllegalArgumentException(this.bind("configure.invalidTaskTag", string));
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.taskTags", bl ? string2 : Util.EMPTY_STRING);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.tasks", n, bl);
                    return;
                }
                if (!string.equals("typeHiding")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", n, bl);
                return;
            }
            case 'u': {
                if (string.equals("unusedLocal") || string.equals("unusedLocals")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedLocal", n, bl);
                    return;
                }
                if (string.equals("unusedArgument") || string.equals("unusedArguments")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedParameter", n, bl);
                    return;
                }
                if (string.equals("unusedImport") || string.equals("unusedImports")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedImport", n, bl);
                    return;
                }
                if (string.equals("unusedAllocation")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", n, bl);
                    return;
                }
                if (string.equals("unusedPrivate")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", n, bl);
                    return;
                }
                if (string.equals("unusedLabel")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedLabel", n, bl);
                    return;
                }
                if (string.equals("uselessTypeCheck")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", n, bl);
                    return;
                }
                if (string.equals("unchecked") || string.equals("unsafe")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", n, bl);
                    return;
                }
                if (string.equals("unnecessaryElse")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unnecessaryElse", n, bl);
                    return;
                }
                if (string.equals("unusedThrown")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", n, bl);
                    return;
                }
                if (string.equals("unqualifiedField") || string.equals("unqualified-field-access")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", n, bl);
                    return;
                }
                if (string.equals("unused")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedLocal", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedParameter", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedImport", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedLabel", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", n, bl);
                    return;
                }
                if (string.equals("unusedTypeArgs")) {
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation", n, bl);
                    this.setSeverity("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", n, bl);
                    return;
                }
                if (!string.equals("unavoidableGenericProblems")) break;
                this.options.put("org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems", bl ? "enabled" : "disabled");
                return;
            }
            case 'v': {
                if (!string.equals("varargsCast")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast", n, bl);
                return;
            }
            case 'w': {
                if (!string.equals("warningToken")) break;
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", n, bl);
                this.setSeverity("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", n, bl);
                return;
            }
        }
        String string3 = null;
        switch (n) {
            case 0: {
                string3 = this.bind("configure.invalidWarning", string);
                break;
            }
            case 1: {
                string3 = this.bind("configure.invalidError", string);
            }
        }
        this.addPendingErrors(string3);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        this.initialize(printWriter, printWriter2, bl, null, null);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map) {
        this.initialize(printWriter, printWriter2, bl, map, null);
    }

    protected void initialize(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Map map, CompilationProgress compilationProgress) {
        this.logger = new Logger(this, printWriter, printWriter2);
        this.proceed = true;
        this.out = printWriter;
        this.err = printWriter2;
        this.systemExitWhenFinished = bl;
        this.options = new CompilerOptions().getMap();
        this.progress = compilationProgress;
        if (map != null) {
            this.didSpecifySource = map.get("org.eclipse.jdt.core.compiler.source") != null;
            this.didSpecifyTarget = map.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform") != null;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.options.put(entry.getKey(), entry.getValue());
            }
        } else {
            this.didSpecifySource = false;
            this.didSpecifyTarget = false;
        }
        this.classNames = null;
    }

    protected void initializeAnnotationProcessorManager() {
        try {
            Class<?> clazz = Class.forName("org.eclipse.jdt.internal.compiler.apt.dispatch.BatchAnnotationProcessorManager");
            AbstractAnnotationProcessorManager abstractAnnotationProcessorManager = (AbstractAnnotationProcessorManager)clazz.newInstance();
            abstractAnnotationProcessorManager.configure(this, this.expandedCommandLine);
            abstractAnnotationProcessorManager.setErr(this.err);
            abstractAnnotationProcessorManager.setOut(this.out);
            this.batchCompiler.annotationProcessorManager = abstractAnnotationProcessorManager;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
            throw new AbortCompilation();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AbortCompilation();
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            this.logger.logIncorrectVMVersionForAnnotationProcessing();
        }
    }

    public void outputClassFiles(CompilationResult compilationResult) {
        if (compilationResult != null && (!compilationResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFileArray = compilationResult.getClassFiles();
            String string = null;
            boolean bl = false;
            CompilationUnit compilationUnit = (CompilationUnit)compilationResult.compilationUnit;
            if (compilationUnit.destinationPath == null) {
                if (this.destinationPath == null) {
                    string = this.extractDestinationPathFromSourceFile(compilationResult);
                } else if (this.destinationPath != NONE) {
                    string = this.destinationPath;
                    bl = true;
                }
            } else if (compilationUnit.destinationPath != NONE) {
                string = compilationUnit.destinationPath;
                bl = true;
            }
            if (string != null) {
                int n = classFileArray.length;
                for (int i = 0; i < n; ++i) {
                    ClassFile classFile = classFileArray[i];
                    char[] cArray = classFile.fileName();
                    int n2 = cArray.length;
                    char[] cArray2 = new char[n2 + 6];
                    System.arraycopy(cArray, 0, cArray2, 0, n2);
                    System.arraycopy(SuffixConstants.SUFFIX_class, 0, cArray2, n2, 6);
                    CharOperation.replace(cArray2, '/', File.separatorChar);
                    String string2 = new String(cArray2);
                    try {
                        if (this.compilerOptions.verbose) {
                            this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), string2}));
                        }
                        Util.writeToDisk(bl, string, string2, classFile);
                        this.logger.logClassFile(bl, string, string2);
                        ++this.exportedClassFilesCounter;
                        continue;
                    }
                    catch (IOException iOException) {
                        this.logger.logNoClassFileCreated(string, string2, iOException);
                    }
                }
                this.batchCompiler.lookupEnvironment.releaseClassFiles(classFileArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCompilation() {
        this.startTime = System.currentTimeMillis();
        FileSystem fileSystem = this.getLibraryAccess();
        this.compilerOptions = new CompilerOptions(this.options);
        this.compilerOptions.performMethodsFullRecovery = false;
        this.compilerOptions.performStatementsRecovery = false;
        this.batchCompiler = new Compiler(fileSystem, this.getHandlingPolicy(), this.compilerOptions, this.getBatchRequestor(), this.getProblemFactory(), this.out, this.progress);
        this.batchCompiler.remainingIterations = this.maxRepetition - this.currentRepetition;
        String string = System.getProperty("jdt.compiler.useSingleThread");
        boolean bl = this.batchCompiler.useSingleThread = string != null && string.equals("true");
        if (this.compilerOptions.complianceLevel >= 0x320000L && this.compilerOptions.processAnnotations) {
            if (this.checkVMVersion(0x320000L)) {
                this.initializeAnnotationProcessorManager();
                if (this.classNames != null) {
                    this.batchCompiler.setBinaryTypes(this.processClassNames(this.batchCompiler.lookupEnvironment));
                }
            } else {
                this.logger.logIncorrectVMVersionForAnnotationProcessing();
            }
        }
        this.compilerOptions.verbose = this.verbose;
        this.compilerOptions.produceReferenceInfo = this.produceRefInfo;
        try {
            this.logger.startLoggingSources();
            this.batchCompiler.compile(this.getCompilationUnits());
            Object var4_3 = null;
            this.logger.endLoggingSources();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.logger.endLoggingSources();
            throw throwable;
        }
        if (this.extraProblems != null) {
            this.loggingExtraProblems();
            this.extraProblems = null;
        }
        if (this.compilerStats != null) {
            this.compilerStats[this.currentRepetition] = this.batchCompiler.stats;
        }
        this.logger.printStats();
        fileSystem.cleanup();
    }

    protected void loggingExtraProblems() {
        this.logger.loggingExtraProblems(this);
    }

    public void printUsage() {
        this.printUsage("misc.usage");
    }

    private void printUsage(String string) {
        this.logger.logUsage(this.bind(string, new String[]{System.getProperty("path.separator"), this.bind("compiler.name"), this.bind("compiler.version"), this.bind("compiler.copyright")}));
        this.logger.flush();
    }

    private ReferenceBinding[] processClassNames(LookupEnvironment lookupEnvironment) {
        int n = this.classNames.length;
        ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            String string = this.classNames[i];
            Object object2 = null;
            if (string.indexOf(46) != -1) {
                object = string.toCharArray();
                object2 = CharOperation.splitOn('.', (char[])object);
            } else {
                object2 = new char[][]{string.toCharArray()};
            }
            object = lookupEnvironment.getType((char[][])object2);
            if (object != null && ((Binding)object).isValidBinding()) {
                if (!((ReferenceBinding)object).isBinaryBinding()) continue;
                referenceBindingArray[i] = object;
                continue;
            }
            throw new IllegalArgumentException(this.bind("configure.invalidClassName", string));
        }
        return referenceBindingArray;
    }

    public void processPathEntries(int n, ArrayList arrayList, String string, String string2, boolean bl, boolean bl2) {
        String string3 = null;
        String string4 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator + "[]", true);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList3.add(stringTokenizer.nextToken());
        }
        int n2 = 0;
        String string5 = null;
        int n3 = 0;
        int n4 = arrayList3.size();
        int n5 = -1;
        while (n3 < n4 && n2 != 99) {
            if ((string5 = (String)arrayList3.get(n3++)).equals(File.pathSeparator)) {
                switch (n2) {
                    case 0: 
                    case 3: 
                    case 10: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 8: {
                        n2 = 3;
                        this.addNewEntry(arrayList, string3, arrayList2, string2, string4, bl, bl2);
                        arrayList2.clear();
                        break;
                    }
                    case 6: {
                        n2 = 4;
                        break;
                    }
                    case 7: {
                        throw new IllegalArgumentException(this.bind("configure.incorrectDestinationPathEntry", string));
                    }
                    case 11: {
                        n3 = n5 + 1;
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else if (string5.equals("[")) {
                switch (n2) {
                    case 0: {
                        string3 = "";
                    }
                    case 1: {
                        n5 = n3 - 1;
                    }
                    case 11: {
                        n2 = 10;
                        break;
                    }
                    case 2: {
                        n2 = 9;
                        break;
                    }
                    case 8: {
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else if (string5.equals("]")) {
                switch (n2) {
                    case 6: {
                        n2 = 2;
                        break;
                    }
                    case 7: {
                        n2 = 8;
                        break;
                    }
                    case 10: {
                        n2 = 11;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else {
                switch (n2) {
                    case 0: 
                    case 3: {
                        n2 = 1;
                        string3 = string5;
                        break;
                    }
                    case 5: {
                        if (string5.startsWith("-d ")) {
                            if (string4 != null) {
                                throw new IllegalArgumentException(this.bind("configure.duplicateDestinationPathEntry", string));
                            }
                            string4 = string5.substring(3).trim();
                            n2 = 7;
                            break;
                        }
                    }
                    case 4: {
                        if (string4 != null) {
                            throw new IllegalArgumentException(this.bind("configure.accessRuleAfterDestinationPath", string));
                        }
                        n2 = 6;
                        arrayList2.add(string5);
                        break;
                    }
                    case 9: {
                        if (!string5.startsWith("-d ")) {
                            n2 = 99;
                            break;
                        }
                        string4 = string5.substring(3).trim();
                        n2 = 7;
                        break;
                    }
                    case 11: {
                        for (int i = n5; i < n3; ++i) {
                            string3 = string3 + (String)arrayList3.get(i);
                        }
                        n2 = 1;
                        break;
                    }
                    case 10: {
                        break;
                    }
                    default: {
                        n2 = 99;
                    }
                }
            }
            if (n2 != 11 || n3 != n4) continue;
            n3 = n5 + 1;
            n2 = 5;
        }
        switch (n2) {
            case 3: {
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                this.addNewEntry(arrayList, string3, arrayList2, string2, string4, bl, bl2);
                break;
            }
            default: {
                if (string.length() == 0) break;
                this.addPendingErrors(this.bind("configure.incorrectClasspath", string));
            }
        }
    }

    private int processPaths(String[] stringArray, int n, String string, ArrayList arrayList) {
        int n2 = n;
        int n3 = 0;
        int n4 = string.length();
        block8: for (int i = 0; i < n4; ++i) {
            switch (string.charAt(i)) {
                case '[': {
                    ++n3;
                    continue block8;
                }
                case ']': {
                    --n3;
                }
            }
        }
        if (n3 != 0) {
            if (n3 > 1) {
                throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            while (true) {
                if (n2 >= stringArray.length) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                }
                String string2 = stringArray[++n2];
                int n5 = string2.length();
                block10: for (int i = 0; i < n5; ++i) {
                    switch (string2.charAt(i)) {
                        case '[': {
                            if (n3 > 1) {
                                throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string2));
                            }
                            ++n3;
                            continue block10;
                        }
                        case ']': {
                            --n3;
                        }
                    }
                }
                if (n3 == 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                    arrayList.add(stringBuffer.toString());
                    return n2 - n;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string2));
                }
                stringBuffer.append(' ');
                stringBuffer.append(string2);
            }
        }
        arrayList.add(string);
        return n2 - n;
    }

    private int processPaths(String[] stringArray, int n, String string, String[] stringArray2) {
        int n2 = n;
        int n3 = 0;
        int n4 = string.length();
        block8: for (int i = 0; i < n4; ++i) {
            switch (string.charAt(i)) {
                case '[': {
                    ++n3;
                    continue block8;
                }
                case ']': {
                    --n3;
                }
            }
        }
        if (n3 != 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (true) {
                if (++n2 >= stringArray.length) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                }
                String string2 = stringArray[n2];
                int n5 = string2.length();
                block10: for (int i = 0; i < n5; ++i) {
                    switch (string2.charAt(i)) {
                        case '[': {
                            if (n3 > 1) {
                                throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                            }
                            ++n3;
                            continue block10;
                        }
                        case ']': {
                            --n3;
                        }
                    }
                }
                if (n3 == 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                    stringArray2[0] = stringBuffer.toString();
                    return n2 - n;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException(this.bind("configure.unexpectedBracket", string));
                }
                stringBuffer.append(' ');
                stringBuffer.append(string2);
            }
        }
        stringArray2[0] = string;
        return n2 - n;
    }

    public void relocalize() {
        this.relocalize(Locale.getDefault());
    }

    private void relocalize(Locale locale) {
        this.compilerLocale = locale;
        try {
            this.bundle = ResourceBundleFactory.getBundle(locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + locale);
            throw missingResourceException;
        }
    }

    public void setDestinationPath(String string) {
        this.destinationPath = string;
    }

    public void setLocale(Locale locale) {
        this.relocalize(locale);
    }

    protected void setPaths(ArrayList arrayList, String string, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, String string2) {
        arrayList = this.handleBootclasspath(arrayList, string2);
        arrayList3 = this.handleClasspath(arrayList3, string2);
        if (string != null) {
            this.processPathEntries(4, arrayList2, string, string2, true, false);
        }
        arrayList4 = this.handleExtdirs(arrayList4);
        arrayList5 = this.handleEndorseddirs(arrayList5);
        arrayList.addAll(arrayList5);
        arrayList.addAll(arrayList4);
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        arrayList3 = arrayList;
        arrayList3 = FileSystem.ClasspathNormalizer.normalize(arrayList3);
        this.checkedClasspaths = new FileSystem.Classpath[arrayList3.size()];
        arrayList3.toArray(this.checkedClasspaths);
        this.logger.logClasspath(this.checkedClasspaths);
    }

    protected void validateOptions(boolean bl) {
        Object v;
        Object v2;
        if (bl) {
            v2 = this.options.get("org.eclipse.jdt.core.compiler.compliance");
            if ("1.3".equals(v2)) {
                if (!this.didSpecifySource) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                }
            } else if ("1.4".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                        }
                    } else if ("1.4".equals(v) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                    }
                }
            } else if ("1.5".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(v) || "1.4".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if ("1.5".equals(v) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    }
                }
            } else if ("1.6".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(v) || "1.4".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if (("1.5".equals(v) || "1.6".equals(v)) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.6");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                    }
                }
            } else if ("1.7".equals(v2)) {
                if (this.didSpecifySource) {
                    v = this.options.get("org.eclipse.jdt.core.compiler.source");
                    if ("1.3".equals(v) || "1.4".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                        }
                    } else if ("1.5".equals(v) || "1.6".equals(v)) {
                        if (!this.didSpecifyTarget) {
                            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                        }
                    } else if ("1.7".equals(v) && !this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                    }
                } else {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.7");
                    if (!this.didSpecifyTarget) {
                        this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                    }
                }
            }
        } else if (this.didSpecifySource) {
            v2 = this.options.get("org.eclipse.jdt.core.compiler.source");
            if ("1.4".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                }
            } else if ("1.5".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            } else if ("1.6".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
                }
            } else if ("1.7".equals(v2)) {
                if (!bl) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
                }
                if (!this.didSpecifyTarget) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                }
            }
        }
        v2 = this.options.get("org.eclipse.jdt.core.compiler.source");
        v = this.options.get("org.eclipse.jdt.core.compiler.compliance");
        if (v2.equals("1.7") && CompilerOptions.versionToJdkLevel(v) < 0x330000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.7"));
        }
        if (v2.equals("1.6") && CompilerOptions.versionToJdkLevel(v) < 0x320000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.6"));
        }
        if (v2.equals("1.5") && CompilerOptions.versionToJdkLevel(v) < 0x310000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.5"));
        }
        if (v2.equals("1.4") && CompilerOptions.versionToJdkLevel(v) < 0x300000L) {
            throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.4"));
        }
        if (this.didSpecifyTarget) {
            Object v3 = this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            if ("jsr14".equals(v3)) {
                if (CompilerOptions.versionToJdkLevel(v2) < 0x310000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForGenericSource", (String)v3, (String)v2));
                }
            } else if ("cldc1.1".equals(v3)) {
                if (this.didSpecifySource && CompilerOptions.versionToJdkLevel(v2) >= 0x300000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleSourceForCldcTarget", (String)v3, (String)v2));
                }
                if (CompilerOptions.versionToJdkLevel(v) >= 0x310000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForCldcTarget", (String)v3, (String)v2));
                }
            } else {
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x330000L && CompilerOptions.versionToJdkLevel(v3) < 0x330000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.7"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x320000L && CompilerOptions.versionToJdkLevel(v3) < 0x320000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.6"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x310000L && CompilerOptions.versionToJdkLevel(v3) < 0x310000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.5"));
                }
                if (CompilerOptions.versionToJdkLevel(v2) >= 0x300000L && CompilerOptions.versionToJdkLevel(v3) < 0x300000L) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleTargetForSource", (String)v3, "1.4"));
                }
                if (CompilerOptions.versionToJdkLevel(v) < CompilerOptions.versionToJdkLevel(v3)) {
                    throw new IllegalArgumentException(this.bind("configure.incompatibleComplianceForTarget", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), (String)v3));
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ResourceBundleFactory {
        private static HashMap Cache = new HashMap();

        public static synchronized ResourceBundle getBundle(Locale locale) {
            ResourceBundle resourceBundle = (ResourceBundle)Cache.get(locale);
            if (resourceBundle == null) {
                resourceBundle = ResourceBundle.getBundle(Main.bundleName, locale);
                Cache.put(locale, resourceBundle);
            }
            return resourceBundle;
        }
    }

    public static class Logger {
        private PrintWriter err;
        private PrintWriter log;
        private Main main;
        private PrintWriter out;
        private HashMap parameters;
        int tagBits;
        private static final String CLASS = "class";
        private static final String CLASS_FILE = "classfile";
        private static final String CLASSPATH = "classpath";
        private static final String CLASSPATH_FILE = "FILE";
        private static final String CLASSPATH_FOLDER = "FOLDER";
        private static final String CLASSPATH_ID = "id";
        private static final String CLASSPATH_JAR = "JAR";
        private static final String CLASSPATHS = "classpaths";
        private static final String COMMAND_LINE_ARGUMENT = "argument";
        private static final String COMMAND_LINE_ARGUMENTS = "command_line";
        private static final String COMPILER = "compiler";
        private static final String COMPILER_COPYRIGHT = "copyright";
        private static final String COMPILER_NAME = "name";
        private static final String COMPILER_VERSION = "version";
        public static final int EMACS = 2;
        private static final String ERROR = "ERROR";
        private static final String ERROR_TAG = "error";
        private static final String WARNING_TAG = "warning";
        private static final String EXCEPTION = "exception";
        private static final String EXTRA_PROBLEM_TAG = "extra_problem";
        private static final String EXTRA_PROBLEMS = "extra_problems";
        private static final HashtableOfInt FIELD_TABLE = new HashtableOfInt();
        private static final String KEY = "key";
        private static final String MESSAGE = "message";
        private static final String NUMBER_OF_CLASSFILES = "number_of_classfiles";
        private static final String NUMBER_OF_ERRORS = "errors";
        private static final String NUMBER_OF_LINES = "number_of_lines";
        private static final String NUMBER_OF_PROBLEMS = "problems";
        private static final String NUMBER_OF_TASKS = "tasks";
        private static final String NUMBER_OF_WARNINGS = "warnings";
        private static final String OPTION = "option";
        private static final String OPTIONS = "options";
        private static final String OUTPUT = "output";
        private static final String PACKAGE = "package";
        private static final String PATH = "path";
        private static final String PROBLEM_ARGUMENT = "argument";
        private static final String PROBLEM_ARGUMENT_VALUE = "value";
        private static final String PROBLEM_ARGUMENTS = "arguments";
        private static final String PROBLEM_CATEGORY_ID = "categoryID";
        private static final String ID = "id";
        private static final String PROBLEM_ID = "problemID";
        private static final String PROBLEM_LINE = "line";
        private static final String PROBLEM_OPTION_KEY = "optionKey";
        private static final String PROBLEM_MESSAGE = "message";
        private static final String PROBLEM_SEVERITY = "severity";
        private static final String PROBLEM_SOURCE_END = "charEnd";
        private static final String PROBLEM_SOURCE_START = "charStart";
        private static final String PROBLEM_SUMMARY = "problem_summary";
        private static final String PROBLEM_TAG = "problem";
        private static final String PROBLEMS = "problems";
        private static final String SOURCE = "source";
        private static final String SOURCE_CONTEXT = "source_context";
        private static final String SOURCE_END = "sourceEnd";
        private static final String SOURCE_START = "sourceStart";
        private static final String SOURCES = "sources";
        private static final String STATS = "stats";
        private static final String TASK = "task";
        private static final String TASKS = "tasks";
        private static final String TIME = "time";
        private static final String VALUE = "value";
        private static final String WARNING = "WARNING";
        public static final int XML = 1;
        private static final String XML_DTD_DECLARATION = "<!DOCTYPE compiler PUBLIC \"-//Eclipse.org//DTD Eclipse JDT 3.2.004 Compiler//EN\" \"http://www.eclipse.org/jdt/core/compiler_32_004.dtd\">";

        public Logger(Main main, PrintWriter printWriter, PrintWriter printWriter2) {
            this.out = printWriter;
            this.err = printWriter2;
            this.parameters = new HashMap();
            this.main = main;
        }

        public String buildFileName(String string, String string2) {
            char c = File.separatorChar;
            String string3 = File.separator;
            string = string.replace('/', c);
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!string.endsWith(string3)) {
                stringBuffer.append(string3);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            String string4 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(string4).append(string3);
                string4 = stringTokenizer.nextToken();
            }
            return stringBuffer.append(string4).toString();
        }

        public void close() {
            if (this.log != null) {
                if ((this.tagBits & 1) != 0) {
                    this.endTag(COMPILER);
                    this.flush();
                }
                this.log.close();
            }
        }

        public void compiling() {
            this.printlnOut(this.main.bind("progress.compiling"));
        }

        private void endLoggingExtraProblems() {
            this.endTag(EXTRA_PROBLEMS);
        }

        private void endLoggingProblems() {
            this.endTag("problems");
        }

        public void endLoggingSource() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCE);
            }
        }

        public void endLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.endTag(SOURCES);
            }
        }

        public void endLoggingTasks() {
            if ((this.tagBits & 1) != 0) {
                this.endTag("tasks");
            }
        }

        private void endTag(String string) {
            if (this.log != null) {
                ((GenericXMLWriter)this.log).endTag(string, true, true);
            }
        }

        private String errorReportSource(CategorizedProblem categorizedProblem, char[] cArray, int n) {
            int n2;
            int n3;
            char c;
            int n4;
            int n5;
            int n6 = categorizedProblem.getSourceStart();
            int n7 = categorizedProblem.getSourceEnd();
            if (cArray == null && categorizedProblem.getOriginatingFileName() != null) {
                try {
                    cArray = Util.getFileCharContent(new File(new String(categorizedProblem.getOriginatingFileName())), null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (n6 > n7 || n6 < 0 && n7 < 0 || cArray == null || (n5 = cArray.length) == 0) {
                return Messages.problem_noSourceInformation;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if ((n & 2) == 0) {
                stringBuffer.append(' ').append(Messages.bind(Messages.problem_atLine, String.valueOf(categorizedProblem.getSourceLineNumber())));
                stringBuffer.append(Util.LINE_SEPARATOR);
            }
            stringBuffer.append('\t');
            int n8 = n4 = n6 >= n5 ? n5 - 1 : n6;
            while (n4 > 0 && (c = cArray[n4 - 1]) != '\n' && c != '\r') {
                --n4;
            }
            int n9 = n3 = n7 >= n5 ? n5 - 1 : n7;
            while (n3 + 1 < n5 && (c = cArray[n3 + 1]) != '\r' && c != '\n') {
                ++n3;
            }
            while ((c = cArray[n4]) == ' ' || c == '\t') {
                ++n4;
            }
            stringBuffer.append(cArray, n4, n3 - n4 + 1);
            stringBuffer.append(Util.LINE_SEPARATOR).append("\t");
            for (n2 = n4; n2 < n6; ++n2) {
                stringBuffer.append(cArray[n2] == '\t' ? (char)'\t' : ' ');
            }
            for (n2 = n6; n2 <= (n7 >= n5 ? n5 - 1 : n7); ++n2) {
                stringBuffer.append('^');
            }
            return stringBuffer.toString();
        }

        private void extractContext(CategorizedProblem categorizedProblem, char[] cArray) {
            int n;
            char c;
            int n2;
            int n3;
            int n4 = categorizedProblem.getSourceStart();
            int n5 = categorizedProblem.getSourceEnd();
            if (cArray == null && categorizedProblem.getOriginatingFileName() != null) {
                try {
                    cArray = Util.getFileCharContent(new File(new String(categorizedProblem.getOriginatingFileName())), null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (n4 > n5 || n4 < 0 && n5 < 0 || cArray == null || (n3 = cArray.length) <= 0 || n5 > n3) {
                this.parameters.put("value", Messages.problem_noSourceInformation);
                this.parameters.put(SOURCE_START, "-1");
                this.parameters.put(SOURCE_END, "-1");
                this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
                return;
            }
            int n6 = n2 = n4 >= n3 ? n3 - 1 : n4;
            while (n2 > 0 && (c = cArray[n2 - 1]) != '\n' && c != '\r') {
                --n2;
            }
            int n7 = n = n5 >= n3 ? n3 - 1 : n5;
            while (n + 1 < n3 && (c = cArray[n + 1]) != '\r' && c != '\n') {
                ++n;
            }
            while ((c = cArray[n2]) == ' ' || c == '\t') {
                ++n2;
            }
            while ((c = cArray[n]) == ' ' || c == '\t') {
                --n;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray, n2, n - n2 + 1);
            this.parameters.put("value", String.valueOf(stringBuffer));
            this.parameters.put(SOURCE_START, Integer.toString(n4 - n2));
            this.parameters.put(SOURCE_END, Integer.toString(n5 - n2));
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
        }

        public void flush() {
            this.out.flush();
            this.err.flush();
            if (this.log != null) {
                this.log.flush();
            }
        }

        private String getFieldName(int n) {
            int n2 = n & 0xFFFFFF;
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
            }
            return (String)FIELD_TABLE.get(n2);
        }

        private String getProblemOptionKey(int n) {
            int n2 = ProblemReporter.getIrritant(n);
            return CompilerOptions.optionKeyFromIrritant(n2);
        }

        public void logAverage() {
            Arrays.sort(this.main.compilerStats);
            long l = this.main.compilerStats[0].lineCount;
            int n = this.main.maxRepetition;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            int n2 = n - 1;
            for (int i = 1; i < n2; ++i) {
                CompilerStats compilerStats = this.main.compilerStats[i];
                l2 += compilerStats.elapsedTime();
                l3 += compilerStats.parseTime;
                l4 += compilerStats.resolveTime;
                l5 += compilerStats.analyzeTime;
                l6 += compilerStats.generateTime;
            }
            long l7 = l2 / (long)(n - 2);
            long l8 = l3 / (long)(n - 2);
            long l9 = l4 / (long)(n - 2);
            long l10 = l5 / (long)(n - 2);
            long l11 = l6 / (long)(n - 2);
            this.printlnOut(this.main.bind("compile.averageTime", new String[]{String.valueOf(l), String.valueOf(l7), String.valueOf((double)((int)((double)l * 10000.0 / (double)l7)) / 10.0)}));
            if ((this.main.timing & 2) != 0) {
                this.printlnOut(this.main.bind("compile.detailedTime", new String[]{String.valueOf(l8), String.valueOf((double)((int)((double)l8 * 1000.0 / (double)l7)) / 10.0), String.valueOf(l9), String.valueOf((double)((int)((double)l9 * 1000.0 / (double)l7)) / 10.0), String.valueOf(l10), String.valueOf((double)((int)((double)l10 * 1000.0 / (double)l7)) / 10.0), String.valueOf(l11), String.valueOf((double)((int)((double)l11 * 1000.0 / (double)l7)) / 10.0)}));
            }
        }

        public void logClassFile(boolean bl, String string, String string2) {
            if ((this.tagBits & 1) != 0) {
                String string3 = null;
                if (bl) {
                    string3 = this.buildFileName(string, string2);
                } else {
                    char c = File.separatorChar;
                    String string4 = File.separator;
                    string = string.replace('/', c);
                    int n = string2.lastIndexOf(c);
                    if (n == -1) {
                        string3 = string.endsWith(string4) ? string + string2 : string + string4 + string2;
                    } else {
                        int n2 = string2.length();
                        string3 = string.endsWith(string4) ? string + string2.substring(n + 1, n2) : string + string4 + string2.substring(n + 1, n2);
                    }
                }
                File file = new File(string3);
                try {
                    this.parameters.put(PATH, file.getCanonicalPath());
                    this.printTag(CLASS_FILE, this.parameters, true, true);
                }
                catch (IOException iOException) {
                    this.logNoClassFileCreated(string, string2, iOException);
                }
            }
        }

        public void logClasspath(FileSystem.Classpath[] classpathArray) {
            int n;
            if (classpathArray == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (n = classpathArray.length) != 0) {
                this.printTag(CLASSPATHS, null, true, false);
                for (int i = 0; i < n; ++i) {
                    String string = classpathArray[i].getPath();
                    this.parameters.put(PATH, string);
                    File file = new File(string);
                    String string2 = null;
                    if (file.isFile()) {
                        string2 = Util.isPotentialZipArchive(string) ? CLASSPATH_JAR : CLASSPATH_FILE;
                    } else if (file.isDirectory()) {
                        string2 = CLASSPATH_FOLDER;
                    }
                    if (string2 == null) continue;
                    this.parameters.put("id", string2);
                    this.printTag(CLASSPATH, this.parameters, true, true);
                }
                this.endTag(CLASSPATHS);
            }
        }

        public void logCommandLineArguments(String[] stringArray) {
            int n;
            if (stringArray == null) {
                return;
            }
            if ((this.tagBits & 1) != 0 && (n = stringArray.length) != 0) {
                this.printTag(COMMAND_LINE_ARGUMENTS, null, true, false);
                for (int i = 0; i < n; ++i) {
                    this.parameters.put("value", stringArray[i]);
                    this.printTag("argument", this.parameters, true, true);
                }
                this.endTag(COMMAND_LINE_ARGUMENTS);
            }
        }

        public void logException(Exception exception) {
            Object object;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            String string = stringWriter.toString();
            if ((this.tagBits & 1) != 0) {
                object = new LineNumberReader(new StringReader(string));
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = exception.getMessage();
                if (string2 != null) {
                    stringBuffer.append(string2).append(Util.LINE_SEPARATOR);
                }
                try {
                    String string3;
                    while ((string3 = ((LineNumberReader)object).readLine()) != null && n < 4) {
                        stringBuffer.append(string3).append(Util.LINE_SEPARATOR);
                        ++n;
                    }
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                string2 = stringBuffer.toString();
                this.parameters.put("message", string2);
                this.parameters.put(CLASS, exception.getClass());
                this.printTag(EXCEPTION, this.parameters, true, true);
            }
            if ((object = exception.getMessage()) == null) {
                this.printlnErr(string);
            } else {
                this.printlnErr((String)object);
            }
        }

        private void logExtraProblem(CategorizedProblem categorizedProblem, int n, int n2) {
            char[] cArray = categorizedProblem.getOriginatingFileName();
            if (cArray == null) {
                if (categorizedProblem.isError()) {
                    this.printErr(this.main.bind("requestor.extraerror", Integer.toString(n2)));
                } else {
                    this.printErr(this.main.bind("requestor.extrawarning", Integer.toString(n2)));
                }
                this.printErr(" ");
                this.printlnErr(categorizedProblem.getMessage());
            } else {
                String string = new String(cArray);
                if ((this.tagBits & 2) != 0) {
                    String string2 = string + ":" + categorizedProblem.getSourceLineNumber() + ": " + (categorizedProblem.isError() ? this.main.bind("output.emacs.error") : this.main.bind("output.emacs.warning")) + ": " + categorizedProblem.getMessage();
                    this.printlnErr(string2);
                    String string3 = this.errorReportSource(categorizedProblem, null, this.tagBits);
                    this.printlnErr(string3);
                } else {
                    if (n == 0) {
                        this.printlnErr("----------");
                    }
                    this.printErr(categorizedProblem.isError() ? this.main.bind("requestor.error", Integer.toString(n2), new String(string)) : this.main.bind("requestor.warning", Integer.toString(n2), new String(string)));
                    String string4 = this.errorReportSource(categorizedProblem, null, 0);
                    this.printlnErr(string4);
                    this.printlnErr(categorizedProblem.getMessage());
                    this.printlnErr("----------");
                }
            }
        }

        public void loggingExtraProblems(Main main) {
            ArrayList arrayList = main.extraProblems;
            int n = arrayList.size();
            int n2 = 0;
            if (n != 0) {
                CategorizedProblem categorizedProblem;
                int n3;
                int n4 = 0;
                int n5 = 0;
                for (n3 = 0; n3 < n; ++n3) {
                    categorizedProblem = (CategorizedProblem)arrayList.get(n3);
                    if (categorizedProblem == null) continue;
                    ++main.globalProblemsCount;
                    this.logExtraProblem(categorizedProblem, n2, main.globalProblemsCount);
                    ++n2;
                    if (categorizedProblem.isError()) {
                        ++n4;
                        ++main.globalErrorsCount;
                        continue;
                    }
                    if (!categorizedProblem.isWarning()) continue;
                    ++main.globalWarningsCount;
                    ++n5;
                }
                if ((this.tagBits & 1) != 0 && n4 + n5 != 0) {
                    this.startLoggingExtraProblems(n);
                    for (n3 = 0; n3 < n; ++n3) {
                        categorizedProblem = (CategorizedProblem)arrayList.get(n3);
                        if (categorizedProblem == null || categorizedProblem.getID() == 536871362) continue;
                        this.logXmlExtraProblem(categorizedProblem, n2, main.globalProblemsCount);
                    }
                    this.endLoggingExtraProblems();
                }
            }
        }

        public void logIncorrectVMVersionForAnnotationProcessing() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.incorrectVMVersionforAPT"));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.incorrectVMVersionforAPT"));
        }

        public void logNoClassFileCreated(String string, String string2, IOException iOException) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("output.noClassFileCreated", new String[]{string, string2, iOException.getMessage()}));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("output.noClassFileCreated", new String[]{string, string2, iOException.getMessage()}));
        }

        public void logNumberOfClassFilesGenerated(int n) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("value", new Integer(n));
                this.printTag(NUMBER_OF_CLASSFILES, this.parameters, true, true);
            }
            if (n == 1) {
                this.printlnOut(this.main.bind("compile.oneClassFileGenerated"));
            } else {
                this.printlnOut(this.main.bind("compile.severalClassFilesGenerated", String.valueOf(n)));
            }
        }

        public void logOptions(Map map) {
            if ((this.tagBits & 1) != 0) {
                this.printTag(OPTIONS, null, true, false);
                Set set = map.entrySet();
                Object[] objectArray = set.toArray();
                Arrays.sort(objectArray, new Comparator(){

                    public int compare(Object object, Object object2) {
                        Map.Entry entry = (Map.Entry)object;
                        Map.Entry entry2 = (Map.Entry)object2;
                        return ((String)entry.getKey()).compareTo((String)entry2.getKey());
                    }
                });
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Map.Entry entry = (Map.Entry)objectArray[i];
                    String string = (String)entry.getKey();
                    this.parameters.put(KEY, string);
                    this.parameters.put("value", entry.getValue());
                    this.printTag(OPTION, this.parameters, true, true);
                }
                this.endTag(OPTIONS);
            }
        }

        public void logPendingError(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", string);
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(string);
        }

        public void logWarning(String string) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", string);
                this.printTag(WARNING_TAG, this.parameters, true, true);
            }
            this.printlnOut(string);
        }

        private void logProblem(CategorizedProblem categorizedProblem, int n, int n2, char[] cArray) {
            if ((this.tagBits & 2) != 0) {
                String string = new String(categorizedProblem.getOriginatingFileName()) + ":" + categorizedProblem.getSourceLineNumber() + ": " + (categorizedProblem.isError() ? this.main.bind("output.emacs.error") : this.main.bind("output.emacs.warning")) + ": " + categorizedProblem.getMessage();
                this.printlnErr(string);
                String string2 = this.errorReportSource(categorizedProblem, cArray, this.tagBits);
                if (string2.length() != 0) {
                    this.printlnErr(string2);
                }
            } else {
                if (n == 0) {
                    this.printlnErr("----------");
                }
                this.printErr(categorizedProblem.isError() ? this.main.bind("requestor.error", Integer.toString(n2), new String(categorizedProblem.getOriginatingFileName())) : this.main.bind("requestor.warning", Integer.toString(n2), new String(categorizedProblem.getOriginatingFileName())));
                try {
                    String string = this.errorReportSource(categorizedProblem, cArray, 0);
                    this.printlnErr(string);
                    this.printlnErr(categorizedProblem.getMessage());
                }
                catch (Exception exception) {
                    this.printlnErr(this.main.bind("requestor.notRetrieveErrorMessage", categorizedProblem.toString()));
                }
                this.printlnErr("----------");
            }
        }

        public int logProblems(CategorizedProblem[] categorizedProblemArray, char[] cArray, Main main) {
            int n = categorizedProblemArray.length;
            int n2 = 0;
            int n3 = 0;
            if (n != 0) {
                CategorizedProblem categorizedProblem;
                int n4;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                for (n4 = 0; n4 < n; ++n4) {
                    categorizedProblem = categorizedProblemArray[n4];
                    if (categorizedProblem == null) continue;
                    ++main.globalProblemsCount;
                    this.logProblem(categorizedProblem, n3, main.globalProblemsCount, cArray);
                    ++n3;
                    if (categorizedProblem.isError()) {
                        ++n2;
                        ++n5;
                        ++main.globalErrorsCount;
                        continue;
                    }
                    if (categorizedProblem.getID() == 536871362) {
                        ++main.globalTasksCount;
                        ++n7;
                        continue;
                    }
                    ++main.globalWarningsCount;
                    ++n6;
                }
                if ((this.tagBits & 1) != 0) {
                    if (n5 + n6 != 0) {
                        this.startLoggingProblems(n5, n6);
                        for (n4 = 0; n4 < n; ++n4) {
                            categorizedProblem = categorizedProblemArray[n4];
                            if (categorizedProblem == null || categorizedProblem.getID() == 536871362) continue;
                            this.logXmlProblem(categorizedProblem, cArray);
                        }
                        this.endLoggingProblems();
                    }
                    if (n7 != 0) {
                        this.startLoggingTasks(n7);
                        for (n4 = 0; n4 < n; ++n4) {
                            categorizedProblem = categorizedProblemArray[n4];
                            if (categorizedProblem == null || categorizedProblem.getID() != 536871362) continue;
                            this.logXmlTask(categorizedProblem, cArray);
                        }
                        this.endLoggingTasks();
                    }
                }
            }
            return n2;
        }

        public void logProblemsSummary(int n, int n2, int n3, int n4) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("problems", new Integer(n));
                this.parameters.put(NUMBER_OF_ERRORS, new Integer(n2));
                this.parameters.put(NUMBER_OF_WARNINGS, new Integer(n3));
                this.parameters.put("tasks", new Integer(n4));
                this.printTag(PROBLEM_SUMMARY, this.parameters, true, true);
            }
            if (n == 1) {
                String string = null;
                string = n2 == 1 ? this.main.bind("compile.oneError") : this.main.bind("compile.oneWarning");
                this.printErr(this.main.bind("compile.oneProblem", string));
            } else {
                int n5;
                String string = null;
                String string2 = null;
                if (n2 > 0) {
                    string = n2 == 1 ? this.main.bind("compile.oneError") : this.main.bind("compile.severalErrors", String.valueOf(n2));
                }
                if ((n5 = n3 + n4) > 0) {
                    string2 = n5 == 1 ? this.main.bind("compile.oneWarning") : this.main.bind("compile.severalWarnings", String.valueOf(n5));
                }
                if (string == null || string2 == null) {
                    if (string == null) {
                        this.printErr(this.main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n), string2));
                    } else {
                        this.printErr(this.main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n), string));
                    }
                } else {
                    this.printErr(this.main.bind("compile.severalProblemsErrorsAndWarnings", new String[]{String.valueOf(n), string, string2}));
                }
            }
            if ((this.tagBits & 2) != 0) {
                this.printlnErr();
            }
        }

        public void logProgress() {
            this.printOut('.');
        }

        public void logRepetition(int n, int n2) {
            this.printlnOut(this.main.bind("compile.repetition", String.valueOf(n + 1), String.valueOf(n2)));
        }

        public void logTiming(CompilerStats compilerStats) {
            long l = compilerStats.elapsedTime();
            long l2 = compilerStats.lineCount;
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("value", new Long(l));
                this.printTag(TIME, this.parameters, true, true);
                this.parameters.put("value", new Long(l2));
                this.printTag(NUMBER_OF_LINES, this.parameters, true, true);
            }
            if (l2 != 0L) {
                this.printlnOut(this.main.bind("compile.instantTime", new String[]{String.valueOf(l2), String.valueOf(l), String.valueOf((double)((int)((double)l2 * 10000.0 / (double)l)) / 10.0)}));
            } else {
                this.printlnOut(this.main.bind("compile.totalTime", new String[]{String.valueOf(l)}));
            }
            if ((this.main.timing & 2) != 0) {
                this.printlnOut(this.main.bind("compile.detailedTime", new String[]{String.valueOf(compilerStats.parseTime), String.valueOf((double)((int)((double)compilerStats.parseTime * 1000.0 / (double)l)) / 10.0), String.valueOf(compilerStats.resolveTime), String.valueOf((double)((int)((double)compilerStats.resolveTime * 1000.0 / (double)l)) / 10.0), String.valueOf(compilerStats.analyzeTime), String.valueOf((double)((int)((double)compilerStats.analyzeTime * 1000.0 / (double)l)) / 10.0), String.valueOf(compilerStats.generateTime), String.valueOf((double)((int)((double)compilerStats.generateTime * 1000.0 / (double)l)) / 10.0)}));
            }
        }

        public void logUsage(String string) {
            this.printlnOut(string);
        }

        public void logVersion(boolean bl) {
            if (this.log != null && (this.tagBits & 1) == 0) {
                String string = this.main.bind("misc.version", new String[]{this.main.bind("compiler.name"), this.main.bind("compiler.version"), this.main.bind("compiler.copyright")});
                this.log.println("# " + string);
                if (bl) {
                    this.out.println(string);
                    this.out.flush();
                }
            } else if (bl) {
                String string = this.main.bind("misc.version", new String[]{this.main.bind("compiler.name"), this.main.bind("compiler.version"), this.main.bind("compiler.copyright")});
                this.out.println(string);
                this.out.flush();
            }
        }

        public void logWrongJDK() {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("message", this.main.bind("configure.requiresJDK1.2orAbove"));
                this.printTag(ERROR, this.parameters, true, true);
            }
            this.printlnErr(this.main.bind("configure.requiresJDK1.2orAbove"));
        }

        private void logXmlExtraProblem(CategorizedProblem categorizedProblem, int n, int n2) {
            int n3 = categorizedProblem.getSourceStart();
            int n4 = categorizedProblem.getSourceEnd();
            boolean bl = categorizedProblem.isError();
            this.parameters.put(PROBLEM_SEVERITY, bl ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(n3));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(n4));
            this.printTag(EXTRA_PROBLEM_TAG, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, null);
            this.endTag(EXTRA_PROBLEM_TAG);
        }

        private void logXmlProblem(CategorizedProblem categorizedProblem, char[] cArray) {
            int n = categorizedProblem.getSourceStart();
            int n2 = categorizedProblem.getSourceEnd();
            int n3 = categorizedProblem.getID();
            this.parameters.put("id", this.getFieldName(n3));
            this.parameters.put(PROBLEM_ID, new Integer(n3));
            boolean bl = categorizedProblem.isError();
            int n4 = bl ? 1 : 0;
            this.parameters.put(PROBLEM_SEVERITY, bl ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(n));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(n2));
            String string = this.getProblemOptionKey(n3);
            if (string != null) {
                this.parameters.put(PROBLEM_OPTION_KEY, string);
            }
            int n5 = ProblemReporter.getProblemCategory(n4, n3);
            this.parameters.put(PROBLEM_CATEGORY_ID, new Integer(n5));
            this.printTag(PROBLEM_TAG, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, cArray);
            String[] stringArray = categorizedProblem.getArguments();
            int n6 = stringArray.length;
            if (n6 != 0) {
                this.printTag(PROBLEM_ARGUMENTS, null, true, false);
                for (int i = 0; i < n6; ++i) {
                    this.parameters.put("value", stringArray[i]);
                    this.printTag("argument", this.parameters, true, true);
                }
                this.endTag(PROBLEM_ARGUMENTS);
            }
            this.endTag(PROBLEM_TAG);
        }

        private void logXmlTask(CategorizedProblem categorizedProblem, char[] cArray) {
            this.parameters.put(PROBLEM_LINE, new Integer(categorizedProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(categorizedProblem.getSourceStart()));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(categorizedProblem.getSourceEnd()));
            String string = this.getProblemOptionKey(categorizedProblem.getID());
            if (string != null) {
                this.parameters.put(PROBLEM_OPTION_KEY, string);
            }
            this.printTag(TASK, this.parameters, true, false);
            this.parameters.put("value", categorizedProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.extractContext(categorizedProblem, cArray);
            this.endTag(TASK);
        }

        private void printErr(String string) {
            this.err.print(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.print(string);
            }
        }

        private void printlnErr() {
            this.err.println();
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println();
            }
        }

        private void printlnErr(String string) {
            this.err.println(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(string);
            }
        }

        private void printlnOut(String string) {
            this.out.println(string);
            if ((this.tagBits & 1) == 0 && this.log != null) {
                this.log.println(string);
            }
        }

        public void printNewLine() {
            this.out.println();
        }

        private void printOut(char c) {
            this.out.print(c);
        }

        public void printStats() {
            boolean bl;
            boolean bl2 = bl = (this.main.timing & 1) != 0;
            if ((this.tagBits & 1) != 0) {
                this.printTag(STATS, null, true, false);
            }
            if (bl) {
                CompilerStats compilerStats = this.main.batchCompiler.stats;
                compilerStats.startTime = this.main.startTime;
                compilerStats.endTime = System.currentTimeMillis();
                this.logTiming(compilerStats);
            }
            if (this.main.globalProblemsCount > 0) {
                this.logProblemsSummary(this.main.globalProblemsCount, this.main.globalErrorsCount, this.main.globalWarningsCount, this.main.globalTasksCount);
            }
            if (this.main.exportedClassFilesCounter != 0 && (this.main.showProgress || bl || this.main.verbose)) {
                this.logNumberOfClassFilesGenerated(this.main.exportedClassFilesCounter);
            }
            if ((this.tagBits & 1) != 0) {
                this.endTag(STATS);
            }
        }

        private void printTag(String string, HashMap hashMap, boolean bl, boolean bl2) {
            if (this.log != null) {
                ((GenericXMLWriter)this.log).printTag(string, this.parameters, true, bl, bl2);
            }
            this.parameters.clear();
        }

        public void setEmacs() {
            this.tagBits |= 2;
        }

        public void setLog(String string) {
            Date date = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1, Locale.getDefault());
            try {
                int n = string.lastIndexOf(46);
                if (n != -1) {
                    if (string.substring(n).toLowerCase().equals(".xml")) {
                        this.log = new GenericXMLWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, false), "UTF-8"), Util.LINE_SEPARATOR, true);
                        this.tagBits |= 1;
                        this.log.println("<!-- " + dateFormat.format(date) + " -->");
                        this.log.println(XML_DTD_DECLARATION);
                        this.parameters.put(COMPILER_NAME, this.main.bind("compiler.name"));
                        this.parameters.put(COMPILER_VERSION, this.main.bind("compiler.version"));
                        this.parameters.put(COMPILER_COPYRIGHT, this.main.bind("compiler.copyright"));
                        this.printTag(COMPILER, this.parameters, true, false);
                    } else {
                        this.log = new PrintWriter(new FileOutputStream(string, false));
                        this.log.println("# " + dateFormat.format(date));
                    }
                } else {
                    this.log = new PrintWriter(new FileOutputStream(string, false));
                    this.log.println("# " + dateFormat.format(date));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException(this.main.bind("configure.cannotOpenLog", string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException(this.main.bind("configure.cannotOpenLogInvalidEncoding", string));
            }
        }

        private void startLoggingExtraProblems(int n) {
            this.parameters.put("problems", new Integer(n));
            this.printTag(EXTRA_PROBLEMS, this.parameters, true, false);
        }

        private void startLoggingProblems(int n, int n2) {
            this.parameters.put("problems", new Integer(n + n2));
            this.parameters.put(NUMBER_OF_ERRORS, new Integer(n));
            this.parameters.put(NUMBER_OF_WARNINGS, new Integer(n2));
            this.printTag("problems", this.parameters, true, false);
        }

        public void startLoggingSource(CompilationResult compilationResult) {
            if ((this.tagBits & 1) != 0) {
                ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
                if (iCompilationUnit != null) {
                    char[][] cArray;
                    char[] cArray2 = iCompilationUnit.getFileName();
                    File file = new File(new String(cArray2));
                    if (cArray2 != null) {
                        this.parameters.put(PATH, file.getAbsolutePath());
                    }
                    if ((cArray = compilationResult.packageName) != null) {
                        this.parameters.put(PACKAGE, new String(CharOperation.concatWith(cArray, File.separatorChar)));
                    }
                    CompilationUnit compilationUnit = (CompilationUnit)iCompilationUnit;
                    String string = compilationUnit.destinationPath;
                    if (string == null) {
                        string = this.main.destinationPath;
                    }
                    if (string != null && string != Main.NONE) {
                        if (File.separatorChar == '/') {
                            this.parameters.put(OUTPUT, string);
                        } else {
                            this.parameters.put(OUTPUT, string.replace('/', File.separatorChar));
                        }
                    }
                }
                this.printTag(SOURCE, this.parameters, true, false);
            }
        }

        public void startLoggingSources() {
            if ((this.tagBits & 1) != 0) {
                this.printTag(SOURCES, null, true, false);
            }
        }

        public void startLoggingTasks(int n) {
            if ((this.tagBits & 1) != 0) {
                this.parameters.put("tasks", new Integer(n));
                this.printTag("tasks", this.parameters, true, false);
            }
        }

        static {
            try {
                Class clazz = class$org$eclipse$jdt$core$compiler$IProblem == null ? (class$org$eclipse$jdt$core$compiler$IProblem = Main.class$("org.eclipse.jdt.core.compiler.IProblem")) : class$org$eclipse$jdt$core$compiler$IProblem;
                Field[] fieldArray = clazz.getFields();
                int n = fieldArray.length;
                for (int i = 0; i < n; ++i) {
                    Field field = fieldArray[i];
                    if (!field.getType().equals(Integer.TYPE)) continue;
                    Integer n2 = (Integer)field.get(null);
                    int n3 = n2 & 0xFFFFFF;
                    if (n3 == 0) {
                        n3 = Integer.MAX_VALUE;
                    }
                    FIELD_TABLE.put(n3, field.getName());
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }
}

