/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public abstract class TypeBinding
extends Binding {
    public int id = Integer.MAX_VALUE;
    public long tagBits = 0L;
    public static final BaseTypeBinding INT = new BaseTypeBinding(10, TypeConstants.INT, new char[]{'I'});
    public static final BaseTypeBinding BYTE = new BaseTypeBinding(3, TypeConstants.BYTE, new char[]{'B'});
    public static final BaseTypeBinding SHORT = new BaseTypeBinding(4, TypeConstants.SHORT, new char[]{'S'});
    public static final BaseTypeBinding CHAR = new BaseTypeBinding(2, TypeConstants.CHAR, new char[]{'C'});
    public static final BaseTypeBinding LONG = new BaseTypeBinding(7, TypeConstants.LONG, new char[]{'J'});
    public static final BaseTypeBinding FLOAT = new BaseTypeBinding(9, TypeConstants.FLOAT, new char[]{'F'});
    public static final BaseTypeBinding DOUBLE = new BaseTypeBinding(8, TypeConstants.DOUBLE, new char[]{'D'});
    public static final BaseTypeBinding BOOLEAN = new BaseTypeBinding(5, TypeConstants.BOOLEAN, new char[]{'Z'});
    public static final BaseTypeBinding NULL = new BaseTypeBinding(12, TypeConstants.NULL, new char[]{'N'});
    public static final BaseTypeBinding VOID = new BaseTypeBinding(6, TypeConstants.VOID, new char[]{'V'});

    public static final TypeBinding wellKnownType(Scope scope, int n) {
        switch (n) {
            case 5: {
                return BOOLEAN;
            }
            case 3: {
                return BYTE;
            }
            case 2: {
                return CHAR;
            }
            case 4: {
                return SHORT;
            }
            case 8: {
                return DOUBLE;
            }
            case 9: {
                return FLOAT;
            }
            case 10: {
                return INT;
            }
            case 7: {
                return LONG;
            }
            case 1: {
                return scope.getJavaLangObject();
            }
            case 11: {
                return scope.getJavaLangString();
            }
        }
        return null;
    }

    public boolean canBeInstantiated() {
        return !this.isBaseType();
    }

    public TypeBinding capture(Scope scope, int n) {
        return this;
    }

    public TypeBinding closestMatch() {
        return this;
    }

    public List collectMissingTypes(List list) {
        return list;
    }

    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, InferenceContext inferenceContext, int n) {
    }

    public abstract char[] constantPoolName();

    public String debugName() {
        return new String(this.readableName());
    }

    public int dimensions() {
        return 0;
    }

    public ReferenceBinding enclosingType() {
        return null;
    }

    public TypeBinding erasure() {
        return this;
    }

    public ReferenceBinding findSuperTypeOriginatingFrom(int n, boolean bl) {
        int n2;
        if (!(this instanceof ReferenceBinding)) {
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this;
        if (referenceBinding.id == n || this.original().id == n) {
            return referenceBinding;
        }
        ReferenceBinding referenceBinding2 = referenceBinding;
        if (bl) {
            while ((referenceBinding2 = referenceBinding2.superclass()) != null) {
                if (referenceBinding2.id == n) {
                    return referenceBinding2;
                }
                if (referenceBinding2.original().id != n) continue;
                return referenceBinding2;
            }
            return null;
        }
        ReferenceBinding[] referenceBindingArray = null;
        int n3 = 0;
        do {
            ReferenceBinding[] referenceBindingArray2;
            if ((referenceBindingArray2 = referenceBinding2.superInterfaces()) == null || referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
            if (referenceBindingArray == null) {
                referenceBindingArray = referenceBindingArray2;
                n3 = referenceBindingArray.length;
                continue;
            }
            int n4 = referenceBindingArray2.length;
            if (n3 + n4 >= referenceBindingArray.length) {
                ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n3 + n4 + 5];
                System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n3);
            }
            block2: for (n2 = 0; n2 < n4; ++n2) {
                ReferenceBinding referenceBinding3 = referenceBindingArray2[n2];
                for (int i = 0; i < n3; ++i) {
                    if (referenceBinding3 == referenceBindingArray[i]) continue block2;
                }
                referenceBindingArray[n3++] = referenceBinding3;
            }
        } while ((referenceBinding2 = referenceBinding2.superclass()) != null);
        for (int i = 0; i < n3; ++i) {
            referenceBinding2 = referenceBindingArray[i];
            if (referenceBinding2.id == n) {
                return referenceBinding2;
            }
            if (referenceBinding2.original().id == n) {
                return referenceBinding2;
            }
            ReferenceBinding[] referenceBindingArray4 = referenceBinding2.superInterfaces();
            if (referenceBindingArray4 == null || referenceBindingArray4 == Binding.NO_SUPERINTERFACES) continue;
            n2 = referenceBindingArray4.length;
            if (n3 + n2 >= referenceBindingArray.length) {
                ReferenceBinding[] referenceBindingArray5 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n3 + n2 + 5];
                System.arraycopy(referenceBindingArray5, 0, referenceBindingArray, 0, n3);
            }
            block5: for (int j = 0; j < n2; ++j) {
                ReferenceBinding referenceBinding4 = referenceBindingArray4[j];
                for (int k = 0; k < n3; ++k) {
                    if (referenceBinding4 == referenceBindingArray[k]) continue block5;
                }
                referenceBindingArray[n3++] = referenceBinding4;
            }
        }
        return null;
    }

    public TypeBinding findSuperTypeOriginatingFrom(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return this;
        }
        if (typeBinding == null) {
            return null;
        }
        switch (this.kind()) {
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)this;
                int n = typeBinding.dimensions();
                if (arrayBinding.dimensions != n) {
                    switch (typeBinding.id) {
                        case 1: 
                        case 36: 
                        case 37: {
                            return typeBinding;
                        }
                    }
                    if (n < arrayBinding.dimensions && typeBinding.leafComponentType().id == 1) {
                        return typeBinding;
                    }
                    return null;
                }
                if (!(arrayBinding.leafComponentType instanceof ReferenceBinding)) {
                    return null;
                }
                TypeBinding typeBinding2 = arrayBinding.leafComponentType.findSuperTypeOriginatingFrom(typeBinding.leafComponentType());
                if (typeBinding2 == null) {
                    return null;
                }
                return arrayBinding.environment().createArrayType(typeBinding2, arrayBinding.dimensions);
            }
            case 4100: {
                ReferenceBinding[] referenceBindingArray;
                ReferenceBinding referenceBinding;
                if (this.isCapture()) {
                    TypeBinding typeBinding3;
                    referenceBinding = (CaptureBinding)this;
                    referenceBindingArray = ((CaptureBinding)referenceBinding).firstBound;
                    if (referenceBindingArray instanceof ArrayBinding && (typeBinding3 = referenceBindingArray.findSuperTypeOriginatingFrom(typeBinding)) != null) {
                        return typeBinding3;
                    }
                }
            }
            case 4: 
            case 260: 
            case 516: 
            case 1028: 
            case 2052: 
            case 8196: {
                int n;
                typeBinding = typeBinding.original();
                if (this == typeBinding) {
                    return this;
                }
                if (this.original() == typeBinding) {
                    return this;
                }
                ReferenceBinding referenceBinding = (ReferenceBinding)this;
                if (!typeBinding.isInterface()) {
                    while ((referenceBinding = referenceBinding.superclass()) != null) {
                        if (referenceBinding == typeBinding) {
                            return referenceBinding;
                        }
                        if (referenceBinding.original() != typeBinding) continue;
                        return referenceBinding;
                    }
                    return null;
                }
                ReferenceBinding[] referenceBindingArray = null;
                int n2 = 0;
                do {
                    ReferenceBinding[] referenceBindingArray2;
                    if ((referenceBindingArray2 = referenceBinding.superInterfaces()) == null || referenceBindingArray2 == Binding.NO_SUPERINTERFACES) continue;
                    if (referenceBindingArray == null) {
                        referenceBindingArray = referenceBindingArray2;
                        n2 = referenceBindingArray.length;
                        continue;
                    }
                    int n3 = referenceBindingArray2.length;
                    if (n2 + n3 >= referenceBindingArray.length) {
                        ReferenceBinding[] referenceBindingArray3 = referenceBindingArray;
                        referenceBindingArray = new ReferenceBinding[n2 + n3 + 5];
                        System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n2);
                    }
                    block10: for (n = 0; n < n3; ++n) {
                        ReferenceBinding referenceBinding2 = referenceBindingArray2[n];
                        for (int i = 0; i < n2; ++i) {
                            if (referenceBinding2 == referenceBindingArray[i]) continue block10;
                        }
                        referenceBindingArray[n2++] = referenceBinding2;
                    }
                } while ((referenceBinding = referenceBinding.superclass()) != null);
                for (int i = 0; i < n2; ++i) {
                    referenceBinding = referenceBindingArray[i];
                    if (referenceBinding == typeBinding) {
                        return referenceBinding;
                    }
                    if (referenceBinding.original() == typeBinding) {
                        return referenceBinding;
                    }
                    ReferenceBinding[] referenceBindingArray4 = referenceBinding.superInterfaces();
                    if (referenceBindingArray4 == null || referenceBindingArray4 == Binding.NO_SUPERINTERFACES) continue;
                    n = referenceBindingArray4.length;
                    if (n2 + n >= referenceBindingArray.length) {
                        ReferenceBinding[] referenceBindingArray5 = referenceBindingArray;
                        referenceBindingArray = new ReferenceBinding[n2 + n + 5];
                        System.arraycopy(referenceBindingArray5, 0, referenceBindingArray, 0, n2);
                    }
                    block13: for (int j = 0; j < n; ++j) {
                        ReferenceBinding referenceBinding3 = referenceBindingArray4[j];
                        for (int k = 0; k < n2; ++k) {
                            if (referenceBinding3 == referenceBindingArray[k]) continue block13;
                        }
                        referenceBindingArray[n2++] = referenceBinding3;
                    }
                }
                break;
            }
        }
        return null;
    }

    public TypeBinding genericCast(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return null;
        }
        TypeBinding typeBinding2 = typeBinding.erasure();
        if (this.erasure().findSuperTypeOriginatingFrom(typeBinding2) != null) {
            return null;
        }
        return typeBinding2;
    }

    public char[] genericTypeSignature() {
        return this.signature();
    }

    public TypeBinding getErasureCompatibleType(TypeBinding typeBinding) {
        switch (this.kind()) {
            case 4100: {
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this;
                if (typeVariableBinding.erasure().findSuperTypeOriginatingFrom(typeBinding) != null) {
                    return this;
                }
                if (typeVariableBinding.superclass != null && typeVariableBinding.superclass.findSuperTypeOriginatingFrom(typeBinding) != null) {
                    return typeVariableBinding.superclass.getErasureCompatibleType(typeBinding);
                }
                int n = typeVariableBinding.superInterfaces.length;
                for (int i = 0; i < n; ++i) {
                    ReferenceBinding referenceBinding = typeVariableBinding.superInterfaces[i];
                    if (referenceBinding.findSuperTypeOriginatingFrom(typeBinding) == null) continue;
                    return referenceBinding.getErasureCompatibleType(typeBinding);
                }
                return this;
            }
            case 8196: {
                WildcardBinding wildcardBinding = (WildcardBinding)this;
                if (wildcardBinding.erasure().findSuperTypeOriginatingFrom(typeBinding) != null) {
                    return this;
                }
                if (wildcardBinding.superclass != null && wildcardBinding.superclass.findSuperTypeOriginatingFrom(typeBinding) != null) {
                    return wildcardBinding.superclass.getErasureCompatibleType(typeBinding);
                }
                int n = wildcardBinding.superInterfaces.length;
                for (int i = 0; i < n; ++i) {
                    ReferenceBinding referenceBinding = wildcardBinding.superInterfaces[i];
                    if (referenceBinding.findSuperTypeOriginatingFrom(typeBinding) == null) continue;
                    return referenceBinding.getErasureCompatibleType(typeBinding);
                }
                return this;
            }
        }
        return this;
    }

    public abstract PackageBinding getPackage();

    void initializeForStaticImports() {
    }

    public boolean isAnnotationType() {
        return false;
    }

    public final boolean isAnonymousType() {
        return (this.tagBits & 0x20L) != 0L;
    }

    public final boolean isArrayType() {
        return (this.tagBits & 1L) != 0L;
    }

    public final boolean isBaseType() {
        return (this.tagBits & 2L) != 0L;
    }

    public boolean isBoundParameterizedType() {
        return (this.tagBits & 0x800000L) != 0L;
    }

    public boolean isCapture() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public abstract boolean isCompatibleWith(TypeBinding var1);

    public boolean isEnum() {
        return false;
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
        }
        return false;
    }

    public boolean isGenericType() {
        return false;
    }

    public final boolean isHierarchyInconsistent() {
        return (this.tagBits & 0x20000L) != 0L;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isIntersectionType() {
        return false;
    }

    public final boolean isLocalType() {
        return (this.tagBits & 0x10L) != 0L;
    }

    public final boolean isMemberType() {
        return (this.tagBits & 8L) != 0L;
    }

    public final boolean isNestedType() {
        return (this.tagBits & 4L) != 0L;
    }

    public final boolean isNumericType() {
        switch (this.id) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public final boolean isParameterizedType() {
        return this.kind() == 260;
    }

    public final boolean isParameterizedTypeWithActualArguments() {
        return this.kind() == 260 && ((ParameterizedTypeBinding)this).arguments != null;
    }

    public boolean isParameterizedWithOwnVariables() {
        if (this.kind() != 260) {
            return false;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this;
        if (parameterizedTypeBinding.arguments == null) {
            return false;
        }
        TypeVariableBinding[] typeVariableBindingArray = this.erasure().typeVariables();
        int n = typeVariableBindingArray.length;
        for (int i = 0; i < n; ++i) {
            if (typeVariableBindingArray[i] == parameterizedTypeBinding.arguments[i]) continue;
            return false;
        }
        ReferenceBinding referenceBinding = parameterizedTypeBinding.enclosingType();
        return referenceBinding == null || !referenceBinding.erasure().isGenericType() || referenceBinding.isParameterizedWithOwnVariables();
    }

    private boolean isProvableDistinctSubType(TypeBinding typeBinding) {
        if (typeBinding.isInterface()) {
            if (this.isInterface()) {
                return false;
            }
            if (this.isArrayType() || this instanceof ReferenceBinding && ((ReferenceBinding)this).isFinal() || this.isTypeVariable() && ((TypeVariableBinding)this).superclass().isFinal()) {
                return !this.isCompatibleWith(typeBinding);
            }
            return false;
        }
        if (this.isInterface() ? typeBinding.isArrayType() || typeBinding instanceof ReferenceBinding && ((ReferenceBinding)typeBinding).isFinal() || typeBinding.isTypeVariable() && ((TypeVariableBinding)typeBinding).superclass().isFinal() : !this.isTypeVariable() && !typeBinding.isTypeVariable()) {
            return !this.isCompatibleWith(typeBinding);
        }
        return false;
    }

    public boolean isProvablyDistinct(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return false;
        }
        if (typeBinding == null) {
            return true;
        }
        switch (this.kind()) {
            case 260: {
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this;
                switch (typeBinding.kind()) {
                    case 260: {
                        int n;
                        TypeBinding[] typeBindingArray;
                        ReferenceBinding referenceBinding;
                        ParameterizedTypeBinding parameterizedTypeBinding2 = (ParameterizedTypeBinding)typeBinding;
                        if (parameterizedTypeBinding.genericType() != parameterizedTypeBinding2.genericType()) {
                            return true;
                        }
                        if (!parameterizedTypeBinding.isStatic() && (referenceBinding = this.enclosingType()) != null) {
                            typeBindingArray = parameterizedTypeBinding2.enclosingType();
                            if (typeBindingArray == null) {
                                return true;
                            }
                            if ((typeBindingArray.tagBits & 0x40000000L) == 0L ? referenceBinding.isProvablyDistinct((TypeBinding)typeBindingArray) : !referenceBinding.isEquivalentTo(parameterizedTypeBinding2.enclosingType())) {
                                return true;
                            }
                        }
                        int n2 = parameterizedTypeBinding.arguments == null ? 0 : parameterizedTypeBinding.arguments.length;
                        typeBindingArray = parameterizedTypeBinding2.arguments;
                        int n3 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
                        if (n != n2) {
                            return true;
                        }
                        for (int i = 0; i < n2; ++i) {
                            if (!parameterizedTypeBinding.arguments[i].isProvablyDistinctTypeArgument(typeBindingArray[i], parameterizedTypeBinding, i)) continue;
                            return true;
                        }
                        return false;
                    }
                    case 2052: {
                        int n;
                        ReferenceBinding referenceBinding;
                        if (parameterizedTypeBinding.genericType() != typeBinding) {
                            return true;
                        }
                        if (!parameterizedTypeBinding.isStatic() && (referenceBinding = this.enclosingType()) != null) {
                            ReferenceBinding referenceBinding2 = typeBinding.enclosingType();
                            if (referenceBinding2 == null) {
                                return true;
                            }
                            if ((referenceBinding2.tagBits & 0x40000000L) == 0L ? referenceBinding != referenceBinding2 : !referenceBinding.isEquivalentTo(typeBinding.enclosingType())) {
                                return true;
                            }
                        }
                        int n4 = parameterizedTypeBinding.arguments == null ? 0 : parameterizedTypeBinding.arguments.length;
                        TypeVariableBinding[] typeVariableBindingArray = typeBinding.typeVariables();
                        int n5 = n = typeVariableBindingArray == null ? 0 : typeVariableBindingArray.length;
                        if (n != n4) {
                            return true;
                        }
                        for (int i = 0; i < n4; ++i) {
                            if (!parameterizedTypeBinding.arguments[i].isProvablyDistinctTypeArgument(typeVariableBindingArray[i], parameterizedTypeBinding, i)) continue;
                            return true;
                        }
                        return false;
                    }
                    case 1028: {
                        return this.erasure() != typeBinding.erasure();
                    }
                    case 4: {
                        return this.erasure() != typeBinding;
                    }
                }
                return true;
            }
            case 1028: {
                switch (typeBinding.kind()) {
                    case 4: 
                    case 260: 
                    case 1028: 
                    case 2052: {
                        return this.erasure() != typeBinding.erasure();
                    }
                }
                return true;
            }
            case 4: {
                switch (typeBinding.kind()) {
                    case 260: 
                    case 1028: {
                        return this != typeBinding.erasure();
                    }
                }
                break;
            }
        }
        return true;
    }

    private boolean isProvablyDistinctTypeArgument(TypeBinding typeBinding, ParameterizedTypeBinding parameterizedTypeBinding, int n) {
        TypeBinding typeBinding2;
        TypeBinding typeBinding3;
        TypeBinding typeBinding4;
        if (this == typeBinding) {
            return false;
        }
        TypeBinding typeBinding5 = null;
        TypeBinding typeBinding6 = null;
        ReferenceBinding referenceBinding = parameterizedTypeBinding.genericType();
        block0 : switch (this.kind()) {
            case 516: {
                typeBinding4 = (WildcardBinding)this;
                switch (((WildcardBinding)typeBinding4).boundKind) {
                    case 1: {
                        typeBinding5 = ((WildcardBinding)typeBinding4).bound;
                        break block0;
                    }
                    case 2: {
                        typeBinding6 = ((WildcardBinding)typeBinding4).bound;
                        break block0;
                    }
                    case 0: {
                        return false;
                    }
                }
                break;
            }
            case 8196: {
                break;
            }
            case 4100: {
                typeBinding3 = (TypeVariableBinding)this;
                if (typeBinding3.isCapture()) {
                    typeBinding2 = (CaptureBinding)typeBinding3;
                    switch (((CaptureBinding)typeBinding2).wildcard.boundKind) {
                        case 1: {
                            typeBinding5 = ((CaptureBinding)typeBinding2).wildcard.bound;
                            break block0;
                        }
                        case 2: {
                            typeBinding6 = ((CaptureBinding)typeBinding2).wildcard.bound;
                            break block0;
                        }
                        case 0: {
                            return false;
                        }
                    }
                    break;
                }
                if (((TypeVariableBinding)typeBinding3).firstBound == null) {
                    return false;
                }
                typeBinding2 = Scope.convertEliminatingTypeVariables(typeBinding3, referenceBinding, n, null);
                switch (typeBinding2.kind()) {
                    case 516: 
                    case 8196: {
                        typeBinding4 = (WildcardBinding)typeBinding2;
                        switch (((WildcardBinding)typeBinding4).boundKind) {
                            case 1: {
                                typeBinding5 = ((WildcardBinding)typeBinding4).bound;
                                break block0;
                            }
                            case 2: {
                                typeBinding6 = ((WildcardBinding)typeBinding4).bound;
                                break block0;
                            }
                            case 0: {
                                return false;
                            }
                        }
                    }
                }
            }
        }
        typeBinding4 = null;
        typeBinding3 = null;
        block23 : switch (typeBinding.kind()) {
            case 516: {
                typeBinding2 = (WildcardBinding)typeBinding;
                switch (((WildcardBinding)typeBinding2).boundKind) {
                    case 1: {
                        typeBinding4 = ((WildcardBinding)typeBinding2).bound;
                        break block23;
                    }
                    case 2: {
                        typeBinding3 = ((WildcardBinding)typeBinding2).bound;
                        break block23;
                    }
                    case 0: {
                        return false;
                    }
                }
                break;
            }
            case 8196: {
                break;
            }
            case 4100: {
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBinding;
                if (typeVariableBinding.isCapture()) {
                    CaptureBinding captureBinding = (CaptureBinding)typeVariableBinding;
                    switch (captureBinding.wildcard.boundKind) {
                        case 1: {
                            typeBinding4 = captureBinding.wildcard.bound;
                            break block23;
                        }
                        case 2: {
                            typeBinding3 = captureBinding.wildcard.bound;
                            break block23;
                        }
                        case 0: {
                            return false;
                        }
                    }
                    break;
                }
                if (typeVariableBinding.firstBound == null) {
                    return false;
                }
                TypeBinding typeBinding7 = Scope.convertEliminatingTypeVariables(typeVariableBinding, referenceBinding, n, null);
                switch (typeBinding7.kind()) {
                    case 516: 
                    case 8196: {
                        typeBinding2 = (WildcardBinding)typeBinding7;
                        switch (((WildcardBinding)typeBinding2).boundKind) {
                            case 1: {
                                typeBinding4 = ((WildcardBinding)typeBinding2).bound;
                                break block23;
                            }
                            case 2: {
                                typeBinding3 = ((WildcardBinding)typeBinding2).bound;
                                break block23;
                            }
                            case 0: {
                                return false;
                            }
                        }
                    }
                }
            }
        }
        if (typeBinding6 != null) {
            if (typeBinding3 != null) {
                return false;
            }
            if (typeBinding4 != null) {
                if (typeBinding6.isTypeVariable() || typeBinding4.isTypeVariable()) {
                    return false;
                }
                return !typeBinding6.isCompatibleWith(typeBinding4);
            }
            if (typeBinding6.isTypeVariable() || typeBinding.isTypeVariable()) {
                return false;
            }
            return !typeBinding6.isCompatibleWith(typeBinding);
        }
        if (typeBinding5 != null) {
            if (typeBinding3 != null) {
                return !typeBinding3.isCompatibleWith(typeBinding5);
            }
            if (typeBinding4 != null) {
                return typeBinding5.isProvableDistinctSubType(typeBinding4) && typeBinding4.isProvableDistinctSubType(typeBinding5);
            }
            return typeBinding.isProvableDistinctSubType(typeBinding5);
        }
        if (typeBinding3 != null) {
            if (typeBinding3.isTypeVariable() || this.isTypeVariable()) {
                return false;
            }
            return !typeBinding3.isCompatibleWith(this);
        }
        if (typeBinding4 != null) {
            return this.isProvableDistinctSubType(typeBinding4);
        }
        return true;
    }

    public final boolean isRawType() {
        return this.kind() == 1028;
    }

    public boolean isReifiable() {
        TypeBinding typeBinding = this.leafComponentType();
        if (!(typeBinding instanceof ReferenceBinding)) {
            return true;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        do {
            switch (referenceBinding.kind()) {
                case 516: 
                case 2052: 
                case 4100: 
                case 8196: {
                    return false;
                }
                case 260: {
                    if (!referenceBinding.isBoundParameterizedType()) break;
                    return false;
                }
                case 1028: {
                    return true;
                }
            }
            if (referenceBinding.isStatic()) {
                return true;
            }
            if (!referenceBinding.isLocalType()) continue;
            LocalTypeBinding localTypeBinding = (LocalTypeBinding)referenceBinding.erasure();
            MethodBinding methodBinding = localTypeBinding.enclosingMethod;
            if (methodBinding == null || !methodBinding.isStatic()) continue;
            return true;
        } while ((referenceBinding = referenceBinding.enclosingType()) != null);
        return true;
    }

    public boolean isThrowable() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isTypeArgumentContainedBy(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 4100: {
                if (!this.isParameterizedType()) return false;
                if (!typeBinding.isCapture()) {
                    return false;
                }
                CaptureBinding captureBinding = (CaptureBinding)typeBinding;
                WildcardBinding wildcardBinding = captureBinding.wildcard;
                TypeBinding typeBinding2 = null;
                TypeBinding[] typeBindingArray = null;
                switch (wildcardBinding.boundKind) {
                    case 2: {
                        return false;
                    }
                    case 0: {
                        TypeVariableBinding typeVariableBinding = wildcardBinding.genericType.typeVariables()[wildcardBinding.rank];
                        typeBinding2 = typeVariableBinding.upperBound();
                        typeBindingArray = typeVariableBinding.boundsCount() > 1 ? typeVariableBinding.otherUpperBounds() : null;
                        break;
                    }
                    case 1: {
                        typeBinding2 = wildcardBinding.bound;
                        typeBindingArray = wildcardBinding.otherBounds;
                        break;
                    }
                }
                if (typeBinding2.id == 1 && typeBindingArray == null) {
                    return false;
                }
                typeBinding = captureBinding.environment.createWildcard(null, 0, typeBinding2, typeBindingArray, 1);
                return this.isTypeArgumentContainedBy(typeBinding);
            }
            case 516: 
            case 8196: {
                TypeBinding typeBinding3;
                WildcardBinding wildcardBinding;
                TypeBinding typeBinding4 = this;
                TypeBinding typeBinding5 = this;
                switch (this.kind()) {
                    case 516: 
                    case 8196: {
                        wildcardBinding = (WildcardBinding)this;
                        switch (wildcardBinding.boundKind) {
                            case 1: {
                                if (wildcardBinding.otherBounds != null) break;
                                typeBinding5 = wildcardBinding.bound;
                                typeBinding4 = null;
                                break;
                            }
                            case 2: {
                                typeBinding5 = wildcardBinding;
                                typeBinding4 = wildcardBinding.bound;
                                break;
                            }
                            case 0: {
                                typeBinding5 = wildcardBinding;
                                typeBinding4 = null;
                            }
                        }
                        break;
                    }
                    case 4100: {
                        if (!this.isCapture()) break;
                        typeBinding3 = (CaptureBinding)this;
                        if (((CaptureBinding)typeBinding3).lowerBound == null) break;
                        typeBinding4 = ((CaptureBinding)typeBinding3).lowerBound;
                        break;
                    }
                }
                wildcardBinding = (WildcardBinding)typeBinding;
                if (wildcardBinding.otherBounds != null) {
                    return false;
                }
                typeBinding3 = wildcardBinding.bound;
                switch (wildcardBinding.boundKind) {
                    case 1: {
                        if (typeBinding3 == this) {
                            return true;
                        }
                        if (typeBinding5 == null) {
                            return false;
                        }
                        TypeBinding typeBinding6 = typeBinding5.findSuperTypeOriginatingFrom(typeBinding3);
                        if (typeBinding6 == null) return typeBinding5.isCompatibleWith(typeBinding3);
                        if (!(typeBinding6 = typeBinding6.leafComponentType()).isRawType()) return typeBinding5.isCompatibleWith(typeBinding3);
                        if (typeBinding6 != typeBinding3.leafComponentType()) return false;
                        return true;
                    }
                    case 2: {
                        if (typeBinding3 == this) {
                            return true;
                        }
                        if (typeBinding4 == null) {
                            return false;
                        }
                        TypeBinding typeBinding7 = typeBinding3.findSuperTypeOriginatingFrom(typeBinding4);
                        if (typeBinding7 == null) return typeBinding3.isCompatibleWith(typeBinding4);
                        if (!(typeBinding7 = typeBinding7.leafComponentType()).isRawType()) return typeBinding3.isCompatibleWith(typeBinding4);
                        if (typeBinding7 != typeBinding4.leafComponentType()) return false;
                        return true;
                    }
                }
                return true;
            }
            case 260: {
                int n;
                TypeBinding[] typeBindingArray;
                ReferenceBinding referenceBinding;
                if (!this.isParameterizedType()) {
                    return false;
                }
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this;
                ParameterizedTypeBinding parameterizedTypeBinding2 = (ParameterizedTypeBinding)typeBinding;
                if (parameterizedTypeBinding.actualType() != parameterizedTypeBinding2.actualType()) {
                    return false;
                }
                if (!parameterizedTypeBinding.isStatic() && (referenceBinding = this.enclosingType()) != null) {
                    typeBindingArray = parameterizedTypeBinding2.enclosingType();
                    if (typeBindingArray == null) {
                        return false;
                    }
                    if ((typeBindingArray.tagBits & 0x40000000L) == 0L ? referenceBinding != typeBindingArray : !referenceBinding.isEquivalentTo(parameterizedTypeBinding2.enclosingType())) {
                        return false;
                    }
                }
                int n2 = parameterizedTypeBinding.arguments == null ? 0 : parameterizedTypeBinding.arguments.length;
                typeBindingArray = parameterizedTypeBinding2.arguments;
                int n3 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
                if (n != n2) {
                    return false;
                }
                int n4 = 0;
                while (n4 < n2) {
                    TypeBinding typeBinding8 = parameterizedTypeBinding.arguments[n4];
                    TypeBinding typeBinding9 = typeBindingArray[n4];
                    if (typeBinding8 != typeBinding9) {
                        int n5 = typeBinding8.kind();
                        if (typeBinding9.kind() != n5) {
                            return false;
                        }
                        block23 : switch (n5) {
                            case 260: {
                                if (!typeBinding8.isTypeArgumentContainedBy(typeBinding9)) return false;
                                break;
                            }
                            case 516: 
                            case 8196: {
                                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding8;
                                WildcardBinding wildcardBinding2 = (WildcardBinding)typeBinding9;
                                switch (wildcardBinding.boundKind) {
                                    case 1: {
                                        if (wildcardBinding2.boundKind != 0) return false;
                                        if (wildcardBinding.bound != wildcardBinding.typeVariable().upperBound()) return false;
                                        break block23;
                                    }
                                    case 2: {
                                        break;
                                    }
                                    case 0: {
                                        if (wildcardBinding2.boundKind != 1) return false;
                                        if (wildcardBinding2.bound != wildcardBinding2.typeVariable().upperBound()) return false;
                                        break block23;
                                    }
                                }
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    ++n4;
                }
                return true;
            }
        }
        if (typeBinding.id != 1) return false;
        switch (this.kind()) {
            case 516: {
                WildcardBinding wildcardBinding = (WildcardBinding)this;
                if (wildcardBinding.boundKind != 2) return false;
                if (wildcardBinding.bound.id != 1) return false;
                return true;
            }
        }
        return false;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public boolean isUnboundWildcard() {
        return false;
    }

    public boolean isUncheckedException(boolean bl) {
        return false;
    }

    public boolean isWildcard() {
        return false;
    }

    public int kind() {
        return 4;
    }

    public TypeBinding leafComponentType() {
        return this;
    }

    public boolean needsUncheckedConversion(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return false;
        }
        if (!((typeBinding = typeBinding.leafComponentType()) instanceof ReferenceBinding)) {
            return false;
        }
        TypeBinding typeBinding2 = this.leafComponentType();
        TypeBinding typeBinding3 = typeBinding2.findSuperTypeOriginatingFrom(typeBinding);
        if (!(typeBinding3 instanceof ReferenceBinding)) {
            return false;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding3;
        while (referenceBinding.isRawType()) {
            if (typeBinding.isBoundParameterizedType()) {
                return true;
            }
            if (!referenceBinding.isStatic() && (referenceBinding = referenceBinding.enclosingType()) != null && (typeBinding = typeBinding.enclosingType()) != null) continue;
            break;
        }
        return false;
    }

    public TypeBinding original() {
        switch (this.kind()) {
            case 68: 
            case 260: 
            case 1028: {
                return this.erasure();
            }
        }
        return this;
    }

    public char[] qualifiedPackageName() {
        PackageBinding packageBinding = this.getPackage();
        return packageBinding == null || packageBinding.compoundName == CharOperation.NO_CHAR_CHAR ? CharOperation.NO_CHAR : packageBinding.readableName();
    }

    public abstract char[] qualifiedSourceName();

    public char[] signature() {
        return this.constantPoolName();
    }

    public abstract char[] sourceName();

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
    }

    public TypeVariableBinding[] typeVariables() {
        return Binding.NO_TYPE_VARIABLES;
    }
}

