/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser.diagnose;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;
import org.eclipse.jdt.internal.compiler.util.Util;

public class LexStream
implements TerminalTokens {
    public static final int IS_AFTER_JUMP = 1;
    public static final int LBRACE_MISSING = 2;
    private int tokenCacheIndex;
    private int tokenCacheEOFIndex;
    private Token[] tokenCache;
    private int currentIndex = -1;
    private Scanner scanner;
    private int[] intervalStartToSkip;
    private int[] intervalEndToSkip;
    private int[] intervalFlagsToSkip;
    private int previousInterval = -1;
    private int currentInterval = -1;

    public LexStream(int n, Scanner scanner, int[] nArray, int[] nArray2, int[] nArray3, int n2, int n3, int n4) {
        this.tokenCache = new Token[n];
        this.tokenCacheIndex = 0;
        this.tokenCacheEOFIndex = Integer.MAX_VALUE;
        this.tokenCache[0] = new Token();
        this.tokenCache[0].kind = n2;
        this.tokenCache[0].name = CharOperation.NO_CHAR;
        this.tokenCache[0].start = n3;
        this.tokenCache[0].end = n3;
        this.tokenCache[0].line = 0;
        this.intervalStartToSkip = nArray;
        this.intervalEndToSkip = nArray2;
        this.intervalFlagsToSkip = nArray3;
        scanner.resetTo(n3, n4);
        this.scanner = scanner;
    }

    private void readTokenFromScanner() {
        int n = this.tokenCache.length;
        boolean bl = true;
        while (bl) {
            try {
                int n2;
                int n3;
                int n4 = this.scanner.getNextToken();
                if (n4 != 69) {
                    n3 = this.scanner.getCurrentTokenStartPosition();
                    n2 = this.scanner.getCurrentTokenEndPosition();
                    int n5 = this.currentInterval + 1;
                    if (this.intervalStartToSkip.length == 0 || n5 >= this.intervalStartToSkip.length || n3 < this.intervalStartToSkip[n5]) {
                        Token token = new Token();
                        token.kind = n4;
                        token.name = this.scanner.getCurrentTokenSource();
                        token.start = n3;
                        token.end = n2;
                        token.line = Util.getLineNumber(n2, this.scanner.lineEnds, 0, this.scanner.linePtr);
                        if (this.currentInterval != this.previousInterval && (this.intervalFlagsToSkip[this.currentInterval] & 2) == 0) {
                            token.flags = 1;
                            if ((this.intervalFlagsToSkip[this.currentInterval] & 1) != 0) {
                                token.flags |= 2;
                            }
                        }
                        this.previousInterval = this.currentInterval;
                        this.tokenCache[++this.tokenCacheIndex % n] = token;
                        bl = false;
                        continue;
                    }
                    this.scanner.resetTo(this.intervalEndToSkip[++this.currentInterval] + 1, this.scanner.eofPosition - 1);
                    continue;
                }
                n3 = this.scanner.getCurrentTokenStartPosition();
                n2 = this.scanner.getCurrentTokenEndPosition();
                Token token = new Token();
                token.kind = n4;
                token.name = CharOperation.NO_CHAR;
                token.start = n3;
                token.end = n2;
                token.line = Util.getLineNumber(n2, this.scanner.lineEnds, 0, this.scanner.linePtr);
                this.tokenCache[++this.tokenCacheIndex % n] = token;
                this.tokenCacheEOFIndex = this.tokenCacheIndex;
                bl = false;
            }
            catch (InvalidInputException invalidInputException) {}
        }
    }

    public Token token(int n) {
        if (n < 0) {
            Token token = new Token();
            token.kind = 69;
            token.name = CharOperation.NO_CHAR;
            return token;
        }
        if (this.tokenCacheEOFIndex >= 0 && n > this.tokenCacheEOFIndex) {
            return this.token(this.tokenCacheEOFIndex);
        }
        int n2 = this.tokenCache.length;
        if (n > this.tokenCacheIndex) {
            int n3 = n - this.tokenCacheIndex;
            while (n3-- != 0) {
                this.readTokenFromScanner();
            }
        } else if (this.tokenCacheIndex - n2 >= n) {
            return null;
        }
        return this.tokenCache[n % n2];
    }

    public int getToken() {
        this.currentIndex = this.next(this.currentIndex);
        return this.currentIndex;
    }

    public int previous(int n) {
        return n > 0 ? n - 1 : 0;
    }

    public int next(int n) {
        return n < this.tokenCacheEOFIndex ? n + 1 : this.tokenCacheEOFIndex;
    }

    public boolean afterEol(int n) {
        return n < 1 ? true : this.line(n - 1) < this.line(n);
    }

    public void reset() {
        this.currentIndex = -1;
    }

    public void reset(int n) {
        this.currentIndex = this.previous(n);
    }

    public int badtoken() {
        return 0;
    }

    public int kind(int n) {
        return this.token((int)n).kind;
    }

    public char[] name(int n) {
        return this.token((int)n).name;
    }

    public int line(int n) {
        return this.token((int)n).line;
    }

    public int start(int n) {
        return this.token((int)n).start;
    }

    public int end(int n) {
        return this.token((int)n).end;
    }

    public int flags(int n) {
        return this.token((int)n).flags;
    }

    public boolean isInsideStream(int n) {
        if (this.tokenCacheEOFIndex >= 0 && n > this.tokenCacheEOFIndex) {
            return false;
        }
        if (n > this.tokenCacheIndex) {
            return true;
        }
        return this.tokenCacheIndex - this.tokenCache.length < n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = new String(this.scanner.source);
        if (this.currentIndex < 0) {
            int n = -1;
            for (int i = 0; i < this.intervalStartToSkip.length; ++i) {
                int n2 = this.intervalStartToSkip[i];
                int n3 = this.intervalEndToSkip[i];
                stringBuffer.append(string.substring(n + 1, n2));
                stringBuffer.append('<');
                stringBuffer.append('@');
                stringBuffer.append(string.substring(n2, n3 + 1));
                stringBuffer.append('@');
                stringBuffer.append('>');
                n = n3;
            }
            stringBuffer.append(string.substring(n + 1));
        } else {
            Token token = this.token(this.currentIndex);
            int n = token.kind;
            int n4 = token.start;
            int n5 = token.end;
            int n6 = -1;
            for (int i = 0; i < this.intervalStartToSkip.length; ++i) {
                int n7 = this.intervalStartToSkip[i];
                int n8 = this.intervalEndToSkip[i];
                if (n4 >= n6 && n5 <= n7) {
                    stringBuffer.append(string.substring(n6 + 1, n4));
                    stringBuffer.append('<');
                    stringBuffer.append('#');
                    stringBuffer.append(string.substring(n4, n5 + 1));
                    stringBuffer.append('#');
                    stringBuffer.append('>');
                    stringBuffer.append(string.substring(n5 + 1, n7));
                } else {
                    stringBuffer.append(string.substring(n6 + 1, n7));
                }
                stringBuffer.append('<');
                stringBuffer.append('@');
                stringBuffer.append(string.substring(n7, n8 + 1));
                stringBuffer.append('@');
                stringBuffer.append('>');
                n6 = n8;
            }
            if (n4 >= n6) {
                stringBuffer.append(string.substring(n6 + 1, n4));
                stringBuffer.append('<');
                stringBuffer.append('#');
                if (n == 69) {
                    stringBuffer.append("EOF#>");
                } else {
                    stringBuffer.append(string.substring(n4, n5 + 1));
                    stringBuffer.append('#');
                    stringBuffer.append('>');
                    stringBuffer.append(string.substring(n5 + 1));
                }
            } else {
                stringBuffer.append(string.substring(n6 + 1));
            }
        }
        return stringBuffer.toString();
    }

    public static class Token {
        int kind;
        char[] name;
        int start;
        int end;
        int line;
        int flags;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name).append('[').append(this.kind).append(']');
            stringBuffer.append('{').append(this.start).append(',').append(this.end).append('}').append(this.line);
            return stringBuffer.toString();
        }
    }
}

