/*
 * This file implements the notifications of the
 * COVALENT-APACHE-LOGGING-MIB module.
 * $Id: apache-logging-mib-notifications.c 8676 2008-01-17 23:11:17Z ispringer $
 */

/* General Includes */
#include <sys/types.h>

/* Apache includes */
#include <httpd.h>
#include <apr_time.h>

/* UCD-SNMP includes */
#include <ucd-snmp-config.h>
#include <asn1.h>
#include <snmp_api.h>
#include <snmp_impl.h>
#include <snmp_client.h>
#include <snmp_debug.h>
#include <snmp_vars.h>
#include <var_struct.h>
#include <agent_trap.h>

/* module includes */
#include "covalent-snmp-config.h"
#include "snmpcommon/snmpcommon.h"
#include "snmpcommon/snmpv2-tc.h"
#include "apache-logging-mib.h"

#ifdef COVALENT_APACHE_LOGGING_MIB
/* Oid definition of the Notification */
static oid notification_oid[] = { 1, 3, 6, 1, 4, 1, 6100, 10, 2, 0 };
/* Oid definition of the Notification Objects */
static oid lastN_log_level_oid[] = { 1, 3, 6, 1, 4, 1, 6100, 10, 1, 0, 1, 2, 0, 0 };
static int lastN_log_level_length = 0;
static oid lastN_log_time_oid[] = { 1, 3, 6, 1, 4, 1, 6100, 10, 1, 0, 1, 4, 0, 0 };
static int lastN_log_time_length = 0;
static oid lastN_log_msg_oid[] = { 1, 3, 6, 1, 4, 1, 6100, 10, 1, 0, 1, 5, 0, 0 };
static int lastN_log_msg_length = 0;

int set_oids_for_notification(int type, int applindex, int wwwserviceindex);
int set_oids_for_notification(int type, int applindex, int wwwserviceindex)
{
    DEBUGTRACE;
    switch (type) {
        case APPLICATION:
            notification_oid[9] = 1;
            lastN_log_level_oid[9] = 3;
            lastN_log_level_oid[12] = applindex;
            lastN_log_level_length = 13;
            lastN_log_time_oid[9] = 3;
            lastN_log_time_oid[12] = applindex;
            lastN_log_time_length = 13;
            lastN_log_msg_oid[9] = 3;
            lastN_log_msg_oid[12] = applindex;
            lastN_log_msg_length = 13;
            return(0);
        case WWW_SERVICE:
            notification_oid[9] = 2;
            lastN_log_level_oid[9] = 6;
            lastN_log_level_oid[12] = applindex;
            lastN_log_level_oid[13] = wwwserviceindex;
            lastN_log_level_length = 14;
            lastN_log_time_oid[9] = 6;
            lastN_log_time_oid[12] = applindex;
            lastN_log_time_oid[13] = wwwserviceindex;
            lastN_log_time_length = 14;
            lastN_log_msg_oid[9] = 6;
            lastN_log_msg_oid[12] = applindex;
            lastN_log_msg_oid[13] = wwwserviceindex;
            lastN_log_msg_length = 14;
            return(0);
    }
    return(1);
}
void
generate_notification(int type,
                        long www_service, long log_level,
                        apr_time_t log_time, char *log_message)
{
struct variable_list lastN_log_level_var;
struct variable_list lastN_log_time_var;
struct variable_list lastN_log_msg_var;

    DEBUGTRACE;
    if (set_oids_for_notification(type, get_appl_index(), www_service)) {
        return; /* If for some reason it has the wrong type. */
    }

    memset(&lastN_log_level_var, 0, sizeof(lastN_log_level_var));
    snmp_set_var_objid(&lastN_log_level_var, 0,
				0);
    snmp_set_var_value(&lastN_log_level_var, 0,
				0);
    lastN_log_level_var.type = ASN_INTEGER;
    lastN_log_level_var.next_variable = &lastN_log_time_var;

    memset(&lastN_log_time_var, 0, sizeof(lastN_log_time_var));
    snmp_set_var_objid(&lastN_log_time_var, 0,
				0);
    snmp_set_var_value(&lastN_log_time_var, 0,
				0);
    lastN_log_time_var.type = ASN_OCTET_STR;
    lastN_log_time_var.next_variable = &lastN_log_msg_var;

    memset(&lastN_log_msg_var, 0, sizeof(lastN_log_msg_var));
    snmp_set_var_objid(&lastN_log_msg_var, 0,
				0);
    snmp_set_var_value(&lastN_log_msg_var, 0,
				0);
    lastN_log_msg_var.type = ASN_OCTET_STR;
    lastN_log_msg_var.next_variable = NULL;

    send_enterprise_trap_vars(6, type, notification_oid,
				sizeof(notification_oid)/sizeof(oid),
							&lastN_log_level_var);
    return;
}

#endif /* COVALENT_APACHE_LOGGING_MIB */
