/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolymorphicMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class MessageSend
extends Expression
implements InvocationSite {
    public Expression receiver;
    public char[] selector;
    public Expression[] arguments;
    public MethodBinding binding;
    public MethodBinding syntheticAccessor;
    public TypeBinding expectedType;
    public long nameSourcePosition;
    public TypeBinding actualReceiverType;
    public TypeBinding valueCast;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean bl = !this.binding.isStatic();
        flowInfo = this.receiver.analyseCode(blockScope, flowContext, flowInfo, bl).unconditionalInits();
        if (bl) {
            this.receiver.checkNPE(blockScope, flowContext, flowInfo);
            if (this.receiver.isThis()) {
                blockScope.resetEnclosingMethodStaticFlag();
            }
        } else if (this.receiver.isThis() && (this.receiver.bits & 4) == 0) {
            blockScope.resetEnclosingMethodStaticFlag();
        }
        if (this.arguments != null) {
            int n = this.arguments.length;
            for (int i = 0; i < n; ++i) {
                if ((this.arguments[i].implicitConversion & 0x400) != 0) {
                    this.arguments[i].checkNPE(blockScope, flowContext, flowInfo);
                }
                flowInfo = this.arguments[i].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            }
        }
        TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                typeBindingArray = blockScope.environment().convertToRawTypes(this.binding.thrownExceptions, true, true);
            }
            flowContext.checkExceptionHandlers(typeBindingArray, (ASTNode)this, flowInfo.copy(), blockScope);
        }
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        return flowInfo;
    }

    public void computeConversion(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == null || typeBinding2 == null) {
            return;
        }
        if (this.binding != null && this.binding.isValidBinding()) {
            TypeBinding typeBinding3;
            MethodBinding methodBinding = this.binding.original();
            TypeBinding typeBinding4 = methodBinding.returnType;
            if (typeBinding4.leafComponentType().isTypeVariable()) {
                typeBinding3 = !typeBinding2.isBaseType() && typeBinding.isBaseType() ? typeBinding2 : typeBinding;
                this.valueCast = typeBinding4.genericCast(typeBinding3);
            } else if (this.binding == scope.environment().arrayClone && typeBinding.id != 1 && scope.compilerOptions().sourceLevel >= 0x310000L) {
                this.valueCast = typeBinding;
            }
            if (this.valueCast instanceof ReferenceBinding && !((ReferenceBinding)(typeBinding3 = (ReferenceBinding)this.valueCast)).canBeSeenBy(scope)) {
                scope.problemReporter().invalidType(this, new ProblemReferenceBinding(CharOperation.splitOn('.', ((ReferenceBinding)typeBinding3).shortReadableName()), (ReferenceBinding)typeBinding3, 2));
            }
        }
        super.computeConversion(scope, typeBinding, typeBinding2);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        TypeBinding typeBinding;
        int n = codeStream.position;
        MethodBinding methodBinding = this.binding instanceof PolymorphicMethodBinding ? this.binding : this.binding.original();
        boolean bl2 = methodBinding.isStatic();
        if (bl2) {
            this.receiver.generateCode(blockScope, codeStream, false);
        } else if ((this.bits & 0x1FE0) != 0 && this.receiver.isImplicitThis()) {
            typeBinding = blockScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
            Object[] objectArray = blockScope.getEmulationPath((ReferenceBinding)typeBinding, true, false);
            codeStream.generateOuterAccess(objectArray, this, typeBinding, blockScope);
        } else {
            this.receiver.generateCode(blockScope, codeStream, true);
            if ((this.bits & 0x40000) != 0) {
                codeStream.checkcast(this.actualReceiverType);
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
        this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
        n = codeStream.position;
        if (this.syntheticAccessor == null) {
            typeBinding = CodeStream.getConstantPoolDeclaringClass((Scope)blockScope, methodBinding, this.actualReceiverType, this.receiver.isImplicitThis());
            if (bl2) {
                codeStream.invoke((byte)-72, methodBinding, typeBinding);
            } else if (this.receiver.isSuper() || methodBinding.isPrivate()) {
                codeStream.invoke((byte)-73, methodBinding, typeBinding);
            } else if (typeBinding.isInterface()) {
                codeStream.invoke((byte)-71, methodBinding, typeBinding);
            } else {
                codeStream.invoke((byte)-74, methodBinding, typeBinding);
            }
        } else {
            codeStream.invoke((byte)-72, this.syntheticAccessor, null);
        }
        if (this.valueCast != null) {
            codeStream.checkcast(this.valueCast);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            boolean bl3;
            boolean bl4 = bl3 = (this.implicitConversion & 0x400) != 0;
            if (bl3) {
                codeStream.generateImplicitConversion(this.implicitConversion);
            }
            switch (bl3 ? this.postConversionType((Scope)blockScope).id : methodBinding.returnType.id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(n, (int)(this.nameSourcePosition >>> 32));
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        MethodBinding methodBinding = this.binding.original();
        if (this.binding.isPrivate()) {
            if (blockScope.enclosingSourceType() != methodBinding.declaringClass) {
                this.syntheticAccessor = ((SourceTypeBinding)methodBinding.declaringClass).addSyntheticMethod(methodBinding, false);
                blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                return;
            }
        } else {
            if (this.receiver instanceof QualifiedSuperReference) {
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)((QualifiedSuperReference)this.receiver).currentCompatibleType;
                this.syntheticAccessor = sourceTypeBinding.addSyntheticMethod(methodBinding, this.isSuperAccess());
                blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                return;
            }
            if (this.binding.isProtected() && (this.bits & 0x1FE0) != 0) {
                SourceTypeBinding sourceTypeBinding = blockScope.enclosingSourceType();
                if (methodBinding.declaringClass.getPackage() != sourceTypeBinding.getPackage()) {
                    SourceTypeBinding sourceTypeBinding2 = (SourceTypeBinding)sourceTypeBinding.enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    this.syntheticAccessor = sourceTypeBinding2.addSyntheticMethod(methodBinding, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                    return;
                }
            }
        }
    }

    public int nullStatus(FlowInfo flowInfo) {
        return 1;
    }

    public TypeBinding postConversionType(Scope scope) {
        TypeBinding typeBinding = this.resolvedType;
        if (this.valueCast != null) {
            typeBinding = this.valueCast;
        }
        int n = (this.implicitConversion & 0xFF) >> 4;
        switch (n) {
            case 5: {
                typeBinding = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                typeBinding = TypeBinding.BYTE;
                break;
            }
            case 4: {
                typeBinding = TypeBinding.SHORT;
                break;
            }
            case 2: {
                typeBinding = TypeBinding.CHAR;
                break;
            }
            case 10: {
                typeBinding = TypeBinding.INT;
                break;
            }
            case 9: {
                typeBinding = TypeBinding.FLOAT;
                break;
            }
            case 7: {
                typeBinding = TypeBinding.LONG;
                break;
            }
            case 8: {
                typeBinding = TypeBinding.DOUBLE;
                break;
            }
        }
        if ((this.implicitConversion & 0x200) != 0) {
            typeBinding = scope.environment().computeBoxingType(typeBinding);
        }
        return typeBinding;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        if (!this.receiver.isImplicitThis()) {
            this.receiver.printExpression(0, stringBuffer).append('.');
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n2 = this.typeArguments.length - 1;
            for (int i = 0; i < n2; ++i) {
                this.typeArguments[i].print(0, stringBuffer);
                stringBuffer.append(", ");
            }
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        stringBuffer.append(this.selector).append('(');
        if (this.arguments != null) {
            for (n2 = 0; n2 < this.arguments.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].printExpression(0, stringBuffer);
            }
        }
        return stringBuffer.append(')');
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        ReferenceContext referenceContext;
        Object object;
        int n;
        boolean bl;
        boolean bl2;
        this.constant = Constant.NotAConstant;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.receiver instanceof CastExpression) {
            this.receiver.bits |= 0x20;
            bl3 = true;
        }
        this.actualReceiverType = this.receiver.resolveType(blockScope);
        boolean bl5 = bl2 = this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0;
        if (bl3 && this.actualReceiverType != null && ((CastExpression)this.receiver).expression.resolvedType == this.actualReceiverType) {
            blockScope.problemReporter().unnecessaryCast((CastExpression)this.receiver);
        }
        if (this.typeArguments != null) {
            int n2 = this.typeArguments.length;
            bl = blockScope.compilerOptions().sourceLevel < 0x310000L;
            this.genericTypeArguments = new TypeBinding[n2];
            for (n = 0; n < n2; ++n) {
                TypeReference typeReference = this.typeArguments[n];
                this.genericTypeArguments[n] = typeReference.resolveType(blockScope, true);
                if (this.genericTypeArguments[n] == null) {
                    bl = true;
                }
                if (!bl || !(typeReference instanceof Wildcard)) continue;
                blockScope.problemReporter().illegalUsageOfWildcard(typeReference);
            }
            if (bl) {
                if (this.arguments != null) {
                    int n3 = this.arguments.length;
                    for (n = 0; n < n3; ++n) {
                        this.arguments[n].resolveType(blockScope);
                    }
                }
                return null;
            }
        }
        TypeBinding[] typeBindingArray = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            bl = false;
            n = this.arguments.length;
            typeBindingArray = new TypeBinding[n];
            for (int i = 0; i < n; ++i) {
                object = this.arguments[i];
                if (object instanceof CastExpression) {
                    ((Expression)object).bits |= 0x20;
                    bl4 = true;
                }
                if ((typeBindingArray[i] = ((Expression)object).resolveType(blockScope)) != null) continue;
                bl = true;
            }
            if (bl) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    MethodBinding methodBinding;
                    TypeBinding[] typeBindingArray2 = new TypeBinding[n];
                    int n4 = n;
                    while (--n4 >= 0) {
                        typeBindingArray2[n4] = typeBindingArray[n4] == null ? TypeBinding.NULL : typeBindingArray[n4];
                    }
                    MethodBinding methodBinding2 = this.binding = this.receiver.isImplicitThis() ? blockScope.getImplicitMethod(this.selector, typeBindingArray2, this) : blockScope.findMethod((ReferenceBinding)this.actualReceiverType, this.selector, typeBindingArray2, this);
                    if (this.binding != null && !this.binding.isValidBinding() && (methodBinding = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                        if (methodBinding.original().typeVariables != Binding.NO_TYPE_VARIABLES) {
                            methodBinding = blockScope.environment().createParameterizedGenericMethod(methodBinding.original(), (RawTypeBinding)null);
                        }
                        this.binding = methodBinding;
                        MethodBinding methodBinding3 = methodBinding.original();
                        if (methodBinding3.isOrEnclosedByPrivateType() && !blockScope.isDefinedInMethod(methodBinding3)) {
                            methodBinding3.modifiers |= 0x8000000;
                        }
                    }
                }
                return null;
            }
        }
        if (this.actualReceiverType == null) {
            return null;
        }
        if (this.actualReceiverType.isBaseType()) {
            blockScope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, typeBindingArray);
            return null;
        }
        MethodBinding methodBinding = this.binding = this.receiver.isImplicitThis() ? blockScope.getImplicitMethod(this.selector, typeBindingArray, this) : blockScope.getMethod(this.actualReceiverType, this.selector, typeBindingArray, this);
        if (!this.binding.isValidBinding()) {
            ReferenceBinding referenceBinding;
            if (this.binding.declaringClass == null) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    this.binding.declaringClass = (ReferenceBinding)this.actualReceiverType;
                } else {
                    blockScope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, typeBindingArray);
                    return null;
                }
            }
            int n5 = n = (referenceBinding = this.binding.declaringClass) != null && referenceBinding.isAnonymousType() && referenceBinding.superclass() instanceof MissingTypeBinding ? 1 : 0;
            if (n == 0) {
                blockScope.problemReporter().invalidMethod(this, this.binding);
            }
            MethodBinding methodBinding4 = ((ProblemMethodBinding)this.binding).closestMatch;
            switch (this.binding.problemId()) {
                case 3: {
                    break;
                }
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    if (methodBinding4 == null) break;
                    this.resolvedType = methodBinding4.returnType;
                }
            }
            if (methodBinding4 != null) {
                this.binding = methodBinding4;
                object = methodBinding4.original();
                if (((MethodBinding)object).isOrEnclosedByPrivateType() && !blockScope.isDefinedInMethod((MethodBinding)object)) {
                    ((MethodBinding)object).modifiers |= 0x8000000;
                }
            }
            return this.resolvedType != null && (this.resolvedType.tagBits & 0x80L) == 0L ? this.resolvedType : null;
        }
        CompilerOptions compilerOptions = blockScope.compilerOptions();
        if (compilerOptions.complianceLevel <= 0x320000L && this.binding.isPolymorphic()) {
            blockScope.problemReporter().polymorphicMethodNotBelow17(this);
            return null;
        }
        if ((this.bits & 0x10) != 0 && this.binding.isPolymorphic()) {
            this.binding = blockScope.environment().updatePolymorphicMethodReturnType((PolymorphicMethodBinding)this.binding, TypeBinding.VOID);
        }
        if ((this.binding.tagBits & 0x80L) != 0L) {
            blockScope.problemReporter().missingTypeInMethod(this, this.binding);
        }
        if (!this.binding.isStatic()) {
            if (bl2) {
                blockScope.problemReporter().mustUseAStaticMethod(this, this.binding);
                if (this.actualReceiverType.isRawType() && (this.receiver.bits & 0x40000000) == 0 && compilerOptions.getSeverity(0x20010000) != 256) {
                    blockScope.problemReporter().rawTypeReference(this.receiver, this.actualReceiverType);
                }
            } else {
                TypeBinding typeBinding = this.actualReceiverType;
                this.actualReceiverType = this.actualReceiverType.getErasureCompatibleType(this.binding.declaringClass);
                this.receiver.computeConversion(blockScope, this.actualReceiverType, this.actualReceiverType);
                if (this.actualReceiverType != typeBinding && this.receiver.postConversionType(blockScope) != this.actualReceiverType) {
                    this.bits |= 0x40000;
                }
            }
        } else {
            if (!(this.receiver.isImplicitThis() || this.receiver.isSuper() || bl2)) {
                blockScope.problemReporter().nonStaticAccessToStaticMethod(this, this.binding);
            }
            if (!this.receiver.isImplicitThis() && this.binding.declaringClass != this.actualReceiverType) {
                blockScope.problemReporter().indirectAccessToStaticMethod(this, this.binding);
            }
        }
        if (MessageSend.checkInvocationArguments(blockScope, this.receiver, this.actualReceiverType, this.binding, this.arguments, typeBindingArray, bl4, this)) {
            this.bits |= 0x10000;
        }
        if (this.binding.isAbstract() && this.receiver.isSuper()) {
            blockScope.problemReporter().cannotDireclyInvokeAbstractMethod(this, this.binding);
        }
        if (this.isMethodUseDeprecated(this.binding, blockScope, true)) {
            blockScope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (this.binding == blockScope.environment().arrayClone && compilerOptions.sourceLevel >= 0x310000L) {
            this.resolvedType = this.actualReceiverType;
        } else {
            TypeBinding typeBinding;
            if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                typeBinding = this.binding.returnType;
                if (typeBinding != null) {
                    typeBinding = blockScope.environment().convertToRawType(typeBinding.erasure(), true);
                }
            } else {
                typeBinding = this.binding.returnType;
                if (typeBinding != null) {
                    typeBinding = typeBinding.capture(blockScope, this.sourceEnd);
                }
            }
            this.resolvedType = typeBinding;
        }
        if (this.receiver.isSuper() && compilerOptions.getSeverity(0x20100000) != 256 && (referenceContext = blockScope.methodScope().referenceContext) instanceof AbstractMethodDeclaration) {
            AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)referenceContext;
            object = abstractMethodDeclaration.binding;
            if (((MethodBinding)object).isOverriding() && CharOperation.equals(this.binding.selector, ((MethodBinding)object).selector) && this.binding.areParametersEqual((MethodBinding)object)) {
                abstractMethodDeclaration.bits |= 0x10;
            }
        }
        if (this.typeArguments != null && this.binding.original().typeVariables == Binding.NO_TYPE_VARIABLES) {
            blockScope.problemReporter().unnecessaryTypeArgumentsForMethodInvocation(this.binding, this.genericTypeArguments, this.typeArguments);
        }
        return (this.resolvedType.tagBits & 0x80L) == 0L ? this.resolvedType : null;
    }

    public void setActualReceiverType(ReferenceBinding referenceBinding) {
        if (referenceBinding == null) {
            return;
        }
        this.actualReceiverType = referenceBinding;
    }

    public void setDepth(int n) {
        this.bits &= 0xFFFFE01F;
        if (n > 0) {
            this.bits |= (n & 0xFF) << 5;
        }
    }

    public void setExpectedType(TypeBinding typeBinding) {
        this.expectedType = typeBinding;
    }

    public void setFieldIndex(int n) {
    }

    public TypeBinding expectedType() {
        return this.expectedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            this.receiver.traverse(aSTVisitor, blockScope);
            if (this.typeArguments != null) {
                n2 = this.typeArguments.length;
                for (n = 0; n < n2; ++n) {
                    this.typeArguments[n].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.arguments != null) {
                n = this.arguments.length;
                for (n2 = 0; n2 < n; ++n2) {
                    this.arguments[n2].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

